using Microsoft.EntityFrameworkCore;
using Newtonsoft.Json.Serialization;
using OdataApplication.Models;
using Syncfusion.Licensing;
using WebApplication4;
using WebApplication4.Data;

var builder = WebApplication.CreateBuilder(args);
// Add services to the container.

builder.Services.AddControllers();
// Add services to the container.
builder.Services.AddRazorPages();

builder.Services.AddCors(options =>
{
    options.AddPolicy("AllowAllOrigins", builder =>
    {
        builder.SetIsOriginAllowed(origin => true)
                .AllowAnyMethod()
                .AllowAnyHeader()
                .AllowCredentials();
    });
});

//builder.Services.AddDbContext<DemoDbContext>(options =>
//    options.UseSqlServer(builder.Configuration.GetConnectionString("demoDbContext")));
//builder.Services.AddDbContext<DSupportIncidents597103CoreAggregateQueryableOdataapplicationModelsNorthwndMdfContext>(options =>
//    options.UseSqlServer(builder.Configuration.GetConnectionString("DSupportIncidents597103CoreAggregateQueryableOdataapplicationModelsNorthwndMdfContext")));
builder.Services.AddDbContext<NorthwndMdfContext>(options =>
    options.UseSqlServer(@"Data Source=(LocalDB)\MSSQLLocalDB;AttachDbFilename=" + Directory.GetCurrentDirectory() + @"\Models\NORTHWND.MDF;Integrated Security=True")
    );

builder.Services.AddDatabaseDeveloperPageExceptionFilter();
// Add services to the container.
builder.Services.AddControllersWithViews().AddJsonOptions(options =>
{
    options.JsonSerializerOptions.ReferenceHandler = System.Text.Json.Serialization.ReferenceHandler.IgnoreCycles;
});
builder.Services.AddControllersWithViews().AddNewtonsoftJson(options =>
{
    options.SerializerSettings.ReferenceLoopHandling = Newtonsoft.Json.ReferenceLoopHandling.Ignore;
});
builder.Services.AddMvc().AddNewtonsoftJson(options =>
{
    options.SerializerSettings.ContractResolver = new DefaultContractResolver();
});
builder.Services.AddAntiforgery(o => o.HeaderName = "XSRF-TOKEN");
builder.Services.AddAutoMapper(c => c.AddProfile(typeof(MappingProfile)));

var app = builder.Build();

// Configure the HTTP request pipeline.
if (!app.Environment.IsDevelopment())
{
    app.UseExceptionHandler("/Error");
}
else
{
    app.UseDeveloperExceptionPage();
    app.UseMigrationsEndPoint();
}

app.UseStaticFiles();
app.UseCors("AllowAllOrigins");
app.UseRouting();

app.UseAuthorization();

app.MapRazorPages();
app.MapControllers();
//app.MapControllerRoute(
//    name: "default",
//pattern: "{controller=WorkOrder}/{action=Index}/{id?}");

app.Run();
