﻿using Syncfusion.DocIO.DLS;
using Syncfusion.DocIORenderer;
using Syncfusion.Pdf;

namespace TestProject
{
    public partial class MainPage
    {

        public MainPage()
        {
            InitializeComponent();
        }

        private async void OnCounterClicked(object sender, EventArgs e)
        {
            if (!OperatingSystem.IsAndroidVersionAtLeast(32))
            {
                if (await Permissions.CheckStatusAsync<Permissions.StorageRead>() is not PermissionStatus.Granted)
                    await
                        Permissions.RequestAsync<Permissions.StorageRead>();
            }

            var fileResult = await FilePicker.PickAsync(new PickOptions()
            {
                FileTypes =  new FilePickerFileType(new Dictionary<DevicePlatform, IEnumerable<string>>
                {
                        { DevicePlatform.Android, ["application/msword", "application/vnd.openxmlformats-officedocument.wordprocessingml.document"] },
                })
            });

            using (WordDocument document = new WordDocument(await fileResult?.OpenReadAsync(), Syncfusion.DocIO.FormatType.Automatic))
            {
                //Instantiation of DocIORenderer for Word to PDF conversion
                using (DocIORenderer render = new DocIORenderer())
                {
                    //Converts Word document into PDF document
                    using (PdfDocument pdfDocument = render.ConvertToPDF(document))
                    {
                        //Saves the PDF document to MemoryStream.
                        MemoryStream stream = new MemoryStream();
                        pdfDocument.Save(stream);
                    }
                }
            }


        }
    }

}
