﻿using HeaderTestApp.Classes;
using Syncfusion.Windows.Tools.Controls;
using System.Globalization;
using System;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.IO;
using Syncfusion.Windows.Shared;
using System.Runtime.Serialization.Formatters.Binary;

namespace HeaderTestApp
{
   public partial class MainWindow : Window
   {
      private const string StorePath = @"C:\Temp\DockingManager";
      private const string FileName = "SyncFusionDockingManager.xml";
      private readonly string _pathAndFileName;

      public MainWindow()
      {
         InitializeComponent();
         
         BtnAddChildren.IsEnabled = true;
         BtnSaveDockState.IsEnabled = false;
         BtnRemoveChildren.IsEnabled = false;
         BtnLoadDockState.IsEnabled = false;

         if (!Directory.Exists(StorePath))
         {
            Directory.CreateDirectory(StorePath);
         }

         var now = DateTime.Now;
         var prefixedFileName = $"{now.Year}.{now.Month:D2}.{now.Day:D2}__{now.Hour:D2}_{now.Minute:D2}_{now.Second:D2}__{FileName}";
         _pathAndFileName = Path.Combine(StorePath, prefixedFileName);
      }

      private void BtnAddChildren_OnClick(object sender, RoutedEventArgs e)
      {
         BtnAddChildren.IsEnabled = false;

         var contentA = new ContentControl { Name = "ContentA", Content = "I am 'contentA'." };
         MyDockingManager.Children.Add(contentA);
         DockingManager.SetHeader(contentA, new Header { DocumentTitle = "ContentA Header", DocumentIsModified = true });
         DockingManager.SetState(contentA, DockState.Document);

         var contentB = new ContentControl { Name = "ContentB", Content = "I am 'contentB'." };
         MyDockingManager.Children.Add(contentB);
         DockingManager.SetHeader(contentB, new Header { DocumentTitle = "ContentB Header", DocumentIsModified = true });
         DockingManager.SetState(contentB, DockState.Dock);

         var contentC = new ContentControl { Name = "ContentC", Content = "I am 'contentC'." };
         MyDockingManager.Children.Add(contentC);
         DockingManager.SetHeader(contentC, new Header { DocumentTitle = "ContentC Header", DocumentIsModified = true });
         DockingManager.SetState(contentC, DockState.AutoHidden);

         var contentD = new ContentControl { Name = "ContentD", Content = "I am 'contentD'." };
         MyDockingManager.Children.Add(contentD);
         DockingManager.SetHeader(contentD, new Header { DocumentTitle = "ContentD Header", DocumentIsModified = true });
         DockingManager.SetState(contentD, DockState.Float);

         BtnSaveDockState.IsEnabled = true;
      }

      private void BtnSaveDockState_OnClick(object sender, RoutedEventArgs e)
      {
         BtnSaveDockState.IsEnabled = false;

         var binaryFormatter = new BinaryFormatter();
         MyDockingManager?.SaveDockState(binaryFormatter, StorageFormat.Xml, _pathAndFileName);

         BtnRemoveChildren.IsEnabled = true;
      }

      private void BtnRemoveChildren_OnClick(object sender, RoutedEventArgs e)
      {
         BtnRemoveChildren.IsEnabled = false;

         MyDockingManager.Children.Clear();

         BtnLoadDockState.IsEnabled = true;
      }

      private void BtnLoadDockState_OnClick(object sender, RoutedEventArgs e)
      {
         BtnLoadDockState.IsEnabled = false;

         var binaryFormatter = new BinaryFormatter();
         var success = MyDockingManager?.LoadDockState(binaryFormatter, StorageFormat.Xml, _pathAndFileName);
         if (success.HasValue && !success.Value)
         {
            MessageBox.Show("'LoadDockState(...) returned 'false'!",
               "Header Test App", MessageBoxButton.OK, MessageBoxImage.Error);
         }
         else
         {
            MessageBox.Show("Seems to work fine.", "Header Test App", MessageBoxButton.OK, MessageBoxImage.Information);
         }

         BtnAddChildren.IsEnabled = true;
      }
   }

   public class BoolVisibilityConverter : IValueConverter
   {
      public object Convert(object value, Type targetType, object parameter, CultureInfo culture)
      {
         if (value is bool boolValue)
         {
            return boolValue ? Visibility.Visible : Visibility.Collapsed;
         }
         return Visibility.Collapsed;
      }

      public object ConvertBack(object value, Type targetType, object parameter, CultureInfo culture)
      {
         if (value is Visibility visibility)
         {
            return visibility == Visibility.Visible;
         }
         return false;
      }
   }
}
