

using BlazorServerProject.Pages;
using FluentValidation;

namespace BlazorServerProject.Validators // Ensure this matches your project namespace
{
    public class CampaignAddEditModelValidator : AbstractValidator<Counter.CampaignAddEditModel>
    {
        public CampaignAddEditModelValidator()
        {
            RuleFor(x => x.BlastingDate)
                .LessThan(x => x.StartDate)
                .WithMessage("Blasting Date must be less than Start Date.");

            RuleFor(x => x.StartDate)
                .GreaterThan(x => x.BlastingDate)
                .WithMessage("Start Date must be after Blasting Date.");
        }
    }
}