﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Net.Http.Headers;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Hosting;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Microsoft.AspNetCore.Http.Features;
//using Syncfusion.PdfExport;
using Microsoft.Extensions.FileProviders;
using System;
using Syncfusion.DocIO;
using Microsoft.AspNetCore.Cors;
using Syncfusion.DocIO.DLS;
using System.Text.RegularExpressions;
/*using Syncfusion.Blazor.Inputs;*/

namespace BlazorServerProject.Data
{
    [Route("api/[controller]")]
    public class SampleDataController : Controller
    {
        private Microsoft.AspNetCore.Hosting.IHostingEnvironment hostingEnv;
        public IActionResult Index()
        {
            return View();
        }

        public SampleDataController(Microsoft.AspNetCore.Hosting.IHostingEnvironment env)
        {
            this.hostingEnv = env;
        }
        
        public string uploads = ".\\Uploaded Files"; 

        [HttpPost("[action]")]

        public async  Task<IActionResult> Save(IFormFile UploadFiles)
        {
            if (UploadFiles.Length > 0)
            {
                //Create directory if not exists
                if (!Directory.Exists(uploads))
                {
                    Directory.CreateDirectory(uploads);
                }

                var filePath = Path.Combine(uploads, UploadFiles.FileName);
                if (System.IO.File.Exists(filePath))
                {
                    //Return conflict status code
                    return new StatusCodeResult(StatusCodes.Status409Conflict);
                }
                using (var fileStream = new FileStream(filePath, FileMode.Create))
                {
                    //Save the uploaded file to server
                    await UploadFiles.CopyToAsync(fileStream);
                }
            }
            return Ok();

        }

        [HttpPost("[action]")]
        public void Remove(IList<IFormFile> UploadFiles)
        {
            try
            {
                var filename = hostingEnv.ContentRootPath + $@"\{UploadFiles[0].FileName}";
                if (System.IO.File.Exists(filename))
                {
                    System.IO.File.Delete(filename);
                }
            }
            catch (Exception e)
            {
                Response.Clear();
                Response.StatusCode = 200;
                Response.HttpContext.Features.Get<IHttpResponseFeature>().ReasonPhrase = "File removed successfully";
                Response.HttpContext.Features.Get<IHttpResponseFeature>().ReasonPhrase = e.Message;
            }
        }

        public class DataService
        {
            public async Task<List<string>> GetIndustriesAsync()
            {
                // Simulate asynchronous data retrieval (replace with actual data fetching logic)
                await Task.Delay(1000);

                // Replace this with actual data retrieval logic, e.g., making an API call or querying a database
                return new List<string> { "Finance", "Technology", "Healthcare", "Manufacturing" };
            }
        }

        [HttpGet("[action]")]
        public FileResult Download(string filename)
        {

            var filePath = Path.Combine(
                      Directory.GetCurrentDirectory());
            IFileProvider provider = new PhysicalFileProvider(filePath);
            IFileInfo fileInfo = provider.GetFileInfo(filename);
            var readStream = fileInfo.CreateReadStream();
            var mimeType = "application/pdf";
            return File(readStream, mimeType, filename);
        }
    }
}