﻿using Microsoft.AspNetCore.Http.Features;
using Microsoft.AspNetCore.Mvc;
using System.Net.Http.Headers;

namespace BlazorApp1
{
    [Route("api/[controller]")]
    public class SampleDataController : Controller
    {
        public string uploads = ".\\Uploaded Files"; // replace with your directory path

        [HttpPost("[action]")]
        public async Task<IActionResult> Save(IFormFile UploadFiles) // Save the uploaded file here
        {
            if (UploadFiles.Length > 0)
            {
                //Receive the additional form data
                var form = Request.Form["Name"];
                var authorizationHeader = Request.Headers["Authorization"];

                var filePath = Path.Combine(uploads, UploadFiles.FileName);
                if (System.IO.File.Exists(filePath))
                {
                    //Return custom-error if file already exists
                    Response.Headers.Append("custom-error", "File already exists.");

                    //Return conflict status code
                    return new StatusCodeResult(StatusCodes.Status409Conflict);
                }
                using (var fileStream = new FileStream(filePath, FileMode.Create))
                {
                    //Save the uploaded file to server
                    await UploadFiles.CopyToAsync(fileStream);
                }
            }
            //Return success response
            Response.Headers.Append("success", "File saved successfully.");
            return Ok();
        }


        [HttpPost("[action]")]
        public void Remove(string UploadFiles) // Delete the uploaded file here
        {
            if(UploadFiles != null)
            {
                var filePath = Path.Combine(uploads, UploadFiles);
                if (System.IO.File.Exists(filePath))
                {
                    //Delete the file from server
                    System.IO.File.Delete(filePath);
                }
            }
        }
    }
}
