﻿using Syncfusion.XlsIO;
using System.Collections.Generic;
using System.IO;

namespace CollectionTemplateMarker
{
	class Program
	{
		static void Main(string[] args)
		{
			//Instantiate the spreadsheet creation engine
			using (ExcelEngine excelEngine = new ExcelEngine())
			{
				//Instantiate the excel application object
				IApplication application = excelEngine.Excel;

				//The workbook is Created
				IWorkbook workbook = application.Workbooks.Create(1);

				//The first worksheet object in the worksheets collection is accessed
				IWorksheet worksheet = workbook.Worksheets[0];

				//Data
				worksheet["A1"].Text = "Number";

				//Add markers 
				worksheet["A2"].Text = "%Number";

				//Create Template Marker Processor
				ITemplateMarkersProcessor markers = workbook.CreateTemplateMarkersProcessor();

				var numbers = new List<int?>()
				{
					null,
					null,
					1
				};

				markers.AddVariable("Number", numbers);

				//Process the markers in the template
				markers.ApplyMarkers();

				//Saving the workbook
				Stream stream = File.Create("Output.xlsx");
				worksheet.UsedRange.AutofitColumns();
				workbook.SaveAs(stream);
			}
		}
	}
}
