﻿using System.Collections;
using System.ComponentModel;
using System.Runtime.CompilerServices;

namespace FannSoftware.Utilities
{
    public class NotifyModel : INotifyPropertyChanged, INotifyDataErrorInfo
    {
        #region INotifyDataErrorInfo

        public bool InitialLoad { get; set; } = true;

        public bool HasErrors => GetErrors(null).OfType<object>().Any();

        public event EventHandler<DataErrorsChangedEventArgs>? ErrorsChanged;

        public virtual void EndInitialLoad()
        {
            InitialLoad = false;
        }

        public virtual void ForceValidation()
        {
            OnPropertyChanged(null);
        }

        public virtual IEnumerable GetErrors([CallerMemberName] string? propertyName = null)
        {
            return Enumerable.Empty<object>();
        }
        protected void OnErrorsChanged([CallerMemberName] string? propertyName = null)
        {
            OnErrorsChanged(this, new DataErrorsChangedEventArgs(propertyName));
        }

        protected virtual void OnErrorsChanged(object sender, DataErrorsChangedEventArgs e)
        {
            ErrorsChanged?.Invoke(sender, e);
        }
        #endregion

        public event PropertyChangedEventHandler? PropertyChanged;

        protected bool SetProperty<T>(ref T field, T value, [CallerMemberName] string? propertyName = null)
        {
            if(object.Equals(field, value)) { return false; }

            field = value;
            OnPropertyChanged(propertyName);
            return true;
        }

        protected virtual void OnPropertyChanged([CallerMemberName] string? propertyName = null)
        {
            PropertyChanged?.Invoke(this, new PropertyChangedEventArgs(propertyName));
        }
    }
}
