﻿using FannSoftware.Utilities;
using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.ComponentModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Data;

namespace TestCheckListbox
{
    internal class MainModel : NotifyModel
    {
        private CollectionView tagView;
        private ObservableCollection<ItemTag> tags;

        public ObservableCollection<ItemTag> Tags { get => tags; set => SetProperty(ref tags, value); }
        
        private ObservableCollection<ItemTag> checkedTags;

        public ObservableCollection<ItemTag> CheckedTags { get => checkedTags; set => SetProperty(ref checkedTags, value); }

        public MainModel()
        {
            tags = [];
            checkedTags = [];
            tagView = (CollectionView)CollectionViewSource.GetDefaultView(tags);
            tagView.SortDescriptions.Add(new SortDescription("Name", ListSortDirection.Ascending));
        }
    }
}
