﻿//
// Author: Herbert Fann
// © Copyright 2019-2023 By Fann Software. All Rights Reserved.
//
using FannSoftware.Utilities;
using System;

namespace TestCheckListbox
{
    public class ItemTag : NotifyModel, IComparable<ItemTag>, ICloneable
    {
        public long TagID { get; set; }

        private string name;

        public string Name
        {
            get { return name; }
            set { SetProperty(ref name, value); }
        }


        /// <summary>
        /// Static object for no tag
        /// </summary>
        public static readonly ItemTag NoTag = new(0, "No Tag");

        public ItemTag()
        {
            TagID = -1;
            name = string.Empty;
        }

        public ItemTag(string TagName)
        {
            TagID = -1;
            name = TagName;
        }

        public ItemTag(long id, string TagName)
        {
            TagID = id;
            name = TagName;
        }

        #region IComparable<ItemTag> Members

        public int CompareTo(ItemTag? other)
        {
            return Name.CompareTo(other?.Name);
        }

        #endregion

        public override string ToString()
        {
            return Name;
        }

        #region ICloneable Members

        public object Clone()
        {
            return this.MemberwiseClone();
        }

        #endregion
    }
}
