import 'package:flutter/material.dart';

class Cacat {
  final String kode;
  final String nama;
  final String grup;
  final int point;
  final String meter;

  Cacat(this.kode, this.nama, this.grup, this.point, this.meter);
}

void main() {
  runApp(MaterialApp(
    home: Scaffold(
      appBar: AppBar(title: const Text('Tabel Cacat Kain')),
      body: CacatTable(),
    ),
  ));
}

class CacatTable extends StatelessWidget {
  // Sample data
  final List<Map<String, dynamic>> data = [
    {
      'meter': 'Meter 0 - 1',
      'cacat': [
        Cacat('kode1', 'nama1', 'grup1', 0, 'Meter 0 - 1'),
      ]
    },
    {
      'meter': 'Meter 1 - 10',
      'cacat': [
        Cacat('kode2', 'nama2', 'grup2', 0, 'Meter 1 - 10'),
        Cacat('kode3', 'nama3', 'grup3', 0, 'Meter 1 - 10'),
        {
          'meter': 'Meter 3 - 5',
          'cacat': [
            Cacat('kode4', 'nama4', 'grup4', 0, 'Meter 3 - 5'),
            {
              'meter': 'Meter 3 - 4',
              'cacat': [
                Cacat('kode5', 'nama5', 'grup5', 0, 'Meter 3 - 4'),
              ]
            },
          ]
        },
        {
          'meter': 'Meter 6 - 8',
          'cacat': [
            Cacat('kode6', 'nama6', 'grup6', 0, 'Meter 6 - 8'),
          ]
        },
      ]
    },
    {
      'meter': 'Meter 10 - 11',
      'cacat': [
        Cacat('kode7', 'nama7', 'grup7', 0, 'Meter 10 - 11'),
      ]
    }
  ];

  CacatTable({super.key});

  @override
  Widget build(BuildContext context) {
    return ListView(
      padding: const EdgeInsets.all(16),
      children: [
        buildTableHeader(),
        const SizedBox(height: 10),
        ...data.map((item) => buildMeterGroup(item)).toList(),
      ],
    );
  }

  // Build the table header
  Widget buildTableHeader() {
    return const Row(
      children: [
        Expanded(flex: 2, child: Text('Kode', style: TextStyle(fontWeight: FontWeight.bold))),
        Expanded(flex: 2, child: Text('Nama', style: TextStyle(fontWeight: FontWeight.bold))),
        Expanded(flex: 2, child: Text('Grup', style: TextStyle(fontWeight: FontWeight.bold))),
        Expanded(flex: 1, child: Text('Point', style: TextStyle(fontWeight: FontWeight.bold))),
        Expanded(flex: 1, child: Text('Aksi', style: TextStyle(fontWeight: FontWeight.bold))),
      ],
    );
  }

  // Build ExpansionTile for each meter range
  Widget buildMeterGroup(Map<String, dynamic> item) {
    return ExpansionTile(
      title: Text(item['meter']),
      trailing: TextButton(
        onPressed: () {
          // Handle edit meter group
        },
        child: const Text('Edit', style: TextStyle(color: Colors.blue)),
      ),
      children: [
        ...item['cacat'].map<Widget>((cacatItem) {
          if (cacatItem is Cacat) {
            return buildCacatRow(cacatItem);
          } else if (cacatItem is Map<String, dynamic>) {
            return buildMeterGroup(cacatItem); // Recursive for nested meter groups
          }
          return const SizedBox.shrink();
        }).toList(),
      ],
    );
  }

  // Build row for each defect (cacat)
  Widget buildCacatRow(Cacat cacat) {
    return Padding(
      padding: const EdgeInsets.symmetric(horizontal: 16.0, vertical: 4.0),
      child: Row(
        children: [
          Expanded(flex: 2, child: Text(cacat.kode)),
          Expanded(flex: 2, child: Text(cacat.nama)),
          Expanded(flex: 2, child: Text(cacat.grup)),
          Expanded(flex: 1, child: Text(cacat.point.toString())),
          Expanded(
            flex: 1,
            child: IconButton(
              onPressed: () {
                // Handle delete defect
              },
              icon: const Icon(Icons.delete, color: Colors.red),
            ),
          ),
        ],
      ),
    );
  }
}
