import { DataManager, WebMethodAdaptor } from '@syncfusion/ej2-data';

// WebMethodAdaptor.prototype.beforeSend = (_, request) => {
//   request.withCredentials = true;
// };

class CustomAdaptor extends WebMethodAdaptor {
  constructor() {
    super(...arguments);
    this.customProcessResponse = arguments[0];
  }

  processResponse(data, instance, value, httpRequest, request, changes, args) {
    let originalValue = super.processResponse.apply(this, arguments);
    if (changes != null) {
      originalValue = changes;
    }
    const result = this.customProcessResponse(originalValue);
    return result;
  }
}

export const getDataManagerObj = (url, processResponse) => {
  let adaptor = new WebMethodAdaptor();

  if (processResponse) {
    adaptor = new CustomAdaptor(processResponse);
  }

  const dataManager = new DataManager({
    url,
    adaptor,
    headers: [{ Authorization: `Bearer e968aaae-f060-4eee-8be8-1ff738b9f6de` }],
  });

  return dataManager;
};


// convert this to projectServiceUrl
// export const includedProjectsUrl = `https://api.qa.cube.ms/projects/getIncludedProjectsController`;
// export const projectServiceUrl = `https://api.qa.cube.ms/projects/projectsController`;
// export const portalRegionsUrl = `https://api.qa.cube.ms/regions/regionsController`;
// export const estimateFilesUrl = `https://api.qa.cube.ms/estimate/getEstimateFiles`
// export const estimateItemsUrl = `https://api.qa.cube.ms/estimate/getEstimateItems`
// export const getDsrItemsUrl = `https://api.qa.cube.ms/dsr/getAllDsrItems`
// export const getValidItemsUrl = `https://api.qa.cube.ms/estimate/getValidItems`
// export const portalPurchaseUnitsUrl = `https://api.qa.cube.ms/units/getPurchaseUnits`
// export const getFilesList = `https://api.qa.cube.ms/projects/getFilesList`
export const performGanttOperationsUrl = `https://api.qa.cube.ms/tasks/performGanttOperations`;
//export const getPortalLevelStatusListUrl ``


// export const portalRegionsService = getDataManagerObj(portalRegionsUrl);
// export const projectsService = getDataManagerObj(projectServiceUrl);
// export const includedProjectsService = getDataManagerObj(includedProjectsUrl);
// export const estimateFilesService = getDataManagerObj(estimateFilesUrl)
// export const estimateItemsService = getDataManagerObj(estimateItemsUrl)
// export const getValidItemsService = getDataManagerObj(getValidItemsUrl)
// export const portalPurchaseUnitsService = getDataManagerObj(portalPurchaseUnitsUrl)
// export const filesService = getDataManagerObj(getFilesList);
// export const gantService = getDataManagerObj(performGanttOperationsUrl);
//export const getPortalLevelStatusListService = getDataManagerObj(getPortalLevelStatusListUrl);