// convert to hook
import axios from 'axios';

axios.interceptors.request.use(
  (config) => {
    const returnedConfig = {
      ...config,
      onUploadProgress: (progressEvent) => {
        if (config.onUploadProgress) {
          config.onUploadProgress(Math.floor((progressEvent.loaded * 100) / progressEvent.total));
        }
      },
    };
    returnedConfig.headers.Authorization = `Bearer e968aaae-f060-4eee-8be8-1ff738b9f6de`;
    return returnedConfig;
  },
  (error) => Promise.reject(error),
);

axios.interceptors.response.use(
  (response) => response,
  (error) => {
    if (error?.response?.status == '401' && !['/', '/loginCallback', '/signup'].includes(window.location.pathname)) {
      localStorage.removeItem('isLogedIn');
    } else if (error?.response?.status == '403' && error?.response?.data?.errorCode === 1001) {
      console.log('licence expired');
    }
    return Promise.reject(error);
  },
);

export default axios;
