import { ButtonComponent } from '@syncfusion/ej2-react-buttons';
import css from './index.module.css'

const ModalStateDialogComponent = (props) => {
  /******************* 
@Purpose : ModalState Component
@Parameter : ModalStateComponentProps
@Author : Techture
 *******************/


  const handleSaveButtonClick = () => {
    if (props.onSave) {
      props.onSave();
    }
  };
  const handleCloseButtonClick = () => {
    if (props.onCancel) {
      props.onCancel();
    }
  };
  const classes = {}

  return <div className={css.overlay}>
    <div className={css.mainContainer}>
      {
        props.headerContent && props.headerContent
      }
      {
        props.modelContent && props.modelContent
      }
      {
        props.footerContent && props.footerContent
      }
    </div>
  </div>

  return (
    <>
      {props.isVisible ? <div id={props.id} className={`${"modal"} ${classes.dialog}`} >
        <div className="modalContent">
          <div className="modalHeader">
            {props.headerContent && props.headerContent}
            {props.headerTitle && <>
              <span>{props.headerTitle}</span>
            </>}
          </div>
          <div className="modalBody">
            {props.modelContent}
          </div>
          <div className="modalFooter">
            {!props.disableDefaultFooter ? <>
              <ButtonComponent onClick={handleSaveButtonClick} cssClass="e-info">
                Save
              </ButtonComponent>
              <ButtonComponent onClick={handleCloseButtonClick} cssClass="e-flat">
                Cancel
              </ButtonComponent>
            </> :
              props.footerContent
            }
          </div>
        </div>
      </div> : null}
    </>
  );
};
ModalStateDialogComponent.defaultProps = {
  width: '500px',
  allowModalPadding: true,
  disableDefaultFooter: true
};
export default ModalStateDialogComponent;
