import { forwardRef, useRef } from "react";
import { DropDownListComponent as SyncfusionDropDownListComponent } from '@syncfusion/ej2-react-dropdowns';

const DropdownListComponentCustom = forwardRef((props, ref) => {
  const dropdownRef = ref || useRef()

  const actionComplete = () => {
    if (dropdownRef.current) {
      dropdownRef.current.value = props.value
    }

    if (props.actionComplete) {
      props.actionComplete(arguments)
    }
  }

  return (
    <>
      <div>
        <SyncfusionDropDownListComponent
          ref={dropdownRef}
          {...props}
          actionComplete={actionComplete}
        />
      </div>
    </>
  );
}
)

export default DropdownListComponentCustom;

