import { Query } from '@syncfusion/ej2-data';
import { useSelector } from 'react-redux';
import { useEffect, useState } from 'react';
import { getDataManagerObj, includedProjectsUrl } from '../../services/dataManager';
import ProjectsList from '../ProjectsList/ProjectsList';
import css from './index.module.css';

const ProjectsListWrapper = () => {
  const dataSource = getDataManagerObj(includedProjectsUrl)

  const projectsStatuses = useSelector((state) => state.projectsStatuses);
  const [gridView, setGridView] = useState(false);

  const [dataSourceReady, setDataSourceReady] = useState(true);

  const handleViewIconClick = () => {
    setGridView(!gridView);
  };

  const headerBar = () => (
    <>
      <div className={css.header}>
        <div>
          <h3>Projects</h3>
          <p className={css.subHeading}>All projects that you have access to</p>
        </div>
        <div onClick={handleViewIconClick} className={css.headerItems}>
          {gridView ? (<img src={""} alt="ListView" />) : (<img src={""} alt="GridView" />)}
        </div>
      </div>
    </>
  );

  return (
    <div className={css.gridContainerClass}>
      {headerBar()}
      {dataSourceReady
      &&(
          <ProjectsList
            projectService={dataSource}
            useMargin
            enableProjectRedirectionOnClick
            allowEditing={false}
          />
        )
      }

    </div>
  );
};

export default ProjectsListWrapper;
