import { ButtonComponent } from '@syncfusion/ej2-react-buttons';
import ModalStateDialogComponent from '../../cubeComponent/ModalWithState';

import css from './index.module.css';

const NestItemWarningPopup = ({ handleNestItemWarning, closeNestItemWarning }) => {
  const nestItemWarningHeader = () => <p className={css.marginBottom20}>Nesting Item</p>;

  const nestItemWarningContent = () => (
    <div>
      <p className={css.marginBottom40}> The item will be removed from any takeoffs attached and the quantity of the item will be lost</p>
      <div>
        <ButtonComponent className={css.marginRight10} onClick={handleNestItemWarning}>
          Proceed
        </ButtonComponent>
        <ButtonComponent onClick={closeNestItemWarning}>
          Cancel
        </ButtonComponent>
      </div>
    </div>
  );

  return (
    <ModalStateDialogComponent
      width="500px"
      isVisible
      headerContent={nestItemWarningHeader()}
      modelContent={nestItemWarningContent()}
    />
  );
};

export default NestItemWarningPopup;
