import { AiOutlineSync } from 'react-icons/ai';
import { MdOutlineWrapText } from 'react-icons/md';
import { itemListSources } from '../../actions/estimation';
import { SwitchComponent } from '@syncfusion/ej2-react-buttons';
import {
  BsArrowsCollapse, BsArrowsExpand, BsFileExcel, BsFilePdf,
} from 'react-icons/bs';

import css from './index.module.css';

const EstimateItemsGridToolbar = ({
  source, previewMode, changePreviewStatus, wrapTextInGrid, handleExportPdf, handleExportExcel, allowImportExcel, handleImportExcel, handleExpandAll, handleCollapseAll,
}) => (
  <div>
    <div className={css.customToolbar}>
      {
        source !== itemListSources.ADD_ITEM_POPUP
        && (
          <div className={css.toolBox}>
            <SwitchComponent checked={previewMode} change={changePreviewStatus} />
            <span className={css.preview}>Preview</span>
          </div>
        )
      }

      <div className={css.toolBox} onClick={wrapTextInGrid}>
        <MdOutlineWrapText />
        <span>Wrap text</span>
      </div>

      {
        (source !== itemListSources.ADD_ITEM_POPUP)
        && (
          <div className={css.toolBox} onClick={handleExportPdf}>
            <BsFilePdf />
            <span>Export PDF</span>
          </div>
        )
      }

      {
        (source !== itemListSources.ADD_ITEM_POPUP)
        && (
          <div className={css.toolBox} onClick={handleExportExcel}>
            <BsFileExcel />
            <span>Export Excel</span>
          </div>
        )
      }

      {
        source === itemListSources.ESTIMATE
        && (
          <div className={`${css.toolBox} ${!allowImportExcel ? css.disabledClass : ''}`} onClick={handleImportExcel}>
            <BsFileExcel />
            <span>Import Excel</span>
          </div>
        )
      }

      {
        (previewMode || source === itemListSources.ADD_ITEM_POPUP)
        && (
          <div className={css.toolBox} onClick={handleExpandAll}>
            <BsArrowsExpand />
            <span>Expand all</span>
          </div>
        )
      }

      {
        (previewMode || source === itemListSources.ADD_ITEM_POPUP)
        && (
          <div className={css.toolBox} onClick={handleCollapseAll}>
            <BsArrowsCollapse />
            <span>Collapse all</span>
          </div>
        )
      }

      {
        source === itemListSources.ESTIMATE
        && (
          <div className={css.toolBox} disabled>
            <AiOutlineSync />
            <span>Sync</span>
          </div>
        )
      }
    </div>
  </div>
);

export default EstimateItemsGridToolbar;
