import { useState } from 'react';
import { Query } from '@syncfusion/ej2-data';
import EstimateDsrItems from './EstimateDsrItemsGrid';
import { itemListSources } from '../../actions/estimation';
import { ButtonComponent } from '@syncfusion/ej2-react-buttons';
import ModalStateDialogComponent from '../../cubeComponent/ModalWithState';

const DsrPopup = (props) => {
  const {
    estimateId, handleDiscardItemAdditionFromPopup, handleItemAdditionFromPopup, parentId, currencyData,
  } = props;

  const getValidItemsQuery = new Query().addParams('estimateParentId', parentId).addParams('estimateId', estimateId);

  const [selectedItem, setSelectedItem] = useState(null);

  function handleOnSelect() {
    handleItemAdditionFromPopup(selectedItem);
    handleDiscardItemAdditionFromPopup();
  }

  function itemSelectionCallback(params) {
    setSelectedItem(params);
  }

  function content() {
    return <EstimateDsrItems source='addItemToBoq' getValidItemsQuery={getValidItemsQuery} itemSelectionCallback={itemSelectionCallback} currencyData={currencyData} />;
  }

  function footer() {
    return (
      <div>
        <ButtonComponent disabled={!selectedItem} onClick={handleOnSelect}>Select</ButtonComponent>
        <ButtonComponent onClick={handleDiscardItemAdditionFromPopup}>Cancel</ButtonComponent>
      </div>
    );
  }

  return <ModalStateDialogComponent width="800px" modelContent={content()} footerContent={footer()} isVisible />;
};

export default DsrPopup;
