import { itemListSources } from '../../actions/estimation';
import css from './index.module.css';

export const gridTools = ({ source, estimateVersionId, dsrVersionId }) => {
  let disabled = false;

  if (source === itemListSources.ESTIMATE) {
    disabled = !!estimateVersionId;
  }

  if (source === itemListSources.COST_DATABASE) {
    disabled = !!dsrVersionId;
  }

  const list = [
    {
      id: 'add_item',
      text: 'Add',
      tooltipText: 'Add an item',
      prefixIcon: 'e-add',
      disabled,
    },
    {
      id: 'edit_item',
      text: 'Edit',
      tooltipText: 'Edit item',
      prefixIcon: 'e-edit',
      disabled: true,
    },
    {
      id: 'remove_item',
      text: source === itemListSources.ESTIMATE ? 'Remove' : 'Delete',
      tooltipText: 'Remove item',
      prefixIcon: 'e-delete',
      disabled: true,
    },
    {
      id: 'nest_item',
      text: 'Nest Item',
      tooltipText: 'Nest this item',
      prefixIcon: 'e-drag-and-drop-indicator',
      disabled: true,
    },
    {
      id: 'item_properties',
      text: 'Properties',
      tooltipText: 'Item Properties',
      disabled: true,
    },
    {
      id: 'expand_all',
      text: 'Expand All',
      tooltipText: 'Expand all items',
    },
    {
      id: 'collapse_all',
      text: 'Collapse All',
      tooltipText: 'Collapse all items',
    },
    'Update',
    'Cancel',
  ];

  if (source === itemListSources.ESTIMATE) {
    list.push({
      id: 'select_numbering',
      text: 'Preferences',
      tooltipText: 'Select numbering system',
      prefixIcon: 'e-number-formatting',
      disabled,
    });
  }

  return list;
};

export const getGridColumns = ({
  source, currencyData, costDatabaseCurrencySymbol, serialTemplate, codeEditTemplate, descriptionEditTemplate, quantityTemplate, quantityEditTemplate, unitEditTemplate, unitTemplate, rateEditTemplate, rateTemplate, amountTemplate, amountEditTemplate,
}) => {
  const columnsList = source === itemListSources.ESTIMATE ? [
    {
      field: 'id',
      headerText: '',
      width: '0',
      visible: false,
      showInColumnChooser: false,
      isPrimaryKey: true,
      allowFiltering: false,
      allowEditing: false,
    },
    {
      field: 'serial',
      headerText: 'S. No',
      isIdentity: true,
      template: serialTemplate,
      allowFiltering: true,
      allowEditing: false,
    },
    {
      field: 'code',
      headerText: 'Code',
      editTemplate: codeEditTemplate,
      allowFiltering: true,
      allowEditing: true,
    },
    {
      field: 'description',
      headerText: 'Description',
      editTemplate: descriptionEditTemplate,
      allowFiltering: true,
      allowEditing: true,
    },
    {
      field: 'quantity',
      headerText: 'Quantity',
      // template: quantityTemplate,
      editTemplate: quantityEditTemplate,
      allowFiltering: false,
      allowEditing: true,
    },
    {
      field: 'purchaseUnit',
      headerText: 'Unit',
      template: unitTemplate,
      editTemplate: unitEditTemplate,
      allowFiltering: true,
      allowEditing: true,
    },
    {
      field: 'rate',
      headerText: `Rate (${currencyData.symbolDetail.name})`,
      // template: rateTemplate,
      editTemplate: rateEditTemplate,
      allowFiltering: false,
      allowEditing: true,
    },
    {
      field: 'amount',
      headerText: `Amount (${currencyData.symbolDetail.name})`,
      isIdentity: true,
      allowEditing: false,
      allowFiltering: false,
      template: amountTemplate,
      editTemplate: amountEditTemplate,
    },
  ] : [
    {
      field: 'id',
      headerText: '',
      width: '0',
      visible: false,
      showInColumnChooser: false,
      isPrimaryKey: true,
      allowFiltering: false,
      allowEditing: false,
    },
    {
      field: 'code',
      headerText: 'Code',
      editTemplate: codeEditTemplate,
      allowFiltering: true,
      allowEditing: true,
    },
    {
      field: 'description',
      headerText: 'Description',
      editTemplate: descriptionEditTemplate,
      allowFiltering: true,
      allowEditing: true,
    },
    {
      field: 'purchaseUnit',
      headerText: 'Unit',
      editTemplate: unitEditTemplate,
      allowFiltering: true,
      allowEditing: true,
    },
    {
      field: 'rate',
      headerText: source === itemListSources.COST_DATABASE ? `Rate (${costDatabaseCurrencySymbol})` : `Rate (${currencyData.symbolDetail.name})`,
      editTemplate: rateEditTemplate,
      allowFiltering: false,
      allowEditing: true,
    },
  ];

  return columnsList;
};
