import axiosWrapper from '../services/axiosWrapper';

export function itemsHaveError(bool) {
  return {
    type: 'ITEMS_HAVE_ERROR',
    hasError: bool,
  };
}

export function setIssuesCount(data) {
  return {
    type: 'SET_ISSUES_COUNT',
    data,
  };
}

export function itemsAreLoading(bool) {
  return {
    type: 'ITEMS_ARE_LOADING',
    isLoading: bool,
  };
}

export function itemsFetchDataSuccess(items) {
  return {
    type: 'ITEMS_FETCH_DATA_SUCCESS',
    items,
  };
}

export function itemsFetchData(url) {
  return (dispatch) => {
    dispatch(itemsAreLoading(true));

    axiosWrapper
      .get(url)
      .then((response) => {
        if (response.status !== 200) {
          throw Error(response.statusText);
        }

        dispatch(itemsAreLoading(false));

        return response;
      })
      .then((response) => dispatch(itemsFetchDataSuccess(response.data)))
      .catch(() => dispatch(itemsHaveError(true)));
  };
}

export function saveBcfId(id) {
  return {
    type: 'SAVE_BCF_DATA',
    id,
  };
}

export function setBcfBufferData(data) {
  return {
    type: 'SET_BCF_BUFFER_DATA',
    data,
  };
}

export function setIssuesCommentsData(data, issueId) {
  return {
    type: 'SET_ISSUES_COMMENTS_DATA',
    data,
    issueId,
  };
}

export function deleteIssuesCommentsData(data, issueId) {
  return {
    type: 'DELETE_ISSUES_COMMENTS_DATA',
    data,
    issueId,
  };
}

export function setIssuesData(data) {
  return {
    type: 'UPDATE_ISSUES_DATA',
    data,
  };
}

export function arrangeIssuesData(data) {
  return {
    type: 'SET_ISSUES_DATA',
    data,
  };
}

export function setIssuesPinData(data) {
  return {
    type: 'SET_ISSUES_PIN_DATA',
    data,
  };
}

export function setExtraIssueData(data) {
  return {
    type: 'SET_EXTRA_ISSUES_DATA',
    data,
  };
}

export function setIssuesDataEmpty() {
  return (dispatch) => {
    dispatch({ type: 'EMPTY_ISSUES_DATA' });
  };
}

export function mergeIssuesData(data, editId) {
  return {
    type: 'MERGE_ISSUES_DATA',
    data,
    editId,
  };
}

export function mergeIssuesPinData(data) {
  return {
    type: 'MERGE_ISSUES_PINDATA',
    data,
  };
}

export function setIssuesStatusesData(data) {
  return {
    type: 'SET_ISSUES_STATUSES_DATA',
    data,
  };
}

export function setTasksStatusesData(data) {
  return {
    type: 'SET_TASKS_STATUSES_DATA',
    data,
  };
}
export function setEstimatesStatusesData(data) {
  return {
    type: 'SET_ESTIMATES_STATUSES_DATA',
    data,
  };
}

export function setFilesStatusesData(data) {
  return {
    type: 'SET_FILES_STATUSES_DATA',
    data,
  };
}

export function setProjectsStatusesData(data) {
  return {
    type: 'SET_PROJECTS_STATUSES_DATA',
    data,
  };
}

export function updateTaskData(data) {
  return {
    type: 'UPDATE_TASK_DATA',
    data,
  };
}

export function removeTaskData(data) {
  return {
    type: 'REMOVE_TASK_DATA',
    data,
  };
}

export function saveBcfData(data, config) {
  return (dispatch) => {
    dispatch(itemsAreLoading(true));

    axiosWrapper
      .post(
        `https://api.qa.cube.ms/bcf/saveBcfData`,
        data,
        config,
      )
      .then((response) => {
        if (response.data.status) {
          dispatch(saveBcfId(response.data.data.id));
        }
      })
      .catch(() => dispatch(itemsHaveError(true)));
  };
}

export function getCommentsData(data) {
  return async (dispatch) => {
    dispatch(itemsAreLoading(true));

    const responseData = await axiosWrapper.post(
      `https://api.qa.cube.ms/comments/getCommentsData`,
      data,
    );
    if (responseData.data.status) {
      dispatch(setIssuesCommentsData(responseData.data.data, data.issueId));
    }
  };
}

export function saveCommentsData(data, userData = {}) {
  return (dispatch) => {
    dispatch(itemsAreLoading(true));

    axiosWrapper
      .post(
        `https://api.qa.cube.ms/comments/saveCommentsData`,
        data,
      )
      .then((response) => {
        if (response.data.status) {
          dispatch(
            setIssuesCommentsData(
              {
                ...data,
                id: response.data.data.id,
                createdDate: response.data.data.createdDate,
                ...userData,
              },
              response.data.data.issuesId,
            ),
          );
        }
      })
      .catch(() => dispatch(itemsHaveError(true)));
  };
}

export function deleteCommentsData(data, issueId) {
  return (dispatch) => {
    dispatch(itemsAreLoading(true));

    axiosWrapper
      .post(
        `https://api.qa.cube.ms/comments/deleteCommentsData`,
        data,
      )
      .then((response) => {
        if (response.data.status) {
          dispatch(deleteIssuesCommentsData(data.commentId, issueId));
        }
      })
      .catch(() => dispatch(itemsHaveError(true)));
  };
}

export function saveIssuesData(data, id) {
  return async (dispatch) => {
    dispatch(itemsAreLoading(true));

    const response = await axiosWrapper.post(`https://api.qa.cube.ms/issues/saveIssuesData`, data);
    if (response.data.status) {
      dispatch(mergeIssuesData({ ...response.data.data }, id));
      dispatch(mergeIssuesPinData({ id: response.data.data.id, pinData: response.data.data.pinData }));
    }
    if (id) {
      
    } else { dispatch(itemsHaveError(true)); }
    return response.data.status;
  };
}

export async function deleteIssuesAttachedFile(data) {
  const response = await axiosWrapper.post(
    `https://api.qa.cube.ms/issues/removeFilesFromIssues`,
    data,
  );
}

export function getIssuesData(data, returnValue = false) {
  return async (dispatch) => {
    const response = await axiosWrapper.post(
      `https://api.qa.cube.ms/issues/getIssuesData`,
      data,
    );
    if (response.data.status) {
      dispatch(setIssuesData(response.data.result));
      if (response.data.count) {
        dispatch(setIssuesCount(response.data.count));
      }
    }
    if (returnValue) {
      return response.data.result;
    }
  };
}

export function getfilteredIssuesData(data, returnValue = false) {
  return async (dispatch) => {
    const response = await axiosWrapper.post(
      `https://api.qa.cube.ms/issues/getIssuesData`,
      data,
    );
    if (response.data.status) {
      dispatch(arrangeIssuesData(response.data.result));
    }
    if (returnValue) {
      return response.data.result;
    }
  };
}

export function getIssuesPinData(data) {
  return async (dispatch) => {
    const response = await axiosWrapper.post(
      `https://api.qa.cube.ms/issues/getIssuesPinData`,
      data,
    );
    if (response.data.status) {
      dispatch(setIssuesPinData(response.data.result));
    }
  };
}

export function getFileData(data, returnValue = false) {
  return async (dispatch) => {
    const response = await axiosWrapper.post(
      `https://api.qa.cube.ms/fileOperations/getFileData`,
      data,
    );
    if (returnValue) {
      return response.data.data;
    }
    if (response.data.status) {
    }
  };
}

export function getIssuesDataByPortal(data) {
  return (dispatch) => {
    dispatch(itemsAreLoading(true));

    axiosWrapper
      .post(
        `https://api.qa.cube.ms/issues/getIssuesDataByPortal`,
        data,
      )
      .then((response) => {
        if (response.data.status) {
          dispatch(setIssuesData(response.data.result));
        }
      })
      .catch(() => dispatch(itemsHaveError(true)));
  };
}

export function getIssuesStatusesData() {
  return (dispatch) => {
    dispatch(itemsAreLoading(true));

    axiosWrapper
      .get(
        `https://api.qa.cube.ms/issues/getAllStatusesForIssues`,
      )
      .then((response) => {
        if (response.data.status) {
          dispatch(setIssuesStatusesData(response.data.data));
        }
      })
      .catch(() => dispatch(itemsHaveError(true)));
  };
}

export function getTasksStatusesData() {
  return (dispatch) => {
    dispatch(itemsAreLoading(true));

    axiosWrapper
      .get(`https://api.qa.cube.ms/tasks/getAllStatusesForTasks`)
      .then((response) => {
        if (response.data.status) {
          dispatch(setTasksStatusesData(response.data.data));
        }
      })
      .catch(() => dispatch(itemsHaveError(true)));
  };
}
export function getEstimatesStatusesData() {
  return (dispatch) => {
    dispatch(itemsAreLoading(true));

    axiosWrapper
      .get(
        `https://api.qa.cube.ms/estimate/getAllStatusesForEstimates`,
      )
      .then((response) => {
        if (response.data.status) {
          dispatch(setEstimatesStatusesData(response.data.data));
        }
      })
      .catch(() => dispatch(itemsHaveError(true)));
  };
}

export function getFilesStatusesData(data) {
  return (dispatch) => {
    dispatch(itemsAreLoading(true));

    axiosWrapper
      .get(
        `https://api.qa.cube.ms/fileUpload/getAllStatusesForFiles`,
      )
      .then((response) => {
        if (response.data.status) {
          dispatch(setFilesStatusesData(response.data.data));
        }
      })
      .catch(() => dispatch(itemsHaveError(true)));
  };
}

export function getProjectsStatusesData(data) {
  return (dispatch) => {
    dispatch(itemsAreLoading(true));

    axiosWrapper
      .get(
        `https://api.qa.cube.ms/projects/getAllStatusesForProjects`,
      )
      .then((response) => {
        if (response.data.status) {
          dispatch(setProjectsStatusesData(response.data.data));
        }
      })
      .catch(() => dispatch(itemsHaveError(true)));
  };
}

export function saveProjectStatus(data) {
  return (dispatch) => {
    axiosWrapper
      .post(
        `https://api.qa.cube.ms/projects/saveProjectStatus`,
        data,
      )
      .then((response) => {
        if (response.data.status) {
          
        }
      })
      .catch(() => dispatch(itemsHaveError(true)));
  };
}

export function saveTaskStatus(data) {
  return (dispatch) => {
    axiosWrapper
      .post(`https://api.qa.cube.ms/tasks/saveTaskStatus`, data)
      .then((response) => {
        if (response.data.status) {
          dispatch(updateTaskData(data));
        }
      })
      .catch(() => dispatch(itemsHaveError(true)));
  };
}

export function deleteTask(data) {
  return async (dispatch) => {
    const response = await axiosWrapper.post(
      `https://api.qa.cube.ms/tasks/deleteTask`,
      data,
    );
    return response;
  };
}

export function saveProjectData(data) {
  return async (dispatch) => {
    const response = await axiosWrapper.post(`https://api.qa.cube.ms/projects/saveProjectsData`, data);
    return response;
  };
}

export function setZoomLevel(data) {
  return {
    type: 'SET_ZOOM_LEVEL',
    data,
  };
}

export function setEditIssuesData(data) {
  return {
    type: 'SET_EDIT_ISSUES_DATA',
    data,
  };
}

export function setAutoBcfLoaded(param) {
  return {
    type: 'SET_AUTO_BCF_LOADED',
    param,
  };
}

export function getBcfData(data) {
  return (dispatch) => {
    dispatch(itemsAreLoading(true));

    axiosWrapper
      .post(`https://api.qa.cube.ms/bcf/getBcfData`, data)
      .then((response) => {
        if (response.data.status && response.data.data.bcfData) {
          dispatch(setBcfBufferData(response.data.data.bcfData));
          dispatch(saveBcfId(response.data.data.rowData.id));
        } else {
          dispatch(setAutoBcfLoaded(true));
        }
      })
      .catch(() => dispatch(itemsHaveError(true)));
  };
}
