import axiosWrapper from '../services/axiosWrapper';

export function getEstimateList(data) {
  return {
    type: 'GET_ESTIMATE_LIST',
    data,
  };
}

export function getEstimateDataAction(data) {
  return {
    type: 'GET_ESTIMATE_DATA',
    data,
  };
}

export function getEstimateListData(data, skip, take) {
  return async (dispatch) => {
    data = { value: { params: { ...data }, skip, take } };
    const responseData = await axiosWrapper.post(`https://api.qa.cube.ms/estimate/getEstimateList`, data);
    if (responseData.data.status) {
      const resData = responseData.data.result;
      dispatch(getEstimateList(resData));
    }
  };
}

export function getEstimateData({ estimateId }) {
  return async (dispatch) => {
    const data = { id: estimateId }
    const responseData = await axiosWrapper.post(`https://api.qa.cube.ms/estimate/getEstimateData`, data);

    if (responseData.data.status) {
      const resData = responseData.data.result;
      dispatch(getEstimateDataAction(resData))
    }
  }
}

export function emptyEstimateListData(data) {
  return (dispatch) => {
    dispatch({ type: 'EMPTY_ESTIMATE_LIST' });
  };
}
