import {
  useEffect, useState, lazy, Suspense,
} from 'react';
import {
  Route, Switch, useLocation, useHistory,Routes
} from 'react-router-dom';
import { connect, useDispatch } from 'react-redux';
import css from './App.module.css';
import Gant from './components/Gant/Gant';

function Router(props) {
  const status = localStorage.getItem('isLogedIn');

  return (
    <>
      <div style={{height: '100vh'}} className={`${css.controlSection} ${css.withoutHeader}` }>
          <Suspense fallback={<></>}>
            <Gant/>
          </Suspense>
      </div>
    </>
  );
}

const mapStateToProps = (state) => ({
  licenceStatus: state.licenceStatus,
  userDetails: state.userDetails,
  toastNotificationContent: state.toastNotificationContent,
});

const mapDispatchToProps = (dispatch) => ({
  getUserDetails: () => dispatch(getUserDetails()),
  getNotifications: () => dispatch(getNotifications()),
  setLayout: (data) => dispatch(setLayout(data)),
  fetchLayout: () => dispatch(fetchLayout()),
});

export default connect(mapStateToProps, mapDispatchToProps)(Router);
