import { createContext, useContext } from 'react';
import { Provider } from 'react-redux';
import configureStore from './store/configureStore';
import Router from './Router';

export const store = configureStore();

export const PubSubContext = createContext({
  PubSubHelper,
});

const themes = {
  light: {
    rootBackground: '--surface-neutral',
  },
  dark: {
    rootBackground: '--surface-white',
  },
};

const ThemeContext = createContext(themes.light);

function App() {
  const PubSubHelper = useContext(PubSubContext);
  const theme = useContext(ThemeContext);

  return (
    <PubSubContext.Provider>
      <ThemeContext.Provider>
        <Provider store={store}>
            <div className="App" style={{ opacity: 1, background: `var(${theme.rootBackground})`,  display: 'flex', flex: 1 }}>
              <Router PubSubHelper={PubSubHelper} />
            </div>
        </Provider>
      </ThemeContext.Provider>
    </PubSubContext.Provider>
  );
}

export default App;
