﻿using System.Windows;

namespace WpfTestNumeric;

/// <summary>
/// Interaction logic for MainWindow.xaml
/// </summary>
public partial class MainWindow : Window
{
    public MainWindow()
    {
        InitializeComponent();
        DataContext = this;
    }

    /// <summary>
    /// Indicates if we are locked (e.g. saving). No navigation, save, cancel etc are allowed if record is locked.
    /// </summary>
    public double? TestVal
    {
        get => (double?)GetValue(TestValProperty);
        set => SetValue(TestValProperty, value);
    }

    private static readonly DependencyProperty TestValProperty
                = DependencyProperty.Register(
                    nameof(TestVal),
                    typeof(double?), typeof(MainWindow),
                    new FrameworkPropertyMetadata(null, FrameworkPropertyMetadataOptions.None));

}