﻿using CommunityToolkit.Maui;
using Microsoft.Extensions.Logging;
using Syncfusion.Licensing;
using Syncfusion.Maui.Core.Hosting;

namespace TestInvisibleButtonsBroken;
public static class MauiProgram
{
    public static MauiApp CreateMauiApp()
    {
        var builder = MauiApp.CreateBuilder();

        builder
            .UseMauiApp<App>()
            .UseMauiCommunityToolkit()
            .ConfigureFonts(fonts =>
            {
                fonts.AddFont("OpenSans-Regular.ttf", "OpenSansRegular");
                fonts.AddFont("OpenSans-Semibold.ttf", "OpenSansSemibold");
            });

        builder.ConfigureSyncfusionCore();

        SyncfusionLicenseProvider.RegisterLicense(
            "MzQ4Nzk5NEAzMjM3MmUzMDJlMzBtTjNmY05FZVJaeDZzVTIyNEg2SWV5Z1dMWEwwMFR5Sm9hdHBIM0JnZmZVPQ==");

#if DEBUG
		builder.Logging.AddDebug();
#endif

        return builder.Build();
    }
}
