﻿
using CommunityToolkit.Mvvm.ComponentModel;
using CommunityToolkit.Mvvm.Input;

namespace TestInvisibleButtonsBroken;
public class MainViewModel : ObservableObject
{
    public MainViewModel()
    {
        CommandWithCanExecuteFalse = new AsyncRelayCommand(SayHello, () => false);
        CommandWithCanExecuteTrue = new AsyncRelayCommand(SayHello, ()=> true);
    }

    private async Task SayHello()
    {
        await MainThread.InvokeOnMainThreadAsync(async () =>
        {
          await  Application.Current.MainPage.DisplayAlert("Hello", "Hello", "OK");
        });
    }


    public AsyncRelayCommand CommandWithCanExecuteTrue { get; }
    public AsyncRelayCommand CommandWithCanExecuteFalse { get; }
}
