import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:ksr_medical_manager/src/components/sf_standard_data_table.dart';
import 'package:ksr_medical_manager/src/core/localization/generated/l10n.dart';
import 'package:ksr_medical_manager/src/core/models/table_column_title.dart';
import 'package:ksr_medical_manager/src/features/patients/bloc/bloc/patient_bloc.dart';
import 'package:ksr_medical_manager/src/features/patients/data/data_source/patients_data_table_source.dart';
import 'package:ksr_medical_manager/src/features/patients/data/model/patient.dart';
import 'package:syncfusion_flutter_datagrid/datagrid.dart';

class PatientList extends StatefulWidget {
  const PatientList({
    super.key,
  });

  @override
  State<PatientList> createState() => _PatientListState();
}

class _PatientListState extends State<PatientList> {
  PatientBloc? _patientBloc;
  final GlobalKey<SfDataGridState> _key = GlobalKey<SfDataGridState>();
  final List<TableColumnTitle> columnsTitles = [];
  @override
  void didChangeDependencies() {
    columnsTitles.addAll([
      TableColumnTitle(name: S.of(context).nom_du_patiente),
      TableColumnTitle(name: S.of(context).sexe, width: 120),
      TableColumnTitle(name: S.of(context).numero_de_telephone),
      TableColumnTitle(name: S.of(context).age, width: 100),
      TableColumnTitle(name: S.of(context).date_de_creation),
      TableColumnTitle(name: S.of(context).adresse),
      TableColumnTitle(name: S.of(context).actions, width: 120),
    ]);
    _patientBloc = context.read<PatientBloc>();
    super.didChangeDependencies();
  }

  @override
  void dispose() {
    // Use the stored reference instead of looking it up from the context.
    _patientBloc?.add(ResetPatientListEvent());
    super.dispose();
  }

  @override
  Widget build(BuildContext context) {
    final List<Patient> myPatients = [];

    return BlocBuilder<PatientBloc, PatientState>(
      buildWhen: (previous, current) =>
          current is SearchedPatientList || current is RefreshPatientList,
      builder: (context, state) {
        if (state is SearchedPatientList) {
          myPatients.clear();
          myPatients.addAll(context.read<PatientBloc>().searchedPatientList);
        } else {
          myPatients.clear();
          myPatients.addAll(context.read<PatientBloc>().patientList);
        }
        return SfDataTable(
          myKey: _key,
          tableTitle: S.of(context).listedes_patientes,
          dataSource: PatientsDataTableSource(
              myPatientList: myPatients, context: context),
          totalItems: myPatients.length,
          columnsTitles: columnsTitles,
          tinyWidthColumnIndex: const [2],
          excludeColumnsOnExport: const ['Actions'],
          disableFilttering: const [3, 6],
          disableSorting: const [6],
        );
      },
    );
  }
}
