﻿using CommunityToolkit.Mvvm.ComponentModel;
using CommunityToolkit.Mvvm.Input;
using SfMemoryLeaks.Models;
using System.Collections.ObjectModel;

namespace SfMemoryLeaks.ViewModels
{
    public partial class MainPageViewModel : ObservableObject
    {
        [ObservableProperty]
        private ObservableCollection<DetectedLeakModel> _detectedLeaks = [];

        [ObservableProperty]
        private string _currentMemoryUsage = string.Empty;

        public MainPageViewModel()
        {

        }

        [RelayCommand]
        private void AddLeaks(List<DetectedLeakModel> leaks)
        {
            ClearLeaks();

            foreach (DetectedLeakModel leak in leaks)
            {
                DetectedLeaks.Insert(0, leak);
            }

            DetectedLeaks.Insert(0, new DetectedLeakModel() { Message = $"Reported at {DateTime.Now.ToString("g")}" });

            CurrentMemoryUsage = $"Current memory usage: " + GC.GetTotalMemory(false) / (1024.0 * 1024.0) + " MB";
        }

        [RelayCommand]
        private void ClearLeaks()
        {
            DetectedLeaks = [];
        }
    }
}
