﻿using Microsoft.Extensions.Logging;
using SfMemoryLeaks.Pages;
using SfMemoryLeaks.ViewModels;
using Syncfusion.Maui.Core.Hosting;

namespace SfMemoryLeaks
{
    public static class MauiProgram
    {
        public static MauiApp CreateMauiApp()
        {
            var builder = MauiApp.CreateBuilder();
            builder
                .UseMauiApp<App>()
                .ConfigureFonts(fonts =>
                {
                    fonts.AddFont("OpenSans-Regular.ttf", "OpenSansRegular");
                    fonts.AddFont("OpenSans-Semibold.ttf", "OpenSansSemibold");
                });

            builder.ConfigureSyncfusionCore();

            builder.Services.AddTransient(typeof(MainPageViewModel));
            builder.Services.AddTransient(typeof(MainPage));

#if DEBUG
            builder.Logging.AddDebug();
#endif

            builder.AddLeakDetection();

            RegisterRoutes();
            return builder.Build();
        }

        private static void RegisterRoutes()
        {
            Routing.RegisterRoute("Pages/SfButtons", typeof(SfButtonsPage));
            Routing.RegisterRoute("Pages/SfTextInputLayouts", typeof(SfTextInputLayoutPage));
            Routing.RegisterRoute("Pages/SfNumericEntries", typeof(SfNumericEntryPage));
            Routing.RegisterRoute("Pages/SfSwitches", typeof(SfSwitchPage));
        }
    }
}
