﻿using SfMemoryLeaks.Models;
using SfMemoryLeaks.ViewModels;

namespace SfMemoryLeaks
{
    public partial class MainPage : ContentPage
    {        
        MainPageViewModel? ViewModel => BindingContext as MainPageViewModel;

        public MainPage(MainPageViewModel viewModel)
        {
            InitializeComponent();
            this.BindingContext = viewModel;
        }

        private void SfButtonsClicked(object sender, EventArgs e)
        {
            Shell.Current.GoToAsync("/Pages/SfButtons");
        }

        private void SfTextInputLayoutClicked(object sender, EventArgs e)
        {
            Shell.Current.GoToAsync("/Pages/SfTextInputLayouts");
        }

        private void SfNumericEntriesClicked(object sender, EventArgs e)
        {
            Shell.Current.GoToAsync("/Pages/SfNumericEntries");
        }

        private void SfSwitchesClicked(object sender, EventArgs e)
        {
            Shell.Current.GoToAsync("/Pages/SfSwitches");
        }

        protected override void OnParentSet()
        {
            base.OnParentSet();

            if (ViewModel == null) return;

            if (Parent == null)
            {
                ViewModel.ClearLeaksCommand.Execute(null);

                // unsubscribe from leak detection
                if (MemoryLeakDetector.Instance is MemoryLeakDetector detector)
                {
                    detector.OnReportLeaks -= ReportLeaks;
                }
            }
            else
            {
                // subscribe to leak detection
                if(MemoryLeakDetector.Instance is MemoryLeakDetector detector)
                {
                    detector.OnReportLeaks += ReportLeaks;
                }
            }
        }
        
        private void ReportLeaks(object? sender, List<DetectedLeakModel> leaks)
        {
            // add the leak to the UI
            ViewModel?.AddLeaksCommand.Execute(leaks);
        }
    }
}
