﻿using Syncfusion.Blazor.DropDowns;

namespace BlazorApp1.Components.Bug;

public partial class Bug
{
    public ConfigViewModel ConfigurationViewModel { get; set; } = new();

    public List<Categories> Categories { get; set; }
    
    protected override async Task OnParametersSetAsync()
    {
        GetControllerTypeSignals();
        await base.OnParametersSetAsync();
    }
    
    public void GetControllerTypeSignals()
    {
        Categories = new()
        {
            new(){
                TypeId = 1, TypeName = "Test A", Items = new()
                {
                    new(1, "Test Item A"),
                    new(1, "Test Item B"),
                    new(1, "Test Item C"),
                }
            },
            new(){
                TypeId = 1, TypeName = "Test B", Items = new()
                {
                    new(1, "Test Item A"),
                    new(1, "Test Item B"),
                    new(1, "Test Item C"),
                }
            },
        };
    }
            
    public void AddConfiguration()
    {
        ConfigurationViewModel.ConfigSets.Add(new Configuration());
    }
    
    public void OnCategoryChange(ChangeEventArgs<int?, Categories> args, int index)
    {
        ConfigurationViewModel.ConfigSets[index].CategoryId = args.Value;
        ConfigurationViewModel.ConfigSets[index].ItemId = null;
    }
        
    public void OnItemChange(ChangeEventArgs<int?, Items> args, int index)
    {
        ConfigurationViewModel.ConfigSets[index].ItemId = args.Value;
    }
}

public class ConfigViewModel
{
    public List<Configuration> ConfigSets { get; init; } = [new Configuration()];
}

public class Configuration
{
    public int? CategoryId { get; set; }
    public int? ItemId { get; set; }
}
    
public class Categories
{
    public int TypeId { get; set; }
    public string TypeName { get; set; }
    public List<Items> Items { get; set; }
}

public class Items
{
    public int ItemId;
    public string ItemName;

    public Items(int itemId, string itemName)
    {
        ItemId = itemId;
        ItemName = itemName;
    }
}
