﻿using System.ComponentModel;
using System.Reflection;
using System.Windows.Input;
using Syncfusion.Maui.PdfViewer;

namespace PdfViewerExample;

internal class PdfViewerViewModel: INotifyPropertyChanged
{
    private Stream? m_pdfDocumentStream;

    /// <summary>
    /// An event to detect the change in the value of a property.
    /// </summary>
    public event PropertyChangedEventHandler? PropertyChanged;

    /// <summary>
    /// The PDF document stream that is loaded into the instance of the PDF viewer. 
    /// </summary>
    public Stream PdfDocumentStream
    {
        get
        {
            return m_pdfDocumentStream;
        }
        set
        {
            m_pdfDocumentStream = value;
            OnPropertyChanged("PdfDocumentStream");
        }
    }
        
    private readonly Command<SfPdfViewer> _saveCommand;
    public ICommand SaveCommand => _saveCommand;

    /// <summary>
    /// Constructor of the view model class
    /// </summary>
    public PdfViewerViewModel()
    {
        //Accessing the PDF document that is added as embedded resource as stream.
        m_pdfDocumentStream = typeof(App).GetTypeInfo().Assembly.GetManifestResourceStream("PdfViewerExample.Assets.32269.pdf");
        _saveCommand = new Command<SfPdfViewer>(pdfv => HandleSaveAsync(pdfv));
    }

    public void OnPropertyChanged(string name)
    {
        PropertyChanged?.Invoke(this, new PropertyChangedEventArgs(name));
    }

    private void HandleSaveAsync(SfPdfViewer pdfViewer)
    {
        using MemoryStream saveStream = new();
        pdfViewer.SaveDocument(saveStream);
    }
}