import 'package:flutter/material.dart';
import 'package:syncfusion_flutter_calendar/calendar.dart';
import 'package:timezone/data/latest_10y.dart';
import 'package:timezone/timezone.dart';

void main() {
  initializeTimeZones();
  runApp(
    const MaterialApp(
      debugShowCheckedModeBanner: false,
      home: HomeScreen(),
    ),
  );
}

const _sfTimeZone = 'Central Standard Time';

class _CalendarDataSource
    extends CalendarDataSource<({TZDateTime startTime, TZDateTime endTime})> {
  _CalendarDataSource() {
    final location = timeZoneDatabase.locations['US/Central']!;
    final now = TZDateTime.now(location);
    appointments = [
      (
        startTime: TZDateTime(location, now.year, now.month, now.day, 22),
        endTime: TZDateTime(location, now.year, now.month, now.day, 23),
      ),
    ];
  }

  @override
  DateTime getStartTime(int index) {
    return appointments![index].startTime;
  }

  @override
  DateTime getEndTime(int index) {
    return appointments![index].endTime;
  }

  @override
  String getSubject(int index) {
    return 'Demo $index';
  }

  @override
  Color getColor(int index) {
    return Colors.red;
  }

  @override
  String? getStartTimeZone(int index) {
    return _sfTimeZone;
  }

  @override
  String? getEndTimeZone(int index) {
    return _sfTimeZone;
  }
}

class HomeScreen extends StatelessWidget {
  const HomeScreen();

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      body: SafeArea(
        child: SfCalendar(
          timeSlotViewSettings:
              const TimeSlotViewSettings(timeInterval: Duration(minutes: 60)),
          timeZone: _sfTimeZone,
          view: CalendarView.day,
          showNavigationArrow: true,
          dataSource: _CalendarDataSource(),
          viewNavigationMode: ViewNavigationMode.none,
          allowedViews: const [
            CalendarView.day,
            CalendarView.week,
          ],
        ),
      ),
    );
  }
}
