﻿using System.Collections.Generic;
using System.Linq;
using System.Windows;
using System.Windows.Controls;
using Syncfusion.SfSkinManager;
using Syncfusion.Windows.Shared;
using SyncfusionWpfApp1.ViewModels;
namespace SyncfusionWpfApp1.Views
{
  public partial class DataGridPage : Page
  {
    string ClipBoardValue;
    public class info : NotificationObject
    {
      private string _A, _B, _C;
      public string A { get { return _A; } set { _A = value; RaisePropertyChanged("A"); } }
      public string B { get { return _B; } set { _B = value; RaisePropertyChanged("B"); } }
      public string C { get { return _C; } set { _C = value; RaisePropertyChanged("C"); } }
    }
    List<info> infos = new List<info>();

    public DataGridPage(DataGridViewModel viewModel)
    {
      InitializeComponent();
      DataContext = viewModel;
      grid.ItemsSource = infos;
      infos.Add(new info { A = "SYSTEM INFO 1" });
      infos.Add(new info { B = "SYSTEM INFO 2" });
      infos.Add(new info { C = "SYSTEM INFO 3" });
    }

    private void dataGrid_CopyGridCellContent(object sender, Syncfusion.UI.Xaml.Grid.GridCopyPasteCellEventArgs e)
    {
      MessageBox.Show("'COPY' event fired and system processing is done!");

      ClipBoardValue = e.ClipBoardValue.ToString();
    }

    private void dataGrid_PasteGridCellContent(object sender, Syncfusion.UI.Xaml.Grid.GridCopyPasteCellEventArgs e)
    {
      MessageBox.Show("'PASTE' event fired and system processing will be done!");

      if (e.ClipBoardValue.ToString() != ClipBoardValue)
      {
        MessageBox.Show("Invalid data: only data copied from other cells is valid!");
        e.Handled = true;
        return;
      }

    }
  }
}
