﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Syncfusion.Pdf;
using Syncfusion.Pdf.Parsing;

namespace SyncfusionMergePdf
{
    internal class Program
    {
        static void Main(string[] args)
        {
            string[] mergeFileNames = new string[]
            {
                "VA24_BB_GHV_E01.pdf", 
                "VA24_BB_GHV_E02.pdf", 
            };

            using (PdfDocument finalPdfDocument = new PdfDocument())
            {
                finalPdfDocument.EnableMemoryOptimization = true;

                // Without the following code line all the form fields get unique names.
                // Before the merge some have the same name, so that an input in one field will be mirrored to the other field.
                // To prevent this with the following code line the form fields e. g. on page 3 are not available anymore (Acrobat Reader)
                finalPdfDocument.Form.FieldAutoNaming = false;

                foreach (string currentMergeFileName in mergeFileNames)
                {
                    using (PdfLoadedDocument currentMergeDocument = new PdfLoadedDocument(currentMergeFileName, true))
                    {
                        PdfDocument.Merge(finalPdfDocument, currentMergeDocument);
                        finalPdfDocument.Save("result.pdf");
                        currentMergeDocument.Close(true);
                    }
                }
                finalPdfDocument.Close(true);
            }
        }
    }
}
