var ej = function(exports) {
    "use strict";
    function createInstance(classFunction, params) {
        var arrayParam = params;
        return arrayParam.unshift(void 0), new (Function.prototype.bind.apply(classFunction, arrayParam))();
    }
    function setImmediate(handler) {
        var unbind, num = new Uint16Array(5);
        (window.msCrypto || window.crypto).getRandomValues(num);
        var secret = "ej2" + function(num) {
            for (var ret = "", i = 0; i < 5; i++) ret += (i ? "," : "") + num[i];
            return ret;
        }(num), messageHandler = function(event) {
            event.source === window && "string" == typeof event.data && event.data.length <= 32 && event.data === secret && (handler(), 
            unbind());
        };
        return window.addEventListener("message", messageHandler, !1), window.postMessage(secret, "*"), 
        unbind = function() {
            window.removeEventListener("message", messageHandler);
        };
    }
    function getValue(nameSpace, obj) {
        for (var value = obj, splits = nameSpace.split("."), i = 0; i < splits.length && !isUndefined(value); i++) value = value[splits[i]];
        return value;
    }
    function setValue(nameSpace, value, obj) {
        var i, key, keys = nameSpace.split("."), start = obj || {}, fromObj = start, length = keys.length;
        for (i = 0; i < length; i++) key = keys[i], i + 1 === length ? fromObj[key] = void 0 === value ? {} : value : isNullOrUndefined(fromObj[key]) && (fromObj[key] = {}), 
        fromObj = fromObj[key];
        return start;
    }
    function deleteObject(obj, key) {
        delete obj[key];
    }
    function isObject(obj) {
        return !isNullOrUndefined(obj) && obj.constructor === {}.constructor;
    }
    function getEnumValue(enumObject, enumValue) {
        return enumObject[enumValue];
    }
    function merge(source, destination) {
        if (!isNullOrUndefined(destination)) for (var temrObj = source, tempProp = destination, _i = 0, keys_1 = Object.keys(destination); _i < keys_1.length; _i++) {
            var key = keys_1[_i];
            temrObj[key] = tempProp[key];
        }
    }
    function extend(copied, first, second, deep) {
        var result = copied || {}, length = arguments.length;
        deep && (length -= 1);
        for (var _loop_1 = function(i) {
            if (!arguments_1[i]) return "continue";
            var obj1 = arguments_1[i];
            Object.keys(obj1).forEach(function(key) {
                var clone, src = result[key], copy = obj1[key];
                deep && isObject(copy) ? (clone = isObject(src) ? src : {}, result[key] = extend({}, clone, copy, !0)) : result[key] = copy;
            });
        }, arguments_1 = arguments, i = 1; i < length; i++) _loop_1(i);
        return result;
    }
    function isNullOrUndefined(value) {
        return void 0 === value || null === value;
    }
    function isUndefined(value) {
        return void 0 === value;
    }
    function getUniqueID(definedName) {
        return definedName + "_" + uid++;
    }
    function debounce(eventFunction, delay) {
        var out;
        return function() {
            var _this = this, args = arguments;
            clearTimeout(out), out = setTimeout(function() {
                return out = null, eventFunction.apply(_this, args);
            }, delay);
        };
    }
    function compareElementParent(child, parent) {
        var node = child;
        return node === parent || !(node === document || !node) && compareElementParent(node.parentNode, parent);
    }
    function throwError(message) {
        try {
            throw new Error(message);
        } catch (e) {
            throw e.message + "\n" + e.stack;
        }
    }
    function print(element, printWindow) {
        var div = document.createElement("div"), links = [].slice.call(document.getElementsByTagName("head")[0].querySelectorAll("link, style")), reference = "";
        isNullOrUndefined(printWindow) && (printWindow = window.open("", "print", "height=452,width=1024,tabbar=no")), 
        div.appendChild(element.cloneNode(!0));
        for (var i = 0, len = links.length; i < len; i++) reference += links[i].outerHTML;
        printWindow.document.write("<!DOCTYPE html> <html><head>" + reference + "</head><body>" + div.innerHTML + "<script> (function() { window.ready = true; })(); <\/script></body></html>"), 
        printWindow.document.close(), printWindow.focus();
        var interval = setInterval(function() {
            printWindow.ready && (printWindow.print(), printWindow.close(), clearInterval(interval));
        }, 500);
        return printWindow;
    }
    function formatUnit(value) {
        var result = value + "";
        return "auto" === result || -1 !== result.indexOf("%") || -1 !== result.indexOf("px") ? result : result + "px";
    }
    function getInstance(element, component) {
        var elem = "string" == typeof element ? document.querySelector(element) : element;
        if (elem[instances]) for (var _i = 0, _a = elem[instances]; _i < _a.length; _i++) {
            var inst = _a[_i];
            if (inst instanceof component) return inst;
        }
        return null;
    }
    function uniqueID() {
        var num = new Uint16Array(5);
        return (window.msCrypto || window.crypto).getRandomValues(num);
    }
    function createElement(tagName, properties) {
        var element = document.createElement(tagName);
        return void 0 === properties ? element : (element.innerHTML = properties.innerHTML ? properties.innerHTML : "", 
        void 0 !== properties.className && (element.className = properties.className), void 0 !== properties.id && (element.id = properties.id), 
        void 0 !== properties.styles && element.setAttribute("style", properties.styles), 
        void 0 !== properties.attrs && attributes(element, properties.attrs), element);
    }
    function addClass(elements, classes) {
        for (var classList = getClassList(classes), _i = 0, _a = elements; _i < _a.length; _i++) for (var ele = _a[_i], _b = 0, classList_1 = classList; _b < classList_1.length; _b++) {
            var className = classList_1[_b];
            ele.classList.contains(className) || ele.classList.add(className);
        }
        return elements;
    }
    function removeClass(elements, classes) {
        for (var classList = getClassList(classes), _i = 0, _a = elements; _i < _a.length; _i++) {
            var ele = _a[_i];
            if ("" !== ele.className) for (var _b = 0, classList_2 = classList; _b < classList_2.length; _b++) {
                var className = classList_2[_b];
                ele.classList.remove(className);
            }
        }
        return elements;
    }
    function getClassList(classes) {
        var classList = [];
        return "string" == typeof classes ? classList.push(classes) : classList = classes, 
        classList;
    }
    function isVisible(element) {
        var ele = element;
        return "" === ele.style.visibility && ele.offsetWidth > 0;
    }
    function prepend(fromElements, toElement) {
        for (var docFrag = document.createDocumentFragment(), _i = 0, _a = fromElements; _i < _a.length; _i++) {
            var ele = _a[_i];
            docFrag.appendChild(ele);
        }
        return toElement.insertBefore(docFrag, toElement.firstElementChild), fromElements;
    }
    function append(fromElements, toElement) {
        for (var docFrag = document.createDocumentFragment(), _i = 0, _a = fromElements; _i < _a.length; _i++) {
            var ele = _a[_i];
            docFrag.appendChild(ele);
        }
        return toElement.appendChild(docFrag), fromElements;
    }
    function detach(element) {
        return element.parentNode.removeChild(element);
    }
    function remove(element) {
        var parentNode = element.parentNode;
        EventHandler.clearEvents(element), parentNode.removeChild(element);
    }
    function attributes(element, attributes) {
        for (var ele = element, _i = 0, keys_1 = Object.keys(attributes); _i < keys_1.length; _i++) {
            var key = keys_1[_i];
            ele.setAttribute(key, attributes[key]);
        }
        return ele;
    }
    function select(selector, context) {
        return void 0 === context && (context = document), context.querySelector(selector);
    }
    function selectAll(selector, context) {
        void 0 === context && (context = document);
        return context.querySelectorAll(selector);
    }
    function closest(element, selector) {
        var el = element;
        if ("function" == typeof el.closest) return el.closest(selector);
        for (;el && 1 === el.nodeType; ) {
            if (matches(el, selector)) return el;
            el = el.parentNode;
        }
        return null;
    }
    function setStyleAttribute(element, attrs) {
        void 0 !== attrs && Object.keys(attrs).forEach(function(key) {
            element.style[key] = attrs[key];
        });
    }
    function classList(element, addClasses, removeClasses) {
        addClass([ element ], addClasses), removeClass([ element ], removeClasses);
    }
    function matches(element, selector) {
        var matches = element.matches || element.msMatchesSelector || element.webkitMatchesSelector;
        return matches ? matches.call(element, selector) : -1 !== [].indexOf.call(document.querySelectorAll(selector), element);
    }
    function getObject(instance, curKey, defaultValue, type) {
        return instance.properties.hasOwnProperty(curKey) || (instance.properties[curKey] = createInstance(type, [ instance, curKey, defaultValue ])), 
        instance.properties[curKey];
    }
    function getObjectArray(instance, curKey, defaultValue, type, isSetter, isFactory) {
        for (var result = [], len = defaultValue.length, i = 0; i < len; i++) {
            var curType = type;
            if (isFactory && (curType = type(defaultValue[i])), isSetter) {
                var inst = createInstance(curType, [ instance, curKey, {}, !0 ]);
                inst.setProperties(defaultValue[i], !0), result.push(inst);
            } else result.push(createInstance(curType, [ instance, curKey, defaultValue[i], !0 ]));
        }
        return result;
    }
    function propertyGetter(defaultValue, curKey) {
        return function() {
            return this.properties.hasOwnProperty(curKey) || (this.properties[curKey] = defaultValue), 
            this.properties[curKey];
        };
    }
    function Property(defaultValue) {
        return function(target, key) {
            var propertyDescriptor = {
                set: function(defaultValue, curKey) {
                    return function(newValue) {
                        if (this.properties[curKey] !== newValue) {
                            var oldVal = this.properties.hasOwnProperty(curKey) ? this.properties[curKey] : defaultValue;
                            this.saveChanges(curKey, newValue, oldVal), this.properties[curKey] = newValue;
                        }
                    };
                }(defaultValue, key),
                get: propertyGetter(defaultValue, key),
                enumerable: !0,
                configurable: !0
            };
            Object.defineProperty(target, key, propertyDescriptor), addPropertyCollection(target, key, "prop", defaultValue);
        };
    }
    function Complex(defaultValue, type) {
        return function(target, key) {
            var propertyDescriptor = {
                set: function(defaultValue, curKey, type) {
                    return function(newValue) {
                        getObject(this, curKey, defaultValue, type).setProperties(newValue);
                    };
                }(defaultValue, key, type),
                get: function(defaultValue, curKey, type) {
                    return function() {
                        return getObject(this, curKey, defaultValue, type);
                    };
                }(defaultValue, key, type),
                enumerable: !0,
                configurable: !0
            };
            Object.defineProperty(target, key, propertyDescriptor), addPropertyCollection(target, key, "complexProp", defaultValue, type);
        };
    }
    function Collection(defaultValue, type) {
        return function(target, key) {
            var propertyDescriptor = {
                set: function(defaultValue, curKey, type) {
                    return function(newValue) {
                        var oldValueCollection = getObjectArray(this, curKey, defaultValue, type, !1), newValCollection = getObjectArray(this, curKey, newValue, type, !0);
                        this.saveChanges(curKey, newValCollection, oldValueCollection), this.properties[curKey] = newValCollection;
                    };
                }(defaultValue, key, type),
                get: function(defaultValue, curKey, type) {
                    return function() {
                        if (!this.properties.hasOwnProperty(curKey)) {
                            var defCollection = getObjectArray(this, curKey, defaultValue, type, !1);
                            this.properties[curKey] = defCollection;
                        }
                        return this.properties[curKey];
                    };
                }(defaultValue, key, type),
                enumerable: !0,
                configurable: !0
            };
            Object.defineProperty(target, key, propertyDescriptor), addPropertyCollection(target, key, "colProp", defaultValue, type);
        };
    }
    function Event() {
        return function(target, key) {
            var eventDescriptor = {
                set: function(newValue) {
                    var oldValue = this.properties[key];
                    if (oldValue !== newValue) {
                        var finalContext = getParentContext(this, key);
                        !1 === isUndefined(oldValue) && finalContext.context.removeEventListener(finalContext.prefix, oldValue), 
                        finalContext.context.addEventListener(finalContext.prefix, newValue), this.properties[key] = newValue;
                    }
                },
                get: propertyGetter(void 0, key),
                enumerable: !0,
                configurable: !0
            };
            Object.defineProperty(target, key, eventDescriptor), addPropertyCollection(target, key, "event");
        };
    }
    function NotifyPropertyChanges(classConstructor) {}
    function addPropertyCollection(target, key, propertyType, defaultValue, type) {
        isUndefined(target.propList) && (target.propList = {
            props: [],
            complexProps: [],
            colProps: [],
            events: [],
            propNames: [],
            complexPropNames: [],
            colPropNames: [],
            eventNames: []
        }), target.propList[propertyType + "s"].push({
            propertyName: key,
            defaultValue: defaultValue,
            type: type
        }), target.propList[propertyType + "Names"].push(key);
    }
    function getBuilderProperties(component) {
        if (isUndefined(component.prototype.builderObject)) {
            component.prototype.builderObject = {
                properties: {},
                propCollections: [],
                add: function() {
                    this.isPropertyArray = !0, this.propCollections.push(extend({}, this.properties, {}));
                }
            };
            for (var rex = /complex/, _i = 0, _a = Object.keys(component.prototype.propList); _i < _a.length; _i++) for (var key = _a[_i], _loop_1 = function(prop) {
                rex.test(key) ? component.prototype.builderObject[prop.propertyName] = function(value) {
                    var childType = {};
                    merge(childType, getBuilderProperties(prop.type)), value(childType);
                    var tempValue;
                    return tempValue = childType.isPropertyArray ? childType.propCollections : extend({}, childType.properties, {}), 
                    this.properties[prop.propertyName] = tempValue, childType.properties = {}, childType.propCollections = [], 
                    childType.isPropertyArray = !1, this;
                } : component.prototype.builderObject[prop.propertyName] = function(value) {
                    return this.properties[prop.propertyName] = value, this;
                };
            }, _b = 0, _c = component.prototype.propList[key]; _b < _c.length; _b++) {
                _loop_1(_c[_b]);
            }
        }
        return component.prototype.builderObject;
    }
    function getParentContext(context, prefix) {
        if (!1 === context.hasOwnProperty("parentObj")) return {
            context: context,
            prefix: prefix
        };
        var curText = getValue("propName", context);
        return curText && (prefix = curText + "-" + prefix), getParentContext(getValue("parentObj", context), prefix);
    }
    function rippleEffect(element, rippleOptions, done) {
        var rippleModel = function(rippleOptions) {
            return {
                selector: rippleOptions && rippleOptions.selector ? rippleOptions.selector : null,
                ignore: rippleOptions && rippleOptions.ignore ? rippleOptions.ignore : null,
                rippleFlag: rippleOptions && rippleOptions.rippleFlag,
                isCenterRipple: rippleOptions && rippleOptions.isCenterRipple,
                duration: rippleOptions && rippleOptions.duration ? rippleOptions.duration : 350
            };
        }(rippleOptions);
        return !1 === rippleModel.rippleFlag || void 0 === rippleModel.rippleFlag && !isRippleEnabled ? Function : (element.setAttribute("data-ripple", "true"), 
        EventHandler.add(element, "mousedown", rippleHandler, {
            parent: element,
            rippleOptions: rippleModel
        }), EventHandler.add(element, "mouseup", rippleUpHandler, {
            parent: element,
            rippleOptions: rippleModel,
            done: done
        }), EventHandler.add(element, "mouseleave", rippleLeaveHandler, {
            parent: element,
            rippleOptions: rippleModel
        }), Browser.isPointer && EventHandler.add(element, "transitionend", rippleLeaveHandler, {
            parent: element,
            rippleOptions: rippleModel
        }), function() {
            element.removeAttribute("data-ripple"), EventHandler.remove(element, "mousedown", rippleHandler), 
            EventHandler.remove(element, "mouseup", rippleUpHandler), EventHandler.remove(element, "mouseleave", rippleLeaveHandler), 
            EventHandler.remove(element, "transitionend", rippleLeaveHandler);
        });
    }
    function rippleHandler(e) {
        var target = e.target, selector = this.rippleOptions.selector, element = selector ? closest(target, selector) : target;
        if (!(!element || this.rippleOptions && closest(target, this.rippleOptions.ignore))) {
            var offset = element.getBoundingClientRect(), offsetX = e.pageX - document.body.scrollLeft, offsetY = e.pageY - document.body.scrollTop, pageX = Math.max(Math.abs(offsetX - offset.left), Math.abs(offsetX - offset.right)), pageY = Math.max(Math.abs(offsetY - offset.top), Math.abs(offsetY - offset.bottom)), radius = Math.sqrt(pageX * pageX + pageY * pageY), diameter = 2 * radius + "px", x = offsetX - offset.left - radius, y = offsetY - offset.top - radius;
            this.rippleOptions && this.rippleOptions.isCenterRipple && (x = 0, y = 0, diameter = "100%"), 
            element.classList.add("e-ripple");
            var rippleElement = createElement("div", {
                className: "e-ripple-element",
                styles: "width: " + diameter + ";height: " + diameter + ";left: " + x + "px;top: " + y + "px;transition-duration: " + this.rippleOptions.duration.toString() + "ms;"
            });
            element.appendChild(rippleElement), window.getComputedStyle(rippleElement).getPropertyValue("opacity"), 
            rippleElement.style.transform = "scale(1)", element !== this.parent && EventHandler.add(element, "mouseleave", rippleLeaveHandler, {
                parent: this.parent,
                rippleOptions: this.rippleOptions
            });
        }
    }
    function rippleUpHandler(e) {
        removeRipple(e, this);
    }
    function rippleLeaveHandler(e) {
        removeRipple(e, this);
    }
    function removeRipple(e, eventArgs) {
        var duration = eventArgs.rippleOptions.duration, target = e.target, selector = eventArgs.rippleOptions.selector, element = selector ? closest(target, selector) : target;
        if (element && (!element || -1 !== element.className.indexOf("e-ripple"))) {
            var rippleElements = selectAll(".e-ripple-element", element), rippleElement = rippleElements[rippleElements.length - 1];
            rippleElement && (rippleElement.style.opacity = "0.5"), eventArgs.parent !== element && EventHandler.remove(element, "mouseleave", rippleLeaveHandler), 
            setTimeout(function() {
                rippleElement && rippleElement.parentNode && rippleElement.parentNode.removeChild(rippleElement), 
                element.getElementsByClassName("e-ripple-element").length || element.classList.remove("e-ripple"), 
                eventArgs.done && eventArgs.done(e);
            }, duration);
        }
    }
    function setCulture(cultureName) {
        defaultCulture = cultureName, onIntlChange.notify("notifyExternalChange", {
            locale: defaultCulture
        });
    }
    function getNumericObject(locale, type) {
        var numObject = IntlBase.getDependables(cldrData, locale, !0)[mapper[0]], dateObject = IntlBase.getDependables(cldrData, locale)[mapper[1]], numSystem = getValue("defaultNumberingSystem", numObject), symbPattern = getValue("symbols-numberSystem-" + numSystem, numObject), pattern = IntlBase.getSymbolPattern(type || "decimal", numSystem, numObject, !1);
        return extend(symbPattern, IntlBase.getFormatData(pattern, !0, "", !0), {
            dateSeparator: IntlBase.getDateSeparator(dateObject)
        });
    }
    function getDefaultDateObject() {
        return IntlBase.getDependables(cldrData, "", !1)[mapper[1]];
    }
    function compile$1(template, helper) {
        var fnCode = 'var str="' + function(str, nameSpace, helper) {
            var localKeys = [];
            return str.replace(LINES, "").replace(DBL_QUOTED_STR, "'$1'").replace(exp, function(match, cnt, offset, matchStr) {
                var matches = cnt.match(CALL_FUNCTION);
                if (matches) {
                    var rlStr = matches[1];
                    if (IF_STMT.test(cnt)) cnt = '"; ' + cnt.replace(matches[1], rlStr.replace(WORD, function(str) {
                        return str = str.trim(), addNameSpace(str, !QUOTES.test(str) && -1 === localKeys.indexOf(str), nameSpace, localKeys);
                    })) + '{ \n str = str + "'; else if (FOR_STMT.test(cnt)) {
                        var rlStr_1 = matches[1].split(" of ");
                        cnt = '"; ' + cnt.replace(matches[1], function(mtc) {
                            return localKeys.push(rlStr_1[0]), localKeys.push(rlStr_1[0] + "Index"), "var i=0; i < " + addNameSpace(rlStr_1[1], !0, nameSpace, localKeys) + ".length; i++";
                        }) + "{ \n " + rlStr_1[0] + "= " + addNameSpace(rlStr_1[1], !0, nameSpace, localKeys) + "[i]; \n var " + rlStr_1[0] + 'Index=i; \n str = str + "';
                    } else {
                        var fnStr = cnt.split("("), fNameSpace = helper && helper.hasOwnProperty(fnStr[0]) ? "this." : "global";
                        fNameSpace = /\./.test(fnStr[0]) ? "" : fNameSpace, cnt = '" + ' + ("global" === fNameSpace ? "" : fNameSpace) + cnt.replace(rlStr, addNameSpace(matches[1].replace(",", nameSpace + "."), "global" !== fNameSpace, nameSpace, localKeys)) + '+"';
                    }
                } else cnt = ELSE_STMT.test(cnt) ? '"; ' + cnt.replace(ELSE_STMT, '} else { \n str = str + "') : cnt.match(IF_OR_FOR) ? cnt.replace(IF_OR_FOR, '"; \n } \n str = str + "') : '"+' + addNameSpace(cnt, -1 === localKeys.indexOf(cnt), nameSpace, localKeys) + '+"';
                return cnt;
            });
        }(template, "data", helper) + '"; return str;';
        return new Function("data", fnCode).bind(helper);
    }
    function addNameSpace(str, addNS, nameSpace, ignoreList) {
        return addNS && !NOT_NUMBER.test(str) && -1 === ignoreList.indexOf(str.split(".")[0]) ? nameSpace + "." + str : str;
    }
    function compile$$1(templateString, helper) {
        var compiler = engineObj.compile(templateString, helper);
        return function(data, component, propName) {
            var result = compiler(data, component, propName);
            if ("string" == typeof result) {
                return createElement(HAS_ROW.test(result) ? "table" : "div", {
                    innerHTML: result
                }).childNodes;
            }
            return result;
        };
    }
    function wrapperInitialize(tag, type, element, WRAPPER) {
        if (element.tagName === tag) {
            for (var ejInstance = getValue("ej2_instances", element), input = createElement("input", {
                attrs: {
                    type: type
                }
            }), props = [ "change", "cssClass", "label", "labelPosition" ], wrapper = createElement(tag, {
                className: WRAPPER,
                attrs: {
                    role: type,
                    "aria-checked": "false"
                }
            }), index = 0, len = element.attributes.length; index < len; index++) -1 === props.indexOf(element.attributes[index].nodeName) && input.setAttribute(element.attributes[index].nodeName, element.attributes[index].nodeValue);
            element.parentNode.insertBefore(input, element), detach(element), (element = input).parentNode.insertBefore(wrapper, element), 
            wrapper.appendChild(element), setValue("ej2_instances", ejInstance, element);
        }
        return element;
    }
    function getTextNode(element) {
        for (var node, childnode = element.childNodes, i = 0; i < childnode.length; i++) if (3 === (node = childnode[i]).nodeType) return node;
        return null;
    }
    function createCheckBox(enableRipple$$1, options) {
        void 0 === enableRipple$$1 && (enableRipple$$1 = !1), void 0 === options && (options = {});
        var wrapper = createElement("div", {
            className: "e-checkbox-wrapper e-css"
        });
        if (options.cssClass && addClass([ wrapper ], options.cssClass.split(" ")), options.enableRtl && wrapper.classList.add("e-rtl"), 
        enableRipple$$1) {
            var rippleSpan = createElement("span", {
                className: "e-ripple-container"
            });
            rippleEffect(rippleSpan, {
                isCenterRipple: !0,
                duration: 400
            }), wrapper.appendChild(rippleSpan);
        }
        var frameSpan = createElement("span", {
            className: "e-frame e-icons"
        });
        if (options.checked && frameSpan.classList.add("e-check"), wrapper.appendChild(frameSpan), 
        options.label) {
            var labelSpan = createElement("span", {
                className: "e-label",
                innerHTML: options.label
            });
            wrapper.appendChild(labelSpan);
        }
        return wrapper;
    }
    function rippleMouseHandler(e, rippleSpan) {
        if (rippleSpan) {
            var event_1 = document.createEvent("MouseEvents");
            event_1.initEvent(e.type, !1, !0), rippleSpan.dispatchEvent(event_1);
        }
    }
    function calculateRelativeBasedPosition(anchor, element) {
        var fixedElement = !1, anchorPos = {
            left: 0,
            top: 0
        }, tempAnchor = anchor;
        if (!anchor || !element) return anchorPos;
        for (isNullOrUndefined(element.offsetParent) && "fixed" === element.style.position && (fixedElement = !0); (element.offsetParent || fixedElement) && anchor && element.offsetParent !== anchor; ) anchorPos.left += anchor.offsetLeft, 
        anchorPos.top += anchor.offsetTop, anchor = anchor.offsetParent;
        for (anchor = tempAnchor; (element.offsetParent || fixedElement) && anchor && element.offsetParent !== anchor; ) anchorPos.left -= anchor.scrollLeft, 
        anchorPos.top -= anchor.scrollTop, anchor = anchor.parentElement;
        return anchorPos;
    }
    function calculatePosition(currentElement, positionX, positionY, parentElement) {
        if (fixedParent = !!parentElement, !currentElement) return {
            left: 0,
            top: 0
        };
        positionX || (positionX = "left"), positionY || (positionY = "top"), parentDocument = currentElement.ownerDocument, 
        element = currentElement;
        return function(posX, posY, pos) {
            switch (elementRect = element.getBoundingClientRect(), posY + posX) {
              case "topcenter":
                setPosx(getElementHCenter(), pos), setPosy(getElementTop(), pos);
                break;

              case "topright":
                setPosx(getElementRight(), pos), setPosy(getElementTop(), pos);
                break;

              case "centercenter":
                setPosx(getElementHCenter(), pos), setPosy(getElementVCenter(), pos);
                break;

              case "centerright":
                setPosx(getElementRight(), pos), setPosy(getElementVCenter(), pos);
                break;

              case "centerleft":
                setPosx(getElementLeft(), pos), setPosy(getElementVCenter(), pos);
                break;

              case "bottomcenter":
                setPosx(getElementHCenter(), pos), setPosy(getElementBottom(), pos);
                break;

              case "bottomright":
                setPosx(getElementRight(), pos), setPosy(getElementBottom(), pos);
                break;

              case "bottomleft":
                setPosx(getElementLeft(), pos), setPosy(getElementBottom(), pos);
                break;

              default:
              case "topleft":
                setPosx(getElementLeft(), pos), setPosy(getElementTop(), pos);
            }
            return pos;
        }(positionX.toLowerCase(), positionY.toLowerCase(), {
            left: 0,
            top: 0
        });
    }
    function setPosx(value, pos) {
        pos.left = value;
    }
    function setPosy(value, pos) {
        pos.top = value;
    }
    function getBodyScrollTop() {
        return parentDocument.documentElement.scrollTop || parentDocument.body.scrollTop;
    }
    function getBodyScrollLeft() {
        return parentDocument.documentElement.scrollLeft || parentDocument.body.scrollLeft;
    }
    function getElementBottom() {
        return fixedParent ? elementRect.bottom : elementRect.bottom + getBodyScrollTop();
    }
    function getElementVCenter() {
        return getElementTop() + elementRect.height / 2;
    }
    function getElementTop() {
        return fixedParent ? elementRect.top : elementRect.top + getBodyScrollTop();
    }
    function getElementLeft() {
        return elementRect.left + getBodyScrollLeft();
    }
    function getElementRight() {
        return elementRect.right + getBodyScrollLeft();
    }
    function getElementHCenter() {
        return getElementLeft() + elementRect.width / 2;
    }
    function fit(element, viewPortElement, axis, position) {
        if (void 0 === viewPortElement && (viewPortElement = null), void 0 === axis && (axis = {
            X: !1,
            Y: !1
        }), !axis.Y && !axis.X) return {
            left: 0,
            top: 0
        };
        var elemData = element.getBoundingClientRect();
        if (targetContainer = viewPortElement, parentDocument$1 = element.ownerDocument, 
        position || (position = calculatePosition(element, "left", "top")), axis.X) {
            var containerWidth = targetContainer ? getTargetContainerWidth() : getViewPortWidth(), containerLeft = ContainerLeft(), containerRight = ContainerRight(), overLeft = containerLeft - position.left, overRight = position.left + elemData.width - containerRight;
            elemData.width > containerWidth ? position.left = overLeft > 0 && overRight <= 0 ? containerRight - elemData.width : overRight > 0 && overLeft <= 0 ? containerLeft : overLeft > overRight ? containerRight - elemData.width : containerLeft : overLeft > 0 ? position.left += overLeft : overRight > 0 && (position.left -= overRight);
        }
        if (axis.Y) {
            var containerHeight = targetContainer ? getTargetContainerHeight() : getViewPortHeight(), containerTop = ContainerTop(), containerBottom = ContainerBottom(), overTop = containerTop - position.top, overBottom = position.top + elemData.height - containerBottom;
            elemData.height > containerHeight ? position.top = overTop > 0 && overBottom <= 0 ? containerBottom - elemData.height : overBottom > 0 && overTop <= 0 ? containerTop : overTop > overBottom ? containerBottom - elemData.height : containerTop : overTop > 0 ? position.top += overTop : overBottom > 0 && (position.top -= overBottom);
        }
        return position;
    }
    function isCollide(element, viewPortElement, x, y) {
        void 0 === viewPortElement && (viewPortElement = null);
        var elemOffset = calculatePosition(element, "left", "top");
        x && (elemOffset.left = x), y && (elemOffset.top = y);
        var data = [];
        targetContainer = viewPortElement, parentDocument$1 = element.ownerDocument;
        var elementRect = element.getBoundingClientRect(), top = elemOffset.top, left = elemOffset.left, right = elemOffset.left + elementRect.width, yAxis = topCollideCheck(top, elemOffset.top + elementRect.height), xAxis = leftCollideCheck(left, right);
        return yAxis.topSide && data.push("top"), xAxis.rightSide && data.push("right"), 
        xAxis.leftSide && data.push("left"), yAxis.bottomSide && data.push("bottom"), data;
    }
    function flip(element, target, offsetX, offsetY, positionX, positionY, viewPortElement, axis, fixedParent) {
        if (void 0 === viewPortElement && (viewPortElement = null), void 0 === axis && (axis = {
            X: !0,
            Y: !0
        }), target && element && positionX && positionY && (axis.X || axis.Y)) {
            var tEdge = {
                TL: null,
                TR: null,
                BL: null,
                BR: null
            }, eEdge = {
                TL: null,
                TR: null,
                BL: null,
                BR: null
            }, elementRect = element.getBoundingClientRect(), pos = {
                posX: positionX,
                posY: positionY,
                offsetX: offsetX,
                offsetY: offsetY,
                position: {
                    left: 0,
                    top: 0
                }
            };
            targetContainer = viewPortElement, parentDocument$1 = target.ownerDocument, function(target, edge, pos, fixedParent) {
                pos.position = calculatePosition(target, pos.posX, pos.posY, fixedParent), edge.TL = calculatePosition(target, "left", "top", fixedParent), 
                edge.TR = calculatePosition(target, "right", "top", fixedParent), edge.BR = calculatePosition(target, "left", "bottom", fixedParent), 
                edge.BL = calculatePosition(target, "right", "bottom", fixedParent);
            }(target, tEdge, pos, fixedParent), setPosition(eEdge, pos, elementRect), axis.X && leftFlip(target, eEdge, tEdge, pos, elementRect, !0), 
            axis.Y && tEdge.TL.top > -1 && topFlip(target, eEdge, tEdge, pos, elementRect, !0), 
            function(element, pos) {
                var left = 0, top = 0;
                if (null != element.offsetParent && ("absolute" === getComputedStyle(element.offsetParent).position || "relative" === getComputedStyle(element.offsetParent).position)) {
                    var data = calculatePosition(element.offsetParent, "left", "top");
                    left = data.left, top = data.top;
                }
                element.style.top = pos.position.top + pos.offsetY - top + "px", element.style.left = pos.position.left + pos.offsetX - left + "px";
            }(element, pos);
        }
    }
    function setPosition(eStatus, pos, elementRect) {
        eStatus.TL = {
            top: pos.position.top + pos.offsetY,
            left: pos.position.left + pos.offsetX
        }, eStatus.TR = {
            top: eStatus.TL.top,
            left: eStatus.TL.left + elementRect.width
        }, eStatus.BL = {
            top: eStatus.TL.top + elementRect.height,
            left: eStatus.TL.left
        }, eStatus.BR = {
            top: eStatus.TL.top + elementRect.height,
            left: eStatus.TL.left + elementRect.width
        };
    }
    function leftCollideCheck(left, right) {
        var leftSide = !1, rightSide = !1;
        return left - getBodyScrollLeft$1() < ContainerLeft() && (leftSide = !0), right > ContainerRight() && (rightSide = !0), 
        {
            leftSide: leftSide,
            rightSide: rightSide
        };
    }
    function leftFlip(target, edge, tEdge, pos, elementRect, deepCheck) {
        var collideSide = leftCollideCheck(edge.TL.left, edge.TR.left);
        tEdge.TL.left - getBodyScrollLeft$1() <= ContainerLeft() && (collideSide.leftSide = !1), 
        tEdge.TR.left >= ContainerRight() && (collideSide.rightSide = !1), (collideSide.leftSide && !collideSide.rightSide || !collideSide.leftSide && collideSide.rightSide) && ("right" === pos.posX ? pos.posX = "left" : pos.posX = "right", 
        pos.offsetX = pos.offsetX + elementRect.width, pos.offsetX = -1 * pos.offsetX, pos.position = calculatePosition(target, pos.posX, pos.posY), 
        setPosition(edge, pos, elementRect), deepCheck && leftFlip(target, edge, tEdge, pos, elementRect, !1));
    }
    function topFlip(target, edge, tEdge, pos, elementRect, deepCheck) {
        var collideSide = topCollideCheck(edge.TL.top, edge.BL.top);
        tEdge.TL.top - getBodyScrollTop$1() <= ContainerTop() && (collideSide.topSide = !1), 
        tEdge.BL.top >= ContainerBottom() && (collideSide.bottomSide = !1), (collideSide.topSide && !collideSide.bottomSide || !collideSide.topSide && collideSide.bottomSide) && ("top" === pos.posY ? pos.posY = "bottom" : pos.posY = "top", 
        pos.offsetY = pos.offsetY + elementRect.height, pos.offsetY = -1 * pos.offsetY, 
        pos.position = calculatePosition(target, pos.posX, pos.posY), setPosition(edge, pos, elementRect), 
        deepCheck && topFlip(target, edge, tEdge, pos, elementRect, !1));
    }
    function topCollideCheck(top, bottom) {
        var topSide = !1, bottomSide = !1;
        return top - getBodyScrollTop$1() < ContainerTop() && (topSide = !0), bottom > ContainerBottom() && (bottomSide = !0), 
        {
            topSide: topSide,
            bottomSide: bottomSide
        };
    }
    function getTargetContainerWidth() {
        return targetContainer.getBoundingClientRect().width;
    }
    function getTargetContainerHeight() {
        return targetContainer.getBoundingClientRect().height;
    }
    function getTargetContainerLeft() {
        return targetContainer.getBoundingClientRect().left;
    }
    function getTargetContainerTop() {
        return targetContainer.getBoundingClientRect().top;
    }
    function ContainerTop() {
        return targetContainer ? getTargetContainerTop() : 0;
    }
    function ContainerLeft() {
        return targetContainer ? getTargetContainerLeft() : 0;
    }
    function ContainerRight() {
        return targetContainer ? getBodyScrollLeft$1() + getTargetContainerLeft() + getTargetContainerWidth() : getBodyScrollLeft$1() + getViewPortWidth();
    }
    function ContainerBottom() {
        return targetContainer ? getBodyScrollTop$1() + getTargetContainerTop() + getTargetContainerHeight() : getBodyScrollTop$1() + getViewPortHeight();
    }
    function getBodyScrollTop$1() {
        return parentDocument$1.documentElement.scrollTop || parentDocument$1.body.scrollTop;
    }
    function getBodyScrollLeft$1() {
        return parentDocument$1.documentElement.scrollLeft || parentDocument$1.body.scrollLeft;
    }
    function getViewPortHeight() {
        return window.innerHeight;
    }
    function getViewPortWidth() {
        return window.innerWidth;
    }
    function getScrollableParent(element, fixedParent) {
        for (var eleStyle = getComputedStyle(element), scrollParents = [], overflowRegex = /(auto|scroll)/, parent = element.parentElement; parent && "HTML" !== parent.tagName; ) {
            var parentStyle = getComputedStyle(parent);
            "absolute" === eleStyle.position && "static" === parentStyle.position || !overflowRegex.test(parentStyle.overflow + parentStyle.overflowY + parentStyle.overflowX) || scrollParents.push(parent), 
            parent = parent.parentElement;
        }
        return fixedParent || scrollParents.push(document), scrollParents;
    }
    function getZindexPartial(element) {
        for (var parent = element.parentElement, parentZindex = []; parent && "BODY" !== parent.tagName; ) {
            var index = document.defaultView.getComputedStyle(parent, null).getPropertyValue("z-index"), position = document.defaultView.getComputedStyle(parent, null).getPropertyValue("position");
            "auto" !== index && "static" !== position && parentZindex.push(index), parent = parent.parentElement;
        }
        for (var childrenZindex = [], i = 0; i < document.body.children.length; i++) if (!element.isEqualNode(document.body.children[i])) {
            index = document.defaultView.getComputedStyle(document.body.children[i], null).getPropertyValue("z-index"), 
            position = document.defaultView.getComputedStyle(document.body.children[i], null).getPropertyValue("position");
            "auto" !== index && "static" !== position && childrenZindex.push(index);
        }
        childrenZindex.push("999");
        var finalValue = parentZindex.concat(childrenZindex);
        return Math.max.apply(Math, finalValue) + 1;
    }
    function createSpinner(args) {
        var radius, container = function(target) {
            var spinnerContainer = document.createElement("div");
            spinnerContainer.classList.add(CLS_SPINWRAP);
            var spinnerInnerContainer = document.createElement("div");
            return spinnerInnerContainer.classList.add(CLS_SPININWRAP), target.appendChild(spinnerContainer), 
            spinnerContainer.appendChild(spinnerInnerContainer), {
                wrap: spinnerContainer,
                inner_wrap: spinnerInnerContainer
            };
        }(args.target);
        if (isNullOrUndefined(args.cssClass) || container.wrap.classList.add(args.cssClass), 
        isNullOrUndefined(args.template) && isNullOrUndefined(spinTemplate)) {
            var theme = isNullOrUndefined(args.type) ? function(container) {
                return window.getComputedStyle(container, ":after").getPropertyValue("content").replace(/['"]+/g, "");
            }(container.wrap) : args.type;
            radius = function(width, theme) {
                var defaultSize = "Material" === theme ? DEFT_MAT_WIDTH : "Fabric" === theme ? DEFT_FAB_WIDTH : DEFT_BOOT_WIDTH;
                return width = width ? parseFloat(width + "") : defaultSize, "Bootstrap" === theme ? width : width / 2;
            }(isNullOrUndefined(args.width) ? void 0 : args.width, theme), setTheme(theme, container.wrap, radius), 
            isNullOrUndefined(args.label) || function(container, label) {
                var labelEle = document.createElement("div");
                labelEle.classList.add(CLS_SPINLABEL), labelEle.textContent = label, container.appendChild(labelEle);
            }(container.inner_wrap, args.label);
        } else {
            var template = isNullOrUndefined(args.template) ? spinTemplate : args.template;
            container.wrap.classList.add(CLS_SPINTEMPLATE), function(container, template, cssClass) {
                isNullOrUndefined(cssClass) || container.classList.add(cssClass);
                container.querySelector(".e-spinner-inner").innerHTML = template;
            }(container.wrap, template, spinCSSClass);
        }
        container.wrap.classList.add(CLS_HIDESPIN);
    }
    function createMaterialSpinner(container, radius) {
        var uniqueID$$1 = random_generator();
        globalTimeOut[uniqueID$$1] = {
            timeOut: 0,
            type: "Material",
            radius: radius
        }, function(innerContainer, uniqueID$$1) {
            var svgMaterial = document.createElementNS("http://www.w3.org/2000/svg", "svg");
            svgMaterial.setAttribute("class", CLS_MATERIALSPIN), svgMaterial.setAttribute("id", uniqueID$$1);
            var matCirclePath = document.createElementNS("http://www.w3.org/2000/svg", "path");
            matCirclePath.setAttribute("class", CLS_SPINCIRCLE), innerContainer.insertBefore(svgMaterial, innerContainer.firstChild), 
            svgMaterial.appendChild(matCirclePath);
        }(container, uniqueID$$1), function(radius, container) {
            var diameter = 2 * radius, svg = container.querySelector("svg.e-spin-material"), path = svg.querySelector("path.e-path-circle"), strokeSize = getStrokeSize(diameter), transformOrigin = diameter / 2 + "px";
            svg.setAttribute("viewBox", "0 0 " + diameter + " " + diameter), svg.style.width = svg.style.height = diameter + "px", 
            svg.style.transformOrigin = transformOrigin + " " + transformOrigin + " " + transformOrigin, 
            path.setAttribute("stroke-width", strokeSize + ""), path.setAttribute("d", function(diameter, strokeSize) {
                var radius = diameter / 2, offset = strokeSize / 2;
                return "M" + radius + "," + offset + "A" + (radius - offset) + "," + (radius - offset) + " 0 1 1 " + offset + "," + radius;
            }(diameter, strokeSize)), path.setAttribute("stroke-dasharray", (diameter - strokeSize) * Math.PI * .75 + ""), 
            path.setAttribute("stroke-dashoffset", getDashOffset(diameter, strokeSize, 1, 75) + "");
        }(radius, container);
    }
    function setTheme(theme, container, radius) {
        var innerContainer = container.querySelector("." + CLS_SPININWRAP), svg = innerContainer.querySelector("svg");
        switch (isNullOrUndefined(svg) || innerContainer.removeChild(svg), theme) {
          case "Material":
            createMaterialSpinner(innerContainer, radius);
            break;

          case "Fabric":
            !function(container, radius) {
                var uniqueID$$1 = random_generator();
                globalTimeOut[uniqueID$$1] = {
                    timeOut: 0,
                    type: "Fabric",
                    radius: radius
                }, create_fabric_element(container, uniqueID$$1, CLS_FABRICSPIN), fb_calculate_attributes(radius, container, CLS_FABRICSPIN);
            }(innerContainer, radius);
            break;

          case "Bootstrap":
            !function(innerContainer, radius) {
                var uniqueID$$1 = random_generator();
                globalTimeOut[uniqueID$$1] = {
                    timeOut: 0,
                    type: "Bootstrap",
                    radius: radius
                }, function(innerContainer, uniqueID$$1) {
                    var svgBoot = document.createElementNS("http://www.w3.org/2000/svg", "svg");
                    svgBoot.setAttribute("id", uniqueID$$1), svgBoot.setAttribute("class", CLS_BOOTSPIN), 
                    svgBoot.setAttribute("viewBox", "0 0 64 64"), innerContainer.insertBefore(svgBoot, innerContainer.firstChild);
                    for (var item = 0; item <= 7; item++) {
                        var bootCircle = document.createElementNS("http://www.w3.org/2000/svg", "circle");
                        bootCircle.setAttribute("class", CLS_SPINCIRCLE + "_" + item), bootCircle.setAttribute("r", "2"), 
                        bootCircle.setAttribute("transform", "translate(32,32)"), svgBoot.appendChild(bootCircle);
                    }
                }(innerContainer, uniqueID$$1), function(innerContainer, radius) {
                    var svg = innerContainer.querySelector("svg.e-spin-bootstrap");
                    svg.style.width = svg.style.height = radius + "px";
                    for (var startArc = 90, item = 0; item <= 7; item++) {
                        var start = defineArcPoints(0, 0, 24, startArc), circleEle = svg.querySelector("." + CLS_SPINCIRCLE + "_" + item);
                        circleEle.setAttribute("cx", start.x + ""), circleEle.setAttribute("cy", start.y + ""), 
                        startArc = startArc >= 360 ? 0 : startArc, startArc += 45;
                    }
                }(innerContainer, radius);
            }(innerContainer, radius);
            break;

          case "HighContrast":
            !function(container, radius) {
                var uniqueID$$1 = random_generator();
                globalTimeOut[uniqueID$$1] = {
                    timeOut: 0,
                    type: "HighContrast",
                    radius: radius
                }, create_fabric_element(container, uniqueID$$1, CLS_HIGHCONTRASTSPIN), fb_calculate_attributes(radius, container, CLS_HIGHCONTRASTSPIN);
            }(innerContainer, radius);
        }
    }
    function generateSeries(begin, stop) {
        function formSeries(i) {
            series.push(i), i === end && 1 !== count || (i <= start && i > 1 && !increment ? i = parseFloat((i - .2).toFixed(2)) : 1 === i ? (i = 7, 
            i = parseFloat((i + .2).toFixed(2)), increment = !0) : i < 8 && increment ? 8 === (i = parseFloat((i + .2).toFixed(2))) && (increment = !1) : i <= 8 && !increment && (i = parseFloat((i - .2).toFixed(2))), 
            ++count, formSeries(i));
        }
        var series = [], start = begin, end = stop, increment = !1, count = 1;
        return formSeries(start), series;
    }
    function random_generator() {
        for (var random = "", combine = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789", i = 0; i < 5; i++) random += combine.charAt(Math.floor(Math.random() * combine.length));
        return random;
    }
    function create_fabric_element(innerContainer, uniqueID$$1, themeClass) {
        var svgFabric = document.createElementNS("http://www.w3.org/2000/svg", "svg");
        svgFabric.setAttribute("id", uniqueID$$1), svgFabric.setAttribute("class", themeClass);
        var fabricCirclePath = document.createElementNS("http://www.w3.org/2000/svg", "path");
        fabricCirclePath.setAttribute("class", CLS_SPINCIRCLE);
        var fabricCircleArc = document.createElementNS("http://www.w3.org/2000/svg", "path");
        fabricCircleArc.setAttribute("class", CLS_SPINARC), innerContainer.insertBefore(svgFabric, innerContainer.firstChild), 
        svgFabric.appendChild(fabricCirclePath), svgFabric.appendChild(fabricCircleArc);
    }
    function animateMaterial(spinnerInfo) {
        !function(start, end, easing, duration, count, max, spinnerInfo) {
            function mat_animation(spinnerInfo) {
                var currentTime = Math.max(0, Math.min(new Date().getTime() - startTime, duration));
                !function(value, container) {
                    if (!isNullOrUndefined(container.querySelector("svg.e-spin-material")) && !isNullOrUndefined(container.querySelector("svg.e-spin-material").querySelector("path.e-path-circle"))) {
                        var svg = container.querySelector("svg.e-spin-material"), path = svg.querySelector("path.e-path-circle");
                        path.setAttribute("stroke-dashoffset", getDashOffset(diameter, strokeSize, value, max) + ""), 
                        path.setAttribute("transform", "rotate(" + rotate + " " + diameter / 2 + " " + diameter / 2 + ")");
                    }
                }(easing(currentTime, start, change, duration), spinnerInfo.container), id === spinnerInfo.globalInfo[spinnerInfo.uniqueID].previousId && currentTime < duration ? globalTimeOut[spinnerInfo.uniqueID].timeOut = setTimeout(mat_animation.bind(null, spinnerInfo), 1) : animateMaterial(spinnerInfo);
            }
            var id = ++spinnerInfo.globalInfo[spinnerInfo.uniqueID].previousId, startTime = new Date().getTime(), change = end - start, diameter = function(value) {
                return parseFloat(value);
            }(2 * spinnerInfo.globalInfo[spinnerInfo.uniqueID].radius + ""), strokeSize = getStrokeSize(diameter), rotate = -90 * (spinnerInfo.globalInfo[spinnerInfo.uniqueID].count || 0);
            mat_animation(spinnerInfo);
        }(1, 149, easeAnimation, 1333, spinnerInfo.globalInfo[spinnerInfo.uniqueID].count, 75, spinnerInfo), 
        spinnerInfo.globalInfo[spinnerInfo.uniqueID].count = ++spinnerInfo.globalInfo[spinnerInfo.uniqueID].count % 4;
    }
    function getStrokeSize(diameter) {
        return .1 * diameter;
    }
    function getDashOffset(diameter, strokeSize, value, max) {
        return (diameter - strokeSize) * Math.PI * (3 * max / 100 - value / 100);
    }
    function easeAnimation(current, start, change, duration) {
        var timestamp = (current /= duration) * current, timecount = timestamp * current;
        return start + change * (6 * timecount * timestamp + -15 * timestamp * timestamp + 10 * timecount);
    }
    function fb_calculate_attributes(radius, innerConainer, trgClass) {
        var centerX = radius, centerY = radius, diameter = 2 * radius, svg = innerConainer.querySelector("." + trgClass), circle = svg.querySelector(".e-path-circle"), path = svg.querySelector(".e-path-arc"), transformOrigin = diameter / 2 + "px";
        circle.setAttribute("d", function(x, y, radius) {
            return [ "M", x, y, "m", -radius, 0, "a", radius, radius, 0, 1, 0, 2 * radius, 0, "a", radius, radius, 0, 1, 0, 2 * -radius, 0 ].join(" ");
        }(centerX, centerY, radius)), path.setAttribute("d", function(x, y, radius, startArc, endArc) {
            var start = defineArcPoints(x, y, radius, endArc), end = defineArcPoints(x, y, radius, startArc);
            return [ "M", start.x, start.y, "A", radius, radius, 0, 0, 0, end.x, end.y ].join(" ");
        }(centerX, centerY, radius, 315, 45)), svg.setAttribute("viewBox", "0 0 " + diameter + " " + diameter), 
        svg.style.transformOrigin = transformOrigin + " " + transformOrigin + " " + transformOrigin, 
        svg.style.width = svg.style.height = diameter + "px";
    }
    function defineArcPoints(centerX, centerY, radius, angle) {
        var radians = (angle - 90) * Math.PI / 180;
        return {
            x: centerX + radius * Math.cos(radians),
            y: centerY + radius * Math.sin(radians)
        };
    }
    function showSpinner(container) {
        showHideSpinner(container, !1);
    }
    function showHideSpinner(container, isHide) {
        var spinnerWrap = container.classList.contains(CLS_SPINWRAP) ? container : container.querySelector("." + CLS_SPINWRAP), inner = spinnerWrap.querySelector("." + CLS_SPININWRAP);
        if (isHide ? !spinnerWrap.classList.contains(CLS_SPINTEMPLATE) && !spinnerWrap.classList.contains(CLS_HIDESPIN) : !spinnerWrap.classList.contains(CLS_SPINTEMPLATE) && !spinnerWrap.classList.contains(CLS_SHOWSPIN)) {
            var svgEle = spinnerWrap.querySelector("svg");
            if (isNullOrUndefined(svgEle)) return;
            var id = svgEle.getAttribute("id");
            switch (globalTimeOut[id].isAnimate = !isHide, globalTimeOut[id].type) {
              case "Material":
                isHide ? clearTimeout(globalTimeOut[id].timeOut) : function(container, uniqueID$$1, radius) {
                    var globalObject = {};
                    globalTimeOut[uniqueID$$1].timeOut = 0, globalObject[uniqueID$$1] = function(id, radius, count, previousId) {
                        return {
                            radius: radius,
                            count: count,
                            previousId: previousId
                        };
                    }(0, radius, 0, 0), animateMaterial({
                        uniqueID: uniqueID$$1,
                        container: container,
                        globalInfo: globalObject,
                        timeOutVar: 0
                    });
                }(inner, id, globalTimeOut[id].radius);
                break;

              case "Bootstrap":
                isHide ? clearTimeout(globalTimeOut[id].timeOut) : function(innerContainer) {
                    for (var id = innerContainer.querySelector("svg.e-spin-bootstrap").getAttribute("id"), i = 1; i <= 8; i++) !function(circle, start, end, series, id) {
                        function boot_animate(radius) {
                            globalTimeOut[id].isAnimate && (++count, circle.setAttribute("r", radius + ""), 
                            count >= series.length && (count = 0), globalTimeOut[id].timeOut = setTimeout(boot_animate.bind(null, series[count]), 18));
                        }
                        var count = 0;
                        boot_animate(start);
                    }(innerContainer.getElementsByClassName("e-path-circle_" + (8 === i ? 0 : i))[0], i, 0, generateSeries(i, i), id);
                }(inner);
            }
        }
        isHide ? classList(spinnerWrap, [ CLS_HIDESPIN ], [ CLS_SHOWSPIN ]) : classList(spinnerWrap, [ CLS_SHOWSPIN ], [ CLS_HIDESPIN ]);
    }
    function hideSpinner(container) {
        showHideSpinner(container, !0);
    }
    function createMask() {
        if (attributes(this.element, {
            role: "textbox",
            autocomplete: "off",
            autocorrect: "off",
            autocapitalize: "off",
            spellcheck: "false",
            "aria-live": "assertive",
            "aria-valuenow": ""
        }), this.mask) {
            for (var splitMask = this.mask.split("]"), i = 0; i < splitMask.length; i++) if ("\\" === splitMask[i][splitMask[i].length - 1]) {
                splitMask[i] = splitMask[i] + "]";
                for (var splitInnerMask = splitMask[i].split("["), j = 0; j < splitInnerMask.length; j++) "\\" === splitInnerMask[j][splitInnerMask[j].length - 1] && (splitInnerMask[j] = splitInnerMask[j] + "["), 
                pushIntoRegExpCollec.call(this, splitInnerMask[j]);
            } else {
                if ((splitInnerMask = splitMask[i].split("[")).length > 1) {
                    var chkSpace = !1;
                    for (j = 0; j < splitInnerMask.length; j++) "\\" === splitInnerMask[j] ? (this.customRegExpCollec.push("["), 
                    this.hiddenMask += splitInnerMask[j] + "[") : "" === splitInnerMask[j] ? chkSpace = !0 : "" !== splitInnerMask[j] && chkSpace || j === splitInnerMask.length - 1 ? (this.customRegExpCollec.push("[" + splitInnerMask[j] + "]"), 
                    this.hiddenMask += this.promptChar, chkSpace = !1) : pushIntoRegExpCollec.call(this, splitInnerMask[j]);
                } else pushIntoRegExpCollec.call(this, splitInnerMask[0]);
            }
            if (this.escapeMaskValue = this.hiddenMask, this.promptMask = this.hiddenMask.replace(/[09?LCAa#&]/g, this.promptChar), 
            !isNullOrUndefined(this.customCharacters)) for (i = 0; i < this.promptMask.length; i++) isNullOrUndefined(this.customCharacters[this.promptMask[i]]) || (this.promptMask = this.promptMask.replace(new RegExp(this.promptMask[i], "g"), this.promptChar));
            var escapeNumber = 0;
            if (this.hiddenMask.match(new RegExp(/\\/))) for (i = 0; i < this.hiddenMask.length; i++) {
                j = 0;
                i >= 2 && (j = i), j -= escapeNumber = this.hiddenMask.length - this.promptMask.length, 
                i > 0 && "\\" !== this.hiddenMask[i - 1] && (">" === this.hiddenMask[i] || "<" === this.hiddenMask[i] || "|" === this.hiddenMask[i]) && (this.promptMask = this.promptMask.substring(0, j) + this.promptMask.substring(i + 1 - escapeNumber, this.promptMask.length), 
                this.escapeMaskValue = this.escapeMaskValue.substring(0, j) + this.escapeMaskValue.substring(i + 1 - escapeNumber, this.escapeMaskValue.length)), 
                "\\" === this.hiddenMask[i] && (this.promptMask = this.promptMask.substring(0, j) + this.hiddenMask[i + 1] + this.promptMask.substring(i + 2 - escapeNumber, this.promptMask.length), 
                this.escapeMaskValue = this.escapeMaskValue.substring(0, j) + this.escapeMaskValue[i + 1] + this.escapeMaskValue.substring(i + 2 - escapeNumber, this.escapeMaskValue.length));
            } else this.promptMask = this.promptMask.replace(/[>|<]/g, ""), this.escapeMaskValue = this.hiddenMask.replace(/[>|<]/g, "");
            attributes(this.element, {
                "aria-invalid": "false"
            });
        }
    }
    function applyMask() {
        setElementValue.call(this, this.promptMask), setMaskValue.call(this, this.value);
    }
    function wireEvents() {
        EventHandler.add(this.element, "keydown", maskInputKeyDownHandler, this), EventHandler.add(this.element, "keypress", maskInputKeyPressHandler, this), 
        EventHandler.add(this.element, "keyup", maskInputKeyUpHandler, this), EventHandler.add(this.element, "focus", maskInputFocusHandler, this), 
        EventHandler.add(this.element, "blur", maskInputBlurHandler, this), EventHandler.add(this.element, "paste", maskInputPasteHandler, this), 
        EventHandler.add(this.element, "cut", maskInputCutHandler, this), EventHandler.add(this.element, "drop", maskInputDropHandler, this);
    }
    function unwireEvents() {
        EventHandler.remove(this.element, "keydown", maskInputKeyDownHandler), EventHandler.remove(this.element, "keypress", maskInputKeyPressHandler), 
        EventHandler.remove(this.element, "keyup", maskInputKeyUpHandler), EventHandler.remove(this.element, "focus", maskInputFocusHandler), 
        EventHandler.remove(this.element, "blur", maskInputBlurHandler), EventHandler.remove(this.element, "paste", maskInputPasteHandler), 
        EventHandler.remove(this.element, "cut", maskInputCutHandler);
    }
    function unstrippedValue(element) {
        return element.value;
    }
    function strippedValue(element) {
        var value = "", k = 0, checkMask = !1;
        if (!isNullOrUndefined(element) && !isNullOrUndefined(this) && element.value !== this.promptMask) for (var i = 0; i < this.customRegExpCollec.length; i++) checkMask && (checkMask = !1), 
        ">" !== this.customRegExpCollec[k] && "<" !== this.customRegExpCollec[k] && "|" !== this.customRegExpCollec[k] && "\\" !== this.customRegExpCollec[k] || (--i, 
        checkMask = !0), checkMask || element.value[i] === this.promptChar || isNullOrUndefined(this.customRegExpCollec[k]) || isNullOrUndefined(this.regExpCollec[this.customRegExpCollec[k]]) && !(this.customRegExpCollec[k].length > 2 && "[" === this.customRegExpCollec[k][0] && "]" === this.customRegExpCollec[k][this.customRegExpCollec[k].length - 1]) && (isNullOrUndefined(this.customCharacters) || isNullOrUndefined(this.customCharacters[this.customRegExpCollec[k]])) || "" === element.value || (value += element.value[i]), 
        ++k;
        return value;
    }
    function pushIntoRegExpCollec(value) {
        for (var k = 0; k < value.length; k++) this.hiddenMask += value[k], "\\" !== value[k] && this.customRegExpCollec.push(value[k]);
    }
    function maskInputFocusHandler(event) {
        var _this = this;
        this.promptMask.length > 0 ? this.focusEventArgs = {
            selectionStart: 0,
            selectionEnd: this.promptMask.length
        } : this.focusEventArgs = {
            selectionStart: 0,
            selectionEnd: this.element.value.length
        };
        var eventArgs = {};
        merge(eventArgs, this.focusEventArgs), this.trigger("focus", eventArgs), this.focusEventArgs = eventArgs, 
        this.mask && (this.isFocus = !0, this.placeholder && "" === this.element.value ? (setElementValue.call(this, this.promptMask), 
        this.element.setSelectionRange(this.focusEventArgs.selectionStart, this.focusEventArgs.selectionEnd), 
        setTimeout(function() {
            _this.element.setSelectionRange(_this.focusEventArgs.selectionStart, _this.focusEventArgs.selectionEnd);
        }, 1)) : this.element.setSelectionRange(this.focusEventArgs.selectionStart, this.focusEventArgs.selectionEnd));
    }
    function maskInputBlurHandler(event) {
        if (this.mask && (this.isFocus = !1, this.placeholder && this.element.value === this.promptMask && "Always" !== this.floatLabelType)) {
            setElementValue.call(this, "");
            var labelElement = this.element.parentNode.querySelector(".e-float-text");
            "Auto" === this.floatLabelType && !isNullOrUndefined(labelElement) && labelElement.classList.contains(TOPLABEL) && removeClass([ labelElement ], TOPLABEL);
        }
    }
    function maskInputPasteHandler(event) {
        var _this = this;
        if (this.mask) {
            var sIndex_1 = this.element.selectionStart, eIndex_1 = this.element.selectionEnd, oldValue_1 = this.element.value;
            setElementValue.call(this, ""), setTimeout(function() {
                var value = _this.element.value;
                _this.redoCollec.length > 0 && _this.redoCollec[0].value === _this.element.value && (value = strippedValue.call(_this, _this.element)), 
                setElementValue.call(_this, oldValue_1), _this.element.selectionStart = sIndex_1, 
                _this.element.selectionEnd = eIndex_1;
                var i = 0;
                _this.maskKeyPress = !0;
                do {
                    validateValue.call(_this, value[i], !1, null), ++i;
                } while (i < value.length);
                _this.maskKeyPress = !1;
            }, 1);
        }
    }
    function maskInputCutHandler(event) {
        var _this = this;
        if (this.mask) {
            var sIndex_2 = this.element.selectionStart, eIndex = this.element.selectionEnd;
            this.undoCollec.push({
                value: this.element.value,
                startIndex: this.element.selectionStart,
                endIndex: this.element.selectionEnd
            });
            var value_1 = this.element.value.substring(0, sIndex_2) + this.promptMask.substring(sIndex_2, eIndex) + this.element.value.substring(eIndex);
            setTimeout(function() {
                setElementValue.call(_this, value_1), _this.element.selectionStart = _this.element.selectionEnd = sIndex_2;
            }, 0);
        }
    }
    function maskInputDropHandler(event) {
        event.preventDefault();
    }
    function maskInputKeyDownHandler(event) {
        var _this = this;
        if (this.mask) {
            229 !== event.keyCode ? (!event.ctrlKey || 89 !== event.keyCode && 90 !== event.keyCode || event.preventDefault(), 
            removeMaskInputValues.call(this, event)) : setTimeout(function() {
                removeMaskInputValues.call(_this, event);
            }, 0);
            var startValue = this.element.value;
            if (event.ctrlKey && (89 === event.keyCode || 90 === event.keyCode)) {
                var collec = void 0;
                90 === event.keyCode && this.undoCollec.length > 0 && startValue !== this.undoCollec[this.undoCollec.length - 1].value ? (collec = this.undoCollec[this.undoCollec.length - 1], 
                this.redoCollec.unshift({
                    value: this.element.value,
                    startIndex: this.element.selectionStart,
                    endIndex: this.element.selectionEnd
                }), setElementValue.call(this, collec.value), this.element.selectionStart = collec.startIndex, 
                this.element.selectionEnd = collec.endIndex, this.undoCollec.splice(this.undoCollec.length - 1, 1)) : 89 === event.keyCode && this.redoCollec.length > 0 && startValue !== this.redoCollec[0].value && (collec = this.redoCollec[0], 
                this.undoCollec.push({
                    value: this.element.value,
                    startIndex: this.element.selectionStart,
                    endIndex: this.element.selectionEnd
                }), setElementValue.call(this, collec.value), this.element.selectionStart = collec.startIndex, 
                this.element.selectionEnd = collec.endIndex, this.redoCollec.splice(0, 1));
            }
        }
    }
    function mobileRemoveFunction() {
        var collec, sIndex = this.element.selectionStart, eIndex = this.element.selectionEnd;
        this.redoCollec.length > 0 ? (collec = this.redoCollec[0], setElementValue.call(this, collec.value), 
        collec.startIndex - sIndex == 1 ? (this.element.selectionStart = collec.startIndex, 
        this.element.selectionEnd = collec.endIndex) : (this.element.selectionStart = sIndex + 1, 
        this.element.selectionEnd = eIndex + 1)) : (setElementValue.call(this, this.promptMask), 
        this.element.selectionStart = this.element.selectionEnd = sIndex);
    }
    function removeMaskInputValues(event) {
        var oldEventVal, isRemove = !1, isDeleted = !1;
        this.element.value.length < this.promptMask.length && (isRemove = !0, mobileRemoveFunction.call(this), 
        oldEventVal = this.element.value);
        var initStartIndex = this.element.selectionStart, initEndIndex = this.element.selectionEnd, startIndex = this.element.selectionStart, endIndex = this.element.selectionEnd, maskValue = this.hiddenMask.replace(/[>|\\<]/g, ""), curMask = maskValue[startIndex - 1];
        this.element.parentNode;
        if (isRemove || 8 === event.keyCode || 46 === event.keyCode) {
            this.undoCollec.push({
                value: this.element.value,
                startIndex: this.element.selectionStart,
                endIndex: endIndex
            });
            var multipleDel = !1;
            if (startIndex > 0 || (8 === event.keyCode || 46 === event.keyCode) && startIndex < this.element.value.length && this.element.selectionEnd - startIndex !== this.element.value.length) {
                var index = startIndex;
                startIndex !== endIndex ? (startIndex = endIndex, 46 === event.keyCode && (multipleDel = !0)) : 46 === event.keyCode ? ++index : --index;
                for (var k = startIndex; 8 === event.keyCode || isRemove || multipleDel ? k > index : k < index; 8 === event.keyCode || isRemove || multipleDel ? k-- : k++) for (var i = startIndex; 8 === event.keyCode || isRemove || multipleDel ? i > 0 : i < this.element.value.length; 8 === event.keyCode || isRemove || multipleDel ? i-- : i++) {
                    var sIndex = void 0;
                    (8 === event.keyCode || multipleDel) && (initStartIndex !== initEndIndex && initStartIndex !== startIndex || initStartIndex === initEndIndex) || isRemove ? (curMask = maskValue[i - 1], 
                    sIndex = startIndex - 1) : (curMask = maskValue[i], sIndex = startIndex, ++startIndex);
                    var oldValue = this.element.value[sIndex];
                    if (isNullOrUndefined(this.regExpCollec[curMask]) && !isNullOrUndefined(this.customCharacters) && isNullOrUndefined(this.customCharacters[curMask]) && this.hiddenMask[sIndex] !== this.promptChar && "[" !== this.customRegExpCollec[sIndex][0] && "]" !== this.customRegExpCollec[sIndex][this.customRegExpCollec[sIndex].length - 1] || this.promptMask[sIndex] !== this.promptChar && isNullOrUndefined(this.customCharacters)) this.element.selectionStart = this.element.selectionEnd = sIndex, 
                    event.preventDefault(), 46 !== event.keyCode || multipleDel || ++this.element.selectionStart; else {
                        var value = this.element.value, prompt_1 = this.promptChar, elementValue = value.substring(0, sIndex) + prompt_1 + value.substring(startIndex, value.length);
                        setElementValue.call(this, elementValue), event.preventDefault(), this.element.selectionStart = this.element.selectionEnd = sIndex, 
                        isDeleted = !0;
                    }
                    if (startIndex = this.element.selectionStart, !isDeleted && 8 === event.keyCode || multipleDel || !isDeleted && 46 !== event.keyCode ? sIndex = startIndex - 1 : (sIndex = startIndex, 
                    isDeleted = !1), oldValue = this.element.value[sIndex], initStartIndex !== initEndIndex && this.element.selectionStart === initStartIndex || this.promptMask[sIndex] === this.promptChar || oldValue !== this.promptMask[sIndex] && this.promptMask[sIndex] !== this.promptChar && !isNullOrUndefined(this.customCharacters)) break;
                }
            }
            0 === this.element.selectionStart && this.element.selectionEnd === this.element.value.length && (setElementValue.call(this, this.promptMask), 
            event.preventDefault(), this.element.selectionStart = this.element.selectionEnd = startIndex), 
            this.redoCollec.unshift({
                value: this.element.value,
                startIndex: this.element.selectionStart,
                endIndex: this.element.selectionEnd
            }), triggerMaskChangeEvent.call(this, event, oldEventVal);
        }
    }
    function maskInputKeyPressHandler(event) {
        if (this.mask) {
            var oldValue = this.element.value;
            if (!event.ctrlKey || event.ctrlKey && "KeyA" !== event.code && "KeyY" !== event.code && "KeyZ" !== event.code && "KeyX" !== event.code && "KeyC" !== event.code && "KeyV" !== event.code) {
                this.maskKeyPress = !0;
                var key = event.key;
                "Spacebar" === key && (key = String.fromCharCode(event.keyCode)), key ? key && 1 === key.length && (validateValue.call(this, key, event.ctrlKey, event), 
                event.preventDefault()) : (this.isIosInvalid = !0, validateValue.call(this, String.fromCharCode(event.keyCode), event.ctrlKey, event), 
                event.preventDefault(), this.isIosInvalid = !1);
            }
            triggerMaskChangeEvent.call(this, event, oldValue);
        }
    }
    function triggerMaskChangeEvent(event, oldValue) {
        if (!isNullOrUndefined(this.changeEventArgs)) {
            var eventArgs = {};
            this.changeEventArgs = {
                value: this.element.value,
                maskedValue: this.element.value,
                isInteraction: !1
            }, this.mask && (this.changeEventArgs.value = strippedValue.call(this, this.element)), 
            isNullOrUndefined(event) || (this.changeEventArgs.isInteraction = !0, this.changeEventArgs.event = event), 
            merge(eventArgs, this.changeEventArgs), this.trigger("change", eventArgs);
        }
        attributes(this.element, {
            "aria-valuenow": this.element.value
        });
    }
    function maskInputKeyUpHandler(event) {
        if (this.mask) {
            var collec = void 0;
            if (this.maskKeyPress || 229 !== event.keyCode) removeMaskError.call(this); else {
                var oldEventVal = void 0;
                if (1 === this.element.value.length && (this.element.value = this.element.value + this.promptMask, 
                this.element.setSelectionRange(1, 1)), this.element.value.length > this.promptMask.length) {
                    var startIndex = this.element.selectionStart, addedValues = this.element.value.length - this.promptMask.length, val_1 = this.element.value.substring(startIndex - addedValues, startIndex);
                    if (this.undoCollec.length > 0) {
                        collec = this.undoCollec[this.undoCollec.length - 1];
                        var startIndex_1 = this.element.selectionStart;
                        oldEventVal = collec.value;
                        var oldVal = collec.value.substring(startIndex_1 - addedValues, startIndex_1);
                        collec = this.redoCollec[0], val_1 = val_1.trim();
                        var isSpace = Browser.isAndroid && "" === val_1;
                        isSpace || oldVal === val_1 || collec.value.substring(startIndex_1 - addedValues, startIndex_1) === val_1 ? isSpace && preventUnsupportedValues.call(this, event, startIndex_1 - 1, this.element.selectionEnd - 1, val_1, event.ctrlKey, !1) : validateValue.call(this, val_1, event.ctrlKey, event);
                    } else oldEventVal = this.promptMask, validateValue.call(this, val_1, event.ctrlKey, event);
                    this.maskKeyPress = !1, triggerMaskChangeEvent.call(this, event, oldEventVal);
                }
            }
            var val = strippedValue.call(this, this.element);
            (0 !== this.element.selectionStart || this.promptMask !== this.element.value || "" !== val || "" === val && this.value !== val) && (this.prevValue = val, 
            this.value = val);
        } else triggerMaskChangeEvent.call(this, event), this.value = this.element.value;
    }
    function validateValue(key, isCtrlKey, event) {
        this.maskKeyPress || function(key) {
            if (key.length > 1 && this.promptMask.length + key.length < this.element.value.length) {
                var elementValue = this.redoCollec[0].value.substring(0, this.redoCollec[0].startIndex) + key + this.redoCollec[0].value.substring(this.redoCollec[0].startIndex, this.redoCollec[0].value.length);
                setElementValue.call(this, elementValue), this.element.selectionStart = this.element.selectionEnd = this.redoCollec[0].startIndex + key.length;
            }
            this.element.selectionStart = this.element.selectionStart - key.length, this.element.selectionEnd = this.element.selectionEnd - key.length;
        }.call(this, key);
        for (var curMask, eventOldVal, startIndex = this.element.selectionStart, initStartIndex = startIndex, allowText = (this.element.selectionEnd, 
        !1), value = this.element.value, prevSupport = !1, isEqualVal = !1, k = 0; k < key.length; k++) {
            var keyValue = key[k];
            if (startIndex = this.element.selectionStart, this.element.selectionEnd, this.maskKeyPress || initStartIndex !== startIndex || (startIndex += k), 
            !this.maskKeyPress || startIndex < this.promptMask.length) {
                for (var i = startIndex; i < this.promptMask.length; i++) {
                    curMask = this.escapeMaskValue[startIndex], "\\" === this.hiddenMask[startIndex] && this.hiddenMask[startIndex + 1] === key && (isEqualVal = !0), 
                    (isNullOrUndefined(this.regExpCollec[curMask]) && (isNullOrUndefined(this.customCharacters) || !isNullOrUndefined(this.customCharacters) && isNullOrUndefined(this.customCharacters[curMask])) && this.hiddenMask[startIndex] !== this.promptChar && "[" !== this.customRegExpCollec[startIndex][0] && "]" !== this.customRegExpCollec[startIndex][this.customRegExpCollec[startIndex].length - 1] || this.promptMask[startIndex] !== this.promptChar && isNullOrUndefined(this.customCharacters) || this.promptChar === curMask && this.escapeMaskValue === this.mask) && (this.element.selectionStart = this.element.selectionEnd = startIndex + 1, 
                    startIndex = this.element.selectionStart, curMask = this.hiddenMask[startIndex]);
                }
                if (isNullOrUndefined(this.customCharacters) || isNullOrUndefined(this.customCharacters[curMask])) !isNullOrUndefined(this.regExpCollec[curMask]) && keyValue.match(new RegExp(this.regExpCollec[curMask])) && this.promptMask[startIndex] === this.promptChar ? allowText = !0 : this.promptMask[startIndex] === this.promptChar && "[" === this.customRegExpCollec[startIndex][0] && "]" === this.customRegExpCollec[startIndex][this.customRegExpCollec[startIndex].length - 1] && keyValue.match(new RegExp(this.customRegExpCollec[startIndex])) && (allowText = !0); else {
                    var customValArr = this.customCharacters[curMask].split(",");
                    for (i = 0; i < customValArr.length; i++) if (keyValue.match(new RegExp("[" + customValArr[i] + "]"))) {
                        allowText = !0;
                        break;
                    }
                }
                if ((!this.maskKeyPress || startIndex < this.hiddenMask.length) && allowText) {
                    if (0 === k) if (this.maskKeyPress) this.undoCollec.push({
                        value: value,
                        startIndex: startIndex,
                        endIndex: startIndex
                    }); else {
                        var sIndex = this.element.selectionStart, eIndex = this.element.selectionEnd;
                        this.redoCollec.length > 0 ? (eventOldVal = this.redoCollec[0].value, setElementValue.call(this, eventOldVal), 
                        this.undoCollec.push(this.redoCollec[0])) : (this.undoCollec.push({
                            value: this.promptMask,
                            startIndex: startIndex,
                            endIndex: startIndex
                        }), eventOldVal = this.promptMask, setElementValue.call(this, eventOldVal)), this.element.selectionStart = sIndex, 
                        this.element.selectionEnd = eIndex;
                    }
                    startIndex = this.element.selectionStart, function(event, startIndex, keyValue, eventOldVal, isEqualVal) {
                        this.hiddenMask.length > this.promptMask.length && (keyValue = function(key, value) {
                            var promptMask, i, curVal = value, caseCount = 0;
                            for (i = 0; i < this.hiddenMask.length; i++) if ("\\" === this.hiddenMask[i] && (promptMask = curVal.substring(0, i) + "\\" + curVal.substring(i, curVal.length)), 
                            ">" !== this.hiddenMask[i] && "<" !== this.hiddenMask[i] && "|" !== this.hiddenMask[i] || (this.hiddenMask[i] !== curVal[i] && (promptMask = curVal.substring(0, i) + this.hiddenMask[i] + curVal.substring(i, curVal.length)), 
                            ++caseCount), promptMask) {
                                if (promptMask[i] === this.promptChar && i > this.element.selectionStart || this.element.value.indexOf(this.promptChar) < 0 && this.element.selectionStart + caseCount === i) {
                                    caseCount = 0;
                                    break;
                                }
                                curVal = promptMask;
                            }
                            for (;i >= 0 && promptMask; ) {
                                if (0 === i || "\\" !== promptMask[i - 1]) {
                                    this.element.value;
                                    if (">" === promptMask[i]) {
                                        key = key.toUpperCase();
                                        break;
                                    }
                                    if ("<" === promptMask[i]) {
                                        key = key.toLowerCase();
                                        break;
                                    }
                                    if ("|" === promptMask[i]) break;
                                }
                                --i;
                            }
                            return key;
                        }.call(this, keyValue, this.element.value));
                        if (!isEqualVal) {
                            var value = this.element.value, elementValue = value.substring(0, startIndex) + keyValue + value.substring(startIndex + 1, value.length);
                            setElementValue.call(this, elementValue), this.element.selectionStart = this.element.selectionEnd = startIndex + 1;
                        }
                        triggerMaskChangeEvent.call(this, event, eventOldVal);
                    }.call(this, event, startIndex, keyValue, eventOldVal, isEqualVal), prevSupport = !0, 
                    k === key.length - 1 && this.redoCollec.unshift({
                        value: this.element.value,
                        startIndex: this.element.selectionStart,
                        endIndex: this.element.selectionEnd
                    }), allowText = !1;
                } else startIndex = this.element.selectionStart, preventUnsupportedValues.call(this, event, startIndex, initStartIndex, key, isCtrlKey, prevSupport);
                k !== key.length - 1 || allowText || (!Browser.isAndroid || Browser.isAndroid && startIndex < this.promptMask.length) && this.redoCollec.unshift({
                    value: this.element.value,
                    startIndex: this.element.selectionStart,
                    endIndex: this.element.selectionEnd
                });
            } else 1 !== key.length || isCtrlKey || isNullOrUndefined(event) || addMaskErrorClass.call(this);
        }
    }
    function preventUnsupportedValues(event, sIdx, idx, key, ctrl, chkSupport) {
        if (!this.maskKeyPress) {
            var eventOldVal = void 0, value = this.element.value;
            sIdx >= this.promptMask.length ? setElementValue.call(this, value.substring(0, sIdx)) : (idx === sIdx ? setElementValue.call(this, value.substring(0, sIdx) + value.substring(sIdx + 1, value.length)) : this.promptMask.length === this.element.value.length ? setElementValue.call(this, value.substring(0, sIdx) + value.substring(sIdx, value.length)) : setElementValue.call(this, value.substring(0, idx) + value.substring(idx + 1, value.length)), 
            this.element.selectionStart = this.element.selectionEnd = chkSupport || this.element.value[idx] !== this.promptChar ? sIdx : idx), 
            eventOldVal = this.element.value, triggerMaskChangeEvent.call(this, event, eventOldVal), 
            addMaskErrorClass.call(this);
        }
        1 !== key.length || ctrl || isNullOrUndefined(event) || addMaskErrorClass.call(this);
    }
    function addMaskErrorClass() {
        var _this = this, parentElement = this.element.parentNode, timer = 200;
        parentElement.classList.contains(INPUTGROUP) || parentElement.classList.contains(FLOATINPUT) ? addClass([ parentElement ], ERROR$1) : addClass([ this.element ], ERROR$1), 
        !0 === this.isIosInvalid && (timer = 400), attributes(this.element, {
            "aria-invalid": "true"
        }), setTimeout(function() {
            _this.maskKeyPress || removeMaskError.call(_this);
        }, timer);
    }
    function removeMaskError() {
        removeClass([ this.element.parentNode ], ERROR$1), removeClass([ this.element ], ERROR$1), 
        attributes(this.element, {
            "aria-invalid": "false"
        });
    }
    function setMaskValue(val) {
        if (this.mask && !isNullOrUndefined(val) && ("" === val || this.prevValue !== val)) {
            this.maskKeyPress = !0, setElementValue.call(this, this.promptMask), "" !== val && (this.element.selectionStart = 0, 
            this.element.selectionEnd = 0);
            for (var i = 0; i < val.length; i++) validateValue.call(this, val[i], !1, null);
            this.value = strippedValue.call(this, this.element), this.maskKeyPress = !1;
            var labelElement = this.element.parentNode.querySelector(".e-float-text");
            this.element.value !== this.promptMask || "Auto" !== this.floatLabelType || isNullOrUndefined(labelElement) || !labelElement.classList.contains(TOPLABEL) || this.isFocus || (removeClass([ labelElement ], TOPLABEL), 
            addClass([ labelElement ], BOTTOMLABEL), setElementValue.call(this, ""));
        }
    }
    function setElementValue(val, element) {
        !this.isFocus && "Auto" === this.floatLabelType && isNullOrUndefined(this.value) && (val = ""), 
        Input.setValue(val, element || this.element, this.floatLabelType);
    }
    function getMaskInput(args) {
        addClass([ args.element ], UTILMASK);
        var inputEle = {
            element: args.element,
            mask: args.mask,
            promptMask: "",
            hiddenMask: "",
            escapeMaskValue: "",
            promptChar: args.promptChar ? args.promptChar.length > 1 ? args.promptChar = args.promptChar[0] : args.promptChar : "_",
            value: args.value ? args.value : null,
            regExpCollec: regularExpressions,
            customRegExpCollec: [],
            customCharacters: args.customCharacters,
            undoCollec: [],
            redoCollec: [],
            maskKeyPress: !1,
            prevValue: ""
        };
        return createMask.call(inputEle), inputEle;
    }
    function getUtilMaskEle(args) {
        var inputEle;
        return !isNullOrUndefined(args) && args.element.classList.contains(UTILMASK) && (inputEle = getMaskInput(args)), 
        inputEle;
    }
    function Search(inputVal, items, searchType, ignoreCase) {
        var listItems = items;
        ignoreCase = void 0 === ignoreCase || null === ignoreCase || ignoreCase;
        var itemData = {
            item: null,
            index: null
        };
        if (inputVal.length) {
            for (var strLength = inputVal.length, queryStr = ignoreCase ? inputVal.toLocaleLowerCase() : inputVal, i = 0, itemsData = listItems; i < itemsData.length; i++) {
                var item = itemsData[i], text = (ignoreCase ? item.textContent.toLocaleLowerCase() : item.textContent).replace(/^\s+|\s+$/g, "");
                if ("Equal" === searchType && text === queryStr || "StartsWith" === searchType && text.substr(0, strLength) === queryStr) return itemData.item = item, 
                itemData.index = i, {
                    item: item,
                    index: i
                };
            }
            return itemData;
        }
        return itemData;
    }
    function getFieldValues(dataItem, fields) {
        var value, fieldData = {};
        if (isNullOrUndefined(dataItem)) return dataItem;
        if ("string" == typeof dataItem || "number" == typeof dataItem) return dataItem;
        if (isNullOrUndefined(dataItem.isHeader)) for (var _i = 0, _a = Object.keys(fields); _i < _a.length; _i++) {
            var field = _a[_i];
            if (!isNullOrUndefined(fields[field]) && "string" == typeof fields[field]) {
                var property = fields[field].split(".");
                isNullOrUndefined(dataItem[property.length > 1 ? property[0] : fields[field]]) || isNullOrUndefined(value = getValue(fields[field], dataItem)) || (fieldData[fields[field]] = value);
            }
        } else !isNullOrUndefined(dataItem.isHeader) && dataItem.isHeader && (fieldData = dataItem);
        return fieldData;
    }
    function highlightSearch(content, query, ignoreCase, type) {
        if (function(content) {
            for (var contentElement = content.querySelectorAll(".e-highlight"), i = contentElement.length - 1; i >= 0; i--) {
                var parent_1 = contentElement[i].parentNode, text = document.createTextNode(contentElement[i].textContent);
                parent_1.replaceChild(text, contentElement[i]);
            }
        }(content), "" !== query) {
            var ignoreRegex = ignoreCase ? "gim" : "gm";
            query = /^[a-zA-Z0-9- ]*$/.test(query) ? query : query.replace(/[\-\[\]\/\{\}\(\)\*\+\?\.\\\^\$\|]/g, "\\$&");
            for (var replaceQuery = "StartsWith" === type ? "^(" + query + ")" : "EndsWith" === type ? "(" + query + ")$" : "(" + query + ")", pattern = new RegExp(replaceQuery, ignoreRegex), li = content.querySelectorAll("ul li"), i = 0; i < li.length; i++) {
                var element = li[i];
                element.innerHTML = element.innerHTML.replace(pattern, '<span class="e-highlight">$1</span>');
            }
        }
    }
    function wrapperInitialize$1(tag, type, element, WRAPPER) {
        if (element.tagName === tag) {
            for (var ejInstance = getValue("ej2_instances", element), input = createElement("input", {
                attrs: {
                    type: type
                }
            }), props = [ "change", "cssClass", "label", "labelPosition" ], wrapper = createElement(tag, {
                className: WRAPPER,
                attrs: {
                    role: type,
                    "aria-checked": "false"
                }
            }), index = 0, len = element.attributes.length; index < len; index++) -1 === props.indexOf(element.attributes[index].nodeName) && input.setAttribute(element.attributes[index].nodeName, element.attributes[index].nodeValue);
            element.parentNode.insertBefore(input, element), detach(element), (element = input).parentNode.insertBefore(wrapper, element), 
            wrapper.appendChild(element), setValue("ej2_instances", ejInstance, element);
        }
        return element;
    }
    function getTextNode$1(element) {
        for (var node, childnode = element.childNodes, i = 0; i < childnode.length; i++) if (3 === (node = childnode[i]).nodeType) return node;
        return null;
    }
    function rippleMouseHandler$1(e, rippleSpan) {
        if (rippleSpan) {
            var event_1 = document.createEvent("MouseEvents");
            event_1.initEvent(e.type, !1, !0), rippleSpan.dispatchEvent(event_1);
        }
    }
    function calculatePosition$1(currentElement, positionX, positionY, parentElement) {
        if (fixedParent$1 = !!parentElement, !currentElement) return {
            left: 0,
            top: 0
        };
        positionX || (positionX = "left"), positionY || (positionY = "top"), parentDocument$1$1 = currentElement.ownerDocument, 
        element$1 = currentElement;
        return function(posX, posY, pos) {
            switch (elementRect$1 = element$1.getBoundingClientRect(), posY + posX) {
              case "topcenter":
                setPosx$1(getElementHCenter$1(), pos), setPosy$1(getElementTop$1(), pos);
                break;

              case "topright":
                setPosx$1(getElementRight$1(), pos), setPosy$1(getElementTop$1(), pos);
                break;

              case "centercenter":
                setPosx$1(getElementHCenter$1(), pos), setPosy$1(getElementVCenter$1(), pos);
                break;

              case "centerright":
                setPosx$1(getElementRight$1(), pos), setPosy$1(getElementVCenter$1(), pos);
                break;

              case "centerleft":
                setPosx$1(getElementLeft$1(), pos), setPosy$1(getElementVCenter$1(), pos);
                break;

              case "bottomcenter":
                setPosx$1(getElementHCenter$1(), pos), setPosy$1(getElementBottom$1(), pos);
                break;

              case "bottomright":
                setPosx$1(getElementRight$1(), pos), setPosy$1(getElementBottom$1(), pos);
                break;

              case "bottomleft":
                setPosx$1(getElementLeft$1(), pos), setPosy$1(getElementBottom$1(), pos);
                break;

              default:
              case "topleft":
                setPosx$1(getElementLeft$1(), pos), setPosy$1(getElementTop$1(), pos);
            }
            return pos;
        }(positionX.toLowerCase(), positionY.toLowerCase(), {
            left: 0,
            top: 0
        });
    }
    function setPosx$1(value, pos) {
        pos.left = value;
    }
    function setPosy$1(value, pos) {
        pos.top = value;
    }
    function getBodyScrollTop$1$1() {
        return parentDocument$1$1.documentElement.scrollTop || parentDocument$1$1.body.scrollTop;
    }
    function getBodyScrollLeft$1$1() {
        return parentDocument$1$1.documentElement.scrollLeft || parentDocument$1$1.body.scrollLeft;
    }
    function getElementBottom$1() {
        return fixedParent$1 ? elementRect$1.bottom : elementRect$1.bottom + getBodyScrollTop$1$1();
    }
    function getElementVCenter$1() {
        return getElementTop$1() + elementRect$1.height / 2;
    }
    function getElementTop$1() {
        return fixedParent$1 ? elementRect$1.top : elementRect$1.top + getBodyScrollTop$1$1();
    }
    function getElementLeft$1() {
        return elementRect$1.left + getBodyScrollLeft$1$1();
    }
    function getElementRight$1() {
        return elementRect$1.right + getBodyScrollLeft$1$1();
    }
    function getElementHCenter$1() {
        return getElementLeft$1() + elementRect$1.width / 2;
    }
    function flip$1(element, target, offsetX, offsetY, positionX, positionY, viewPortElement, axis, fixedParent) {
        if (void 0 === viewPortElement && (viewPortElement = null), void 0 === axis && (axis = {
            X: !0,
            Y: !0
        }), target && element && positionX && positionY && (axis.X || axis.Y)) {
            var tEdge = {
                TL: null,
                TR: null,
                BL: null,
                BR: null
            }, eEdge = {
                TL: null,
                TR: null,
                BL: null,
                BR: null
            }, elementRect = element.getBoundingClientRect(), pos = {
                posX: positionX,
                posY: positionY,
                offsetX: offsetX,
                offsetY: offsetY,
                position: {
                    left: 0,
                    top: 0
                }
            };
            targetContainer$1 = viewPortElement, parentDocument$2 = target.ownerDocument, function(target, edge, pos, fixedParent) {
                pos.position = calculatePosition$1(target, pos.posX, pos.posY, fixedParent), edge.TL = calculatePosition$1(target, "left", "top", fixedParent), 
                edge.TR = calculatePosition$1(target, "right", "top", fixedParent), edge.BR = calculatePosition$1(target, "left", "bottom", fixedParent), 
                edge.BL = calculatePosition$1(target, "right", "bottom", fixedParent);
            }(target, tEdge, pos, fixedParent), setPosition$1(eEdge, pos, elementRect), axis.X && leftFlip$1(target, eEdge, tEdge, pos, elementRect, !0), 
            axis.Y && tEdge.TL.top > -1 && topFlip$1(target, eEdge, tEdge, pos, elementRect, !0), 
            function(element, pos) {
                var left = 0, top = 0;
                if (null != element.offsetParent && ("absolute" === getComputedStyle(element.offsetParent).position || "relative" === getComputedStyle(element.offsetParent).position)) {
                    var data = calculatePosition$1(element.offsetParent, "left", "top");
                    left = data.left, top = data.top;
                }
                element.style.top = pos.position.top + pos.offsetY - top + "px", element.style.left = pos.position.left + pos.offsetX - left + "px";
            }(element, pos);
        }
    }
    function setPosition$1(eStatus, pos, elementRect) {
        eStatus.TL = {
            top: pos.position.top + pos.offsetY,
            left: pos.position.left + pos.offsetX
        }, eStatus.TR = {
            top: eStatus.TL.top,
            left: eStatus.TL.left + elementRect.width
        }, eStatus.BL = {
            top: eStatus.TL.top + elementRect.height,
            left: eStatus.TL.left
        }, eStatus.BR = {
            top: eStatus.TL.top + elementRect.height,
            left: eStatus.TL.left + elementRect.width
        };
    }
    function leftCollideCheck$1(left, right) {
        var leftSide = !1, rightSide = !1;
        return left - getBodyScrollLeft$2() < ContainerLeft$1() && (leftSide = !0), right > ContainerRight$1() && (rightSide = !0), 
        {
            leftSide: leftSide,
            rightSide: rightSide
        };
    }
    function leftFlip$1(target, edge, tEdge, pos, elementRect, deepCheck) {
        var collideSide = leftCollideCheck$1(edge.TL.left, edge.TR.left);
        tEdge.TL.left - getBodyScrollLeft$2() <= ContainerLeft$1() && (collideSide.leftSide = !1), 
        tEdge.TR.left >= ContainerRight$1() && (collideSide.rightSide = !1), (collideSide.leftSide && !collideSide.rightSide || !collideSide.leftSide && collideSide.rightSide) && ("right" === pos.posX ? pos.posX = "left" : pos.posX = "right", 
        pos.offsetX = pos.offsetX + elementRect.width, pos.offsetX = -1 * pos.offsetX, pos.position = calculatePosition$1(target, pos.posX, pos.posY), 
        setPosition$1(edge, pos, elementRect), deepCheck && leftFlip$1(target, edge, tEdge, pos, elementRect, !1));
    }
    function topFlip$1(target, edge, tEdge, pos, elementRect, deepCheck) {
        var collideSide = topCollideCheck$1(edge.TL.top, edge.BL.top);
        tEdge.TL.top - getBodyScrollTop$2() <= ContainerTop$1() && (collideSide.topSide = !1), 
        tEdge.BL.top >= ContainerBottom$1() && (collideSide.bottomSide = !1), (collideSide.topSide && !collideSide.bottomSide || !collideSide.topSide && collideSide.bottomSide) && ("top" === pos.posY ? pos.posY = "bottom" : pos.posY = "top", 
        pos.offsetY = pos.offsetY + elementRect.height, pos.offsetY = -1 * pos.offsetY, 
        pos.position = calculatePosition$1(target, pos.posX, pos.posY), setPosition$1(edge, pos, elementRect), 
        deepCheck && topFlip$1(target, edge, tEdge, pos, elementRect, !1));
    }
    function topCollideCheck$1(top, bottom) {
        var topSide = !1, bottomSide = !1;
        return top - getBodyScrollTop$2() < ContainerTop$1() && (topSide = !0), bottom > ContainerBottom$1() && (bottomSide = !0), 
        {
            topSide: topSide,
            bottomSide: bottomSide
        };
    }
    function getTargetContainerWidth$1() {
        return targetContainer$1.getBoundingClientRect().width;
    }
    function getTargetContainerHeight$1() {
        return targetContainer$1.getBoundingClientRect().height;
    }
    function getTargetContainerLeft$1() {
        return targetContainer$1.getBoundingClientRect().left;
    }
    function getTargetContainerTop$1() {
        return targetContainer$1.getBoundingClientRect().top;
    }
    function ContainerTop$1() {
        return targetContainer$1 ? getTargetContainerTop$1() : 0;
    }
    function ContainerLeft$1() {
        return targetContainer$1 ? getTargetContainerLeft$1() : 0;
    }
    function ContainerRight$1() {
        return targetContainer$1 ? getBodyScrollLeft$2() + getTargetContainerLeft$1() + getTargetContainerWidth$1() : getBodyScrollLeft$2() + getViewPortWidth$1();
    }
    function ContainerBottom$1() {
        return targetContainer$1 ? getBodyScrollTop$2() + getTargetContainerTop$1() + getTargetContainerHeight$1() : getBodyScrollTop$2() + getViewPortHeight$1();
    }
    function getBodyScrollTop$2() {
        return parentDocument$2.documentElement.scrollTop || parentDocument$2.body.scrollTop;
    }
    function getBodyScrollLeft$2() {
        return parentDocument$2.documentElement.scrollLeft || parentDocument$2.body.scrollLeft;
    }
    function getViewPortHeight$1() {
        return window.innerHeight;
    }
    function getViewPortWidth$1() {
        return window.innerWidth;
    }
    function getZindexPartial$1(element) {
        for (var parent = element.parentElement, parentZindex = []; parent && "BODY" !== parent.tagName; ) {
            var index = document.defaultView.getComputedStyle(parent, null).getPropertyValue("z-index"), position = document.defaultView.getComputedStyle(parent, null).getPropertyValue("position");
            "auto" !== index && "static" !== position && parentZindex.push(index), parent = parent.parentElement;
        }
        for (var childrenZindex = [], i = 0; i < document.body.children.length; i++) if (!element.isEqualNode(document.body.children[i])) {
            index = document.defaultView.getComputedStyle(document.body.children[i], null).getPropertyValue("z-index"), 
            position = document.defaultView.getComputedStyle(document.body.children[i], null).getPropertyValue("position");
            "auto" !== index && "static" !== position && childrenZindex.push(index);
        }
        childrenZindex.push("999");
        var finalValue = parentZindex.concat(childrenZindex);
        return Math.max.apply(Math, finalValue) + 1;
    }
    function getModel(props, model) {
        for (var obj = extend({}, props), _i = 0, _a = Object.keys(obj); _i < _a.length; _i++) {
            var prop = _a[_i];
            model.indexOf(prop) < 0 && deleteObject(obj, prop);
        }
        return obj;
    }
    function unwireEvents$1() {
        EventHandler.remove(this.element, "keydown", maskInputKeyDownHandler$1), EventHandler.remove(this.element, "keypress", maskInputKeyPressHandler$1), 
        EventHandler.remove(this.element, "keyup", maskInputKeyUpHandler$1), EventHandler.remove(this.element, "focus", maskInputFocusHandler$1), 
        EventHandler.remove(this.element, "blur", maskInputBlurHandler$1), EventHandler.remove(this.element, "paste", maskInputPasteHandler$1), 
        EventHandler.remove(this.element, "cut", maskInputCutHandler$1);
    }
    function strippedValue$1(element) {
        var value = "", k = 0, checkMask = !1;
        if (!isNullOrUndefined(element) && !isNullOrUndefined(this) && element.value !== this.promptMask) for (var i = 0; i < this.customRegExpCollec.length; i++) checkMask && (checkMask = !1), 
        ">" !== this.customRegExpCollec[k] && "<" !== this.customRegExpCollec[k] && "|" !== this.customRegExpCollec[k] && "\\" !== this.customRegExpCollec[k] || (--i, 
        checkMask = !0), checkMask || element.value[i] === this.promptChar || isNullOrUndefined(this.customRegExpCollec[k]) || isNullOrUndefined(this.regExpCollec[this.customRegExpCollec[k]]) && !(this.customRegExpCollec[k].length > 2 && "[" === this.customRegExpCollec[k][0] && "]" === this.customRegExpCollec[k][this.customRegExpCollec[k].length - 1]) && (isNullOrUndefined(this.customCharacters) || isNullOrUndefined(this.customCharacters[this.customRegExpCollec[k]])) || "" === element.value || (value += element.value[i]), 
        ++k;
        return value;
    }
    function pushIntoRegExpCollec$1(value) {
        for (var k = 0; k < value.length; k++) this.hiddenMask += value[k], "\\" !== value[k] && this.customRegExpCollec.push(value[k]);
    }
    function maskInputFocusHandler$1(event) {
        var _this = this;
        this.promptMask.length > 0 ? this.focusEventArgs = {
            selectionStart: 0,
            selectionEnd: this.promptMask.length
        } : this.focusEventArgs = {
            selectionStart: 0,
            selectionEnd: this.element.value.length
        };
        var eventArgs = {};
        merge(eventArgs, this.focusEventArgs), this.trigger("focus", eventArgs), this.focusEventArgs = eventArgs, 
        this.mask && (this.isFocus = !0, this.placeholder && "" === this.element.value ? (setElementValue$1.call(this, this.promptMask), 
        this.element.setSelectionRange(this.focusEventArgs.selectionStart, this.focusEventArgs.selectionEnd), 
        setTimeout(function() {
            _this.element.setSelectionRange(_this.focusEventArgs.selectionStart, _this.focusEventArgs.selectionEnd);
        }, 1)) : this.element.setSelectionRange(this.focusEventArgs.selectionStart, this.focusEventArgs.selectionEnd));
    }
    function maskInputBlurHandler$1(event) {
        if (this.mask && (this.isFocus = !1, this.placeholder && this.element.value === this.promptMask && "Always" !== this.floatLabelType)) {
            setElementValue$1.call(this, "");
            var labelElement = this.element.parentNode.querySelector(".e-float-text");
            "Auto" === this.floatLabelType && !isNullOrUndefined(labelElement) && labelElement.classList.contains(TOPLABEL$1) && removeClass([ labelElement ], TOPLABEL$1);
        }
    }
    function maskInputPasteHandler$1(event) {
        var _this = this;
        if (this.mask) {
            var sIndex_1 = this.element.selectionStart, eIndex_1 = this.element.selectionEnd, oldValue_1 = this.element.value;
            setElementValue$1.call(this, ""), setTimeout(function() {
                var value = _this.element.value;
                _this.redoCollec.length > 0 && _this.redoCollec[0].value === _this.element.value && (value = strippedValue$1.call(_this, _this.element)), 
                setElementValue$1.call(_this, oldValue_1), _this.element.selectionStart = sIndex_1, 
                _this.element.selectionEnd = eIndex_1;
                var i = 0;
                _this.maskKeyPress = !0;
                do {
                    validateValue$1.call(_this, value[i], !1, null), ++i;
                } while (i < value.length);
                _this.maskKeyPress = !1;
            }, 1);
        }
    }
    function maskInputCutHandler$1(event) {
        var _this = this;
        if (this.mask) {
            var sIndex_2 = this.element.selectionStart, eIndex = this.element.selectionEnd;
            this.undoCollec.push({
                value: this.element.value,
                startIndex: this.element.selectionStart,
                endIndex: this.element.selectionEnd
            });
            var value_1 = this.element.value.substring(0, sIndex_2) + this.promptMask.substring(sIndex_2, eIndex) + this.element.value.substring(eIndex);
            setTimeout(function() {
                setElementValue$1.call(_this, value_1), _this.element.selectionStart = _this.element.selectionEnd = sIndex_2;
            }, 0);
        }
    }
    function maskInputDropHandler$1(event) {
        event.preventDefault();
    }
    function maskInputKeyDownHandler$1(event) {
        var _this = this;
        if (this.mask) {
            229 !== event.keyCode ? (!event.ctrlKey || 89 !== event.keyCode && 90 !== event.keyCode || event.preventDefault(), 
            removeMaskInputValues$1.call(this, event)) : setTimeout(function() {
                removeMaskInputValues$1.call(_this, event);
            }, 0);
            var startValue = this.element.value;
            if (event.ctrlKey && (89 === event.keyCode || 90 === event.keyCode)) {
                var collec = void 0;
                90 === event.keyCode && this.undoCollec.length > 0 && startValue !== this.undoCollec[this.undoCollec.length - 1].value ? (collec = this.undoCollec[this.undoCollec.length - 1], 
                this.redoCollec.unshift({
                    value: this.element.value,
                    startIndex: this.element.selectionStart,
                    endIndex: this.element.selectionEnd
                }), setElementValue$1.call(this, collec.value), this.element.selectionStart = collec.startIndex, 
                this.element.selectionEnd = collec.endIndex, this.undoCollec.splice(this.undoCollec.length - 1, 1)) : 89 === event.keyCode && this.redoCollec.length > 0 && startValue !== this.redoCollec[0].value && (collec = this.redoCollec[0], 
                this.undoCollec.push({
                    value: this.element.value,
                    startIndex: this.element.selectionStart,
                    endIndex: this.element.selectionEnd
                }), setElementValue$1.call(this, collec.value), this.element.selectionStart = collec.startIndex, 
                this.element.selectionEnd = collec.endIndex, this.redoCollec.splice(0, 1));
            }
        }
    }
    function removeMaskInputValues$1(event) {
        var oldEventVal, isRemove = !1, isDeleted = !1;
        this.element.value.length < this.promptMask.length && (isRemove = !0, function() {
            var collec, sIndex = this.element.selectionStart, eIndex = this.element.selectionEnd;
            this.redoCollec.length > 0 ? (collec = this.redoCollec[0], setElementValue$1.call(this, collec.value), 
            collec.startIndex - sIndex == 1 ? (this.element.selectionStart = collec.startIndex, 
            this.element.selectionEnd = collec.endIndex) : (this.element.selectionStart = sIndex + 1, 
            this.element.selectionEnd = eIndex + 1)) : (setElementValue$1.call(this, this.promptMask), 
            this.element.selectionStart = this.element.selectionEnd = sIndex);
        }.call(this), oldEventVal = this.element.value);
        var initStartIndex = this.element.selectionStart, initEndIndex = this.element.selectionEnd, startIndex = this.element.selectionStart, endIndex = this.element.selectionEnd, maskValue = this.hiddenMask.replace(/[>|\\<]/g, ""), curMask = maskValue[startIndex - 1];
        this.element.parentNode;
        if (isRemove || 8 === event.keyCode || 46 === event.keyCode) {
            this.undoCollec.push({
                value: this.element.value,
                startIndex: this.element.selectionStart,
                endIndex: endIndex
            });
            var multipleDel = !1;
            if (startIndex > 0 || (8 === event.keyCode || 46 === event.keyCode) && startIndex < this.element.value.length && this.element.selectionEnd - startIndex !== this.element.value.length) {
                var index = startIndex;
                startIndex !== endIndex ? (startIndex = endIndex, 46 === event.keyCode && (multipleDel = !0)) : 46 === event.keyCode ? ++index : --index;
                for (var k = startIndex; 8 === event.keyCode || isRemove || multipleDel ? k > index : k < index; 8 === event.keyCode || isRemove || multipleDel ? k-- : k++) for (var i = startIndex; 8 === event.keyCode || isRemove || multipleDel ? i > 0 : i < this.element.value.length; 8 === event.keyCode || isRemove || multipleDel ? i-- : i++) {
                    var sIndex = void 0;
                    (8 === event.keyCode || multipleDel) && (initStartIndex !== initEndIndex && initStartIndex !== startIndex || initStartIndex === initEndIndex) || isRemove ? (curMask = maskValue[i - 1], 
                    sIndex = startIndex - 1) : (curMask = maskValue[i], sIndex = startIndex, ++startIndex);
                    var oldValue = this.element.value[sIndex];
                    if (isNullOrUndefined(this.regExpCollec[curMask]) && !isNullOrUndefined(this.customCharacters) && isNullOrUndefined(this.customCharacters[curMask]) && this.hiddenMask[sIndex] !== this.promptChar && "[" !== this.customRegExpCollec[sIndex][0] && "]" !== this.customRegExpCollec[sIndex][this.customRegExpCollec[sIndex].length - 1] || this.promptMask[sIndex] !== this.promptChar && isNullOrUndefined(this.customCharacters)) this.element.selectionStart = this.element.selectionEnd = sIndex, 
                    event.preventDefault(), 46 !== event.keyCode || multipleDel || ++this.element.selectionStart; else {
                        var value = this.element.value, prompt_1 = this.promptChar, elementValue = value.substring(0, sIndex) + prompt_1 + value.substring(startIndex, value.length);
                        setElementValue$1.call(this, elementValue), event.preventDefault(), this.element.selectionStart = this.element.selectionEnd = sIndex, 
                        isDeleted = !0;
                    }
                    if (startIndex = this.element.selectionStart, !isDeleted && 8 === event.keyCode || multipleDel || !isDeleted && 46 !== event.keyCode ? sIndex = startIndex - 1 : (sIndex = startIndex, 
                    isDeleted = !1), oldValue = this.element.value[sIndex], initStartIndex !== initEndIndex && this.element.selectionStart === initStartIndex || this.promptMask[sIndex] === this.promptChar || oldValue !== this.promptMask[sIndex] && this.promptMask[sIndex] !== this.promptChar && !isNullOrUndefined(this.customCharacters)) break;
                }
            }
            0 === this.element.selectionStart && this.element.selectionEnd === this.element.value.length && (setElementValue$1.call(this, this.promptMask), 
            event.preventDefault(), this.element.selectionStart = this.element.selectionEnd = startIndex), 
            this.redoCollec.unshift({
                value: this.element.value,
                startIndex: this.element.selectionStart,
                endIndex: this.element.selectionEnd
            }), triggerMaskChangeEvent$1.call(this, event, oldEventVal);
        }
    }
    function maskInputKeyPressHandler$1(event) {
        if (this.mask) {
            var oldValue = this.element.value;
            if (!event.ctrlKey || event.ctrlKey && "KeyA" !== event.code && "KeyY" !== event.code && "KeyZ" !== event.code && "KeyX" !== event.code && "KeyC" !== event.code && "KeyV" !== event.code) {
                this.maskKeyPress = !0;
                var key = event.key;
                "Spacebar" === key && (key = String.fromCharCode(event.keyCode)), key ? key && 1 === key.length && (validateValue$1.call(this, key, event.ctrlKey, event), 
                event.preventDefault()) : (this.isIosInvalid = !0, validateValue$1.call(this, String.fromCharCode(event.keyCode), event.ctrlKey, event), 
                event.preventDefault(), this.isIosInvalid = !1);
            }
            triggerMaskChangeEvent$1.call(this, event, oldValue);
        }
    }
    function triggerMaskChangeEvent$1(event, oldValue) {
        if (!isNullOrUndefined(this.changeEventArgs)) {
            var eventArgs = {};
            this.changeEventArgs = {
                value: this.element.value,
                maskedValue: this.element.value,
                isInteraction: !1
            }, this.mask && (this.changeEventArgs.value = strippedValue$1.call(this, this.element)), 
            isNullOrUndefined(event) || (this.changeEventArgs.isInteraction = !0, this.changeEventArgs.event = event), 
            merge(eventArgs, this.changeEventArgs), this.trigger("change", eventArgs);
        }
        attributes(this.element, {
            "aria-valuenow": this.element.value
        });
    }
    function maskInputKeyUpHandler$1(event) {
        if (this.mask) {
            var collec = void 0;
            if (this.maskKeyPress || 229 !== event.keyCode) removeMaskError$1.call(this); else {
                var oldEventVal = void 0;
                if (1 === this.element.value.length && (this.element.value = this.element.value + this.promptMask, 
                this.element.setSelectionRange(1, 1)), this.element.value.length > this.promptMask.length) {
                    var startIndex = this.element.selectionStart, addedValues = this.element.value.length - this.promptMask.length, val_1 = this.element.value.substring(startIndex - addedValues, startIndex);
                    if (this.undoCollec.length > 0) {
                        collec = this.undoCollec[this.undoCollec.length - 1];
                        var startIndex_1 = this.element.selectionStart;
                        oldEventVal = collec.value;
                        var oldVal = collec.value.substring(startIndex_1 - addedValues, startIndex_1);
                        collec = this.redoCollec[0], val_1 = val_1.trim();
                        var isSpace = Browser.isAndroid && "" === val_1;
                        isSpace || oldVal === val_1 || collec.value.substring(startIndex_1 - addedValues, startIndex_1) === val_1 ? isSpace && preventUnsupportedValues$1.call(this, event, startIndex_1 - 1, this.element.selectionEnd - 1, val_1, event.ctrlKey, !1) : validateValue$1.call(this, val_1, event.ctrlKey, event);
                    } else oldEventVal = this.promptMask, validateValue$1.call(this, val_1, event.ctrlKey, event);
                    this.maskKeyPress = !1, triggerMaskChangeEvent$1.call(this, event, oldEventVal);
                }
            }
            var val = strippedValue$1.call(this, this.element);
            (0 !== this.element.selectionStart || this.promptMask !== this.element.value || "" !== val || "" === val && this.value !== val) && (this.prevValue = val, 
            this.value = val);
        } else triggerMaskChangeEvent$1.call(this, event), this.value = this.element.value;
    }
    function validateValue$1(key, isCtrlKey, event) {
        this.maskKeyPress || function(key) {
            if (key.length > 1 && this.promptMask.length + key.length < this.element.value.length) {
                var elementValue = this.redoCollec[0].value.substring(0, this.redoCollec[0].startIndex) + key + this.redoCollec[0].value.substring(this.redoCollec[0].startIndex, this.redoCollec[0].value.length);
                setElementValue$1.call(this, elementValue), this.element.selectionStart = this.element.selectionEnd = this.redoCollec[0].startIndex + key.length;
            }
            this.element.selectionStart = this.element.selectionStart - key.length, this.element.selectionEnd = this.element.selectionEnd - key.length;
        }.call(this, key);
        for (var curMask, eventOldVal, startIndex = this.element.selectionStart, initStartIndex = startIndex, allowText = (this.element.selectionEnd, 
        !1), value = this.element.value, prevSupport = !1, isEqualVal = !1, k = 0; k < key.length; k++) {
            var keyValue = key[k];
            if (startIndex = this.element.selectionStart, this.element.selectionEnd, this.maskKeyPress || initStartIndex !== startIndex || (startIndex += k), 
            !this.maskKeyPress || startIndex < this.promptMask.length) {
                for (var i = startIndex; i < this.promptMask.length; i++) {
                    curMask = this.escapeMaskValue[startIndex], "\\" === this.hiddenMask[startIndex] && this.hiddenMask[startIndex + 1] === key && (isEqualVal = !0), 
                    (isNullOrUndefined(this.regExpCollec[curMask]) && (isNullOrUndefined(this.customCharacters) || !isNullOrUndefined(this.customCharacters) && isNullOrUndefined(this.customCharacters[curMask])) && this.hiddenMask[startIndex] !== this.promptChar && "[" !== this.customRegExpCollec[startIndex][0] && "]" !== this.customRegExpCollec[startIndex][this.customRegExpCollec[startIndex].length - 1] || this.promptMask[startIndex] !== this.promptChar && isNullOrUndefined(this.customCharacters) || this.promptChar === curMask && this.escapeMaskValue === this.mask) && (this.element.selectionStart = this.element.selectionEnd = startIndex + 1, 
                    startIndex = this.element.selectionStart, curMask = this.hiddenMask[startIndex]);
                }
                if (isNullOrUndefined(this.customCharacters) || isNullOrUndefined(this.customCharacters[curMask])) !isNullOrUndefined(this.regExpCollec[curMask]) && keyValue.match(new RegExp(this.regExpCollec[curMask])) && this.promptMask[startIndex] === this.promptChar ? allowText = !0 : this.promptMask[startIndex] === this.promptChar && "[" === this.customRegExpCollec[startIndex][0] && "]" === this.customRegExpCollec[startIndex][this.customRegExpCollec[startIndex].length - 1] && keyValue.match(new RegExp(this.customRegExpCollec[startIndex])) && (allowText = !0); else {
                    var customValArr = this.customCharacters[curMask].split(",");
                    for (i = 0; i < customValArr.length; i++) if (keyValue.match(new RegExp("[" + customValArr[i] + "]"))) {
                        allowText = !0;
                        break;
                    }
                }
                if ((!this.maskKeyPress || startIndex < this.hiddenMask.length) && allowText) {
                    if (0 === k) if (this.maskKeyPress) this.undoCollec.push({
                        value: value,
                        startIndex: startIndex,
                        endIndex: startIndex
                    }); else {
                        var sIndex = this.element.selectionStart, eIndex = this.element.selectionEnd;
                        this.redoCollec.length > 0 ? (eventOldVal = this.redoCollec[0].value, setElementValue$1.call(this, eventOldVal), 
                        this.undoCollec.push(this.redoCollec[0])) : (this.undoCollec.push({
                            value: this.promptMask,
                            startIndex: startIndex,
                            endIndex: startIndex
                        }), eventOldVal = this.promptMask, setElementValue$1.call(this, eventOldVal)), this.element.selectionStart = sIndex, 
                        this.element.selectionEnd = eIndex;
                    }
                    startIndex = this.element.selectionStart, function(event, startIndex, keyValue, eventOldVal, isEqualVal) {
                        this.hiddenMask.length > this.promptMask.length && (keyValue = function(key, value) {
                            var promptMask, i, curVal = value, caseCount = 0;
                            for (i = 0; i < this.hiddenMask.length; i++) if ("\\" === this.hiddenMask[i] && (promptMask = curVal.substring(0, i) + "\\" + curVal.substring(i, curVal.length)), 
                            ">" !== this.hiddenMask[i] && "<" !== this.hiddenMask[i] && "|" !== this.hiddenMask[i] || (this.hiddenMask[i] !== curVal[i] && (promptMask = curVal.substring(0, i) + this.hiddenMask[i] + curVal.substring(i, curVal.length)), 
                            ++caseCount), promptMask) {
                                if (promptMask[i] === this.promptChar && i > this.element.selectionStart || this.element.value.indexOf(this.promptChar) < 0 && this.element.selectionStart + caseCount === i) {
                                    caseCount = 0;
                                    break;
                                }
                                curVal = promptMask;
                            }
                            for (;i >= 0 && promptMask; ) {
                                if (0 === i || "\\" !== promptMask[i - 1]) {
                                    this.element.value;
                                    if (">" === promptMask[i]) {
                                        key = key.toUpperCase();
                                        break;
                                    }
                                    if ("<" === promptMask[i]) {
                                        key = key.toLowerCase();
                                        break;
                                    }
                                    if ("|" === promptMask[i]) break;
                                }
                                --i;
                            }
                            return key;
                        }.call(this, keyValue, this.element.value));
                        if (!isEqualVal) {
                            var value = this.element.value, elementValue = value.substring(0, startIndex) + keyValue + value.substring(startIndex + 1, value.length);
                            setElementValue$1.call(this, elementValue), this.element.selectionStart = this.element.selectionEnd = startIndex + 1;
                        }
                        triggerMaskChangeEvent$1.call(this, event, eventOldVal);
                    }.call(this, event, startIndex, keyValue, eventOldVal, isEqualVal), prevSupport = !0, 
                    k === key.length - 1 && this.redoCollec.unshift({
                        value: this.element.value,
                        startIndex: this.element.selectionStart,
                        endIndex: this.element.selectionEnd
                    }), allowText = !1;
                } else startIndex = this.element.selectionStart, preventUnsupportedValues$1.call(this, event, startIndex, initStartIndex, key, isCtrlKey, prevSupport);
                k !== key.length - 1 || allowText || (!Browser.isAndroid || Browser.isAndroid && startIndex < this.promptMask.length) && this.redoCollec.unshift({
                    value: this.element.value,
                    startIndex: this.element.selectionStart,
                    endIndex: this.element.selectionEnd
                });
            } else 1 !== key.length || isCtrlKey || isNullOrUndefined(event) || addMaskErrorClass$1.call(this);
        }
    }
    function preventUnsupportedValues$1(event, sIdx, idx, key, ctrl, chkSupport) {
        if (!this.maskKeyPress) {
            var eventOldVal = void 0, value = this.element.value;
            sIdx >= this.promptMask.length ? setElementValue$1.call(this, value.substring(0, sIdx)) : (idx === sIdx ? setElementValue$1.call(this, value.substring(0, sIdx) + value.substring(sIdx + 1, value.length)) : this.promptMask.length === this.element.value.length ? setElementValue$1.call(this, value.substring(0, sIdx) + value.substring(sIdx, value.length)) : setElementValue$1.call(this, value.substring(0, idx) + value.substring(idx + 1, value.length)), 
            this.element.selectionStart = this.element.selectionEnd = chkSupport || this.element.value[idx] !== this.promptChar ? sIdx : idx), 
            eventOldVal = this.element.value, triggerMaskChangeEvent$1.call(this, event, eventOldVal), 
            addMaskErrorClass$1.call(this);
        }
        1 !== key.length || ctrl || isNullOrUndefined(event) || addMaskErrorClass$1.call(this);
    }
    function addMaskErrorClass$1() {
        var _this = this, parentElement = this.element.parentNode, timer = 200;
        parentElement.classList.contains(INPUTGROUP$1) || parentElement.classList.contains(FLOATINPUT$1) ? addClass([ parentElement ], ERROR$5) : addClass([ this.element ], ERROR$5), 
        !0 === this.isIosInvalid && (timer = 400), attributes(this.element, {
            "aria-invalid": "true"
        }), setTimeout(function() {
            _this.maskKeyPress || removeMaskError$1.call(_this);
        }, timer);
    }
    function removeMaskError$1() {
        removeClass([ this.element.parentNode ], ERROR$5), removeClass([ this.element ], ERROR$5), 
        attributes(this.element, {
            "aria-invalid": "false"
        });
    }
    function setMaskValue$1(val) {
        if (this.mask && !isNullOrUndefined(val) && ("" === val || this.prevValue !== val)) {
            this.maskKeyPress = !0, setElementValue$1.call(this, this.promptMask), "" !== val && (this.element.selectionStart = 0, 
            this.element.selectionEnd = 0);
            for (var i = 0; i < val.length; i++) validateValue$1.call(this, val[i], !1, null);
            this.value = strippedValue$1.call(this, this.element), this.maskKeyPress = !1;
            var labelElement = this.element.parentNode.querySelector(".e-float-text");
            this.element.value !== this.promptMask || "Auto" !== this.floatLabelType || isNullOrUndefined(labelElement) || !labelElement.classList.contains(TOPLABEL$1) || this.isFocus || (removeClass([ labelElement ], TOPLABEL$1), 
            addClass([ labelElement ], BOTTOMLABEL$1), setElementValue$1.call(this, ""));
        }
    }
    function setElementValue$1(val, element) {
        !this.isFocus && "Auto" === this.floatLabelType && isNullOrUndefined(this.value) && (val = ""), 
        Input$1.setValue(val, element || this.element, this.floatLabelType);
    }
    function valueAccessor(field, data, column) {
        return field = isNullOrUndefined(field) ? "" : field, getValue(field, data);
    }
    function iterateArrayOrObject(collection, predicate) {
        for (var result = [], i = 0, len = collection.length; i < len; i++) {
            var pred = predicate(collection[i], i);
            isNullOrUndefined(pred) || result.push(pred);
        }
        return result;
    }
    function templateCompiler(template) {
        if (template) try {
            if (document.querySelectorAll(template).length) return compile$$1(document.querySelector(template).innerHTML.trim());
        } catch (e) {
            return compile$$1(template);
        }
    }
    function setStyleAndAttributes(node, customAttributes) {
        var copyAttr = {}, literals = [ "style", "class" ];
        extend(copyAttr, customAttributes, {}), "style" in copyAttr && (setStyleAttribute(node, copyAttr[literals[0]]), 
        delete copyAttr[literals[0]]), "class" in copyAttr && (addClass([ node ], copyAttr[literals[1]]), 
        delete copyAttr[literals[1]]), attributes(node, copyAttr);
    }
    function prepareColumns(columns, autoWidth) {
        for (var c = 0, len = columns.length; c < len; c++) {
            var column = void 0;
            "string" == typeof columns[c] ? column = new Column({
                field: columns[c]
            }) : columns[c] instanceof Column ? column = columns[c] : columns[c].columns ? (column = new Column(columns[c]), 
            columns[c].columns = prepareColumns(columns[c].columns)) : column = new Column(columns[c]), 
            column.headerText = isNullOrUndefined(column.headerText) ? column.foreignKeyValue || column.field || "" : column.headerText, 
            column.foreignKeyField = column.foreignKeyField || column.field, column.valueAccessor = column.valueAccessor || valueAccessor, 
            column.width = autoWidth && isNullOrUndefined(column.width) ? 200 : column.width, 
            isNullOrUndefined(column.visible) && (column.visible = !0), columns[c] = column;
        }
        return columns;
    }
    function setCssInGridPopUp(popUp, e, className) {
        var isBottomTail, popUpSpan = popUp.querySelector("span"), position = popUp.parentElement.getBoundingClientRect(), targetPosition = e.target.getBoundingClientRect();
        popUpSpan.className = className, popUp.style.display = "", isBottomTail = (isNullOrUndefined(e.clientY) ? e.changedTouches[0].clientY : e.clientY) > popUp.offsetHeight + 10, 
        popUp.style.top = targetPosition.top - position.top + (isBottomTail ? -(popUp.offsetHeight + 10) : popUp.offsetHeight + 10) + "px", 
        popUp.style.left = function(popup, e, targetPosition, left) {
            var width = popup.offsetWidth / 2, x = getPosition(e).x;
            return x - targetPosition.left < width ? targetPosition.left - left : targetPosition.right - x < width ? targetPosition.right - left - 2 * width : x - left - width;
        }(popUp, e, targetPosition, position.left) + "px", isBottomTail ? (popUp.querySelector(".e-downtail").style.display = "", 
        popUp.querySelector(".e-uptail").style.display = "none") : (popUp.querySelector(".e-downtail").style.display = "none", 
        popUp.querySelector(".e-uptail").style.display = "");
    }
    function getActualProperties(obj) {
        return obj instanceof ChildProperty ? getValue("properties", obj) : obj;
    }
    function parentsUntil(elem, selector, isID) {
        for (var parent = elem; parent && (isID ? parent.id !== selector : !parent.classList.contains(selector)); ) parent = parent.parentElement;
        return parent;
    }
    function getElementIndex(element, elements) {
        for (var index = -1, i = 0, len = elements.length; i < len; i++) if (elements[i].isEqualNode(element)) {
            index = i;
            break;
        }
        return index;
    }
    function inArray(value, collection) {
        for (var i = 0, len = collection.length; i < len; i++) if (collection[i] === value) return i;
        return -1;
    }
    function getActualPropFromColl(collection) {
        for (var coll = [], i = 0, len = collection.length; i < len; i++) collection[i].hasOwnProperty("properties") ? coll.push(collection[i].properties) : coll.push(collection[i]);
        return coll;
    }
    function removeElement(target, selector) {
        for (var elements = [].slice.call(target.querySelectorAll(selector)), i = 0; i < elements.length; i++) remove(elements[i]);
    }
    function getPosition(e) {
        var position = {};
        return position.x = isNullOrUndefined(e.clientX) ? e.changedTouches[0].clientX : e.clientX, 
        position.y = isNullOrUndefined(e.clientY) ? e.changedTouches[0].clientY : e.clientY, 
        position;
    }
    function getUid(prefix) {
        return prefix + uid$1++;
    }
    function appendChildren(elem, children) {
        for (var i = 0, len = children.length; i < len; i++) len === children.length ? elem.appendChild(children[i]) : elem.appendChild(children[0]);
        return elem;
    }
    function calculateAggregate(type, data, column, context) {
        return "Custom" === type ? column.customAggregate ? column.customAggregate.call(context, data, column) : "" : DataUtil.aggregates[type.toLowerCase()](data, column.field);
    }
    function getScrollBarWidth() {
        if (null !== scrollWidth) return scrollWidth;
        var divNode = document.createElement("div"), value = 0;
        return divNode.style.cssText = "width:100px;height: 100px;overflow: scroll;position: absolute;top: -9999px;", 
        document.body.appendChild(divNode), value = divNode.offsetWidth - divNode.clientWidth | 0, 
        document.body.removeChild(divNode), scrollWidth = value;
    }
    function getRowHeight(element) {
        if (void 0 !== rowHeight) return rowHeight;
        var table = createElement("table", {
            className: "e-table",
            styles: "visibility: hidden"
        });
        table.innerHTML = '<tr><td class="e-rowcell">A<td></tr>', element.appendChild(table);
        var rect = table.querySelector("td").getBoundingClientRect();
        return element.removeChild(table), rowHeight = Math.ceil(rect.height);
    }
    function isEditable(col, type, elem) {
        var row = parentsUntil(elem, "e-row"), isOldRow = !row || row && !row.classList.contains("e-insertedrow");
        return "beginEdit" === type && isOldRow ? !(col.isIdentity || col.isPrimaryKey || !col.allowEditing) : ("add" !== type || !col.isIdentity || !col.isPrimaryKey) && !(isOldRow && !col.allowEditing && !col.isIdentity && !col.isPrimaryKey);
    }
    function isActionPrevent(inst) {
        var dlg = inst.element.querySelector("#" + inst.element.id + "EditConfirm");
        return "Batch" === inst.editSettings.mode && inst.element.querySelectorAll(".e-updatedtd").length && inst.editSettings.showConfirmDialog && (!dlg || dlg.classList.contains("e-popup-close"));
    }
    function wrap(elem, action) {
        elem = elem instanceof Array ? elem : [ elem ];
        for (var i = 0; i < elem.length; i++) action ? elem[i].classList.add("e-wrap") : elem[i].classList.remove("e-wrap");
    }
    function changeButtonType(target) {
        for (var _i = 0, elements_1 = [].slice.call(target.querySelectorAll("button")); _i < elements_1.length; _i++) {
            attributes(elements_1[_i], {
                type: "button"
            });
        }
    }
    function setFormatter(serviceLocator, column) {
        var fmtr = serviceLocator.getService("valueFormatter");
        switch (column.type) {
          case "date":
            column.setFormatter(fmtr.getFormatFunction({
                type: "date",
                skeleton: column.format
            })), column.setParser(fmtr.getParserFunction({
                type: "date",
                skeleton: column.format
            }));
            break;

          case "datetime":
            column.setFormatter(fmtr.getFormatFunction({
                type: "dateTime",
                skeleton: column.format
            })), column.setParser(fmtr.getParserFunction({
                type: "dateTime",
                skeleton: column.format
            }));
            break;

          case "number":
            column.setFormatter(fmtr.getFormatFunction({
                format: column.format
            })), column.setParser(fmtr.getParserFunction({
                format: column.format
            }));
        }
    }
    function addRemoveActiveClasses(cells, add) {
        for (var args = [], _i = 2; _i < arguments.length; _i++) args[_i - 2] = arguments[_i];
        for (var i = 0, len = cells.length; i < len; i++) add ? (classList(cells[i], args.slice(), []), 
        cells[i].setAttribute("aria-selected", "true")) : (classList(cells[i], [], args.slice()), 
        cells[i].removeAttribute("aria-selected"));
    }
    function getFilterMenuPostion(target, dialogObj, grid) {
        var elementVisible = dialogObj.element.style.display;
        dialogObj.element.style.display = "block";
        var newpos, dlgWidth = dialogObj.width;
        if (grid.enableRtl) {
            newpos = calculatePosition(target, "left", "bottom"), dialogObj.element.style.top = newpos.top + target.getBoundingClientRect().height - 35 + "px", 
            dialogObj.element.style.display = elementVisible;
            leftPos = newpos.left - dlgWidth + target.clientWidth;
            dialogObj.element.style.left = leftPos < 1 ? dlgWidth + leftPos + -16 + "px" : leftPos - 16 + "px";
        } else {
            newpos = calculateRelativeBasedPosition(target, dialogObj.element), dialogObj.element.style.display = elementVisible, 
            dialogObj.element.style.top = newpos.top + target.getBoundingClientRect().height - 5 + "px";
            var leftPos = newpos.left - dlgWidth + target.clientWidth;
            dialogObj.element.style.left = leftPos < 1 ? dlgWidth + leftPos - 16 + "px" : leftPos + -4 + "px";
        }
    }
    function getZIndexCalcualtion(args, dialogObj) {
        args.popup.element.style.zIndex = (dialogObj.zIndex + 1).toString();
    }
    function toogleCheckbox(elem) {
        var span = elem.querySelector(".e-frame");
        span.classList.contains("e-check") ? classList(span, [ "e-uncheck" ], [ "e-check" ]) : classList(span, [ "e-check" ], [ "e-uncheck" ]);
    }
    function createCboxWithWrap(uid, elem, className) {
        var div = createElement("div", {
            className: className
        });
        return div.appendChild(elem), div.setAttribute("uid", uid), div;
    }
    function removeAddCboxClasses(elem, checked) {
        removeClass([ elem ], [ "e-check", "e-stop", "e-uncheck" ]), checked ? elem.classList.add("e-check") : elem.classList.add("e-uncheck");
    }
    function refreshForeignData(row, columns, data) {
        columns.forEach(function(col) {
            setValue(col.field, getForeignData(col, data), row.foreignKeyData);
        }), row.cells.forEach(function(cell) {
            cell.isForeignKey && setValue("foreignKeyData", getValue(cell.column.field, row.foreignKeyData), cell);
        });
    }
    function getForeignData(column, data, lValue, foreignKeyData) {
        var fField = column.foreignKeyField, key = lValue || valueAccessor(column.field, data) || "", query = new Query(), fdata = foreignKeyData || column.dataSource instanceof DataManager && column.dataSource.dataSource.offline ? column.dataSource.dataSource.json : column.columnData;
        return key.getDay ? query.where(getDatePredicate({
            field: fField,
            operator: "equal",
            value: key,
            matchCase: !1
        })) : query.where(fField, "==", key, !1), new DataManager(fdata).executeLocal(query);
    }
    function getColumnByForeignKeyValue(foreignKeyValue, columns) {
        var column;
        return columns.some(function(col) {
            return column = col, col.foreignKeyValue === foreignKeyValue;
        }) && column;
    }
    function getDatePredicate(filterObject) {
        var datePredicate, prevDate, nextDate, prevObj = extend({}, getActualProperties(filterObject)), nextObj = extend({}, getActualProperties(filterObject)), value = new Date(filterObject.value);
        if ("equal" === filterObject.operator || "notequal" === filterObject.operator) {
            prevDate = new Date(value.setHours(0) - 1), nextDate = new Date(value.setHours(24)), 
            prevObj.value = prevDate, nextObj.value = nextDate, "equal" === filterObject.operator ? (prevObj.operator = "greaterthan", 
            nextObj.operator = "lessthan") : "notequal" === filterObject.operator && (prevObj.operator = "lessthanorequal", 
            nextObj.operator = "greaterthanorequal");
            var predicateSt = new Predicate(prevObj.field, prevObj.operator, prevObj.value, !1), predicateEnd = new Predicate(nextObj.field, nextObj.operator, nextObj.value, !1);
            datePredicate = "equal" === filterObject.operator ? predicateSt.and(predicateEnd) : predicateSt.or(predicateEnd);
        } else {
            "string" == typeof prevObj.value && (prevObj.value = new Date(prevObj.value));
            datePredicate = new Predicate(prevObj.field, prevObj.operator, prevObj.value, !1);
        }
        return filterObject.ejpredicate = datePredicate, datePredicate;
    }
    function renderMovable(ele, frzCols) {
        for (var mEle = ele.cloneNode(!0), i = 0; i < frzCols; i++) mEle.removeChild(mEle.children[0]);
        i = frzCols;
        for (var len = ele.childElementCount; i < len; i++) ele.removeChild(ele.children[ele.childElementCount - 1]);
        return mEle;
    }
    function Search$1(inputVal, items, searchType, ignoreCase) {
        var listItems = items;
        ignoreCase = void 0 === ignoreCase || null === ignoreCase || ignoreCase;
        var itemData = {
            item: null,
            index: null
        };
        if (inputVal.length) {
            for (var strLength = inputVal.length, queryStr = ignoreCase ? inputVal.toLocaleLowerCase() : inputVal, i = 0, itemsData = listItems; i < itemsData.length; i++) {
                var item = itemsData[i], text = (ignoreCase ? item.textContent.toLocaleLowerCase() : item.textContent).replace(/^\s+|\s+$/g, "");
                if ("Equal" === searchType && text === queryStr || "StartsWith" === searchType && text.substr(0, strLength) === queryStr) return itemData.item = item, 
                itemData.index = i, {
                    item: item,
                    index: i
                };
            }
            return itemData;
        }
        return itemData;
    }
    function highlightSearch$1(content, query, ignoreCase, type) {
        if (function(content) {
            for (var contentElement = content.querySelectorAll(".e-highlight"), i = contentElement.length - 1; i >= 0; i--) {
                var parent_1 = contentElement[i].parentNode, text = document.createTextNode(contentElement[i].textContent);
                parent_1.replaceChild(text, contentElement[i]);
            }
        }(content), "" !== query) {
            var ignoreRegex = ignoreCase ? "gim" : "gm";
            query = /^[a-zA-Z0-9- ]*$/.test(query) ? query : query.replace(/[\-\[\]\/\{\}\(\)\*\+\?\.\\\^\$\|]/g, "\\$&");
            for (var replaceQuery = "StartsWith" === type ? "^(" + query + ")" : "EndsWith" === type ? "(" + query + ")$" : "(" + query + ")", pattern = new RegExp(replaceQuery, ignoreRegex), li = content.querySelectorAll("ul li"), i = 0; i < li.length; i++) {
                var element = li[i];
                element.innerHTML = element.innerHTML.replace(pattern, '<span class="e-highlight">$1</span>');
            }
        }
    }
    function getWeekFirstDate(date1, firstDayOfWeek) {
        var date = new Date(date1.getTime());
        return firstDayOfWeek = (firstDayOfWeek - date.getDay() - 7) % 7, new Date(date.setDate(date.getDate() + firstDayOfWeek));
    }
    function setTime(date, time) {
        var tzOffsetBefore = date.getTimezoneOffset(), d = new Date(date.getTime() + time), tzOffsetDiff = d.getTimezoneOffset() - tzOffsetBefore;
        return date.setTime(d.getTime() + tzOffsetDiff * MS_PER_DAY), date;
    }
    function resetTime(date) {
        return date.setHours(0, 0, 0, 0), date;
    }
    function getDateInMs(date) {
        return date.getTime() - new Date(date.getFullYear(), date.getMonth(), date.getDate(), 0, 0, 0).getTime();
    }
    function addDays(date, i) {
        return date = new Date("" + date), new Date(date.setDate(date.getDate() + i));
    }
    function addMonths(date, i) {
        var day = (date = new Date("" + date)).getDate();
        return date.setDate(1), date.setMonth(date.getMonth() + i), date.setDate(Math.min(day, function(d) {
            return new Date(d.getFullYear(), d.getMonth() + 1, 0).getDate();
        }(date))), date;
    }
    function getStartEndHours(date, startHour, endHour) {
        var date1 = new Date(date.getTime());
        date1.setHours(startHour.getHours()), date1.setMinutes(startHour.getMinutes()), 
        date1.setSeconds(startHour.getSeconds());
        var date2 = new Date(date.getTime());
        return 0 === endHour.getHours() ? date2 = addDays(date2, 1) : (date2.setHours(endHour.getHours()), 
        date2.setMinutes(endHour.getMinutes()), date2.setSeconds(endHour.getSeconds())), 
        {
            startHour: date1,
            endHour: date2
        };
    }
    function getDaysCount(startDate, endDate) {
        var strTime = resetTime(new Date(startDate));
        return (resetTime(new Date(endDate)).getTime() - strTime.getTime()) / MS_PER_DAY;
    }
    function getScrollBarWidth$1() {
        if (null !== scrollWidth$1) return scrollWidth$1;
        var divNode = document.createElement("div"), value = 0;
        return divNode.style.cssText = "width:100px;height: 100px;overflow: scroll;position: absolute;top: -9999px;", 
        document.body.appendChild(divNode), value = divNode.offsetWidth - divNode.clientWidth | 0, 
        document.body.removeChild(divNode), scrollWidth$1 = value;
    }
    function getMonthSummary(ruleObject, cldrObj, localeObj) {
        var summary = "";
        if (ruleObject.monthDay.length) summary += ruleObject.monthDay[0]; else if (ruleObject.day) {
            var pos = ruleObject.setPosition - 1;
            summary += localeObj.getConstant(WEEKPOS[pos > -1 ? pos : WEEKPOS.length - 1]) + " " + getValue(DAYINDEXOBJECT[ruleObject.day[0]], cldrObj);
        }
        return summary;
    }
    function generate(startDate, rule, excludeDate, startDayOfWeek, maximumCount, viewDate) {
        void 0 === maximumCount && (maximumCount = MAXOCCURRENCE), void 0 === viewDate && (viewDate = null);
        var cacheDate, ruleObject = extractObjectFromRule(rule), data = [], modifiedDate = new Date(startDate.getTime());
        if (viewDate && viewDate > startDate && !ruleObject.count ? (tempViewDate = new Date(viewDate.getTime())).setHours(startDate.getHours(), startDate.getMinutes(), startDate.getSeconds()) : tempViewDate = null, 
        !ruleObject.until && tempViewDate && ((cacheDate = new Date(tempViewDate.getTime())).setDate(tempViewDate.getDate() + 42 * ruleObject.interval), 
        ruleObject.until = cacheDate), ruleObject.until && startDate > ruleObject.until) return data;
        maxOccurrence = maximumCount, function(day) {
            for (;dayIndex[0] !== day; ) rotate(dayIndex);
        }(DAYINDEX[startDayOfWeek]), tempExcludeDate = [];
        switch ((isNullOrUndefined(excludeDate) ? [] : excludeDate.split(",")).forEach(function(content) {
            var parsedDate = getDateFromRecurrenceDateString(content);
            tempExcludeDate.push(new Date(parsedDate.getTime()).setHours(0, 0, 0, 0));
        }), ruleObject.freq) {
          case "DAILY":
            !function(startDate, endDate, data, ruleObject) {
                var tempDate = new Date(startDate.getTime()), interval = ruleObject.interval, expectedCount = ruleObject.count ? ruleObject.count : maxOccurrence;
                for (;compareDates(tempDate, endDate) && (!0, !(validateRules(tempDate, ruleObject) && (excludeDateHandler(data, tempDate.getTime()), 
                expectedCount && data.length + tempExcludeDate.length >= expectedCount))); ) tempDate.setDate(tempDate.getDate() + interval);
            }(modifiedDate, ruleObject.until, data, ruleObject);
            break;

          case "WEEKLY":
            !function(startDate, endDate, data, ruleObject) {
                var tempDate = getStartDateForWeek(startDate, ruleObject.day), interval = ruleObject.interval, expectedDays = ruleObject.day, expectedCount = ruleObject.count ? ruleObject.count : maxOccurrence, dayCycleData = processWeekDays(expectedDays);
                for (;compareDates(tempDate, endDate) && (!0, !(validateRules(tempDate, ruleObject) && (excludeDateHandler(data, tempDate.getTime()), 
                expectedCount && data.length + tempExcludeDate.length >= expectedCount))); ) expectedDays.length > 1 ? tempDate.setDate(tempDate.getDate() + dayCycleData[DAYINDEX[tempDate.getDay()]] + (expectedDays.indexOf(DAYINDEX[tempDate.getDay()]) === expectedDays.length - 1 ? 7 * (interval - 1) : 0)) : tempDate.setDate(tempDate.getDate() + 7 * interval);
            }(modifiedDate, ruleObject.until, data, ruleObject);
            break;

          case "MONTHLY":
            monthlyType(modifiedDate, ruleObject.until, data, ruleObject);
            break;

          case "YEARLY":
            !function(startDate, endDate, data, ruleObject) {
                switch (function(ruleObject) {
                    {
                        if (ruleObject.yearDay.length) return "YEARDAY";
                        if (ruleObject.weekNo.length) return "WEEKNO";
                    }
                    return "MONTH";
                }(ruleObject)) {
                  case "MONTH":
                    monthlyType(startDate, endDate, data, ruleObject);
                    break;

                  case "WEEKNO":
                    !function(startDate, endDate, data, ruleObject) {
                        var tempDate, state, startDay, firstWeekSpan, weekNo, maxDate, minDate, stDate = new Date(startDate.getFullYear(), 0, 0), expectedCount = ruleObject.count ? ruleObject.count : maxOccurrence, weekNos = ruleObject.weekNo;
                        for (;compareDates(stDate, endDate); ) {
                            startDay = dayIndex.indexOf(DAYINDEX[stDate.getDay()]), firstWeekSpan = 6 - startDay + 1;
                            for (var index = 0; index < weekNos.length; index++) for (weekNo = weekNos[index], 
                            maxDate = 1 === (weekNo = weekNo > 0 ? weekNo : 53 + weekNo + 1) ? firstWeekSpan : firstWeekSpan + 7 * (weekNo - 1), 
                            minDate = 1 === weekNo ? firstWeekSpan - 7 : firstWeekSpan + 7 * (weekNo - 2); minDate < maxDate; ) {
                                if (tempDate = new Date(stDate.getTime() + MS_PER_DAY * minDate), state = validateRules(tempDate, ruleObject), 
                                tempDate >= startDate && state && compareDates(tempDate, endDate) && (excludeDateHandler(data, tempDate.getTime()), 
                                expectedCount && data.length + tempExcludeDate.length >= expectedCount)) return;
                                minDate++;
                            }
                            stDate = new Date(tempDate.getFullYear() + ruleObject.interval, 0, 0);
                        }
                    }(startDate, endDate, data, ruleObject);
                    break;

                  case "YEARDAY":
                    !function(startDate, endDate, data, ruleObject) {
                        var tempDate, state, date, stDate = new Date(startDate.getFullYear(), 0, 0), expectedCount = ruleObject.count ? ruleObject.count : maxOccurrence;
                        for (;compareDates(stDate, endDate); ) {
                            for (var index = 0; index < ruleObject.yearDay.length; index++) if (date = ruleObject.yearDay[index], 
                            tempDate = new Date(stDate.getTime()), date !== LEAPYEAR && date !== -LEAPYEAR || (tempDate.getFullYear() + 1) % 4 == 0) {
                                if (tempDate.setDate(tempDate.getDate() + (date < 0 ? getMaxYearDay(tempDate.getFullYear() + 1) + 1 + date : date)), 
                                state = validateRules(tempDate, ruleObject), tempDate >= startDate && state && compareDates(tempDate, endDate) && (excludeDateHandler(data, tempDate.getTime()), 
                                expectedCount && data.length + tempExcludeDate.length >= expectedCount)) return;
                            } else tempDate.setDate(tempDate.getDate() + 1);
                            stDate = new Date(tempDate.getFullYear() + ruleObject.interval, 0, 0);
                        }
                    }(startDate, endDate, data, ruleObject);
                }
            }(modifiedDate, ruleObject.until, data, ruleObject);
        }
        return data;
    }
    function getDateFromRecurrenceDateString(recDateString) {
        return new Date(recDateString.substr(0, 4) + "-" + recDateString.substr(4, 2) + "-" + recDateString.substr(6, 5) + ":" + recDateString.substr(11, 2) + ":" + recDateString.substr(13));
    }
    function excludeDateHandler(data, date) {
        var zeroIndex = new Date(date).setHours(0, 0, 0, 0);
        -1 === tempExcludeDate.indexOf(zeroIndex) && (!tempViewDate || zeroIndex >= tempViewDate.getTime()) && data.push(date);
    }
    function monthlyType(startDate, endDate, data, ruleObject) {
        switch (function(ruleObject) {
            {
                if (ruleObject.monthDay.length && !ruleObject.day.length) return "date";
                if (!ruleObject.monthDay.length && ruleObject.day.length) return "day";
            }
            return "both";
        }(ruleObject)) {
          case "day":
            !function(startDate, endDate, data, ruleObject) {
                var state, month, index, beginDate, tempDate = new Date(startDate.getTime()), expectedDays = ruleObject.day, expectedCount = ruleObject.count ? ruleObject.count : maxOccurrence, dayCycleData = processWeekDays(expectedDays), interval = ruleObject.interval, monthCollection = [], weekCollection = [], monthInit = 0;
                tempDate.setDate(1), ruleObject.month.length && tempDate.setMonth(ruleObject.month[0] - 1);
                tempDate = getStartDateForWeek(tempDate, ruleObject.day);
                for (;compareDates(tempDate, endDate); ) {
                    if (month = tempDate.getMonth(), beginDate = new Date(tempDate.getTime()), expectedDays.length > 1) for (;tempDate.getMonth() === month; ) weekCollection.push(tempDate.getTime()), 
                    DAYINDEX[tempDate.getDay()] === expectedDays[expectedDays.length - 1] && (monthCollection.push(weekCollection), 
                    weekCollection = []), tempDate.setDate(tempDate.getDate() + dayCycleData[DAYINDEX[tempDate.getDay()]]); else for (;tempDate.getMonth() === month; ) monthCollection.push([ tempDate.getTime() ]), 
                    tempDate.setDate(tempDate.getDate() + 7);
                    if (index = ruleObject.setPosition < 1 ? monthCollection.length + ruleObject.setPosition : ruleObject.setPosition - 1, 
                    null === ruleObject.setPosition) {
                        index = 0;
                        for (var datas = [], week = 0; week < monthCollection.length; week++) for (var row = 0; row < monthCollection[week].length; row++) datas.push(monthCollection[week][row]);
                        monthCollection = [ datas ];
                    }
                    for (var week = 0; week < monthCollection[index].length; week++) {
                        var dayData = monthCollection[index][week], chDate = new Date(dayData);
                        if (state = validateRules(chDate, ruleObject), chDate >= startDate && compareDates(chDate, endDate) && state && (excludeDateHandler(data, dayData), 
                        expectedCount && data.length + tempExcludeDate.length >= expectedCount)) return;
                    }
                    monthInit = setNextValidDate(tempDate, ruleObject, monthInit, interval, beginDate), 
                    monthCollection = [], weekCollection = [], tempDate = getStartDateForWeek(tempDate, ruleObject.day);
                }
            }(startDate, endDate, data, ruleObject);
            break;

          case "both":
          case "date":
            !function(startDate, endDate, data, ruleObject) {
                var date, state, tempDate = new Date(startDate.getTime()), mainDate = new Date(startDate.getTime()), expectedCount = ruleObject.count ? ruleObject.count : maxOccurrence, interval = ruleObject.interval, monthInit = 0;
                tempDate.setDate(1), mainDate.setDate(1), ruleObject.month.length && tempDate.setMonth(ruleObject.month[0] - 1);
                for (;compareDates(tempDate, endDate); ) {
                    for (var index = 0; index < ruleObject.monthDay.length; index++) {
                        date = ruleObject.monthDay[index];
                        var maxDate = 1 === tempDate.getMonth() ? tempDate.getFullYear() % 4 == 0 ? 29 : 28 : monthDay[tempDate.getMonth()];
                        if ((date = date > 0 ? date : maxDate + date + 1) > 0 && function(tempDate, data, startDate) {
                            var maxDate = 1 === tempDate.getMonth() ? tempDate.getFullYear() % 4 == 0 ? 29 : 28 : monthDay[tempDate.getMonth()];
                            return data <= maxDate && tempDate >= startDate;
                        }(tempDate, date, mainDate)) {
                            if (tempDate.setDate(date), endDate && tempDate > endDate) return;
                            if (state = validateRules(tempDate, ruleObject), tempDate >= startDate && state && compareDates(tempDate, endDate) && (excludeDateHandler(data, tempDate.getTime()), 
                            expectedCount && data.length + tempExcludeDate.length >= expectedCount)) return;
                        }
                    }
                    monthInit = setNextValidDate(tempDate, ruleObject, monthInit, interval);
                }
            }(startDate, endDate, data, ruleObject);
        }
    }
    function getMaxYearDay(date) {
        return date % 4 == 0 ? LEAPYEAR : NORMALYEAR;
    }
    function setNextValidDate(tempDate, ruleObject, monthInit, interval, beginDate) {
        void 0 === beginDate && (beginDate = null);
        var monthData = beginDate ? beginDate.getMonth() : 0;
        return tempDate.setDate(1), ruleObject.month.length ? (monthInit++, monthInit %= ruleObject.month.length, 
        tempDate.setMonth(ruleObject.month[monthInit] - 1), 0 === monthInit && tempDate.setFullYear(tempDate.getFullYear() + interval)) : (beginDate && beginDate.getFullYear() < tempDate.getFullYear() && (monthData = tempDate.getMonth() - 1), 
        tempDate.setMonth((beginDate ? monthData : tempDate.getMonth()) + interval)), monthInit;
    }
    function compareDates(startDate, endDate) {
        return !endDate || startDate <= endDate;
    }
    function getStartDateForWeek(startDate, expectedDays) {
        var tempDate = new Date(startDate.getTime());
        if (-1 === expectedDays.indexOf(DAYINDEX[tempDate.getDay()])) do {
            tempDate.setDate(tempDate.getDate() + 1);
        } while (-1 === expectedDays.indexOf(DAYINDEX[tempDate.getDay()]));
        return tempDate;
    }
    function extractObjectFromRule(rules) {
        var temp, ruleObject = {
            freq: null,
            interval: 1,
            count: null,
            until: null,
            day: [],
            month: [],
            weekNo: [],
            monthDay: [],
            yearDay: [],
            setPosition: null,
            validRules: []
        }, splitData = [];
        if (rules.split(";").forEach(function(data) {
            switch ((splitData = data.split("="))[0]) {
              case "UNTIL":
                temp = splitData[1], ruleObject.until = getDateFromRecurrenceDateString(temp);
                break;

              case "BYDAY":
                ruleObject.day = splitData[1].split(","), ruleObject.validRules.push(splitData[0]);
                break;

              case "BYMONTHDAY":
                ruleObject.monthDay = splitData[1].split(",").map(Number), ruleObject.validRules.push(splitData[0]);
                break;

              case "BYMONTH":
                ruleObject.month = splitData[1].split(",").map(Number), ruleObject.validRules.push(splitData[0]);
                break;

              case "BYYEARDAY":
                ruleObject.yearDay = splitData[1].split(",").map(Number), ruleObject.validRules.push(splitData[0]);
                break;

              case "BYWEEKNO":
                ruleObject.weekNo = splitData[1].split(",").map(Number), ruleObject.validRules.push(splitData[0]);
                break;

              case "INTERVAL":
                ruleObject.interval = parseInt(splitData[1], 10);
                break;

              case "COUNT":
                ruleObject.count = parseInt(splitData[1], 10);
                break;

              case "BYSETPOS":
                ruleObject.setPosition = parseInt(splitData[1], 10);
                break;

              case "FREQ":
                ruleObject.freq = splitData[1];
            }
        }), "MONTHLY" === ruleObject.freq && 0 === ruleObject.monthDay.length) {
            var index = ruleObject.validRules.indexOf("BYDAY");
            ruleObject.validRules.splice(index, 1);
        }
        return ruleObject;
    }
    function processWeekDays(expectedDays) {
        var dayCycle = {};
        return expectedDays.forEach(function(element, index) {
            if (index === expectedDays.length - 1) {
                for (var startIndex = dayIndex.indexOf(element), temp = startIndex; temp % 7 !== dayIndex.indexOf(expectedDays[0]); ) temp++;
                dayCycle[element] = temp - startIndex;
            } else dayCycle[element] = dayIndex.indexOf(expectedDays[index + 1]) - dayIndex.indexOf(element);
        }), dayCycle;
    }
    function checkYear(tempDate, expectedyearDay) {
        var data, temp = expectedyearDay.slice(0), yearDay = function(currentDate) {
            startDateCollection[currentDate.getFullYear()] || (startDateCollection[currentDate.getFullYear()] = new Date(currentDate.getFullYear(), 0, 0));
            var tempDate = startDateCollection[currentDate.getFullYear()], diff = currentDate.getTime() - tempDate.getTime();
            return Math.ceil(diff / MS_PER_DAY);
        }(tempDate);
        for (data = temp.shift(); data; ) {
            if (data < 0 && (data = data + getMaxYearDay(tempDate.getFullYear()) + 1), data === yearDay) return !1;
            data = temp.shift();
        }
        return !0;
    }
    function rotate(days) {
        var data = days.shift();
        days.push(data);
    }
    function validateRules(tempDate, ruleObject) {
        var state = !0, expectedDays = ruleObject.day, expectedMonth = ruleObject.month, expectedDate = ruleObject.monthDay, expectedyearDay = ruleObject.yearDay;
        return ruleObject.validRules.forEach(function(rule) {
            switch (rule) {
              case "BYDAY":
                (function(day, expectedDays) {
                    return -1 === expectedDays.indexOf(DAYINDEX[day]);
                })(tempDate.getDay(), expectedDays) && (state = !1);
                break;

              case "BYMONTH":
                (function(tempDate, expectedMonth) {
                    return -1 === expectedMonth.indexOf(tempDate.getMonth() + 1);
                })(tempDate, expectedMonth) && (state = !1);
                break;

              case "BYMONTHDAY":
                (function(tempDate, expectedDate) {
                    var data, temp = expectedDate.slice(0), maxDate = 1 === tempDate.getMonth() ? tempDate.getFullYear() % 4 == 0 ? 29 : 28 : monthDay[tempDate.getMonth()];
                    for (data = temp.shift(); data; ) {
                        if (data < 0 && (data = data + maxDate + 1), data === tempDate.getDate()) return !1;
                        data = temp.shift();
                    }
                    return !0;
                })(tempDate, expectedDate) && (state = !1);
                break;

              case "BYYEARDAY":
                checkYear(tempDate, expectedyearDay) && (state = !1);
            }
        }), state;
    }
    function getRecurrenceStringFromDate(date) {
        return [ date.getUTCFullYear(), roundDateValues(date.getUTCMonth() + 1), roundDateValues(date.getUTCDate()), "T", roundDateValues(date.getUTCHours()), roundDateValues(date.getUTCMinutes()), roundDateValues(date.getUTCSeconds()), "Z" ].join("");
    }
    function roundDateValues(date) {
        return ("0" + date).slice(-2);
    }
    function getSeriesColor(theme) {
        var palette;
        switch (theme) {
          case "Fabric":
            palette = [ "#4472c4", "#ed7d31", "#ffc000", "#70ad47", "#5b9bd5", "#c1c1c1", "#6f6fe2", "#e269ae", "#9e480e", "#997300" ];
            break;

          case "Bootstrap":
            palette = [ "#a16ee5", "#f7ce69", "#55a5c2", "#7ddf1e", "#ff6ea6", "#7953ac", "#b99b4f", "#407c92", "#5ea716", "#b91c52" ];
            break;

          case "Highcontrast":
            palette = [ "#79ECE4", "#E98272", "#DFE6B6", "#C6E773", "#BA98FF", "#FA83C3", "#00C27A", "#43ACEF", "#D681EF", "#D8BC6E" ];
            break;

          default:
            palette = [ "#00bdae", "#404041", "#357cd2", "#e56590", "#f8b883", "#70ad47", "#dd8abd", "#7f84e8", "#7bb4eb", "#ea7a57" ];
        }
        return palette;
    }
    function getThemeColor(theme) {
        var style;
        switch (theme) {
          case "Highcontrast":
            style = {
                axisLabel: "#ffffff",
                axisTitle: "#ffffff",
                axisLine: "#ffffff",
                majorGridLine: "#BFBFBF",
                minorGridLine: "#969696",
                majorTickLine: "#BFBFBF",
                minorTickLine: "#969696",
                chartTitle: "#ffffff",
                legendLabel: "#ffffff",
                background: "#000000",
                areaBorder: "#ffffff",
                errorBar: "#ffffff",
                crosshairLine: "#ffffff",
                crosshairFill: "#ffffff",
                crosshairLabel: "#000000",
                tooltipFill: "#ffffff",
                tooltipBoldLabel: "#000000",
                tooltipLightLabel: "#000000",
                tooltipHeaderLine: "#969696",
                markerShadow: "#BFBFBF",
                selectionRectFill: "rgba(255, 217, 57, 0.3)",
                selectionRectStroke: "#ffffff",
                selectionCircleStroke: "#FFD939"
            };
            break;

          default:
            style = {
                axisLabel: "#686868",
                axisTitle: "#424242",
                axisLine: "#b5b5b5",
                majorGridLine: "#dbdbdb",
                minorGridLine: "#eaeaea",
                majorTickLine: "#b5b5b5",
                minorTickLine: "#d6d6d6",
                chartTitle: "#424242",
                legendLabel: "#353535",
                background: "#FFFFFF",
                areaBorder: "Gray",
                errorBar: "#000000",
                crosshairLine: "#4f4f4f",
                crosshairFill: "#4f4f4f",
                crosshairLabel: "#e5e5e5",
                tooltipFill: "rgba(0, 8, 22, 0.75)",
                tooltipBoldLabel: "#ffffff",
                tooltipLightLabel: "#dbdbdb",
                tooltipHeaderLine: "#ffffff",
                markerShadow: null,
                selectionRectFill: "rgba(41, 171, 226, 0.1)",
                selectionRectStroke: "#29abe2",
                selectionCircleStroke: "#29abe2"
            };
        }
        return style;
    }
    function measureText(text, font) {
        var htmlObject = document.getElementById("chartmeasuretext");
        return null === htmlObject && (htmlObject = createElement("text", {
            id: "chartmeasuretext"
        }), document.body.appendChild(htmlObject)), htmlObject.innerHTML = text, htmlObject.style.position = "absolute", 
        htmlObject.style.fontSize = font.size, htmlObject.style.fontWeight = font.fontWeight, 
        htmlObject.style.fontStyle = font.fontStyle, htmlObject.style.fontFamily = font.fontFamily, 
        htmlObject.style.visibility = "hidden", htmlObject.style.top = "-100", htmlObject.style.left = "0", 
        htmlObject.style.whiteSpace = "nowrap", htmlObject.style.lineHeight = "normal", 
        new Size(htmlObject.clientWidth, htmlObject.clientHeight);
    }
    function rotateTextSize(font, text, angle, chart) {
        var box, options, htmlObject, renderer = new SvgRenderer(chart.element.id);
        return options = {
            "font-size": font.size,
            "font-style": font.fontStyle,
            "font-family": font.fontFamily,
            "font-weight": font.fontWeight,
            transform: "rotate(" + angle + ", 0, 0)",
            "text-anchor": "middle"
        }, htmlObject = renderer.createText(options, text), chart.delayRedraw || chart.element.appendChild(chart.svgObject), 
        chart.svgObject.appendChild(htmlObject), box = htmlObject.getBoundingClientRect(), 
        remove(htmlObject), chart.delayRedraw || remove(chart.svgObject), new Size(box.right - box.left, box.bottom - box.top);
    }
    function removeElement$1(id) {
        var element = getElement(id);
        element && remove(element);
    }
    function logBase(value, base) {
        return Math.log(value) / Math.log(base);
    }
    function showTooltip(text, x, y, areaWidth, id, element, isTouch) {
        var tooltip = document.getElementById(id), width = measureText(text, {
            fontFamily: "Segoe UI",
            size: "12px",
            fontStyle: "Normal",
            fontWeight: "Regular"
        }).width + 5;
        x = x + width > areaWidth ? x - width : x, tooltip ? (tooltip.innerHTML = text, 
        tooltip.style.top = (y + 15).toString() + "px", tooltip.style.left = (x + 15).toString() + "px") : (tooltip = createElement("div", {
            innerHTML: text,
            id: id,
            styles: "top:" + (y + 15).toString() + "px;left:" + (x + 15).toString() + 'px;background-color: rgb(255, 255, 255);position:absolute;border:1px solid rgb(112, 112, 112); padding-left : 3px; padding-right : 2px;padding-bottom : 2px; padding-top : 2px; font-size:12px; font-family: "Segoe UI"'
        }), element.appendChild(tooltip)), isTouch && setTimeout(function() {
            removeElement$1(id);
        }, 1500);
    }
    function inside(value, range) {
        return value < range.max && value > range.min;
    }
    function withIn(value, range) {
        return value <= range.max && value >= range.min;
    }
    function withInRange(previousPoint, currentPoint, nextPoint, series) {
        var mX2 = series.logWithIn(currentPoint.xValue, series.xAxis), mX1 = previousPoint ? series.logWithIn(previousPoint.xValue, series.xAxis) : mX2, mX3 = nextPoint ? series.logWithIn(nextPoint.xValue, series.xAxis) : mX2, xStart = Math.floor(series.xAxis.visibleRange.min), xEnd = Math.ceil(series.xAxis.visibleRange.max);
        return mX1 >= xStart && mX1 <= xEnd || mX2 >= xStart && mX2 <= xEnd || mX3 >= xStart && mX3 <= xEnd || xStart >= mX1 && xStart <= mX3;
    }
    function sum(values) {
        for (var sum = 0, _i = 0, values_1 = values; _i < values_1.length; _i++) {
            sum += values_1[_i];
        }
        return sum;
    }
    function subArraySum(values, first, last, index, series) {
        var sum = 0;
        if (null !== index) for (var i = first + 1; i < last; i++) -1 === index.indexOf(i) && (sum += values[i][series.yName]); else for (i = first + 1; i < last; i++) isNullOrUndefined(values[i][series.yName]) || (sum += values[i][series.yName]);
        return sum;
    }
    function subtractThickness(rect, thickness) {
        return rect.x += thickness.left, rect.y += thickness.top, rect.width -= thickness.left + thickness.right, 
        rect.height -= thickness.top + thickness.bottom, rect;
    }
    function degreeToLocation(degree, radius, center) {
        var radian = degree * Math.PI / 180;
        return new ChartLocation(Math.cos(radian) * radius + center.x, Math.sin(radian) * radius + center.y);
    }
    function subArray(values, index) {
        for (var subArray = [], i = 0; i <= index - 1; i++) subArray.push(values[i]);
        return subArray;
    }
    function valueToCoefficient(value, axis) {
        var range = axis.visibleRange, result = (value - range.min) / range.delta;
        return axis.isInversed ? 1 - result : result;
    }
    function TransformToVisible(x, y, xAxis, yAxis, isInverted, series) {
        x = "Logarithmic" === xAxis.valueType ? logBase(x > 1 ? x : 1, xAxis.logBase) : x, 
        y = "Logarithmic" === yAxis.valueType ? logBase(y > 1 ? y : 1, yAxis.logBase) : y, 
        x += "Category" === xAxis.valueType && "BetweenTicks" === xAxis.labelPlacement && "Radar" !== series.type ? .5 : 0;
        var radius = series.chart.radius * valueToCoefficient(y, yAxis), point = CoefficientToVector(valueToPolarCoefficient(x, xAxis), series.chart.primaryXAxis.startAngle);
        return {
            x: series.clipRect.width / 2 + series.clipRect.x + radius * point.x,
            y: series.clipRect.height / 2 + series.clipRect.y + radius * point.y
        };
    }
    function indexFinder(id) {
        var ids = [ "NaN", "NaN" ];
        return id.indexOf("_Point_") > -1 ? ids = id.split("_Series_")[1].split("_Point_") : id.indexOf("_shape_") > -1 ? (ids = id.split("_shape_"))[0] = "0" : id.indexOf("_text_") > -1 && ((ids = id.split("_text_"))[0] = "0"), 
        new Index(parseInt(ids[0], 10), parseInt(ids[1], 10));
    }
    function CoefficientToVector(coefficient, startAngle) {
        startAngle = startAngle < 0 ? startAngle + 360 : startAngle;
        var angle = Math.PI * (1.5 - 2 * coefficient);
        return angle += startAngle * Math.PI / 180, {
            x: Math.cos(angle),
            y: Math.sin(angle)
        };
    }
    function valueToPolarCoefficient(value, axis) {
        var delta, length, range = axis.visibleRange;
        return "Category" !== axis.valueType ? (delta = range.max - ("DateTime" === axis.valueType ? axis.dateTimeInterval : range.interval) - range.min, 
        length = axis.visibleLabels.length - 1, delta = 0 === delta ? 1 : delta) : (delta = range.delta, 
        length = axis.visibleLabels.length), axis.isInversed ? (value - range.min) / delta * (1 - 1 / length) : 1 - (value - range.min) / delta * (1 - 1 / length);
    }
    function withInBounds(x, y, bounds, width, height) {
        return void 0 === width && (width = 0), void 0 === height && (height = 0), x >= bounds.x - width && x <= bounds.x + bounds.width + width && y >= bounds.y - height && y <= bounds.y + bounds.height + height;
    }
    function getValueXByPoint(value, size, axis) {
        return (axis.isInversed ? 1 - value / size : value / size) * axis.visibleRange.delta + axis.visibleRange.min;
    }
    function getValueYByPoint(value, size, axis) {
        return (axis.isInversed ? value / size : 1 - value / size) * axis.visibleRange.delta + axis.visibleRange.min;
    }
    function findClipRect(series) {
        var rect = series.clipRect;
        series.chart.requireInvertedAxis ? (rect.x = series.yAxis.rect.x, rect.y = series.xAxis.rect.y, 
        rect.width = series.yAxis.rect.width, rect.height = series.xAxis.rect.height) : (rect.x = series.xAxis.rect.x, 
        rect.y = series.yAxis.rect.y, rect.width = series.xAxis.rect.width, rect.height = series.yAxis.rect.height);
    }
    function firstToLowerCase(str) {
        return str.substr(0, 1).toLowerCase() + str.substr(1);
    }
    function getMinPointsDelta(axis, seriesCollection) {
        var xValues, minVal, minDelta = Number.MAX_VALUE;
        return seriesCollection.forEach(function(series, index) {
            xValues = [], series.visible && (axis.name === series.xAxisName || "primaryXAxis" === axis.name && null === series.xAxisName || axis.name === series.chart.primaryXAxis.name && !series.xAxisName) && ((xValues = series.points.map(function(point, index) {
                return point.xValue;
            })).sort(function(first, second) {
                return first - second;
            }), 1 === xValues.length ? 0 !== (minVal = xValues[0] - (series.xMin && "DateTime" !== series.xAxis.valueType ? series.xMin : axis.visibleRange.min)) && (minDelta = Math.min(minDelta, minVal)) : xValues.forEach(function(value, index, xValues) {
                index > 0 && value && 0 !== (minVal = value - xValues[index - 1]) && (minDelta = Math.min(minDelta, minVal));
            }));
        }), minDelta === Number.MAX_VALUE && (minDelta = 1), minDelta;
    }
    function getAnimationFunction(effect) {
        var functionName;
        switch (effect) {
          case "Linear":
            functionName = linear;
        }
        return functionName;
    }
    function linear(currentTime, startValue, endValue, duration) {
        return -endValue * Math.cos(currentTime / duration * (Math.PI / 2)) + endValue + startValue;
    }
    function markerAnimate(element, delay, duration, series, pointIndex, point, isLabel) {
        var centerX = point.x, centerY = point.y, height = 0;
        element.style.visibility = "hidden", new Animation({}).animate(element, {
            duration: duration,
            delay: delay,
            progress: function(args) {
                args.timeStamp > args.delay && (args.element.style.visibility = "visible", height = (args.timeStamp - args.delay) / args.duration, 
                element.setAttribute("transform", "translate(" + centerX + " " + centerY + ") scale(" + height + ") translate(" + -centerX + " " + -centerY + ")"));
            },
            end: function(model) {
                element.style.visibility = "", element.removeAttribute("transform"), "Scatter" !== series.type && "Bubble" !== series.type || isLabel || pointIndex !== series.points.length - 1 || series.chart.trigger("animationComplete", {
                    series: series
                });
            }
        });
    }
    function templateAnimate(element, delay, duration, name, isRemove) {
        new Animation({}).animate(element, {
            duration: duration,
            delay: delay,
            name: name,
            progress: function(args) {
                args.element.style.visibility = "visible";
            },
            end: function(args) {
                isRemove ? remove(args.element) : args.element.style.visibility = "visible";
            }
        });
    }
    function drawSymbol(location, shape, size, url, options, label) {
        var renderer = new SvgRenderer(""), temp = function(location, size, shape, options, url) {
            var path, functionName = "Path", width = size.width, height = size.height, locX = location.x, locY = location.y, x = location.x + -width / 2, y = location.y + -height / 2;
            switch (shape) {
              case "Circle":
              case "Bubble":
                functionName = "Ellipse", merge(options, {
                    rx: width / 2,
                    ry: height / 2,
                    cx: locX,
                    cy: locY
                });
                break;

              case "Cross":
                merge(options, {
                    d: path = "M " + x + " " + locY + " L " + (locX + width / 2) + " " + locY + " M " + locX + " " + (locY + height / 2) + " L " + locX + " " + (locY + -height / 2)
                });
                break;

              case "HorizontalLine":
                merge(options, {
                    d: path = "M " + x + " " + locY + " L " + (locX + width / 2) + " " + locY
                });
                break;

              case "VerticalLine":
                merge(options, {
                    d: path = "M " + locX + " " + (locY + height / 2) + " L " + locX + " " + (locY + -height / 2)
                });
                break;

              case "Diamond":
                merge(options, {
                    d: path = "M " + x + " " + locY + " L " + locX + " " + (locY + -height / 2) + " L " + (locX + width / 2) + " " + locY + " L " + locX + " " + (locY + height / 2) + " L " + x + " " + locY + " z"
                });
                break;

              case "Rectangle":
              case "Hilo":
              case "HiloOpenClose":
              case "Candle":
              case "Waterfall":
              case "BoxAndWhisker":
              case "StepArea":
                merge(options, {
                    d: path = "M " + x + " " + (locY + -height / 2) + " L " + (locX + width / 2) + " " + (locY + -height / 2) + " L " + (locX + width / 2) + " " + (locY + height / 2) + " L " + x + " " + (locY + height / 2) + " L " + x + " " + (locY + -height / 2) + " z"
                });
                break;

              case "Pyramid":
              case "Triangle":
                merge(options, {
                    d: path = "M " + x + " " + (locY + height / 2) + " L " + locX + " " + (locY + -height / 2) + " L " + (locX + width / 2) + " " + (locY + height / 2) + " L " + x + " " + (locY + height / 2) + " z"
                });
                break;

              case "Funnel":
              case "InvertedTriangle":
                merge(options, {
                    d: path = "M " + (locX + width / 2) + " " + (locY - height / 2) + " L " + locX + " " + (locY + height / 2) + " L " + (locX - width / 2) + " " + (locY - height / 2) + " L " + (locX + width / 2) + " " + (locY - height / 2) + " z"
                });
                break;

              case "Pentagon":
                for (var xValue = void 0, yValue = void 0, i = 0; i <= 5; i++) xValue = width / 2 * Math.cos(Math.PI / 180 * (72 * i)), 
                yValue = height / 2 * Math.sin(Math.PI / 180 * (72 * i)), path = 0 === i ? "M " + (locX + xValue) + " " + (locY + yValue) + " " : path.concat("L " + (locX + xValue) + " " + (locY + yValue) + " ");
                path = path.concat("Z"), merge(options, {
                    d: path
                });
                break;

              case "Image":
                functionName = "Image", merge(options, {
                    href: url,
                    height: height,
                    width: width,
                    x: x,
                    y: y
                });
            }
            return options = function(location, size, shape, options) {
                var path = "", height = size.height, width = size.width, locX = location.x, locY = location.y;
                switch (shape) {
                  case "MultiColoredLine":
                  case "Line":
                    merge(options, {
                        d: path = "M " + (locX + -width / 2) + " " + locY + " L " + (locX + width / 2) + " " + locY
                    });
                    break;

                  case "StepLine":
                    options.fill = "transparent", merge(options, {
                        d: path = "M " + (locX + -width / 2 - 2.5) + " " + (locY + height / 2) + " L " + (locX + -width / 2 + width / 10) + " " + (locY + height / 2) + " L " + (locX + -width / 2 + width / 10) + " " + locY + " L " + (locX + -width / 10) + " " + locY + " L " + (locX + -width / 10) + " " + (locY + height / 2) + " L " + (locX + width / 5) + " " + (locY + height / 2) + " L " + (locX + width / 5) + " " + (locY + -height / 2) + " L " + (locX + width / 2) + " " + (locY + -height / 2) + "L " + (locX + width / 2) + " " + (locY + height / 2) + " L" + (locX + width / 2 + 2.5) + " " + (locY + height / 2)
                    });
                    break;

                  case "RightArrow":
                    var space = 2;
                    merge(options, {
                        d: path = "M " + (locX + -width / 2) + " " + (locY - height / 2) + " L " + (locX + width / 2) + " " + locY + " L " + (locX + -width / 2) + " " + (locY + height / 2) + " L " + (locX + -width / 2) + " " + (locY + height / 2 - space) + " L " + (locX + width / 2 - 2 * space) + " " + locY + " L" + (locX + -width / 2) + " " + (locY - height / 2 + space) + " Z"
                    });
                    break;

                  case "LeftArrow":
                    options.fill = options.stroke, options.stroke = "transparent", merge(options, {
                        d: path = "M " + (locX + width / 2) + " " + (locY - height / 2) + " L " + (locX + -width / 2) + " " + locY + " L " + (locX + width / 2) + " " + (locY + height / 2) + " L " + (locX + width / 2) + " " + (locY + height / 2 - (space = 2)) + " L " + (locX + -width / 2 + 2 * space) + " " + locY + " L" + (locX + width / 2) + " " + (locY - height / 2 + space) + " Z"
                    });
                    break;

                  case "Column":
                  case "StackingColumn":
                  case "StackingColumn100":
                  case "RangeColumn":
                    merge(options, {
                        d: path = "M " + (locX - width / 5 * 3) + " " + (locY - height / 5) + " L " + (locX + -width / 10 * 3) + " " + (locY - height / 5) + " L " + (locX + -width / 10 * 3) + " " + (locY + height / 2) + " L " + (locX - width / 5 * 3) + " " + (locY + height / 2) + " Z M " + (locX + -width / 10 - width / 20) + " " + (locY - height / 4 - 5) + " L " + (locX + width / 10 + width / 20) + " " + (locY - height / 4 - 5) + " L " + (locX + width / 10 + width / 20) + " " + (locY + height / 2) + " L " + (locX + -width / 10 - width / 20) + " " + (locY + height / 2) + " Z M " + (locX + width / 10 * 3) + " " + locY + " L " + (locX + width / 5 * 3) + " " + locY + " L " + (locX + width / 5 * 3) + " " + (locY + height / 2) + " L " + (locX + width / 10 * 3) + " " + (locY + height / 2) + " Z"
                    });
                    break;

                  case "Bar":
                  case "StackingBar":
                  case "StackingBar100":
                    merge(options, {
                        d: path = "M " + (locX + -width / 2 + -2.5) + " " + (locY - height / 5 * 3) + " L " + (locX + width / 10 * 3) + " " + (locY - height / 5 * 3) + " L " + (locX + width / 10 * 3) + " " + (locY - height / 10 * 3) + " L " + (locX - width / 2 - 2.5) + " " + (locY - height / 10 * 3) + " Z M " + (locX + -width / 2 + -2.5) + " " + (locY - height / 5 + .5) + " L " + (locX + width / 2 + 2.5) + " " + (locY - height / 5 + .5) + " L " + (locX + width / 2 + 2.5) + " " + (locY + height / 10 + .5) + " L " + (locX - width / 2 - 2.5) + " " + (locY + height / 10 + .5) + " Z M " + (locX - width / 2 - 2.5) + " " + (locY + height / 5 + 1) + " L " + (locX + -width / 4) + " " + (locY + height / 5 + 1) + " L " + (locX + -width / 4) + " " + (locY + height / 2 + 1) + " L " + (locX - width / 2 - 2.5) + " " + (locY + height / 2 + 1) + " Z"
                    });
                    break;

                  case "Spline":
                    options.fill = "transparent", merge(options, {
                        d: path = "M " + (locX - width / 2) + " " + (locY + height / 5) + " Q " + locX + " " + (locY - height) + " " + locX + " " + (locY + height / 5) + " M " + locX + " " + (locY + height / 5) + " Q " + (locX + width / 2) + " " + (locY + height / 2) + " " + (locX + width / 2) + " " + (locY - height / 2)
                    });
                    break;

                  case "Area":
                  case "MultiColoredArea":
                  case "RangeArea":
                  case "StackingArea":
                  case "StackingArea100":
                    merge(options, {
                        d: path = "M " + (locX - width / 2 - 2.5) + " " + (locY + height / 2) + " L " + (locX + -width / 4 + -1.25) + " " + (locY - height / 2) + " L " + locX + " " + (locY + height / 4) + " L " + (locX + width / 4 + 1.25) + " " + (locY + -height / 2 + height / 4) + " L " + (locX + height / 2 + 2.5) + " " + (locY + height / 2) + " Z"
                    });
                    break;

                  case "SplineArea":
                    merge(options, {
                        d: path = "M " + (locX - width / 2) + " " + (locY + height / 5) + " Q " + locX + " " + (locY - height) + " " + locX + " " + (locY + height / 5) + " Z M " + locX + " " + (locY + height / 5) + " Q " + (locX + width / 2) + " " + (locY + height / 2) + " " + (locX + width / 2) + " " + (locY - height / 2) + "  Z"
                    });
                    break;

                  case "Pie":
                  case "Doughnut":
                    options.stroke = "transparent";
                    var r = Math.min(height, width) / 2;
                    path = function(locX, locY, r, height, width, mode) {
                        var cartesianlarge = degreeToLocation(270, r, new ChartLocation(locX, locY)), cartesiansmall = degreeToLocation(270, r, new ChartLocation(locX + width / 10, locY));
                        return "M " + locX + " " + locY + " L " + (locX + r) + " " + locY + " A " + r + " " + r + " 0 1 1 " + cartesianlarge.x + " " + cartesianlarge.y + " Z M " + (locX + width / 10) + " " + (locY - height / 10) + " L" + (locX + r) + " " + (locY - height / 10) + " A " + r + " " + r + " 0 0 0 " + cartesiansmall.x + " " + cartesiansmall.y + " Z";
                    }(locX, locY, r, height, width), merge(options, {
                        d: path
                    });
                }
                return {
                    renderOption: options
                };
            }(location, new Size(width, height), shape, options).renderOption, {
                renderOption: options,
                functionName: functionName
            };
        }(location, size, shape, options, url), htmlObject = renderer["draw" + temp.functionName](temp.renderOption);
        return htmlObject.setAttribute("aria-label", label), htmlObject;
    }
    function minMax(value, min, max) {
        return value > max ? max : value < min ? min : value;
    }
    function getElement(id) {
        return document.getElementById(id);
    }
    function createTemplate(childElement, pointIndex, content, chart, point, series) {
        var templateFn, templateElement;
        templateFn = function(template) {
            var templateFn = null;
            try {
                document.querySelectorAll(template).length && (templateFn = compile$$1(document.querySelector(template).innerHTML.trim()));
            } catch (e) {
                templateFn = compile$$1(template);
            }
            return templateFn;
        }(content);
        try {
            if (templateFn && templateFn({
                chart: chart,
                series: series,
                point: point
            }).length) for (templateElement = templateFn({
                chart: chart,
                series: series,
                point: point
            }); templateElement.length > 0; ) childElement.appendChild(templateElement[0]);
        } catch (e) {
            return childElement;
        }
        return childElement;
    }
    function getFontStyle(font) {
        return "font-size:" + font.size + "; font-style:" + font.fontStyle + "; font-weight:" + font.fontWeight + "; font-family:" + font.fontFamily + ";opacity:" + font.opacity + "; color:" + font.color + ";";
    }
    function measureElementRect(element) {
        var bounds;
        return document.body.appendChild(element), bounds = element.getBoundingClientRect(), 
        removeElement$1(element.id), bounds;
    }
    function getPoint(x, y, xAxis, yAxis, isInverted, series) {
        var xLength = isInverted ? xAxis.rect.height : xAxis.rect.width, yLength = isInverted ? yAxis.rect.width : yAxis.rect.height, xvalue = "Logarithmic" === xAxis.valueType ? logBase(x > 1 ? x : 1, xAxis.logBase) : x, yvalue = "Logarithmic" === yAxis.valueType ? logBase(y > 1 ? y : 1, yAxis.logBase) : y;
        xvalue = valueToCoefficient(xvalue, xAxis), yvalue = valueToCoefficient(yvalue, yAxis);
        return new ChartLocation(isInverted ? yvalue * yLength : xvalue * xLength, isInverted ? (1 - xvalue) * xLength : (1 - yvalue) * yLength);
    }
    function appendElement(child, parent) {
        if (!(child && child.hasChildNodes() && parent)) return null;
        parent.appendChild(child);
    }
    function getDraggedRectLocation(x1, y1, x2, y2, outerRect) {
        var width = Math.abs(x1 - x2), height = Math.abs(y1 - y2), x = Math.max(checkBounds(Math.min(x1, x2), width, outerRect.x, outerRect.width), outerRect.x), y = Math.max(checkBounds(Math.min(y1, y2), height, outerRect.y, outerRect.height), outerRect.y);
        return new Rect(x, y, Math.min(width, outerRect.width), Math.min(height, outerRect.height));
    }
    function checkBounds(start, size, min, max) {
        return start < min ? start = min : start + size > max + min && (start = max + min - size), 
        start;
    }
    function stopTimer(timer) {
        window.clearInterval(timer);
    }
    function isCollide$2(rect, collections, clipRect) {
        var currentRect = new Rect(rect.x + clipRect.x, rect.y + clipRect.y, rect.width, rect.height);
        return collections.some(function(rect) {
            return currentRect.x < rect.x + rect.width && currentRect.x + currentRect.width > rect.x && currentRect.y < rect.y + rect.height && currentRect.height + currentRect.y > rect.y;
        });
    }
    function isOverlap(currentRect, rect) {
        return currentRect.x < rect.x + rect.width && currentRect.x + currentRect.width > rect.x && currentRect.y < rect.y + rect.height && currentRect.height + currentRect.y > rect.y;
    }
    function calculateRect(location, textSize, margin) {
        return new Rect(location.x - textSize.width / 2 - margin.left, location.y - textSize.height / 2 - margin.top, textSize.width + margin.left + margin.right, textSize.height + margin.top + margin.bottom);
    }
    function componentToHex(value) {
        var hex = value.toString(16);
        return 1 === hex.length ? "0" + hex : hex;
    }
    function convertHexToColor(hex) {
        var result = /^#?([a-f\d]{2})([a-f\d]{2})([a-f\d]{2})$/i.exec(hex);
        return result ? new ColorValue(parseInt(result[1], 16), parseInt(result[2], 16), parseInt(result[3], 16)) : new ColorValue(255, 255, 255);
    }
    function colorNameToHex(color) {
        var element;
        color = "transparent" === color ? "white" : color, (element = document.getElementById("chartmeasuretext")).style.color = color, 
        color = window.getComputedStyle(element).color;
        var isRGBValue = /^(rgb|hsl)(a?)[(]\s*([\d.]+\s*%?)\s*,\s*([\d.]+\s*%?)\s*,\s*([\d.]+\s*%?)\s*(?:,\s*([\d.]+)\s*)?[)]$/.exec(color);
        return function(value) {
            return "#" + componentToHex(value.r) + componentToHex(value.g) + componentToHex(value.b);
        }(new ColorValue(parseInt(isRGBValue[3], 10), parseInt(isRGBValue[4], 10), parseInt(isRGBValue[5], 10)));
    }
    function getSaturationColor(color, factor) {
        (color = (color = colorNameToHex(color)).replace(/[^0-9a-f]/gi, "")).length < 6 && (color = color[0] + color[0] + color[1] + color[1] + color[2] + color[2]), 
        factor = factor || 0;
        for (var colorCode, rgb = "#", i = 0; i < 3; i++) colorCode = parseInt(color.substr(2 * i, 2), 16), 
        rgb += ("00" + (colorCode = Math.round(Math.min(Math.max(0, colorCode + colorCode * factor), 255))).toString(16)).substr(colorCode.toString(16).length);
        return rgb;
    }
    function getMedian(values) {
        var half = Math.floor(values.length / 2);
        return values.length % 2 ? values[half] : (values[half - 1] + values[half]) / 2;
    }
    function textTrim(maxWidth, text, font) {
        var label = text, size = measureText(text, font).width;
        if (size > maxWidth) for (var i = text.length - 1; i >= 0; --i) if (label = text.substring(0, i) + "...", 
        (size = measureText(label, font).width) <= maxWidth) return label;
        return label;
    }
    function stringToNumber(value, containerSize) {
        return null !== value && void 0 !== value ? -1 !== value.indexOf("%") ? containerSize / 100 * parseInt(value, 10) : parseInt(value, 10) : null;
    }
    function findDirection(rX, rY, rect, arrowLocation, arrowPadding, top, bottom, left, tipX, tipY, tipRadius) {
        var direction = "", startX = rect.x, startY = rect.y, width = rect.x + rect.width, height = rect.y + rect.height;
        return tipRadius = tipRadius || 0, top ? (direction = (direction = direction.concat("M " + startX + " " + (startY + rY) + " Q " + startX + " " + startY + " " + (startX + rX) + " " + startY + "  L " + (width - rX) + " " + startY + " Q " + width + " " + startY + " " + width + " " + (startY + rY))).concat(" L " + width + " " + (height - rY) + " Q " + width + " " + height + " " + (width - rX) + " " + height), 
        0 !== arrowPadding && (direction = (direction = direction.concat(" L " + (arrowLocation.x + arrowPadding / 2) + " " + height)).concat(" L " + (tipX + tipRadius) + " " + (height + arrowPadding - tipRadius)), 
        direction += " Q " + tipX + " " + (height + arrowPadding) + " " + (tipX - tipRadius) + " " + (height + arrowPadding - tipRadius)), 
        direction = arrowLocation.x - arrowPadding / 2 > startX ? direction.concat(" L " + (arrowLocation.x - arrowPadding / 2) + " " + height + " L " + (startX + rX) + " " + height + " Q " + startX + " " + height + " " + startX + " " + (height - rY) + " z") : 0 === arrowPadding ? direction.concat(" L " + (startX + rX) + " " + height + " Q " + startX + " " + height + " " + startX + " " + (height - rY) + " z") : direction.concat(" L " + startX + " " + (height + rY) + " z")) : bottom ? (direction = (direction = direction.concat("M " + startX + " " + (startY + rY) + " Q " + startX + " " + startY + " " + (startX + rX) + " " + startY + " L " + (arrowLocation.x - arrowPadding / 2) + " " + startY)).concat(" L " + (tipX - tipRadius) + " " + (arrowLocation.y + tipRadius)), 
        direction = (direction = (direction += " Q " + tipX + " " + arrowLocation.y + " " + (tipX + tipRadius) + " " + (arrowLocation.y + tipRadius)).concat(" L " + (arrowLocation.x + arrowPadding / 2) + " " + startY + " L " + (width - rX) + " " + startY + " Q " + width + " " + startY + " " + width + " " + (startY + rY))).concat(" L " + width + " " + (height - rY) + " Q " + width + " " + height + " " + (width - rX) + " " + height + " L " + (startX + rX) + " " + height + " Q " + startX + " " + height + " " + startX + " " + (height - rY) + " z")) : left ? (direction = (direction = (direction = direction.concat("M " + startX + " " + (startY + rY) + " Q " + startX + " " + startY + " " + (startX + rX) + " " + startY)).concat(" L " + (width - rX) + " " + startY + " Q " + width + " " + startY + " " + width + " " + (startY + rY) + " L " + width + " " + (arrowLocation.y - arrowPadding / 2))).concat(" L " + (width + arrowPadding - tipRadius) + " " + (tipY - tipRadius)), 
        direction = (direction = (direction += " Q " + (width + arrowPadding) + " " + tipY + " " + (width + arrowPadding - tipRadius) + " " + (tipY + tipRadius)).concat(" L " + width + " " + (arrowLocation.y + arrowPadding / 2) + " L " + width + " " + (height - rY) + " Q " + width + " " + height + " " + (width - rX) + " " + height)).concat(" L " + (startX + rX) + " " + height + " Q " + startX + " " + height + " " + startX + " " + (height - rY) + " z")) : (direction = (direction = direction.concat("M " + (startX + rX) + " " + startY + " Q " + startX + " " + startY + " " + startX + " " + (startY + rY) + " L " + startX + " " + (arrowLocation.y - arrowPadding / 2))).concat(" L " + (startX - arrowPadding + tipRadius) + " " + (tipY - tipRadius)), 
        direction = (direction = (direction += " Q " + (startX - arrowPadding) + " " + tipY + " " + (startX - arrowPadding + tipRadius) + " " + (tipY + tipRadius)).concat(" L " + startX + " " + (arrowLocation.y + arrowPadding / 2) + " L " + startX + " " + (height - rY) + " Q " + startX + " " + height + " " + (startX + rX) + " " + height)).concat(" L " + (width - rX) + " " + height + " Q " + width + " " + height + " " + width + " " + (height - rY) + " L " + width + " " + (startY + rY) + " Q " + width + " " + startY + " " + (width - rX) + " " + startY + " z")), 
        direction;
    }
    function textElement(options, font, color, parent, isMinus) {
        void 0 === isMinus && (isMinus = !1);
        var htmlObject, tspanElement, text, height, renderOptions = {}, renderer = new SvgRenderer("");
        if (renderOptions = {
            id: options.id,
            x: options.x,
            y: options.y,
            fill: color,
            "font-size": font.size,
            "font-style": font.fontStyle,
            "font-family": font.fontFamily,
            "font-weight": font.fontWeight,
            "text-anchor": options.anchor,
            transform: options.transform,
            opacity: font.opacity,
            "dominant-baseline": options.baseLine
        }, text = "string" == typeof options.text ? options.text : isMinus ? options.text[options.text.length - 1] : options.text[0], 
        htmlObject = renderer.createText(renderOptions, text), "string" != typeof options.text && options.text.length > 1) for (var i = 1, len = options.text.length; i < len; i++) height = measureText(options.text[i], font).height, 
        tspanElement = renderer.createTSpan({
            x: options.x,
            id: options.id,
            y: options.y + (isMinus ? -i * height : i * height)
        }, isMinus ? options.text[options.text.length - (i + 1)] : options.text[i]), htmlObject.appendChild(tspanElement);
        return parent.appendChild(htmlObject), htmlObject;
    }
    function calculateSize(chart) {
        var containerWidth = chart.element.clientWidth, containerHeight = chart.element.clientHeight;
        chart.availableSize = new Size(stringToNumber(chart.width, containerWidth) || containerWidth || 600, stringToNumber(chart.height, containerHeight) || containerHeight || 450);
    }
    function createSvg(chart) {
        chart.renderer = new SvgRenderer(chart.element.id), calculateSize(chart), chart.svgObject = chart.renderer.createSvg({
            id: chart.element.id + "_svg",
            width: chart.availableSize.width,
            height: chart.availableSize.height
        });
    }
    function getTitle(title, style, width) {
        var titleCollection = [];
        switch (style.textOverflow) {
          case "Wrap":
            titleCollection = textWrap(title, width, style);
            break;

          case "Trim":
            titleCollection.push(textTrim(width, title, style));
            break;

          default:
            titleCollection.push(title);
        }
        return titleCollection;
    }
    function titlePositionX(chartSize, leftPadding, rightPadding, titleStyle) {
        return "Near" === titleStyle.textAlignment ? leftPadding : "Center" === titleStyle.textAlignment ? chartSize.width / 2 : chartSize.width - rightPadding;
    }
    function textWrap(currentLabel, maximumWidth, font) {
        for (var text, textCollection = currentLabel.split(" "), label = "", labelCollection = [], i = 0, len = textCollection.length; i < len; i++) text = textCollection[i], 
        measureText(label.concat(text), font).width < maximumWidth ? label = label.concat(("" === label ? "" : " ") + text) : "" !== label ? (labelCollection.push(textTrim(maximumWidth, label, font)), 
        label = text) : (labelCollection.push(textTrim(maximumWidth, text, font)), text = ""), 
        label && i === len - 1 && labelCollection.push(textTrim(maximumWidth, label, font));
        return labelCollection;
    }
    function pointByIndex(index, points) {
        for (var _i = 0, points_1 = points; _i < points_1.length; _i++) {
            var point = points_1[_i];
            if (point.index === index) return point;
        }
        return null;
    }
    function validateNullOrUndefined(value, message) {
        if (null === value || void 0 === value) throw new Error("ArgumentException: " + message + " cannot be null or undefined");
    }
    function defaultToString(item) {
        return "[object String]" === Object.prototype.toString.call(item) ? "$s" + item : "$o" + item.toString();
    }
    function measureText$1(text, font) {
        var htmlObject = document.getElementById("gauge-measuretext");
        null === htmlObject && (htmlObject = createElement("text", {
            id: "gauge-measuretext"
        }), document.body.appendChild(htmlObject));
        var style = "position: absolute; visibility: hidden;;left: 0; top: -100; white-space: nowrap;" + getFontStyle$1(font);
        return htmlObject.innerHTML = text, htmlObject.setAttribute("style", style), new Size$1(htmlObject.clientWidth, htmlObject.clientHeight);
    }
    function toPixel(value, maxDimension) {
        return null !== value && void 0 !== value ? -1 !== value.indexOf("%") ? maxDimension / 100 * parseInt(value, 10) : parseInt(value, 10) : null;
    }
    function getFontStyle$1(font) {
        return "font-size:" + font.size + "; font-style:" + font.fontStyle + "; font-weight:" + font.fontWeight + "; font-family:" + font.fontFamily + ";opacity:" + font.opacity + "; color:" + font.color + ";";
    }
    function setStyles(element, fill, border) {
        setStyleAttribute(element, {
            stroke: border.color,
            "stroke-width": border.width,
            fill: fill
        });
    }
    function stringToNumber$1(value, containerSize) {
        return null !== value && void 0 !== value ? -1 !== value.indexOf("%") ? containerSize / 100 * parseInt(value, 10) : parseInt(value, 10) : null;
    }
    function textElement$1(options, font, color, parent, styles) {
        var htmlObject, renderOptions = {}, renderer = new SvgRenderer(""), style = styles + " font-size:" + font.size + "; font-style:" + font.fontStyle + " ; font-weight:" + font.fontWeight + "; font-family:" + font.fontFamily + ";";
        return renderOptions = {
            id: options.id,
            x: options.x,
            y: options.y,
            fill: color,
            "text-anchor": options.anchor,
            transform: options.transform,
            opacity: font.opacity,
            "dominant-baseline": options.baseLine,
            style: style
        }, htmlObject = renderer.createText(renderOptions, options.text), parent.appendChild(htmlObject), 
        htmlObject;
    }
    function appendPath(options, element, gauge, functionName) {
        functionName = functionName || "Path";
        var htmlObject = gauge.renderer["draw" + functionName](options);
        return htmlObject.setAttribute("transform", options.transform), htmlObject.setAttribute("style", options.style), 
        element.appendChild(htmlObject), htmlObject;
    }
    function linear$1(currentTime, startValue, endValue, duration) {
        return -endValue * Math.cos(currentTime / duration * (Math.PI / 2)) + endValue + startValue;
    }
    function getAngleFromValue(value, maximumValue, minimumValue, startAngle, endAngle, isClockWise) {
        var angle;
        return endAngle -= isCompleteAngle(startAngle, endAngle) ? 1e-4 : 0, startAngle -= 90, 
        endAngle -= 90, angle = isClockWise ? (value - minimumValue) * (getDegree(startAngle, endAngle) / (maximumValue - minimumValue)) + startAngle : (angle = endAngle - (value - minimumValue) * (getDegree(startAngle, endAngle) / (maximumValue - minimumValue))) < 0 ? 360 + angle : angle, 
        angle = Math.round(angle) >= 360 ? angle - 360 : Math.round(angle) < 0 ? 360 + angle : angle;
    }
    function getDegree(startAngle, endAngle) {
        var degree = endAngle - startAngle;
        return degree < 0 ? degree + 360 : degree;
    }
    function isCompleteAngle(startAngle, endAngle) {
        var totalAngle = endAngle - startAngle;
        return totalAngle = totalAngle <= 0 ? totalAngle + 360 : totalAngle, 0 !== Math.floor(totalAngle / 360);
    }
    function getLocationFromAngle(degree, radius, center) {
        var radian = degree * Math.PI / 180;
        return new GaugeLocation(Math.cos(radian) * radius + center.x, Math.sin(radian) * radius + center.y);
    }
    function getPathArc(center, start, end, radius, startWidth, endWidth) {
        var degree = getDegree(start, end -= isCompleteAngle(start, end) ? 1e-4 : 0), startRadius = radius - startWidth, endRadius = radius - endWidth, arcRadius = radius - (startWidth + endWidth) / 2;
        return void 0 !== startWidth && void 0 !== endWidth ? function(start, end, innerStart, innerEnd, radius, startRadius, endRadius, clockWise) {
            return "M " + start.x + " " + start.y + " A " + radius + " " + radius + " 0 " + clockWise + " 1 " + end.x + " " + end.y + " L " + innerEnd.x + " " + innerEnd.y + " A " + endRadius + " " + startRadius + " 0 " + clockWise + " 0 " + innerStart.x + " " + innerStart.y + " Z";
        }(getLocationFromAngle(start, radius, center), getLocationFromAngle(end, radius, center), getLocationFromAngle(start, startRadius, center), getLocationFromAngle(end, endRadius, center), radius, arcRadius, arcRadius, degree < 180 ? 0 : 1) : function(start, end, radius, clockWise) {
            return "M " + start.x + " " + start.y + " A " + radius + " " + radius + " 0 " + clockWise + " 1 " + end.x + " " + end.y;
        }(getLocationFromAngle(start, radius, center), getLocationFromAngle(end, radius, center), radius, degree < 180 ? 0 : 1);
    }
    function getCompleteArc(center, start, end, radius, innerRadius) {
        var degree = getDegree(start, end -= isCompleteAngle(start, end) ? 1e-4 : 0);
        return function(center, start, end, radius, innerStart, innerEnd, innerRadius, clockWise) {
            return "M " + start.x + " " + start.y + " A " + radius + " " + radius + " 0 " + clockWise + " 1 " + end.x + " " + end.y + " L " + innerEnd.x + " " + innerEnd.y + " A " + innerRadius + " " + innerRadius + " 0 " + clockWise + ",0 " + innerStart.x + " " + innerStart.y + " Z";
        }(0, getLocationFromAngle(start, radius, center), getLocationFromAngle(end, radius, center), radius, getLocationFromAngle(start, innerRadius, center), getLocationFromAngle(end, innerRadius, center), innerRadius, degree < 180 ? 0 : 1);
    }
    function getElement$1(id) {
        return document.getElementById(id);
    }
    function getTemplateFunction$1(template) {
        var templateFn = null;
        try {
            document.querySelectorAll(template).length && (templateFn = compile$$1(document.querySelector(template).innerHTML.trim()));
        } catch (e) {
            templateFn = compile$$1(template);
        }
        return templateFn;
    }
    function removeElement$2(id) {
        var element = getElement$1(id);
        element && remove(element);
    }
    function getPointer(targetId, gauge) {
        var tempString;
        return tempString = targetId.split(gauge.element.id + "_Axis_")[1], {
            axisIndex: +tempString[0],
            pointerIndex: +tempString[tempString.length - 1]
        };
    }
    function getLabelFormat(format) {
        return format && null !== format.match("{value}") ? "" : format;
    }
    function calculateShapes$1(location, shape, size, url, options) {
        var width = size.width, height = size.height, locX = location.x, locY = location.y, x = location.x + -width / 2, y = location.y + -height / 2;
        switch (shape) {
          case "Circle":
            merge(options, {
                rx: width / 2,
                ry: height / 2,
                cx: locX,
                cy: locY
            });
            break;

          case "Diamond":
            merge(options, {
                d: "M " + x + " " + locY + " L " + locX + " " + (locY + -height / 2) + " L " + (locX + width / 2) + " " + locY + " L " + locX + " " + (locY + height / 2) + " L " + x + " " + locY + " Z"
            });
            break;

          case "Rectangle":
            merge(options, {
                d: "M " + x + " " + (locY + -height / 2) + " L " + (locX + width / 2) + " " + (locY + -height / 2) + " L " + (locX + width / 2) + " " + (locY + height / 2) + " L " + x + " " + (locY + height / 2) + " L " + x + " " + (locY + -height / 2) + " Z"
            });
            break;

          case "Triangle":
            merge(options, {
                d: "M " + locX + " " + locY + " L " + (locX - height) + " " + (locY - width / 2) + "L " + (locX - height) + " " + (locY + width / 2) + " Z"
            });
            break;

          case "InvertedTriangle":
            merge(options, {
                d: "M " + locX + " " + locY + " L " + (locX + height) + " " + (locY - width / 2) + "L " + (locX + height) + " " + (locY + width / 2) + " Z"
            });
            break;

          case "Image":
            merge(options, {
                href: url,
                height: height,
                width: width,
                x: x,
                y: y
            });
        }
        return options;
    }
    function getRangeColor(value, ranges, color) {
        var min = 0, max = 0, currentRange = ranges.filter(function(range) {
            return min = Math.min(range.start, range.end), max = Math.max(range.start, range.end), 
            value >= min && max >= value;
        });
        return currentRange.length ? currentRange[0].rangeColor : color;
    }
    function setStateAndProperties(target, attribute, value, remove) {
        remove ? target.removeAttribute(attribute) : target && target.setAttribute(attribute, value);
    }
    function stringToNumber$2(value, containerSize) {
        return null !== value && void 0 !== value ? -1 !== value.indexOf("%") ? containerSize / 100 * parseInt(value, 10) : parseInt(value, 10) : null;
    }
    function measureText$2(text, font) {
        var htmlObject = document.getElementById("gauge-measuretext");
        return null === htmlObject && (htmlObject = createElement("text", {
            id: "gauge-measuretext"
        }), document.body.appendChild(htmlObject)), htmlObject.innerHTML = text, htmlObject.style.position = "absolute", 
        htmlObject.style.fontSize = font.size, htmlObject.style.fontWeight = font.fontWeight, 
        htmlObject.style.fontStyle = font.fontStyle, htmlObject.style.fontFamily = font.fontFamily, 
        htmlObject.style.visibility = "hidden", htmlObject.style.top = "-100", htmlObject.style.left = "0", 
        htmlObject.style.whiteSpace = "nowrap", new Size$2(htmlObject.clientWidth, htmlObject.clientHeight);
    }
    function withInRange$1(value, start, end, max, min, type) {
        return "pointer" === type ? value <= max && value >= min : null != start && start <= max && start >= min && null != end && end <= max && end >= min;
    }
    function convertPixelToValue(parentElement, pointerElement, orientation, axis, type, location) {
        var elementRect = parentElement.getBoundingClientRect(), pointerRect = pointerElement.getBoundingClientRect(), height = pointerElement.id.indexOf("MarkerPointer") > -1 ? pointerRect.height / 2 : axis.isInversed ? pointerRect.height : 0, width = pointerElement.id.indexOf("MarkerPointer") > -1 ? pointerRect.width / 2 : axis.isInversed ? 0 : pointerRect.width, size = new Size$2(axis.lineBounds.width, axis.lineBounds.height), y = "drag" === type ? location.y - axis.lineBounds.y : pointerRect.top + height - elementRect.top - axis.lineBounds.y, x = "drag" === type ? location.x - axis.lineBounds.x : pointerRect.left + width - elementRect.left - axis.lineBounds.x, newSize = "Vertical" === orientation ? size.height : size.width, divideVal = "Vertical" === orientation ? y : x, value = "Vertical" === orientation ? axis.isInversed ? divideVal / newSize : 1 - divideVal / newSize : axis.isInversed ? 1 - divideVal / newSize : divideVal / newSize;
        return value = value * axis.visibleRange.delta + axis.visibleRange.min;
    }
    function getElement$2(id) {
        return document.getElementById(id);
    }
    function isPointerDrag(axes) {
        var pointerEnable = !1;
        return axes.map(function(axis, index) {
            axis.pointers.map(function(pointer, index) {
                pointer.enableDrag && (pointerEnable = !0);
            });
        }), pointerEnable;
    }
    function valueToCoefficient$1(value, axis, orientation, range) {
        var result = (value - range.min) / range.delta;
        return result = "Vertical" === orientation ? axis.isInversed ? result : 1 - result : axis.isInversed ? 1 - result : result;
    }
    function getLabelFormat$1(format) {
        return format && null !== format.match("{value}") ? "" : format;
    }
    function getTemplateFunction$2(template) {
        var templateFn = null;
        try {
            document.querySelectorAll(template).length && (templateFn = compile$$1(document.querySelector(template).innerHTML.trim()));
        } catch (e) {
            templateFn = compile$$1(template);
        }
        return templateFn;
    }
    function textElement$2(options, font, color, parent) {
        var htmlObject, renderOptions = {}, renderer = new SvgRenderer(""), style = "fill:" + color + "; font-size:" + font.size + "; font-style:" + font.fontStyle + " ; font-weight:" + font.fontWeight + "; font-family:" + font.fontFamily + "; text-anchor:" + options.anchor + "; transform:" + options.transform + "; opacity:" + font.opacity + "; dominant-baseline:" + options.baseLine + ";";
        return renderOptions = {
            id: options.id,
            x: options.x,
            y: options.y,
            style: style
        }, htmlObject = renderer.createText(renderOptions, options.text), parent.appendChild(htmlObject), 
        htmlObject;
    }
    function calculateNiceInterval(min, max, size, orientation) {
        for (var currentInterval, delta = max - min, desiredIntervalsCount = function(size, orientation) {
            var desiredIntervalsCount = 5 * ("Horizontal" === orientation ? .533 : 1);
            return desiredIntervalsCount = Math.max(size * (desiredIntervalsCount / 100), 1);
        }(size, orientation), niceInterval = delta / desiredIntervalsCount, minInterval = Math.pow(10, Math.floor(Math.log(niceInterval) / Math.log(10))), _i = 0, intervalDivs_1 = [ 10, 5, 2, 1 ]; _i < intervalDivs_1.length; _i++) {
            if (currentInterval = minInterval * intervalDivs_1[_i], desiredIntervalsCount < delta / currentInterval) break;
            niceInterval = currentInterval;
        }
        return niceInterval;
    }
    function getPointer$1(target, gauge) {
        var axisIndex, pointIndex, axis, pointer, split = [];
        return split = target.id.split("_"), axisIndex = parseInt(split[2], 10), pointIndex = parseInt(split[4], 10), 
        axis = gauge.axes[axisIndex], pointer = gauge.axes[axisIndex].pointers[pointIndex], 
        {
            axis: axis,
            axisIndex: axisIndex,
            pointer: pointer,
            pointerIndex: pointIndex
        };
    }
    function getRangeColor$1(value, ranges) {
        var rangeColor = null;
        return ranges.forEach(function(range, index) {
            value >= range.start && range.end >= value && (rangeColor = range.interior);
        }), rangeColor;
    }
    function calculateShapes$2(location, shape, size, url, options, orientation, axis, pointer) {
        var radius, width = size.width, height = size.height, locX = location.x, locY = location.y;
        switch (shape) {
          case "Circle":
            merge(options, {
                r: radius = (width + height) / 4,
                cx: locX = "Vertical" === orientation ? axis.opposedPosition ? "Near" === pointer.placement ? locX - radius : locX + radius : "Far" !== pointer.placement ? locX - radius : locX + radius : locX,
                cy: locY = "Vertical" === orientation ? locY : axis.opposedPosition ? "Near" === pointer.placement ? locY - radius : locY + radius : "Far" === pointer.placement ? locY + radius : locY - radius
            });
            break;

          case "Diamond":
          case "Rectangle":
            locX = "Horizontal" === orientation ? locX - width / 2 : !axis.opposedPosition && "Far" !== pointer.placement || axis.opposedPosition && "Near" === pointer.placement ? locX - width : locX, 
            locY = "Vertical" === orientation ? locY : axis.opposedPosition ? "Near" === pointer.placement ? locY - height / 2 : locY + height / 2 : "Far" === pointer.placement ? locY + height / 2 : locY - height / 2, 
            merge(options, {
                d: "Diamond" === shape ? "M " + locX + " " + locY + " L " + (locX + width / 2) + " " + (locY - height / 2) + " L " + (locX + width) + " " + locY + " L " + (locX + width / 2) + " " + (locY + height / 2) + " L " + locX + " " + locY + " z" : "M " + locX + " " + (locY - height / 2) + " L " + (locX + width) + " " + (locY - height / 2) + " L " + (locX + width) + " " + (locY + height / 2) + " L " + locX + " " + (locY + height / 2) + " L " + locX + " " + (locY - height / 2) + " z"
            });
            break;

          case "Triangle":
            merge(options, {
                d: "Vertical" === orientation ? "M " + locX + " " + locY + " L" + (locX - width) + " " + (locY - height / 2) + "L" + (locX - width) + " " + (locY + height / 2) + " Z" : "M " + locX + " " + locY + " L" + (locX + width / 2) + " " + (locY - height) + "L" + (locX - width / 2) + " " + (locY - height) + " Z"
            });
            break;

          case "InvertedTriangle":
            merge(options, {
                d: "Vertical" === orientation ? "M " + locX + " " + locY + " L" + (locX + width) + " " + (locY - height / 2) + "L" + (locX + width) + " " + (locY + height / 2) + " Z" : "M " + locX + " " + locY + " L" + (locX + width / 2) + " " + (locY + height) + "L" + (locX - width / 2) + " " + (locY + height) + " Z"
            });
            break;

          case "Arrow":
            merge(options, {
                d: "Vertical" === orientation ? "M " + locX + " " + locY + " L" + (locX - width / 2) + " " + (locY - height / 2) + " L" + (locX - width / 2) + " " + (locY - height / 2 + height / 4) + " L" + (locX - width) + " " + (locY - height / 2 + height / 4) + " L" + (locX - width) + " " + (locY + height / 2 - height / 4) + " L" + (locX - width / 2) + " " + (locY + height / 2 - height / 4) + " L" + (locX - width / 2) + " " + (locY + height / 2) + "z" : "M " + locX + " " + locY + " L" + (locX + width / 2) + " " + (locY - height / 2) + " L" + (locX + width / 2 - width / 4) + " " + (locY - height / 2) + " L" + (locX + width / 2 - width / 4) + " " + (locY - height) + " L" + (locX - width / 2 + width / 4) + " " + (locY - height) + " L" + (locX - width / 2 + width / 4) + " " + (locY - height / 2) + " L" + (locX - width / 2) + " " + (locY - height / 2) + "z"
            });
            break;

          case "InvertedArrow":
            merge(options, {
                d: "Vertical" === orientation ? "M " + locX + " " + locY + "L" + (locX + width / 2) + " " + (locY - height / 2) + " L" + (locX + width / 2) + " " + (locY - height / 2 + height / 4) + " L" + (locX + width) + " " + (locY - height / 2 + height / 4) + " L" + (locX + width) + " " + (locY + height / 2 - height / 4) + " L" + (locX + width / 2) + " " + (locY + height / 2 - height / 4) + " L" + (locX + width / 2) + " " + (locY + height / 2) + "z" : "M " + locX + " " + locY + " L" + (locX + width / 2) + " " + (locY + height / 2) + " L" + (locX + width / 2 - width / 4) + " " + (locY + height / 2) + " L" + (locX + width / 2 - width / 4) + " " + (locY + height) + " L" + (locX - width / 2 + width / 4) + " " + (locY + height) + " L" + (locX - width / 2 + width / 4) + " " + (locY + height / 2) + " L" + (locX - width / 2) + " " + (locY + height / 2) + "z"
            });
            break;

          case "Image":
            merge(options, {
                href: url,
                height: height,
                width: width,
                x: locX - width / 2,
                y: locY - height / 2
            });
        }
        return options;
    }
    function getBox(location, boxName, orientation, size, type, containerWidth, axis, cornerRadius) {
        var x1, y1, rectWidth, rectHeight, bottomRadius, topRadius, path = " ", radius = cornerRadius;
        switch (boxName) {
          case "RoundedRectangle":
            path = "M " + (x1 = location.x) + " " + (radius + (y1 = location.y)) + " Q " + x1 + " " + y1 + " " + (x1 + radius) + " " + y1 + " ", 
            path += "L " + (x1 + (rectWidth = location.width) - radius) + " " + y1 + " Q " + (x1 + rectWidth) + " " + y1 + " " + (x1 + rectWidth) + " " + (y1 + radius) + " ", 
            path += "L " + (x1 + rectWidth) + " " + (y1 + (rectHeight = location.height) - radius) + " Q " + (x1 + rectWidth) + " " + (y1 + rectHeight) + " " + (x1 + rectWidth - radius) + " " + (y1 + rectHeight) + " ", 
            path += " L " + (x1 + radius) + " " + (y1 + rectHeight) + " Q " + x1 + " " + (y1 + rectHeight) + " " + x1 + " " + (y1 + rectHeight - radius) + " ", 
            path += "L " + x1 + " " + (radius + y1) + " z";
            break;

          case "Thermometer":
            var width = "Vertical" === orientation ? location.width : location.height;
            if (bottomRadius = width + width / 2 / Math.PI, topRadius = width / 2, "Vertical" === orientation) {
                var addValue = containerWidth + containerWidth / 2 / Math.PI - bottomRadius, y1_1 = "bar" === type ? location.y + addValue : location.y, locY = "bar" === type ? location.y + (topRadius - topRadius / Math.PI) : location.y, locHeight = location.height;
                path = "M" + location.x + " " + (y1_1 + locHeight) + " A " + bottomRadius + " " + bottomRadius + ", 0, 1, 0, " + (location.x + location.width) + " " + (y1_1 + locHeight) + " L " + (location.x + location.width) + " " + locY + " A " + topRadius + " " + topRadius + ", 0, 1, 0, " + location.x + " " + locY + " z ";
            } else {
                var x1_1 = "bar" !== type || axis.isInversed ? location.x : location.x - (containerWidth + containerWidth / 2 / Math.PI - bottomRadius), locWidth = "bar" === type ? location.width - (topRadius - topRadius / Math.PI) : location.width;
                path = "M" + x1_1 + " " + location.y + " A " + bottomRadius + " " + bottomRadius + ", 0, 1, 0, " + x1_1 + " " + (location.y + location.height) + " L " + (("bar" === type ? location.x : x1_1) + locWidth) + " " + (location.y + location.height) + " A " + topRadius + " " + topRadius + ", 0, 1, 0, " + (("bar" === type ? location.x : x1_1) + locWidth) + " " + location.y + " z ";
            }
        }
        return path;
    }
    function stringToNumber$3(value, containerSize) {
        return null !== value && void 0 !== value ? -1 !== value.indexOf("%") ? containerSize / 100 * parseInt(value, 10) : parseInt(value, 10) : null;
    }
    function createSvg$1(maps) {
        maps.renderer = new SvgRenderer(maps.element.id), function(maps) {
            var containerWidth = maps.element.clientWidth, containerHeight = maps.element.clientHeight;
            maps.availableSize = new Size$3(stringToNumber$3(maps.width, containerWidth) || containerWidth || 600, stringToNumber$3(maps.height, containerHeight) || containerHeight || (maps.isDevice ? Math.min(window.innerWidth, window.innerHeight) : 450));
        }(maps), maps.svgObject = maps.renderer.createSvg({
            id: maps.element.id + "_svg",
            width: maps.availableSize.width,
            height: maps.availableSize.height
        });
    }
    function degreesToRadians(deg) {
        return deg * (Math.PI / 180);
    }
    function radiansToDegrees(radian) {
        return radian * (180 / Math.PI);
    }
    function convertGeoToPoint(latitude, longitude, factor, layer, mapModel) {
        var x, y, value, lat, lng, temp, mapSize = new Size$3(mapModel.mapAreaRect.width, mapModel.mapAreaRect.height), longitudeMinMax = mapModel.baseMapBounds.longitude, latitudeMinMax = mapModel.baseMapBounds.latitude, latRadian = degreesToRadians(latitude), lngRadian = degreesToRadians(longitude), type = mapModel.projectionType, size = mapModel.isTileMap ? 256 * Math.pow(2, 1) : isNullOrUndefined(factor) ? Math.min(mapSize.width, mapSize.height) : Math.min(mapSize.width, mapSize.height) * factor;
        if ("Normal" === layer.geometryType) x = isNullOrUndefined(factor) ? longitude : Math.abs((longitude - longitudeMinMax.min) * factor), 
        y = isNullOrUndefined(factor) ? latitude : Math.abs((latitudeMinMax.max - latitude) * factor); else if ("Geographic" === layer.geometryType) {
            switch (type) {
              case "Mercator":
                var pixelOrigin = new Point(size / 2, size / 2);
                x = pixelOrigin.x + longitude * (size / 360);
                var sinY = function(value, min, max) {
                    isNullOrUndefined(min) || (value = Math.max(value, min));
                    isNullOrUndefined(max) || (value = Math.min(value, max));
                    return value;
                }(Math.sin(degreesToRadians(latitude)), -.9999, .9999);
                y = pixelOrigin.y + .5 * Math.log((1 + sinY) / (1 - sinY)) * (-size / (2 * Math.PI));
                break;

              case "Winkel3":
                lng = ((value = aitoff(lngRadian, latRadian)).x + lngRadian / (Math.PI / 2)) / 2, 
                lat = (value.y + latRadian) / 2;
                break;

              case "Miller":
                lng = lngRadian, lat = 1.25 * Math.log(Math.tan(Math.PI / 4 + .4 * latRadian));
                break;

              case "Eckert3":
                lng = 2 / (temp = Math.sqrt(Math.PI * (4 + Math.PI))) * lngRadian * (1 + Math.sqrt(1 - 4 * latRadian * latRadian / (Math.PI * Math.PI))), 
                lat = 4 / temp * latRadian;
                break;

              case "AitOff":
                lng = (value = aitoff(lngRadian, latRadian)).x, lat = value.y;
                break;

              case "Eckert5":
                lng = lngRadian * (1 + Math.cos(latRadian)) / Math.sqrt(2 + Math.PI), lat = 2 * latRadian / Math.sqrt(2 + Math.PI);
                break;

              case "Equirectangular":
                lng = lngRadian, lat = latRadian;
                break;

              case "Eckert6":
                temp = (1 + Math.PI / 2) * Math.sin(latRadian);
                for (var delta = 1 / 0, i = 0; i < 10 && Math.abs(delta) > 1e-6; i++) latRadian -= delta = (latRadian + Math.sin(latRadian) - temp) / (1 + Math.cos(latRadian));
                temp = Math.sqrt(2 + Math.PI), lng = lngRadian * (1 + Math.cos(latRadian)) / temp, 
                lat = 2 * latRadian / temp;
            }
            x = "Mercator" === type ? x : roundTo(function(mapObject, val) {
                var longitudeMinMax = mapObject.baseMapBounds.longitude, totalSize = isNullOrUndefined(mapObject.baseSize) ? mapObject.mapAreaRect.width : mapObject.mapAreaRect.width + Math.abs(mapObject.baseSize.width - mapObject.mapAreaRect.width) / 2;
                return Math.round(totalSize * (val - longitudeMinMax.min) / (longitudeMinMax.max - longitudeMinMax.min) * 100) / 100;
            }(mapModel, radiansToDegrees(lng)), 3), y = "Mercator" === type ? y : -roundTo(function(mapObject, val) {
                var latitudeMinMax = mapObject.baseMapBounds.latitude;
                return Math.round(mapObject.mapAreaRect.height * (val - latitudeMinMax.min) / (latitudeMinMax.max - latitudeMinMax.min) * 100) / 100;
            }(mapModel, radiansToDegrees(lat)), 3);
        }
        return new Point(x, y);
    }
    function convertTileLatLongToPoint(center, zoomLevel, tileTranslatePoint, isMapCoordinates) {
        var size = 256 * Math.pow(2, zoomLevel), x = (center.x + 180) / 360, sinLatitude = Math.sin(center.y * Math.PI / 180), y = .5 - Math.log((1 + sinLatitude) / (1 - sinLatitude)) / (4 * Math.PI), pixelX = center.x, pixelY = center.y;
        return isMapCoordinates && (pixelX = x * size + .5 + tileTranslatePoint.x, pixelY = y * size + .5 + tileTranslatePoint.y), 
        {
            x: pixelX,
            y: pixelY
        };
    }
    function aitoff(x, y) {
        var cosy = Math.cos(y), sincia = function(x) {
            return x / Math.sin(x);
        }(function(a) {
            return Math.acos(a);
        }(cosy * Math.cos(x /= 2)));
        return new Point(2 * cosy * Math.sin(x) * sincia, Math.sin(y) * sincia);
    }
    function roundTo(a, b) {
        var c = Math.pow(10, b);
        return Math.round(a * c) / c;
    }
    function measureText$3(text, font) {
        var htmlObject = document.getElementById("mapsmeasuretext");
        return null === htmlObject && (htmlObject = createElement("text", {
            id: "mapsmeasuretext"
        }), document.body.appendChild(htmlObject)), htmlObject.innerHTML = text, htmlObject.style.position = "absolute", 
        htmlObject.style.fontSize = font.size, htmlObject.style.fontWeight = font.fontWeight, 
        htmlObject.style.fontStyle = font.fontStyle, htmlObject.style.fontFamily = font.fontFamily, 
        htmlObject.style.visibility = "hidden", htmlObject.style.top = "-100", htmlObject.style.left = "0", 
        htmlObject.style.whiteSpace = "nowrap", htmlObject.style.lineHeight = "normal", 
        new Size$3(htmlObject.clientWidth, htmlObject.clientHeight);
    }
    function renderTextElement(options, font, color, parent, isMinus) {
        void 0 === isMinus && (isMinus = !1);
        var tspanElement, height, renderOptions = {
            id: options.id,
            x: options.x,
            y: options.y,
            fill: color,
            "font-size": font.size,
            "font-style": font.fontStyle,
            "font-family": font.fontFamily,
            "font-weight": font.fontWeight,
            "text-anchor": options.anchor,
            transform: options.transform,
            opacity: font.opacity,
            "dominant-baseline": options.baseLine
        }, text = "string" == typeof options.text ? options.text : isMinus ? options.text[options.text.length - 1] : options.text[0], renderer = new SvgRenderer(""), htmlObject = renderer.createText(renderOptions, text);
        if (htmlObject.style["user-select"] = "none", htmlObject.style["-moz-user-select"] = "none", 
        htmlObject.style["-webkit-touch-callout"] = "none", htmlObject.style["-webkit-user-select"] = "none", 
        htmlObject.style["-khtml-user-select"] = "none", htmlObject.style["-ms-user-select"] = "none", 
        htmlObject.style["-o-user-select"] = "none", "string" != typeof options.text && options.text.length > 1) for (var i = 1, len = options.text.length; i < len; i++) height = measureText$3(options.text[i], font).height, 
        tspanElement = renderer.createTSpan({
            x: options.x,
            id: options.id,
            y: options.y + (isMinus ? -i * height : i * height)
        }, isMinus ? options.text[options.text.length - (i + 1)] : options.text[i]), htmlObject.appendChild(tspanElement);
        return parent.appendChild(htmlObject), htmlObject;
    }
    function appendShape(shape, element) {
        return element && element.appendChild(shape), shape;
    }
    function calculateShapes$3(maps, shape, options, size, location, markerEle) {
        var tempGroup;
        switch (shape) {
          case "Balloon":
            tempGroup = function(maps, options, size, location, element) {
                var width = size.width, height = size.height;
                location.x -= width / 2, location.y -= height, options.d = "M15,0C8.8,0,3.8,5,3.8,11.2C3.8,17.5,9.4,24.4,15,30c5.6-5.6,11.2-12.5,11.2-18.8C26.2,5,21.2,0,15,0z M15,16c-2.8,0-5-2.2-5-5s2.2-5,5-5s5,2.2,5,5S17.8,16,15,16z";
                var balloon = maps.renderer.drawPath(options), x = size.width / 22.5, y = size.height / 30;
                balloon.setAttribute("transform", "translate(" + location.x + ", " + location.y + ") scale(" + x + ", " + y + ")");
                var g = maps.renderer.createGroup({
                    id: options.id
                });
                return appendShape(balloon, g), appendShape(g, element);
            }(maps, options, size, location, markerEle);
            break;

          case "Cross":
            options.d = "M " + location.x + " " + (location.y - size.height / 2) + " L " + location.x + " " + (location.y + size.height / 2) + " M " + (location.x - size.width / 2) + " " + location.y + " L " + (location.x + size.width / 2) + " " + location.y;
            break;

          case "Diamond":
            options.d = "M " + location.x + " " + (location.y - size.height / 2) + " L " + (location.x + size.width / 2) + " " + location.y + " L " + location.x + " " + (location.y + size.height / 2) + " L " + (location.x - size.width / 2) + " " + location.y + " Z";
            break;

          case "Star":
            options.d = "M " + (location.x + size.width / 3) + " " + (location.y - size.height / 2) + " L " + (location.x - size.width / 2) + " " + (location.y + size.height / 6) + " L " + (location.x + size.width / 2) + " " + (location.y + size.height / 6) + " L " + (location.x - size.width / 3) + " " + (location.y - size.height / 2) + " L " + location.x + " " + (location.y + size.height / 2) + " L " + (location.x + size.width / 3) + " " + (location.y - size.height / 2) + " Z";
            break;

          case "Triangle":
            options.d = "M " + location.x + " " + (location.y - size.height / 2) + " L " + (location.x + size.width / 2) + " " + (location.y + size.height / 2) + " L " + (location.x - size.width / 2) + " " + (location.y + size.height / 2) + " Z";
            break;

          case "HorizontalLine":
            options.d = " M " + (location.x - size.width / 2) + " " + location.y + " L " + (location.x + size.width / 2) + " " + location.y;
            break;

          case "VerticalLine":
            options.d = "M " + location.x + " " + (location.y - size.height / 2) + " L " + location.x + " " + (location.y + size.height / 2);
        }
        return "Balloon" === shape ? tempGroup : maps.renderer.drawPath(options);
    }
    function checkShapeDataFields(dataSource, properties, dataPath, propertyPath) {
        if (!isNullOrUndefined(properties)) for (var i = 0; i < dataSource.length; i++) if (dataSource[i][dataPath] === properties[propertyPath]) return i;
        return null;
    }
    function findMidPointOfPolygon(points) {
        if (!points.length) return null;
        for (var startX, startY, startX1, startY1, max = points.length, sum = 0, xSum = 0, ySum = 0, i = 0; i <= max - 1; i++) startX = points[i].x, 
        startY = points[i].y, i === max - 1 ? (startX1 = points[0].x, startY1 = points[0].y) : (startX1 = points[i + 1].x, 
        startY1 = points[i + 1].y), sum += Math.abs(startX * startY1 - startX1 * startY), 
        xSum += Math.abs((startX + startX1) * (startX * startY1 - startX1 * startY)), ySum += Math.abs((startY + startY1) * (startX * startY1 - startX1 * startY));
        xSum *= 1 / (4 * (sum *= .5)), ySum *= 1 / (4 * sum);
        var rightMinPoint = {
            x: 0,
            y: 0
        }, rightMaxPoint = {
            x: 0,
            y: 0
        }, leftMinPoint = {
            x: 0,
            y: 0
        }, leftMaxPoint = {
            x: 0,
            y: 0
        }, bottomMinPoint = {
            x: 0,
            y: 0
        }, bottomMaxPoint = {
            x: 0,
            y: 0
        }, topMinPoint = {
            x: 0,
            y: 0
        }, topMaxPoint = {
            x: 0,
            y: 0
        }, height = 0;
        for (i = 0; i <= max - 1; i++) {
            var point = points[i];
            point.y > ySum ? point.x < xSum && xSum - point.x < xSum - bottomMinPoint.x ? bottomMinPoint = {
                x: point.x,
                y: point.y
            } : point.x > xSum && (0 === bottomMaxPoint.x || point.x - xSum < bottomMaxPoint.x - xSum) && (bottomMaxPoint = {
                x: point.x,
                y: point.y
            }) : point.x < xSum && xSum - point.x < xSum - topMinPoint.x ? topMinPoint = {
                x: point.x,
                y: point.y
            } : point.x > xSum && (0 === topMaxPoint.x || point.x - xSum < topMaxPoint.x - xSum) && (topMaxPoint = {
                x: point.x,
                y: point.y
            }), height = bottomMaxPoint.y - topMaxPoint.y + (bottomMaxPoint.y - topMaxPoint.y) / 4, 
            point.x > xSum ? point.y < ySum && ySum - point.y < ySum - rightMinPoint.y ? rightMinPoint = {
                x: point.x,
                y: point.y
            } : point.y > ySum && (0 === rightMaxPoint.y || point.y - ySum < rightMaxPoint.y - ySum) && (rightMaxPoint = {
                x: point.x,
                y: point.y
            }) : point.y < ySum && ySum - point.y < ySum - leftMinPoint.y ? leftMinPoint = {
                x: point.x,
                y: point.y
            } : point.y > ySum && (0 === leftMaxPoint.y || point.y - ySum < leftMaxPoint.y - ySum) && (leftMaxPoint = {
                x: point.x,
                y: point.y
            });
        }
        return {
            x: xSum,
            y: ySum,
            rightMin: rightMinPoint,
            rightMax: rightMaxPoint,
            leftMin: leftMinPoint,
            leftMax: leftMaxPoint,
            points: points,
            topMax: topMaxPoint,
            topMin: topMinPoint,
            bottomMax: bottomMaxPoint,
            bottomMin: bottomMinPoint,
            height: height
        };
    }
    function isCustomPath(layerData) {
        var customPath = !1;
        return "[object Array]" === Object.prototype.toString.call(layerData) && layerData.forEach(function(layer, index) {
            isNullOrUndefined(layer.geometry) || "Path" !== layer.geometry.type || (customPath = !0);
        }), customPath;
    }
    function textTrim$1(maxWidth, text, font) {
        var label = text, size = measureText$3(text, font).width;
        if (size > maxWidth) for (var i = text.length - 1; i >= 0; --i) if (label = text.substring(0, i) + "...", 
        (size = measureText$3(label, font).width) <= maxWidth || label.length < 4) return label.length < 4 && (label = " "), 
        label;
        return label;
    }
    function removeElement$4(id) {
        var element = document.getElementById(id);
        return element ? remove(element) : null;
    }
    function getTranslate(mapObject, layer, animate) {
        var x, y, scaleFactor, zoomFactor = animate ? 1 : mapObject.zoomSettings.zoomFactor, min = mapObject.baseMapRectBounds.min, max = mapObject.baseMapRectBounds.max, size = mapObject.mapAreaRect, mapWidth = (mapObject.availableSize, 
        Math.abs(max.x - min.x)), mapHeight = Math.abs(min.y - max.y), factor = animate ? 1 : mapObject.zoomSettings.zoomFactor, center = mapObject.centerPosition;
        if (isNullOrUndefined(center.longitude) || isNullOrUndefined(center.latitude)) mapWidth *= scaleFactor = parseFloat(Math.min(size.width / mapWidth, size.height / mapHeight).toFixed(2)), 
        mapHeight *= scaleFactor, x = size.x + (-min.x + (size.width / 2 - mapWidth / 2)), 
        y = size.y + (-min.y + (size.height / 2 - mapHeight / 2)); else {
            var leftPosition = (mapWidth + Math.abs(mapObject.mapAreaRect.width - mapWidth)) / 2 / factor, topPosition = (mapHeight + Math.abs(mapObject.mapAreaRect.height - mapHeight)) / 2 / factor, point = convertGeoToPoint(center.latitude, center.longitude, mapObject.mapLayerPanel.calculateFactor(layer), layer, mapObject);
            x = -point.x + leftPosition, y = -point.y + topPosition, scaleFactor = zoomFactor;
        }
        return {
            scale: scaleFactor,
            location: new Point(x, y)
        };
    }
    function getElementByID(id) {
        return document.getElementById(id);
    }
    function Internalize(maps, value) {
        return maps.formatFunction = maps.intl.getNumberFormat({
            format: maps.format,
            useGrouping: maps.useGroupingSeparator
        }), maps.formatFunction(value);
    }
    function getTemplateFunction$3(template) {
        var templateFn = null;
        try {
            document.querySelectorAll(template).length && (templateFn = compile$$1(document.querySelector(template).innerHTML.trim()));
        } catch (e) {
            templateFn = compile$$1(template);
        }
        return templateFn;
    }
    function getElement$3(id) {
        return document.getElementById(id);
    }
    function triggerShapeEvent(targetId, selection, maps, eventName) {
        var shape = function(targetId, map) {
            var data, layerIndex = parseInt(targetId.split("_LayerIndex_")[1].split("_")[0], 10), shapeIndex = parseInt(targetId.split("_ShapeIndex_")[1].split("_")[0], 10), layer = map.layers[layerIndex], shapeData = layer.layerData[shapeIndex].property;
            return layer.dataSource && (data = layer.dataSource[checkShapeDataFields(layer.dataSource, shapeData, layer.shapeDataPath, layer.shapePropertyPath)]), 
            {
                shapeData: shapeData,
                data: data
            };
        }(targetId, maps), eventArgs = {
            cancel: !1,
            name: eventName,
            fill: selection.fill,
            opacity: selection.opacity,
            border: selection.border,
            shapeData: shape.shapeData,
            data: shape.data,
            target: targetId
        };
        return maps.trigger(eventName, eventArgs), eventArgs;
    }
    function getElementsByClassName(className) {
        return document.getElementsByClassName(className);
    }
    function querySelector(args, elementSelector) {
        var targetEle = null;
        return document.getElementById(elementSelector) && (targetEle = document.getElementById(elementSelector).querySelector("#" + args)), 
        targetEle;
    }
    function getTargetElement(layerIndex, name, enable, map) {
        for (var targetId, shapeData = map.layers[layerIndex].shapeData.features, i = 0; i < shapeData.length; i++) if (shapeData[i].properties.name === name) {
            targetId = map.element.id + "_LayerIndex_" + layerIndex + "_ShapeIndex_" + i + "_dataIndex_undefined";
            break;
        }
        return getElement$3(targetId);
    }
    function createStyle(id, className, eventArgs) {
        return createElement("style", {
            id: id,
            innerHTML: "." + className + "{fill:" + eventArgs.fill + ";opacity:" + eventArgs.opacity.toString() + ";}"
        });
    }
    function customizeStyle(id, className, eventArgs) {
        getElement$3(id).innerHTML = "." + className + "{fill:" + eventArgs.fill + ";opacity:" + eventArgs.opacity.toString() + ";stroke-width:" + eventArgs.border.width.toString() + "stroke-color:" + eventArgs.border.color + "}";
    }
    function removeClass$1(element) {
        element.removeAttribute("class");
    }
    function elementAnimate(element, delay, duration, point, maps, ele, radius) {
        void 0 === radius && (radius = 0);
        var centerX = point.x, centerY = point.y, height = 0, transform = element.getAttribute("transform") || "";
        new Animation({}).animate(element, {
            duration: duration,
            delay: delay,
            progress: function(args) {
                args.timeStamp > args.delay && (height = (args.timeStamp - args.delay) / args.duration, 
                element.setAttribute("transform", "translate( " + (centerX - radius * height) + " " + (centerY - radius * height) + " ) scale(" + height + ")"));
            },
            end: function(model) {
                if (element.setAttribute("transform", transform), ele) {
                    var event = {
                        cancel: !1,
                        name: animationComplete$3,
                        element: ele,
                        maps: maps
                    };
                    maps.trigger(animationComplete$3, event);
                }
            }
        });
    }
    function timeout(id) {
        removeElement$4(id);
    }
    function wordWrap(tooltip, text, x, y, size1, width, areaWidth, element) {
        tooltip.innerHTML = text, tooltip.style.top = (y + parseInt(size1[0], 10)).toString() + "px", 
        tooltip.style.left = x.toString() + "px", tooltip.style.width = width.toString() + "px", 
        tooltip.style.maxWidth = areaWidth.toString() + "px", tooltip.style.wordWrap = "break-word", 
        element.appendChild(tooltip);
    }
    function drawSymbol$1(location, shape, size, url, options) {
        var renderer = new SvgRenderer(""), temp = function(location, size, shape, options, url) {
            var path, functionName = "Path", width = size.width, height = size.height, locX = location.x, locY = location.y, x = location.x + -width / 2, y = location.y + -height / 2;
            switch (shape) {
              case "Circle":
              case "Bubble":
                functionName = "Ellipse", merge(options, {
                    rx: width / 2,
                    ry: height / 2,
                    cx: locX,
                    cy: locY
                });
                break;

              case "Star":
                path = "M " + (location.x + size.width / 3) + " " + (location.y - size.height / 2) + " L " + (location.x - size.width / 2) + " " + (location.y + size.height / 6) + " L " + (location.x + size.width / 2) + " " + (location.y + size.height / 6) + " L " + (location.x - size.width / 3) + " " + (location.y - size.height / 2) + " L " + location.x + " " + (location.y + size.height / 2) + " L " + (location.x + size.width / 3) + " " + (location.y - size.height / 2) + " Z", 
                merge(options, {
                    d: path
                });
                break;

              case "Cross":
                merge(options, {
                    d: path = "M " + x + " " + locY + " L " + (locX + width / 2) + " " + locY + " M " + locX + " " + (locY + height / 2) + " L " + locX + " " + (locY + -height / 2)
                });
                break;

              case "HorizontalLine":
                merge(options, {
                    d: path = "M " + x + " " + locY + " L " + (locX + width / 2) + " " + locY
                });
                break;

              case "VerticalLine":
                merge(options, {
                    d: path = "M " + locX + " " + (locY + height / 2) + " L " + locX + " " + (locY + -height / 2)
                });
                break;

              case "Diamond":
                merge(options, {
                    d: path = "M " + x + " " + locY + " L " + locX + " " + (locY + -height / 2) + " L " + (locX + width / 2) + " " + locY + " L " + locX + " " + (locY + height / 2) + " L " + x + " " + locY + " z"
                });
                break;

              case "Rectangle":
                merge(options, {
                    d: path = "M " + x + " " + (locY + -height / 2) + " L " + (locX + width / 2) + " " + (locY + -height / 2) + " L " + (locX + width / 2) + " " + (locY + height / 2) + " L " + x + " " + (locY + height / 2) + " L " + x + " " + (locY + -height / 2) + " z"
                });
                break;

              case "Triangle":
                merge(options, {
                    d: path = "M " + x + " " + (locY + height / 2) + " L " + locX + " " + (locY + -height / 2) + " L " + (locX + width / 2) + " " + (locY + height / 2) + " L " + x + " " + (locY + height / 2) + " z"
                });
                break;

              case "InvertedTriangle":
                merge(options, {
                    d: path = "M " + (locX + width / 2) + " " + (locY - height / 2) + " L " + locX + " " + (locY + height / 2) + " L " + (locX - width / 2) + " " + (locY - height / 2) + " L " + (locX + width / 2) + " " + (locY - height / 2) + " z"
                });
                break;

              case "Pentagon":
                for (var xValue = void 0, yValue = void 0, i = 0; i <= 5; i++) xValue = width / 2 * Math.cos(Math.PI / 180 * (72 * i)), 
                yValue = height / 2 * Math.sin(Math.PI / 180 * (72 * i)), path = 0 === i ? "M " + (locX + xValue) + " " + (locY + yValue) + " " : path.concat("L " + (locX + xValue) + " " + (locY + yValue) + " ");
                path = path.concat("Z"), merge(options, {
                    d: path
                });
                break;

              case "Image":
                functionName = "Image", merge(options, {
                    href: url,
                    height: height,
                    width: width,
                    x: x,
                    y: y
                });
            }
            return {
                renderOption: options,
                functionName: functionName
            };
        }(location, size, shape, options, url);
        return renderer["draw" + temp.functionName](temp.renderOption);
    }
    function changeBorderWidth(element, index, scale, maps) {
        for (var childNode, l = 0; l < element.childElementCount; l++) if ((childNode = element.childNodes[l]).id.indexOf("_NavigationGroup") > -1) !function(element, index, scale, maps) {
            for (var node, m = 0; m < element.childElementCount; m++) if ("path" === (node = element.childNodes[m]).tagName) {
                var currentStroke = maps.layersCollection[index].navigationLineSettings[parseFloat(node.id.split("_")[2])].width;
                node.setAttribute("stroke-width", (currentStroke / scale).toString());
            }
        }(childNode, index, scale, maps); else {
            var currentStroke = maps.layersCollection[index].shapeSettings.border.width;
            childNode.setAttribute("stroke-width", (currentStroke / scale).toString());
        }
    }
    function targetTouches(event) {
        for (var targetTouches = [], touches = event.touches, i = 0; i < touches.length; i++) targetTouches.push({
            pageX: touches[i].pageX,
            pageY: touches[i].pageY
        });
        return targetTouches;
    }
    function getDistance(a, b) {
        var x = a.pageX - b.pageX, y = a.pageY - b.pageY;
        return Math.sqrt(x * x + y * y);
    }
    function sum$1(a, b) {
        return a + b;
    }
    function animate(element, delay, duration, process, end) {
        var clearAnimation, _this = this, start = null, startAnimation = function(timestamp) {
            start || (start = timestamp);
            var progress = timestamp - start;
            progress < duration ? (process.call(_this, {
                element: element,
                delay: 0,
                timeStamp: progress,
                duration: duration
            }), window.requestAnimationFrame(startAnimation)) : (window.cancelAnimationFrame(clearAnimation), 
            end.call(_this, {
                element: element
            }));
        };
        clearAnimation = window.requestAnimationFrame(startAnimation);
    }
    function smoothTranslate(element, delay, duration, point) {
        var delta = 0, transform = element.getAttribute("transform").split(" ");
        2 === transform.length && (transform[2] = transform[1].split(")")[0], transform[1] = transform[0].split("(")[1]);
        var previousLocation = new MapLocation(parseInt(transform[1], 10), parseInt(transform[2], 10)), diffx = point.x - previousLocation.x, diffy = point.y - previousLocation.y, currentLocation = new MapLocation(0, 0);
        animate(element, 0, duration, function(args) {
            args.timeStamp > args.delay && (delta = (args.timeStamp - args.delay) / args.duration, 
            currentLocation.x = previousLocation.x + delta * diffx, currentLocation.y = previousLocation.y + delta * diffy, 
            args.element.setAttribute("transform", "translate( " + currentLocation.x + " " + currentLocation.y + " )"));
        }, function() {
            element.setAttribute("transform", "translate( " + point.x + " " + point.y + " )");
        });
    }
    var instances = "ej2_instances", uid = 0, headerRegex = /^(.*?):[ \t]*([^\r\n]*)$/gm, defaultType = "GET", Ajax = function() {
        function Ajax(options, type, async) {
            this.mode = !0, this.options = {}, "string" == typeof options ? (this.url = options, 
            this.type = type ? type.toUpperCase() : defaultType, this.mode = !!isNullOrUndefined(async) || async) : "object" == typeof options && (this.options = options, 
            merge(this, this.options)), this.type = this.type ? this.type.toUpperCase() : defaultType;
        }
        return Ajax.prototype.send = function(data) {
            var _this = this;
            this.data = isNullOrUndefined(data) ? this.data : data;
            return new Promise(function(resolve, reject) {
                _this.httpRequest = new XMLHttpRequest(), _this.httpRequest.onreadystatechange = function() {
                    _this.stateChange(resolve, reject);
                }, _this.httpRequest.open(_this.type, _this.url, _this.mode), isNullOrUndefined(_this.data) || _this.httpRequest.setRequestHeader("Content-Type", _this.contentType || "application/json; charset=utf-8"), 
                _this.beforeSend && _this.beforeSend(), _this.httpRequest.send(isNullOrUndefined(_this.data) ? null : _this.data);
            });
        }, Ajax.prototype.successHandler = function(data) {
            return this.onSuccess && this.onSuccess(data, this), data;
        }, Ajax.prototype.failureHandler = function(reason) {
            return this.onFailure && this.onFailure(this.httpRequest), reason;
        }, Ajax.prototype.stateChange = function(resolve, reject) {
            var data = this.httpRequest.responseText;
            if (this.dataType && "json" === this.dataType.toLowerCase()) if ("" === data) data = void 0; else try {
                data = JSON.parse(data);
            } catch (error) {}
            4 === this.httpRequest.readyState && (200 === this.httpRequest.status || 304 === this.httpRequest.status ? resolve(this.successHandler(data)) : reject(new Error(this.failureHandler(this.httpRequest.statusText))));
        }, Ajax.prototype.getResponseHeader = function(key) {
            var responseHeaders, header;
            responseHeaders = {};
            for (var headers = headerRegex.exec(this.httpRequest.getAllResponseHeaders()); headers; ) responseHeaders[headers[1].toLowerCase()] = headers[2], 
            headers = headerRegex.exec(this.httpRequest.getAllResponseHeaders());
            return header = responseHeaders[key.toLowerCase()], isNullOrUndefined(header) ? null : header;
        }, Ajax;
    }(), EventHandler = function() {
        function EventHandler() {}
        return EventHandler.addOrGetEventData = function(element) {
            return "__eventList" in element ? element.__eventList.events : (element.__eventList = {}, 
            element.__eventList.events = []);
        }, EventHandler.add = function(element, eventName, listener, bindTo, intDebounce) {
            var debounceListener, eventData = EventHandler.addOrGetEventData(element);
            debounceListener = intDebounce ? debounce(listener, intDebounce) : listener, bindTo && (debounceListener = debounceListener.bind(bindTo));
            for (var event = eventName.split(" "), i = 0; i < event.length; i++) eventData.push({
                name: event[i],
                listener: listener,
                debounce: debounceListener
            }), element.addEventListener(event[i], debounceListener);
            return debounceListener;
        }, EventHandler.remove = function(element, eventName, listener) {
            for (var eventData = EventHandler.addOrGetEventData(element), event = eventName.split(" "), _loop_1 = function(j) {
                var debounceListener, index = -1;
                eventData && 0 !== eventData.length && eventData.some(function(x, i) {
                    return x.name === event[j] && x.listener === listener && (index = i, debounceListener = x.debounce, 
                    !0);
                }), -1 !== index && eventData.splice(index, 1), debounceListener && element.removeEventListener(event[j], debounceListener);
            }, j = 0; j < event.length; j++) _loop_1(j);
        }, EventHandler.clearEvents = function(element) {
            var eventData, copyData;
            copyData = extend([], copyData, eventData = EventHandler.addOrGetEventData(element));
            for (var i = 0; i < copyData.length; i++) element.removeEventListener(copyData[i].name, copyData[i].debounce), 
            eventData.shift();
        }, EventHandler.trigger = function(element, eventName, eventProp) {
            for (var _i = 0, eventData_1 = EventHandler.addOrGetEventData(element); _i < eventData_1.length; _i++) {
                var event_1 = eventData_1[_i];
                event_1.name === eventName && event_1.debounce.call(this, eventProp);
            }
        }, EventHandler;
    }(), Observer = function() {
        function Observer(context) {
            this.ranArray = [], this.boundedEvents = {}, isNullOrUndefined(context) || (this.context = context);
        }
        return Observer.prototype.on = function(property, handler, context, id) {
            if (!isNullOrUndefined(handler)) {
                var cntxt = context || this.context;
                this.notExist(property) ? this.boundedEvents[property] = [ {
                    handler: handler,
                    context: cntxt
                } ] : isNullOrUndefined(id) ? this.isHandlerPresent(this.boundedEvents[property], handler) || this.boundedEvents[property].push({
                    handler: handler,
                    context: cntxt
                }) : -1 === this.ranArray.indexOf(id) && (this.ranArray.push(id), this.boundedEvents[property].push({
                    handler: handler,
                    context: cntxt,
                    id: id
                }));
            }
        }, Observer.prototype.off = function(property, handler, id) {
            if (!this.notExist(property)) {
                var curObject = getValue(property, this.boundedEvents);
                if (handler) for (var i = 0; i < curObject.length; i++) {
                    if (id) {
                        curObject.splice(i, 1);
                        var indexLocation = this.ranArray.indexOf(id);
                        -1 !== indexLocation && this.ranArray.splice(indexLocation, 1);
                        break;
                    }
                    if (handler === curObject[i].handler) {
                        curObject.splice(i, 1);
                        break;
                    }
                } else delete this.boundedEvents[property];
            }
        }, Observer.prototype.notify = function(property, argument) {
            if (!this.notExist(property)) {
                argument && (argument.name = property);
                for (var _i = 0, curObject_1 = getValue(property, this.boundedEvents).slice(0); _i < curObject_1.length; _i++) {
                    var cur = curObject_1[_i];
                    cur.handler.call(cur.context, argument);
                }
            }
        }, Observer.prototype.destroy = function() {
            this.boundedEvents = this.context = void 0;
        }, Observer.prototype.notExist = function(prop) {
            return !1 === this.boundedEvents.hasOwnProperty(prop);
        }, Observer.prototype.isHandlerPresent = function(boundedEvents, handler) {
            for (var _i = 0, boundedEvents_1 = boundedEvents; _i < boundedEvents_1.length; _i++) {
                if (boundedEvents_1[_i].handler === handler) return !0;
            }
            return !1;
        }, Observer;
    }(), Base = function() {
        function Base(options, element) {
            this.isProtectedOnChange = !0, this.properties = {}, this.changedProperties = {}, 
            this.oldProperties = {}, this.refreshing = !1, this.finalUpdate = function() {}, 
            this.childChangedProperties = {}, this.modelObserver = new Observer(this), isUndefined(element) || (this.element = "string" == typeof element ? document.querySelector(element) : element, 
            isNullOrUndefined(this.element) || (this.isProtectedOnChange = !1, this.addInstance())), 
            isUndefined(options) || this.setProperties(options, !0), this.isDestroyed = !1;
        }
        return Base.prototype.setProperties = function(prop, muteOnChange) {
            var prevDetection = this.isProtectedOnChange;
            this.isProtectedOnChange = !!muteOnChange, merge(this, prop), !0 !== muteOnChange && (merge(this.changedProperties, prop), 
            this.dataBind()), this.finalUpdate(), this.changedProperties = {}, this.oldProperties = {}, 
            this.isProtectedOnChange = prevDetection;
        }, Base.callChildDataBind = function(obj, parent) {
            for (var _i = 0, keys_1 = Object.keys(obj); _i < keys_1.length; _i++) {
                var key = keys_1[_i];
                if (parent[key] instanceof Array) for (var _a = 0, _b = parent[key]; _a < _b.length; _a++) {
                    var obj_1 = _b[_a];
                    void 0 !== obj_1.dataBind && obj_1.dataBind();
                } else parent[key].dataBind();
            }
        }, Base.prototype.clearChanges = function() {
            this.finalUpdate(), this.changedProperties = {}, this.oldProperties = {}, this.childChangedProperties = {};
        }, Base.prototype.dataBind = function() {
            if (Base.callChildDataBind(this.childChangedProperties, this), Object.getOwnPropertyNames(this.changedProperties).length) {
                var prevDetection = this.isProtectedOnChange, newChanges = this.changedProperties, oldChanges = this.oldProperties;
                this.clearChanges(), this.isProtectedOnChange = !0, this.onPropertyChanged(newChanges, oldChanges), 
                this.isProtectedOnChange = prevDetection;
            }
        }, Base.prototype.saveChanges = function(key, newValue, oldValue) {
            this.isProtectedOnChange || (this.oldProperties[key] = oldValue, this.changedProperties[key] = newValue, 
            this.finalUpdate(), this.finalUpdate = setImmediate(this.dataBind.bind(this)));
        }, Base.prototype.addEventListener = function(eventName, handler) {
            this.modelObserver.on(eventName, handler);
        }, Base.prototype.removeEventListener = function(eventName, handler) {
            this.modelObserver.off(eventName, handler);
        }, Base.prototype.trigger = function(eventName, eventProp) {
            if (!0 !== this.isDestroyed) {
                var prevDetection = this.isProtectedOnChange;
                this.isProtectedOnChange = !1, this.modelObserver.notify(eventName, eventProp), 
                this.isProtectedOnChange = prevDetection;
            }
        }, Base.prototype.addInstance = function() {
            var moduleClass = "e-" + this.getModuleName().toLowerCase();
            addClass([ this.element ], [ "e-control", moduleClass ]), isNullOrUndefined(this.element.ej2_instances) ? setValue("ej2_instances", [ this ], this.element) : this.element.ej2_instances.push(this);
        }, Base.prototype.destroy = function() {
            var _this = this;
            this.element.ej2_instances = this.element.ej2_instances.filter(function(i) {
                return i !== _this;
            }), removeClass([ this.element ], [ "e-" + this.getModuleName() ]), 0 === this.element.ej2_instances.length && removeClass([ this.element ], [ "e-control" ]), 
            this.clearChanges(), this.modelObserver.destroy(), this.isDestroyed = !0;
        }, Base;
    }(), REGX_MOBILE = /android|webos|iphone|ipad|ipod|blackberry|iemobile|opera mini|mobile/i, REGX_IE = /msie|trident/i, REGX_IE11 = /Trident\/7\./, REGX_IOS = /(ipad|iphone|ipod touch)/i, REGX_IOS7 = /(ipad|iphone|ipod touch);.*os 7_\d|(ipad|iphone|ipod touch);.*os 8_\d/i, REGX_ANDROID = /android/i, REGX_WINDOWS = /trident|windows phone|edge/i, REGX_VERSION = /(version)[ \/]([\w.]+)/i, REGX_BROWSER = {
        OPERA: /(opera|opr)(?:.*version|)[ \/]([\w.]+)/i,
        EDGE: /(edge)(?:.*version|)[ \/]([\w.]+)/i,
        CHROME: /(chrome|crios)[ \/]([\w.]+)/i,
        PANTHOMEJS: /(phantomjs)[ \/]([\w.]+)/i,
        SAFARI: /(safari)[ \/]([\w.]+)/i,
        WEBKIT: /(webkit)[ \/]([\w.]+)/i,
        MSIE: /(msie|trident) ([\w.]+)/i,
        MOZILLA: /(mozilla)(?:.*? rv:([\w.]+)|)/i
    };
    "undefined" != typeof window && (window.browserDetails = window.browserDetails || {});
    var IntlBase, Browser = function() {
        function Browser() {}
        return Browser.extractBrowserDetail = function() {
            for (var browserInfo = {
                culture: {}
            }, clientInfo = [], _i = 0, keys_1 = Object.keys(REGX_BROWSER); _i < keys_1.length; _i++) {
                var key = keys_1[_i];
                if (clientInfo = Browser.userAgent.match(REGX_BROWSER[key])) {
                    if (browserInfo.name = "opr" === clientInfo[1].toLowerCase() ? "opera" : clientInfo[1].toLowerCase(), 
                    browserInfo.name = "crios" === clientInfo[1].toLowerCase() ? "chrome" : browserInfo.name, 
                    browserInfo.version = clientInfo[2], browserInfo.culture.name = browserInfo.culture.language = navigator.language, 
                    Browser.userAgent.match(REGX_IE11)) {
                        browserInfo.name = "msie";
                        break;
                    }
                    var version = Browser.userAgent.match(REGX_VERSION);
                    "safari" === browserInfo.name && version && (browserInfo.version = version[2]);
                    break;
                }
            }
            return browserInfo;
        }, Browser.getEvent = function(event) {
            var events = {
                start: {
                    isPointer: "pointerdown",
                    isTouch: "touchstart",
                    isDevice: "mousedown"
                },
                move: {
                    isPointer: "pointermove",
                    isTouch: "touchmove",
                    isDevice: "mousemove"
                },
                end: {
                    isPointer: "pointerup",
                    isTouch: "touchend",
                    isDevice: "mouseup"
                }
            };
            return Browser.isPointer ? events[event].isPointer : Browser.isTouch ? events[event].isTouch + (Browser.isDevice ? "" : " " + events[event].isDevice) : events[event].isDevice;
        }, Browser.getTouchStartEvent = function() {
            return Browser.getEvent("start");
        }, Browser.getTouchEndEvent = function() {
            return Browser.getEvent("end");
        }, Browser.getTouchMoveEvent = function() {
            return Browser.getEvent("move");
        }, Browser.getValue = function(key, regX) {
            var browserDetails = window.browserDetails;
            return void 0 === browserDetails[key] ? browserDetails[key] = regX.test(Browser.userAgent) : browserDetails[key];
        }, Object.defineProperty(Browser, "userAgent", {
            get: function() {
                return Browser.uA;
            },
            set: function(uA) {
                Browser.uA = uA, window.browserDetails = {};
            },
            enumerable: !0,
            configurable: !0
        }), Object.defineProperty(Browser, "info", {
            get: function() {
                return isUndefined(window.browserDetails.info) ? window.browserDetails.info = Browser.extractBrowserDetail() : window.browserDetails.info;
            },
            enumerable: !0,
            configurable: !0
        }), Object.defineProperty(Browser, "isIE", {
            get: function() {
                return Browser.getValue("isIE", REGX_IE);
            },
            enumerable: !0,
            configurable: !0
        }), Object.defineProperty(Browser, "isTouch", {
            get: function() {
                return isUndefined(window.browserDetails.isTouch) ? window.browserDetails.isTouch = "ontouchstart" in window : window.browserDetails.isTouch;
            },
            enumerable: !0,
            configurable: !0
        }), Object.defineProperty(Browser, "isPointer", {
            get: function() {
                return isUndefined(window.browserDetails.isPointer) ? window.browserDetails.isPointer = "pointerEnabled" in window.navigator : window.browserDetails.isPointer;
            },
            enumerable: !0,
            configurable: !0
        }), Object.defineProperty(Browser, "isMSPointer", {
            get: function() {
                return isUndefined(window.browserDetails.isMSPointer) ? window.browserDetails.isMSPointer = "msPointerEnabled" in window.navigator : window.browserDetails.isMSPointer;
            },
            enumerable: !0,
            configurable: !0
        }), Object.defineProperty(Browser, "isDevice", {
            get: function() {
                return Browser.getValue("isDevice", REGX_MOBILE);
            },
            enumerable: !0,
            configurable: !0
        }), Object.defineProperty(Browser, "isIos", {
            get: function() {
                return Browser.getValue("isIos", REGX_IOS);
            },
            enumerable: !0,
            configurable: !0
        }), Object.defineProperty(Browser, "isIos7", {
            get: function() {
                return Browser.getValue("isIos7", REGX_IOS7);
            },
            enumerable: !0,
            configurable: !0
        }), Object.defineProperty(Browser, "isAndroid", {
            get: function() {
                return Browser.getValue("isAndroid", REGX_ANDROID);
            },
            enumerable: !0,
            configurable: !0
        }), Object.defineProperty(Browser, "isWebView", {
            get: function() {
                return isUndefined(window.browserDetails.isWebView) ? (window.browserDetails.isWebView = !(isUndefined(window.cordova) && isUndefined(window.PhoneGap) && isUndefined(window.phonegap) && "object" !== window.forge), 
                window.browserDetails.isWebView) : window.browserDetails.isWebView;
            },
            enumerable: !0,
            configurable: !0
        }), Object.defineProperty(Browser, "isWindows", {
            get: function() {
                return Browser.getValue("isWindows", REGX_WINDOWS);
            },
            enumerable: !0,
            configurable: !0
        }), Object.defineProperty(Browser, "touchStartEvent", {
            get: function() {
                return isUndefined(window.browserDetails.touchStartEvent) ? window.browserDetails.touchStartEvent = Browser.getTouchStartEvent() : window.browserDetails.touchStartEvent;
            },
            enumerable: !0,
            configurable: !0
        }), Object.defineProperty(Browser, "touchMoveEvent", {
            get: function() {
                return isUndefined(window.browserDetails.touchMoveEvent) ? window.browserDetails.touchMoveEvent = Browser.getTouchMoveEvent() : window.browserDetails.touchMoveEvent;
            },
            enumerable: !0,
            configurable: !0
        }), Object.defineProperty(Browser, "touchEndEvent", {
            get: function() {
                return isUndefined(window.browserDetails.touchEndEvent) ? window.browserDetails.touchEndEvent = Browser.getTouchEndEvent() : window.browserDetails.touchEndEvent;
            },
            enumerable: !0,
            configurable: !0
        }), Browser.uA = "undefined" != typeof navigator ? navigator.userAgent : "", Browser;
    }(), __extends$1 = function() {
        var extendStatics = Object.setPrototypeOf || {
            __proto__: []
        } instanceof Array && function(d, b) {
            d.__proto__ = b;
        } || function(d, b) {
            for (var p in b) b.hasOwnProperty(p) && (d[p] = b[p]);
        };
        return function(d, b) {
            function __() {
                this.constructor = d;
            }
            extendStatics(d, b), d.prototype = null === b ? Object.create(b) : (__.prototype = b.prototype, 
            new __());
        };
    }(), __decorate$1 = function(decorators, target, key, desc) {
        var d, c = arguments.length, r = c < 3 ? target : null === desc ? desc = Object.getOwnPropertyDescriptor(target, key) : desc;
        if ("object" == typeof Reflect && "function" == typeof Reflect.decorate) r = Reflect.decorate(decorators, target, key, desc); else for (var i = decorators.length - 1; i >= 0; i--) (d = decorators[i]) && (r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r);
        return c > 3 && r && Object.defineProperty(target, key, r), r;
    }, Animation = function(_super) {
        function Animation(options) {
            var _this = _super.call(this, options, void 0) || this;
            return _this.easing = {
                ease: "cubic-bezier(0.250, 0.100, 0.250, 1.000)",
                linear: "cubic-bezier(0.250, 0.250, 0.750, 0.750)",
                easeIn: "cubic-bezier(0.420, 0.000, 1.000, 1.000)",
                easeOut: "cubic-bezier(0.000, 0.000, 0.580, 1.000)",
                easeInOut: "cubic-bezier(0.420, 0.000, 0.580, 1.000)",
                elasticInOut: "cubic-bezier(0.5,-0.58,0.38,1.81)",
                elasticIn: "cubic-bezier(0.17,0.67,0.59,1.81)",
                elasticOut: "cubic-bezier(0.7,-0.75,0.99,1.01)"
            }, _this;
        }
        return __extends$1(Animation, _super), Animation_1 = Animation, Animation.prototype.animate = function(element, options) {
            options = options || {};
            var model = this.getModel(options);
            if ("string" == typeof element) for (var _i = 0, elements_1 = Array.prototype.slice.call(selectAll(element, document)); _i < elements_1.length; _i++) {
                var element_1 = elements_1[_i];
                model.element = element_1, Animation_1.delayAnimation(model);
            } else model.element = element, Animation_1.delayAnimation(model);
        }, Animation.stop = function(element, model) {
            element.style.animation = "", element.removeAttribute("e-animate");
            var animationId = element.getAttribute("e-animation-id");
            if (animationId) {
                var frameId = parseInt(animationId, 10);
                cancelAnimationFrame(frameId), element.removeAttribute("e-animation-id");
            }
            model && model.end && model.end.call(this, model);
        }, Animation.delayAnimation = function(model) {
            model.delay ? setTimeout(function() {
                Animation_1.applyAnimation(model);
            }, model.delay) : Animation_1.applyAnimation(model);
        }, Animation.applyAnimation = function(model) {
            var _this = this;
            model.timeStamp = 0;
            var step = 0, timerId = 0, prevTimeStamp = 0, duration = model.duration;
            model.element.setAttribute("e-animate", "true");
            var startAnimation = function(timeStamp) {
                try {
                    if (timeStamp) {
                        prevTimeStamp = 0 === prevTimeStamp ? timeStamp : prevTimeStamp, model.timeStamp = timeStamp + model.timeStamp - prevTimeStamp, 
                        prevTimeStamp = timeStamp, !step && model.begin && model.begin.call(_this, model), 
                        step += 1;
                        var avg = model.timeStamp / step;
                        model.timeStamp < duration && model.timeStamp + avg < duration && model.element.getAttribute("e-animate") ? (model.element.style.animation = model.name + " " + model.duration + "ms " + model.timingFunction, 
                        model.progress && model.progress.call(_this, model), requestAnimationFrame(startAnimation)) : (cancelAnimationFrame(timerId), 
                        model.element.removeAttribute("e-animation-id"), model.element.removeAttribute("e-animate"), 
                        model.element.style.animation = "", model.end && model.end.call(_this, model));
                    } else performance.now(), timerId = requestAnimationFrame(startAnimation), model.element.setAttribute("e-animation-id", timerId.toString());
                } catch (e) {
                    cancelAnimationFrame(timerId), model.element.removeAttribute("e-animation-id"), 
                    model.fail && model.fail.call(_this, e);
                }
            };
            startAnimation();
        }, Animation.prototype.getModel = function(options) {
            return {
                name: options.name || this.name,
                delay: options.delay || this.delay,
                duration: void 0 !== options.duration ? options.duration : this.duration,
                begin: options.begin || this.begin,
                end: options.end || this.end,
                fail: options.fail || this.fail,
                progress: options.progress || this.progress,
                timingFunction: this.easing[options.timingFunction] ? this.easing[options.timingFunction] : options.timingFunction || this.easing[this.timingFunction]
            };
        }, Animation.prototype.onPropertyChanged = function(newProp, oldProp) {}, Animation.prototype.getModuleName = function() {
            return "animation";
        }, Animation.prototype.destroy = function() {}, __decorate$1([ Property("FadeIn") ], Animation.prototype, "name", void 0), 
        __decorate$1([ Property(400) ], Animation.prototype, "duration", void 0), __decorate$1([ Property("ease") ], Animation.prototype, "timingFunction", void 0), 
        __decorate$1([ Property(0) ], Animation.prototype, "delay", void 0), __decorate$1([ Event() ], Animation.prototype, "progress", void 0), 
        __decorate$1([ Event() ], Animation.prototype, "begin", void 0), __decorate$1([ Event() ], Animation.prototype, "end", void 0), 
        __decorate$1([ Event() ], Animation.prototype, "fail", void 0), Animation = Animation_1 = __decorate$1([ NotifyPropertyChanges ], Animation);
        var Animation_1;
    }(Base), isRippleEnabled = !1, CanvasRenderer = function() {
        function CanvasRenderer(rootID) {
            this.rootId = rootID;
        }
        return CanvasRenderer.prototype.getOptionValue = function(options, key) {
            return options[key];
        }, CanvasRenderer.prototype.createCanvas = function(options) {
            var canvasObj = document.createElement("canvas");
            return canvasObj.setAttribute("id", this.rootId + "_canvas"), this.ctx = canvasObj.getContext("2d"), 
            this.canvasObj = canvasObj, this.setCanvasSize(options.width, options.height), this.canvasObj;
        }, CanvasRenderer.prototype.setCanvasSize = function(width, height) {
            var element = document.getElementById(this.rootId), size = isNullOrUndefined(element) ? null : element.getBoundingClientRect();
            isNullOrUndefined(this.width) ? this.canvasObj.setAttribute("width", width ? width.toString() : size.width.toString()) : this.canvasObj.setAttribute("width", this.width.toString()), 
            isNullOrUndefined(this.height) ? this.canvasObj.setAttribute("height", height ? height.toString() : "450") : this.canvasObj.setAttribute("height", this.height.toString());
        }, CanvasRenderer.prototype.setAttributes = function(options) {
            this.ctx.lineWidth = this.getOptionValue(options, "stroke-width");
            var dashArray = this.getOptionValue(options, "stroke-dasharray");
            if (!isNullOrUndefined(dashArray)) {
                var dashArrayString = dashArray.split(",");
                this.ctx.setLineDash([ parseInt(dashArrayString[0], 10), parseInt(dashArrayString[1], 10) ]);
            }
            this.ctx.strokeStyle = this.getOptionValue(options, "stroke");
        }, CanvasRenderer.prototype.drawLine = function(options) {
            this.ctx.save(), this.ctx.beginPath(), this.ctx.lineWidth = this.getOptionValue(options, "stroke-width"), 
            this.ctx.strokeStyle = options.stroke, this.ctx.moveTo(options.x1, options.y1), 
            this.ctx.lineTo(options.x2, options.y2), this.ctx.stroke(), this.ctx.restore(), 
            this.dataUrl = this.canvasObj.toDataURL();
        }, CanvasRenderer.prototype.drawRectangle = function(options) {
            var canvasCtx = this.ctx, cornerRadius = options.rx;
            this.ctx.save(), this.ctx.beginPath(), this.ctx.globalAlpha = this.getOptionValue(options, "opacity"), 
            this.setAttributes(options), this.ctx.rect(options.x, options.y, options.width, options.height), 
            null !== cornerRadius && cornerRadius >= 0 ? this.drawCornerRadius(options) : ("none" === options.fill && (options.fill = "transparent"), 
            this.ctx.fillStyle = options.fill, this.ctx.fillRect(options.x, options.y, options.width, options.height), 
            this.ctx.stroke()), this.ctx.restore(), this.ctx = canvasCtx, this.dataUrl = this.canvasObj.toDataURL();
        }, CanvasRenderer.prototype.drawCornerRadius = function(options) {
            var cornerRadius = options.rx, x = options.x, y = options.y, width = options.width, height = options.height;
            "none" === options.fill && (options.fill = "transparent"), this.ctx.fillStyle = options.fill, 
            width < 2 * cornerRadius && (cornerRadius = width / 2), height < 2 * cornerRadius && (cornerRadius = height / 2), 
            this.ctx.beginPath(), this.ctx.moveTo(x + width - cornerRadius, y), this.ctx.arcTo(x + width, y, x + width, y + height, cornerRadius), 
            this.ctx.arcTo(x + width, y + height, x, y + height, cornerRadius), this.ctx.arcTo(x, y + height, x, y, cornerRadius), 
            this.ctx.arcTo(x, y, x + width, y, cornerRadius), this.ctx.closePath(), this.ctx.fill(), 
            this.ctx.stroke(), this.dataUrl = this.canvasObj.toDataURL();
        }, CanvasRenderer.prototype.drawPath = function(options, canvasTranslate) {
            var dataSplit = options.d.split(" "), borderWidth = this.getOptionValue(options, "stroke-width"), canvasCtx = this.ctx, flag = !0;
            this.ctx.save(), this.ctx.beginPath(), canvasTranslate && this.ctx.translate(canvasTranslate[0], canvasTranslate[1]), 
            this.ctx.globalAlpha = options.opacity ? options.opacity : this.getOptionValue(options, "fill-opacity"), 
            this.setAttributes(options);
            for (var i = 0; i < dataSplit.length; i += 3) {
                var x1 = parseFloat(dataSplit[i + 1]), y1 = parseFloat(dataSplit[i + 2]);
                switch (dataSplit[i]) {
                  case "M":
                    options.innerR || options.cx || this.ctx.moveTo(x1, y1);
                    break;

                  case "L":
                    options.innerR || this.ctx.lineTo(x1, y1);
                    break;

                  case "C":
                    var c1 = parseFloat(dataSplit[i + 3]), c2 = parseFloat(dataSplit[i + 4]), c3 = parseFloat(dataSplit[i + 5]), c4 = parseFloat(dataSplit[i + 6]);
                    this.ctx.bezierCurveTo(x1, y1, c1, c2, c3, c4), i += 4;
                    break;

                  case "A":
                    options.innerR ? flag && (this.ctx.arc(options.x, options.y, options.radius, options.start, options.end, options.counterClockWise), 
                    this.ctx.arc(options.x, options.y, options.innerR, options.end, options.start, !options.counterClockWise), 
                    flag = !1) : options.cx ? this.ctx.arc(options.cx, options.cy, options.radius, 0, 2 * Math.PI, options.counterClockWise) : (this.ctx.moveTo(options.x, options.y), 
                    this.ctx.arc(options.x, options.y, options.radius, options.start, options.end, options.counterClockWise), 
                    this.ctx.lineTo(options.x, options.y)), i += 5;
                    break;

                  case "z":
                    this.ctx.closePath();
                }
            }
            "none" !== options.fill && void 0 !== options.fill && (this.ctx.fillStyle = options.fill, 
            this.ctx.fill()), borderWidth > 0 && this.ctx.stroke(), this.ctx.restore(), this.ctx = canvasCtx, 
            this.dataUrl = this.canvasObj.toDataURL();
        }, CanvasRenderer.prototype.drawText = function(options, label) {
            var fontWeight = this.getOptionValue(options, "font-weight");
            isNullOrUndefined(fontWeight) || "regular" !== fontWeight.toLowerCase() || (fontWeight = "normal");
            var fontSize = this.getOptionValue(options, "font-size"), fontFamily = this.getOptionValue(options, "font-family"), font = this.getOptionValue(options, "font-style").toLowerCase() + " " + fontWeight + " " + fontSize + " " + fontFamily, anchor = this.getOptionValue(options, "text-anchor"), opacity = void 0 !== options.opacity ? options.opacity : 1;
            "middle" === anchor && (anchor = "center"), this.ctx.save(), this.ctx.fillStyle = options.fill, 
            this.ctx.font = font, this.ctx.textAlign = anchor, this.ctx.globalAlpha = opacity, 
            options.baseline && (this.ctx.textBaseline = options.baseline);
            this.ctx.translate(options.x + 0, options.y), this.ctx.rotate(options.labelRotation * Math.PI / 180), 
            this.ctx.fillText(label, 0, 0), this.ctx.restore(), this.dataUrl = this.canvasObj.toDataURL();
        }, CanvasRenderer.prototype.drawCircle = function(options) {
            var canvasCtx = this.ctx;
            this.ctx.save(), this.ctx.beginPath(), this.ctx.arc(options.cx, options.cy, options.r, 0, 2 * Math.PI), 
            this.ctx.fillStyle = options.fill, this.ctx.globalAlpha = options.opacity, this.ctx.fill(), 
            this.setAttributes(options), this.ctx.stroke(), this.ctx.restore(), this.ctx = canvasCtx, 
            this.dataUrl = this.canvasObj.toDataURL();
        }, CanvasRenderer.prototype.drawPolyline = function(options) {
            this.ctx.save(), this.ctx.beginPath();
            for (var points = options.points.split(" "), i = 0; i < points.length - 1; i++) {
                var point = points[i].split(","), x = parseFloat(point[0]), y = parseFloat(point[1]);
                0 === i ? this.ctx.moveTo(x, y) : this.ctx.lineTo(x, y);
            }
            this.ctx.lineWidth = this.getOptionValue(options, "stroke-width"), this.ctx.strokeStyle = options.stroke, 
            this.ctx.stroke(), this.ctx.restore(), this.dataUrl = this.canvasObj.toDataURL();
        }, CanvasRenderer.prototype.drawEllipse = function(options) {
            var canvasCtx = this.ctx, circumference = Math.max(options.rx, options.ry), scaleX = options.rx / circumference, scaleY = options.ry / circumference;
            this.ctx.save(), this.ctx.beginPath(), this.ctx.translate(options.cx, options.cy), 
            this.ctx.save(), this.ctx.scale(scaleX, scaleY), this.ctx.arc(0, 0, circumference, 0, 2 * Math.PI, !1), 
            this.ctx.fillStyle = options.fill, this.ctx.fill(), this.ctx.restore(), this.ctx.lineWidth = this.getOptionValue(options, "stroke-width"), 
            this.ctx.strokeStyle = options.stroke, this.ctx.stroke(), this.ctx.restore(), this.ctx = canvasCtx, 
            this.dataUrl = this.canvasObj.toDataURL();
        }, CanvasRenderer.prototype.drawImage = function(options) {
            this.ctx.save();
            var imageObj = new Image();
            isNullOrUndefined(options.href) || (imageObj.src = options.href, this.ctx.drawImage(imageObj, options.x, options.y, options.width, options.height)), 
            this.ctx.restore(), this.dataUrl = this.canvasObj.toDataURL();
        }, CanvasRenderer.prototype.createLinearGradient = function(colors) {
            var myGradient;
            isNullOrUndefined(colors[0].colorStop) || (myGradient = this.ctx.createLinearGradient(0, 0, 0, this.canvasObj.height));
            return this.setGradientValues(colors, myGradient);
        }, CanvasRenderer.prototype.createRadialGradient = function(colors) {
            var myGradient;
            isNullOrUndefined(colors[0].colorStop) || (myGradient = this.ctx.createRadialGradient(0, 0, 0, 0, 0, this.canvasObj.height));
            return this.setGradientValues(colors, myGradient);
        }, CanvasRenderer.prototype.setGradientValues = function(colors, myGradient) {
            var colorName;
            if (isNullOrUndefined(colors[0].colorStop)) colorName = colors[0].color.toString(); else {
                for (var i = 0; i <= colors.length - 1; i++) {
                    var color = colors[i].color, newColorStop = colors[i].colorStop.slice(0, -1), stopColor = parseInt(newColorStop, 10) / 100;
                    myGradient.addColorStop(stopColor, color);
                }
                colorName = myGradient.toString();
            }
            return this.dataUrl = this.canvasObj.toDataURL(), colorName;
        }, CanvasRenderer.prototype.setElementAttributes = function(options, element) {
            for (var keys = Object.keys(options), values = Object.keys(options).map(function(key) {
                return options[key];
            }), i = 0; i < keys.length; i++) element.setAttribute(keys[i], values[i]);
            return element;
        }, CanvasRenderer.prototype.updateCanvasAttributes = function(options) {
            this.setElementAttributes(options, this.canvasObj);
            var ctx = this.ctx;
            if (!isNullOrUndefined(this.dataUrl)) {
                var img_1 = new Image();
                img_1.onload = function() {
                    ctx.drawImage(img_1, 0, 0);
                }, img_1.src = this.dataUrl;
            }
        }, CanvasRenderer;
    }(), ModuleLoader = function() {
        function ModuleLoader(parent) {
            this.loadedModules = [], this.parent = parent;
        }
        return ModuleLoader.prototype.inject = function(requiredModules, moduleList) {
            var reqLength = requiredModules.length;
            if (0 !== reqLength) {
                this.loadedModules.length && this.clearUnusedModule(requiredModules);
                for (var i = 0; i < reqLength; i++) for (var modl = requiredModules[i], _i = 0, moduleList_1 = moduleList; _i < moduleList_1.length; _i++) {
                    var module = moduleList_1[_i], modName = modl.member;
                    if (module.prototype.getModuleName() === modl.member && !this.isModuleLoaded(modName)) {
                        var moduleObject = createInstance(module, modl.args), memberName = this.getMemberName(modName);
                        modl.isProperty ? setValue(memberName, module, this.parent) : setValue(memberName, moduleObject, this.parent);
                        var loadedModule = modl;
                        loadedModule.member = memberName, this.loadedModules.push(loadedModule);
                    }
                }
            } else this.clean();
        }, ModuleLoader.prototype.clean = function() {
            for (var _i = 0, _a = this.loadedModules; _i < _a.length; _i++) {
                var modules = _a[_i];
                modules.isProperty || getValue(modules.member, this.parent).destroy();
            }
            this.loadedModules = [];
        }, ModuleLoader.prototype.clearUnusedModule = function(moduleList) {
            for (var _this = this, usedModules = moduleList.map(function(arg) {
                return _this.getMemberName(arg.member);
            }), _i = 0, removableModule_1 = this.loadedModules.filter(function(module) {
                return -1 === usedModules.indexOf(module.member);
            }); _i < removableModule_1.length; _i++) {
                var mod = removableModule_1[_i];
                mod.isProperty || getValue(mod.member, this.parent).destroy(), this.loadedModules.splice(this.loadedModules.indexOf(mod), 1), 
                deleteObject(this.parent, mod.member);
            }
        }, ModuleLoader.prototype.getMemberName = function(name) {
            return name[0].toLowerCase() + name.substring(1) + "Module";
        }, ModuleLoader.prototype.isModuleLoaded = function(modName) {
            for (var _i = 0, _a = this.loadedModules; _i < _a.length; _i++) {
                if (_a[_i].member === this.getMemberName(modName)) return !0;
            }
            return !1;
        }, ModuleLoader;
    }(), ChildProperty = function() {
        function ChildProperty(parent, propName, defaultValue, isArray) {
            this.properties = {}, this.changedProperties = {}, this.childChangedProperties = {}, 
            this.oldProperties = {}, this.finalUpdate = function() {}, this.callChildDataBind = getValue("callChildDataBind", Base), 
            this.parentObj = parent, this.controlParent = this.parentObj.controlParent || this.parentObj, 
            this.propName = propName, this.setProperties(defaultValue, !0), this.isParentArray = isArray;
        }
        return ChildProperty.prototype.updateChange = function(val, propName) {
            !0 === val ? this.parentObj.childChangedProperties[propName] = val : delete this.parentObj.childChangedProperties[propName], 
            this.parentObj.updateChange && this.parentObj.updateChange(val, this.parentObj.propName);
        }, ChildProperty.prototype.updateTimeOut = function() {
            this.parentObj.updateTimeOut ? (this.parentObj.finalUpdate(), this.parentObj.updateTimeOut()) : this.parentObj.finalUpdate = setImmediate(this.parentObj.dataBind.bind(this.parentObj));
        }, ChildProperty.prototype.clearChanges = function() {
            this.finalUpdate(), this.updateChange(!1, this.propName), this.oldProperties = {}, 
            this.changedProperties = {};
        }, ChildProperty.prototype.setProperties = function(prop, muteOnChange) {
            !0 === muteOnChange ? (merge(this, prop), this.updateChange(!1, this.propName), 
            this.clearChanges()) : merge(this, prop);
        }, ChildProperty.prototype.dataBind = function() {
            if (this.callChildDataBind(this.childChangedProperties, this), this.isParentArray) {
                var curIndex = this.parentObj[this.propName].indexOf(this);
                Object.keys(this.changedProperties).length && (setValue(this.propName + "." + curIndex, this.changedProperties, this.parentObj.changedProperties), 
                setValue(this.propName + "." + curIndex, this.oldProperties, this.parentObj.oldProperties));
            } else this.parentObj.changedProperties[this.propName] = this.changedProperties, 
            this.parentObj.oldProperties[this.propName] = this.oldProperties;
            this.clearChanges();
        }, ChildProperty.prototype.saveChanges = function(key, newValue, oldValue) {
            this.controlParent.isProtectedOnChange || (this.oldProperties[key] = oldValue, this.changedProperties[key] = newValue, 
            this.updateChange(!0, this.propName), this.finalUpdate(), this.updateTimeOut());
        }, ChildProperty;
    }(), defaultNumberingSystem = {
        latn: {
            _digits: "0123456789",
            _type: "numeric"
        }
    }, defaultNumberSymbols = {
        decimal: ".",
        group: ",",
        percentSign: "%",
        plusSign: "+",
        minusSign: "-",
        infinity: "∞",
        nan: "NaN",
        exponential: "E"
    }, latnNumberSystem = [ 0, 1, 2, 3, 4, 5, 6, 7, 8, 9 ], ParserBase = function() {
        function ParserBase() {}
        return ParserBase.getMainObject = function(obj, cName) {
            return getValue("main." + cName, obj);
        }, ParserBase.getNumberingSystem = function(obj) {
            return getValue("supplemental.numberingSystems", obj) || this.numberingSystems;
        }, ParserBase.reverseObject = function(prop, keys) {
            for (var res = {}, _i = 0, propKeys_1 = keys || Object.keys(prop); _i < propKeys_1.length; _i++) {
                var key = propKeys_1[_i];
                res.hasOwnProperty(prop[key]) || (res[prop[key]] = key);
            }
            return res;
        }, ParserBase.getSymbolRegex = function(props) {
            var regexStr = props.map(function(str) {
                return str.replace(/([.*+?^=!:${}()|\[\]\/\\])/g, "\\$1");
            }).join("|");
            return new RegExp(regexStr, "g");
        }, ParserBase.getSymbolMatch = function(prop) {
            for (var ret = {}, _i = 0, matchKeys_1 = Object.keys(defaultNumberSymbols); _i < matchKeys_1.length; _i++) {
                var key = matchKeys_1[_i];
                ret[prop[key]] = defaultNumberSymbols[key];
            }
            return ret;
        }, ParserBase.constructRegex = function(val) {
            for (var len = val.length, ret = "", i = 0; i < len; i++) ret += i !== len - 1 ? val[i] + "|" : val[i];
            return ret;
        }, ParserBase.convertValueParts = function(value, regex, obj) {
            return value.replace(regex, function(str) {
                return obj[str];
            });
        }, ParserBase.getDefaultNumberingSystem = function(obj) {
            var ret = {};
            return ret.obj = getValue("numbers", obj), ret.nSystem = getValue("defaultNumberingSystem", ret.obj), 
            ret;
        }, ParserBase.getCurrentNumericOptions = function(curObj, numberSystem, needSymbols) {
            var ret = {}, cur = this.getDefaultNumberingSystem(curObj);
            if (!isUndefined(cur.nSystem)) {
                var digits = getValue(cur.nSystem + "._digits", numberSystem);
                isUndefined(digits) || (ret.numericPair = this.reverseObject(digits, latnNumberSystem), 
                ret.numberParseRegex = new RegExp(this.constructRegex(digits), "g"), ret.numericRegex = "[" + digits[0] + "-" + digits[9] + "]", 
                needSymbols && (ret.numericRegex = digits[0] + "-" + digits[9], ret.symbolNumberSystem = getValue("symbols-numberSystem-" + cur.nSystem, cur.obj), 
                ret.symbolMatch = this.getSymbolMatch(ret.symbolNumberSystem), ret.numberSystem = cur.nSystem));
            }
            return ret;
        }, ParserBase.getNumberMapper = function(curObj, numberSystem, isNumber) {
            var ret = {
                mapper: {}
            }, cur = this.getDefaultNumberingSystem(curObj);
            if (!isUndefined(cur.nSystem)) {
                ret.numberSystem = cur.nSystem, ret.numberSymbols = getValue("symbols-numberSystem-" + cur.nSystem, cur.obj), 
                ret.timeSeparator = getValue("timeSeparator", ret.numberSymbols);
                var digits = getValue(cur.nSystem + "._digits", numberSystem);
                if (!isUndefined(digits)) for (var _i = 0, latnNumberSystem_1 = latnNumberSystem; _i < latnNumberSystem_1.length; _i++) {
                    var i = latnNumberSystem_1[_i];
                    ret.mapper[i] = digits[i];
                }
            }
            return ret;
        }, ParserBase.nPair = "numericPair", ParserBase.nRegex = "numericRegex", ParserBase.numberingSystems = defaultNumberingSystem, 
        ParserBase;
    }(), errorText = {
        ms: "minimumSignificantDigits",
        ls: "maximumSignificantDigits",
        mf: "minimumFractionDigits",
        lf: "maximumFractionDigits"
    }, mapper$1 = [ "infinity", "nan", "group", "decimal", "exponential" ], NumberFormat = function() {
        function NumberFormat() {}
        return NumberFormat.numberFormatter = function(culture, option, cldr) {
            var symbolPattern, _this = this, fOptions = extend({}, option), cOptions = {}, dOptions = {}, dependable = IntlBase.getDependables(cldr, culture, !0);
            dOptions.numberMapper = ParserBase.getNumberMapper(dependable.parserObject, ParserBase.getNumberingSystem(cldr), !0), 
            dOptions.currencySymbol = IntlBase.getCurrencySymbol(dependable.numericObject, fOptions.currency || defaultCurrencyCode), 
            dOptions.percentSymbol = dOptions.numberMapper.numberSymbols.percentSign, dOptions.minusSymbol = dOptions.numberMapper.numberSymbols.minusSign;
            var symbols = dOptions.numberMapper.numberSymbols;
            if (option.format && !IntlBase.formatRegex.test(option.format)) cOptions = IntlBase.customFormat(option.format, dOptions, dependable.numericObject); else {
                extend(fOptions, IntlBase.getProperNumericSkeleton(option.format || "N")), fOptions.isCurrency = "currency" === fOptions.type, 
                fOptions.isPercent = "percent" === fOptions.type, symbolPattern = IntlBase.getSymbolPattern(fOptions.type, dOptions.numberMapper.numberSystem, dependable.numericObject, fOptions.isAccount), 
                fOptions.groupOne = this.checkValueRange(fOptions.maximumSignificantDigits, fOptions.minimumSignificantDigits, !0), 
                this.checkValueRange(fOptions.maximumFractionDigits, fOptions.minimumFractionDigits, !1, !0), 
                isUndefined(fOptions.fractionDigits) || (fOptions.minimumFractionDigits = fOptions.maximumFractionDigits = fOptions.fractionDigits), 
                isUndefined(fOptions.useGrouping) && (fOptions.useGrouping = !0), fOptions.isCurrency && (symbolPattern = symbolPattern.replace(/\u00A4/g, IntlBase.defaultCurrency));
                var split = symbolPattern.split(";");
                cOptions.nData = IntlBase.getFormatData(split[1] || "-" + split[0], !0, dOptions.currencySymbol), 
                cOptions.pData = IntlBase.getFormatData(split[0], !1, dOptions.currencySymbol), 
                fOptions.useGrouping && (fOptions.groupSeparator = symbols[mapper$1[2]], fOptions.groupData = this.getGroupingDetails(split[0]));
                if (isUndefined(fOptions.minimumFractionDigits) && (fOptions.minimumFractionDigits = cOptions.nData.minimumFraction), 
                isUndefined(fOptions.maximumFractionDigits)) {
                    var mval = cOptions.nData.maximumFraction;
                    fOptions.maximumFractionDigits = isUndefined(mval) && fOptions.isPercent ? 0 : mval;
                }
                var mfrac = fOptions.minimumFractionDigits, lfrac = fOptions.maximumFractionDigits;
                isUndefined(mfrac) || isUndefined(lfrac) || mfrac > lfrac && (fOptions.maximumFractionDigits = mfrac);
            }
            return extend(cOptions.nData, fOptions), extend(cOptions.pData, fOptions), function(value) {
                return isNaN(value) ? symbols[mapper$1[1]] : isFinite(value) ? _this.intNumberFormatter(value, cOptions, dOptions) : symbols[mapper$1[0]];
            };
        }, NumberFormat.getGroupingDetails = function(pattern) {
            var ret = {}, match = pattern.match(IntlBase.negativeDataRegex);
            if (match && match[4]) {
                var pattern_1 = match[4], p = pattern_1.lastIndexOf(",");
                if (-1 !== p) {
                    var temp = pattern_1.split(".")[0];
                    ret.primary = temp.length - p - 1;
                    var s = pattern_1.lastIndexOf(",", p - 1);
                    -1 !== s && (ret.secondary = p - 1 - s);
                }
            }
            return ret;
        }, NumberFormat.checkValueRange = function(val1, val2, checkbothExist, isFraction) {
            var decide = isFraction ? "f" : "s", dint = 0, str1 = errorText["l" + decide], str2 = errorText["m" + decide];
            if (isUndefined(val1) || (this.checkRange(val1, str1, isFraction), dint++), isUndefined(val2) || (this.checkRange(val2, str2, isFraction), 
            dint++), 2 === dint) {
                if (!(val1 < val2)) return !0;
                throwError(str2 + "specified must be less than the" + str1);
            } else checkbothExist && 1 === dint && throwError("Both" + str2 + "and" + str2 + "must be present");
            return !1;
        }, NumberFormat.checkRange = function(val, text, isFraction) {
            var range = isFraction ? [ 0, 20 ] : [ 1, 21 ];
            (val < range[0] || val > range[1]) && throwError(text + "value must be within the range" + range[0] + "to" + range[1]);
        }, NumberFormat.intNumberFormatter = function(value, fOptions, dOptions) {
            var curData;
            if (!isUndefined(fOptions.nData.type)) {
                value < 0 ? (value *= -1, curData = fOptions.nData) : curData = 0 === value ? fOptions.zeroData || fOptions.pData : fOptions.pData;
                var fValue = "";
                return curData.isPercent && (value *= 100), curData.groupOne ? fValue = this.processSignificantDigits(value, curData.minimumSignificantDigits, curData.maximumSignificantDigits) : (fValue = this.processFraction(value, curData.minimumFractionDigits, curData.maximumFractionDigits), 
                curData.minimumIntegerDigits && (fValue = this.processMinimumIntegers(fValue, curData.minimumIntegerDigits))), 
                "scientific" === curData.type && (fValue = (fValue = value.toExponential(curData.maximumFractionDigits)).replace("e", dOptions.numberMapper.numberSymbols[mapper$1[4]])), 
                fValue = fValue.replace(".", dOptions.numberMapper.numberSymbols[mapper$1[3]]), 
                curData.useGrouping && (fValue = this.groupNumbers(fValue, curData.groupData.primary, curData.groupSeparator || ",", dOptions.numberMapper.numberSymbols[mapper$1[3]] || ".", curData.groupData.secondary)), 
                fValue = ParserBase.convertValueParts(fValue, IntlBase.latnParseRegex, dOptions.numberMapper.mapper), 
                "N/A" === curData.nlead ? curData.nlead : curData.nlead + fValue + curData.nend;
            }
        }, NumberFormat.processSignificantDigits = function(value, min, max) {
            var temp = value + "";
            return temp.length < min ? value.toPrecision(min) : (temp = value.toPrecision(max), 
            +temp + "");
        }, NumberFormat.groupNumbers = function(val, level1, sep, decimalSymbol, level2) {
            for (var flag = !isNullOrUndefined(level2) && 0 !== level2, split = val.split(decimalSymbol), prefix = split[0], length = prefix.length, str = ""; length > level1; ) str = prefix.slice(length - level1, length) + (str.length ? sep + str : ""), 
            length -= level1, flag && (level1 = level2, flag = !1);
            return split[0] = prefix.slice(0, length) + (str.length ? sep : "") + str, split.join(decimalSymbol);
        }, NumberFormat.processFraction = function(value, min, max) {
            var temp = (value + "").split(".")[1], length = temp ? temp.length : 0;
            if (min && length < min) {
                var ret = "";
                if (0 !== length) {
                    ret += value;
                    for (var j = 0; j < min - length; j++) ret += "0";
                    return ret;
                }
                return ret = value.toFixed(min), value.toFixed(min);
            }
            return !isNullOrUndefined(max) && (length > max || 0 === max) ? value.toFixed(max) : value + "";
        }, NumberFormat.processMinimumIntegers = function(value, min) {
            var temp = value.split("."), lead = temp[0], len = lead.length;
            if (len < min) {
                for (var i = 0; i < min - len; i++) lead = "0" + lead;
                temp[0] = lead;
            }
            return temp.join(".");
        }, NumberFormat;
    }();
    !function(IntlBase) {
        function getResultantPattern(skeleton, dateObject, type) {
            var resPattern, iType = type || "date";
            if (-1 !== IntlBase.basicPatterns.indexOf(skeleton)) {
                if (resPattern = getValue(iType + "Formats." + skeleton, dateObject), "dateTime" === iType) {
                    var dPattern = getValue("dateFormats." + skeleton, dateObject), tPattern = getValue("timeFormats." + skeleton, dateObject);
                    resPattern = resPattern.replace("{1}", dPattern).replace("{0}", tPattern);
                }
            } else resPattern = getValue("dateTimeFormats.availableFormats." + skeleton, dateObject);
            return resPattern;
        }
        function getDependables(cldr, culture, isNumber) {
            var ret = {};
            return ret.parserObject = ParserBase.getMainObject(cldr, culture) || IntlBase.defaultObject, 
            isNumber ? ret.numericObject = getValue("numbers", ret.parserObject) : ret.dateObject = getValue("dates.calendars.gregorian", ret.parserObject), 
            ret;
        }
        function getSymbolPattern(type, numSystem, obj, isAccount) {
            return getValue(type + "Formats-numberSystem-" + numSystem + (isAccount ? ".accounting" : ".standard"), obj) || (isAccount ? getValue(type + "Formats-numberSystem-" + numSystem + ".standard", obj) : "");
        }
        function getProperNumericSkeleton(skeleton) {
            var matches = skeleton.match(IntlBase.formatRegex), ret = {}, pattern = matches[1].toUpperCase();
            return ret.isAccount = "A" === pattern, ret.type = IntlBase.patternMatcher[pattern], 
            skeleton.length > 1 && (ret.fractionDigits = parseInt(matches[2], 10)), ret;
        }
        function getFormatData(pattern, needFraction, cSymbol, fractionOnly) {
            var nData = fractionOnly ? {} : {
                nlead: "",
                nend: ""
            }, match = pattern.match(IntlBase.customRegex);
            if (match) {
                fractionOnly || (nData.nlead = changeCurrencySymbol(match[1], cSymbol), nData.nend = changeCurrencySymbol(match[10], cSymbol), 
                nData.groupPattern = match[4]);
                var fraction = match[7];
                if (fraction && needFraction) {
                    var fmatch = fraction.match(fractionRegex);
                    isNullOrUndefined(fmatch) ? nData.minimumFraction = 0 : nData.minimumFraction = fmatch.length, 
                    nData.maximumFraction = fraction.length - 1;
                }
            }
            return nData;
        }
        function changeCurrencySymbol(val, sym) {
            return val ? val.replace(IntlBase.defaultCurrency, sym) : "";
        }
        function isCurrencyPercent(parts, actual, symbol) {
            for (var options = {
                nlead: parts[0],
                nend: parts[1]
            }, i = 0; i < 2; i++) {
                var part = parts[i], loc = part.indexOf(actual);
                if (-1 !== loc && (loc < part.indexOf("'") || loc > part.lastIndexOf("'"))) {
                    options[typeMapper[i]] = part.substr(0, loc) + symbol + part.substr(loc + 1), options[typeMapper[actual]] = !0, 
                    options.type = options.isCurrency ? "currency" : "percent";
                    break;
                }
            }
            return options;
        }
        IntlBase.negativeDataRegex = /^(('[^']+'|''|[^*#@0,.E])*)(\*.)?((([#,]*[0,]*0+)(\.0*[0-9]*#*)?)|([#,]*@+#*))(E\+?0+)?(('[^']+'|''|[^*#@0,.E])*)$/, 
        IntlBase.customRegex = /^(('[^']+'|''|[^*#@0,.])*)(\*.)?((([0#,]*[0,]*[0#]*)(\.[0#]*)?)|([#,]*@+#*))(E\+?0+)?(('[^']+'|''|[^*#@0,.E])*)$/, 
        IntlBase.latnParseRegex = /0|1|2|3|4|5|6|7|8|9/g;
        var fractionRegex = /[0-9]/g;
        IntlBase.defaultCurrency = "$";
        var mapper = [ "infinity", "nan", "group", "decimal" ], patternRegex = /G|M|L|H|c|'| a|yy|y|EEEE|E/g, patternMatch = {
            G: "",
            M: "m",
            L: "m",
            H: "h",
            c: "d",
            "'": '"',
            " a": " AM/PM",
            yy: "yy",
            y: "yyyy",
            EEEE: "dddd",
            E: "ddd"
        };
        IntlBase.formatRegex = /(^[ncpae]{1})([0-1]?[0-9]|20)?$/i;
        var typeMapper = {
            $: "isCurrency",
            "%": "isPercent",
            "-": "isNegative",
            0: "nlead",
            1: "nend"
        };
        IntlBase.dateParseRegex = /([a-z])\1*|'([^']|'')+'|''|./gi, IntlBase.basicPatterns = [ "short", "medium", "long", "full" ], 
        IntlBase.defaultObject = {
            dates: {
                calendars: {
                    gregorian: {
                        months: {
                            "stand-alone": {
                                abbreviated: {
                                    "1": "Jan",
                                    "2": "Feb",
                                    "3": "Mar",
                                    "4": "Apr",
                                    "5": "May",
                                    "6": "Jun",
                                    "7": "Jul",
                                    "8": "Aug",
                                    "9": "Sep",
                                    "10": "Oct",
                                    "11": "Nov",
                                    "12": "Dec"
                                },
                                narrow: {
                                    "1": "J",
                                    "2": "F",
                                    "3": "M",
                                    "4": "A",
                                    "5": "M",
                                    "6": "J",
                                    "7": "J",
                                    "8": "A",
                                    "9": "S",
                                    "10": "O",
                                    "11": "N",
                                    "12": "D"
                                },
                                wide: {
                                    "1": "January",
                                    "2": "February",
                                    "3": "March",
                                    "4": "April",
                                    "5": "May",
                                    "6": "June",
                                    "7": "July",
                                    "8": "August",
                                    "9": "September",
                                    "10": "October",
                                    "11": "November",
                                    "12": "December"
                                }
                            }
                        },
                        days: {
                            "stand-alone": {
                                abbreviated: {
                                    sun: "Sun",
                                    mon: "Mon",
                                    tue: "Tue",
                                    wed: "Wed",
                                    thu: "Thu",
                                    fri: "Fri",
                                    sat: "Sat"
                                },
                                narrow: {
                                    sun: "S",
                                    mon: "M",
                                    tue: "T",
                                    wed: "W",
                                    thu: "T",
                                    fri: "F",
                                    sat: "S"
                                },
                                short: {
                                    sun: "Su",
                                    mon: "Mo",
                                    tue: "Tu",
                                    wed: "We",
                                    thu: "Th",
                                    fri: "Fr",
                                    sat: "Sa"
                                },
                                wide: {
                                    sun: "Sunday",
                                    mon: "Monday",
                                    tue: "Tuesday",
                                    wed: "Wednesday",
                                    thu: "Thursday",
                                    fri: "Friday",
                                    sat: "Saturday"
                                }
                            }
                        },
                        dayPeriods: {
                            format: {
                                wide: {
                                    am: "AM",
                                    pm: "PM"
                                }
                            }
                        },
                        eras: {
                            eraNames: {
                                "0": "Before Christ",
                                "0-alt-variant": "Before Common Era",
                                "1": "Anno Domini",
                                "1-alt-variant": "Common Era"
                            },
                            eraAbbr: {
                                "0": "BC",
                                "0-alt-variant": "BCE",
                                "1": "AD",
                                "1-alt-variant": "CE"
                            },
                            eraNarrow: {
                                "0": "B",
                                "0-alt-variant": "BCE",
                                "1": "A",
                                "1-alt-variant": "CE"
                            }
                        },
                        dateFormats: {
                            full: "EEEE, MMMM d, y",
                            long: "MMMM d, y",
                            medium: "MMM d, y",
                            short: "M/d/yy"
                        },
                        timeFormats: {
                            full: "h:mm:ss a zzzz",
                            long: "h:mm:ss a z",
                            medium: "h:mm:ss a",
                            short: "h:mm a"
                        },
                        dateTimeFormats: {
                            full: "{1} 'at' {0}",
                            long: "{1} 'at' {0}",
                            medium: "{1}, {0}",
                            short: "{1}, {0}",
                            availableFormats: {
                                d: "d",
                                E: "ccc",
                                Ed: "d E",
                                Ehm: "E h:mm a",
                                EHm: "E HH:mm",
                                Ehms: "E h:mm:ss a",
                                EHms: "E HH:mm:ss",
                                Gy: "y G",
                                GyMMM: "MMM y G",
                                GyMMMd: "MMM d, y G",
                                GyMMMEd: "E, MMM d, y G",
                                h: "h a",
                                H: "HH",
                                hm: "h:mm a",
                                Hm: "HH:mm",
                                hms: "h:mm:ss a",
                                Hms: "HH:mm:ss",
                                hmsv: "h:mm:ss a v",
                                Hmsv: "HH:mm:ss v",
                                hmv: "h:mm a v",
                                Hmv: "HH:mm v",
                                M: "L",
                                Md: "M/d",
                                MEd: "E, M/d",
                                MMM: "LLL",
                                MMMd: "MMM d",
                                MMMEd: "E, MMM d",
                                MMMMd: "MMMM d",
                                ms: "mm:ss",
                                y: "y",
                                yM: "M/y",
                                yMd: "M/d/y",
                                yMEd: "E, M/d/y",
                                yMMM: "MMM y",
                                yMMMd: "MMM d, y",
                                yMMMEd: "E, MMM d, y",
                                yMMMM: "MMMM y"
                            }
                        }
                    }
                },
                timeZoneNames: {
                    hourFormat: "+HH:mm;-HH:mm",
                    gmtFormat: "GMT{0}",
                    gmtZeroFormat: "GMT"
                }
            },
            numbers: {
                currencies: {
                    USD: {
                        displayName: "US Dollar",
                        symbol: "$",
                        "symbol-alt-narrow": "$"
                    },
                    EUR: {
                        displayName: "Euro",
                        symbol: "€",
                        "symbol-alt-narrow": "€"
                    },
                    GBP: {
                        displayName: "British Pound",
                        "symbol-alt-narrow": "£"
                    }
                },
                defaultNumberingSystem: "latn",
                minimumGroupingDigits: "1",
                "symbols-numberSystem-latn": {
                    decimal: ".",
                    group: ",",
                    list: ";",
                    percentSign: "%",
                    plusSign: "+",
                    minusSign: "-",
                    exponential: "E",
                    superscriptingExponent: "×",
                    perMille: "‰",
                    infinity: "∞",
                    nan: "NaN",
                    timeSeparator: ":"
                },
                "decimalFormats-numberSystem-latn": {
                    standard: "#,##0.###"
                },
                "percentFormats-numberSystem-latn": {
                    standard: "#,##0%"
                },
                "currencyFormats-numberSystem-latn": {
                    standard: "¤#,##0.00",
                    accounting: "¤#,##0.00;(¤#,##0.00)"
                },
                "scientificFormats-numberSystem-latn": {
                    standard: "#E0"
                }
            }
        }, IntlBase.monthIndex = {
            3: "abbreviated",
            4: "wide",
            5: "narrow",
            1: "abbreviated"
        }, IntlBase.month = "months", IntlBase.days = "days", IntlBase.patternMatcher = {
            C: "currency",
            P: "percent",
            N: "decimal",
            A: "currency",
            E: "scientific"
        }, IntlBase.getResultantPattern = getResultantPattern, IntlBase.getDependables = getDependables, 
        IntlBase.getSymbolPattern = getSymbolPattern, IntlBase.getProperNumericSkeleton = getProperNumericSkeleton, 
        IntlBase.getFormatData = getFormatData, IntlBase.getCurrencySymbol = function(numericObject, currencyCode) {
            return getValue("currencies." + currencyCode + ".symbol", numericObject) || "$";
        }, IntlBase.customFormat = function(format, dOptions, obj) {
            for (var options = {}, formatSplit = format.split(";"), data = [ "pData", "nData", "zeroData" ], i = 0; i < formatSplit.length; i++) options[data[i]] = function(format, dOptions, numObject) {
                var cOptions = {
                    type: "decimal",
                    minimumFractionDigits: 0,
                    maximumFractionDigits: 0
                }, pattern = format.match(IntlBase.customRegex);
                (isNullOrUndefined(pattern) || "" === pattern[5] && "N/A" !== format) && (cOptions.type = void 0), 
                cOptions.nlead = pattern[1], cOptions.nend = pattern[10];
                var integerPart = pattern[6];
                cOptions.useGrouping = -1 !== integerPart.indexOf(","), integerPart = integerPart.replace(/,/g, "");
                var fractionPart = pattern[7];
                if (-1 !== integerPart.indexOf("0") && (cOptions.minimumIntegerDigits = integerPart.length - integerPart.indexOf("0")), 
                isNullOrUndefined(fractionPart) || (cOptions.minimumFractionDigits = fractionPart.lastIndexOf("0"), 
                cOptions.maximumFractionDigits = fractionPart.lastIndexOf("#"), -1 === cOptions.minimumFractionDigits && (cOptions.minimumFractionDigits = 0), 
                (-1 === cOptions.maximumFractionDigits || cOptions.maximumFractionDigits < cOptions.minimumFractionDigits) && (cOptions.maximumFractionDigits = cOptions.minimumFractionDigits)), 
                isNullOrUndefined(dOptions) ? extend(cOptions, isCurrencyPercent([ cOptions.nlead, cOptions.nend ], "%", "%")) : (extend(cOptions, isCurrencyPercent([ cOptions.nlead, cOptions.nend ], "$", dOptions.currencySymbol)), 
                cOptions.isCurrency || extend(cOptions, isCurrencyPercent([ cOptions.nlead, cOptions.nend ], "%", dOptions.percentSymbol))), 
                !isNullOrUndefined(numObject)) {
                    var symbolPattern = getSymbolPattern(cOptions.type, dOptions.numberMapper.numberSystem, numObject, !1);
                    cOptions.useGrouping && (cOptions.groupSeparator = dOptions.numberMapper.numberSymbols[mapper[2]], 
                    cOptions.groupData = NumberFormat.getGroupingDetails(symbolPattern.split(";")[0])), 
                    cOptions.nlead = cOptions.nlead.replace(/\'/g, ""), cOptions.nend = cOptions.nend.replace(/\'/g, "");
                }
                return cOptions;
            }(formatSplit[i], dOptions, obj);
            return isNullOrUndefined(options.nData) && (options.nData = extend({}, options.pData), 
            options.nData.nlead = isNullOrUndefined(dOptions) ? "-" + options.nData.nlead : dOptions.minusSymbol + options.nData.nlead), 
            options;
        }, IntlBase.isCurrencyPercent = isCurrencyPercent, IntlBase.getDateSeparator = function(dateObj) {
            var value = (getValue("dateFormats.short", dateObj) || "").match(/[d‏M‏]([^d‏M])[d‏M‏]/i);
            return value ? value[1] : "/";
        }, IntlBase.getActualDateTimeFormat = function(culture, options, cldr, isExcelFormat) {
            var dependable = getDependables(cldr, culture), actualPattern = options.format || getResultantPattern(options.skeleton, dependable.dateObject, options.type);
            if (isExcelFormat) {
                if (-1 !== (actualPattern = actualPattern.replace(patternRegex, function(pattern) {
                    return patternMatch[pattern];
                })).indexOf("z")) {
                    var tLength = actualPattern.match(/z/g).length, timeZonePattern = void 0, options_1 = {
                        timeZone: {}
                    };
                    options_1.numMapper = ParserBase.getNumberMapper(dependable.parserObject, ParserBase.getNumberingSystem(cldr)), 
                    options_1.timeZone = getValue("dates.timeZoneNames", dependable.parserObject);
                    var timezone = new Date().getTimezoneOffset(), pattern = tLength < 4 ? "+H;-H" : options_1.timeZone.hourFormat;
                    pattern = pattern.replace(/:/g, options_1.numMapper.timeSeparator), 0 === timezone ? timeZonePattern = options_1.timeZone.gmtZeroFormat : (timeZonePattern = DateFormat.getTimeZoneValue(timezone, pattern), 
                    timeZonePattern = options_1.timeZone.gmtFormat.replace(/\{0\}/, timeZonePattern)), 
                    actualPattern = actualPattern.replace(/[z]+/, '"' + timeZonePattern + '"');
                }
                actualPattern = actualPattern.replace(/ $/, "");
            }
            return actualPattern;
        }, IntlBase.getActualNumberFormat = function(culture, options, cldr) {
            var minFrac, dependable = getDependables(cldr, culture, !0), parseOptions = {
                custom: !0
            };
            if (/(c|a)$/gi.test(options.format) && !options.minimumFractionDigits && !options.maximumFractionDigits) {
                var dOptions = {};
                dOptions.numberMapper = ParserBase.getNumberMapper(dependable.parserObject, ParserBase.getNumberingSystem(cldr), !0), 
                minFrac = getFormatData(getSymbolPattern("currency", dOptions.numberMapper.numberSystem, dependable.numericObject, /a/i.test(options.format)).split(";")[0], !0, "", !0).minimumFraction;
            }
            var actualPattern;
            IntlBase.formatRegex.test(options.format) || !options.format ? (extend(parseOptions, getProperNumericSkeleton(options.format || "N")), 
            parseOptions.custom = !1, actualPattern = "###0", (parseOptions.fractionDigits || options.minimumFractionDigits || options.maximumFractionDigits || minFrac) && (parseOptions.fractionDigits && (options.minimumFractionDigits = options.maximumFractionDigits = parseOptions.fractionDigits), 
            actualPattern = function(pattern, minDigits, maxDigits) {
                pattern += ".";
                for (var a = 0; a < minDigits; a++) pattern += "0";
                if (minDigits < maxDigits) for (var diff = maxDigits - minDigits, b = 0; b < diff; b++) pattern += "#";
                return pattern;
            }(actualPattern, minFrac || parseOptions.fractionDigits || options.minimumFractionDigits || 0, options.maximumFractionDigits || 0)), 
            options.minimumIntegerDigits && (actualPattern = function(pattern, digits) {
                for (var temp = pattern.split("."), integer = "", x = 0; x < digits; x++) integer += "0";
                return temp[1] ? integer + "." + temp[1] : integer;
            }(actualPattern, options.minimumIntegerDigits)), options.useGrouping && (actualPattern = function(pattern) {
                var temp = pattern.split("."), integer = temp[0], no = 3 - integer.length % 3;
                pattern = "";
                for (var x = (integer = (no && 1 === no ? "#" : 2 === no ? "##" : "") + integer).length - 1; x > 0; x -= 3) pattern = "," + integer[x - 2] + integer[x - 1] + integer[x] + pattern;
                return pattern = pattern.slice(1), temp[1] ? pattern + "." + temp[1] : pattern;
            }(actualPattern)), "currency" !== parseOptions.type || parseOptions.isAccount ? "currency" === parseOptions.type && parseOptions.isAccount && (actualPattern = "$ " + actualPattern + ";($ " + actualPattern + ")") : actualPattern = "$ " + actualPattern, 
            "percent" === parseOptions.type && (actualPattern += " %")) : actualPattern = options.format.replace(/\'/g, '"');
            return actualPattern;
        };
    }(IntlBase || (IntlBase = {}));
    var lastPageID, abbreviateRegexGlobal = /\/MMMMM|MMMM|MMM|a|LLL|EEEEE|EEEE|E|K|ccc|G+|z+/gi, weekdayKey = [ "sun", "mon", "tue", "wed", "thu", "fri", "sat" ], timeSetter = {
        m: "getMinutes",
        h: "getHours",
        H: "getHours",
        s: "getSeconds",
        d: "getDate"
    }, datePartMatcher = {
        M: "month",
        d: "day",
        E: "weekday",
        c: "weekday",
        y: "year",
        m: "minute",
        h: "hour",
        H: "hour",
        s: "second",
        L: "month",
        a: "designator",
        z: "timeZone",
        Z: "timeZone",
        G: "era"
    }, DateFormat = function() {
        function DateFormat() {}
        return DateFormat.dateFormat = function(culture, option, cldr) {
            var _this = this, dependable = IntlBase.getDependables(cldr, culture), formatOptions = {}, resPattern = option.format || IntlBase.getResultantPattern(option.skeleton, dependable.dateObject, option.type);
            if (formatOptions.dateSeperator = IntlBase.getDateSeparator(dependable.dateObject), 
            isUndefined(resPattern)) throwError("Format options or type given must be invalid"); else {
                formatOptions.pattern = resPattern, formatOptions.numMapper = ParserBase.getNumberMapper(dependable.parserObject, ParserBase.getNumberingSystem(cldr));
                for (var _i = 0, patternMatch_1 = resPattern.match(abbreviateRegexGlobal) || []; _i < patternMatch_1.length; _i++) {
                    var str = patternMatch_1[_i], len = str.length, char = str[0];
                    switch ("K" === char && (char = "h"), char) {
                      case "E":
                      case "c":
                        formatOptions.weekday = dependable.dateObject[IntlBase.days]["stand-alone"][IntlBase.monthIndex[len]];
                        break;

                      case "M":
                      case "L":
                        formatOptions.month = dependable.dateObject[IntlBase.month]["stand-alone"][IntlBase.monthIndex[len]];
                        break;

                      case "a":
                        formatOptions.designator = getValue("dayPeriods.format.wide", dependable.dateObject);
                        break;

                      case "G":
                        var eText = len <= 3 ? "eraAbbr" : 4 === len ? "eraNames" : "eraNarrow";
                        formatOptions.era = getValue("eras." + eText, dependable.dateObject);
                        break;

                      case "z":
                        formatOptions.timeZone = getValue("dates.timeZoneNames", dependable.parserObject);
                    }
                }
            }
            return function(value) {
                return isNaN(value.getDate()) ? null : _this.intDateFormatter(value, formatOptions);
            };
        }, DateFormat.intDateFormatter = function(value, options) {
            for (var ret = "", _i = 0, matches_1 = options.pattern.match(IntlBase.dateParseRegex); _i < matches_1.length; _i++) {
                var match = matches_1[_i], length_1 = match.length, char = match[0];
                "K" === char && (char = "h");
                var curval = void 0, isNumber = void 0, processNumber = void 0, curstr = "";
                switch (char) {
                  case "M":
                  case "L":
                    curval = value.getMonth() + 1, length_1 > 2 ? ret += options.month[curval] : isNumber = !0;
                    break;

                  case "E":
                  case "c":
                    ret += options.weekday[weekdayKey[value.getDay()]];
                    break;

                  case "H":
                  case "h":
                  case "m":
                  case "s":
                  case "d":
                    isNumber = !0, curval = value[timeSetter[char]](), "h" === char && (curval = curval % 12 || 12);
                    break;

                  case "y":
                    processNumber = !0, curstr += value.getFullYear(), 2 === length_1 && (curstr = curstr.substr(curstr.length - 2));
                    break;

                  case "a":
                    var desig = value.getHours() < 12 ? "am" : "pm";
                    ret += options.designator[desig];
                    break;

                  case "G":
                    var dec = value.getFullYear() < 0 ? 0 : 1;
                    ret += options.era[dec];
                    break;

                  case "'":
                    ret += "''" === match ? "'" : match.replace(/\'/g, "");
                    break;

                  case "z":
                    var timezone = value.getTimezoneOffset(), pattern_1 = length_1 < 4 ? "+H;-H" : options.timeZone.hourFormat;
                    pattern_1 = pattern_1.replace(/:/g, options.numMapper.timeSeparator), 0 === timezone ? ret += options.timeZone.gmtZeroFormat : (processNumber = !0, 
                    curstr = this.getTimeZoneValue(timezone, pattern_1)), curstr = options.timeZone.gmtFormat.replace(/\{0\}/, curstr);
                    break;

                  case ":":
                    ret += options.numMapper.numberSymbols.timeSeparator;
                    break;

                  case "/":
                    ret += options.dateSeperator;
                    break;

                  default:
                    ret += match;
                }
                isNumber && (processNumber = !0, curstr = this.checkTwodigitNumber(curval, length_1)), 
                processNumber && (ret += ParserBase.convertValueParts(curstr, IntlBase.latnParseRegex, options.numMapper.mapper));
            }
            return ret;
        }, DateFormat.checkTwodigitNumber = function(val, len) {
            var ret = val + "";
            return 2 === len && 2 !== ret.length ? "0" + ret : ret;
        }, DateFormat.getTimeZoneValue = function(tVal, pattern) {
            var _this = this, curPattern = pattern.split(";")[tVal > 0 ? 1 : 0], no = Math.abs(tVal);
            return curPattern = curPattern.replace(/HH?|mm/g, function(str) {
                var len = str.length, ishour = -1 !== str.indexOf("H");
                return _this.checkTwodigitNumber(Math.floor(ishour ? no / 60 : no % 60), len);
            });
        }, DateFormat;
    }(), latnRegex$1 = /^[0-9]*$/, timeSetter$1 = {
        minute: "setMinutes",
        hour: "setHours",
        second: "setSeconds",
        day: "setDate",
        month: "setMonth"
    }, DateParser = function() {
        function DateParser() {}
        return DateParser.dateParser = function(culture, option, cldr) {
            var hourOnly, _this = this, dependable = IntlBase.getDependables(cldr, culture), numOptions = ParserBase.getCurrentNumericOptions(dependable.parserObject, ParserBase.getNumberingSystem(cldr)), parseOptions = {}, resPattern = option.format || IntlBase.getResultantPattern(option.skeleton, dependable.dateObject, option.type), regexString = "";
            if (isUndefined(resPattern)) throwError("Format options or type given must be invalid"); else {
                parseOptions = {
                    pattern: resPattern,
                    evalposition: {}
                };
                for (var patternMatch = resPattern.match(IntlBase.dateParseRegex) || [], length_1 = patternMatch.length, gmtCorrection = 0, zCorrectTemp = 0, isgmtTraversed = !1, nRegx = numOptions.numericRegex, i = 0; i < length_1; i++) {
                    var str = patternMatch[i], len = str.length, char = "K" === str[0] ? "h" : str[0], isNumber = void 0, canUpdate = void 0, charKey = datePartMatcher[char], optional = 2 === len ? "" : "?";
                    switch (isgmtTraversed && (gmtCorrection = zCorrectTemp, isgmtTraversed = !1), char) {
                      case "E":
                      case "c":
                        var weekObject = ParserBase.reverseObject(dependable.dateObject[IntlBase.days]["stand-alone"][IntlBase.monthIndex[len]]);
                        regexString += "(" + Object.keys(weekObject).join("|") + ")";
                        break;

                      case "M":
                      case "L":
                      case "d":
                      case "m":
                      case "s":
                      case "h":
                      case "H":
                        canUpdate = !0, ("M" === char || "L" === char) && len > 2 ? (parseOptions[charKey] = ParserBase.reverseObject(dependable.dateObject.months["stand-alone"][IntlBase.monthIndex[len]]), 
                        regexString += "(" + Object.keys(parseOptions[charKey]).join("|") + ")") : (isNumber = !0, 
                        regexString += "(" + nRegx + nRegx + optional + ")"), "h" === char && (parseOptions.hour12 = !0);
                        break;

                      case "y":
                        canUpdate = isNumber = !0, regexString += 2 === len ? "(" + nRegx + nRegx + ")" : "(" + nRegx + "{" + len + ",})";
                        break;

                      case "a":
                        canUpdate = !0, parseOptions[charKey] = ParserBase.reverseObject(getValue("dayPeriods.format.wide", dependable.dateObject)), 
                        regexString += "(" + Object.keys(parseOptions[charKey]).join("|") + ")";
                        break;

                      case "G":
                        canUpdate = !0;
                        var eText = len <= 3 ? "eraAbbr" : 4 === len ? "eraNames" : "eraNarrow";
                        parseOptions[charKey] = ParserBase.reverseObject(getValue("eras." + eText, dependable.dateObject)), 
                        regexString += "(" + Object.keys(parseOptions[charKey]).join("|") + "?)";
                        break;

                      case "z":
                        canUpdate = 0 !== new Date().getTimezoneOffset(), parseOptions[charKey] = getValue("dates.timeZoneNames", dependable.parserObject);
                        var tzone = parseOptions[charKey], hpattern = (hourOnly = len < 4) ? "+H;-H" : tzone.hourFormat;
                        regexString += "(" + this.parseTimeZoneRegx(hpattern, tzone, nRegx) + ")?", isgmtTraversed = !0, 
                        zCorrectTemp = hourOnly ? 6 : 12;
                        break;

                      case "'":
                        regexString += "(" + str.replace(/\'/g, "") + ")?";
                        break;

                      default:
                        regexString += "(.)?";
                    }
                    canUpdate && (parseOptions.evalposition[charKey] = {
                        isNumber: isNumber,
                        pos: i + 1 + gmtCorrection,
                        hourOnly: hourOnly
                    }), i !== length_1 - 1 || isNullOrUndefined(regexString) || (parseOptions.parserRegex = new RegExp("^" + regexString + "$"));
                }
            }
            return function(value) {
                var parsedDateParts = _this.internalDateParse(value, parseOptions, numOptions);
                return isNullOrUndefined(parsedDateParts) || !Object.keys(parsedDateParts).length ? null : _this.getDateObject(parsedDateParts);
            };
        }, DateParser.getDateObject = function(options, value) {
            var res = value || new Date();
            res.setMilliseconds(0);
            var y = options.year, desig = options.designator, tzone = options.timeZone;
            if (!isUndefined(y)) {
                if ((y + "").length <= 2) {
                    y += 100 * Math.floor(res.getFullYear() / 100);
                }
                res.setFullYear(y);
            }
            for (var _i = 0, tKeys_1 = [ "hour", "minute", "second", "month", "day" ]; _i < tKeys_1.length; _i++) {
                var key = tKeys_1[_i], tValue = options[key];
                if (!isUndefined(tValue)) if ("month" === key) {
                    if ((tValue -= 1) < 0 || tValue > 11) return new Date("invalid");
                    var pDate = res.getDate();
                    res.setDate(1), res[timeSetter$1[key]](tValue);
                    var lDate = new Date(res.getFullYear(), tValue + 1, 0).getDate();
                    res.setDate(pDate < lDate ? pDate : lDate);
                } else {
                    if ("day" === key) {
                        var lastDay = new Date(res.getFullYear(), res.getMonth() + 1, 0).getDate();
                        if (tValue < 1 || tValue > lastDay) return null;
                    }
                    res[timeSetter$1[key]](tValue);
                }
            }
            if (!isUndefined(desig)) {
                var hour = res.getHours();
                "pm" === desig ? res.setHours(hour + (12 === hour ? 0 : 12)) : 12 === hour && res.setHours(0);
            }
            if (!isUndefined(tzone)) {
                var tzValue = tzone - res.getTimezoneOffset();
                0 !== tzValue && res.setMinutes(res.getMinutes() + tzValue);
            }
            return res;
        }, DateParser.internalDateParse = function(value, parseOptions, num) {
            var matches = value.match(parseOptions.parserRegex), retOptions = {
                hour: 0,
                minute: 0,
                second: 0
            };
            num.numericRegex;
            if (isNullOrUndefined(matches)) return null;
            for (var _i = 0, props_1 = Object.keys(parseOptions.evalposition); _i < props_1.length; _i++) {
                var prop = props_1[_i], curObject = parseOptions.evalposition[prop], matchString = matches[curObject.pos];
                if (curObject.isNumber) retOptions[prop] = this.internalNumberParser(matchString, num); else if ("timeZone" !== prop || isUndefined(matchString)) retOptions[prop] = parseOptions[prop][matchString]; else {
                    var pos = curObject.pos, val = void 0, tmatch = matches[pos + 1], flag = !isUndefined(tmatch);
                    curObject.hourOnly ? val = 60 * this.getZoneValue(flag, tmatch, matches[pos + 4], num) : (val = 60 * this.getZoneValue(flag, tmatch, matches[pos + 7], num), 
                    val += this.getZoneValue(flag, matches[pos + 4], matches[pos + 10], num)), isNullOrUndefined(val) || (retOptions[prop] = val);
                }
            }
            return parseOptions.hour12 && (retOptions.hour12 = !0), retOptions;
        }, DateParser.internalNumberParser = function(value, option) {
            return value = ParserBase.convertValueParts(value, option.numberParseRegex, option.numericPair), 
            latnRegex$1.test(value) ? +value : null;
        }, DateParser.parseTimeZoneRegx = function(hourFormat, tZone, nRegex) {
            var ret, splitStr, pattern = tZone.gmtFormat, cRegex = "(" + nRegex + ")(" + nRegex + ")";
            return ret = hourFormat.replace("+", "\\+"), ret = -1 !== hourFormat.indexOf("HH") ? ret.replace(/HH|mm/g, "(" + cRegex + ")") : ret.replace(/H|m/g, "(" + cRegex + "?)"), 
            splitStr = ret.split(";").map(function(str) {
                return pattern.replace("{0}", str);
            }), ret = splitStr.join("|") + "|" + tZone.gmtZeroFormat;
        }, DateParser.getZoneValue = function(flag, val1, val2, num) {
            var value = this.internalNumberParser(flag ? val1 : val2, num);
            return flag ? -value : value;
        }, DateParser;
    }(), parseRegex = /^([^0-9]*)(([0-9,]*[0-9]+)(\.[0-9]+)?)([Ee][+-]?[0-9]+)?([^0-9]*)$/, groupRegex = /,/g, keys = [ "minusSign", "infinity" ], NumberParser = function() {
        function NumberParser() {}
        return NumberParser.numberParser = function(culture, option, cldr) {
            var numOptions, _this = this, dependable = IntlBase.getDependables(cldr, culture, !0), parseOptions = {
                custom: !0
            };
            IntlBase.formatRegex.test(option.format) || !option.format ? (extend(parseOptions, IntlBase.getProperNumericSkeleton(option.format || "N")), 
            parseOptions.custom = !1) : extend(parseOptions, IntlBase.customFormat(option.format, null, null)), 
            numOptions = ParserBase.getCurrentNumericOptions(dependable.parserObject, ParserBase.getNumberingSystem(cldr), !0), 
            parseOptions.symbolRegex = ParserBase.getSymbolRegex(Object.keys(numOptions.symbolMatch)), 
            parseOptions.infinity = numOptions.symbolNumberSystem[keys[1]];
            var symbolpattern = IntlBase.getSymbolPattern(parseOptions.type, numOptions.numberSystem, dependable.numericObject, parseOptions.isAccount);
            if (symbolpattern) {
                var split = (symbolpattern = symbolpattern.replace(/\u00A4/g, IntlBase.defaultCurrency)).split(";");
                parseOptions.nData = IntlBase.getFormatData(split[1] || "-" + split[0], !0, ""), 
                parseOptions.pData = IntlBase.getFormatData(split[0], !0, "");
            }
            return function(value) {
                return _this.getParsedNumber(value, parseOptions, numOptions);
            };
        }, NumberParser.getParsedNumber = function(value, options, numOptions) {
            var isNegative, isPercent, tempValue, lead, end, ret;
            if (-1 !== value.indexOf(options.infinity)) return 1 / 0;
            value = ParserBase.convertValueParts(value, options.symbolRegex, numOptions.symbolMatch), 
            0 === (value = ParserBase.convertValueParts(value, numOptions.numberParseRegex, numOptions.numericPair)).indexOf(".") && (value = "0" + value);
            var matches = value.match(parseRegex);
            if (isNullOrUndefined(matches)) return NaN;
            lead = matches[1], tempValue = matches[2];
            var exponent = matches[5];
            return end = matches[6], isNegative = options.custom ? lead === options.nData.nlead && end === options.nData.nend : -1 !== lead.indexOf(options.nData.nlead) && -1 !== end.indexOf(options.nData.nend), 
            isPercent = isNegative ? options.nData.isPercent : options.pData.isPercent, tempValue = tempValue.replace(groupRegex, ""), 
            exponent && (tempValue += exponent), ret = +tempValue, ("percent" === options.type || isPercent) && (ret /= 100), 
            (options.custom || options.fractionDigits) && (ret = parseFloat(ret.toFixed(options.custom ? isNegative ? options.nData.maximumFractionDigits : options.pData.maximumFractionDigits : options.fractionDigits))), 
            isNegative && (ret *= -1), ret;
        }, NumberParser;
    }(), onIntlChange = new Observer(), rightToLeft = !1, cldrData = {}, defaultCulture = "en-US", defaultCurrencyCode = "USD", mapper = [ "numericObject", "dateObject" ], Internationalization = function() {
        function Internationalization(cultureName) {
            cultureName && (this.culture = cultureName);
        }
        return Internationalization.prototype.getDateFormat = function(options) {
            return DateFormat.dateFormat(this.getCulture(), options || {
                type: "date",
                skeleton: "short"
            }, cldrData);
        }, Internationalization.prototype.getNumberFormat = function(options) {
            return options && !options.currency && (options.currency = defaultCurrencyCode), 
            NumberFormat.numberFormatter(this.getCulture(), options || {}, cldrData);
        }, Internationalization.prototype.getDateParser = function(options) {
            return DateParser.dateParser(this.getCulture(), options || {
                skeleton: "short",
                type: "date"
            }, cldrData);
        }, Internationalization.prototype.getNumberParser = function(options) {
            return NumberParser.numberParser(this.getCulture(), options || {
                format: "N"
            }, cldrData);
        }, Internationalization.prototype.formatNumber = function(value, option) {
            return this.getNumberFormat(option)(value);
        }, Internationalization.prototype.formatDate = function(value, option) {
            return this.getDateFormat(option)(value);
        }, Internationalization.prototype.parseDate = function(value, option) {
            return this.getDateParser(option)(value);
        }, Internationalization.prototype.parseNumber = function(value, option) {
            return this.getNumberParser(option)(value);
        }, Internationalization.prototype.getDatePattern = function(option, isExcelFormat) {
            return IntlBase.getActualDateTimeFormat(this.getCulture(), option, cldrData, isExcelFormat);
        }, Internationalization.prototype.getNumberPattern = function(option) {
            return IntlBase.getActualNumberFormat(this.getCulture(), option, cldrData);
        }, Internationalization.prototype.getCulture = function() {
            return this.culture || defaultCulture;
        }, Internationalization;
    }(), __extends$1$1 = function() {
        var extendStatics = Object.setPrototypeOf || {
            __proto__: []
        } instanceof Array && function(d, b) {
            d.__proto__ = b;
        } || function(d, b) {
            for (var p in b) b.hasOwnProperty(p) && (d[p] = b[p]);
        };
        return function(d, b) {
            function __() {
                this.constructor = d;
            }
            extendStatics(d, b), d.prototype = null === b ? Object.create(b) : (__.prototype = b.prototype, 
            new __());
        };
    }(), __decorate$1$1 = function(decorators, target, key, desc) {
        var d, c = arguments.length, r = c < 3 ? target : null === desc ? desc = Object.getOwnPropertyDescriptor(target, key) : desc;
        if ("object" == typeof Reflect && "function" == typeof Reflect.decorate) r = Reflect.decorate(decorators, target, key, desc); else for (var i = decorators.length - 1; i >= 0; i--) (d = decorators[i]) && (r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r);
        return c > 3 && r && Object.defineProperty(target, key, r), r;
    }, componentCount = 0, lastHistoryLen = 0, Component = function(_super) {
        function Component(options, selector) {
            var _this = _super.call(this, options, selector) || this;
            return _this.randomId = uniqueID(), _this.needsID = !1, isNullOrUndefined(_this.enableRtl) && _this.setProperties({
                enableRtl: rightToLeft
            }, !0), isNullOrUndefined(_this.locale) && _this.setProperties({
                locale: defaultCulture
            }, !0), _this.moduleLoader = new ModuleLoader(_this), _this.localObserver = new Observer(_this), 
            _this.detectFunction = new Function("args", "var prop = Object.keys(args); if(prop.length){this[prop[0]] = args[prop[0]];}"), 
            onIntlChange.on("notifyExternalChange", _this.detectFunction, _this, _this.randomId), 
            isUndefined(selector) || _this.appendTo(), _this;
        }
        return __extends$1$1(Component, _super), Component.prototype.requiredModules = function() {
            return [];
        }, Component.prototype.destroy = function() {
            this.isDestroyed || (this.enablePersistence && this.setPersistData(), this.localObserver.destroy(), 
            this.refreshing || (this.trigger("destroyed", {
                cancel: !1
            }), _super.prototype.destroy.call(this), this.moduleLoader.clean(), onIntlChange.off("notifyExternalChange", this.detectFunction, this.randomId)));
        }, Component.prototype.refresh = function() {
            this.refreshing = !0, this.moduleLoader.clean(), this.destroy(), this.clearChanges(), 
            this.localObserver = new Observer(this), this.preRender(), this.injectModules(), 
            this.render(), this.refreshing = !1;
        }, Component.prototype.appendTo = function(selector) {
            if (isNullOrUndefined(selector) || "string" != typeof selector ? isNullOrUndefined(selector) || (this.element = selector) : this.element = document.querySelector(selector), 
            !isNullOrUndefined(this.element)) {
                this.isProtectedOnChange = !1, this.needsID && !this.element.id && (this.element.id = this.getUniqueID(this.getModuleName())), 
                this.enablePersistence && (this.mergePersistData(), window.addEventListener("unload", this.setPersistData.bind(this)));
                var inst = getValue("ej2_instances", this.element);
                inst && -1 !== inst.indexOf(this) || _super.prototype.addInstance.call(this), this.preRender(), 
                this.injectModules(), this.render(), this.trigger("created");
            }
        }, Component.prototype.dataBind = function() {
            this.injectModules(), _super.prototype.dataBind.call(this);
        }, Component.prototype.on = function(event, handler, context) {
            if ("string" == typeof event) this.localObserver.on(event, handler, context); else for (var _i = 0, event_1 = event; _i < event_1.length; _i++) {
                var arg = event_1[_i];
                this.localObserver.on(arg.event, arg.handler, arg.context);
            }
        }, Component.prototype.off = function(event, handler) {
            if ("string" == typeof event) this.localObserver.off(event, handler); else for (var _i = 0, event_2 = event; _i < event_2.length; _i++) {
                var arg = event_2[_i];
                this.localObserver.off(arg.event, arg.handler);
            }
        }, Component.prototype.notify = function(property, argument) {
            !0 !== this.isDestroyed && this.localObserver.notify(property, argument);
        }, Component.prototype.getInjectedModules = function() {
            return this.injectedModules;
        }, Component.Inject = function() {
            for (var moduleList = [], _i = 0; _i < arguments.length; _i++) moduleList[_i] = arguments[_i];
            this.prototype.injectedModules || (this.prototype.injectedModules = []);
            for (var i = 0; i < moduleList.length; i++) -1 === this.prototype.injectedModules.indexOf(moduleList[i]) && this.prototype.injectedModules.push(moduleList[i]);
        }, Component.prototype.injectModules = function() {
            this.injectedModules && this.injectedModules.length && this.moduleLoader.inject(this.requiredModules(), this.injectedModules);
        }, Component.prototype.mergePersistData = function() {
            var data = window.localStorage.getItem(this.getModuleName() + this.element.id);
            isNullOrUndefined(data) || "" === data || this.setProperties(JSON.parse(data), !0);
        }, Component.prototype.setPersistData = function() {
            this.isDestroyed || window.localStorage.setItem(this.getModuleName() + this.element.id, this.getPersistData());
        }, Component.prototype.clearTemplate = function(templateName) {}, Component.prototype.getUniqueID = function(definedName) {
            return this.isHistoryChanged() && (componentCount = 0), lastPageID = this.pageID(location.href), 
            lastHistoryLen = history.length, definedName + "_" + lastPageID + "_" + componentCount++;
        }, Component.prototype.pageID = function(url) {
            var hash = 0;
            if (0 === url.length) return hash;
            for (var i = 0; i < url.length; i++) {
                hash = (hash << 5) - hash + url.charCodeAt(i), hash &= hash;
            }
            return Math.abs(hash);
        }, Component.prototype.isHistoryChanged = function() {
            return lastPageID !== this.pageID(location.href) || lastHistoryLen !== history.length;
        }, Component.prototype.addOnPersist = function(options) {
            for (var _this = this, persistObj = {}, _i = 0, options_1 = options; _i < options_1.length; _i++) {
                var key = options_1[_i], objValue = void 0;
                isUndefined(objValue = getValue(key, this)) || setValue(key, this.getActualProperties(objValue), persistObj);
            }
            return JSON.stringify(persistObj, function(key, value) {
                return _this.getActualProperties(value);
            });
        }, Component.prototype.getActualProperties = function(obj) {
            return obj instanceof ChildProperty ? getValue("properties", obj) : obj;
        }, Component.prototype.ignoreOnPersist = function(options) {
            return JSON.stringify(this.iterateJsonProperties(this.properties, options));
        }, Component.prototype.iterateJsonProperties = function(obj, ignoreList) {
            for (var newObj = {}, _loop_1 = function(key) {
                if (-1 === ignoreList.indexOf(key)) {
                    var value = obj[key];
                    if ("object" != typeof value || value instanceof Array) newObj[key] = value; else {
                        var newList = ignoreList.filter(function(str) {
                            return new RegExp(key + ".").test(str);
                        }).map(function(str) {
                            return str.replace(key + ".", "");
                        });
                        newObj[key] = this_1.iterateJsonProperties(this_1.getActualProperties(value), newList);
                    }
                }
            }, this_1 = this, _i = 0, _a = Object.keys(obj); _i < _a.length; _i++) {
                _loop_1(_a[_i]);
            }
            return newObj;
        }, __decorate$1$1([ Property(!1) ], Component.prototype, "enablePersistence", void 0), 
        __decorate$1$1([ Property() ], Component.prototype, "enableRtl", void 0), __decorate$1$1([ Property() ], Component.prototype, "locale", void 0), 
        Component = __decorate$1$1([ NotifyPropertyChanges ], Component);
    }(Base);
    "undefined" != typeof window && window.addEventListener("popstate", function() {
        componentCount = 0;
    });
    var elementRect, element, parentDocument, parentDocument$1, targetContainer, Input, __extends$2 = function() {
        var extendStatics = Object.setPrototypeOf || {
            __proto__: []
        } instanceof Array && function(d, b) {
            d.__proto__ = b;
        } || function(d, b) {
            for (var p in b) b.hasOwnProperty(p) && (d[p] = b[p]);
        };
        return function(d, b) {
            function __() {
                this.constructor = d;
            }
            extendStatics(d, b), d.prototype = null === b ? Object.create(b) : (__.prototype = b.prototype, 
            new __());
        };
    }(), __decorate$2 = function(decorators, target, key, desc) {
        var d, c = arguments.length, r = c < 3 ? target : null === desc ? desc = Object.getOwnPropertyDescriptor(target, key) : desc;
        if ("object" == typeof Reflect && "function" == typeof Reflect.decorate) r = Reflect.decorate(decorators, target, key, desc); else for (var i = decorators.length - 1; i >= 0; i--) (d = decorators[i]) && (r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r);
        return c > 3 && r && Object.defineProperty(target, key, r), r;
    }, defaultPosition = {
        left: 0,
        top: 0,
        bottom: 0,
        right: 0
    }, Position = function(_super) {
        function Position() {
            return null !== _super && _super.apply(this, arguments) || this;
        }
        return __extends$2(Position, _super), __decorate$2([ Property(0) ], Position.prototype, "left", void 0), 
        __decorate$2([ Property(0) ], Position.prototype, "top", void 0), Position;
    }(ChildProperty), Draggable = function(_super) {
        function Draggable(element, options) {
            var _this = _super.call(this, options, element) || this;
            return _this.dragLimit = Draggable_1.getDefaultPosition(), _this.borderWidth = Draggable_1.getDefaultPosition(), 
            _this.padding = Draggable_1.getDefaultPosition(), _this.diffX = 0, _this.diffY = 0, 
            _this.droppables = {}, _this.bind(), _this;
        }
        return __extends$2(Draggable, _super), Draggable_1 = Draggable, Draggable.prototype.bind = function() {
            this.toggleEvents(), Browser.isIE && addClass([ this.element ], "e-block-touch"), 
            this.droppables[this.scope] = {};
        }, Draggable.getDefaultPosition = function() {
            return extend({}, defaultPosition);
        }, Draggable.prototype.toggleEvents = function(isUnWire) {
            var ele;
            isUndefined(this.handle) || (ele = select(this.handle, this.element)), isUnWire ? EventHandler.remove(ele || this.element, Browser.touchStartEvent, this.initialize) : EventHandler.add(ele || this.element, Browser.touchStartEvent, this.initialize, this);
        }, Draggable.prototype.initialize = function(evt) {
            if (this.target = evt.currentTarget, this.preventDefault && !isUndefined(evt.changedTouches) && evt.preventDefault(), 
            !this.abort || isNullOrUndefined(closest(evt.target, this.abort))) {
                this.element.setAttribute("aria-grabbed", "true");
                var intCoord = this.getCoordinates(evt);
                if (this.initialPosition = {
                    x: intCoord.pageX,
                    y: intCoord.pageY
                }, !this.clone) {
                    var pos = this.element.getBoundingClientRect();
                    this.relativeXPosition = intCoord.pageX - pos.left, this.relativeYPosition = intCoord.pageY - pos.top;
                }
                EventHandler.add(document, Browser.touchMoveEvent, this.intDragStart, this), EventHandler.add(document, Browser.touchEndEvent, this.intDestroy, this), 
                this.toggleEvents(!0), document.body.classList.add("e-prevent-select"), EventHandler.trigger(document.documentElement, Browser.touchStartEvent, evt);
            }
        }, Draggable.prototype.intDragStart = function(evt) {
            if (!!isUndefined(evt.changedTouches) || 1 === evt.changedTouches.length) {
                var pos, intCordinate = this.getCoordinates(evt), styleProp = getComputedStyle(this.element);
                this.margin = {
                    left: parseInt(styleProp.marginLeft, 10),
                    top: parseInt(styleProp.marginTop, 10),
                    right: parseInt(styleProp.marginRight, 10),
                    bottom: parseInt(styleProp.marginBottom, 10)
                };
                var element = this.element;
                if (this.clone && this.dragTarget) {
                    var intClosest = closest(evt.target, this.dragTarget);
                    isNullOrUndefined(intClosest) || (element = intClosest);
                }
                this.offset = this.calculateParentPosition(element), this.position = this.getMousePosition(evt);
                var x = this.initialPosition.x - intCordinate.pageX, y = this.initialPosition.y - intCordinate.pageY;
                if (Math.sqrt(x * x + y * y) >= this.distance) {
                    var ele = this.getHelperElement(evt);
                    if (!ele || isNullOrUndefined(ele)) return;
                    var dragTargetElement = this.helperElement = ele;
                    if (this.parentClientRect = this.calculateParentPosition(dragTargetElement.offsetParent), 
                    this.dragStart) {
                        var curTarget = this.getProperTargetElement(evt);
                        this.trigger("dragStart", {
                            event: evt,
                            element: element,
                            target: curTarget
                        });
                    }
                    this.dragArea ? this.setDragArea() : (this.dragLimit = {
                        left: 0,
                        right: 0,
                        bottom: 0,
                        top: 0
                    }, this.borderWidth = {
                        top: 0,
                        left: 0
                    }), pos = {
                        left: this.position.left - this.parentClientRect.left,
                        top: this.position.top - this.parentClientRect.top
                    }, this.clone && !this.enableTailMode && (this.diffX = this.position.left - this.offset.left, 
                    this.diffY = this.position.top - this.offset.top);
                    var posValue = this.getProcessedPositionValue({
                        top: pos.top - this.diffY + "px",
                        left: pos.left - this.diffX + "px"
                    });
                    setStyleAttribute(dragTargetElement, {
                        position: "absolute",
                        top: posValue.top,
                        left: posValue.left
                    }), EventHandler.remove(document, Browser.touchMoveEvent, this.intDragStart), EventHandler.remove(document, Browser.touchEndEvent, this.intDestroy), 
                    isVisible(dragTargetElement) ? (EventHandler.add(document, Browser.touchMoveEvent, this.intDrag, this), 
                    EventHandler.add(document, Browser.touchEndEvent, this.intDragStop, this), this.setGlobalDroppables(!1, this.element, dragTargetElement)) : document.body.classList.remove("e-prevent-select");
                }
            }
        }, Draggable.prototype.getProcessedPositionValue = function(value) {
            return this.axis && ("x" === this.axis ? value.top = "0px" : "y" === this.axis && (value.left = "0px")), 
            this.queryPositionInfo ? this.queryPositionInfo(value) : value;
        }, Draggable.prototype.calculateParentPosition = function(ele) {
            if (isNullOrUndefined(ele)) return {
                left: 0,
                top: 0
            };
            var rect = ele.getBoundingClientRect(), style = getComputedStyle(ele);
            return {
                left: rect.left + window.pageXOffset - parseInt(style.marginLeft, 10),
                top: rect.top + window.pageYOffset - parseInt(style.marginTop, 10)
            };
        }, Draggable.prototype.intDrag = function(evt) {
            if (isUndefined(evt.changedTouches) || 1 === evt.changedTouches.length) {
                var left, top;
                this.position = this.getMousePosition(evt);
                var docHeight = this.getDocumentWidthHeight("Height");
                docHeight < this.position.top && (this.position.top = docHeight);
                var docWidth = this.getDocumentWidthHeight("Width");
                if (docWidth < this.position.left && (this.position.left = docWidth), this.drag) {
                    var curTarget = this.getProperTargetElement(evt);
                    this.trigger("drag", {
                        event: evt,
                        element: this.element,
                        target: curTarget
                    });
                }
                var eleObj = this.checkTargetElement(evt);
                eleObj.target && eleObj.instance ? (eleObj.instance.intOver(evt, eleObj.target), 
                eleObj.instance.dragData[this.scope] = this.droppables[this.scope], this.hoverObject = eleObj) : this.hoverObject && (this.hoverObject.instance.intOut(evt, eleObj.target), 
                this.hoverObject.instance.dragData[this.scope] = null, this.hoverObject = null);
                var helperElement = this.droppables[this.scope].helper;
                this.parentClientRect = this.calculateParentPosition(this.helperElement.offsetParent);
                var tLeft = this.parentClientRect.left, tTop = this.parentClientRect.top, intCoord = this.getCoordinates(evt), pagex = intCoord.pageX, pagey = intCoord.pageY, dLeft = this.position.left - this.diffX, dTop = this.position.top - this.diffY;
                if (this.dragArea) {
                    var styles = getComputedStyle(helperElement);
                    if (this.pageX !== pagex || this.skipDistanceCheck) {
                        var helperWidth = helperElement.offsetWidth + (parseFloat(styles.marginLeft) + parseFloat(styles.marginRight));
                        left = this.dragLimit.left > dLeft ? this.dragLimit.left : this.dragLimit.right < dLeft + helperWidth ? this.dragLimit.right - helperWidth : dLeft;
                    }
                    if (this.pageY !== pagey || this.skipDistanceCheck) {
                        var helperHeight = helperElement.offsetHeight + (parseFloat(styles.marginTop) + parseFloat(styles.marginBottom));
                        top = this.dragLimit.top > dTop ? this.dragLimit.top : this.dragLimit.bottom < dTop + helperHeight ? this.dragLimit.bottom - helperHeight : dTop;
                    }
                } else left = dLeft, top = dTop;
                var iTop = tTop + this.borderWidth.top, iLeft = tLeft + this.borderWidth.left, dragValue = this.getProcessedPositionValue({
                    top: top - iTop + "px",
                    left: left - iLeft + "px"
                });
                setStyleAttribute(helperElement, {
                    left: dragValue.left,
                    top: dragValue.top
                }), this.position.left = left, this.position.top = top, this.pageX = pagex, this.pageY = pagey;
            }
        }, Draggable.prototype.getDocumentWidthHeight = function(str) {
            var docBody = document.body, docEle = document.documentElement;
            return Math.max(docBody["scroll" + str], docEle["scroll" + str], docBody["offset" + str], docEle["offset" + str], docEle["client" + str]);
        }, Draggable.prototype.intDragStop = function(evt) {
            if (isUndefined(evt.changedTouches) || 1 === evt.changedTouches.length) {
                if (-1 !== [ "touchend", "pointerup", "mouseup" ].indexOf(evt.type)) {
                    if (this.dragStop) {
                        var curTarget = this.getProperTargetElement(evt);
                        this.trigger("dragStop", {
                            event: evt,
                            element: this.element,
                            target: curTarget,
                            helper: this.helperElement
                        });
                    }
                    this.intDestroy(evt);
                } else this.element.setAttribute("aria-grabbed", "false");
                var eleObj = this.checkTargetElement(evt);
                eleObj.target && eleObj.instance && (eleObj.instance.dragStopCalled = !0, eleObj.instance.dragData[this.scope] = this.droppables[this.scope], 
                eleObj.instance.intDrop(evt, eleObj.target)), this.setGlobalDroppables(!0), document.body.classList.remove("e-prevent-select");
            }
        }, Draggable.prototype.intDestroy = function(evt) {
            this.toggleEvents(), document.body.classList.remove("e-prevent-select"), this.element.setAttribute("aria-grabbed", "false"), 
            EventHandler.remove(document, Browser.touchMoveEvent, this.intDragStart), EventHandler.remove(document, Browser.touchEndEvent, this.intDragStop), 
            EventHandler.remove(document, Browser.touchEndEvent, this.intDestroy), EventHandler.remove(document, Browser.touchMoveEvent, this.intDrag);
        }, Draggable.prototype.onPropertyChanged = function(newProp, oldProp) {}, Draggable.prototype.getModuleName = function() {
            return "draggable";
        }, Draggable.prototype.setDragArea = function() {
            var eleWidthBound, eleHeightBound, ele, top = 0, left = 0;
            if (ele = "string" === typeof this.dragArea ? select(this.dragArea) : this.dragArea) {
                var elementArea = ele.getBoundingClientRect();
                eleWidthBound = elementArea.width ? elementArea.width : elementArea.right - elementArea.left, 
                eleHeightBound = elementArea.height ? elementArea.height : elementArea.bottom - elementArea.top;
                for (var keys = [ "Top", "Left", "Bottom", "Right" ], styles = getComputedStyle(ele), i = 0; i < keys.length; i++) {
                    var key = keys[i], tborder = styles["border" + key + "Width"], tpadding = styles["padding" + key], lowerKey = key.toLowerCase();
                    this.borderWidth[lowerKey] = isNaN(parseFloat(tborder)) ? 0 : parseFloat(tborder), 
                    this.padding[lowerKey] = isNaN(parseFloat(tpadding)) ? 0 : parseFloat(tpadding);
                }
                top = elementArea.top, left = elementArea.left, this.dragLimit.left = left + this.borderWidth.left + this.padding.left, 
                this.dragLimit.top = top + this.borderWidth.top + this.padding.top, this.dragLimit.right = left + eleWidthBound - (this.borderWidth.right + this.padding.right), 
                this.dragLimit.bottom = top + eleHeightBound - (this.borderWidth.bottom + this.padding.bottom);
            }
        }, Draggable.prototype.getProperTargetElement = function(evt) {
            var ele, intCoord = this.getCoordinates(evt), prevStyle = this.helperElement.style.display || "";
            return compareElementParent(evt.target, this.helperElement) || -1 !== evt.type.indexOf("touch") ? (this.helperElement.style.display = "none", 
            ele = document.elementFromPoint(intCoord.clientX, intCoord.clientY), this.helperElement.style.display = prevStyle) : ele = evt.target, 
            ele;
        }, Draggable.prototype.getMousePosition = function(evt) {
            var intCoord = this.getCoordinates(evt), pageX = this.clone ? intCoord.pageX : intCoord.pageX - this.relativeXPosition, pageY = this.clone ? intCoord.pageY : intCoord.pageY - this.relativeYPosition;
            return {
                left: pageX - (this.margin.left + this.cursorAt.left),
                top: pageY - (this.margin.top + this.cursorAt.top)
            };
        }, Draggable.prototype.getCoordinates = function(evt) {
            return evt.type.indexOf("touch") > -1 ? evt.changedTouches[0] : evt;
        }, Draggable.prototype.getHelperElement = function(evt) {
            var element;
            return this.clone ? this.helper ? element = this.helper({
                sender: evt,
                element: this.target
            }) : (element = createElement("div", {
                className: "e-drag-helper e-block-touch",
                innerHTML: "Draggable"
            }), document.body.appendChild(element)) : element = this.element, element;
        }, Draggable.prototype.setGlobalDroppables = function(reset, drag, helper) {
            this.droppables[this.scope] = reset ? null : {
                draggable: drag,
                helper: helper,
                draggedElement: this.element
            };
        }, Draggable.prototype.checkTargetElement = function(evt) {
            var target = this.getProperTargetElement(evt), dropIns = this.getDropInstance(target);
            if (!dropIns && target && !isNullOrUndefined(target.parentNode)) {
                var parent_1 = closest(target.parentNode, ".e-droppable") || target.parentElement;
                parent_1 && (dropIns = this.getDropInstance(parent_1));
            }
            return {
                target: target,
                instance: dropIns
            };
        }, Draggable.prototype.getDropInstance = function(ele) {
            var drop, eleInst = ele && ele.ej2_instances;
            if (eleInst) for (var _i = 0, eleInst_1 = eleInst; _i < eleInst_1.length; _i++) {
                var inst = eleInst_1[_i];
                if ("droppable" === inst.getModuleName()) {
                    drop = inst;
                    break;
                }
            }
            return drop;
        }, Draggable.prototype.destroy = function() {
            this.toggleEvents(!0), _super.prototype.destroy.call(this);
        }, __decorate$2([ Complex({}, Position) ], Draggable.prototype, "cursorAt", void 0), 
        __decorate$2([ Property(!0) ], Draggable.prototype, "clone", void 0), __decorate$2([ Property() ], Draggable.prototype, "dragArea", void 0), 
        __decorate$2([ Event() ], Draggable.prototype, "drag", void 0), __decorate$2([ Event() ], Draggable.prototype, "dragStart", void 0), 
        __decorate$2([ Event() ], Draggable.prototype, "dragStop", void 0), __decorate$2([ Property(1) ], Draggable.prototype, "distance", void 0), 
        __decorate$2([ Property() ], Draggable.prototype, "handle", void 0), __decorate$2([ Property() ], Draggable.prototype, "abort", void 0), 
        __decorate$2([ Property() ], Draggable.prototype, "helper", void 0), __decorate$2([ Property("default") ], Draggable.prototype, "scope", void 0), 
        __decorate$2([ Property("") ], Draggable.prototype, "dragTarget", void 0), __decorate$2([ Property() ], Draggable.prototype, "axis", void 0), 
        __decorate$2([ Property() ], Draggable.prototype, "queryPositionInfo", void 0), 
        __decorate$2([ Property(!1) ], Draggable.prototype, "enableTailMode", void 0), __decorate$2([ Property(!1) ], Draggable.prototype, "skipDistanceCheck", void 0), 
        __decorate$2([ Property(!0) ], Draggable.prototype, "preventDefault", void 0), Draggable = Draggable_1 = __decorate$2([ NotifyPropertyChanges ], Draggable);
        var Draggable_1;
    }(Base), __extends$3 = function() {
        var extendStatics = Object.setPrototypeOf || {
            __proto__: []
        } instanceof Array && function(d, b) {
            d.__proto__ = b;
        } || function(d, b) {
            for (var p in b) b.hasOwnProperty(p) && (d[p] = b[p]);
        };
        return function(d, b) {
            function __() {
                this.constructor = d;
            }
            extendStatics(d, b), d.prototype = null === b ? Object.create(b) : (__.prototype = b.prototype, 
            new __());
        };
    }(), __decorate$3 = function(decorators, target, key, desc) {
        var d, c = arguments.length, r = c < 3 ? target : null === desc ? desc = Object.getOwnPropertyDescriptor(target, key) : desc;
        if ("object" == typeof Reflect && "function" == typeof Reflect.decorate) r = Reflect.decorate(decorators, target, key, desc); else for (var i = decorators.length - 1; i >= 0; i--) (d = decorators[i]) && (r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r);
        return c > 3 && r && Object.defineProperty(target, key, r), r;
    }, Droppable = function(_super) {
        function Droppable(element, options) {
            var _this = _super.call(this, options, element) || this;
            return _this.mouseOver = !1, _this.dragData = {}, _this.dragStopCalled = !1, _this.bind(), 
            _this;
        }
        return __extends$3(Droppable, _super), Droppable.prototype.bind = function() {
            this.wireEvents();
        }, Droppable.prototype.wireEvents = function() {
            EventHandler.add(this.element, Browser.touchEndEvent, this.intDrop, this);
        }, Droppable.prototype.onPropertyChanged = function(newProp, oldProp) {}, Droppable.prototype.getModuleName = function() {
            return "droppable";
        }, Droppable.prototype.intOver = function(event, element) {
            this.mouseOver || (this.trigger("over", {
                event: event,
                target: element
            }), this.mouseOver = !0);
        }, Droppable.prototype.intOut = function(event, element) {
            this.mouseOver && (this.trigger("out", {
                evt: event,
                target: element
            }), this.mouseOver = !1);
        }, Droppable.prototype.intDrop = function(evt, element) {
            if (this.dragStopCalled) {
                this.dragStopCalled = !1;
                var area, accept = !0, drag = this.dragData[this.scope], isDrag = !!drag && (drag.helper && isVisible(drag.helper));
                isDrag && (area = this.isDropArea(evt, drag.helper, element), this.accept && (accept = matches(drag.helper, this.accept))), 
                isDrag && this.drop && area.canDrop && accept && this.trigger("drop", {
                    event: evt,
                    target: area.target,
                    droppedElement: drag.helper,
                    dragData: drag
                });
            }
        }, Droppable.prototype.isDropArea = function(evt, helper, element) {
            var area = {
                canDrop: !0,
                target: element || evt.target
            }, isTouch = "touchend" === evt.type;
            if (isTouch || area.target === helper) {
                helper.style.display = "none";
                var coord = isTouch ? evt.changedTouches[0] : evt, ele = document.elementFromPoint(coord.clientX, coord.clientY);
                area.canDrop = !1, area.canDrop = compareElementParent(ele, this.element), area.canDrop && (area.target = ele), 
                helper.style.display = "";
            }
            return area;
        }, Droppable.prototype.destroy = function() {
            EventHandler.remove(this.element, Browser.touchEndEvent, this.intDrop), _super.prototype.destroy.call(this);
        }, __decorate$3([ Property() ], Droppable.prototype, "accept", void 0), __decorate$3([ Property("default") ], Droppable.prototype, "scope", void 0), 
        __decorate$3([ Event() ], Droppable.prototype, "drop", void 0), __decorate$3([ Event() ], Droppable.prototype, "over", void 0), 
        __decorate$3([ Event() ], Droppable.prototype, "out", void 0), Droppable = __decorate$3([ NotifyPropertyChanges ], Droppable);
    }(Base), __extends$4 = function() {
        var extendStatics = Object.setPrototypeOf || {
            __proto__: []
        } instanceof Array && function(d, b) {
            d.__proto__ = b;
        } || function(d, b) {
            for (var p in b) b.hasOwnProperty(p) && (d[p] = b[p]);
        };
        return function(d, b) {
            function __() {
                this.constructor = d;
            }
            extendStatics(d, b), d.prototype = null === b ? Object.create(b) : (__.prototype = b.prototype, 
            new __());
        };
    }(), __decorate$4 = function(decorators, target, key, desc) {
        var d, c = arguments.length, r = c < 3 ? target : null === desc ? desc = Object.getOwnPropertyDescriptor(target, key) : desc;
        if ("object" == typeof Reflect && "function" == typeof Reflect.decorate) r = Reflect.decorate(decorators, target, key, desc); else for (var i = decorators.length - 1; i >= 0; i--) (d = decorators[i]) && (r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r);
        return c > 3 && r && Object.defineProperty(target, key, r), r;
    }, keyCode = {
        backspace: 8,
        tab: 9,
        enter: 13,
        shift: 16,
        control: 17,
        alt: 18,
        pause: 19,
        capslock: 20,
        space: 32,
        escape: 27,
        pageup: 33,
        pagedown: 34,
        end: 35,
        home: 36,
        leftarrow: 37,
        uparrow: 38,
        rightarrow: 39,
        downarrow: 40,
        insert: 45,
        delete: 46,
        f1: 112,
        f2: 113,
        f3: 114,
        f4: 115,
        f5: 116,
        f6: 117,
        f7: 118,
        f8: 119,
        f9: 120,
        f10: 121,
        f11: 122,
        f12: 123,
        semicolon: 186,
        plus: 187,
        comma: 188,
        minus: 189,
        dot: 190,
        forwardslash: 191,
        graveaccent: 192,
        openbracket: 219,
        backslash: 220,
        closebracket: 221,
        singlequote: 222
    }, KeyboardEvents = function(_super) {
        function KeyboardEvents(element, options) {
            var _this = _super.call(this, options, element) || this;
            return _this.keyPressHandler = function(e) {
                for (var isAltKey = e.altKey, isCtrlKey = e.ctrlKey, isShiftKey = e.shiftKey, curkeyCode = e.which, _i = 0, keys_1 = Object.keys(_this.keyConfigs); _i < keys_1.length; _i++) for (var key = keys_1[_i], _a = 0, configCollection_1 = _this.keyConfigs[key].split(","); _a < configCollection_1.length; _a++) {
                    var rconfig = configCollection_1[_a], rKeyObj = KeyboardEvents_1.getKeyConfigData(rconfig.trim());
                    isAltKey === rKeyObj.altKey && isCtrlKey === rKeyObj.ctrlKey && isShiftKey === rKeyObj.shiftKey && curkeyCode === rKeyObj.keyCode && (e.action = key, 
                    _this.keyAction && _this.keyAction(e));
                }
            }, _this.bind(), _this;
        }
        return __extends$4(KeyboardEvents, _super), KeyboardEvents_1 = KeyboardEvents, KeyboardEvents.prototype.destroy = function() {
            this.unwireEvents(), _super.prototype.destroy.call(this);
        }, KeyboardEvents.prototype.onPropertyChanged = function(newProp, oldProp) {}, KeyboardEvents.prototype.bind = function() {
            this.wireEvents();
        }, KeyboardEvents.prototype.getModuleName = function() {
            return "keyboard";
        }, KeyboardEvents.prototype.wireEvents = function() {
            this.element.addEventListener(this.eventName, this.keyPressHandler);
        }, KeyboardEvents.prototype.unwireEvents = function() {
            this.element.removeEventListener(this.eventName, this.keyPressHandler);
        }, KeyboardEvents.getKeyConfigData = function(config) {
            if (config in this.configCache) return this.configCache[config];
            var keys = config.toLowerCase().split("+"), keyData = {
                altKey: -1 !== keys.indexOf("alt"),
                ctrlKey: -1 !== keys.indexOf("ctrl"),
                shiftKey: -1 !== keys.indexOf("shift"),
                keyCode: null
            };
            return keys[keys.length - 1].length > 1 && Number(keys[keys.length - 1]) ? keyData.keyCode = Number(keys[keys.length - 1]) : keyData.keyCode = KeyboardEvents_1.getKeyCode(keys[keys.length - 1]), 
            KeyboardEvents_1.configCache[config] = keyData, keyData;
        }, KeyboardEvents.getKeyCode = function(keyVal) {
            return keyCode[keyVal] || keyVal.toUpperCase().charCodeAt(0);
        }, KeyboardEvents.configCache = {}, __decorate$4([ Property({}) ], KeyboardEvents.prototype, "keyConfigs", void 0), 
        __decorate$4([ Property("keyup") ], KeyboardEvents.prototype, "eventName", void 0), 
        __decorate$4([ Event() ], KeyboardEvents.prototype, "keyAction", void 0), KeyboardEvents = KeyboardEvents_1 = __decorate$4([ NotifyPropertyChanges ], KeyboardEvents);
        var KeyboardEvents_1;
    }(Base), L10n = function() {
        function L10n(controlName, localeStrings, locale) {
            this.controlName = controlName, this.localeStrings = localeStrings, this.setLocale(locale || defaultCulture);
        }
        return L10n.prototype.setLocale = function(locale) {
            var intLocale = this.intGetControlConstant(L10n.locale, locale);
            this.currentLocale = intLocale || this.localeStrings;
        }, L10n.load = function(localeObject) {
            this.locale = extend(this.locale, localeObject, {}, !0);
        }, L10n.prototype.getConstant = function(prop) {
            return this.currentLocale[prop] || this.localeStrings[prop] || "";
        }, L10n.prototype.intGetControlConstant = function(curObject, locale) {
            return curObject[locale] ? curObject[locale][this.controlName] : null;
        }, L10n.locale = {}, L10n;
    }(), SvgRenderer = function() {
        function SvgRenderer(rootID) {
            this.svgLink = "http://www.w3.org/2000/svg", this.rootId = rootID;
        }
        return SvgRenderer.prototype.getOptionValue = function(options, key) {
            return options[key];
        }, SvgRenderer.prototype.createSvg = function(options) {
            return isNullOrUndefined(options.id) && (options.id = this.rootId + "_svg"), this.svgObj = document.getElementById(options.id), 
            isNullOrUndefined(document.getElementById(options.id)) && (this.svgObj = document.createElementNS(this.svgLink, "svg")), 
            this.svgObj = this.setElementAttributes(options, this.svgObj), this.setSVGSize(options.width, options.height), 
            this.svgObj;
        }, SvgRenderer.prototype.setSVGSize = function(width, height) {
            var element = document.getElementById(this.rootId), size = isNullOrUndefined(element) ? null : element.getBoundingClientRect();
            isNullOrUndefined(this.width) || this.width <= 0 ? this.svgObj.setAttribute("width", width ? width.toString() : size.width.toString()) : this.svgObj.setAttribute("width", this.width.toString()), 
            isNullOrUndefined(this.height) || this.height <= 0 ? this.svgObj.setAttribute("height", height ? height.toString() : "450") : this.svgObj.setAttribute("height", this.height.toString());
        }, SvgRenderer.prototype.drawPath = function(options) {
            var path = document.getElementById(options.id);
            return null === path && (path = document.createElementNS(this.svgLink, "path")), 
            path = this.setElementAttributes(options, path);
        }, SvgRenderer.prototype.drawLine = function(options) {
            var line = document.getElementById(options.id);
            return null === line && (line = document.createElementNS(this.svgLink, "line")), 
            line = this.setElementAttributes(options, line);
        }, SvgRenderer.prototype.drawRectangle = function(options) {
            var rectangle = document.getElementById(options.id);
            return null === rectangle && (rectangle = document.createElementNS(this.svgLink, "rect")), 
            rectangle = this.setElementAttributes(options, rectangle);
        }, SvgRenderer.prototype.drawCircle = function(options) {
            var circle = document.getElementById(options.id);
            return null === circle && (circle = document.createElementNS(this.svgLink, "circle")), 
            circle = this.setElementAttributes(options, circle);
        }, SvgRenderer.prototype.drawPolyline = function(options) {
            var polyline = document.getElementById(options.id);
            return null === polyline && (polyline = document.createElementNS(this.svgLink, "polyline")), 
            polyline = this.setElementAttributes(options, polyline);
        }, SvgRenderer.prototype.drawEllipse = function(options) {
            var ellipse = document.getElementById(options.id);
            return null === ellipse && (ellipse = document.createElementNS(this.svgLink, "ellipse")), 
            ellipse = this.setElementAttributes(options, ellipse);
        }, SvgRenderer.prototype.drawPolygon = function(options) {
            var polygon = document.getElementById(options.id);
            return null === polygon && (polygon = document.createElementNS(this.svgLink, "polygon")), 
            polygon = this.setElementAttributes(options, polygon);
        }, SvgRenderer.prototype.drawImage = function(options) {
            var img = document.createElementNS(this.svgLink, "image");
            return img.setAttributeNS(null, "height", options.height.toString()), img.setAttributeNS(null, "width", options.width.toString()), 
            img.setAttributeNS("http://www.w3.org/1999/xlink", "href", options.href), img.setAttributeNS(null, "x", options.x.toString()), 
            img.setAttributeNS(null, "y", options.y.toString()), img.setAttributeNS(null, "id", options.id), 
            img.setAttributeNS(null, "visibility", options.visibility), isNullOrUndefined(this.getOptionValue(options, "clip-path")) || img.setAttributeNS(null, "clip-path", this.getOptionValue(options, "clip-path")), 
            isNullOrUndefined(options.preserveAspectRatio) || img.setAttributeNS(null, "preserveAspectRatio", options.preserveAspectRatio), 
            img;
        }, SvgRenderer.prototype.createText = function(options, label) {
            var text = document.createElementNS(this.svgLink, "text");
            return text = this.setElementAttributes(options, text), isNullOrUndefined(label) || (text.textContent = label), 
            text;
        }, SvgRenderer.prototype.createTSpan = function(options, label) {
            var tSpan = document.createElementNS(this.svgLink, "tspan");
            return tSpan = this.setElementAttributes(options, tSpan), isNullOrUndefined(label) || (tSpan.textContent = label), 
            tSpan;
        }, SvgRenderer.prototype.createTitle = function(text) {
            var title = document.createElementNS(this.svgLink, "title");
            return title.textContent = text, title;
        }, SvgRenderer.prototype.createDefs = function() {
            return document.createElementNS(this.svgLink, "defs");
        }, SvgRenderer.prototype.createClipPath = function(options) {
            var clipPath = document.createElementNS(this.svgLink, "clipPath");
            return clipPath = this.setElementAttributes(options, clipPath);
        }, SvgRenderer.prototype.createForeignObject = function(options) {
            var foreignObject = document.createElementNS(this.svgLink, "foreignObject");
            return foreignObject = this.setElementAttributes(options, foreignObject);
        }, SvgRenderer.prototype.createGroup = function(options) {
            var group = document.createElementNS(this.svgLink, "g");
            return group = this.setElementAttributes(options, group);
        }, SvgRenderer.prototype.createPattern = function(options, element) {
            var pattern = document.createElementNS(this.svgLink, element);
            return pattern = this.setElementAttributes(options, pattern);
        }, SvgRenderer.prototype.createRadialGradient = function(colors, name, options) {
            var colorName;
            if (isNullOrUndefined(colors[0].colorStop)) colorName = colors[0].color.toString(); else {
                var newOptions = {
                    id: this.rootId + "_" + name + "radialGradient",
                    cx: options.cx + "%",
                    cy: options.cy + "%",
                    r: options.r + "%",
                    fx: options.fx + "%",
                    fy: options.fy + "%"
                };
                this.drawGradient("radialGradient", newOptions, colors), colorName = "url(#" + this.rootId + "_" + name + "radialGradient)";
            }
            return colorName;
        }, SvgRenderer.prototype.createLinearGradient = function(colors, name, options) {
            var colorName;
            if (isNullOrUndefined(colors[0].colorStop)) colorName = colors[0].color.toString(); else {
                var newOptions = {
                    id: this.rootId + "_" + name + "linearGradient",
                    x1: options.x1 + "%",
                    y1: options.y1 + "%",
                    x2: options.x2 + "%",
                    y2: options.y2 + "%"
                };
                this.drawGradient("linearGradient", newOptions, colors), colorName = "url(#" + this.rootId + "_" + name + "linearGradient)";
            }
            return colorName;
        }, SvgRenderer.prototype.drawGradient = function(gradientType, options, colors) {
            var defs = this.createDefs(), gradient = document.createElementNS(this.svgLink, gradientType);
            gradient = this.setElementAttributes(options, gradient);
            for (var i = 0; i < colors.length; i++) {
                var stop_1 = document.createElementNS(this.svgLink, "stop");
                stop_1.setAttribute("offset", colors[i].colorStop), stop_1.setAttribute("stop-color", colors[i].color), 
                stop_1.setAttribute("stop-opacity", "1"), gradient.appendChild(stop_1);
            }
            return defs.appendChild(gradient), defs;
        }, SvgRenderer.prototype.drawClipPath = function(options) {
            var defs = this.createDefs(), clipPath = this.createClipPath({
                id: options.id
            }), rect = this.drawRectangle(options);
            return clipPath.appendChild(rect), defs.appendChild(clipPath), defs;
        }, SvgRenderer.prototype.drawCircularClipPath = function(options) {
            var defs = this.createDefs(), clipPath = this.createClipPath({
                id: options.id
            }), circle = this.drawCircle(options);
            return clipPath.appendChild(circle), defs.appendChild(clipPath), defs;
        }, SvgRenderer.prototype.setElementAttributes = function(options, element) {
            for (var keys = Object.keys(options), i = 0; i < keys.length; i++) element.setAttribute(keys[i], options[keys[i]]);
            return element;
        }, SvgRenderer;
    }(), __extends$5 = function() {
        var extendStatics = Object.setPrototypeOf || {
            __proto__: []
        } instanceof Array && function(d, b) {
            d.__proto__ = b;
        } || function(d, b) {
            for (var p in b) b.hasOwnProperty(p) && (d[p] = b[p]);
        };
        return function(d, b) {
            function __() {
                this.constructor = d;
            }
            extendStatics(d, b), d.prototype = null === b ? Object.create(b) : (__.prototype = b.prototype, 
            new __());
        };
    }(), __decorate$5 = function(decorators, target, key, desc) {
        var d, c = arguments.length, r = c < 3 ? target : null === desc ? desc = Object.getOwnPropertyDescriptor(target, key) : desc;
        if ("object" == typeof Reflect && "function" == typeof Reflect.decorate) r = Reflect.decorate(decorators, target, key, desc); else for (var i = decorators.length - 1; i >= 0; i--) (d = decorators[i]) && (r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r);
        return c > 3 && r && Object.defineProperty(target, key, r), r;
    }, SwipeSettings = function(_super) {
        function SwipeSettings() {
            return null !== _super && _super.apply(this, arguments) || this;
        }
        return __extends$5(SwipeSettings, _super), __decorate$5([ Property(50) ], SwipeSettings.prototype, "swipeThresholdDistance", void 0), 
        SwipeSettings;
    }(ChildProperty), swipeRegex = /(Up|Down)/, Touch = function(_super) {
        function Touch(element, options) {
            var _this = _super.call(this, options, element) || this;
            return _this.touchAction = !0, _this.tapCount = 0, _this.startEvent = function(evt) {
                if (!0 === _this.touchAction) {
                    var point = evt.changedTouches ? evt.changedTouches[0] : evt;
                    void 0 !== evt.changedTouches && (_this.touchAction = !1), _this.isTouchMoved = !1, 
                    _this.movedDirection = "", _this.startPoint = _this.lastMovedPoint = {
                        clientX: point.clientX,
                        clientY: point.clientY
                    }, _this.startEventData = point, _this.hScrollLocked = _this.vScrollLocked = !1, 
                    _this.tStampStart = Date.now(), _this.timeOutTapHold = setTimeout(function() {
                        _this.tapHoldEvent(evt);
                    }, _this.tapHoldThreshold), EventHandler.add(_this.element, Browser.touchMoveEvent, _this.moveEvent, _this), 
                    EventHandler.add(_this.element, Browser.touchEndEvent, _this.endEvent, _this);
                }
            }, _this.moveEvent = function(evt) {
                var point = evt.changedTouches ? evt.changedTouches[0] : evt;
                _this.movedPoint = point, _this.isTouchMoved = !(point.clientX === _this.startPoint.clientX && point.clientY === _this.startPoint.clientY);
                var eScrollArgs = {};
                if (_this.isTouchMoved) {
                    clearTimeout(_this.timeOutTapHold), _this.calcScrollPoints(evt);
                    eScrollArgs = extend(eScrollArgs, {}, {
                        startEvents: _this.startEventData,
                        originalEvent: evt,
                        startX: _this.startPoint.clientX,
                        startY: _this.startPoint.clientY,
                        distanceX: _this.distanceX,
                        distanceY: _this.distanceY,
                        scrollDirection: _this.scrollDirection,
                        velocity: _this.getVelocity(point)
                    }), _this.trigger("scroll", eScrollArgs), _this.lastMovedPoint = {
                        clientX: point.clientX,
                        clientY: point.clientY
                    };
                }
            }, _this.endEvent = function(evt) {
                clearTimeout(_this.timeOutTapHold), clearTimeout(_this.timeOutTap);
                var point = evt;
                evt.changedTouches && (point = evt.changedTouches[0]);
                var diffX = point.clientX - _this.startPoint.clientX, diffY = point.clientY - _this.startPoint.clientY;
                diffX = Math.floor(diffX < 0 ? -1 * diffX : diffX), diffY = Math.floor(diffY < 0 ? -1 * diffY : diffX), 
                _this.isTouchMoved = diffX > 1 || diffY > 1, _this.endPoint = point;
                var eSwipeArgs, tDistance = _this.swipeSettings.swipeThresholdDistance;
                _this.calcPoints(evt);
                var swipeArgs = {
                    originalEvent: evt,
                    startEvents: _this.startEventData,
                    startX: _this.startPoint.clientX,
                    startY: _this.startPoint.clientY,
                    distanceX: _this.distanceX,
                    distanceY: _this.distanceY,
                    swipeDirection: _this.movedDirection,
                    velocity: _this.getVelocity(point)
                };
                if (_this.isTouchMoved) {
                    eSwipeArgs = extend(eSwipeArgs, _this.defaultArgs, swipeArgs);
                    var canTrigger = !1, ele = _this.element, scrollBool = _this.isScrollable(ele), moved = swipeRegex.test(_this.movedDirection);
                    (tDistance < _this.distanceX && !moved || tDistance < _this.distanceY && moved) && (canTrigger = !scrollBool || _this.checkSwipe(ele, moved)), 
                    canTrigger && _this.trigger("swipe", eSwipeArgs);
                } else "function" == typeof _this.tap && (_this.trigger("tap", {
                    originalEvent: evt,
                    tapCount: ++_this.tapCount
                }), _this.timeOutTap = setTimeout(function() {
                    _this.tapCount = 0;
                }, _this.tapThreshold));
                _this.modeClear = setTimeout(function() {
                    _this.touchAction = !0;
                }, "function" != typeof _this.tap ? 0 : 10), _this.lastTapTime = new Date().getTime(), 
                EventHandler.remove(_this.element, Browser.touchMoveEvent, _this.moveEvent), EventHandler.remove(_this.element, Browser.touchEndEvent, _this.endEvent);
            }, _this.bind(), _this;
        }
        return __extends$5(Touch, _super), Touch.prototype.onPropertyChanged = function(newProp, oldProp) {}, 
        Touch.prototype.bind = function() {
            this.wireEvents(), Browser.isIE && this.element.classList.add("e-block-touch");
        }, Touch.prototype.destroy = function() {
            this.unwireEvents(), _super.prototype.destroy.call(this);
        }, Touch.prototype.wireEvents = function() {
            EventHandler.add(this.element, Browser.touchStartEvent, this.startEvent, this);
        }, Touch.prototype.unwireEvents = function() {
            EventHandler.remove(this.element, Browser.touchStartEvent, this.startEvent);
        }, Touch.prototype.getModuleName = function() {
            return "touch";
        }, Touch.prototype.isScrollable = function(element) {
            var eleStyle = getComputedStyle(element), style = eleStyle.overflow + eleStyle.overflowX + eleStyle.overflowY;
            return !!/(auto|scroll)/.test(style);
        }, Touch.prototype.tapHoldEvent = function(evt) {
            this.tapCount = 0, this.touchAction = !0;
            var eTapArgs;
            EventHandler.remove(this.element, Browser.touchMoveEvent, this.moveEvent), EventHandler.remove(this.element, Browser.touchEndEvent, this.endEvent), 
            eTapArgs = {
                originalEvent: evt
            }, this.trigger("tapHold", eTapArgs);
        }, Touch.prototype.calcPoints = function(evt) {
            var point = evt.changedTouches ? evt.changedTouches[0] : evt;
            this.defaultArgs = {
                originalEvent: evt
            }, this.distanceX = Math.abs(Math.abs(point.clientX) - Math.abs(this.startPoint.clientX)), 
            this.distanceY = Math.abs(Math.abs(point.clientY) - Math.abs(this.startPoint.clientY)), 
            this.distanceX > this.distanceY ? this.movedDirection = point.clientX > this.startPoint.clientX ? "Right" : "Left" : this.movedDirection = point.clientY < this.startPoint.clientY ? "Up" : "Down";
        }, Touch.prototype.calcScrollPoints = function(evt) {
            var point = evt.changedTouches ? evt.changedTouches[0] : evt;
            this.defaultArgs = {
                originalEvent: evt
            }, this.distanceX = Math.abs(Math.abs(point.clientX) - Math.abs(this.lastMovedPoint.clientX)), 
            this.distanceY = Math.abs(Math.abs(point.clientY) - Math.abs(this.lastMovedPoint.clientY)), 
            (this.distanceX > this.distanceY || !0 === this.hScrollLocked) && !1 === this.vScrollLocked ? (this.scrollDirection = point.clientX > this.lastMovedPoint.clientX ? "Right" : "Left", 
            this.hScrollLocked = !0) : (this.scrollDirection = point.clientY < this.lastMovedPoint.clientY ? "Up" : "Down", 
            this.vScrollLocked = !0);
        }, Touch.prototype.getVelocity = function(pnt) {
            var newX = pnt.clientX, newY = pnt.clientY, newT = Date.now(), xDist = newX - this.startPoint.clientX, yDist = newY - this.startPoint.clientX, interval = newT - this.tStampStart;
            return Math.sqrt(xDist * xDist + yDist * yDist) / interval;
        }, Touch.prototype.checkSwipe = function(ele, flag) {
            var keys = [ "scroll", "offset" ], temp = flag ? [ "Height", "Top" ] : [ "Width", "Left" ];
            return ele[keys[0] + temp[0]] <= ele[keys[1] + temp[0]] || (0 === ele[keys[0] + temp[1]] || ele[keys[1] + temp[0]] + ele[keys[0] + temp[1]] >= ele[keys[0] + temp[0]]);
        }, __decorate$5([ Event() ], Touch.prototype, "tap", void 0), __decorate$5([ Event() ], Touch.prototype, "tapHold", void 0), 
        __decorate$5([ Event() ], Touch.prototype, "swipe", void 0), __decorate$5([ Event() ], Touch.prototype, "scroll", void 0), 
        __decorate$5([ Property(350) ], Touch.prototype, "tapThreshold", void 0), __decorate$5([ Property(750) ], Touch.prototype, "tapHoldThreshold", void 0), 
        __decorate$5([ Complex({}, SwipeSettings) ], Touch.prototype, "swipeSettings", void 0), 
        Touch = __decorate$5([ NotifyPropertyChanges ], Touch);
    }(Base), LINES = new RegExp("\\n|\\r|\\s\\s+", "g"), QUOTES = new RegExp(/'|"/g), IF_STMT = new RegExp("if ?\\("), ELSE_STMT = new RegExp("else"), FOR_STMT = new RegExp("for ?\\("), IF_OR_FOR = new RegExp("(/if|/for)"), CALL_FUNCTION = new RegExp("\\((.*)\\)", ""), NOT_NUMBER = new RegExp("^[0-9]+$", "g"), WORD = new RegExp("[\\w\"'.\\s+]+", "g"), DBL_QUOTED_STR = new RegExp('"(.*?)"', "g"), exp = new RegExp("\\${([^}]*)}", "g"), HAS_ROW = /^[\n\r.]+\<tr|^\<tr/, engineObj = {
        compile: new (function() {
            function Engine() {}
            return Engine.prototype.compile = function(templateString, helper) {
                return void 0 === helper && (helper = {}), compile$1(templateString, helper);
            }, Engine;
        }())().compile
    }, _base = Object.freeze({
        Ajax: Ajax,
        Animation: Animation,
        rippleEffect: rippleEffect,
        get isRippleEnabled() {
            return isRippleEnabled;
        },
        enableRipple: function(isRipple) {
            return isRippleEnabled = isRipple;
        },
        Base: Base,
        Browser: Browser,
        CanvasRenderer: CanvasRenderer,
        Component: Component,
        ChildProperty: ChildProperty,
        Position: Position,
        Draggable: Draggable,
        Droppable: Droppable,
        EventHandler: EventHandler,
        onIntlChange: onIntlChange,
        get rightToLeft() {
            return rightToLeft;
        },
        cldrData: cldrData,
        get defaultCulture() {
            return defaultCulture;
        },
        get defaultCurrencyCode() {
            return defaultCurrencyCode;
        },
        Internationalization: Internationalization,
        setCulture: setCulture,
        setCurrencyCode: function(currencyCode) {
            defaultCurrencyCode = currencyCode, onIntlChange.notify("notifyExternalChange", {
                currencyCode: defaultCurrencyCode
            });
        },
        loadCldr: function() {
            for (var data = [], _i = 0; _i < arguments.length; _i++) data[_i] = arguments[_i];
            for (var _a = 0, data_1 = data; _a < data_1.length; _a++) {
                var obj = data_1[_a];
                extend(cldrData, obj, {}, !0);
            }
        },
        enableRtl: function(status) {
            void 0 === status && (status = !0), rightToLeft = status, onIntlChange.notify("notifyExternalChange", {
                enableRtl: rightToLeft
            });
        },
        getNumericObject: getNumericObject,
        getDefaultDateObject: getDefaultDateObject,
        KeyboardEvents: KeyboardEvents,
        L10n: L10n,
        ModuleLoader: ModuleLoader,
        Property: Property,
        Complex: Complex,
        ComplexFactory: function(type) {
            return function(target, key) {
                var propertyDescriptor = {
                    set: function(defaultValue, curKey, type) {
                        return function(newValue) {
                            var curType = type(newValue);
                            getObject(this, curKey, defaultValue, curType).setProperties(newValue);
                        };
                    }({}, key, type),
                    get: function(defaultValue, curKey, type) {
                        return function() {
                            var curType = type({});
                            return getObject(this, curKey, defaultValue, curType);
                        };
                    }({}, key, type),
                    enumerable: !0,
                    configurable: !0
                };
                Object.defineProperty(target, key, propertyDescriptor), addPropertyCollection(target, key, "complexProp", {}, type);
            };
        },
        Collection: Collection,
        CollectionFactory: function(type) {
            return function(target, key) {
                var propertyDescriptor = {
                    set: function(defaultValue, curKey, type) {
                        return function(newValue) {
                            var oldValueCollection = getObjectArray(this, curKey, defaultValue, type, !1, !0), newValCollection = getObjectArray(this, curKey, newValue, type, !0, !0);
                            this.saveChanges(curKey, newValCollection, oldValueCollection), this.properties[curKey] = newValCollection;
                        };
                    }([], key, type),
                    get: function(defaultValue, curKey, type) {
                        return function() {
                            var curType = type({});
                            if (!this.properties.hasOwnProperty(curKey)) {
                                var defCollection = getObjectArray(this, curKey, defaultValue, curType, !1);
                                this.properties[curKey] = defCollection;
                            }
                            return this.properties[curKey];
                        };
                    }([], key, type),
                    enumerable: !0,
                    configurable: !0
                };
                Object.defineProperty(target, key, propertyDescriptor), addPropertyCollection(target, key, "colProp", {}, type);
            };
        },
        Event: Event,
        NotifyPropertyChanges: NotifyPropertyChanges,
        CreateBuilder: function(component) {
            var builderFunction = function(element) {
                return this.element = element, this;
            };
            return function(element) {
                return builderFunction.prototype.hasOwnProperty("create") || ((builderFunction.prototype = getBuilderProperties(component)).create = function() {
                    var temp = extend({}, {}, this.properties);
                    return this.properties = {}, new component(temp, this.element);
                }), new builderFunction(element);
            };
        },
        SvgRenderer: SvgRenderer,
        SwipeSettings: SwipeSettings,
        Touch: Touch,
        compile: compile$$1,
        setTemplateEngine: function(classObj) {
            engineObj.compile = classObj.compile;
        },
        getTemplateEngine: function() {
            return engineObj.compile;
        },
        createInstance: createInstance,
        setImmediate: setImmediate,
        getValue: getValue,
        setValue: setValue,
        deleteObject: deleteObject,
        isObject: isObject,
        getEnumValue: getEnumValue,
        merge: merge,
        extend: extend,
        isNullOrUndefined: isNullOrUndefined,
        isUndefined: isUndefined,
        getUniqueID: getUniqueID,
        debounce: debounce,
        queryParams: function(data) {
            for (var array = [], _i = 0, keys_2 = Object.keys(data); _i < keys_2.length; _i++) {
                var key = keys_2[_i];
                array.push(encodeURIComponent(key) + "=" + encodeURIComponent("" + data[key]));
            }
            return array.join("&");
        },
        isObjectArray: function(value) {
            var parser = Object.prototype.toString;
            return "[object Array]" === parser.call(value) && "[object Object]" === parser.call(value[0]);
        },
        compareElementParent: compareElementParent,
        throwError: throwError,
        print: print,
        formatUnit: formatUnit,
        getInstance: getInstance,
        addInstance: function(element, instance) {
            var elem = "string" == typeof element ? document.querySelector(element) : element;
            elem[instances] ? elem[instances].push(instance) : elem[instances] = [ instance ];
        },
        uniqueID: uniqueID,
        createElement: createElement,
        addClass: addClass,
        removeClass: removeClass,
        isVisible: isVisible,
        prepend: prepend,
        append: append,
        detach: detach,
        remove: remove,
        attributes: attributes,
        select: select,
        selectAll: selectAll,
        closest: closest,
        siblings: function(element) {
            for (var siblings = [], _i = 0, childNodes_1 = Array.prototype.slice.call(element.parentNode.childNodes); _i < childNodes_1.length; _i++) {
                var curNode = childNodes_1[_i];
                curNode.nodeType === Node.ELEMENT_NODE && element !== curNode && siblings.push(curNode);
            }
            return siblings;
        },
        getAttributeOrDefault: function(element, property, value) {
            var attrVal = element.getAttribute(property);
            return isNullOrUndefined(attrVal) && (element.setAttribute(property, value.toString()), 
            attrVal = value), attrVal;
        },
        setStyleAttribute: setStyleAttribute,
        classList: classList,
        matches: matches
    }), __extends = function() {
        var extendStatics = Object.setPrototypeOf || {
            __proto__: []
        } instanceof Array && function(d, b) {
            d.__proto__ = b;
        } || function(d, b) {
            for (var p in b) b.hasOwnProperty(p) && (d[p] = b[p]);
        };
        return function(d, b) {
            function __() {
                this.constructor = d;
            }
            extendStatics(d, b), d.prototype = null === b ? Object.create(b) : (__.prototype = b.prototype, 
            new __());
        };
    }(), __decorate = function(decorators, target, key, desc) {
        var d, c = arguments.length, r = c < 3 ? target : null === desc ? desc = Object.getOwnPropertyDescriptor(target, key) : desc;
        if ("object" == typeof Reflect && "function" == typeof Reflect.decorate) r = Reflect.decorate(decorators, target, key, desc); else for (var i = decorators.length - 1; i >= 0; i--) (d = decorators[i]) && (r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r);
        return c > 3 && r && Object.defineProperty(target, key, r), r;
    }, CLS_ITEM = "e-acrdn-item", CLS_HEADER = "e-acrdn-header", CLS_CONTENT = "e-acrdn-panel", AccordionActionSettings = function(_super) {
        function AccordionActionSettings() {
            return null !== _super && _super.apply(this, arguments) || this;
        }
        return __extends(AccordionActionSettings, _super), __decorate([ Property("SlideDown") ], AccordionActionSettings.prototype, "effect", void 0), 
        __decorate([ Property(400) ], AccordionActionSettings.prototype, "duration", void 0), 
        __decorate([ Property("linear") ], AccordionActionSettings.prototype, "easing", void 0), 
        AccordionActionSettings;
    }(ChildProperty), AccordionAnimationSettings = function(_super) {
        function AccordionAnimationSettings() {
            return null !== _super && _super.apply(this, arguments) || this;
        }
        return __extends(AccordionAnimationSettings, _super), __decorate([ Complex({
            effect: "SlideUp",
            duration: 400,
            easing: "linear"
        }, AccordionActionSettings) ], AccordionAnimationSettings.prototype, "collapse", void 0), 
        __decorate([ Complex({
            effect: "SlideDown",
            duration: 400,
            easing: "linear"
        }, AccordionActionSettings) ], AccordionAnimationSettings.prototype, "expand", void 0), 
        AccordionAnimationSettings;
    }(ChildProperty), AccordionItem = function(_super) {
        function AccordionItem() {
            return null !== _super && _super.apply(this, arguments) || this;
        }
        return __extends(AccordionItem, _super), __decorate([ Property(void 0) ], AccordionItem.prototype, "content", void 0), 
        __decorate([ Property(void 0) ], AccordionItem.prototype, "header", void 0), __decorate([ Property(void 0) ], AccordionItem.prototype, "cssClass", void 0), 
        __decorate([ Property(void 0) ], AccordionItem.prototype, "iconCss", void 0), __decorate([ Property(!1) ], AccordionItem.prototype, "expanded", void 0), 
        AccordionItem;
    }(ChildProperty), Accordion = function(_super) {
        function Accordion(options, element) {
            var _this = _super.call(this, options, element) || this;
            return _this.keyConfigs = {
                moveUp: "uparrow",
                moveDown: "downarrow",
                enter: "enter",
                space: "space",
                home: "home",
                end: "end"
            }, _this;
        }
        return __extends(Accordion, _super), Accordion.prototype.destroy = function() {
            var _this = this, ele = this.element;
            for (_super.prototype.destroy.call(this), this.unwireEvents(), this.isDestroy = !0, 
            this.templateEle.forEach(function(eleStr) {
                document.body.appendChild(_this.element.querySelector(eleStr)).style.display = "none";
            }); ele.firstChild; ) ele.removeChild(ele.firstChild);
            if (this.trgtEle) for (;this.ctrlTem.firstChild; ) ele.appendChild(this.ctrlTem.firstChild);
            ele.removeAttribute("style"), [ "aria-disabled", "aria-multiselectable", "role" ].forEach(function(attrb) {
                _this.element.removeAttribute(attrb);
            });
        }, Accordion.prototype.preRender = function() {
            var nested = closest(this.element, "." + CLS_CONTENT);
            this.isNested = !1, this.templateEle = [], this.isDestroy || (this.isDestroy = !1), 
            isNullOrUndefined(nested) ? this.element.classList.add("e-acrdn-root") : (nested.classList.add("e-nested"), 
            this.isNested = !0), this.enableRtl && this.add(this.element, "e-rtl"), this.enablePersistence && !isNullOrUndefined(this.expandedItems) || (this.expandedItems = []);
        }, Accordion.prototype.add = function(ele, val) {
            ele.classList.add(val);
        }, Accordion.prototype.remove = function(ele, val) {
            ele.classList.remove(val);
        }, Accordion.prototype.render = function() {
            this.initialize(), this.renderControl(), this.wireEvents();
        }, Accordion.prototype.initialize = function() {
            var width = formatUnit(this.width), height = formatUnit(this.height);
            setStyleAttribute(this.element, {
                width: width,
                height: height
            });
            this.expandedItems.length > 0 && (this.initExpand = this.expandedItems), attributes(this.element, {
                "aria-disabled": "false",
                role: "presentation",
                "aria-multiselectable": "true"
            }), "Single" === this.expandMode && this.element.setAttribute("aria-multiselectable", "false");
        }, Accordion.prototype.renderControl = function() {
            this.trgtEle = this.element.children.length > 0 ? select("div", this.element) : null, 
            this.renderItems(), this.initItemExpand();
        }, Accordion.prototype.unwireEvents = function() {
            EventHandler.remove(this.element, "click", this.clickHandler), isNullOrUndefined(this.keyModule) || this.keyModule.destroy();
        }, Accordion.prototype.wireEvents = function() {
            EventHandler.add(this.element, "click", this.clickHandler, this), this.isNested || this.isDestroy || rippleEffect(this.element, {
                selector: "." + CLS_HEADER
            }), this.isNested || (this.keyModule = new KeyboardEvents(this.element, {
                keyAction: this.keyActionHandler.bind(this),
                keyConfigs: this.keyConfigs,
                eventName: "keydown"
            }));
        }, Accordion.prototype.focusIn = function(e) {
            e.target.parentElement.classList.add("e-item-focus");
        }, Accordion.prototype.focusOut = function(e) {
            e.target.parentElement.classList.remove("e-item-focus");
        }, Accordion.prototype.ctrlTemplate = function() {
            var _this = this;
            this.ctrlTem = this.element.cloneNode(!0);
            var content, innerEles = this.element.children;
            addClass(innerEles, [ CLS_ITEM ]), [].slice.call(innerEles).forEach(function(el) {
                if (el.id = getUniqueID("acrdn_item"), el.children.length > 0) {
                    _this.add(el.children[0], CLS_HEADER);
                    var header = el.children[0];
                    attributes(header, {
                        tabindex: "0",
                        role: "heading",
                        "aria-level": innerEles.length.toString()
                    }), header.id = getUniqueID("acrdn_header"), EventHandler.add(header, "focus", _this.focusIn, _this), 
                    EventHandler.add(header, "blur", _this.focusOut, _this);
                    var headerEle = header.firstElementChild;
                    headerEle && headerEle.classList.add("e-acrdn-header-content"), (content = el.children[1]) && (content.id = getUniqueID("acrdn_panel"), 
                    header.setAttribute("aria-controls", content.id), content.style.display = "", el.classList.add("e-select"), 
                    el.children[0].appendChild(_this.toggleIconGenerate()), classList(content, [ CLS_CONTENT, "e-content-hide" ], []), 
                    attributes(content, {
                        "aria-labelledby": header.id,
                        "aria-hidden": "true"
                    }), (content = content.firstElementChild) && (content.classList.add("e-acrdn-content"), 
                    content.style.display = ""));
                }
            });
        }, Accordion.prototype.toggleIconGenerate = function() {
            var tglIcon = createElement("div", {
                className: "e-toggle-icon"
            }), hdrColIcon = createElement("span", {
                className: "e-tgl-collapse-icon e-icons"
            });
            return tglIcon.appendChild(hdrColIcon), tglIcon;
        }, Accordion.prototype.initItemExpand = function() {
            var len = this.initExpand.length;
            if (0 !== len) if ("Single" === this.expandMode) this.expandItem(!0, this.initExpand[len - 1]); else for (var i = 0; i < len; i++) this.expandItem(!0, this.initExpand[i]);
        }, Accordion.prototype.renderItems = function() {
            var innerItem, _this = this, ele = this.element;
            isNullOrUndefined(this.initExpand) && (this.initExpand = []);
            var items = this.items;
            isNullOrUndefined(this.trgtEle) ? ele && items.length > 0 && items.forEach(function(item, index) {
                innerItem = _this.renderInnerItem(item, index), ele.appendChild(innerItem), innerItem.childElementCount > 0 && (EventHandler.add(innerItem.querySelector("." + CLS_HEADER), "focus", _this.focusIn, _this), 
                EventHandler.add(innerItem.querySelector("." + CLS_HEADER), "blur", _this.focusOut, _this));
            }) : this.ctrlTemplate();
        }, Accordion.prototype.clickHandler = function(e) {
            var index, tglIcon, _this = this, trgt = e.target, eventArgs = {};
            if (closest(trgt, ".e-accordion") === this.element) {
                trgt.classList.add("e-target");
                var acrdnItem = closest(trgt, "." + CLS_ITEM), acrdnHdr = closest(trgt, "." + CLS_HEADER), acrdnCtn = closest(trgt, "." + CLS_CONTENT);
                acrdnItem && (isNullOrUndefined(acrdnHdr) || isNullOrUndefined(acrdnCtn)) && (acrdnHdr = acrdnItem.children[0], 
                acrdnCtn = acrdnItem.children[1]), acrdnHdr && (tglIcon = select(".e-toggle-icon", acrdnHdr));
                var acrdnCtnItem;
                acrdnCtn && (acrdnCtnItem = closest(acrdnCtn, "." + CLS_ITEM));
                var acrdActive = [];
                index = this.getIndexByItem(acrdnItem), acrdnCtnItem && (eventArgs.item = this.items[this.getIndexByItem(acrdnCtnItem)]), 
                eventArgs.originalEvent = e;
                !(!isNullOrUndefined(tglIcon) && isNullOrUndefined(this.trgtEle) && acrdnItem.childElementCount <= 1) || !isNullOrUndefined(acrdnCtn) && isNullOrUndefined(select(".e-acrdn-header .e-toggle-icon", acrdnCtnItem)) || (acrdnItem.appendChild(this.contentRendering(index)), 
                this.ariaAttrUpdate(acrdnItem)), this.trigger("clicked", eventArgs);
                var cntclkCheck = acrdnCtn && !isNullOrUndefined(select(".e-target", acrdnCtn));
                if (cntclkCheck = cntclkCheck && (isNullOrUndefined(select(".e-accordion", acrdnCtn)) || !(closest(trgt, ".e-accordion") === this.element)), 
                trgt.classList.remove("e-target"), !(trgt.classList.contains(CLS_CONTENT) || trgt.classList.contains("e-acrdn-content") || cntclkCheck)) {
                    [].slice.call(this.element.children).forEach(function(el) {
                        el.classList.contains("e-active") && acrdActive.push(el);
                    });
                    var acrdAniEle = [].slice.call(this.element.querySelectorAll(".e-acrdn-item [e-animate]"));
                    if (acrdAniEle.length > 0) for (var _i = 0, acrdAniEle_1 = acrdAniEle; _i < acrdAniEle_1.length; _i++) {
                        var el = acrdAniEle_1[_i];
                        acrdActive.push(el.parentElement);
                    }
                    var sameContentCheck = -1 !== acrdActive.indexOf(acrdnCtnItem) && "true" === acrdnCtn.getAttribute("e-animate"), sameHeader = !1;
                    if (!isNullOrUndefined(acrdnItem) && !isNullOrUndefined(acrdnHdr)) {
                        var acrdnCtn_1 = select("." + CLS_CONTENT, acrdnItem), expandState = closest(acrdnItem, ".e-acrdn-root").querySelector(".e-expand-state");
                        if (isNullOrUndefined(acrdnCtn_1)) return;
                        sameHeader = expandState === acrdnItem, !isVisible(acrdnCtn_1) || sameContentCheck && !acrdnCtnItem.classList.contains("e-selected") ? (acrdActive.length > 0 && "Single" === this.expandMode && !sameContentCheck && acrdActive.forEach(function(el) {
                            _this.collapse(select("." + CLS_CONTENT, el)), el.classList.remove("e-expand-state");
                        }), this.expand(acrdnCtn_1)) : this.collapse(acrdnCtn_1), isNullOrUndefined(expandState) || sameHeader || expandState.classList.remove("e-expand-state");
                    }
                }
            }
        }, Accordion.prototype.eleMoveFocus = function(action, root, trgt) {
            var clst, clstItem = closest(trgt, "." + CLS_ITEM);
            trgt === root ? clst = ("moveUp" === action ? trgt.lastElementChild : trgt).querySelector("." + CLS_HEADER) : trgt.classList.contains(CLS_HEADER) && (clstItem = "moveUp" === action ? clstItem.previousElementSibling : clstItem.nextElementSibling) && (clst = select("." + CLS_HEADER, clstItem)), 
            clst && clst.focus();
        }, Accordion.prototype.keyActionHandler = function(e) {
            var trgt = e.target;
            if ("INPUT" !== trgt.tagName) {
                e.preventDefault();
                var content, root = this.element;
                switch (e.action) {
                  case "moveUp":
                  case "moveDown":
                    this.eleMoveFocus(e.action, root, trgt);
                    break;

                  case "space":
                  case "enter":
                    !isNullOrUndefined(content = trgt.nextElementSibling) && content.classList.contains(CLS_CONTENT) ? "true" !== content.getAttribute("e-animate") && trgt.click() : trgt.click();
                    break;

                  case "home":
                  case "end":
                    ("home" === e.action ? root.firstElementChild.children[0] : root.lastElementChild.children[0]).focus();
                }
            }
        }, Accordion.prototype.headerEleGenerate = function() {
            var header = createElement("div", {
                className: CLS_HEADER,
                id: getUniqueID("acrdn_header")
            });
            return attributes(header, {
                tabindex: "0",
                role: "heading",
                "aria-expanded": "false",
                "aria-selected": "false",
                "aria-disabled": "false",
                "aria-level": this.items.length.toString()
            }), header;
        }, Accordion.prototype.renderInnerItem = function(item, index) {
            var innerEle;
            if (innerEle = createElement("div", {
                className: CLS_ITEM
            }), innerEle.id = getUniqueID("acrdn_item"), item.header) {
                var ctnEle = this.headerEleGenerate(), hdrEle = createElement("div", {
                    className: "e-acrdn-header-content"
                });
                ctnEle.appendChild(hdrEle), ctnEle.appendChild(this.fetchElement(hdrEle, item.header, index, !0)), 
                innerEle.appendChild(ctnEle);
            }
            var hdr = select("." + CLS_HEADER, innerEle);
            if (!item.expanded || isNullOrUndefined(index) || this.enablePersistence || -1 === this.initExpand.indexOf(index) && this.initExpand.push(index), 
            item.cssClass && innerEle.classList.add(item.cssClass), item.iconCss) {
                var hdrIcnEle = createElement("div", {
                    className: "e-acrdn-header-icon"
                }), icon = createElement("span", {
                    className: item.iconCss + " e-icons"
                });
                hdrIcnEle.appendChild(icon), isNullOrUndefined(hdr) ? ((hdr = this.headerEleGenerate()).appendChild(hdrIcnEle), 
                innerEle.appendChild(hdr)) : hdr.insertBefore(hdrIcnEle, hdr.childNodes[0]);
            }
            if (item.content) {
                var hdrIcon = this.toggleIconGenerate();
                isNullOrUndefined(hdr) && (hdr = this.headerEleGenerate(), innerEle.appendChild(hdr)), 
                hdr.appendChild(hdrIcon), this.add(innerEle, "e-select");
            }
            return innerEle;
        }, Accordion.prototype.fetchElement = function(ele, value, index, isHeader) {
            var templateFn, temString;
            try {
                if (document.querySelectorAll(value).length) {
                    var eleVal = document.querySelector(value);
                    temString = eleVal.outerHTML.trim(), ele.appendChild(eleVal), eleVal.style.display = "";
                }
            } catch (e) {
                templateFn = compile$$1(value);
            }
            return isNullOrUndefined(templateFn) || !(templateFn().length > 0) || isNullOrUndefined(templateFn()[0].tagName) && 1 === templateFn().length ? 0 === ele.childElementCount && (ele.innerHTML = value) : [].slice.call(templateFn()).forEach(function(el) {
                isNullOrUndefined(el.tagName) || (el.style.display = ""), ele.appendChild(el);
            }), isNullOrUndefined(temString) || this.templateEle.push(value), ele;
        }, Accordion.prototype.ariaAttrUpdate = function(itemEle) {
            var header = select("." + CLS_HEADER, itemEle), content = select("." + CLS_CONTENT, itemEle);
            header.setAttribute("aria-controls", content.id), content.setAttribute("aria-labelledby", header.id);
        }, Accordion.prototype.contentRendering = function(index) {
            var content = this.items[index].content, itemcnt = createElement("div", {
                className: CLS_CONTENT + " e-content-hide",
                id: getUniqueID("acrdn_panel")
            });
            attributes(itemcnt, {
                "aria-hidden": "true"
            });
            var ctn = createElement("div", {
                className: "e-acrdn-content"
            });
            return itemcnt.appendChild(this.fetchElement(ctn, content, index, !1)), itemcnt;
        }, Accordion.prototype.expand = function(trgt) {
            var eventArgs, trgtItemEle = closest(trgt, "." + CLS_ITEM);
            if (!(isNullOrUndefined(trgt) || isVisible(trgt) && "true" !== trgt.getAttribute("e-animate") || trgtItemEle.classList.contains("e-overlay"))) {
                var expandState = closest(trgtItemEle, ".e-acrdn-root").querySelector(".e-expand-state"), animation = {
                    name: this.animation.expand.effect,
                    duration: this.animation.expand.duration,
                    timingFunction: this.animation.expand.easing
                }, icon = select(".e-toggle-icon", trgtItemEle).firstElementChild;
                eventArgs = {
                    element: trgtItemEle,
                    item: this.items[this.getIndexByItem(trgtItemEle)],
                    isExpanded: !0
                };
                var eff = animation.name;
                if (this.trigger("expanding", eventArgs), !eventArgs.cancel) {
                    if (icon.classList.add("e-toggle-animation"), this.expandedItemsPush(trgtItemEle), 
                    isNullOrUndefined(expandState) || expandState.classList.remove("e-expand-state"), 
                    trgtItemEle.classList.add("e-expand-state"), "None" === animation.name) return this.expandProgress("begin", icon, trgt, trgtItemEle, eventArgs), 
                    void this.expandProgress("end", icon, trgt, trgtItemEle, eventArgs);
                    this.expandAnimation(eff, icon, trgt, trgtItemEle, animation, eventArgs);
                }
            }
        }, Accordion.prototype.expandAnimation = function(ef, icn, trgt, trgtItemEle, animate, args) {
            var height, _this = this;
            "SlideDown" === ef ? (animate.begin = function() {
                _this.expandProgress("begin", icn, trgt, trgtItemEle, args), trgt.style.position = "absolute", 
                height = trgtItemEle.offsetHeight, trgt.offsetHeight, trgt.style.maxHeight = trgt.offsetHeight + "px", 
                trgtItemEle.style.maxHeight = "";
            }, animate.progress = function() {
                trgtItemEle.style.minHeight = height + trgt.offsetHeight + "px";
            }, animate.end = function() {
                setStyleAttribute(trgt, {
                    position: "",
                    maxHeight: ""
                }), trgtItemEle.style.minHeight = "", _this.expandProgress("end", icn, trgt, trgtItemEle, args);
            }) : (animate.begin = function() {
                _this.expandProgress("begin", icn, trgt, trgtItemEle, args);
            }, animate.end = function() {
                _this.expandProgress("end", icn, trgt, trgtItemEle, args);
            }), new Animation(animate).animate(trgt);
        }, Accordion.prototype.expandProgress = function(progress, icon, trgt, trgtItemEle, eventArgs) {
            this.remove(trgt, "e-content-hide"), this.add(trgtItemEle, "e-selected"), this.add(icon, "e-expand-icon"), 
            "end" === progress && (this.add(trgtItemEle, "e-active"), trgt.setAttribute("aria-hidden", "false"), 
            attributes(trgt.previousElementSibling, {
                "aria-selected": "true",
                "aria-expanded": "true"
            }), icon.classList.remove("e-toggle-animation"), this.trigger("expanded", eventArgs));
        }, Accordion.prototype.expandedItemsPush = function(item) {
            var index = this.getIndexByItem(item);
            -1 === this.expandedItems.indexOf(index) && this.expandedItems.push(index);
        }, Accordion.prototype.getIndexByItem = function(item) {
            return [].slice.call(this.element.children).indexOf(item);
        }, Accordion.prototype.expandedItemsPop = function(item) {
            var index = this.getIndexByItem(item);
            this.expandedItems.splice(this.expandedItems.indexOf(index), 1);
        }, Accordion.prototype.collapse = function(trgt) {
            var eventArgs, trgtItemEle = closest(trgt, "." + CLS_ITEM);
            if (!isNullOrUndefined(trgt) && isVisible(trgt) && !trgtItemEle.classList.contains("e-overlay")) {
                var animation = {
                    name: this.animation.collapse.effect,
                    duration: this.animation.collapse.duration,
                    timingFunction: this.animation.collapse.easing
                }, icon = select(".e-toggle-icon", trgtItemEle).firstElementChild;
                eventArgs = {
                    element: trgtItemEle,
                    item: this.items[this.getIndexByItem(trgtItemEle)],
                    isExpanded: !1
                };
                var eff = animation.name;
                if (this.trigger("expanding", eventArgs), !eventArgs.cancel) {
                    if (this.expandedItemsPop(trgtItemEle), trgtItemEle.classList.add("e-expand-state"), 
                    icon.classList.add("e-toggle-animation"), "None" === animation.name) return this.collapseProgress("begin", icon, trgt, trgtItemEle, eventArgs), 
                    void this.collapseProgress("end", icon, trgt, trgtItemEle, eventArgs);
                    this.collapseAnimation(eff, trgt, trgtItemEle, icon, animation, eventArgs);
                }
            }
        }, Accordion.prototype.collapseAnimation = function(ef, trgt, trgtItEl, icn, animate, args) {
            var height, trgtHeight, itemHeight, remain, _this = this;
            "SlideUp" === ef ? (animate.begin = function() {
                itemHeight = trgtItEl.offsetHeight, trgtItEl.style.minHeight = itemHeight + "px", 
                trgt.style.position = "absolute", height = trgtItEl.offsetHeight, trgtHeight = trgt.offsetHeight, 
                trgt.style.maxHeight = trgtHeight + "px", _this.collapseProgress("begin", icn, trgt, trgtItEl, args);
            }, animate.progress = function() {
                (remain = height - (trgtHeight - trgt.offsetHeight)) < itemHeight && (trgtItEl.style.minHeight = remain + "px");
            }, animate.end = function() {
                trgt.style.display = "none", _this.collapseProgress("end", icn, trgt, trgtItEl, args), 
                trgtItEl.style.minHeight = "", setStyleAttribute(trgt, {
                    position: "",
                    maxHeight: "",
                    display: ""
                });
            }) : (animate.begin = function() {
                _this.collapseProgress("begin", icn, trgt, trgtItEl, args);
            }, animate.end = function() {
                _this.collapseProgress("end", icn, trgt, trgtItEl, args);
            }), new Animation(animate).animate(trgt);
        }, Accordion.prototype.collapseProgress = function(progress, icon, trgt, trgtItemEle, eventArgs) {
            this.remove(icon, "e-expand-icon"), this.remove(trgtItemEle, "e-selected"), "end" === progress && (this.add(trgt, "e-content-hide"), 
            icon.classList.remove("e-toggle-animation"), this.remove(trgtItemEle, "e-active"), 
            trgt.setAttribute("aria-hidden", "true"), attributes(trgt.previousElementSibling, {
                "aria-selected": "false",
                "aria-expanded": "false"
            }), this.trigger("expanded", eventArgs));
        }, Accordion.prototype.getModuleName = function() {
            return "accordion";
        }, Accordion.prototype.itemAttribUpdate = function() {
            var itemEle = [].slice.call(this.element.children), itemLen = this.items.length;
            itemEle.forEach(function(ele) {
                select("." + CLS_HEADER, ele).setAttribute("aria-level", "" + itemLen);
            });
        }, Accordion.prototype.addItem = function(item, index) {
            var ele = this.element;
            if (isNullOrUndefined(index) && (index = this.items.length), ele.childElementCount >= index) {
                this.items.splice(index, 0, item);
                var innerItemEle = this.renderInnerItem(item, index);
                ele.childElementCount === index ? ele.appendChild(innerItemEle) : ele.insertBefore(innerItemEle, ele.children[index]), 
                EventHandler.add(innerItemEle.querySelector("." + CLS_HEADER), "focus", this.focusIn, this), 
                EventHandler.add(innerItemEle.querySelector("." + CLS_HEADER), "blur", this.focusOut, this), 
                this.itemAttribUpdate();
            }
            this.expandedItems = [], this.expandedItemRefresh(ele), item.expanded && this.expandItem(!0, index);
        }, Accordion.prototype.expandedItemRefresh = function(ele) {
            var _this = this;
            [].slice.call(ele.children).forEach(function(el) {
                el.classList.contains("e-selected") && _this.expandedItemsPush(el);
            });
        }, Accordion.prototype.removeItem = function(index) {
            var ele = this.element.children[index];
            isNullOrUndefined(ele) || (detach(ele), this.items.splice(index, 1), this.itemAttribUpdate(), 
            this.expandedItems = [], this.expandedItemRefresh(this.element));
        }, Accordion.prototype.select = function(index) {
            var ele = this.element.children[index];
            isNullOrUndefined(ele) || isNullOrUndefined(select("." + CLS_HEADER, ele)) || ele.children[0].focus();
        }, Accordion.prototype.hideItem = function(index, isHidden) {
            var ele = this.element.children[index];
            isNullOrUndefined(ele) || (isNullOrUndefined(isHidden) && (isHidden = !0), isHidden ? this.add(ele, "e-hide") : this.remove(ele, "e-hide"));
        }, Accordion.prototype.enableItem = function(index, isEnable) {
            var ele = this.element.children[index];
            if (!isNullOrUndefined(ele)) {
                var eleHeader = ele.firstElementChild;
                isEnable ? (this.remove(ele, "e-overlay"), attributes(eleHeader, {
                    tabindex: "0",
                    "aria-disabled": "false"
                }), eleHeader.focus()) : (ele.classList.contains("e-active") && (this.expandItem(!1, index), 
                this.eleMoveFocus("movedown", this.element, eleHeader)), this.add(ele, "e-overlay"), 
                eleHeader.setAttribute("aria-disabled", "true"), eleHeader.removeAttribute("tabindex"));
            }
        }, Accordion.prototype.expandItem = function(isExpand, index) {
            var _this = this, root = this.element;
            if (isNullOrUndefined(index)) if ("Single" === this.expandMode && isExpand) {
                var ele = root.children[root.childElementCount - 1];
                this.itemExpand(isExpand, ele, this.getIndexByItem(ele));
            } else [].slice.call(this.element.children).forEach(function(el) {
                _this.itemExpand(isExpand, el, _this.getIndexByItem(el));
            }); else {
                if (isNullOrUndefined(ele = this.element.children[index]) || !ele.classList.contains("e-select") || ele.classList.contains("e-active") && isExpand) return;
                "Single" === this.expandMode && this.expandItem(!1), this.itemExpand(isExpand, ele, index);
            }
        }, Accordion.prototype.itemExpand = function(isExpand, ele, index) {
            var ctn = ele.children[1];
            if (!ele.classList.contains("e-overlay")) {
                if (isNullOrUndefined(ctn) && isExpand) ctn = this.contentRendering(index), ele.appendChild(ctn), 
                this.ariaAttrUpdate(ele); else if (isNullOrUndefined(ctn)) return;
                isExpand ? this.expand(ctn) : this.collapse(ctn);
            }
        }, Accordion.prototype.destroyItems = function() {
            [].slice.call(this.element.querySelectorAll("." + CLS_ITEM)).forEach(function(el) {
                detach(el);
            });
        }, Accordion.prototype.updateItem = function(item, index) {
            if (!isNullOrUndefined(item)) {
                var itemObj = this.items[index];
                this.items.splice(index, 1), detach(item), this.addItem(itemObj, index);
            }
        }, Accordion.prototype.getPersistData = function() {
            return this.addOnPersist([ "expandedItems" ]);
        }, Accordion.prototype.onPropertyChanged = function(newProp, oldProp) {
            for (var acrdn = this.element, _i = 0, _a = Object.keys(newProp); _i < _a.length; _i++) {
                switch (_a[_i]) {
                  case "items":
                    if (newProp.items instanceof Array && oldProp.items instanceof Array) this.destroyItems(), 
                    this.renderItems(), this.initItemExpand(); else for (var changedProp = Object.keys(newProp.items), i = 0; i < changedProp.length; i++) {
                        var index = parseInt(Object.keys(newProp.items)[i], 10), property = Object.keys(newProp.items[index])[0], oldVal = Object(oldProp.items[index])[property], newVal = Object(newProp.items[index])[property], item = selectAll("." + CLS_ITEM, this.element)[index];
                        "header" !== property && "iconCss" !== property && "expanded" !== property || this.updateItem(item, index), 
                        "cssClass" !== property || isNullOrUndefined(item) || (item.classList.remove(oldVal), 
                        item.classList.add(newVal)), "content" !== property || isNullOrUndefined(item) || 2 !== item.children.length || (item.classList.contains("e-selected") && this.expandItem(!1, index), 
                        detach(item.querySelector("." + CLS_CONTENT)));
                    }
                    break;

                  case "enableRtl":
                    newProp.enableRtl ? this.add(acrdn, "e-rtl") : this.remove(acrdn, "e-rtl");
                    break;

                  case "height":
                    setStyleAttribute(this.element, {
                        height: formatUnit(newProp.height)
                    });
                    break;

                  case "width":
                    setStyleAttribute(this.element, {
                        width: formatUnit(newProp.width)
                    });
                    break;

                  case "expandMode":
                    "Single" === newProp.expandMode ? (this.element.setAttribute("aria-multiselectable", "false"), 
                    this.expandedItems.length > 1 && this.expandItem(!1)) : this.element.setAttribute("aria-multiselectable", "true");
                }
            }
        }, __decorate([ Collection([], AccordionItem) ], Accordion.prototype, "items", void 0), 
        __decorate([ Property("100%") ], Accordion.prototype, "width", void 0), __decorate([ Property("auto") ], Accordion.prototype, "height", void 0), 
        __decorate([ Property("Multiple") ], Accordion.prototype, "expandMode", void 0), 
        __decorate([ Complex({}, AccordionAnimationSettings) ], Accordion.prototype, "animation", void 0), 
        __decorate([ Event() ], Accordion.prototype, "clicked", void 0), __decorate([ Event() ], Accordion.prototype, "expanding", void 0), 
        __decorate([ Event() ], Accordion.prototype, "expanded", void 0), __decorate([ Event() ], Accordion.prototype, "created", void 0), 
        __decorate([ Event() ], Accordion.prototype, "destroyed", void 0), Accordion = __decorate([ NotifyPropertyChanges ], Accordion);
    }(Component), __extends$5$1 = function() {
        var extendStatics = Object.setPrototypeOf || {
            __proto__: []
        } instanceof Array && function(d, b) {
            d.__proto__ = b;
        } || function(d, b) {
            for (var p in b) b.hasOwnProperty(p) && (d[p] = b[p]);
        };
        return function(d, b) {
            function __() {
                this.constructor = d;
            }
            extendStatics(d, b), d.prototype = null === b ? Object.create(b) : (__.prototype = b.prototype, 
            new __());
        };
    }(), __decorate$5$1 = function(decorators, target, key, desc) {
        var d, c = arguments.length, r = c < 3 ? target : null === desc ? desc = Object.getOwnPropertyDescriptor(target, key) : desc;
        if ("object" == typeof Reflect && "function" == typeof Reflect.decorate) r = Reflect.decorate(decorators, target, key, desc); else for (var i = decorators.length - 1; i >= 0; i--) (d = decorators[i]) && (r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r);
        return c > 3 && r && Object.defineProperty(target, key, r), r;
    }, cssClassName_RTL = "e-rtl", cssClassName_BUTTON = "e-btn", cssClassName_PRIMARY = "e-primary", cssClassName_ICONBTN = "e-icon-btn", Button = function(_super) {
        function Button(options, element) {
            return _super.call(this, options, element) || this;
        }
        return __extends$5$1(Button, _super), Button.prototype.preRender = function() {}, 
        Button.prototype.render = function() {
            this.initialize();
        }, Button.prototype.initialize = function() {
            this.cssClass && addClass([ this.element ], this.cssClass.split(" ")), this.isPrimary && this.element.classList.add(cssClassName_PRIMARY), 
            this.content && (this.element.innerHTML = this.content), this.setIconCss(), this.enableRtl && this.element.classList.add(cssClassName_RTL), 
            this.disabled ? this.controlStatus(this.disabled) : this.wireEvents(), rippleEffect(this.element, {
                selector: "." + cssClassName_BUTTON
            });
        }, Button.prototype.controlStatus = function(disabled) {
            this.element.disabled = disabled;
        }, Button.prototype.setIconCss = function() {
            if (this.iconCss) {
                var span = createElement("span", {
                    className: "e-btn-icon " + this.iconCss
                });
                this.element.textContent.trim() ? span.classList.add("e-icon-" + this.iconPosition.toLowerCase()) : this.element.classList.add(cssClassName_ICONBTN);
                var node = this.element.childNodes[0];
                node && "Left" === this.iconPosition ? this.element.insertBefore(span, node) : this.element.appendChild(span);
            }
        }, Button.prototype.wireEvents = function() {
            this.isToggle && EventHandler.add(this.element, "click", this.btnClickHandler, this);
        }, Button.prototype.unWireEvents = function() {
            this.isToggle && EventHandler.remove(this.element, "click", this.btnClickHandler);
        }, Button.prototype.btnClickHandler = function() {
            this.element.classList.contains("e-active") ? this.element.classList.remove("e-active") : this.element.classList.add("e-active");
        }, Button.prototype.destroy = function() {
            var span, element = this.element;
            _super.prototype.destroy.call(this), removeClass([ this.element ], [ cssClassName_PRIMARY, cssClassName_RTL, cssClassName_ICONBTN, "e-success", "e-info", "e-danger", "e-warning", "e-flat", "e-outline", "e-small", "e-bigger", "e-active", "e-round" ]), 
            [ "e-ripple", "disabled" ].forEach(function(value) {
                element.removeAttribute(value);
            }), this.content && (element.innerHTML = element.innerHTML.replace(this.content, "")), 
            (span = element.querySelector("span.e-btn-icon")) && detach(span), this.unWireEvents();
        }, Button.prototype.getModuleName = function() {
            return "btn";
        }, Button.prototype.getPersistData = function() {
            return this.addOnPersist([]);
        }, Button.prototype.onPropertyChanged = function(newProp, oldProp) {
            for (var _i = 0, _a = Object.keys(newProp); _i < _a.length; _i++) {
                switch (_a[_i]) {
                  case "isPrimary":
                    newProp.isPrimary ? this.element.classList.add(cssClassName_PRIMARY) : this.element.classList.remove(cssClassName_PRIMARY);
                    break;

                  case "disabled":
                    this.controlStatus(newProp.disabled), this.unWireEvents();
                    break;

                  case "iconCss":
                    var span = this.element.querySelector("span.e-btn-icon");
                    span ? (span.className = "e-btn-icon " + newProp.iconCss, this.element.textContent.trim() && ("Left" === this.iconPosition ? span.classList.add("e-icon-left") : span.classList.add("e-icon-right"))) : this.setIconCss();
                    break;

                  case "iconPosition":
                    (span = this.element.querySelector("span.e-btn-icon")) && detach(span), this.setIconCss();
                    break;

                  case "cssClass":
                    oldProp.cssClass && removeClass([ this.element ], oldProp.cssClass.split(" ")), 
                    addClass([ this.element ], newProp.cssClass.split(" "));
                    break;

                  case "enableRtl":
                    newProp.enableRtl ? this.element.classList.add(cssClassName_RTL) : this.element.classList.remove(cssClassName_RTL);
                    break;

                  case "content":
                    getTextNode(this.element) || this.element.classList.remove(cssClassName_ICONBTN), 
                    this.element.innerHTML = newProp.content, this.setIconCss();
                    break;

                  case "isToggle":
                    newProp.isToggle ? EventHandler.add(this.element, "click", this.btnClickHandler, this) : (EventHandler.remove(this.element, "click", this.btnClickHandler), 
                    removeClass([ this.element ], [ "e-active" ]));
                }
            }
        }, __decorate$5$1([ Property("Left") ], Button.prototype, "iconPosition", void 0), 
        __decorate$5$1([ Property("") ], Button.prototype, "iconCss", void 0), __decorate$5$1([ Property(!1) ], Button.prototype, "disabled", void 0), 
        __decorate$5$1([ Property(!1) ], Button.prototype, "isPrimary", void 0), __decorate$5$1([ Property("") ], Button.prototype, "cssClass", void 0), 
        __decorate$5$1([ Property("") ], Button.prototype, "content", void 0), __decorate$5$1([ Property(!1) ], Button.prototype, "isToggle", void 0), 
        Button = __decorate$5$1([ NotifyPropertyChanges ], Button);
    }(Component), __extends$1$3 = function() {
        var extendStatics = Object.setPrototypeOf || {
            __proto__: []
        } instanceof Array && function(d, b) {
            d.__proto__ = b;
        } || function(d, b) {
            for (var p in b) b.hasOwnProperty(p) && (d[p] = b[p]);
        };
        return function(d, b) {
            function __() {
                this.constructor = d;
            }
            extendStatics(d, b), d.prototype = null === b ? Object.create(b) : (__.prototype = b.prototype, 
            new __());
        };
    }(), __decorate$1$3 = function(decorators, target, key, desc) {
        var d, c = arguments.length, r = c < 3 ? target : null === desc ? desc = Object.getOwnPropertyDescriptor(target, key) : desc;
        if ("object" == typeof Reflect && "function" == typeof Reflect.decorate) r = Reflect.decorate(decorators, target, key, desc); else for (var i = decorators.length - 1; i >= 0; i--) (d = decorators[i]) && (r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r);
        return c > 3 && r && Object.defineProperty(target, key, r), r;
    }, RIPPLE = "e-ripple-container", WRAPPER = "e-checkbox-wrapper", CheckBox = function(_super) {
        function CheckBox(options, element) {
            var _this = _super.call(this, options, element) || this;
            return _this.isKeyPressed = !1, _this;
        }
        return __extends$1$3(CheckBox, _super), CheckBox.prototype.changeState = function(state) {
            var ariaState, rippleSpan, frameSpan = this.getWrapper().getElementsByClassName("e-frame")[0];
            isRippleEnabled && (rippleSpan = this.getWrapper().getElementsByClassName(RIPPLE)[0]), 
            "check" === state ? (frameSpan.classList.remove("e-stop"), frameSpan.classList.add("e-check"), 
            rippleSpan && (rippleSpan.classList.remove("e-ripple-stop"), rippleSpan.classList.add("e-ripple-check")), 
            ariaState = "true", this.element.checked = !0) : "uncheck" === state ? (removeClass([ frameSpan ], [ "e-check", "e-stop" ]), 
            rippleSpan && removeClass([ rippleSpan ], [ "e-ripple-check", "e-ripple-stop" ]), 
            ariaState = "false", this.element.checked = !1) : (frameSpan.classList.remove("e-check"), 
            frameSpan.classList.add("e-stop"), rippleSpan && (rippleSpan.classList.remove("e-ripple-check"), 
            rippleSpan.classList.add("e-ripple-stop")), ariaState = "mixed", this.element.indeterminate = !0), 
            this.getWrapper().setAttribute("aria-checked", ariaState);
        }, CheckBox.prototype.clickHandler = function(event) {
            this.focusOutHandler(), this.indeterminate ? (this.changeState(this.checked ? "check" : "uncheck"), 
            this.indeterminate = !1, this.element.indeterminate = !1) : this.checked ? (this.changeState("uncheck"), 
            this.checked = !1) : (this.changeState("check"), this.checked = !0);
            var changeEventArgs = {
                checked: this.element.checked,
                event: event
            };
            this.trigger("change", changeEventArgs);
        }, CheckBox.prototype.destroy = function() {
            var _this = this, wrapper = this.getWrapper();
            _super.prototype.destroy.call(this), this.disabled || this.unWireEvents(), "INPUT" === this.tagName ? (wrapper.parentNode.insertBefore(this.element, wrapper), 
            detach(wrapper), this.element.checked = !1, this.indeterminate && (this.element.indeterminate = !1), 
            [ "name", "value", "disabled" ].forEach(function(key) {
                _this.element.removeAttribute(key);
            })) : ([ "role", "aria-checked", "class" ].forEach(function(key) {
                wrapper.removeAttribute(key);
            }), this.element.id && wrapper.setAttribute("id", this.element.id), wrapper.innerHTML = "");
        }, CheckBox.prototype.focusHandler = function() {
            this.isKeyPressed && this.getWrapper().classList.add("e-focus");
        }, CheckBox.prototype.focusOutHandler = function() {
            this.getWrapper().classList.remove("e-focus");
        }, CheckBox.prototype.getModuleName = function() {
            return "checkbox";
        }, CheckBox.prototype.getPersistData = function() {
            return this.addOnPersist([ "checked", "indeterminate" ]);
        }, CheckBox.prototype.getWrapper = function() {
            return this.element.parentElement.parentElement;
        }, CheckBox.prototype.initialize = function() {
            this.name && this.element.setAttribute("name", this.name), this.value && this.element.setAttribute("value", this.value), 
            this.checked && this.changeState("check"), this.indeterminate && this.changeState(), 
            this.disabled && this.setDisabled();
        }, CheckBox.prototype.initWrapper = function() {
            var wrapper = this.element.parentElement;
            wrapper.classList.contains(WRAPPER) || (wrapper = createElement("div", {
                className: WRAPPER,
                attrs: {
                    role: "checkbox",
                    "aria-checked": "false"
                }
            }), this.element.parentNode.insertBefore(wrapper, this.element));
            var label = createElement("label", {
                attrs: {
                    for: this.element.id
                }
            }), frameSpan = createElement("span", {
                className: "e-icons e-frame"
            });
            if (this.enableRtl && wrapper.classList.add("e-rtl"), this.cssClass && addClass([ wrapper ], this.cssClass.split(" ")), 
            wrapper.appendChild(label), label.appendChild(this.element), label.appendChild(frameSpan), 
            isRippleEnabled) {
                var rippleSpan = createElement("span", {
                    className: RIPPLE
                });
                "Before" === this.labelPosition ? label.appendChild(rippleSpan) : label.insertBefore(rippleSpan, frameSpan), 
                rippleEffect(rippleSpan, {
                    duration: 400,
                    isCenterRipple: !0
                });
            }
            this.label && this.setText(this.label);
        }, CheckBox.prototype.keyDownHandler = function() {
            this.isKeyPressed = !0;
        }, CheckBox.prototype.labelMouseHandler = function(e) {
            rippleMouseHandler(e, this.getWrapper().getElementsByClassName(RIPPLE)[0]);
        }, CheckBox.prototype.mouseDownHandler = function() {
            this.isKeyPressed = !1;
        }, CheckBox.prototype.onPropertyChanged = function(newProp, oldProp) {
            for (var wrapper = this.getWrapper(), _i = 0, _a = Object.keys(newProp); _i < _a.length; _i++) {
                switch (_a[_i]) {
                  case "checked":
                    this.indeterminate = !1, this.element.indeterminate = !1, this.changeState(newProp.checked ? "check" : "uncheck");
                    break;

                  case "indeterminate":
                    newProp.indeterminate ? this.changeState() : (this.element.indeterminate = !1, this.changeState(this.checked ? "check" : "uncheck"));
                    break;

                  case "disabled":
                    newProp.disabled ? (this.setDisabled(), this.unWireEvents()) : (this.element.disabled = !1, 
                    wrapper.classList.remove("e-checkbox-disabled"), wrapper.setAttribute("aria-disabled", "false"), 
                    this.wireEvents());
                    break;

                  case "cssClass":
                    oldProp.cssClass && wrapper.classList.remove(oldProp.cssClass), wrapper.classList.add(newProp.cssClass);
                    break;

                  case "enableRtl":
                    newProp.enableRtl ? wrapper.classList.add("e-rtl") : wrapper.classList.remove("e-rtl");
                    break;

                  case "label":
                    this.setText(newProp.label);
                    break;

                  case "labelPosition":
                    var label = wrapper.getElementsByClassName("e-label")[0], labelWrap = wrapper.getElementsByTagName("label")[0];
                    detach(label), "After" === newProp.labelPosition ? labelWrap.appendChild(label) : labelWrap.insertBefore(label, wrapper.getElementsByClassName("e-frame")[0]);
                    break;

                  case "name":
                    this.element.setAttribute("name", newProp.name);
                    break;

                  case "value":
                    this.element.setAttribute("value", newProp.value);
                }
            }
        }, CheckBox.prototype.preRender = function() {
            var element = this.element;
            this.tagName = this.element.tagName, element = wrapperInitialize("EJS-CHECKBOX", "checkbox", element, WRAPPER), 
            this.element = element, "checkbox" !== this.element.getAttribute("type") && this.element.setAttribute("type", "checkbox"), 
            this.element.id || (this.element.id = getUniqueID("e-" + this.getModuleName()));
        }, CheckBox.prototype.render = function() {
            this.initWrapper(), this.initialize(), this.disabled || this.wireEvents();
        }, CheckBox.prototype.setDisabled = function() {
            var wrapper = this.getWrapper();
            this.element.disabled = !0, wrapper.classList.add("e-checkbox-disabled"), wrapper.setAttribute("aria-disabled", "true");
        }, CheckBox.prototype.setText = function(text) {
            var label = this.getWrapper().getElementsByClassName("e-label")[0];
            if (label) label.textContent = text; else {
                label = createElement("span", {
                    className: "e-label",
                    innerHTML: text
                });
                var labelWrap = this.getWrapper().getElementsByTagName("label")[0];
                "Before" === this.labelPosition ? labelWrap.insertBefore(label, this.getWrapper().getElementsByClassName("e-frame")[0]) : labelWrap.appendChild(label);
            }
        }, CheckBox.prototype.unWireEvents = function() {
            var wrapper = this.getWrapper();
            EventHandler.remove(this.element, "click", this.clickHandler), EventHandler.remove(document, "keydown", this.keyDownHandler), 
            EventHandler.remove(wrapper, "mousedown", this.mouseDownHandler), EventHandler.remove(this.element, "focus", this.focusHandler), 
            EventHandler.remove(this.element, "focusout", this.focusOutHandler);
            var label = wrapper.getElementsByTagName("label")[0];
            EventHandler.remove(label, "mousedown", this.labelMouseHandler), EventHandler.remove(label, "mouseup", this.labelMouseHandler);
        }, CheckBox.prototype.wireEvents = function() {
            var wrapper = this.getWrapper();
            EventHandler.add(this.element, "click", this.clickHandler, this), EventHandler.add(document, "keydown", this.keyDownHandler, this), 
            EventHandler.add(wrapper, "mousedown", this.mouseDownHandler, this), EventHandler.add(this.element, "focus", this.focusHandler, this), 
            EventHandler.add(this.element, "focusout", this.focusOutHandler, this);
            var label = wrapper.getElementsByTagName("label")[0];
            EventHandler.add(label, "mousedown", this.labelMouseHandler, this), EventHandler.add(label, "mouseup", this.labelMouseHandler, this);
        }, __decorate$1$3([ Event() ], CheckBox.prototype, "change", void 0), __decorate$1$3([ Property(!1) ], CheckBox.prototype, "checked", void 0), 
        __decorate$1$3([ Property("") ], CheckBox.prototype, "cssClass", void 0), __decorate$1$3([ Property(!1) ], CheckBox.prototype, "disabled", void 0), 
        __decorate$1$3([ Property(!1) ], CheckBox.prototype, "indeterminate", void 0), __decorate$1$3([ Property("") ], CheckBox.prototype, "label", void 0), 
        __decorate$1$3([ Property("After") ], CheckBox.prototype, "labelPosition", void 0), 
        __decorate$1$3([ Property("") ], CheckBox.prototype, "name", void 0), __decorate$1$3([ Property("") ], CheckBox.prototype, "value", void 0), 
        CheckBox = __decorate$1$3([ NotifyPropertyChanges ], CheckBox);
    }(Component), __extends$2$3 = function() {
        var extendStatics = Object.setPrototypeOf || {
            __proto__: []
        } instanceof Array && function(d, b) {
            d.__proto__ = b;
        } || function(d, b) {
            for (var p in b) b.hasOwnProperty(p) && (d[p] = b[p]);
        };
        return function(d, b) {
            function __() {
                this.constructor = d;
            }
            extendStatics(d, b), d.prototype = null === b ? Object.create(b) : (__.prototype = b.prototype, 
            new __());
        };
    }(), __decorate$2$3 = function(decorators, target, key, desc) {
        var d, c = arguments.length, r = c < 3 ? target : null === desc ? desc = Object.getOwnPropertyDescriptor(target, key) : desc;
        if ("object" == typeof Reflect && "function" == typeof Reflect.decorate) r = Reflect.decorate(decorators, target, key, desc); else for (var i = decorators.length - 1; i >= 0; i--) (d = decorators[i]) && (r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r);
        return c > 3 && r && Object.defineProperty(target, key, r), r;
    }, RadioButton = function(_super) {
        function RadioButton(options, element) {
            var _this = _super.call(this, options, element) || this;
            return _this.isKeyPressed = !1, _this;
        }
        return __extends$2$3(RadioButton, _super), RadioButton_1 = RadioButton, RadioButton.prototype.changeHandler = function(event) {
            this.checked = !0, this.dataBind();
            var changeEventArgs = {
                value: this.value,
                event: event
            };
            this.trigger("change", changeEventArgs);
        }, RadioButton.prototype.updateChange = function(state) {
            for (var input, name = this.element.getAttribute("name"), radioGrp = document.querySelectorAll('input.e-radio[name="' + name + '"]'), i = 0; i < radioGrp.length; i++) (input = radioGrp[i]) !== this.element && (getInstance(input, RadioButton_1).checked = !1);
        }, RadioButton.prototype.destroy = function() {
            var _this = this, radioWrap = this.element.parentElement;
            _super.prototype.destroy.call(this), this.disabled || this.unWireEvents(), "INPUT" === this.tagName ? (radioWrap.parentNode.insertBefore(this.element, radioWrap), 
            detach(radioWrap), this.element.checked = !1, [ "name", "value", "disabled" ].forEach(function(key) {
                _this.element.removeAttribute(key);
            })) : ([ "role", "aria-checked", "class" ].forEach(function(key) {
                radioWrap.removeAttribute(key);
            }), this.element.id && radioWrap.setAttribute("id", this.element.id), radioWrap.innerHTML = "");
        }, RadioButton.prototype.focusHandler = function() {
            this.isKeyPressed && this.getLabel().classList.add("e-focus");
        }, RadioButton.prototype.focusOutHandler = function() {
            this.getLabel().classList.remove("e-focus");
        }, RadioButton.prototype.getModuleName = function() {
            return "radio";
        }, RadioButton.prototype.getPersistData = function() {
            return this.addOnPersist([ "checked" ]);
        }, RadioButton.prototype.getLabel = function() {
            return this.element.nextElementSibling;
        }, RadioButton.prototype.initialize = function() {
            this.initWrapper(), this.name && this.element.setAttribute("name", this.name), this.value && this.element.setAttribute("value", this.value), 
            this.checked && (this.element.checked = !0), this.disabled && this.setDisabled();
        }, RadioButton.prototype.initWrapper = function() {
            var rippleSpan, wrapper = this.element.parentElement;
            wrapper.classList.contains("e-radio-wrapper") || (wrapper = createElement("div", {
                className: "e-radio-wrapper"
            }), this.element.parentNode.insertBefore(wrapper, this.element));
            var label = createElement("label", {
                attrs: {
                    for: this.element.id
                }
            });
            wrapper.appendChild(this.element), wrapper.appendChild(label), isRippleEnabled && (rippleSpan = createElement("span", {
                className: "e-ripple-container"
            }), label.appendChild(rippleSpan), rippleEffect(rippleSpan, {
                duration: 400,
                isCenterRipple: !0
            })), this.enableRtl && label.classList.add("e-rtl"), this.cssClass && addClass([ label ], this.cssClass.split(" ")), 
            this.label && this.setText(this.label);
        }, RadioButton.prototype.keyDownHandler = function() {
            this.isKeyPressed = !0;
        }, RadioButton.prototype.labelRippleHandler = function(e) {
            rippleMouseHandler(e, this.getLabel().getElementsByClassName("e-ripple-container")[0]);
        }, RadioButton.prototype.mouseDownHandler = function() {
            this.isKeyPressed = !1;
        }, RadioButton.prototype.onPropertyChanged = function(newProp, oldProp) {
            for (var label = this.getLabel(), _i = 0, _a = Object.keys(newProp); _i < _a.length; _i++) {
                switch (_a[_i]) {
                  case "checked":
                    newProp.checked && this.updateChange(newProp.checked), this.element.checked = newProp.checked;
                    break;

                  case "disabled":
                    newProp.disabled ? (this.setDisabled(), this.unWireEvents()) : (this.element.disabled = !1, 
                    this.wireEvents());
                    break;

                  case "cssClass":
                    oldProp.cssClass && removeClass([ label ], oldProp.cssClass.split(" ")), addClass([ label ], newProp.cssClass.split(" "));
                    break;

                  case "enableRtl":
                    newProp.enableRtl ? label.classList.add("e-rtl") : label.classList.remove("e-rtl");
                    break;

                  case "label":
                    this.setText(newProp.label);
                    break;

                  case "labelPosition":
                    "Before" === newProp.labelPosition ? label.classList.add("e-right") : label.classList.remove("e-right");
                    break;

                  case "name":
                    this.element.setAttribute("name", newProp.name);
                    break;

                  case "value":
                    this.element.setAttribute("value", newProp.value);
                }
            }
        }, RadioButton.prototype.preRender = function() {
            var element = this.element;
            this.tagName = this.element.tagName, element = wrapperInitialize("EJS-RADIOBUTTON", "radio", element, "e-radio-wrapper"), 
            this.element = element, "radio" !== this.element.getAttribute("type") && this.element.setAttribute("type", "radio"), 
            this.element.id || (this.element.id = getUniqueID("e-" + this.getModuleName()));
        }, RadioButton.prototype.render = function() {
            this.initialize(), this.disabled || this.wireEvents();
        }, RadioButton.prototype.setDisabled = function() {
            this.element.disabled = !0;
        }, RadioButton.prototype.setText = function(text) {
            var label = this.getLabel(), textLabel = label.getElementsByClassName("e-label")[0];
            textLabel ? textLabel.textContent = text : (textLabel = createElement("span", {
                className: "e-label",
                innerHTML: text
            }), label.appendChild(textLabel)), "Before" === this.labelPosition ? this.getLabel().classList.add("e-right") : this.getLabel().classList.remove("e-right");
        }, RadioButton.prototype.unWireEvents = function() {
            var label = this.getLabel();
            EventHandler.remove(this.element, "change", this.changeHandler), EventHandler.remove(document, "keydown", this.keyDownHandler), 
            EventHandler.remove(label, "mousedown", this.mouseDownHandler), EventHandler.remove(this.element, "focus", this.focusHandler), 
            EventHandler.remove(this.element, "focusout", this.focusOutHandler);
            var rippleLabel = label.getElementsByClassName("e-label")[0];
            rippleLabel && (EventHandler.remove(rippleLabel, "mousedown", this.labelRippleHandler), 
            EventHandler.remove(rippleLabel, "mouseup", this.labelRippleHandler));
        }, RadioButton.prototype.wireEvents = function() {
            var label = this.getLabel();
            EventHandler.add(this.element, "change", this.changeHandler, this), EventHandler.add(document, "keydown", this.keyDownHandler, this), 
            EventHandler.add(label, "mousedown", this.mouseDownHandler, this), EventHandler.add(this.element, "focus", this.focusHandler, this), 
            EventHandler.add(this.element, "focusout", this.focusOutHandler, this);
            var rippleLabel = label.getElementsByClassName("e-label")[0];
            rippleLabel && (EventHandler.add(rippleLabel, "mousedown", this.labelRippleHandler, this), 
            EventHandler.add(rippleLabel, "mouseup", this.labelRippleHandler, this));
        }, __decorate$2$3([ Event() ], RadioButton.prototype, "change", void 0), __decorate$2$3([ Property(!1) ], RadioButton.prototype, "checked", void 0), 
        __decorate$2$3([ Property("") ], RadioButton.prototype, "cssClass", void 0), __decorate$2$3([ Property(!1) ], RadioButton.prototype, "disabled", void 0), 
        __decorate$2$3([ Property("") ], RadioButton.prototype, "label", void 0), __decorate$2$3([ Property("After") ], RadioButton.prototype, "labelPosition", void 0), 
        __decorate$2$3([ Property("") ], RadioButton.prototype, "name", void 0), __decorate$2$3([ Property("") ], RadioButton.prototype, "value", void 0), 
        RadioButton = RadioButton_1 = __decorate$2$3([ NotifyPropertyChanges ], RadioButton);
        var RadioButton_1;
    }(Component), _buttons = Object.freeze({
        wrapperInitialize: wrapperInitialize,
        getTextNode: getTextNode,
        createCheckBox: createCheckBox,
        rippleMouseHandler: rippleMouseHandler,
        Button: Button,
        CheckBox: CheckBox,
        RadioButton: RadioButton
    }), fixedParent = !1, __extends$4$1 = function() {
        var extendStatics = Object.setPrototypeOf || {
            __proto__: []
        } instanceof Array && function(d, b) {
            d.__proto__ = b;
        } || function(d, b) {
            for (var p in b) b.hasOwnProperty(p) && (d[p] = b[p]);
        };
        return function(d, b) {
            function __() {
                this.constructor = d;
            }
            extendStatics(d, b), d.prototype = null === b ? Object.create(b) : (__.prototype = b.prototype, 
            new __());
        };
    }(), __decorate$4$1 = function(decorators, target, key, desc) {
        var d, c = arguments.length, r = c < 3 ? target : null === desc ? desc = Object.getOwnPropertyDescriptor(target, key) : desc;
        if ("object" == typeof Reflect && "function" == typeof Reflect.decorate) r = Reflect.decorate(decorators, target, key, desc); else for (var i = decorators.length - 1; i >= 0; i--) (d = decorators[i]) && (r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r);
        return c > 3 && r && Object.defineProperty(target, key, r), r;
    }, PositionData = function(_super) {
        function PositionData() {
            return null !== _super && _super.apply(this, arguments) || this;
        }
        return __extends$4$1(PositionData, _super), __decorate$4$1([ Property("left") ], PositionData.prototype, "X", void 0), 
        __decorate$4$1([ Property("top") ], PositionData.prototype, "Y", void 0), PositionData;
    }(ChildProperty), CLASSNAMES_ROOT = "e-popup", CLASSNAMES_RTL = "e-rtl", CLASSNAMES_OPEN = "e-popup-open", CLASSNAMES_CLOSE = "e-popup-close", Popup = function(_super) {
        function Popup(element, options) {
            var _this = _super.call(this, options, element) || this;
            return _this.fixedParent = !1, _this;
        }
        return __extends$4$1(Popup, _super), Popup.prototype.onPropertyChanged = function(newProp, oldProp) {
            for (var _i = 0, _a = Object.keys(newProp); _i < _a.length; _i++) {
                switch (_a[_i]) {
                  case "width":
                    setStyleAttribute(this.element, {
                        width: formatUnit(newProp.width)
                    });
                    break;

                  case "height":
                    setStyleAttribute(this.element, {
                        height: formatUnit(newProp.height)
                    });
                    break;

                  case "zIndex":
                    setStyleAttribute(this.element, {
                        zIndex: newProp.zIndex
                    });
                    break;

                  case "enableRtl":
                    this.setEnableRtl();
                    break;

                  case "position":
                  case "relateTo":
                    this.refreshPosition();
                    break;

                  case "offsetX":
                    var x = newProp.offsetX - oldProp.offsetX;
                    this.element.style.left = (parseInt(this.element.style.left, 10) + x).toString() + "px";
                    break;

                  case "offsetY":
                    var y = newProp.offsetY - oldProp.offsetY;
                    this.element.style.top = (parseInt(this.element.style.top, 10) + y).toString() + "px";
                    break;

                  case "content":
                    this.setContent();
                    break;

                  case "actionOnScroll":
                    "none" !== newProp.actionOnScroll ? this.wireScrollEvents() : this.unwireScrollEvents();
                }
            }
        }, Popup.prototype.getModuleName = function() {
            return "popup";
        }, Popup.prototype.getPersistData = function() {
            return this.addOnPersist([]);
        }, Popup.prototype.destroy = function() {
            this.element.classList.remove(CLASSNAMES_ROOT, CLASSNAMES_RTL), this.unwireEvents(), 
            _super.prototype.destroy.call(this);
        }, Popup.prototype.render = function() {
            this.element.classList.add(CLASSNAMES_ROOT);
            var styles = {};
            1e3 !== this.zIndex && (styles.zIndex = this.zIndex), "auto" !== this.width && (styles.width = formatUnit(this.width)), 
            "auto" !== this.height && (styles.height = formatUnit(this.height)), setStyleAttribute(this.element, styles), 
            this.setEnableRtl(), this.setContent(), this.wireEvents();
        }, Popup.prototype.wireEvents = function() {
            Browser.isDevice && EventHandler.add(window, "orientationchange", this.orientationOnChange, this), 
            "none" !== this.actionOnScroll && this.wireScrollEvents();
        }, Popup.prototype.wireScrollEvents = function() {
            if (this.getRelateToElement()) for (var _i = 0, _a = this.getScrollableParent(this.getRelateToElement()); _i < _a.length; _i++) {
                var parent_1 = _a[_i];
                EventHandler.add(parent_1, "scroll", this.scrollRefresh, this);
            }
        }, Popup.prototype.unwireEvents = function() {
            Browser.isDevice && EventHandler.remove(window, "orientationchange", this.orientationOnChange), 
            "none" !== this.actionOnScroll && this.unwireScrollEvents();
        }, Popup.prototype.unwireScrollEvents = function() {
            if (this.getRelateToElement()) for (var _i = 0, _a = this.getScrollableParent(this.getRelateToElement()); _i < _a.length; _i++) {
                var parent_2 = _a[_i];
                EventHandler.remove(parent_2, "scroll", this.scrollRefresh);
            }
        }, Popup.prototype.getRelateToElement = function() {
            var relateToElement = "" === this.relateTo ? document.body : this.relateTo;
            return this.setProperties({
                relateTo: relateToElement
            }, !0), "string" == typeof this.relateTo ? document.querySelector(this.relateTo) : this.relateTo;
        }, Popup.prototype.scrollRefresh = function(e) {
            if ("reposition" === this.actionOnScroll ? this.element.offsetParent === e.target || this.element.offsetParent && "BODY" === this.element.offsetParent.tagName && null == e.target.parentElement || this.refreshPosition() : "hide" === this.actionOnScroll && this.hide(), 
            "none" !== this.actionOnScroll && this.getRelateToElement()) {
                var targetVisible = this.isElementOnViewport(this.getRelateToElement(), e.target);
                targetVisible || this.targetInvisibleStatus ? targetVisible && (this.targetInvisibleStatus = !1) : (this.trigger("targetExitViewport"), 
                this.targetInvisibleStatus = !0);
            }
        }, Popup.prototype.isElementOnViewport = function(relateToElement, scrollElement) {
            for (var scrollParents = this.getScrollableParent(relateToElement), parent_3 = 0; parent_3 < scrollParents.length; parent_3++) if (!this.isElementVisible(relateToElement, scrollParents[parent_3])) return !1;
            return !0;
        }, Popup.prototype.isElementVisible = function(relateToElement, scrollElement) {
            var rect = relateToElement.getBoundingClientRect();
            if (!rect.height || !rect.width) return !1;
            if (scrollElement.getBoundingClientRect) {
                var parent_4 = scrollElement.getBoundingClientRect();
                return !(rect.bottom < parent_4.top || rect.bottom > parent_4.bottom || rect.right > parent_4.right || rect.left < parent_4.left);
            }
            var win = window, windowView_top = win.scrollY, windowView_left = win.scrollX, windowView_right = win.scrollX + win.outerWidth, windowView_bottom = win.scrollY + win.outerHeight, off = calculatePosition(relateToElement), ele_top = off.top, ele_left = off.left, ele_right = off.left + rect.width, ele_bottom = off.top + rect.height;
            return windowView_bottom - ele_top > 0 && windowView_right - ele_left > 0 && ele_right - windowView_left > 0 && ele_bottom - windowView_top > 0;
        }, Popup.prototype.preRender = function() {}, Popup.prototype.setEnableRtl = function() {
            this.reposition(), this.enableRtl ? this.element.classList.add(CLASSNAMES_RTL) : this.element.classList.remove(CLASSNAMES_RTL);
        }, Popup.prototype.setContent = function() {
            isNullOrUndefined(this.content) || (this.element.innerHTML = "", "string" == typeof this.content ? this.element.textContent = this.content : this.element.appendChild(this.content));
        }, Popup.prototype.orientationOnChange = function() {
            var _this = this;
            setTimeout(function() {
                _this.refreshPosition();
            }, 200);
        }, Popup.prototype.refreshPosition = function(target) {
            isNullOrUndefined(target) || this.checkFixedParent(target), this.reposition(), this.checkCollision();
        }, Popup.prototype.reposition = function() {
            var pos, relateToElement = this.getRelateToElement();
            if ("number" == typeof this.position.X && "number" == typeof this.position.Y) pos = {
                left: this.position.X,
                top: this.position.Y
            }; else if (relateToElement) {
                var display = this.element.style.display;
                this.element.style.display = "block", pos = this.getAnchorPosition(relateToElement, this.element, this.position, this.offsetX, this.offsetY), 
                this.element.style.display = display;
            } else pos = {
                left: 0,
                top: 0
            };
            this.element.style.left = pos.left + "px", this.element.style.top = pos.top + "px";
        }, Popup.prototype.getAnchorPosition = function(anchorEle, ele, position, offsetX, offsetY) {
            var eleRect = ele.getBoundingClientRect(), anchorRect = anchorEle.getBoundingClientRect(), anchor = anchorEle, anchorPos = {
                left: 0,
                top: 0
            };
            switch (anchorPos = ele.offsetParent && "BODY" === ele.offsetParent.tagName && "BODY" === anchorEle.tagName ? calculatePosition(anchorEle) : calculateRelativeBasedPosition(anchor, ele), 
            position.X) {
              default:
              case "left":
                break;

              case "center":
                "container" === this.targetType ? anchorPos.left += anchorRect.width / 2 - eleRect.width / 2 : anchorPos.left += anchorRect.width / 2;
                break;

              case "right":
                "container" === this.targetType ? anchorPos.left += anchorRect.width - eleRect.width : anchorPos.left += anchorRect.width;
            }
            switch (position.Y) {
              default:
              case "top":
                break;

              case "center":
                "container" === this.targetType ? anchorPos.top += anchorRect.height / 2 - eleRect.height / 2 : anchorPos.top += anchorRect.height / 2;
                break;

              case "bottom":
                "container" === this.targetType ? anchorPos.top += anchorRect.height - eleRect.height : anchorPos.top += anchorRect.height;
            }
            return anchorPos.left += offsetX, anchorPos.top += offsetY, anchorPos;
        }, Popup.prototype.callFlip = function(param) {
            var relateToElement = this.getRelateToElement();
            flip(this.element, relateToElement, this.offsetX, this.offsetY, this.position.X, this.position.Y, this.viewPortElement, param, this.fixedParent);
        }, Popup.prototype.callFit = function(param) {
            if (0 !== isCollide(this.element, this.viewPortElement).length) {
                var data = fit(this.element, this.viewPortElement, param);
                this.element.style.left = data.left + "px", this.element.style.top = data.top + "px";
            }
        }, Popup.prototype.checkCollision = function() {
            var horz = this.collision.X, vert = this.collision.Y;
            "none" === horz && "none" === vert || ("flip" === horz && "flip" === vert ? this.callFlip({
                X: !0,
                Y: !0
            }) : "fit" === horz && "fit" === vert ? this.callFit({
                X: !0,
                Y: !0
            }) : ("fit" === horz ? this.callFit({
                X: !0,
                Y: !1
            }) : "fit" === vert && this.callFit({
                X: !1,
                Y: !0
            }), "flip" === horz ? this.callFlip({
                X: !0,
                Y: !1
            }) : "flip" === vert && this.callFlip({
                Y: !0,
                X: !1
            })));
        }, Popup.prototype.show = function(animationOptions) {
            var _this = this;
            1e3 === this.zIndex && (this.zIndex = getZindexPartial(this.element), setStyleAttribute(this.element, {
                zIndex: this.zIndex
            })), animationOptions = isNullOrUndefined(animationOptions) || "object" != typeof animationOptions ? this.showAnimation : animationOptions, 
            "none" === this.collision.X && "none" === this.collision.Y || (removeClass([ this.element ], CLASSNAMES_CLOSE), 
            addClass([ this.element ], CLASSNAMES_OPEN), this.checkCollision(), removeClass([ this.element ], CLASSNAMES_OPEN), 
            addClass([ this.element ], CLASSNAMES_CLOSE)), isNullOrUndefined(animationOptions) ? (removeClass([ this.element ], CLASSNAMES_CLOSE), 
            addClass([ this.element ], CLASSNAMES_OPEN), this.trigger("open")) : (animationOptions.begin = function() {
                _this.isDestroyed || (removeClass([ _this.element ], CLASSNAMES_CLOSE), addClass([ _this.element ], CLASSNAMES_OPEN));
            }, animationOptions.end = function() {
                _this.isDestroyed || _this.trigger("open");
            }, new Animation(animationOptions).animate(this.element));
        }, Popup.prototype.hide = function(animationOptions) {
            var _this = this;
            isNullOrUndefined(animationOptions = isNullOrUndefined(animationOptions) || "object" != typeof animationOptions ? this.hideAnimation : animationOptions) ? (removeClass([ this.element ], CLASSNAMES_OPEN), 
            addClass([ this.element ], CLASSNAMES_CLOSE), this.trigger("close")) : (animationOptions.end = function() {
                _this.isDestroyed || (removeClass([ _this.element ], CLASSNAMES_OPEN), addClass([ _this.element ], CLASSNAMES_CLOSE), 
                _this.trigger("close"));
            }, new Animation(animationOptions).animate(this.element));
        }, Popup.prototype.getScrollableParent = function(element) {
            return this.checkFixedParent(element), getScrollableParent(element, this.fixedParent);
        }, Popup.prototype.checkFixedParent = function(element) {
            for (var parent = element.parentElement; parent && "HTML" !== parent.tagName; ) {
                var parentStyle = getComputedStyle(parent);
                "fixed" === parentStyle.position && this.element.offsetParent && "BODY" === this.element.offsetParent.tagName && (this.element.style.position = "fixed", 
                this.fixedParent = !0), parent = parent.parentElement, isNullOrUndefined(this.element.offsetParent) && "fixed" === parentStyle.position && "fixed" === this.element.style.position && (this.fixedParent = !0);
            }
        }, __decorate$4$1([ Property("auto") ], Popup.prototype, "height", void 0), __decorate$4$1([ Property("auto") ], Popup.prototype, "width", void 0), 
        __decorate$4$1([ Property(null) ], Popup.prototype, "content", void 0), __decorate$4$1([ Property("container") ], Popup.prototype, "targetType", void 0), 
        __decorate$4$1([ Property(null) ], Popup.prototype, "viewPortElement", void 0), 
        __decorate$4$1([ Property({
            X: "none",
            Y: "none"
        }) ], Popup.prototype, "collision", void 0), __decorate$4$1([ Property("") ], Popup.prototype, "relateTo", void 0), 
        __decorate$4$1([ Complex({}, PositionData) ], Popup.prototype, "position", void 0), 
        __decorate$4$1([ Property(0) ], Popup.prototype, "offsetX", void 0), __decorate$4$1([ Property(0) ], Popup.prototype, "offsetY", void 0), 
        __decorate$4$1([ Property(1e3) ], Popup.prototype, "zIndex", void 0), __decorate$4$1([ Property(!1) ], Popup.prototype, "enableRtl", void 0), 
        __decorate$4$1([ Property("reposition") ], Popup.prototype, "actionOnScroll", void 0), 
        __decorate$4$1([ Property(null) ], Popup.prototype, "showAnimation", void 0), __decorate$4$1([ Property(null) ], Popup.prototype, "hideAnimation", void 0), 
        __decorate$4$1([ Event() ], Popup.prototype, "open", void 0), __decorate$4$1([ Event() ], Popup.prototype, "close", void 0), 
        __decorate$4$1([ Event() ], Popup.prototype, "targetExitViewport", void 0), Popup = __decorate$4$1([ NotifyPropertyChanges ], Popup);
    }(Component), __extends$1$2 = function() {
        var extendStatics = Object.setPrototypeOf || {
            __proto__: []
        } instanceof Array && function(d, b) {
            d.__proto__ = b;
        } || function(d, b) {
            for (var p in b) b.hasOwnProperty(p) && (d[p] = b[p]);
        };
        return function(d, b) {
            function __() {
                this.constructor = d;
            }
            extendStatics(d, b), d.prototype = null === b ? Object.create(b) : (__.prototype = b.prototype, 
            new __());
        };
    }(), __decorate$1$2 = function(decorators, target, key, desc) {
        var d, c = arguments.length, r = c < 3 ? target : null === desc ? desc = Object.getOwnPropertyDescriptor(target, key) : desc;
        if ("object" == typeof Reflect && "function" == typeof Reflect.decorate) r = Reflect.decorate(decorators, target, key, desc); else for (var i = decorators.length - 1; i >= 0; i--) (d = decorators[i]) && (r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r);
        return c > 3 && r && Object.defineProperty(target, key, r), r;
    }, ButtonProps = function(_super) {
        function ButtonProps() {
            return null !== _super && _super.apply(this, arguments) || this;
        }
        return __extends$1$2(ButtonProps, _super), __decorate$1$2([ Property() ], ButtonProps.prototype, "buttonModel", void 0), 
        __decorate$1$2([ Property() ], ButtonProps.prototype, "click", void 0), ButtonProps;
    }(ChildProperty), AnimationSettings = function(_super) {
        function AnimationSettings() {
            return null !== _super && _super.apply(this, arguments) || this;
        }
        return __extends$1$2(AnimationSettings, _super), __decorate$1$2([ Property("Fade") ], AnimationSettings.prototype, "effect", void 0), 
        __decorate$1$2([ Property(400) ], AnimationSettings.prototype, "duration", void 0), 
        __decorate$1$2([ Property(0) ], AnimationSettings.prototype, "delay", void 0), AnimationSettings;
    }(ChildProperty), ROOT = "e-dialog", Dialog = function(_super) {
        function Dialog(options, element) {
            return _super.call(this, options, element) || this;
        }
        return __extends$1$2(Dialog, _super), Dialog.prototype.render = function() {
            this.initialize(), this.initRender(), this.wireEvents();
        }, Dialog.prototype.preRender = function() {
            var _this = this;
            this.headerContent = null;
            for (var classArray = [], j = 0; j < this.element.classList.length; j++) isNullOrUndefined(this.element.classList[j].match("e-control")) && isNullOrUndefined(this.element.classList[j].match(ROOT)) || classArray.push(this.element.classList[j]);
            removeClass([ this.element ], classArray), this.clonedEle = this.element.cloneNode(!0), 
            this.closeIconClickEventHandler = function(event) {
                _this.hide(), _this.closedFrom = event;
            }, this.dlgOverlayClickEventHandler = function(event) {
                _this.trigger("overlayClick", event);
            };
            this.l10n = new L10n("dialog", {
                close: "Close"
            }, this.locale);
        }, Dialog.prototype.keyDown = function(event) {
            var _this = this;
            if (9 === event.keyCode && this.isModal) {
                var buttonObj = void 0;
                isNullOrUndefined(this.btnObj) || (buttonObj = this.btnObj[this.btnObj.length - 1]), 
                isNullOrUndefined(buttonObj) || document.activeElement !== buttonObj.element || event.shiftKey || (event.preventDefault(), 
                this.focusableElements(this.element).focus()), document.activeElement === this.focusableElements(this.element) && event.shiftKey && (event.preventDefault(), 
                isNullOrUndefined(buttonObj) || buttonObj.element.focus());
            }
            var element = document.activeElement, isTagName = [ "input", "textarea" ].indexOf(element.tagName.toLowerCase()) > -1, isContentEdit = !1;
            if (isTagName || (isContentEdit = element.hasAttribute("contenteditable") && "true" === element.getAttribute("contenteditable")), 
            27 === event.keyCode && this.closeOnEscape && (this.hide(), this.closedFrom = event), 
            13 === event.keyCode && !event.ctrlKey && "textarea" !== element.tagName.toLowerCase() && isTagName && !isNullOrUndefined(this.primaryButtonEle) || 13 === event.keyCode && event.ctrlKey && ("textarea" === element.tagName.toLowerCase() || isContentEdit) && !isNullOrUndefined(this.primaryButtonEle)) {
                var buttonIndex_1;
                this.buttons.some(function(data, index) {
                    buttonIndex_1 = index;
                    var buttonModel = data.buttonModel;
                    return !isNullOrUndefined(buttonModel) && !0 === buttonModel.isPrimary;
                }) && "function" == typeof this.buttons[buttonIndex_1].click && setTimeout(function() {
                    _this.buttons[buttonIndex_1].click.call(_this, event);
                });
            }
        }, Dialog.prototype.initialize = function() {
            isNullOrUndefined(this.target) || (this.targetEle = "string" == typeof this.target ? document.querySelector(this.target) : this.target), 
            addClass([ this.element ], ROOT), Browser.isDevice && addClass([ this.element ], "e-device"), 
            this.setCSSClass(), this.setMaxHeight();
        }, Dialog.prototype.initRender = function() {
            var _this = this;
            attributes(this.element, {
                role: "dialog"
            }), 1e3 === this.zIndex && (this.zIndex = getZindexPartial(this.element)), this.setTargetContent(), 
            "" !== this.header && this.setHeader(), this.showCloseIcon && this.renderCloseIcon(), 
            isNullOrUndefined(this.content) || "" === this.content ? this.element.hasChildNodes() && (this.contentEle = this.element) : this.setContent(), 
            "" !== this.footerTemplate && this.setFooterTemplate(), isNullOrUndefined(this.buttons[0].buttonModel) || "" !== this.footerTemplate || this.setButton(), 
            !this.allowDragging || this.isModal || isNullOrUndefined(this.headerContent) || this.setAllowDragging(), 
            attributes(this.element, {
                "aria-modal": this.isModal ? "true" : "false"
            }), this.isModal && this.setIsModal(), isNullOrUndefined(this.targetEle) || (this.isModal ? this.targetEle.appendChild(this.dlgContainer) : this.targetEle.appendChild(this.element)), 
            this.popupObj = new Popup(this.element, {
                height: this.height,
                width: this.width,
                zIndex: this.zIndex,
                relateTo: this.target,
                actionOnScroll: "none",
                open: function() {
                    _this.focusContent(), _this.trigger("open");
                },
                close: function(event) {
                    _this.unBindEvent(_this.element), _this.isModal && (_this.dlgContainer.style.display = "none"), 
                    _this.trigger("close", _this.closedFrom), _this.closedFrom = {}, isNullOrUndefined(_this.storeActiveElement) || _this.storeActiveElement.focus();
                }
            }), this.positionChange(), this.setEnableRTL(), addClass([ this.element ], "e-popup-close"), 
            this.isModal && this.setOverlayZindex(), this.visible ? this.show() : this.isModal && (this.dlgOverlay.style.display = "none");
        }, Dialog.prototype.setOverlayZindex = function() {
            var zIndex = parseInt(this.element.style.zIndex, 10) ? parseInt(this.element.style.zIndex, 10) : this.zIndex;
            this.dlgOverlay.style.zIndex = (zIndex - 1).toString(), this.dlgContainer.style.zIndex = zIndex.toString();
        }, Dialog.prototype.positionChange = function() {
            this.isModal ? this.dlgContainer.classList.add("e-dlg-" + this.position.X + "-" + this.position.Y) : this.popupObj.setProperties({
                position: {
                    X: this.position.X,
                    Y: this.position.Y
                }
            });
        }, Dialog.prototype.setAllowDragging = function() {
            var _this = this;
            this.dragObj = new Draggable(this.element, {
                clone: !1,
                handle: ".e-dlg-header-content",
                dragStart: function(event) {
                    _this.trigger("dragStart", event);
                },
                dragStop: function(event) {
                    _this.trigger("dragStop", event);
                },
                drag: function(event) {
                    _this.trigger("drag", event);
                }
            }), isNullOrUndefined(this.targetEle) || (this.dragObj.dragArea = this.targetEle);
        }, Dialog.prototype.setButton = function() {
            this.buttonContent = [], this.btnObj = [];
            for (var i = 0; i < this.buttons.length; i++) {
                var btn = createElement("button", {
                    attrs: {
                        type: "button"
                    }
                });
                this.buttonContent.push(btn.outerHTML);
            }
            this.setFooterTemplate();
            for (i = 0; i < this.buttons.length; i++) this.btnObj[i] = new Button(this.buttons[i].buttonModel), 
            "function" == typeof this.buttons[i].click && EventHandler.add(this.ftrTemplateContent.children[i], "click", this.buttons[i].click, this), 
            this.btnObj[i].appendTo(this.ftrTemplateContent.children[i]), this.btnObj[i].isPrimary || this.btnObj[i].element.classList.add("e-flat"), 
            this.primaryButtonEle = this.element.getElementsByClassName("e-primary")[0];
        }, Dialog.prototype.setContent = function() {
            attributes(this.element, {
                "aria-describedby": this.element.id + "_dialog-content"
            }), this.contentEle = createElement("div", {
                className: "e-dlg-content",
                id: this.element.id + "_dialog-content"
            }), "string" == typeof this.content ? this.contentEle.innerHTML = this.content : this.contentEle.appendChild(this.content), 
            isNullOrUndefined(this.headerContent) ? this.element.insertBefore(this.contentEle, this.element.children[0]) : this.element.insertBefore(this.contentEle, this.element.children[1]), 
            "auto" === this.height && this.setMaxHeight();
        }, Dialog.prototype.setMaxHeight = function() {
            var display = this.element.style.display;
            this.element.style.display = "none", this.element.style.maxHeight = isNullOrUndefined(this.target) ? window.innerHeight - 20 + "px" : this.targetEle.offsetHeight - 20 + "px", 
            this.element.style.display = display;
        }, Dialog.prototype.setEnableRTL = function() {
            this.enableRtl ? addClass([ this.element ], "e-rtl") : removeClass([ this.element ], "e-rtl");
        }, Dialog.prototype.setTargetContent = function() {
            var isContent = "" !== this.element.innerHTML.replace(/\s/g, "");
            if (this.element.children.length > 0 || isContent) {
                for (var contentDiv = document.createDocumentFragment(); 0 !== this.element.childNodes.length; ) contentDiv.appendChild(this.element.childNodes[0]);
                this.setProperties({
                    content: contentDiv
                }, !0);
            }
        }, Dialog.prototype.setHeader = function() {
            this.headerEle = createElement("div", {
                id: this.element.id + "_title",
                className: "e-dlg-header",
                innerHTML: this.header
            }), attributes(this.element, {
                "aria-labelledby": this.element.id + "_title"
            }), this.createHeaderContent(), this.headerContent.appendChild(this.headerEle), 
            this.element.insertBefore(this.headerContent, this.element.children[0]);
        }, Dialog.prototype.setFooterTemplate = function() {
            this.ftrTemplateContent = createElement("div", {
                className: "e-footer-content",
                innerHTML: "" !== this.footerTemplate ? this.footerTemplate : this.buttonContent.join("")
            }), this.element.appendChild(this.ftrTemplateContent);
        }, Dialog.prototype.createHeaderContent = function() {
            isNullOrUndefined(this.headerContent) && (this.headerContent = createElement("div", {
                className: "e-dlg-header-content"
            }));
        }, Dialog.prototype.renderCloseIcon = function() {
            this.closeIcon = createElement("button", {
                className: "e-dlg-closeicon-btn",
                attrs: {
                    type: "button"
                }
            }), this.closeIconBtnObj = new Button({
                cssClass: "e-flat",
                iconCss: "e-icon-dlg-close e-icons"
            }), this.closeIconTitle(), isNullOrUndefined(this.headerContent) ? (this.createHeaderContent(), 
            prepend([ this.closeIcon ], this.headerContent), this.element.insertBefore(this.headerContent, this.element.children[0])) : prepend([ this.closeIcon ], this.headerContent), 
            this.closeIconBtnObj.appendTo(this.closeIcon);
        }, Dialog.prototype.closeIconTitle = function() {
            this.l10n.setLocale(this.locale);
            var closeIconTitle = this.l10n.getConstant("close");
            this.closeIcon.setAttribute("title", closeIconTitle);
        }, Dialog.prototype.setCSSClass = function(oldCSSClass) {
            this.cssClass && addClass([ this.element ], this.cssClass.split(" ")), oldCSSClass && removeClass([ this.element ], oldCSSClass.split(" "));
        }, Dialog.prototype.setIsModal = function() {
            this.dlgContainer = createElement("div", {
                className: "e-dlg-container"
            }), this.element.parentNode.insertBefore(this.dlgContainer, this.element), this.dlgContainer.appendChild(this.element), 
            addClass([ this.element ], "e-dlg-modal"), this.dlgOverlay = createElement("div", {
                className: "e-dlg-overlay"
            }), this.dlgOverlay.style.zIndex = (this.zIndex - 1).toString(), this.dlgContainer.appendChild(this.dlgOverlay);
        }, Dialog.prototype.getValidFocusNode = function(items) {
            for (var node, u = 0; u < items.length; u++) if (((node = items[u]).clientHeight > 0 || "a" === node.tagName.toLowerCase() && node.hasAttribute("href")) && node.tabIndex > -1 && !node.disabled && !this.disableElement(node, '[disabled],[aria-disabled="true"],[type="hidden"]')) return node;
            return node;
        }, Dialog.prototype.focusableElements = function(content) {
            if (!isNullOrUndefined(content)) {
                var items = content.querySelectorAll('input,select,textarea,button,a,[contenteditable="true"],[tabindex]');
                return this.getValidFocusNode(items);
            }
            return null;
        }, Dialog.prototype.getAutoFocusNode = function(container) {
            var node = container.querySelector(".e-dlg-closeicon-btn"), items = container.querySelectorAll("[autofocus]"), validNode = this.getValidFocusNode(items);
            if (isNullOrUndefined(validNode)) {
                if (validNode = this.focusableElements(this.contentEle), !isNullOrUndefined(validNode)) return node = validNode;
                if (!isNullOrUndefined(this.primaryButtonEle)) return this.element.querySelector(".e-primary");
            } else node = validNode;
            return node;
        }, Dialog.prototype.disableElement = function(element, t) {
            var elementMatch = element ? element.matches || element.webkitMatchesSelector || element.msMatchesSelector : null;
            if (elementMatch) for (;element; element = element.parentNode) if (element instanceof Element && elementMatch.call(element, t)) return element;
            return null;
        }, Dialog.prototype.focusContent = function() {
            var element = this.getAutoFocusNode(this.element);
            (isNullOrUndefined(element) ? this.element : element).focus(), this.bindEvent(this.element);
        }, Dialog.prototype.bindEvent = function(element) {
            EventHandler.add(element, "keydown", this.keyDown, this);
        }, Dialog.prototype.unBindEvent = function(element) {
            EventHandler.remove(element, "keydown", this.keyDown);
        }, Dialog.prototype.getModuleName = function() {
            return "dialog";
        }, Dialog.prototype.onPropertyChanged = function(newProp, oldProp) {
            for (var _i = 0, _a = Object.keys(newProp); _i < _a.length; _i++) {
                switch (_a[_i]) {
                  case "content":
                    isNullOrUndefined(this.content) || "" === this.content ? isNullOrUndefined(this.contentEle) || this.element.removeChild(this.contentEle) : isNullOrUndefined(this.contentEle) || "dialog" === this.contentEle.getAttribute("role") ? this.setContent() : (this.contentEle.innerHTML = "", 
                    "string" == typeof this.content ? this.contentEle.innerHTML = this.content : this.contentEle.appendChild(this.content), 
                    this.setMaxHeight());
                    break;

                  case "header":
                    "" === this.header ? detach(this.headerEle) : this.element.getElementsByClassName("e-dlg-header").length > 0 ? this.element.getElementsByClassName("e-dlg-header")[0].innerHTML = this.header : this.setHeader();
                    break;

                  case "footerTemplate":
                    this.element.getElementsByClassName("e-footer-content").length > 0 ? this.ftrTemplateContent.innerHTML = this.footerTemplate : this.setFooterTemplate();
                    break;

                  case "showCloseIcon":
                    this.element.getElementsByClassName("e-icon-dlg-close").length > 0 ? this.showCloseIcon || "" !== this.header ? this.showCloseIcon || detach(this.closeIcon) : detach(this.headerContent) : (this.renderCloseIcon(), 
                    this.wireEvents());
                    break;

                  case "locale":
                    this.showCloseIcon && this.closeIconTitle();
                    break;

                  case "visible":
                    this.visible ? this.show() : this.hide();
                    break;

                  case "isModal":
                    if (this.element.setAttribute("aria-modal", this.isModal ? "true" : "false"), this.isModal) this.setIsModal(), 
                    this.wireEvents(), isNullOrUndefined(this.targetEle) || (this.isModal ? this.targetEle.appendChild(this.dlgContainer) : this.targetEle.appendChild(this.element)); else {
                        for (removeClass([ this.element ], "e-dlg-modal"), removeClass([ document.body ], "e-scroll-disabled"), 
                        detach(this.dlgOverlay); this.dlgContainer.firstChild; ) this.dlgContainer.parentElement.insertBefore(this.dlgContainer.firstChild, this.dlgContainer);
                        this.dlgContainer.parentElement.removeChild(this.dlgContainer);
                    }
                    break;

                  case "height":
                    setStyleAttribute(this.element, {
                        height: formatUnit(newProp.height)
                    });
                    break;

                  case "width":
                    setStyleAttribute(this.element, {
                        width: formatUnit(newProp.width)
                    });
                    break;

                  case "zIndex":
                    this.popupObj.zIndex = this.zIndex, this.isModal && this.setOverlayZindex();
                    break;

                  case "cssClass":
                    this.setCSSClass(oldProp.cssClass);
                    break;

                  case "animationSettings":
                    this.show();
                    break;

                  case "buttons":
                    isNullOrUndefined(this.buttons[0].buttonModel) || "" !== this.footerTemplate || (isNullOrUndefined(this.ftrTemplateContent) || detach(this.ftrTemplateContent), 
                    this.setButton());
                    break;

                  case "allowDragging":
                    !this.allowDragging || this.isModal || isNullOrUndefined(this.headerContent) ? this.dragObj.destroy() : this.setAllowDragging();
                    break;

                  case "target":
                    this.popupObj.relateTo = newProp.target;
                    break;

                  case "position":
                    if (oldProp.position.X === this.position.X && oldProp.position.Y === this.position.Y) break;
                    if (!this.isModal) {
                        this.popupObj.position.X = this.position.X, this.popupObj.position.Y = this.position.Y;
                        break;
                    }
                    this.dlgContainer.classList.remove("e-dlg-" + oldProp.position.X + "-" + oldProp.position.Y), 
                    this.dlgContainer.classList.add("e-dlg-" + this.position.X + "-" + this.position.Y);
                    break;

                  case "enableRtl":
                    this.setEnableRTL();
                }
            }
        }, Dialog.prototype.getPersistData = function() {
            return this.addOnPersist([]);
        }, Dialog.prototype.destroy = function() {
            if (this.element.classList.contains(ROOT)) {
                this.unWireEvents(), _super.prototype.destroy.call(this);
                var classArray = [ ROOT, "e-rtl", "e-dlg-modal" ];
                if (removeClass([ this.element, this.element ], classArray), this.popupObj.element.classList.contains("e-popup") && this.popupObj.destroy(), 
                !isNullOrUndefined(this.btnObj)) for (var i = void 0; i < this.btnObj.length; i++) this.btnObj[i].destroy();
                for (this.isModal && (detach(this.dlgOverlay), this.dlgContainer.parentNode.insertBefore(this.element, this.dlgContainer), 
                detach(this.dlgContainer)), this.element.innerHTML = ""; this.element.attributes.length > 0; ) this.element.removeAttribute(this.element.attributes[0].name);
                for (var k = 0; k < this.clonedEle.attributes.length; k++) this.element.setAttribute(this.clonedEle.attributes[k].name, this.clonedEle.attributes[k].value);
            }
        }, Dialog.prototype.wireEvents = function() {
            this.showCloseIcon && EventHandler.add(this.closeIcon, "click", this.closeIconClickEventHandler, this), 
            this.isModal && EventHandler.add(this.dlgOverlay, "click", this.dlgOverlayClickEventHandler, this);
        }, Dialog.prototype.unWireEvents = function() {
            if (this.showCloseIcon && EventHandler.remove(this.closeIcon, "click", this.closeIconClickEventHandler), 
            this.isModal && EventHandler.remove(this.dlgOverlay, "click", this.dlgOverlayClickEventHandler), 
            !isNullOrUndefined(this.buttons[0].buttonModel)) for (var i = 0; i < this.buttons.length; i++) "function" == typeof this.buttons[i].click && EventHandler.remove(this.ftrTemplateContent.children[i], "click", this.buttons[i].click);
        }, Dialog.prototype.refreshPosition = function() {
            this.popupObj.refreshPosition();
        }, Dialog.prototype.show = function(isFullScreen) {
            if (!this.element.classList.contains("e-popup-open") || !isNullOrUndefined(isFullScreen)) {
                isNullOrUndefined(isFullScreen) || this.fullScreen(isFullScreen);
                var eventArgs = {
                    cancel: !1,
                    container: this.isModal ? this.dlgContainer : this.element
                };
                if (this.trigger("beforeOpen", eventArgs), eventArgs.cancel) return;
                this.storeActiveElement = document.activeElement, this.element.tabIndex = -1, this.isModal && !isNullOrUndefined(this.dlgOverlay) && (this.dlgOverlay.style.display = "block", 
                this.dlgContainer.style.display = "flex", isNullOrUndefined(this.targetEle) ? addClass([ document.body ], "e-scroll-disabled") : (this.targetEle === document.body ? this.dlgContainer.style.position = "fixed" : this.dlgContainer.style.position = "absolute", 
                this.dlgOverlay.style.position = "absolute", this.element.style.position = "relative", 
                addClass([ this.targetEle ], "e-scroll-disabled")));
                var openAnimation = {
                    name: this.animationSettings.effect + "In",
                    duration: this.animationSettings.duration,
                    delay: this.animationSettings.delay
                };
                "None" === this.animationSettings.effect ? this.popupObj.show() : this.popupObj.show(openAnimation), 
                this.dialogOpen = !0, this.setProperties({
                    visible: !0
                }, !0);
            }
        }, Dialog.prototype.hide = function() {
            var eventArgs = {
                cancel: !1,
                container: this.isModal ? this.dlgContainer : this.element
            };
            if (this.trigger("beforeClose", eventArgs), !eventArgs.cancel) {
                this.isModal && (this.dlgOverlay.style.display = "none", isNullOrUndefined(this.targetEle) ? removeClass([ document.body ], "e-scroll-disabled") : removeClass([ this.targetEle ], "e-scroll-disabled"));
                var closeAnimation = {
                    name: this.animationSettings.effect + "Out",
                    duration: this.animationSettings.duration,
                    delay: this.animationSettings.delay
                };
                "None" === this.animationSettings.effect ? this.popupObj.hide() : this.popupObj.hide(closeAnimation), 
                this.dialogOpen = !1, this.setProperties({
                    visible: !1
                }, !0);
            }
        }, Dialog.prototype.fullScreen = function(args) {
            this.element.offsetTop, this.element.offsetLeft;
            if (args) {
                addClass([ this.element ], "e-dlg-fullscreen");
                var display = this.element.style.display;
                this.element.style.display = "none", this.element.style.maxHeight = isNullOrUndefined(this.target) ? window.innerHeight + "px" : this.targetEle.offsetHeight + "px", 
                this.element.style.display = display, addClass([ document.body ], "e-scroll-disabled"), 
                this.allowDragging && !isNullOrUndefined(this.dragObj) && this.dragObj.destroy();
            } else removeClass([ this.element ], "e-dlg-fullscreen"), removeClass([ document.body ], "e-scroll-disabled"), 
            !this.allowDragging || this.isModal || isNullOrUndefined(this.headerContent) || this.setAllowDragging();
            return args;
        }, __decorate$1$2([ Property("") ], Dialog.prototype, "content", void 0), __decorate$1$2([ Property(!1) ], Dialog.prototype, "showCloseIcon", void 0), 
        __decorate$1$2([ Property(!1) ], Dialog.prototype, "isModal", void 0), __decorate$1$2([ Property("") ], Dialog.prototype, "header", void 0), 
        __decorate$1$2([ Property(!0) ], Dialog.prototype, "visible", void 0), __decorate$1$2([ Property("auto") ], Dialog.prototype, "height", void 0), 
        __decorate$1$2([ Property("100%") ], Dialog.prototype, "width", void 0), __decorate$1$2([ Property("") ], Dialog.prototype, "cssClass", void 0), 
        __decorate$1$2([ Property(1e3) ], Dialog.prototype, "zIndex", void 0), __decorate$1$2([ Property(null) ], Dialog.prototype, "target", void 0), 
        __decorate$1$2([ Property("") ], Dialog.prototype, "footerTemplate", void 0), __decorate$1$2([ Property(!1) ], Dialog.prototype, "allowDragging", void 0), 
        __decorate$1$2([ Collection([ {} ], ButtonProps) ], Dialog.prototype, "buttons", void 0), 
        __decorate$1$2([ Property(!0) ], Dialog.prototype, "closeOnEscape", void 0), __decorate$1$2([ Complex({}, AnimationSettings) ], Dialog.prototype, "animationSettings", void 0), 
        __decorate$1$2([ Complex({
            X: "center",
            Y: "center"
        }, PositionData) ], Dialog.prototype, "position", void 0), __decorate$1$2([ Event() ], Dialog.prototype, "created", void 0), 
        __decorate$1$2([ Event() ], Dialog.prototype, "open", void 0), __decorate$1$2([ Event() ], Dialog.prototype, "beforeOpen", void 0), 
        __decorate$1$2([ Event() ], Dialog.prototype, "close", void 0), __decorate$1$2([ Event() ], Dialog.prototype, "beforeClose", void 0), 
        __decorate$1$2([ Event() ], Dialog.prototype, "dragStart", void 0), __decorate$1$2([ Event() ], Dialog.prototype, "dragStop", void 0), 
        __decorate$1$2([ Event() ], Dialog.prototype, "drag", void 0), __decorate$1$2([ Event() ], Dialog.prototype, "overlayClick", void 0), 
        Dialog = __decorate$1$2([ NotifyPropertyChanges ], Dialog);
    }(Component), __extends$2$2 = function() {
        var extendStatics = Object.setPrototypeOf || {
            __proto__: []
        } instanceof Array && function(d, b) {
            d.__proto__ = b;
        } || function(d, b) {
            for (var p in b) b.hasOwnProperty(p) && (d[p] = b[p]);
        };
        return function(d, b) {
            function __() {
                this.constructor = d;
            }
            extendStatics(d, b), d.prototype = null === b ? Object.create(b) : (__.prototype = b.prototype, 
            new __());
        };
    }(), __decorate$2$2 = function(decorators, target, key, desc) {
        var d, c = arguments.length, r = c < 3 ? target : null === desc ? desc = Object.getOwnPropertyDescriptor(target, key) : desc;
        if ("object" == typeof Reflect && "function" == typeof Reflect.decorate) r = Reflect.decorate(decorators, target, key, desc); else for (var i = decorators.length - 1; i >= 0; i--) (d = decorators[i]) && (r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r);
        return c > 3 && r && Object.defineProperty(target, key, r), r;
    }, Animation$1 = function(_super) {
        function Animation$$1() {
            return null !== _super && _super.apply(this, arguments) || this;
        }
        return __extends$2$2(Animation$$1, _super), __decorate$2$2([ Property({
            effect: "FadeIn",
            duration: 150,
            delay: 0
        }) ], Animation$$1.prototype, "open", void 0), __decorate$2$2([ Property({
            effect: "FadeOut",
            duration: 150,
            delay: 0
        }) ], Animation$$1.prototype, "close", void 0), Animation$$1;
    }(ChildProperty), Tooltip = function(_super) {
        function Tooltip(options, element) {
            return _super.call(this, options, element) || this;
        }
        return __extends$2$2(Tooltip, _super), Tooltip.prototype.initialize = function() {
            this.formatPosition(), addClass([ this.element ], "e-tooltip");
        }, Tooltip.prototype.formatPosition = function() {
            0 === this.position.indexOf("Top") || 0 === this.position.indexOf("Bottom") ? (_a = this.position.split(/(?=[A-Z])/), 
            this.tooltipPositionY = _a[0], this.tooltipPositionX = _a[1]) : (_b = this.position.split(/(?=[A-Z])/), 
            this.tooltipPositionX = _b[0], this.tooltipPositionY = _b[1]);
            var _a, _b;
        }, Tooltip.prototype.renderArrow = function() {
            this.setTipClass(this.position);
            var tip = createElement("div", {
                className: "e-arrow-tip " + this.tipClass
            });
            tip.appendChild(createElement("div", {
                className: "e-arrow-tip-outer " + this.tipClass
            })), tip.appendChild(createElement("div", {
                className: "e-arrow-tip-inner " + this.tipClass
            })), this.tooltipEle.appendChild(tip);
        }, Tooltip.prototype.setTipClass = function(position) {
            0 === position.indexOf("Right") ? this.tipClass = "e-tip-left" : 0 === position.indexOf("Bottom") ? this.tipClass = "e-tip-top" : 0 === position.indexOf("Left") ? this.tipClass = "e-tip-right" : this.tipClass = "e-tip-bottom";
        }, Tooltip.prototype.renderPopup = function(target) {
            var elePos = this.mouseTrail ? {
                top: 0,
                left: 0
            } : this.getTooltipPosition(target);
            this.popupObj = new Popup(this.tooltipEle, {
                height: this.height,
                width: this.width,
                position: {
                    X: elePos.left,
                    Y: elePos.top
                },
                enableRtl: this.enableRtl,
                open: this.openPopupHandler.bind(this),
                close: this.closePopupHandler.bind(this)
            });
        }, Tooltip.prototype.getTooltipPosition = function(target) {
            var pos = calculatePosition(target, this.tooltipPositionX, this.tooltipPositionY), offsetPos = this.calculateTooltipOffset(this.position);
            return this.collisionFlipFit(target, pos.left + offsetPos.left, pos.top + offsetPos.top);
        }, Tooltip.prototype.reposition = function(target) {
            var elePos = this.getTooltipPosition(target);
            this.popupObj.position = {
                X: elePos.left,
                Y: elePos.top
            }, this.popupObj.dataBind();
        }, Tooltip.prototype.openPopupHandler = function() {
            this.trigger("afterOpen", this.tooltipEventArgs);
        }, Tooltip.prototype.closePopupHandler = function() {
            this.clear(), this.trigger("afterClose", this.tooltipEventArgs);
        }, Tooltip.prototype.calculateTooltipOffset = function(position) {
            var pos = {
                top: 0,
                left: 0
            }, tooltipEleWidth = this.tooltipEle.offsetWidth, tooltipEleHeight = this.tooltipEle.offsetHeight, arrowEle = this.tooltipEle.querySelector(".e-arrow-tip"), tipWidth = arrowEle ? arrowEle.offsetWidth : 0, tipHeight = arrowEle ? arrowEle.offsetHeight : 0, tipAdjust = this.showTipPointer ? 0 : 8, tipHeightAdjust = tipHeight / 2 + 2 + (this.tooltipEle.offsetHeight - this.tooltipEle.clientHeight), tipWidthAdjust = tipWidth / 2 + 2 + (this.tooltipEle.offsetWidth - this.tooltipEle.clientWidth);
            switch (this.mouseTrail && (tipAdjust += 2), position) {
              case "RightTop":
                pos.left += tipWidth + tipAdjust, pos.top -= tooltipEleHeight - tipHeightAdjust;
                break;

              case "RightCenter":
                pos.left += tipWidth + tipAdjust, pos.top -= tooltipEleHeight / 2;
                break;

              case "RightBottom":
                pos.left += tipWidth + tipAdjust, pos.top -= tipHeightAdjust;
                break;

              case "BottomRight":
                pos.top += tipHeight + tipAdjust, pos.left -= tipWidthAdjust;
                break;

              case "BottomCenter":
                pos.top += tipHeight + tipAdjust, pos.left -= tooltipEleWidth / 2;
                break;

              case "BottomLeft":
                pos.top += tipHeight + tipAdjust, pos.left -= tooltipEleWidth - tipWidthAdjust;
                break;

              case "LeftBottom":
                pos.left -= tipWidth + tooltipEleWidth + tipAdjust, pos.top -= tipHeightAdjust;
                break;

              case "LeftCenter":
                pos.left -= tipWidth + tooltipEleWidth + tipAdjust, pos.top -= tooltipEleHeight / 2;
                break;

              case "LeftTop":
                pos.left -= tipWidth + tooltipEleWidth + tipAdjust, pos.top -= tooltipEleHeight - tipHeightAdjust;
                break;

              case "TopLeft":
                pos.top -= tooltipEleHeight + tipHeight + tipAdjust, pos.left -= tooltipEleWidth - tipWidthAdjust;
                break;

              case "TopRight":
                pos.top -= tooltipEleHeight + tipHeight + tipAdjust, pos.left -= tipWidthAdjust;
                break;

              default:
                pos.top -= tooltipEleHeight + tipHeight + tipAdjust, pos.left -= tooltipEleWidth / 2;
            }
            return pos.left += this.offsetX, pos.top += this.offsetY, pos;
        }, Tooltip.prototype.updateTipPosition = function(position) {
            var selEle = this.tooltipEle.querySelectorAll(".e-arrow-tip,.e-arrow-tip-outer,.e-arrow-tip-inner");
            removeClass(selEle, [ "e-tip-bottom", "e-tip-top", "e-tip-left", "e-tip-right" ]), 
            this.setTipClass(position), addClass(selEle, this.tipClass);
        }, Tooltip.prototype.adjustArrow = function(target, position, tooltipPositionX, tooltipPositionY) {
            if (!1 !== this.showTipPointer) {
                this.updateTipPosition(position);
                var leftValue, topValue, tooltipWidth = this.tooltipEle.clientWidth, tooltipHeight = this.tooltipEle.clientHeight, arrowEle = this.tooltipEle.querySelector(".e-arrow-tip"), arrowInnerELe = this.tooltipEle.querySelector(".e-arrow-tip-inner"), tipWidth = arrowEle.offsetWidth, tipHeight = arrowEle.offsetHeight;
                if ("e-tip-bottom" === this.tipClass || "e-tip-top" === this.tipClass) {
                    "e-tip-bottom" === this.tipClass ? (topValue = "99.9%", arrowInnerELe.style.top = "-" + (tipHeight - 2) + "px") : (topValue = -(tipHeight - 1) + "px", 
                    arrowInnerELe.style.top = "-" + (tipHeight - 6) + "px");
                    leftValue = (tipPosExclude = "Center" !== tooltipPositionX || tooltipWidth > target.offsetWidth || this.mouseTrail) && "Left" === tooltipPositionX || !tipPosExclude && "End" === this.tipPointerPosition ? tooltipWidth - tipWidth - 2 + "px" : tipPosExclude && "Right" === tooltipPositionX || !tipPosExclude && "Start" === this.tipPointerPosition ? "2px" : tooltipWidth / 2 - tipWidth / 2 + "px";
                } else {
                    "e-tip-right" === this.tipClass ? (leftValue = "99.9%", arrowInnerELe.style.left = "-" + (tipWidth - 2) + "px") : (leftValue = -(tipWidth - 1) + "px", 
                    arrowInnerELe.style.left = tipWidth - 2 - tipWidth + "px");
                    var tipPosExclude;
                    topValue = (tipPosExclude = "Center" !== tooltipPositionY || tooltipHeight > target.offsetHeight || this.mouseTrail) && "Top" === tooltipPositionY || !tipPosExclude && "End" === this.tipPointerPosition ? tooltipHeight - tipHeight - 2 + "px" : tipPosExclude && "Bottom" === tooltipPositionY || !tipPosExclude && "Start" === this.tipPointerPosition ? "2px" : tooltipHeight / 2 - tipHeight / 2 + "px";
                }
                arrowEle.style.top = topValue, arrowEle.style.left = leftValue;
            }
        }, Tooltip.prototype.renderContent = function(target) {
            var tooltipContent = this.tooltipEle.querySelector(".e-tip-content");
            if (target && !isNullOrUndefined(target.getAttribute("title")) && (target.setAttribute("data-content", target.getAttribute("title")), 
            target.removeAttribute("title")), isNullOrUndefined(this.content)) target && !isNullOrUndefined(target.getAttribute("data-content")) && (tooltipContent.innerHTML = target.getAttribute("data-content")); else if ("string" == typeof this.content) tooltipContent.innerHTML = this.content; else {
                for (;tooltipContent.firstChild; ) tooltipContent.removeChild(tooltipContent.firstChild);
                tooltipContent.appendChild(this.content);
            }
        }, Tooltip.prototype.renderCloseIcon = function() {
            if (this.isSticky) {
                var tipClose = createElement("div", {
                    className: "e-icons e-tooltip-close"
                });
                this.tooltipEle.appendChild(tipClose), EventHandler.add(tipClose, Browser.touchStartEvent, this.onStickyClose, this);
            }
        }, Tooltip.prototype.addDescribedBy = function(target, id) {
            var describedby = (target.getAttribute("aria-describedby") || "").split(/\s+/);
            describedby.indexOf(id) < 0 && describedby.push(id), attributes(target, {
                "aria-describedby": describedby.join(" ").trim(),
                "data-tooltip-id": id
            });
        }, Tooltip.prototype.removeDescribedBy = function(target) {
            var id = target.getAttribute("data-tooltip-id"), describedby = (target.getAttribute("aria-describedby") || "").split(/\s+/), index = describedby.indexOf(id);
            -1 !== index && describedby.splice(index, 1), target.removeAttribute("data-tooltip-id");
            var orgdescribedby = describedby.join(" ").trim();
            orgdescribedby ? target.setAttribute("aria-describedby", orgdescribedby) : target.removeAttribute("aria-describedby");
        }, Tooltip.prototype.tapHoldHandler = function(evt) {
            clearTimeout(this.autoCloseTimer), this.targetHover(evt.originalEvent);
        }, Tooltip.prototype.touchEndHandler = function(e) {
            var _this = this;
            if (!this.isSticky) {
                this.autoCloseTimer = setTimeout(function() {
                    _this.close();
                }, 1500);
            }
        }, Tooltip.prototype.targetClick = function(e) {
            var target;
            isNullOrUndefined(target = this.target ? closest(e.target, this.target) : this.element) || (null === target.getAttribute("data-tooltip-id") ? this.targetHover(e) : this.isSticky || this.hideTooltip(this.animation.close, e, target));
        }, Tooltip.prototype.targetHover = function(e) {
            var target;
            if (target = this.target ? closest(e.target, this.target) : this.element, !isNullOrUndefined(target) && null === target.getAttribute("data-tooltip-id")) {
                for (var _i = 0, targetList_1 = [].slice.call(document.querySelectorAll("[data-tooltip-id= " + this.ctrlId + "_content]")); _i < targetList_1.length; _i++) {
                    var target_1 = targetList_1[_i];
                    this.restoreElement(target_1);
                }
                this.showTooltip(target, this.animation.open, e), this.wireMouseEvents(e, target);
            }
        }, Tooltip.prototype.showTooltip = function(target, showAnimation, e) {
            var _this = this;
            if (clearTimeout(this.showTimer), clearTimeout(this.hideTimer), this.tooltipEventArgs = e ? {
                type: e.type,
                cancel: !1,
                target: target,
                event: e,
                element: this.tooltipEle
            } : {
                type: null,
                cancel: !1,
                target: target,
                event: null,
                element: this.tooltipEle
            }, this.trigger("beforeRender", this.tooltipEventArgs), this.tooltipEventArgs.cancel) return this.isHidden = !0, 
            void this.clear();
            if (this.isHidden = !1, isNullOrUndefined(this.tooltipEle) ? (this.ctrlId = this.element.getAttribute("id") ? getUniqueID(this.element.getAttribute("id")) : getUniqueID("tooltip"), 
            this.tooltipEle = createElement("div", {
                className: "e-tooltip-wrap e-popup",
                attrs: {
                    role: "tooltip",
                    "aria-hidden": "false",
                    id: this.ctrlId + "_content"
                },
                styles: "width:" + formatUnit(this.width) + ";height:" + formatUnit(this.height) + ";position:absolute;"
            }), this.cssClass && addClass([ this.tooltipEle ], this.cssClass.split(" ")), Browser.isDevice && addClass([ this.tooltipEle ], "e-bigger"), 
            "auto" !== this.width && (this.tooltipEle.style.maxWidth = formatUnit(this.width)), 
            this.tooltipEle.appendChild(createElement("div", {
                className: "e-tip-content"
            })), document.body.appendChild(this.tooltipEle), this.addDescribedBy(target, this.ctrlId + "_content"), 
            this.renderContent(target), addClass([ this.tooltipEle ], "e-popup-open"), this.showTipPointer && this.renderArrow(), 
            this.renderCloseIcon(), this.renderPopup(target)) : (this.adjustArrow(target, this.position, this.tooltipPositionX, this.tooltipPositionY), 
            this.addDescribedBy(target, this.ctrlId + "_content"), this.renderContent(target), 
            Animation.stop(this.tooltipEle), this.reposition(target)), removeClass([ this.tooltipEle ], "e-popup-open"), 
            addClass([ this.tooltipEle ], "e-popup-close"), this.tooltipEventArgs = e ? {
                type: e.type,
                cancel: !1,
                target: target,
                event: e,
                element: this.tooltipEle
            } : {
                type: null,
                cancel: !1,
                target: target,
                event: null,
                element: this.tooltipEle
            }, this.trigger("beforeOpen", this.tooltipEventArgs), this.tooltipEventArgs.cancel) return this.isHidden = !0, 
            void this.clear();
            var openAnimation = {
                name: showAnimation.effect,
                duration: showAnimation.duration,
                delay: showAnimation.delay,
                timingFunction: "easeOut"
            };
            if ("None" === showAnimation.effect && (openAnimation = void 0), this.openDelay > 0) {
                this.showTimer = setTimeout(function() {
                    _this.popupObj && _this.popupObj.show(openAnimation);
                }, this.openDelay);
            } else this.popupObj.show(openAnimation);
        }, Tooltip.prototype.checkCollision = function(target, x, y) {
            var elePos = {
                left: x,
                top: y,
                position: this.position,
                horizontal: this.tooltipPositionX,
                vertical: this.tooltipPositionY
            }, affectedPos = isCollide(this.tooltipEle, this.target ? this.element : null, x, y);
            return affectedPos.length > 0 && (elePos.horizontal = affectedPos.indexOf("left") >= 0 ? "Right" : affectedPos.indexOf("right") >= 0 ? "Left" : this.tooltipPositionX, 
            elePos.vertical = affectedPos.indexOf("top") >= 0 ? "Bottom" : affectedPos.indexOf("bottom") >= 0 ? "Top" : this.tooltipPositionY), 
            elePos;
        }, Tooltip.prototype.collisionFlipFit = function(target, x, y) {
            var elePos = this.checkCollision(target, x, y), newpos = elePos.position;
            if (this.tooltipPositionY !== elePos.vertical && (newpos = 0 === this.position.indexOf("Bottom") || 0 === this.position.indexOf("Top") ? elePos.vertical + this.tooltipPositionX : this.tooltipPositionX + elePos.vertical), 
            this.tooltipPositionX !== elePos.horizontal && (0 === newpos.indexOf("Left") && (elePos.vertical = "LeftTop" === newpos || "LeftCenter" === newpos ? "Top" : "Bottom", 
            newpos = elePos.vertical + "Left"), 0 === newpos.indexOf("Right") && (elePos.vertical = "RightTop" === newpos || "RightCenter" === newpos ? "Top" : "Bottom", 
            newpos = elePos.vertical + "Right"), elePos.horizontal = this.tooltipPositionX), 
            this.tooltipEventArgs = {
                type: null,
                cancel: !1,
                target: target,
                event: null,
                element: this.tooltipEle,
                collidedPosition: newpos
            }, this.trigger("beforeCollision", this.tooltipEventArgs), elePos.position !== newpos) {
                var pos = calculatePosition(target, this.tooltipPositionX, elePos.vertical);
                this.adjustArrow(target, newpos, elePos.horizontal, elePos.vertical);
                var offsetPos = this.calculateTooltipOffset(newpos);
                elePos.position = newpos, elePos.left = pos.left + offsetPos.left, elePos.top = pos.top + offsetPos.top;
            } else this.adjustArrow(target, newpos, elePos.horizontal, elePos.vertical);
            var eleOffset = {
                left: elePos.left,
                top: elePos.top
            }, left = fit(this.tooltipEle, this.target ? this.element : null, {
                X: !0,
                Y: !1
            }, eleOffset).left;
            if (this.showTipPointer && (0 === newpos.indexOf("Bottom") || 0 === newpos.indexOf("Top"))) {
                var arrowEle = this.tooltipEle.querySelector(".e-arrow-tip"), arrowleft = parseInt(arrowEle.style.left, 10) - (left - elePos.left);
                arrowleft < 0 ? arrowleft = 0 : arrowleft + arrowEle.offsetWidth > this.tooltipEle.clientWidth && (arrowleft = this.tooltipEle.clientWidth - arrowEle.offsetWidth), 
                arrowEle.style.left = arrowleft.toString() + "px";
            }
            return eleOffset.left = left, eleOffset;
        }, Tooltip.prototype.hideTooltip = function(hideAnimation, e, targetElement) {
            var target, _this = this;
            if (e ? (target = this.target ? targetElement || e.target : this.element, this.tooltipEventArgs = {
                type: e.type,
                cancel: !1,
                target: target,
                event: e,
                element: this.tooltipEle
            }) : (target = document.querySelector("[data-tooltip-id= " + this.ctrlId + "_content]"), 
            this.tooltipEventArgs = {
                type: null,
                cancel: !1,
                target: target,
                event: null,
                element: this.tooltipEle
            }), !isNullOrUndefined(target)) if (this.trigger("beforeClose", this.tooltipEventArgs), 
            this.tooltipEventArgs.cancel) this.isHidden = !1; else {
                this.restoreElement(target), this.isHidden = !0;
                var closeAnimation_1 = {
                    name: hideAnimation.effect,
                    duration: hideAnimation.duration,
                    delay: hideAnimation.delay,
                    timingFunction: "easeIn"
                };
                if ("None" === hideAnimation.effect && (closeAnimation_1 = void 0), this.closeDelay > 0) {
                    this.hideTimer = setTimeout(function() {
                        _this.popupObj && _this.popupObj.hide(closeAnimation_1);
                    }, this.closeDelay);
                } else this.popupObj.hide(closeAnimation_1);
            }
        }, Tooltip.prototype.restoreElement = function(target) {
            this.unwireMouseEvents(target), isNullOrUndefined(target.getAttribute("data-content")) || (target.setAttribute("title", target.getAttribute("data-content")), 
            target.removeAttribute("data-content")), this.removeDescribedBy(target);
        }, Tooltip.prototype.clear = function() {
            this.tooltipEle && (removeClass([ this.tooltipEle ], "e-popup-close"), addClass([ this.tooltipEle ], "e-popup-open")), 
            this.isHidden && (this.popupObj && this.popupObj.destroy(), this.tooltipEle && remove(this.tooltipEle), 
            this.tooltipEle = null, this.popupObj = null);
        }, Tooltip.prototype.onMouseOut = function(e) {
            this.hideTooltip(this.animation.close, e);
        }, Tooltip.prototype.onStickyClose = function(e) {
            this.close();
        }, Tooltip.prototype.onMouseMove = function(event) {
            var eventPageX = 0, eventPageY = 0;
            event.type.indexOf("touch") > -1 ? (event.preventDefault(), eventPageX = event.touches[0].pageX, 
            eventPageY = event.touches[0].pageY) : (eventPageX = event.pageX, eventPageY = event.pageY), 
            Animation.stop(this.tooltipEle), removeClass([ this.tooltipEle ], "e-popup-close"), 
            addClass([ this.tooltipEle ], "e-popup-open"), this.adjustArrow(event.target, this.position, this.tooltipPositionX, this.tooltipPositionY);
            var pos = this.calculateTooltipOffset(this.position), x = eventPageX + pos.left + this.offsetX, y = eventPageY + pos.top + this.offsetY, elePos = this.checkCollision(event.target, x, y);
            if (this.tooltipPositionX !== elePos.horizontal || this.tooltipPositionY !== elePos.vertical) {
                var newpos = 0 === this.position.indexOf("Bottom") || 0 === this.position.indexOf("Top") ? elePos.vertical + elePos.horizontal : elePos.horizontal + elePos.vertical;
                elePos.position = newpos, this.adjustArrow(event.target, elePos.position, elePos.horizontal, elePos.vertical);
                var colpos = this.calculateTooltipOffset(elePos.position);
                elePos.left = eventPageX + colpos.left - this.offsetX, elePos.top = eventPageY + colpos.top - this.offsetY;
            }
            this.tooltipEle.style.left = elePos.left + "px", this.tooltipEle.style.top = elePos.top + "px";
        }, Tooltip.prototype.keyDown = function(event) {
            this.tooltipEle && 27 === event.keyCode && this.close();
        }, Tooltip.prototype.touchEnd = function(e) {
            this.tooltipEle && null === closest(e.target, ".e-tooltip") && this.close();
        }, Tooltip.prototype.scrollHandler = function(e) {
            this.tooltipEle && this.close();
        }, Tooltip.prototype.render = function() {
            this.initialize(), this.wireEvents(this.opensOn);
        }, Tooltip.prototype.preRender = function() {
            this.tipClass = "e-tip-bottom", this.tooltipPositionX = "Center", this.tooltipPositionY = "Top", 
            this.isHidden = !0;
        }, Tooltip.prototype.wireEvents = function(trigger) {
            for (var _i = 0, triggerList_1 = this.getTriggerList(trigger); _i < triggerList_1.length; _i++) {
                var opensOn = triggerList_1[_i];
                if ("Custom" === opensOn) return;
                "Focus" === opensOn && this.wireFocusEvents(), "Click" === opensOn && EventHandler.add(this.element, Browser.touchStartEvent, this.targetClick, this), 
                "Hover" === opensOn && (Browser.isDevice ? (this.touchModule = new Touch(this.element, {
                    tapHoldThreshold: 500,
                    tapHold: this.tapHoldHandler.bind(this)
                }), EventHandler.add(this.element, Browser.touchEndEvent, this.touchEndHandler, this)) : EventHandler.add(this.element, "mouseover", this.targetHover, this));
            }
            EventHandler.add(document, "touchend", this.touchEnd, this), EventHandler.add(document, "scroll", this.scrollHandler, this), 
            EventHandler.add(document, "keydown", this.keyDown, this);
        }, Tooltip.prototype.getTriggerList = function(trigger) {
            return "Auto" === trigger && (trigger = Browser.isDevice ? "Hover" : "Hover Focus"), 
            trigger.split(" ");
        }, Tooltip.prototype.wireFocusEvents = function() {
            if (isNullOrUndefined(this.target)) EventHandler.add(this.element, "focus", this.targetHover, this); else for (var _i = 0, targetList_2 = [].slice.call(this.element.querySelectorAll(this.target)); _i < targetList_2.length; _i++) {
                var target = targetList_2[_i];
                EventHandler.add(target, "focus", this.targetHover, this);
            }
        }, Tooltip.prototype.wireMouseEvents = function(e, target) {
            this.tooltipEle && (this.isSticky || ("focus" === e.type && EventHandler.add(target, "blur", this.onMouseOut, this), 
            "mouseover" === e.type && EventHandler.add(target, "mouseleave", this.onMouseOut, this)), 
            this.mouseTrail && EventHandler.add(target, "mousemove touchstart mouseenter", this.onMouseMove, this));
        }, Tooltip.prototype.unwireEvents = function(trigger) {
            for (var _i = 0, triggerList_2 = this.getTriggerList(trigger); _i < triggerList_2.length; _i++) {
                var opensOn = triggerList_2[_i];
                if ("Custom" === opensOn) return;
                "Focus" === opensOn && this.unwireFocusEvents(), "Click" === opensOn && EventHandler.remove(this.element, Browser.touchStartEvent, this.targetClick), 
                "Hover" === opensOn && (Browser.isDevice ? (this.touchModule && this.touchModule.destroy(), 
                EventHandler.remove(this.element, Browser.touchEndEvent, this.touchEndHandler)) : EventHandler.remove(this.element, "mouseover", this.targetHover));
            }
            EventHandler.remove(document, "touchend", this.touchEnd), EventHandler.remove(document, "scroll", this.scrollHandler), 
            EventHandler.remove(document, "keydown", this.keyDown);
        }, Tooltip.prototype.unwireFocusEvents = function() {
            if (isNullOrUndefined(this.target)) EventHandler.remove(this.element, "focus", this.targetHover); else for (var _i = 0, targetList_3 = [].slice.call(this.element.querySelectorAll(this.target)); _i < targetList_3.length; _i++) {
                var target = targetList_3[_i];
                EventHandler.remove(target, "focus", this.targetHover);
            }
        }, Tooltip.prototype.unwireMouseEvents = function(target) {
            if (!this.isSticky) for (var _i = 0, triggerList_3 = this.getTriggerList(this.opensOn); _i < triggerList_3.length; _i++) {
                var opensOn = triggerList_3[_i];
                "Focus" === opensOn && EventHandler.remove(target, "blur", this.onMouseOut), "Hover" !== opensOn || Browser.isDevice || EventHandler.remove(target, "mouseleave", this.onMouseOut);
            }
            this.mouseTrail && EventHandler.remove(target, "mousemove touchstart mouseenter", this.onMouseMove);
        }, Tooltip.prototype.getModuleName = function() {
            return "tooltip";
        }, Tooltip.prototype.getPersistData = function() {
            return this.addOnPersist([]);
        }, Tooltip.prototype.onPropertyChanged = function(newProp, oldProp) {
            for (var _i = 0, _a = Object.keys(newProp); _i < _a.length; _i++) {
                switch (_a[_i]) {
                  case "width":
                    this.tooltipEle && (this.tooltipEle.style.width = formatUnit(newProp.width));
                    break;

                  case "height":
                    this.tooltipEle && (this.tooltipEle.style.height = formatUnit(newProp.height));
                    break;

                  case "content":
                    this.tooltipEle && this.renderContent();
                    break;

                  case "opensOn":
                    this.unwireEvents(oldProp.opensOn), this.wireEvents(newProp.opensOn);
                    break;

                  case "position":
                    this.formatPosition();
                    var target = document.querySelector("[data-tooltip-id= " + this.ctrlId + "_content]");
                    if (this.tooltipEle && target) {
                        var arrowInnerELe = this.tooltipEle.querySelector(".e-arrow-tip-inner");
                        arrowInnerELe.style.top = arrowInnerELe.style.left = null, this.reposition(target);
                    }
                    break;

                  case "tipPointerPosition":
                    var trgt = document.querySelector("[data-tooltip-id= " + this.ctrlId + "_content]");
                    this.tooltipEle && trgt && this.reposition(trgt);
                    break;

                  case "offsetX":
                    if (this.tooltipEle) {
                        var x = newProp.offsetX - oldProp.offsetX;
                        this.tooltipEle.style.left = (parseInt(this.tooltipEle.style.left, 10) + x).toString() + "px";
                    }
                    break;

                  case "offsetY":
                    if (this.tooltipEle) {
                        var y = newProp.offsetY - oldProp.offsetY;
                        this.tooltipEle.style.top = (parseInt(this.tooltipEle.style.top, 10) + y).toString() + "px";
                    }
                    break;

                  case "cssClass":
                    this.tooltipEle && (oldProp.cssClass && removeClass([ this.tooltipEle ], oldProp.cssClass.split(" ")), 
                    newProp.cssClass && addClass([ this.tooltipEle ], newProp.cssClass.split(" ")));
                    break;

                  case "enableRtl":
                    this.tooltipEle && (this.enableRtl ? addClass([ this.tooltipEle ], "e-rtl") : removeClass([ this.tooltipEle ], "e-rtl"));
                }
            }
        }, Tooltip.prototype.open = function(element, animation) {
            void 0 === animation && (animation = this.animation.open), "none" !== element.style.display && this.showTooltip(element, animation);
        }, Tooltip.prototype.close = function(animation) {
            void 0 === animation && (animation = this.animation.close), this.hideTooltip(animation);
        }, Tooltip.prototype.refresh = function(target) {
            this.tooltipEle && this.renderContent(target), this.popupObj && target && this.reposition(target);
        }, Tooltip.prototype.destroy = function() {
            _super.prototype.destroy.call(this), removeClass([ this.element ], "e-tooltip"), 
            this.unwireEvents(this.opensOn), this.popupObj && this.popupObj.destroy(), this.tooltipEle && remove(this.tooltipEle), 
            this.tooltipEle = null, this.popupObj = null;
        }, __decorate$2$2([ Property("auto") ], Tooltip.prototype, "width", void 0), __decorate$2$2([ Property("auto") ], Tooltip.prototype, "height", void 0), 
        __decorate$2$2([ Property() ], Tooltip.prototype, "content", void 0), __decorate$2$2([ Property() ], Tooltip.prototype, "target", void 0), 
        __decorate$2$2([ Property("TopCenter") ], Tooltip.prototype, "position", void 0), 
        __decorate$2$2([ Property(0) ], Tooltip.prototype, "offsetX", void 0), __decorate$2$2([ Property(0) ], Tooltip.prototype, "offsetY", void 0), 
        __decorate$2$2([ Property(!0) ], Tooltip.prototype, "showTipPointer", void 0), __decorate$2$2([ Property("Auto") ], Tooltip.prototype, "tipPointerPosition", void 0), 
        __decorate$2$2([ Property("Auto") ], Tooltip.prototype, "opensOn", void 0), __decorate$2$2([ Property(!1) ], Tooltip.prototype, "mouseTrail", void 0), 
        __decorate$2$2([ Property(!1) ], Tooltip.prototype, "isSticky", void 0), __decorate$2$2([ Complex({}, Animation$1) ], Tooltip.prototype, "animation", void 0), 
        __decorate$2$2([ Property(0) ], Tooltip.prototype, "openDelay", void 0), __decorate$2$2([ Property(0) ], Tooltip.prototype, "closeDelay", void 0), 
        __decorate$2$2([ Property() ], Tooltip.prototype, "cssClass", void 0), __decorate$2$2([ Property(!1) ], Tooltip.prototype, "enableRtl", void 0), 
        __decorate$2$2([ Event() ], Tooltip.prototype, "beforeRender", void 0), __decorate$2$2([ Event() ], Tooltip.prototype, "beforeOpen", void 0), 
        __decorate$2$2([ Event() ], Tooltip.prototype, "afterOpen", void 0), __decorate$2$2([ Event() ], Tooltip.prototype, "beforeClose", void 0), 
        __decorate$2$2([ Event() ], Tooltip.prototype, "afterClose", void 0), __decorate$2$2([ Event() ], Tooltip.prototype, "beforeCollision", void 0), 
        __decorate$2$2([ Event() ], Tooltip.prototype, "created", void 0), __decorate$2$2([ Event() ], Tooltip.prototype, "destroyed", void 0), 
        Tooltip = __decorate$2$2([ NotifyPropertyChanges ], Tooltip);
    }(Component), globalTimeOut = {}, spinTemplate = null, spinCSSClass = null, DEFT_MAT_WIDTH = 30, DEFT_FAB_WIDTH = 30, DEFT_BOOT_WIDTH = 30, CLS_SHOWSPIN = "e-spin-show", CLS_HIDESPIN = "e-spin-hide", CLS_MATERIALSPIN = "e-spin-material", CLS_FABRICSPIN = "e-spin-fabric", CLS_BOOTSPIN = "e-spin-bootstrap", CLS_HIGHCONTRASTSPIN = "e-spin-high-contrast", CLS_SPINWRAP = "e-spinner-pane", CLS_SPININWRAP = "e-spinner-inner", CLS_SPINCIRCLE = "e-path-circle", CLS_SPINARC = "e-path-arc", CLS_SPINLABEL = "e-spin-label", CLS_SPINTEMPLATE = "e-spin-template", _popups = Object.freeze({
        PositionData: PositionData,
        Popup: Popup,
        getScrollableParent: getScrollableParent,
        getZindexPartial: getZindexPartial,
        calculateRelativeBasedPosition: calculateRelativeBasedPosition,
        calculatePosition: calculatePosition,
        fit: fit,
        isCollide: isCollide,
        flip: flip,
        ButtonProps: ButtonProps,
        AnimationSettings: AnimationSettings,
        Dialog: Dialog,
        Animation: Animation$1,
        Tooltip: Tooltip,
        createSpinner: createSpinner,
        showSpinner: showSpinner,
        hideSpinner: hideSpinner,
        setSpinner: function(args) {
            void 0 !== args.template && (spinTemplate = args.template, void 0 !== args.template && (spinCSSClass = args.cssClass));
            for (var container = document.querySelectorAll("." + CLS_SPINWRAP), index = 0; index < container.length; index++) !function(template, container, theme, cssClass) {
                isNullOrUndefined(template) && !container.classList.contains(CLS_SPINTEMPLATE) ? (function(container, theme, cssClass) {
                    isNullOrUndefined(cssClass) || container.classList.add(cssClass);
                    var svgElement = container.querySelector("svg"), radius = "Bootstrap" === theme ? parseFloat(svgElement.style.height) : parseFloat(svgElement.style.height) / 2;
                    if (svgElement.getAttribute("class").split(/\s/).indexOf("e-spin-material") >= 0) {
                        var id = svgElement.getAttribute("id");
                        clearTimeout(globalTimeOut[id].timeOut);
                    }
                    setTheme(theme, container, radius);
                }(container, theme, cssClass), container.classList.contains(CLS_SHOWSPIN) ? (container.classList.remove(CLS_SHOWSPIN), 
                showSpinner(container)) : (container.classList.remove(CLS_HIDESPIN), hideSpinner(container))) : (spinTemplate = template, 
                isNullOrUndefined(cssClass) || (spinCSSClass = cssClass));
            }(args.template, container[index], args.type, args.cssClass);
        }
    }), CLASSNAMES$1 = {
        RTL: "e-rtl",
        DISABLE: "e-disabled",
        INPUT: "e-input",
        INPUTGROUP: "e-input-group",
        FLOATINPUT: "e-float-input",
        FLOATLINE: "e-float-line",
        FLOATTEXT: "e-float-text",
        CLEARICON: "e-clear-icon",
        CLEARICONHIDE: "e-clear-icon-hide",
        LABELTOP: "e-label-top",
        LABELBOTTOM: "e-label-bottom",
        NOFLOATLABEL: "e-no-float-label",
        INPUTCUSTOMTAG: "e-input-custom-tag",
        FLOATCUSTOMTAG: "e-float-custom-tag"
    };
    !function(Input) {
        function _focusFn() {
            var label = getParentNode(this).getElementsByClassName("e-float-text")[0];
            addClass([ label ], CLASSNAMES$1.LABELTOP), label.classList.contains(CLASSNAMES$1.LABELBOTTOM) && removeClass([ label ], CLASSNAMES$1.LABELBOTTOM);
        }
        function _blurFn() {
            var parent = getParentNode(this);
            if ("" === parent.getElementsByTagName("input")[0].value) {
                var label = parent.getElementsByClassName("e-float-text")[0];
                label.classList.contains(CLASSNAMES$1.LABELTOP) && removeClass([ label ], CLASSNAMES$1.LABELTOP), 
                addClass([ label ], CLASSNAMES$1.LABELBOTTOM);
            }
        }
        function createFloatingInput(args, inputObject) {
            var floatLinelement, floatLabelElement;
            "Auto" === args.floatLabelType && function(element) {
                element.addEventListener("focus", _focusFn), element.addEventListener("blur", _blurFn);
            }(args.element), isNullOrUndefined(inputObject.container) ? (inputObject.container = createInputContainer(args, CLASSNAMES$1.FLOATINPUT, CLASSNAMES$1.FLOATCUSTOMTAG, "div"), 
            args.element.parentNode.insertBefore(inputObject.container, args.element)) : (isNullOrUndefined(args.customTag) || inputObject.container.classList.add(CLASSNAMES$1.FLOATCUSTOMTAG), 
            inputObject.container.classList.add(CLASSNAMES$1.FLOATINPUT)), floatLinelement = createElement("span", {
                className: CLASSNAMES$1.FLOATLINE
            }), floatLabelElement = createElement("label", {
                className: CLASSNAMES$1.FLOATTEXT
            }), isNullOrUndefined(args.element.id) || "" === args.element.id || (floatLabelElement.id = "label_" + args.element.id.replace(/ /g, "_"), 
            attributes(args.element, {
                "aria-labelledby": floatLabelElement.id
            })), isNullOrUndefined(args.element.placeholder) || "" === args.element.placeholder || (floatLabelElement.innerHTML = args.element.placeholder, 
            args.element.removeAttribute("placeholder")), isNullOrUndefined(args.properties) || isNullOrUndefined(args.properties.placeholder) || "" === args.properties.placeholder || (floatLabelElement.innerHTML = args.properties.placeholder), 
            floatLabelElement.innerHTML || inputObject.container.classList.add(CLASSNAMES$1.NOFLOATLABEL), 
            inputObject.container.appendChild(args.element), inputObject.container.appendChild(floatLinelement), 
            inputObject.container.appendChild(floatLabelElement), updateLabelState(args.element.value, floatLabelElement), 
            "Always" === args.floatLabelType && (floatLabelElement.classList.contains(CLASSNAMES$1.LABELBOTTOM) && removeClass([ floatLabelElement ], CLASSNAMES$1.LABELBOTTOM), 
            addClass([ floatLabelElement ], CLASSNAMES$1.LABELTOP)), "Auto" === args.floatLabelType && (args.element.addEventListener("input", function(event) {
                updateLabelState(args.element.value, floatLabelElement);
            }), args.element.addEventListener("blur", function(event) {
                updateLabelState(args.element.value, floatLabelElement);
            }));
        }
        function updateIconState(value, button) {
            value ? removeClass([ button ], CLASSNAMES$1.CLEARICONHIDE) : addClass([ button ], CLASSNAMES$1.CLEARICONHIDE);
        }
        function updateLabelState(value, label) {
            value ? (addClass([ label ], CLASSNAMES$1.LABELTOP), label.classList.contains(CLASSNAMES$1.LABELBOTTOM) && removeClass([ label ], CLASSNAMES$1.LABELBOTTOM)) : (label.classList.contains(CLASSNAMES$1.LABELTOP) && removeClass([ label ], CLASSNAMES$1.LABELTOP), 
            addClass([ label ], CLASSNAMES$1.LABELBOTTOM));
        }
        function getParentNode(element) {
            return element.parentNode;
        }
        function createClearButton(element, inputObject, initial) {
            var button = createElement("span", {
                className: CLASSNAMES$1.CLEARICON
            }), container = inputObject.container;
            if (isNullOrUndefined(initial)) {
                (inputObject.container.classList.contains(CLASSNAMES$1.FLOATINPUT) ? inputObject.container.querySelector("." + CLASSNAMES$1.FLOATTEXT) : element).insertAdjacentElement("afterend", button);
            } else container.appendChild(button);
            return !isNullOrUndefined(container) && container.classList.contains(CLASSNAMES$1.FLOATINPUT) && addClass([ container ], CLASSNAMES$1.INPUTGROUP), 
            addClass([ button ], CLASSNAMES$1.CLEARICONHIDE), function(element, button) {
                button.addEventListener("click", function(event) {
                    element.classList.contains(CLASSNAMES$1.DISABLE) || element.readOnly || (event.preventDefault(), 
                    element !== document.activeElement && element.focus(), element.value = "", addClass([ button ], CLASSNAMES$1.CLEARICONHIDE));
                }), element.addEventListener("input", function(event) {
                    updateIconState(element.value, button);
                }), element.addEventListener("focus", function(event) {
                    updateIconState(element.value, button);
                }), element.addEventListener("blur", function(event) {
                    setTimeout(function() {
                        addClass([ button ], CLASSNAMES$1.CLEARICONHIDE);
                    }, 200);
                });
            }(element, button), button;
        }
        function validateLabel(element, floatLabelType) {
            if (getParentNode(element).classList.contains(CLASSNAMES$1.FLOATINPUT) && "Auto" === floatLabelType) {
                var label = getParentNode(element).getElementsByClassName("e-float-text")[0];
                updateLabelState(element.value, label);
            }
        }
        function createInputContainer(args, className, tagClass, tag) {
            var container;
            return isNullOrUndefined(args.customTag) ? container = createElement(tag, {
                className: className
            }) : (container = createElement(args.customTag, {
                className: className
            })).classList.add(tagClass), container.classList.add("e-control-wrapper"), container;
        }
        function setCssClass(cssClass, elements, oldClass) {
            isNullOrUndefined(oldClass) || "" === oldClass || removeClass(elements, oldClass), 
            isNullOrUndefined(cssClass) || "" === cssClass || addClass(elements, cssClass);
        }
        function setPlaceholder(placeholder, element) {
            var parentElement;
            (parentElement = getParentNode(element)).classList.contains(CLASSNAMES$1.FLOATINPUT) ? isNullOrUndefined(placeholder) || "" === placeholder ? (parentElement.classList.add(CLASSNAMES$1.NOFLOATLABEL), 
            parentElement.getElementsByClassName(CLASSNAMES$1.FLOATTEXT)[0].textContent = "") : (parentElement.getElementsByClassName(CLASSNAMES$1.FLOATTEXT)[0].textContent = placeholder, 
            parentElement.classList.remove(CLASSNAMES$1.NOFLOATLABEL)) : isNullOrUndefined(placeholder) || "" === placeholder ? (element.removeAttribute("placeholder"), 
            element.removeAttribute("aria-placeholder")) : attributes(element, {
                placeholder: placeholder,
                "aria-placeholder": placeholder
            });
        }
        function setReadonly(isReadonly, element, floatLabelType) {
            isReadonly ? attributes(element, {
                readonly: ""
            }) : element.removeAttribute("readonly"), isNullOrUndefined(floatLabelType) || validateLabel(element, floatLabelType);
        }
        function setEnableRtl(isRtl, elements) {
            isRtl ? addClass(elements, CLASSNAMES$1.RTL) : removeClass(elements, CLASSNAMES$1.RTL);
        }
        function setEnabled(isEnable, element, floatLabelType) {
            var disabledAttrs = {
                disabled: "disabled",
                "aria-disabled": "true"
            };
            isEnable ? (element.classList.remove(CLASSNAMES$1.DISABLE), removeAttributes(disabledAttrs, element)) : (element.classList.add(CLASSNAMES$1.DISABLE), 
            addAttributes(disabledAttrs, element)), isNullOrUndefined(floatLabelType) || validateLabel(element, floatLabelType);
        }
        function setClearButton(isClear, element, inputObject, initial) {
            isClear ? inputObject.clearButton = createClearButton(element, inputObject, initial) : (inputObject.clearButton.remove(), 
            inputObject.clearButton = null);
        }
        function removeAttributes(attrs, element) {
            for (var _i = 0, _a = Object.keys(attrs); _i < _a.length; _i++) {
                var key = _a[_i], parentElement = void 0;
                parentElement = getParentNode(element), "disabled" === key && element.classList.remove(CLASSNAMES$1.DISABLE), 
                "disabled" === key && parentElement.classList.contains(CLASSNAMES$1.INPUTGROUP) && parentElement.classList.remove(CLASSNAMES$1.DISABLE), 
                "placeholder" === key && parentElement.classList.contains(CLASSNAMES$1.FLOATINPUT) ? parentElement.getElementsByClassName(CLASSNAMES$1.FLOATTEXT)[0].textContent = "" : element.removeAttribute(key);
            }
        }
        function addAttributes(attrs, element) {
            for (var _i = 0, _a = Object.keys(attrs); _i < _a.length; _i++) {
                var key = _a[_i], parentElement = void 0;
                parentElement = getParentNode(element), "disabled" === key && element.classList.add(CLASSNAMES$1.DISABLE), 
                "disabled" === key && parentElement.classList.contains(CLASSNAMES$1.INPUTGROUP) && parentElement.classList.add(CLASSNAMES$1.DISABLE), 
                "placeholder" === key && parentElement.classList.contains(CLASSNAMES$1.FLOATINPUT) ? parentElement.getElementsByClassName(CLASSNAMES$1.FLOATTEXT)[0].textContent = attrs[key] : element.setAttribute(key, attrs[key]);
            }
        }
        function appendSpan(iconClass, container) {
            var button = createElement("span", {
                className: iconClass
            });
            return container.appendChild(button), container.classList.contains(CLASSNAMES$1.INPUTGROUP) || container.classList.add(CLASSNAMES$1.INPUTGROUP), 
            button.addEventListener("mousedown", function() {
                container.classList.contains("e-disabled") || container.querySelector("input").readOnly || this.classList.add("e-input-btn-ripple");
            }), button.addEventListener("mouseup", function() {
                var ele = this;
                setTimeout(function() {
                    ele.classList.remove("e-input-btn-ripple");
                }, 500);
            }), button;
        }
        Input.createInput = function(args) {
            var inputObject = {
                container: null,
                buttons: [],
                clearButton: null
            };
            if (isNullOrUndefined(args.floatLabelType) || "Never" === args.floatLabelType ? (inputObject.container = createInputContainer(args, CLASSNAMES$1.INPUTGROUP, CLASSNAMES$1.INPUTCUSTOMTAG, "span"), 
            args.element.parentNode.insertBefore(inputObject.container, args.element), addClass([ args.element ], CLASSNAMES$1.INPUT), 
            inputObject.container.appendChild(args.element)) : createFloatingInput(args, inputObject), 
            args.element.addEventListener("focus", function() {
                var parent = getParentNode(this);
                parent.classList.contains("e-input-group") && parent.classList.add("e-input-focus");
            }), args.element.addEventListener("blur", function() {
                var parent = getParentNode(this);
                parent.classList.contains("e-input-group") && parent.classList.remove("e-input-focus");
            }), isNullOrUndefined(args.properties) || isNullOrUndefined(args.properties.showClearButton) || !args.properties.showClearButton || (setClearButton(args.properties.showClearButton, args.element, inputObject, !0), 
            inputObject.container.classList.contains(CLASSNAMES$1.FLOATINPUT) && addClass([ inputObject.container ], CLASSNAMES$1.INPUTGROUP)), 
            !isNullOrUndefined(args.buttons)) for (var i = 0; i < args.buttons.length; i++) inputObject.buttons.push(appendSpan(args.buttons[i], inputObject.container));
            return inputObject = function(args, inputObject) {
                if (!isNullOrUndefined(args.properties)) for (var _i = 0, _a = Object.keys(args.properties); _i < _a.length; _i++) {
                    var prop = _a[_i];
                    switch (prop) {
                      case "cssClass":
                        setCssClass(args.properties.cssClass, [ inputObject.container ]);
                        break;

                      case "enabled":
                        setEnabled(args.properties.enabled, args.element);
                        break;

                      case "enableRtl":
                        setEnableRtl(args.properties.enableRtl, [ inputObject.container ]);
                        break;

                      case "placeholder":
                        setPlaceholder(args.properties.placeholder, args.element);
                        break;

                      case "readonly":
                        setReadonly(args.properties.readonly, args.element);
                    }
                }
                return inputObject;
            }(args, inputObject);
        }, Input.setValue = function(value, element, floatLabelType, clearButton) {
            if (element.value = value, isNullOrUndefined(floatLabelType) || "Auto" !== floatLabelType || validateLabel(element, floatLabelType), 
            !isNullOrUndefined(clearButton) && clearButton) {
                var parentElement = getParentNode(element), button = parentElement.getElementsByClassName(CLASSNAMES$1.CLEARICON)[0];
                element.value && parentElement.classList.contains("e-input-focus") ? removeClass([ button ], CLASSNAMES$1.CLEARICONHIDE) : addClass([ button ], CLASSNAMES$1.CLEARICONHIDE);
            }
        }, Input.setCssClass = setCssClass, Input.setPlaceholder = setPlaceholder, Input.setReadonly = setReadonly, 
        Input.setEnableRtl = setEnableRtl, Input.setEnabled = setEnabled, Input.setClearButton = setClearButton, 
        Input.removeAttributes = removeAttributes, Input.addAttributes = addAttributes, 
        Input.removeFloating = function(input) {
            var container = input.container;
            if (!isNullOrUndefined(container) && container.classList.contains(CLASSNAMES$1.FLOATINPUT)) {
                var inputEle = container.querySelector("input"), placeholder = container.querySelector("." + CLASSNAMES$1.FLOATTEXT).textContent, clearButton = null !== container.querySelector(".e-clear-icon");
                detach(container.querySelector("." + CLASSNAMES$1.FLOATLINE)), detach(container.querySelector("." + CLASSNAMES$1.FLOATTEXT)), 
                classList(container, [ CLASSNAMES$1.INPUTGROUP ], [ CLASSNAMES$1.FLOATINPUT ]), 
                function(element) {
                    element.removeEventListener("focus", _focusFn), element.removeEventListener("blur", _blurFn);
                }(inputEle), attributes(inputEle, {
                    placeholder: placeholder
                }), inputEle.classList.add(CLASSNAMES$1.INPUT), clearButton || inputEle.removeAttribute("required");
            }
        }, Input.addFloating = function(input, type, placeholder) {
            var container = closest(input, "." + CLASSNAMES$1.INPUTGROUP);
            if ("Never" !== type) {
                var customTag = container.tagName, args = {
                    element: input,
                    floatLabelType: type,
                    customTag: customTag = "DIV" !== customTag && "SPAN" !== customTag ? customTag : null,
                    properties: {
                        placeholder: placeholder
                    }
                }, iconEle = container.querySelector(".e-clear-icon"), inputObj = {
                    container: container
                };
                if (input.classList.remove(CLASSNAMES$1.INPUT), createFloatingInput(args, inputObj), 
                isNullOrUndefined(iconEle) && (iconEle = container.querySelector(".e-input-group-icon")), 
                isNullOrUndefined(iconEle)) container.classList.remove(CLASSNAMES$1.INPUTGROUP); else {
                    var floatLine = container.querySelector("." + CLASSNAMES$1.FLOATLINE), floatText = container.querySelector("." + CLASSNAMES$1.FLOATTEXT);
                    container.insertBefore(input, iconEle), container.insertBefore(floatLine, iconEle), 
                    container.insertBefore(floatText, iconEle);
                }
            }
        }, Input.appendSpan = appendSpan;
    }(Input || (Input = {}));
    var ErrorOption, __extends$6 = function() {
        var extendStatics = Object.setPrototypeOf || {
            __proto__: []
        } instanceof Array && function(d, b) {
            d.__proto__ = b;
        } || function(d, b) {
            for (var p in b) b.hasOwnProperty(p) && (d[p] = b[p]);
        };
        return function(d, b) {
            function __() {
                this.constructor = d;
            }
            extendStatics(d, b), d.prototype = null === b ? Object.create(b) : (__.prototype = b.prototype, 
            new __());
        };
    }(), __decorate$6 = function(decorators, target, key, desc) {
        var d, c = arguments.length, r = c < 3 ? target : null === desc ? desc = Object.getOwnPropertyDescriptor(target, key) : desc;
        if ("object" == typeof Reflect && "function" == typeof Reflect.decorate) r = Reflect.decorate(decorators, target, key, desc); else for (var i = decorators.length - 1; i >= 0; i--) (d = decorators[i]) && (r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r);
        return c > 3 && r && Object.defineProperty(target, key, r), r;
    }, SPINICON = "e-input-group-icon", INTREGEXP = new RegExp("/^(-)?(d*)$/"), NumericTextBox = function(_super) {
        function NumericTextBox(options, element) {
            return _super.call(this, options, element) || this;
        }
        return __extends$6(NumericTextBox, _super), NumericTextBox.prototype.preRender = function() {
            this.isPrevFocused = !1, this.decimalSeparator = ".", this.intRegExp = new RegExp("/^(-)?(d*)$/"), 
            this.isCalled = !1;
            var ejInstance = getValue("ej2_instances", this.element);
            if (this.cloneElement = this.element.cloneNode(!0), this.angularTagName = null, 
            "EJS-NUMERICTEXTBOX" === this.element.tagName) {
                this.angularTagName = this.element.tagName;
                for (var input = createElement("input"), index = 0; index < this.element.attributes.length; index++) input.setAttribute(this.element.attributes[index].nodeName, this.element.attributes[index].nodeValue), 
                input.innerHTML = this.element.innerHTML;
                this.element.parentNode.appendChild(input), this.element.parentNode.removeChild(this.element), 
                this.element = input, setValue("ej2_instances", ejInstance, this.element);
            }
            attributes(this.element, {
                role: "spinbutton",
                tabindex: "0",
                autocomplete: "off",
                "aria-live": "assertive"
            });
            this.l10n = new L10n("numerictextbox", {
                incrementTitle: "Increment value",
                decrementTitle: "Decrement value",
                placeholder: ""
            }, this.locale), this.isValidState = !0, this.inputStyle = null, this.inputName = null, 
            this.cultureInfo = {}, this.initCultureInfo(), this.initCultureFunc(), this.checkAttributes(), 
            this.prevValue = this.value, this.validateMinMax(), this.validateStep(), null === this.placeholder && this.updatePlaceholder();
        }, NumericTextBox.prototype.render = function() {
            "input" === this.element.tagName.toLowerCase() && (this.createWrapper(), this.showSpinButton && this.spinBtnCreation(), 
            isNullOrUndefined(this.width) || setStyleAttribute(this.container, {
                width: formatUnit(this.width)
            }), this.changeValue(this.value), this.wireEvents(), null === this.value || isNaN(this.value) || this.decimals && this.setProperties({
                value: this.roundNumber(this.value, this.decimals)
            }, !0));
        }, NumericTextBox.prototype.checkAttributes = function() {
            for (var _i = 0, attributes_1 = [ "value", "min", "max", "step", "disabled", "readonly", "style", "name" ]; _i < attributes_1.length; _i++) {
                var prop = attributes_1[_i];
                if (!isNullOrUndefined(this.element.getAttribute(prop))) switch (prop) {
                  case "disabled":
                    var enabled = "disabled" !== this.element.getAttribute(prop) && "true" !== this.element.getAttribute(prop);
                    this.setProperties({
                        enabled: enabled
                    }, !0);
                    break;

                  case "readonly":
                    var readonly = "readonly" === this.element.getAttribute(prop) || "true" === this.element.getAttribute(prop);
                    this.setProperties({
                        readonly: readonly
                    }, !0);
                    break;

                  case "style":
                    this.inputStyle = this.element.getAttribute(prop);
                    break;

                  case "name":
                    this.inputName = this.element.getAttribute(prop);
                    break;

                  default:
                    var value = this.instance.getNumberParser({
                        format: "n"
                    })(this.element.getAttribute(prop));
                    (null !== value && !isNaN(value) || "value" === prop) && this.setProperties(setValue(prop, value, {}), !0);
                }
            }
        }, NumericTextBox.prototype.updatePlaceholder = function() {
            this.setProperties({
                placeholder: this.l10n.getConstant("placeholder")
            }, !0);
        }, NumericTextBox.prototype.initCultureFunc = function() {
            this.instance = new Internationalization(this.locale);
        }, NumericTextBox.prototype.initCultureInfo = function() {
            this.cultureInfo.format = this.format, null !== getValue("currency", this) && (setValue("currency", this.currency, this.cultureInfo), 
            this.setProperties({
                currencyCode: this.currency
            }, !0));
        }, NumericTextBox.prototype.createWrapper = function() {
            var inputObj = Input.createInput({
                element: this.element,
                customTag: this.angularTagName,
                floatLabelType: this.floatLabelType,
                properties: {
                    readonly: this.readonly,
                    placeholder: this.placeholder,
                    cssClass: this.cssClass,
                    enableRtl: this.enableRtl,
                    enabled: this.enabled
                }
            });
            this.container = inputObj.container, this.container.setAttribute("class", "e-control-wrapper e-numeric " + this.container.getAttribute("class")), 
            this.readonly && attributes(this.element, {
                "aria-readonly": "true"
            }), this.hiddenInput = createElement("input", {
                attrs: {
                    type: "hidden"
                }
            }), this.inputName = null !== this.inputName ? this.inputName : this.element.id, 
            this.element.removeAttribute("name"), attributes(this.hiddenInput, {
                name: this.inputName
            }), this.container.insertBefore(this.hiddenInput, this.element), null !== this.inputStyle && attributes(this.container, {
                style: this.inputStyle
            });
        }, NumericTextBox.prototype.spinBtnCreation = function() {
            this.spinDown = Input.appendSpan(SPINICON + " e-spin-down", this.container), attributes(this.spinDown, {
                title: this.l10n.getConstant("decrementTitle"),
                "aria-label": this.l10n.getConstant("decrementTitle")
            }), this.spinUp = Input.appendSpan(SPINICON + " e-spin-up", this.container), attributes(this.spinUp, {
                title: this.l10n.getConstant("incrementTitle"),
                "aria-label": this.l10n.getConstant("incrementTitle")
            }), this.wireSpinBtnEvents();
        }, NumericTextBox.prototype.validateMinMax = function() {
            ("number" != typeof this.min || isNaN(this.min)) && this.setProperties({
                min: -Number.MAX_VALUE
            }, !0), ("number" != typeof this.max || isNaN(this.max)) && this.setProperties({
                max: Number.MAX_VALUE
            }, !0), null !== this.decimals && (this.min !== -Number.MAX_VALUE && this.setProperties({
                min: this.instance.getNumberParser({
                    format: "n"
                })(this.formattedValue(this.decimals, this.min))
            }, !0), this.max !== Number.MAX_VALUE && this.setProperties({
                max: this.instance.getNumberParser({
                    format: "n"
                })(this.formattedValue(this.decimals, this.max))
            }, !0)), this.setProperties({
                min: this.min > this.max ? this.max : this.min
            }, !0), attributes(this.element, {
                "aria-valuemin": this.min.toString(),
                "aria-valuemax": this.max.toString()
            });
        }, NumericTextBox.prototype.formattedValue = function(decimals, value) {
            return this.instance.getNumberFormat({
                maximumFractionDigits: decimals,
                minimumFractionDigits: decimals,
                useGrouping: !1
            })(value);
        }, NumericTextBox.prototype.validateStep = function() {
            null !== this.decimals && this.setProperties({
                step: this.instance.getNumberParser({
                    format: "n"
                })(this.formattedValue(this.decimals, this.step))
            }, !0);
        }, NumericTextBox.prototype.action = function(operation, event) {
            this.isInteract = !0;
            var value = this.isFocused ? this.instance.getNumberParser({
                format: "n"
            })(this.element.value) : this.value;
            this.changeValue(this.performAction(value, this.step, operation)), this.raiseChangeEvent(event);
        }, NumericTextBox.prototype.checkErrorClass = function() {
            this.isValidState ? removeClass([ this.container ], "e-error") : addClass([ this.container ], "e-error"), 
            attributes(this.element, {
                "aria-invalid": this.isValidState ? "false" : "true"
            });
        }, NumericTextBox.prototype.wireEvents = function() {
            EventHandler.add(this.element, "focus", this.focusIn, this), EventHandler.add(this.element, "blur", this.focusOut, this), 
            EventHandler.add(this.element, "keydown", this.keyDownHandler, this), EventHandler.add(this.element, "keypress", this.keyPressHandler, this), 
            EventHandler.add(this.element, "change", this.changeHandler, this), EventHandler.add(this.element, "paste", this.pasteHandler, this);
        }, NumericTextBox.prototype.wireSpinBtnEvents = function() {
            EventHandler.add(this.spinUp, Browser.touchStartEvent, this.mouseDownOnSpinner, this), 
            EventHandler.add(this.spinDown, Browser.touchStartEvent, this.mouseDownOnSpinner, this), 
            EventHandler.add(this.spinUp, Browser.touchEndEvent, this.mouseUpOnSpinner, this), 
            EventHandler.add(this.spinDown, Browser.touchEndEvent, this.mouseUpOnSpinner, this), 
            EventHandler.add(this.spinUp, Browser.touchMoveEvent, this.touchMoveOnSpinner, this), 
            EventHandler.add(this.spinDown, Browser.touchMoveEvent, this.touchMoveOnSpinner, this);
        }, NumericTextBox.prototype.unwireEvents = function() {
            EventHandler.remove(this.element, "focus", this.focusIn), EventHandler.remove(this.element, "blur", this.focusOut), 
            EventHandler.remove(this.element, "keydown", this.keyDownHandler), EventHandler.remove(this.element, "keypress", this.keyPressHandler), 
            EventHandler.remove(this.element, "change", this.changeHandler), EventHandler.remove(this.element, "paste", this.pasteHandler);
        }, NumericTextBox.prototype.unwireSpinBtnEvents = function() {
            EventHandler.remove(this.spinUp, Browser.touchStartEvent, this.mouseDownOnSpinner), 
            EventHandler.remove(this.spinDown, Browser.touchStartEvent, this.mouseDownOnSpinner), 
            EventHandler.remove(this.spinUp, Browser.touchEndEvent, this.mouseUpOnSpinner), 
            EventHandler.remove(this.spinDown, Browser.touchEndEvent, this.mouseUpOnSpinner), 
            EventHandler.remove(this.spinUp, Browser.touchMoveEvent, this.touchMoveOnSpinner), 
            EventHandler.remove(this.spinDown, Browser.touchMoveEvent, this.touchMoveOnSpinner);
        }, NumericTextBox.prototype.changeHandler = function(event) {
            this.element.value.length || this.setProperties({
                value: null
            }, !0);
            var parsedInput = this.instance.getNumberParser({
                format: "n"
            })(this.element.value);
            this.updateValue(parsedInput, event);
        }, NumericTextBox.prototype.raiseChangeEvent = function(event) {
            if (this.prevValue !== this.value) {
                var eventArgs = {};
                this.changeEventArgs = {
                    value: this.value,
                    previousValue: this.prevValue,
                    isInteraction: this.isInteract,
                    event: event
                }, event && (this.changeEventArgs.event = event), merge(eventArgs, this.changeEventArgs), 
                this.prevValue = this.value, this.isInteract = !1, this.trigger("change", eventArgs);
            }
        }, NumericTextBox.prototype.pasteHandler = function() {
            var _this = this, beforeUpdate = this.element.value;
            setTimeout(function() {
                _this.numericRegex().test(_this.element.value) || _this.setElementValue(beforeUpdate);
            });
        }, NumericTextBox.prototype.keyDownHandler = function(event) {
            switch (event.keyCode) {
              case 38:
                event.preventDefault(), this.action("increment", event);
                break;

              case 40:
                event.preventDefault(), this.action("decrement", event);
            }
            this.element.value.length || (this.setProperties({
                value: null
            }, !0), this.isKeyDown = !0, this.updateValue(this.instance.getNumberParser({
                format: "n"
            })(this.element.value)), this.isKeyDown = !1);
        }, NumericTextBox.prototype.performAction = function(value, step, operation) {
            (null === value || isNaN(value)) && (value = 0);
            var updatedValue = "increment" === operation ? value + step : value - step;
            return updatedValue = this.correctRounding(value, step, updatedValue), this.strictMode ? this.trimValue(updatedValue) : updatedValue;
        }, NumericTextBox.prototype.correctRounding = function(value, step, result) {
            var floatExp = new RegExp("[,.](.*)"), floatValue = (value.toString(), step.toString(), 
            floatExp.test(value.toString())), floatStep = floatExp.test(step.toString());
            if (floatValue || floatStep) {
                var valueCount = floatValue ? floatExp.exec(value.toString())[0].length : 0, stepCount = floatStep ? floatExp.exec(step.toString())[0].length : 0, max = Math.max(valueCount, stepCount);
                return value = this.roundValue(result, max);
            }
            return result;
        }, NumericTextBox.prototype.roundValue = function(result, precision) {
            precision = precision || 0;
            var divide = Math.pow(10, precision);
            return result *= divide, result = Math.round(result) / divide;
        }, NumericTextBox.prototype.updateValue = function(value, event) {
            event && (this.isInteract = !0), null === value || isNaN(value) || this.decimals && (value = this.roundNumber(value, this.decimals)), 
            this.changeValue(null === value || isNaN(value) ? null : this.strictMode ? this.trimValue(value) : value), 
            this.isKeyDown || this.raiseChangeEvent(event);
        }, NumericTextBox.prototype.updateCurrency = function(prop, propVal) {
            setValue(prop, propVal, this.cultureInfo), this.updateValue(this.value);
        }, NumericTextBox.prototype.changeValue = function(value) {
            if (value || 0 === value) {
                var numberOfDecimals = void 0, decimalPart = value.toString().split(".")[1];
                numberOfDecimals = decimalPart && decimalPart.length ? decimalPart.length : 0, null !== this.decimals && (numberOfDecimals = numberOfDecimals < this.decimals ? numberOfDecimals : this.decimals), 
                this.setProperties({
                    value: this.roundNumber(value, numberOfDecimals)
                }, !0);
            } else value = null, this.setProperties({
                value: value
            }, !0);
            this.modifyText(), this.strictMode || this.validateState();
        }, NumericTextBox.prototype.modifyText = function() {
            if (this.value || 0 === this.value) {
                var value = this.formatNumber(), elementValue = this.isFocused ? value : this.instance.getNumberFormat(this.cultureInfo)(this.value);
                this.setElementValue(elementValue), attributes(this.element, {
                    "aria-valuenow": value
                }), this.hiddenInput.value = value;
            } else this.setElementValue(""), this.element.removeAttribute("aria-valuenow"), 
            this.hiddenInput.value = null;
        }, NumericTextBox.prototype.setElementValue = function(val, element) {
            Input.setValue(val, element || this.element, this.floatLabelType);
        }, NumericTextBox.prototype.validateState = function() {
            this.isValidState = !0, (this.value || 0 === this.value) && (this.isValidState = !(this.value > this.max || this.value < this.min)), 
            this.checkErrorClass();
        }, NumericTextBox.prototype.formatNumber = function() {
            var numberOfDecimals, decimalPart = this.value.toString().split(".")[1];
            return numberOfDecimals = decimalPart && decimalPart.length ? decimalPart.length : 0, 
            null !== this.decimals && (numberOfDecimals = numberOfDecimals < this.decimals ? numberOfDecimals : this.decimals), 
            this.instance.getNumberFormat({
                maximumFractionDigits: numberOfDecimals,
                minimumFractionDigits: numberOfDecimals,
                useGrouping: !1
            })(this.value);
        }, NumericTextBox.prototype.trimValue = function(value) {
            return value > this.max ? this.max : value < this.min ? this.min : value;
        }, NumericTextBox.prototype.roundNumber = function(value, precision) {
            var result = value, decimals = precision || 0, result1 = result.toString().split("e"), result2 = (result = Math.round(Number(result1[0] + "e" + (result1[1] ? Number(result1[1]) + decimals : decimals)))).toString().split("e");
            return result = Number(result2[0] + "e" + (result2[1] ? Number(result2[1]) - decimals : -decimals)), 
            Number(result.toFixed(decimals));
        }, NumericTextBox.prototype.cancelEvent = function(event) {
            return event.preventDefault(), !1;
        }, NumericTextBox.prototype.keyPressHandler = function(event) {
            if (0 === event.which || event.metaKey || event.ctrlKey || 8 === event.keyCode || 13 === event.keyCode) return !0;
            var currentChar = String.fromCharCode(event.which), text = this.element.value;
            return text = text.substring(0, this.element.selectionStart) + currentChar + text.substring(this.element.selectionEnd), 
            !!this.numericRegex().test(text) || (event.preventDefault(), event.stopPropagation(), 
            !1);
        }, NumericTextBox.prototype.numericRegex = function() {
            var decimalSeparator = getValue("decimal", getNumericObject(this.locale)), fractionRule = "*";
            return "." === decimalSeparator && (decimalSeparator = "\\" + decimalSeparator), 
            0 === this.decimals ? INTREGEXP : (this.decimals && this.validateDecimalOnType && (fractionRule = "{0," + this.decimals + "}"), 
            new RegExp("^(-)?(((\\d+(" + decimalSeparator + "\\d" + fractionRule + ")?)|(" + decimalSeparator + "\\d" + fractionRule + ")))?$"));
        }, NumericTextBox.prototype.mouseWheel = function(event) {
            event.preventDefault();
            var delta, rawEvent = event;
            rawEvent.wheelDelta ? delta = rawEvent.wheelDelta / 120 : rawEvent.detail && (delta = -rawEvent.detail / 3), 
            delta > 0 ? this.action("increment", event) : delta < 0 && this.action("decrement", event), 
            this.cancelEvent(event);
        }, NumericTextBox.prototype.focusIn = function(event) {
            if (this.enabled && !this.readonly) {
                if (this.isFocused = !0, removeClass([ this.container ], "e-error"), this.prevValue = this.value, 
                this.value || 0 === this.value) {
                    var formatValue = this.formatNumber();
                    this.setElementValue(formatValue), this.isPrevFocused || this.element.setSelectionRange(0, formatValue.length);
                }
                Browser.isDevice || EventHandler.add(this.element, "mousewheel DOMMouseScroll", this.mouseWheel, this);
            }
        }, NumericTextBox.prototype.focusOut = function(event) {
            var _this = this;
            if (this.isPrevFocused) {
                if (event.preventDefault(), Browser.isDevice) {
                    var value_1 = this.element.value;
                    this.element.focus(), this.isPrevFocused = !1;
                    var ele_1 = this.element;
                    setTimeout(function() {
                        _this.setElementValue(value_1, ele_1);
                    }, 200);
                }
            } else {
                this.isFocused = !1, this.element.value.length || this.setProperties({
                    value: null
                }, !0);
                var parsedInput = this.instance.getNumberParser({
                    format: "n"
                })(this.element.value);
                this.updateValue(parsedInput), Browser.isDevice || EventHandler.remove(this.element, "mousewheel DOMMouseScroll", this.mouseWheel);
            }
        }, NumericTextBox.prototype.mouseDownOnSpinner = function(event) {
            var _this = this;
            if (this.isFocused && (this.isPrevFocused = !0, event.preventDefault()), this.getElementData(event)) {
                this.getElementData(event);
                var target = event.currentTarget, action = target.classList.contains("e-spin-up") ? "increment" : "decrement";
                EventHandler.add(target, "mouseleave", this.mouseUpClick, this), this.timeOut = setInterval(function() {
                    _this.isCalled = !0, _this.action(action, event);
                }, 150), EventHandler.add(document, "mouseup", this.mouseUpClick, this);
            }
        }, NumericTextBox.prototype.touchMoveOnSpinner = function(event) {
            document.elementFromPoint(event.clientX, event.clientY).classList.contains(SPINICON) || clearInterval(this.timeOut);
        }, NumericTextBox.prototype.mouseUpOnSpinner = function(event) {
            if (this.isPrevFocused && (this.element.focus(), Browser.isDevice || (this.isPrevFocused = !1)), 
            Browser.isDevice || event.preventDefault(), this.getElementData(event)) {
                var target = event.currentTarget, action = target.classList.contains("e-spin-up") ? "increment" : "decrement";
                EventHandler.remove(target, "mouseleave", this.mouseUpClick), this.isCalled || this.action(action, event), 
                this.isCalled = !1, EventHandler.remove(document, "mouseup", this.mouseUpClick);
            }
        }, NumericTextBox.prototype.getElementData = function(event) {
            return !(event.which && 3 === event.which || event.button && 2 === event.button || !this.enabled || this.readonly) && (clearInterval(this.timeOut), 
            !0);
        }, NumericTextBox.prototype.mouseUpClick = function(event) {
            event.stopPropagation(), clearInterval(this.timeOut), this.isCalled = !1, EventHandler.remove(this.spinUp, "mouseleave", this.mouseUpClick), 
            EventHandler.remove(this.spinDown, "mouseleave", this.mouseUpClick);
        }, NumericTextBox.prototype.increment = function(step) {
            void 0 === step && (step = this.step), this.changeValue(this.performAction(this.value, step, "increment"));
        }, NumericTextBox.prototype.decrement = function(step) {
            void 0 === step && (step = this.step), this.changeValue(this.performAction(this.value, step, "decrement"));
        }, NumericTextBox.prototype.destroy = function() {
            this.unwireEvents(), detach(this.hiddenInput), this.showSpinButton && (this.unwireSpinBtnEvents(), 
            detach(this.spinUp), detach(this.spinDown)), this.container.parentElement.appendChild(this.cloneElement), 
            detach(this.container), _super.prototype.destroy.call(this);
        }, NumericTextBox.prototype.getText = function() {
            return this.element.value;
        }, NumericTextBox.prototype.getPersistData = function() {
            return this.addOnPersist([ "value" ]);
        }, NumericTextBox.prototype.onPropertyChanged = function(newProp, oldProp) {
            for (var _i = 0, _a = Object.keys(newProp); _i < _a.length; _i++) {
                var prop = _a[_i];
                switch (prop) {
                  case "width":
                    setStyleAttribute(this.container, {
                        width: formatUnit(newProp.width)
                    });
                    break;

                  case "cssClass":
                    Input.setCssClass(newProp.cssClass, [ this.container ], oldProp.cssClass);
                    break;

                  case "enabled":
                    Input.setEnabled(newProp.enabled, this.element);
                    break;

                  case "enableRtl":
                    Input.setEnableRtl(newProp.enableRtl, [ this.container ]);
                    break;

                  case "readonly":
                    Input.setReadonly(newProp.readonly, this.element), this.readonly ? attributes(this.element, {
                        "aria-readonly": "true"
                    }) : this.element.removeAttribute("aria-readonly");
                    break;

                  case "placeholder":
                    Input.setPlaceholder(newProp.placeholder, this.element);
                    break;

                  case "step":
                    this.step = newProp.step, this.validateStep();
                    break;

                  case "showSpinButton":
                    newProp.showSpinButton ? this.spinBtnCreation() : (detach(this.spinUp), detach(this.spinDown));
                    break;

                  case "value":
                    this.updateValue(newProp.value);
                    break;

                  case "min":
                  case "max":
                    setValue(prop, getValue(prop, newProp), this), this.validateMinMax(), this.updateValue(this.value);
                    break;

                  case "strictMode":
                    this.strictMode = newProp.strictMode, this.updateValue(this.value), this.validateState();
                    break;

                  case "locale":
                    this.initCultureFunc(), this.l10n.setLocale(this.locale), isNullOrUndefined(this.spinDown) || attributes(this.spinDown, {
                        title: this.l10n.getConstant("decrementTitle"),
                        "aria-label": this.l10n.getConstant("decrementTitle")
                    }), isNullOrUndefined(this.spinUp) || attributes(this.spinUp, {
                        title: this.l10n.getConstant("incrementTitle"),
                        "aria-label": this.l10n.getConstant("incrementTitle")
                    }), this.updatePlaceholder(), Input.setPlaceholder(this.placeholder, this.element), 
                    this.updateValue(this.value);
                    break;

                  case "currency":
                    var propVal = getValue(prop, newProp);
                    this.setProperties({
                        currencyCode: propVal
                    }, !0), this.updateCurrency(prop, propVal);
                    break;

                  case "currencyCode":
                    var propValue = getValue(prop, newProp);
                    this.setProperties({
                        currency: propValue
                    }, !0), this.updateCurrency("currency", propValue);
                    break;

                  case "format":
                    setValue(prop, getValue(prop, newProp), this), this.initCultureInfo(), this.updateValue(this.value);
                    break;

                  case "decimals":
                    this.decimals = newProp.decimals, this.updateValue(this.value);
                }
            }
        }, NumericTextBox.prototype.getModuleName = function() {
            return "numerictextbox";
        }, __decorate$6([ Property("") ], NumericTextBox.prototype, "cssClass", void 0), 
        __decorate$6([ Property(null) ], NumericTextBox.prototype, "value", void 0), __decorate$6([ Property(-Number.MAX_VALUE) ], NumericTextBox.prototype, "min", void 0), 
        __decorate$6([ Property(Number.MAX_VALUE) ], NumericTextBox.prototype, "max", void 0), 
        __decorate$6([ Property(1) ], NumericTextBox.prototype, "step", void 0), __decorate$6([ Property(null) ], NumericTextBox.prototype, "width", void 0), 
        __decorate$6([ Property(null) ], NumericTextBox.prototype, "placeholder", void 0), 
        __decorate$6([ Property(!0) ], NumericTextBox.prototype, "showSpinButton", void 0), 
        __decorate$6([ Property(!1) ], NumericTextBox.prototype, "readonly", void 0), __decorate$6([ Property(!0) ], NumericTextBox.prototype, "enabled", void 0), 
        __decorate$6([ Property(!1) ], NumericTextBox.prototype, "enableRtl", void 0), __decorate$6([ Property(!1) ], NumericTextBox.prototype, "enablePersistence", void 0), 
        __decorate$6([ Property("n2") ], NumericTextBox.prototype, "format", void 0), __decorate$6([ Property(null) ], NumericTextBox.prototype, "decimals", void 0), 
        __decorate$6([ Property(null) ], NumericTextBox.prototype, "currency", void 0), 
        __decorate$6([ Property(null) ], NumericTextBox.prototype, "currencyCode", void 0), 
        __decorate$6([ Property(!0) ], NumericTextBox.prototype, "strictMode", void 0), 
        __decorate$6([ Property(!1) ], NumericTextBox.prototype, "validateDecimalOnType", void 0), 
        __decorate$6([ Property("Never") ], NumericTextBox.prototype, "floatLabelType", void 0), 
        __decorate$6([ Event() ], NumericTextBox.prototype, "created", void 0), __decorate$6([ Event() ], NumericTextBox.prototype, "destroyed", void 0), 
        __decorate$6([ Event() ], NumericTextBox.prototype, "change", void 0), NumericTextBox = __decorate$6([ NotifyPropertyChanges ], NumericTextBox);
    }(Component), ERROR$1 = "e-error", INPUTGROUP = "e-input-group", FLOATINPUT = "e-float-input", UTILMASK = "e-utility-mask", TOPLABEL = "e-label-top", BOTTOMLABEL = "e-label-bottom", regularExpressions = {
        "0": "[0-9]",
        "9": "[0-9 ]",
        "#": "[0-9 +-]",
        L: "[A-Za-z]",
        "?": "[A-Za-z ]",
        "&": "[^ ]+",
        C: "[^]+",
        A: "[A-Za-z0-9]",
        a: "[A-Za-z0-9 ]"
    }, MaskUndo = function() {
        return function() {};
    }(), __extends$1$4 = function() {
        var extendStatics = Object.setPrototypeOf || {
            __proto__: []
        } instanceof Array && function(d, b) {
            d.__proto__ = b;
        } || function(d, b) {
            for (var p in b) b.hasOwnProperty(p) && (d[p] = b[p]);
        };
        return function(d, b) {
            function __() {
                this.constructor = d;
            }
            extendStatics(d, b), d.prototype = null === b ? Object.create(b) : (__.prototype = b.prototype, 
            new __());
        };
    }(), __decorate$1$4 = function(decorators, target, key, desc) {
        var d, c = arguments.length, r = c < 3 ? target : null === desc ? desc = Object.getOwnPropertyDescriptor(target, key) : desc;
        if ("object" == typeof Reflect && "function" == typeof Reflect.decorate) r = Reflect.decorate(decorators, target, key, desc); else for (var i = decorators.length - 1; i >= 0; i--) (d = decorators[i]) && (r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r);
        return c > 3 && r && Object.defineProperty(target, key, r), r;
    }, MaskedTextBox = function(_super) {
        function MaskedTextBox(options, element) {
            return _super.call(this, options, element) || this;
        }
        return __extends$1$4(MaskedTextBox, _super), MaskedTextBox.prototype.getModuleName = function() {
            return "maskedtextbox";
        }, MaskedTextBox.prototype.preRender = function() {
            this.promptMask = "", this.hiddenMask = "", this.escapeMaskValue = "", this.regExpCollec = regularExpressions, 
            this.customRegExpCollec = [], this.undoCollec = [], this.redoCollec = [], this.changeEventArgs = {}, 
            this.focusEventArgs = {}, this.maskKeyPress = !1, this.isFocus = !1, this.isInitial = !1, 
            this.isIosInvalid = !1;
            var ejInstance = getValue("ej2_instances", this.element);
            if (this.cloneElement = this.element.cloneNode(!0), this.angularTagName = null, 
            "EJS-MASKEDTEXTBOX" === this.element.tagName) {
                this.angularTagName = this.element.tagName;
                for (var input = createElement("input"), i = 0; i < this.element.attributes.length; i++) input.setAttribute(this.element.attributes[i].nodeName, this.element.attributes[i].nodeValue), 
                input.innerHTML = this.element.innerHTML;
                this.element.parentNode.appendChild(input), this.element.parentNode.removeChild(this.element), 
                this.element = input, setValue("ej2_instances", ejInstance, this.element);
            }
        }, MaskedTextBox.prototype.getPersistData = function() {
            return this.addOnPersist([ "value" ]);
        }, MaskedTextBox.prototype.render = function() {
            "input" === this.element.tagName.toLowerCase() && ("Never" === this.floatLabelType && addClass([ this.element ], "e-input"), 
            this.createWrapper(), this.isInitial = !0, this.resetMaskedTextBox(), this.isInitial = !1, 
            this.setMaskPlaceholder(!0), this.setWidth(this.width));
        }, MaskedTextBox.prototype.resetMaskedTextBox = function() {
            this.promptMask = "", this.hiddenMask = "", this.escapeMaskValue = "", this.customRegExpCollec = [], 
            this.undoCollec = [], this.redoCollec = [], this.promptChar.length > 1 && (this.promptChar = this.promptChar[0]), 
            createMask.call(this), applyMask.call(this);
            var val = strippedValue.call(this, this.element);
            this.prevValue = val, this.value = val, this.isInitial || unwireEvents.call(this), 
            wireEvents.call(this);
        }, MaskedTextBox.prototype.setMaskPlaceholder = function(setVal) {
            this.placeholder && (Input.setPlaceholder(this.placeholder, this.element), this.element.value === this.promptMask && setVal && "Always" !== this.floatLabelType && setElementValue.call(this, ""), 
            "Never" === this.floatLabelType && maskInputBlurHandler.call(this));
        }, MaskedTextBox.prototype.setCssClass = function(cssClass, element) {
            cssClass && addClass(element, cssClass);
        }, MaskedTextBox.prototype.setWidth = function(width) {
            isNullOrUndefined(width) || (this.element.style.width = formatUnit(width));
        }, MaskedTextBox.prototype.createWrapper = function() {
            this.inputObj = Input.createInput({
                element: this.element,
                customTag: this.angularTagName,
                floatLabelType: this.floatLabelType,
                properties: {
                    enableRtl: this.enableRtl,
                    enabled: this.enabled,
                    placeholder: this.placeholder
                }
            }), this.inputObj.container.setAttribute("class", "e-widget e-control-wrapper e-mask " + this.inputObj.container.getAttribute("class"));
        }, MaskedTextBox.prototype.onPropertyChanged = function(newProp, oldProp) {
            for (var _i = 0, _a = Object.keys(newProp); _i < _a.length; _i++) {
                switch (_a[_i]) {
                  case "value":
                    setMaskValue.call(this, this.value), this.placeholder && this.setMaskPlaceholder(!1);
                    break;

                  case "placeholder":
                    this.setMaskPlaceholder(!0);
                    break;

                  case "width":
                    this.setWidth(newProp.width);
                    break;

                  case "cssClass":
                    this.setCssClass(newProp.cssClass, [ this.inputObj.container ]);
                    break;

                  case "enabled":
                    Input.setEnabled(newProp.enabled, this.element);
                    break;

                  case "enableRtl":
                    Input.setEnableRtl(newProp.enableRtl, [ this.inputObj.container ]);
                    break;

                  case "customCharacters":
                    this.customCharacters = newProp.customCharacters, this.resetMaskedTextBox();
                    break;

                  case "mask":
                    var strippedValue_1 = this.value;
                    this.mask = newProp.mask, this.updateValue(strippedValue_1);
                    break;

                  case "promptChar":
                    newProp.promptChar.length > 1 && (newProp.promptChar = newProp.promptChar[0]), newProp.promptChar ? this.promptChar = newProp.promptChar : this.promptChar = "_";
                    var value = this.element.value.replace(new RegExp("[" + oldProp.promptChar + "]", "g"), this.promptChar);
                    this.promptMask === this.element.value && (value = this.promptMask.replace(new RegExp("[" + oldProp.promptChar + "]", "g"), this.promptChar)), 
                    this.promptMask = this.promptMask.replace(new RegExp("[" + oldProp.promptChar + "]", "g"), this.promptChar), 
                    this.undoCollec = this.redoCollec = [], setElementValue.call(this, value);
                }
            }
        }, MaskedTextBox.prototype.updateValue = function(strippedVal) {
            this.resetMaskedTextBox(), setMaskValue.call(this, strippedVal);
        }, MaskedTextBox.prototype.getMaskedValue = function() {
            return unstrippedValue.call(this, this.element);
        }, MaskedTextBox.prototype.destroy = function() {
            unwireEvents.call(this), this.inputObj.container.parentElement.appendChild(this.cloneElement), 
            detach(this.inputObj.container), _super.prototype.destroy.call(this);
        }, __decorate$1$4([ Property(null) ], MaskedTextBox.prototype, "cssClass", void 0), 
        __decorate$1$4([ Property(null) ], MaskedTextBox.prototype, "width", void 0), __decorate$1$4([ Property(null) ], MaskedTextBox.prototype, "placeholder", void 0), 
        __decorate$1$4([ Property("Never") ], MaskedTextBox.prototype, "floatLabelType", void 0), 
        __decorate$1$4([ Property(!0) ], MaskedTextBox.prototype, "enabled", void 0), __decorate$1$4([ Property(!1) ], MaskedTextBox.prototype, "enablePersistence", void 0), 
        __decorate$1$4([ Property(!1) ], MaskedTextBox.prototype, "enableRtl", void 0), 
        __decorate$1$4([ Property(null) ], MaskedTextBox.prototype, "mask", void 0), __decorate$1$4([ Property("_") ], MaskedTextBox.prototype, "promptChar", void 0), 
        __decorate$1$4([ Property(null) ], MaskedTextBox.prototype, "value", void 0), __decorate$1$4([ Property(null) ], MaskedTextBox.prototype, "customCharacters", void 0), 
        __decorate$1$4([ Event() ], MaskedTextBox.prototype, "created", void 0), __decorate$1$4([ Event() ], MaskedTextBox.prototype, "destroyed", void 0), 
        __decorate$1$4([ Event() ], MaskedTextBox.prototype, "change", void 0), __decorate$1$4([ Event() ], MaskedTextBox.prototype, "focus", void 0), 
        MaskedTextBox = __decorate$1$4([ NotifyPropertyChanges ], MaskedTextBox);
    }(Component), __extends$2$4 = function() {
        var extendStatics = Object.setPrototypeOf || {
            __proto__: []
        } instanceof Array && function(d, b) {
            d.__proto__ = b;
        } || function(d, b) {
            for (var p in b) b.hasOwnProperty(p) && (d[p] = b[p]);
        };
        return function(d, b) {
            function __() {
                this.constructor = d;
            }
            extendStatics(d, b), d.prototype = null === b ? Object.create(b) : (__.prototype = b.prototype, 
            new __());
        };
    }(), __decorate$2$4 = function(decorators, target, key, desc) {
        var d, c = arguments.length, r = c < 3 ? target : null === desc ? desc = Object.getOwnPropertyDescriptor(target, key) : desc;
        if ("object" == typeof Reflect && "function" == typeof Reflect.decorate) r = Reflect.decorate(decorators, target, key, desc); else for (var i = decorators.length - 1; i >= 0; i--) (d = decorators[i]) && (r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r);
        return c > 3 && r && Object.defineProperty(target, key, r), r;
    }, TicksData = function(_super) {
        function TicksData() {
            return null !== _super && _super.apply(this, arguments) || this;
        }
        return __extends$2$4(TicksData, _super), __decorate$2$4([ Property("None") ], TicksData.prototype, "placement", void 0), 
        __decorate$2$4([ Property(10) ], TicksData.prototype, "largeStep", void 0), __decorate$2$4([ Property(1) ], TicksData.prototype, "smallStep", void 0), 
        __decorate$2$4([ Property(!1) ], TicksData.prototype, "showSmallTicks", void 0), 
        __decorate$2$4([ Property(null) ], TicksData.prototype, "format", void 0), TicksData;
    }(ChildProperty), TooltipData = function(_super) {
        function TooltipData() {
            return null !== _super && _super.apply(this, arguments) || this;
        }
        return __extends$2$4(TooltipData, _super), __decorate$2$4([ Property("") ], TooltipData.prototype, "cssClass", void 0), 
        __decorate$2$4([ Property("Before") ], TooltipData.prototype, "placement", void 0), 
        __decorate$2$4([ Property("Focus") ], TooltipData.prototype, "showOn", void 0), 
        __decorate$2$4([ Property(!1) ], TooltipData.prototype, "isVisible", void 0), __decorate$2$4([ Property(null) ], TooltipData.prototype, "format", void 0), 
        TooltipData;
    }(ChildProperty), classNames_root = "e-slider", classNames_rtl = "e-rtl", classNames_sliderHiddenInput = "e-slider-input", classNames_sliderHandle = "e-handle", classNames_rangeBar = "e-range", classNames_sliderButton = "e-slider-button", classNames_firstButton = "e-first-button", classNames_secondButton = "e-second-button", classNames_scale = "e-scale", classNames_tick = "e-tick", classNames_large = "e-large", classNames_tickValue = "e-tick-value", classNames_sliderTooltip = "e-slider-tooltip", classNames_sliderHover = "e-slider-hover", classNames_sliderFirstHandle = "e-handle-first", classNames_sliderSecondHandle = "e-handle-second", classNames_sliderDisabled = "e-disabled", classNames_sliderContainer = "e-slider-container", classNames_horizontalTooltipBefore = "e-slider-horizontal-before", classNames_horizontalTooltipAfter = "e-slider-horizontal-after", classNames_verticalTooltipBefore = "e-slider-vertical-before", classNames_verticalTooltipAfter = "e-slider-vertical-after", classNames_materialTooltipOpen = "e-material-tooltip-open", classNames_materialTooltipActive = "e-tooltip-active", classNames_materialSlider = "e-material-slider", classNames_sliderTrack = "e-slider-track", classNames_sliderHandleFocused = "e-handle-focused", classNames_verticalSlider = "e-vertical", classNames_horizontalSlider = "e-horizontal", classNames_sliderHandleStart = "e-handle-start", classNames_sliderTooltipStart = "e-material-tooltip-start", classNames_sliderTabHandle = "e-tab-handle", classNames_sliderButtonIcon = "e-button-icon", classNames_sliderSmallSize = "e-small-size", classNames_sliderTickPosition = "e-tick-pos", classNames_sliderFirstTick = "e-first-tick", classNames_sliderLastTick = "e-last-tick", classNames_sliderButtonClass = "e-slider-btn", classNames_sliderTabTrack = "e-tab-track", classNames_sliderTabRange = "e-tab-range", classNames_sliderActiveHandle = "e-handle-active", classNames_sliderMaterialHandle = "e-material-handle", classNames_sliderMaterialRange = "e-material-range", classNames_sliderMaterialDefault = "e-material-default", classNames_materialTooltipShow = "e-material-tooltip-show", classNames_materialTooltipHide = "e-material-tooltip-hide", classNames_readOnly = "e-read-only", Slider = function(_super) {
        function Slider(options, element) {
            var _this = _super.call(this, options, element) || this;
            return _this.horDir = "left", _this.verDir = "bottom", _this.transition = {
                handle: "left .4s cubic-bezier(.25, .8, .25, 1), right .4s cubic-bezier(.25, .8, .25, 1), top .4s cubic-bezier(.25, .8, .25, 1) , bottom .4s cubic-bezier(.25, .8, .25, 1)",
                rangeBar: "all .4s cubic-bezier(.25, .8, .25, 1)"
            }, _this.transitionOnMaterialTooltip = {
                handle: "left 1ms ease-out, right 1ms ease-out, bottom 1ms ease-out",
                rangeBar: "left 1ms ease-out, right 1ms ease-out, bottom 1ms ease-out, width 1ms ease-out, height 1ms ease-out"
            }, _this.scaleTransform = "transform .4s cubic-bezier(.25, .8, .25, 1)", _this.customAriaText = null, 
            _this;
        }
        return __extends$2$4(Slider, _super), Slider.prototype.preRender = function() {
            this.l10n = new L10n("slider", {
                incrementTitle: "Increase",
                decrementTitle: "Decrease"
            }, this.locale), this.tickElementCollection = [], this.tooltipFormatInfo = {}, this.ticksFormatInfo = {}, 
            this.initCultureInfo(), this.initCultureFunc();
        }, Slider.prototype.initCultureFunc = function() {
            this.internationalization = new Internationalization(this.locale);
        }, Slider.prototype.initCultureInfo = function() {
            this.tooltipFormatInfo.format = isNullOrUndefined(this.tooltip.format) ? null : this.tooltip.format, 
            this.ticksFormatInfo.format = isNullOrUndefined(this.ticks.format) ? null : this.ticks.format;
        }, Slider.prototype.formatString = function(value, formatInfo) {
            var formatValue = null, formatString = null;
            if (value || 0 === value) {
                formatValue = this.formatNumber(value);
                var numberOfDecimals = this.numberOfDecimals(value);
                formatString = this.internationalization.getNumberFormat(formatInfo)(this.makeRoundNumber(value, numberOfDecimals));
            }
            return {
                elementVal: formatValue,
                formatString: formatString
            };
        }, Slider.prototype.formatNumber = function(value) {
            var numberOfDecimals = this.numberOfDecimals(value);
            return this.internationalization.getNumberFormat({
                maximumFractionDigits: numberOfDecimals,
                minimumFractionDigits: numberOfDecimals,
                useGrouping: !1
            })(value);
        }, Slider.prototype.numberOfDecimals = function(value) {
            var decimalPart = value.toString().split(".")[1];
            return decimalPart && decimalPart.length ? decimalPart.length : 0;
        }, Slider.prototype.makeRoundNumber = function(value, precision) {
            var decimals = precision || 0;
            return Number(value.toFixed(decimals));
        }, Slider.prototype.fractionalToInteger = function(value) {
            value = 0 === this.numberOfDecimals(value) ? Number(value).toFixed(this.noOfDecimals) : value;
            for (var tens = 1, i = 0; i < this.noOfDecimals; i++) tens *= 10;
            return value = Number((value * tens).toFixed(0));
        }, Slider.prototype.render = function() {
            this.initialize(), this.initRender(), this.wireEvents(), this.setZindex();
        }, Slider.prototype.initialize = function() {
            addClass([ this.element ], classNames_root), this.setCSSClass();
        }, Slider.prototype.setCSSClass = function(oldCSSClass) {
            oldCSSClass && removeClass([ this.element ], oldCSSClass.split(" ")), this.cssClass && addClass([ this.element ], this.cssClass.split(" "));
        }, Slider.prototype.setEnabled = function() {
            var tooltipElement = "Range" !== this.type ? [ this.firstTooltipElement ] : [ this.firstTooltipElement, this.secondTooltipElement ];
            this.enabled ? (removeClass([ this.sliderContainer ], [ classNames_sliderDisabled ]), 
            this.tooltip.isVisible && "Always" === this.tooltip.showOn && tooltipElement.forEach(function(tooltipElement) {
                tooltipElement.classList.remove(classNames_sliderDisabled);
            }), this.wireEvents()) : (addClass([ this.sliderContainer ], [ classNames_sliderDisabled ]), 
            this.tooltip.isVisible && "Always" === this.tooltip.showOn && tooltipElement.forEach(function(tooltipElement) {
                tooltipElement.classList.add(classNames_sliderDisabled);
            }), this.unwireEvents());
        }, Slider.prototype.getTheme = function(container) {
            return window.getComputedStyle(container, ":after").getPropertyValue("content").replace(/['"]+/g, "");
        }, Slider.prototype.initRender = function() {
            this.sliderContainer = createElement("div", {
                className: classNames_sliderContainer
            }), this.element.parentNode.insertBefore(this.sliderContainer, this.element), this.sliderContainer.appendChild(this.element), 
            this.sliderTrack = createElement("div", {
                className: classNames_sliderTrack
            }), this.element.appendChild(this.sliderTrack), this.element.tabIndex = -1, this.isMaterial = "material" === this.getTheme(this.sliderContainer), 
            this.setHandler(), this.createRangeBar(), this.setOrientClass(), this.hiddenInput = createElement("input", {
                attrs: {
                    type: "hidden",
                    value: isNullOrUndefined(this.value) ? this.min.toString() : this.value.toString(),
                    name: this.element.getAttribute("name") || this.element.getAttribute("id") || "_" + (1e3 * Math.random()).toFixed(0) + "slider",
                    class: classNames_sliderHiddenInput
                }
            }), this.hiddenInput.tabIndex = -1, this.sliderContainer.appendChild(this.hiddenInput), 
            this.showButtons && this.setButtons(), this.setEnableRTL(), "Range" === this.type ? this.rangeValueUpdate() : this.value = isNullOrUndefined(this.value) ? parseFloat(formatUnit(this.min.toString())) : this.value, 
            this.previousVal = "Range" !== this.type ? this.checkHandleValue(parseFloat(formatUnit(this.value.toString()))) : [ this.checkHandleValue(parseFloat(formatUnit(this.value[0].toString()))), this.checkHandleValue(parseFloat(formatUnit(this.value[1].toString()))) ], 
            this.previousChanged = this.previousVal, this.setValue(), "None" !== this.ticks.placement && this.renderScale(), 
            this.tooltip.isVisible && this.renderTooltip(), this.enabled ? removeClass([ this.sliderContainer ], [ classNames_sliderDisabled ]) : addClass([ this.sliderContainer ], [ classNames_sliderDisabled ]), 
            this.readOnly ? addClass([ this.sliderContainer ], [ classNames_readOnly ]) : removeClass([ this.sliderContainer ], [ classNames_readOnly ]);
        }, Slider.prototype.createRangeBar = function() {
            "Default" !== this.type && (this.rangeBar = createElement("div", {
                attrs: {
                    class: classNames_rangeBar
                }
            }), this.element.appendChild(this.rangeBar));
        }, Slider.prototype.setOrientClass = function() {
            "Vertical" !== this.orientation ? (this.sliderContainer.classList.remove(classNames_verticalSlider), 
            this.sliderContainer.classList.add(classNames_horizontalSlider), this.firstHandle.setAttribute("aria-orientation", "horizontal"), 
            "Range" === this.type && this.secondHandle.setAttribute("aria-orientation", "horizontal")) : (this.sliderContainer.classList.remove(classNames_horizontalSlider), 
            this.sliderContainer.classList.add(classNames_verticalSlider), this.firstHandle.setAttribute("aria-orientation", "vertical"), 
            "Range" === this.type && this.secondHandle.setAttribute("aria-orientation", "vertical"));
        }, Slider.prototype.setAriaAttributes = function(element) {
            var _this = this;
            if ("Range" !== this.type) attributes(element, {
                "aria-valuemin": this.min.toString(),
                "aria-valuemax": this.max.toString()
            }); else {
                [ [ this.min.toString(), this.value[1].toString() ], [ this.value[0].toString(), this.max.toString() ] ].forEach(function(range, index) {
                    var element = 0 === index ? _this.firstHandle : _this.secondHandle;
                    element && attributes(element, {
                        "aria-valuemin": range[0],
                        "aria-valuemax": range[1]
                    });
                });
            }
        }, Slider.prototype.createSecondHandle = function() {
            this.secondHandle = createElement("div", {
                attrs: {
                    class: classNames_sliderHandle,
                    role: "slider",
                    "aria-labelledby": this.element.id + "_title",
                    tabIndex: "0"
                }
            }), this.secondHandle.classList.add(classNames_sliderSecondHandle), this.element.appendChild(this.secondHandle), 
            this.isMaterial && this.tooltip.isVisible && (this.secondMaterialHandle = createElement("div", {
                attrs: {
                    class: classNames_sliderHandle + " " + classNames_sliderMaterialHandle
                }
            }), this.element.appendChild(this.secondMaterialHandle));
        }, Slider.prototype.createFirstHandle = function() {
            this.firstHandle = createElement("div", {
                attrs: {
                    class: classNames_sliderHandle,
                    role: "slider",
                    "aria-labelledby": this.element.id + "_title",
                    tabIndex: "0"
                }
            }), this.firstHandle.classList.add(classNames_sliderFirstHandle), this.element.appendChild(this.firstHandle), 
            this.isMaterial && this.tooltip.isVisible && (this.firstMaterialHandle = createElement("div", {
                attrs: {
                    class: classNames_sliderHandle + " " + classNames_sliderMaterialHandle
                }
            }), this.element.appendChild(this.firstMaterialHandle));
        }, Slider.prototype.wireFirstHandleEvt = function(destroy) {
            destroy ? (EventHandler.remove(this.firstHandle, "mousedown touchstart", this.handleFocus), 
            EventHandler.remove(this.firstHandle, "transitionend", this.transitionEnd), EventHandler.remove(this.firstHandle, "mouseenter touchenter", this.handleOver), 
            EventHandler.remove(this.firstHandle, "mouseleave touchend", this.handleLeave)) : (EventHandler.add(this.firstHandle, "mousedown touchstart", this.handleFocus, this), 
            EventHandler.add(this.firstHandle, "transitionend", this.transitionEnd, this), EventHandler.add(this.firstHandle, "mouseenter touchenter", this.handleOver, this), 
            EventHandler.add(this.firstHandle, "mouseleave touchend", this.handleLeave, this));
        }, Slider.prototype.wireSecondHandleEvt = function(destroy) {
            destroy ? (EventHandler.remove(this.secondHandle, "mousedown touchstart", this.handleFocus), 
            EventHandler.remove(this.secondHandle, "transitionend", this.transitionEnd), EventHandler.remove(this.secondHandle, "mouseenter touchenter", this.handleOver), 
            EventHandler.remove(this.secondHandle, "mouseleave touchend", this.handleLeave)) : (EventHandler.add(this.secondHandle, "mousedown touchstart", this.handleFocus, this), 
            EventHandler.add(this.secondHandle, "transitionend", this.transitionEnd, this), 
            EventHandler.add(this.secondHandle, "mouseenter touchenter", this.handleOver, this), 
            EventHandler.add(this.secondHandle, "mouseleave touchend", this.handleLeave, this));
        }, Slider.prototype.handleStart = function() {
            var pos = 1 === this.activeHandle ? this.handlePos1 : this.handlePos2, tooltipElement = 1 === this.activeHandle ? this.firstTooltipElement : this.secondTooltipElement;
            0 === pos && "Range" !== this.type && (this.getHandle().classList.add(classNames_sliderHandleStart), 
            this.isMaterial && this.tooltip.isVisible && (this.firstMaterialHandle.classList.add(classNames_sliderHandleStart), 
            tooltipElement && tooltipElement.classList.add(classNames_sliderTooltipStart)));
        }, Slider.prototype.transitionEnd = function(e) {
            if (this.handleStart(), this.getHandle().style.transition = "none", "Default" !== this.type && (this.rangeBar.style.transition = "none"), 
            this.tooltip.isVisible) {
                var tooltipObj = 1 === this.activeHandle ? this.firstTooltipObj : this.secondTooltipObj, tooltipElement = 1 === this.activeHandle ? this.firstTooltipElement : this.secondTooltipElement;
                this.isMaterial ? tooltipElement.classList.contains(classNames_materialTooltipOpen) || "transform" === e.propertyName ? ("Default" === this.type && (tooltipElement.style.transition = this.transition.handle), 
                this.refreshTooltip()) : this.openMaterialTooltip() : (tooltipObj.animation = {
                    open: {
                        effect: "None"
                    },
                    close: {
                        effect: "FadeOut",
                        duration: 500
                    }
                }, this.tooltipAnimation());
            }
            "Always" !== this.tooltip.showOn && this.closeTooltip();
        }, Slider.prototype.handleFocusOut = function() {
            this.firstHandle.classList.contains(classNames_sliderHandleFocused) && this.firstHandle.classList.remove(classNames_sliderHandleFocused), 
            "Range" === this.type && this.secondHandle.classList.contains(classNames_sliderHandleFocused) && this.secondHandle.classList.remove(classNames_sliderHandleFocused);
        }, Slider.prototype.handleFocus = function(e) {
            e.currentTarget === this.firstHandle ? this.firstHandle.classList.add(classNames_sliderHandleFocused) : this.secondHandle.classList.add(classNames_sliderHandleFocused);
        }, Slider.prototype.handleOver = function(e) {
            if (this.tooltip.isVisible && "Hover" === this.tooltip.showOn) {
                this.tooltipValue();
                (e.currentTarget === this.firstHandle ? this.firstTooltipObj : this.secondTooltipObj).animation = {
                    open: {
                        effect: "None"
                    },
                    close: {
                        effect: "FadeOut",
                        duration: 500
                    }
                }, e.currentTarget === this.firstHandle ? this.firstTooltipObj.open(this.firstHandle) : this.secondTooltipObj.open(this.secondHandle);
            }
        }, Slider.prototype.handleLeave = function(e) {
            if (this.tooltip.isVisible && "Hover" === this.tooltip.showOn && !e.currentTarget.classList.contains(classNames_sliderHandleFocused) && !e.currentTarget.classList.contains(classNames_sliderTabHandle)) {
                this.tooltipValue();
                var tooltipObj = e.currentTarget === this.firstHandle ? this.firstTooltipObj : this.secondTooltipObj;
                e.currentTarget === this.firstHandle ? this.firstTooltipObj.close() : this.secondTooltipObj.close(), 
                tooltipObj.animation = {
                    open: {
                        effect: "None"
                    },
                    close: {
                        effect: "FadeOut",
                        duration: 500
                    }
                };
            }
        }, Slider.prototype.setHandler = function() {
            this.min > this.max && (this.min = this.max), this.createFirstHandle(), "Range" === this.type && this.createSecondHandle();
        }, Slider.prototype.setEnableRTL = function() {
            this.enableRtl && "Vertical" !== this.orientation ? addClass([ this.sliderContainer ], classNames_rtl) : removeClass([ this.sliderContainer ], classNames_rtl);
            var preDir = "Vertical" !== this.orientation ? this.horDir : this.verDir;
            this.enableRtl ? (this.horDir = "right", this.verDir = "bottom") : (this.horDir = "left", 
            this.verDir = "bottom");
            preDir !== ("Vertical" !== this.orientation ? this.horDir : this.verDir) && "Horizontal" === this.orientation && (setStyleAttribute(this.firstHandle, {
                right: "",
                left: "auto"
            }), "Range" === this.type && setStyleAttribute(this.secondHandle, {
                top: "",
                left: "auto"
            }));
        }, Slider.prototype.tooltipValue = function() {
            var text, args = {
                value: this.value,
                text: ""
            };
            this.setTooltipContent(), args.text = text = this.firstTooltipObj.content, this.trigger("tooltipChange", args), 
            this.addTooltipClass(args.text), text !== args.text && (this.customAriaText = args.text, 
            this.firstTooltipObj.content = args.text, this.setAriaAttrValue(this.firstHandle), 
            "Range" === this.type && (this.secondTooltipObj.content = args.text, this.setAriaAttrValue(this.secondHandle)));
        }, Slider.prototype.setTooltipContent = function() {
            if ("Range" === this.type) {
                var content_1 = this.formatContent(this.tooltipFormatInfo, !1);
                this.firstTooltipObj.content = content_1, this.secondTooltipObj.content = content_1;
            } else if (!isNullOrUndefined(this.handleVal1)) {
                var content_2 = this.formatContent(this.tooltipFormatInfo, !1);
                this.firstTooltipObj.content = content_2;
            }
        }, Slider.prototype.formatContent = function(formatInfo, ariaContent) {
            var content = "";
            return ariaContent ? ("Range" === this.type ? content = this.enableRtl && "Vertical" !== this.orientation ? isNullOrUndefined(this.tooltip) || isNullOrUndefined(this.tooltip.format) ? this.handleVal2.toString() + " - " + this.handleVal1.toString() : this.formatString(this.handleVal2, formatInfo).elementVal + " - " + this.formatString(this.handleVal1, formatInfo).elementVal : isNullOrUndefined(this.tooltip) || isNullOrUndefined(this.tooltip.format) ? this.handleVal1.toString() + " - " + this.handleVal2.toString() : this.formatString(this.handleVal1, formatInfo).elementVal + " - " + this.formatString(this.handleVal2, formatInfo).elementVal : isNullOrUndefined(this.handleVal1) || (content = isNullOrUndefined(this.tooltip) || isNullOrUndefined(this.tooltip.format) ? this.handleVal1.toString() : this.formatString(this.handleVal1, formatInfo).elementVal), 
            content) : ("Range" === this.type ? content = this.enableRtl && "Vertical" !== this.orientation ? isNullOrUndefined(formatInfo.format) ? this.handleVal2.toString() + " - " + this.handleVal1.toString() : this.formatString(this.handleVal2, formatInfo).formatString + " - " + this.formatString(this.handleVal1, formatInfo).formatString : isNullOrUndefined(formatInfo.format) ? this.handleVal1.toString() + " - " + this.handleVal2.toString() : this.formatString(this.handleVal1, formatInfo).formatString + " - " + this.formatString(this.handleVal2, formatInfo).formatString : isNullOrUndefined(this.handleVal1) || (content = isNullOrUndefined(formatInfo.format) ? this.handleVal1.toString() : this.formatString(this.handleVal1, formatInfo).formatString), 
            content);
        }, Slider.prototype.addTooltipClass = function(content) {
            var _this = this;
            if (this.isMaterial && this.tooltip.isVisible) {
                var count_1 = content.toString().length;
                ("Range" !== this.type ? [ this.firstTooltipElement ] : [ this.firstTooltipElement, this.secondTooltipElement ]).forEach(function(element, index) {
                    if (element) count_1 > 4 ? (element.classList.remove(classNames_sliderMaterialDefault), 
                    element.classList.contains(classNames_sliderMaterialRange) || (element.classList.add(classNames_sliderMaterialRange), 
                    element.style.transform = "scale(1)")) : (element.classList.remove(classNames_sliderMaterialRange), 
                    element.classList.contains(classNames_sliderMaterialDefault) || (element.classList.add(classNames_sliderMaterialDefault), 
                    element.style.transform = _this.getTooltipTransformProperties(_this.previousTooltipClass).rotate)); else {
                        var cssClass = count_1 > 4 ? classNames_sliderMaterialRange : classNames_sliderMaterialDefault;
                        index ? _this.secondTooltipObj.cssClass = classNames_sliderTooltip + " " + cssClass : _this.firstTooltipObj.cssClass = classNames_sliderTooltip + " " + cssClass;
                    }
                });
            }
        }, Slider.prototype.tooltipPlacement = function() {
            var tooltipPosition;
            tooltipPosition = "Horizontal" === this.orientation ? "Before" === this.tooltip.placement ? "TopCenter" : "BottomCenter" : "Before" === this.tooltip.placement ? "LeftCenter" : "RightCenter", 
            this.firstTooltipObj.position = tooltipPosition, "Range" === this.type && (this.secondTooltipObj.position = tooltipPosition), 
            this.isMaterial && (this.firstTooltipObj.showTipPointer = !0, this.setProperties({
                tooltip: {
                    showOn: "Always"
                }
            }, !0), this.firstTooltipObj.height = 30, "Range" === this.type && (this.secondTooltipObj.showTipPointer = !0, 
            this.secondTooltipObj.height = 30));
        }, Slider.prototype.tooltipBeforeOpen = function(args) {
            var tooltipElement = args.target === this.firstHandle ? this.firstTooltipElement = args.element : this.secondTooltipElement = args.element;
            if (args.target.removeAttribute("aria-describedby"), this.isMaterial && this.tooltip.isVisible) {
                var transformProperties = this.getTooltipTransformProperties(this.previousTooltipClass);
                tooltipElement.firstChild.classList.add(classNames_materialTooltipHide), this.handleStart(), 
                tooltipElement.firstElementChild.innerText.length > 4 ? tooltipElement.style.transform = transformProperties.translate + " scale(0.01)" : tooltipElement.style.transform = transformProperties.translate + " " + transformProperties.rotate + " scale(0.01)";
            }
        }, Slider.prototype.wireMaterialTooltipEvent = function(destroy) {
            this.isMaterial && this.tooltip.isVisible && (destroy ? (EventHandler.remove(this.firstTooltipElement, "mousedown touchstart", this.sliderDown), 
            "Range" === this.type && EventHandler.remove(this.secondTooltipElement, "mousedown touchstart", this.sliderDown)) : (EventHandler.add(this.firstTooltipElement, "mousedown touchstart", this.sliderDown, this), 
            "Range" === this.type && EventHandler.add(this.secondTooltipElement, "mousedown touchstart", this.sliderDown, this)));
        }, Slider.prototype.tooltipPositionCalculation = function(position) {
            var cssClass;
            switch (position) {
              case "TopCenter":
                cssClass = classNames_horizontalTooltipBefore;
                break;

              case "BottomCenter":
                cssClass = classNames_horizontalTooltipAfter;
                break;

              case "LeftCenter":
                cssClass = classNames_verticalTooltipBefore;
                break;

              case "RightCenter":
                cssClass = classNames_verticalTooltipAfter;
            }
            return cssClass;
        }, Slider.prototype.getTooltipTransformProperties = function(className) {
            if (this.firstTooltipElement) {
                var position = void 0;
                position = "Horizontal" === this.orientation ? this.firstTooltipElement.clientHeight + 14 - this.firstTooltipElement.clientHeight / 2 : this.firstTooltipElement.clientWidth + 14 - this.firstTooltipElement.clientWidth / 2;
                return "Horizontal" === this.orientation ? className === classNames_horizontalTooltipBefore ? {
                    rotate: "rotate(45deg)",
                    translate: "translateY(" + position + "px)"
                } : {
                    rotate: "rotate(225deg)",
                    translate: "translateY(" + -position + "px)"
                } : className === classNames_verticalTooltipBefore ? {
                    rotate: "rotate(-45deg)",
                    translate: "translateX(" + position + "px)"
                } : {
                    rotate: "rotate(-225deg)",
                    translate: "translateX(" + -position + "px)"
                };
            }
        }, Slider.prototype.openMaterialTooltip = function() {
            var _this = this;
            this.refreshTooltip();
            var tooltipElement = 1 === this.activeHandle ? this.firstTooltipElement : this.secondTooltipElement, handle = 1 === this.activeHandle ? this.firstMaterialHandle : this.secondMaterialHandle;
            tooltipElement.firstChild.classList.contains(classNames_materialTooltipHide) && tooltipElement.firstChild.classList.remove(classNames_materialTooltipHide), 
            tooltipElement.firstChild.classList.add(classNames_materialTooltipShow), this.getHandle().style.cursor = "default", 
            tooltipElement.style.transition = this.scaleTransform, tooltipElement.classList.add(classNames_materialTooltipOpen), 
            handle.style.transform = "scale(0)", tooltipElement.firstElementChild.innerText.length > 4 ? tooltipElement.style.transform = "scale(1)" : tooltipElement.style.transform = this.getTooltipTransformProperties(this.previousTooltipClass).rotate, 
            "Default" === this.type ? setTimeout(function() {
                tooltipElement.style.transition = _this.transition.handle;
            }, 2500) : setTimeout(function() {
                tooltipElement.style.transition = "none";
            }, 2500);
        }, Slider.prototype.checkTooltipPosition = function(args) {
            var tooltipPosition = args.target === this.firstHandle ? this.firstHandleTooltipPosition : this.secondHandleTooltipPosition;
            if (void 0 === tooltipPosition || tooltipPosition !== args.collidedPosition) {
                var tooltipClass = this.tooltipPositionCalculation(args.collidedPosition);
                args.element.classList.remove(this.previousTooltipClass), args.element.classList.add(tooltipClass), 
                this.previousTooltipClass = tooltipClass, args.element.style.transform && args.element.classList.contains(classNames_materialTooltipOpen) && args.element.firstElementChild.innerText.length < 4 && (args.element.style.transform = this.getTooltipTransformProperties(this.previousTooltipClass).rotate), 
                args.target === this.firstHandle ? this.firstHandleTooltipPosition = args.collidedPosition : this.secondHandleTooltipPosition = args.collidedPosition;
            }
        }, Slider.prototype.renderTooltip = function() {
            "Auto" === this.tooltip.showOn && this.setProperties({
                tooltip: {
                    showOn: "Hover"
                }
            }, !0), this.firstTooltipObj = new Tooltip({
                showTipPointer: !1,
                cssClass: classNames_sliderTooltip,
                animation: {
                    open: {
                        effect: "None"
                    },
                    close: {
                        effect: "None"
                    }
                },
                opensOn: "Custom",
                beforeOpen: this.tooltipBeforeOpen.bind(this),
                beforeCollision: this.checkTooltipPosition.bind(this),
                afterClose: this.tooltipAfterClose.bind(this)
            }), this.firstTooltipObj.appendTo(this.firstHandle), "Range" === this.type && (this.secondTooltipObj = new Tooltip({
                showTipPointer: !1,
                cssClass: classNames_sliderTooltip,
                animation: {
                    open: {
                        effect: "None"
                    },
                    close: {
                        effect: "None"
                    }
                },
                opensOn: "Custom",
                beforeOpen: this.tooltipBeforeOpen.bind(this),
                beforeCollision: this.checkTooltipPosition.bind(this),
                afterClose: this.tooltipAfterClose.bind(this)
            }), this.secondTooltipObj.appendTo(this.secondHandle)), this.tooltipPlacement(), 
            this.firstHandle.style.transition = "none", "Default" !== this.type && (this.rangeBar.style.transition = "none"), 
            "Range" === this.type && (this.secondHandle.style.transition = "none"), this.isMaterial && (this.sliderContainer.classList.add(classNames_materialSlider), 
            this.tooltipValue(), this.firstTooltipObj.open(this.firstHandle), "Range" === this.type && this.secondTooltipObj.open(this.secondHandle));
        }, Slider.prototype.tooltipAfterClose = function(args) {
            args.element === this.firstTooltipElement ? this.firstTooltipElement = void 0 : this.secondTooltipElement = void 0;
        }, Slider.prototype.setButtons = function() {
            this.firstBtn = createElement("div", {
                className: classNames_sliderButton + " " + classNames_firstButton
            }), this.firstBtn.appendChild(createElement("span", {
                className: classNames_sliderButtonIcon
            })), this.firstBtn.tabIndex = -1, this.secondBtn = createElement("div", {
                className: classNames_sliderButton + " " + classNames_secondButton
            }), this.secondBtn.appendChild(createElement("span", {
                className: classNames_sliderButtonIcon
            })), this.secondBtn.tabIndex = -1, this.sliderContainer.classList.add(classNames_sliderButtonClass), 
            this.sliderContainer.appendChild(this.firstBtn), this.sliderContainer.appendChild(this.secondBtn), 
            this.sliderContainer.appendChild(this.element), this.buttonTitle();
        }, Slider.prototype.buttonTitle = function() {
            var enabledRTL = this.enableRtl && "Vertical" !== this.orientation;
            this.l10n.setLocale(this.locale);
            var decrementTitle = this.l10n.getConstant("decrementTitle"), incrementTitle = this.l10n.getConstant("incrementTitle");
            attributes(enabledRTL ? this.secondBtn : this.firstBtn, {
                "aria-label": decrementTitle,
                title: decrementTitle
            }), attributes(enabledRTL ? this.firstBtn : this.secondBtn, {
                "aria-label": incrementTitle,
                title: incrementTitle
            });
        }, Slider.prototype.buttonFocusOut = function() {
            this.isMaterial && (this.getHandle().style.transform = this.getHandle().style.transform.replace("scale(1.5)", "scale(1)"));
        }, Slider.prototype.repeatButton = function(args) {
            args.target.parentElement;
            !(1 === this.activeHandle ? this.firstTooltipElement : this.secondTooltipElement) && this.tooltip.isVisible && this.openTooltip();
            var value, hVal = this.handleValueUpdate(), enabledRTL = this.enableRtl && "Vertical" !== this.orientation;
            args.target.parentElement.classList.contains(classNames_firstButton) || args.target.classList.contains(classNames_firstButton) ? value = enabledRTL ? this.add(hVal, parseFloat(this.step.toString()), !0) : this.add(hVal, parseFloat(this.step.toString()), !1) : (args.target.parentElement.classList.contains(classNames_secondButton) || args.target.classList.contains(classNames_secondButton)) && (value = enabledRTL ? this.add(hVal, parseFloat(this.step.toString()), !1) : this.add(hVal, parseFloat(this.step.toString()), !0)), 
            value >= this.min && value <= this.max && (this.changeHandleValue(value), this.refreshTooltipOnMove());
        }, Slider.prototype.repeatHandlerMouse = function(args) {
            args.preventDefault(), "mousedown" !== args.type && "touchstart" !== args.type || (this.buttonClick(args), 
            this.repeatInterval = setInterval(this.repeatButton.bind(this), 180, args));
        }, Slider.prototype.materialChange = function() {
            -1 === this.getHandle().style.transform.indexOf("scale(1.5") && (this.getHandle().style.transform = "scale(1.5)");
        }, Slider.prototype.repeatHandlerUp = function(e) {
            this.changeEvent("changed"), this.tooltip.isVisible && "Always" !== this.tooltip.showOn && !this.isMaterial && this.closeTooltip(), 
            clearInterval(this.repeatInterval), this.getHandle().focus();
        }, Slider.prototype.renderScale = function() {
            var orien = "Vertical" === this.orientation ? "v" : "h";
            this.noOfDecimals = this.numberOfDecimals(this.step), this.ul = createElement("ul", {
                className: classNames_scale + " e-" + orien + "-scale " + classNames_tick + "-" + this.ticks.placement.toLowerCase(),
                attrs: {
                    role: "presentation",
                    tabIndex: "-1",
                    "aria-hidden": "true"
                }
            }), Browser.isAndroid && "h" === orien && this.ul.classList.add(classNames_sliderTickPosition);
            var smallStep = this.ticks.smallStep;
            this.ticks.showSmallTicks ? smallStep <= 0 && (smallStep = parseFloat(formatUnit(this.step))) : smallStep = this.ticks.largeStep > 0 ? this.ticks.largeStep : parseFloat(formatUnit(this.max)) - parseFloat(formatUnit(this.min));
            var min = this.fractionalToInteger(this.min), max = this.fractionalToInteger(this.max), steps = this.fractionalToInteger(smallStep), count = Math.abs((max - min) / steps);
            this.element.appendChild(this.ul);
            var li, start = parseFloat(this.min.toString());
            "v" === orien && (start = parseFloat(this.max.toString()));
            var left = 0, tickWidth = 100 / count;
            tickWidth === 1 / 0 && (tickWidth = 5);
            for (var i = 0; i <= count; i++) {
                li = createElement("li", {
                    attrs: {
                        class: classNames_tick,
                        title: start.toString(),
                        role: "presentation",
                        tabIndex: "-1",
                        "aria-hidden": "true"
                    }
                });
                var islargeTick = void 0;
                if (0 === this.numberOfDecimals(this.max) && 0 === this.numberOfDecimals(this.min) && 0 === this.numberOfDecimals(this.step)) islargeTick = "h" === orien ? (start - parseFloat(this.min.toString())) % this.ticks.largeStep == 0 : Math.abs(start - parseFloat(this.max.toString())) % this.ticks.largeStep == 0; else {
                    var largestep = this.fractionalToInteger(this.ticks.largeStep);
                    islargeTick = (this.fractionalToInteger(start) - min) % largestep == 0;
                }
                islargeTick && li.classList.add(classNames_large), "h" === orien ? li.style.width = tickWidth + "%" : li.style.height = tickWidth + "%";
                var repeat = islargeTick ? "Both" === this.ticks.placement ? 2 : 1 : 0;
                if (islargeTick) for (var j = 0; j < repeat; j++) this.createTick(li, start); else this.formatTicksValue(li, start);
                this.ul.appendChild(li), this.tickElementCollection.push(li);
                var decimalPoints = void 0;
                decimalPoints = this.numberOfDecimals(smallStep) > this.numberOfDecimals(start) ? this.numberOfDecimals(smallStep) : this.numberOfDecimals(start), 
                start = "h" === orien ? this.makeRoundNumber(start + smallStep, decimalPoints) : this.makeRoundNumber(start - smallStep, decimalPoints), 
                left = this.makeRoundNumber(left + smallStep, decimalPoints);
            }
            this.firstChild = this.ul.firstElementChild, this.lastChild = this.ul.lastElementChild, 
            this.firstChild.classList.add(classNames_sliderFirstTick), this.lastChild.classList.add(classNames_sliderLastTick), 
            this.sliderContainer.classList.add(classNames_scale + "-" + this.ticks.placement.toLowerCase()), 
            "h" === orien ? (this.firstChild.style.width = tickWidth / 2 + "%", this.lastChild.style.width = tickWidth / 2 + "%") : (this.firstChild.style.height = tickWidth / 2 + "%", 
            this.lastChild.style.height = tickWidth / 2 + "%");
            var eventArgs = {
                ticksWrapper: this.ul,
                tickElements: this.tickElementCollection
            };
            this.trigger("renderedTicks", eventArgs), this.scaleAlignment();
        }, Slider.prototype.createTick = function(li, start) {
            var span = createElement("span", {
                className: classNames_tickValue + " " + classNames_tick + "-" + this.ticks.placement.toLowerCase(),
                attrs: {
                    role: "presentation",
                    tabIndex: "-1",
                    "aria-hidden": "true"
                }
            });
            li.appendChild(span), span.innerHTML = this.formatTicksValue(li, start);
        }, Slider.prototype.formatTicksValue = function(li, start) {
            var tickText = this.formatNumber(start), eventArgs = {
                value: start,
                text: isNullOrUndefined(this.ticks) || isNullOrUndefined(this.ticks.format) ? tickText : this.formatString(start, this.ticksFormatInfo).formatString,
                tickElement: li
            };
            return this.trigger("renderingTicks", eventArgs), li.setAttribute("title", eventArgs.text.toString()), 
            eventArgs.text.toString();
        }, Slider.prototype.scaleAlignment = function() {
            this.tickValuePosition();
            this.orientation;
            "Vertical" === this.orientation ? this.element.getBoundingClientRect().width <= 15 ? this.sliderContainer.classList.add(classNames_sliderSmallSize) : this.sliderContainer.classList.remove(classNames_sliderSmallSize) : this.element.getBoundingClientRect().height <= 15 ? this.sliderContainer.classList.add(classNames_sliderSmallSize) : this.sliderContainer.classList.remove(classNames_sliderSmallSize);
        }, Slider.prototype.tickValuePosition = function() {
            var firstChild, first = this.firstChild.getBoundingClientRect(), smallStep = this.ticks.smallStep, count = Math.abs(parseFloat(formatUnit(this.max)) - parseFloat(formatUnit(this.min))) / smallStep;
            this.firstChild.children.length > 0 && (firstChild = this.firstChild.children[0].getBoundingClientRect());
            var other, tickElements = [ this.sliderContainer.querySelectorAll("." + classNames_tick + "." + classNames_large + " ." + classNames_tickValue) ];
            other = "Both" === this.ticks.placement ? [].slice.call(tickElements[0], 2) : [].slice.call(tickElements[0], 1);
            for (var tickWidth = "Vertical" === this.orientation ? 2 * first.height : 2 * first.width, i = 0; i < this.firstChild.children.length; i++) "Vertical" === this.orientation ? this.firstChild.children[i].style.top = -firstChild.height / 2 + "px" : this.enableRtl ? this.firstChild.children[i].style.left = (tickWidth - this.firstChild.children[i].getBoundingClientRect().width) / 2 + "px" : this.firstChild.children[i].style.left = -firstChild.width / 2 + "px";
            for (i = 0; i < other.length; i++) {
                var otherChild = other[i].getBoundingClientRect();
                "Vertical" === this.orientation ? setStyleAttribute(other[i], {
                    top: (tickWidth - otherChild.height) / 2 + "px"
                }) : setStyleAttribute(other[i], {
                    left: (tickWidth - otherChild.width) / 2 + "px"
                });
            }
            this.enableRtl && this.lastChild.children.length && 0 !== count && (this.lastChild.children[0].style.left = -this.lastChild.getBoundingClientRect().width / 2 + "px", 
            "Both" === this.ticks.placement && (this.lastChild.children[1].style.left = -this.lastChild.getBoundingClientRect().width / 2 + "px")), 
            0 === count && ("Horizontal" === this.orientation && (this.enableRtl ? (this.firstChild.classList.remove(classNames_sliderLastTick), 
            this.firstChild.style.right = this.firstHandle.style.right, this.firstChild.children[0].style.left = this.firstChild.getBoundingClientRect().width / 2 + 2 + "px", 
            "Both" === this.ticks.placement && (this.firstChild.children[1].style.left = this.firstChild.getBoundingClientRect().width / 2 + 2 + "px")) : (this.firstChild.classList.remove(classNames_sliderLastTick), 
            this.firstChild.style.left = this.firstHandle.style.left)), "Vertical" === this.orientation && this.firstChild.classList.remove(classNames_sliderLastTick));
        }, Slider.prototype.setAriaAttrValue = function(element) {
            var ariaValueText, isTickFormatted = !isNullOrUndefined(this.ticks) && !isNullOrUndefined(this.ticks.format), text = isTickFormatted ? this.formatContent(this.tooltipFormatInfo, !1) : this.formatContent(this.ticksFormatInfo, !1), valuenow = isTickFormatted ? this.formatContent(this.ticksFormatInfo, !0) : this.formatContent(this.tooltipFormatInfo, !0);
            ariaValueText = 2 === (text = this.customAriaText ? this.customAriaText : text).split(" - ").length ? text.split(" - ") : [ text, text ], 
            this.setAriaAttributes(element), "Range" !== this.type ? attributes(element, {
                "aria-valuenow": valuenow,
                "aria-valuetext": text
            }) : this.enableRtl ? element === this.firstHandle ? attributes(element, {
                "aria-valuenow": valuenow.split(" - ")[1],
                "aria-valuetext": ariaValueText[1]
            }) : attributes(element, {
                "aria-valuenow": valuenow.split(" - ")[0],
                "aria-valuetext": ariaValueText[0]
            }) : element === this.firstHandle ? attributes(element, {
                "aria-valuenow": valuenow.split(" - ")[0],
                "aria-valuetext": ariaValueText[0]
            }) : attributes(element, {
                "aria-valuenow": valuenow.split(" - ")[1],
                "aria-valuetext": ariaValueText[1]
            });
        }, Slider.prototype.handleValueUpdate = function() {
            return "Range" === this.type ? 1 === this.activeHandle ? this.handleVal1 : this.handleVal2 : this.handleVal1;
        }, Slider.prototype.buttonClick = function(args) {
            var value, enabledRTL = this.enableRtl && "Vertical" !== this.orientation, hVal = this.handleValueUpdate();
            40 === args.keyCode || 37 === args.keyCode || args.currentTarget.classList.contains(classNames_firstButton) ? value = enabledRTL ? this.add(hVal, parseFloat(this.step.toString()), !0) : this.add(hVal, parseFloat(this.step.toString()), !1) : 38 === args.keyCode || 39 === args.keyCode || args.currentTarget.classList.contains(classNames_secondButton) ? value = enabledRTL ? this.add(hVal, parseFloat(this.step.toString()), !1) : this.add(hVal, parseFloat(this.step.toString()), !0) : 33 === args.keyCode || args.currentTarget.classList.contains(classNames_firstButton) ? value = enabledRTL ? this.add(hVal, parseFloat(this.ticks.largeStep.toString()), !1) : this.add(hVal, parseFloat(this.ticks.largeStep.toString()), !0) : 34 === args.keyCode || args.currentTarget.classList.contains(classNames_secondButton) ? value = enabledRTL ? this.add(hVal, parseFloat(this.ticks.largeStep.toString()), !0) : this.add(hVal, parseFloat(this.ticks.largeStep.toString()), !1) : 36 === args.keyCode ? value = parseFloat(this.min.toString()) : 35 === args.keyCode && (value = parseFloat(this.max.toString())), 
            this.changeHandleValue(value), !this.isMaterial || this.tooltip.isVisible || this.getHandle().classList.contains(classNames_sliderTabHandle) || this.materialChange(), 
            this.tooltipAnimation(), this.getHandle().focus(), args.currentTarget.classList.contains(classNames_firstButton) && EventHandler.add(this.firstBtn, "mouseup touchend", this.buttonUp, this), 
            args.currentTarget.classList.contains(classNames_secondButton) && EventHandler.add(this.secondBtn, "mouseup touchend", this.buttonUp, this);
        }, Slider.prototype.tooltipAnimation = function() {
            if (this.tooltip.isVisible) {
                var tooltipObj = 1 === this.activeHandle ? this.firstTooltipObj : this.secondTooltipObj, tooltipElement = 1 === this.activeHandle ? this.firstTooltipElement : this.secondTooltipElement;
                this.isMaterial ? tooltipElement.classList.contains(classNames_materialTooltipOpen) ? this.refreshTooltip() : this.openMaterialTooltip() : (tooltipObj.animation = {
                    open: {
                        effect: "None"
                    },
                    close: {
                        effect: "FadeOut",
                        duration: 500
                    }
                }, this.openTooltip());
            }
        }, Slider.prototype.buttonUp = function(args) {
            if (this.tooltip.isVisible && !this.isMaterial) {
                (1 === this.activeHandle ? this.firstTooltipObj : this.secondTooltipObj).animation = {
                    open: {
                        effect: "None"
                    },
                    close: {
                        effect: "None"
                    }
                };
            }
            args.currentTarget.classList.contains(classNames_firstButton) && EventHandler.remove(this.firstBtn, "mouseup touchend", this.buttonUp), 
            args.currentTarget.classList.contains(classNames_secondButton) && EventHandler.remove(this.secondBtn, "mouseup touchend", this.buttonUp);
        }, Slider.prototype.setRangeBar = function() {
            "Horizontal" === this.orientation ? "MinRange" === this.type ? (this.enableRtl ? this.rangeBar.style.right = "0px" : this.rangeBar.style.left = "0px", 
            setStyleAttribute(this.rangeBar, {
                width: isNullOrUndefined(this.handlePos1) ? 0 : this.handlePos1 + "px"
            })) : (this.enableRtl ? this.rangeBar.style.right = this.handlePos1 + "px" : this.rangeBar.style.left = this.handlePos1 + "px", 
            setStyleAttribute(this.rangeBar, {
                width: this.handlePos2 - this.handlePos1 + "px"
            })) : "MinRange" === this.type ? (this.rangeBar.style.bottom = "0px", setStyleAttribute(this.rangeBar, {
                height: isNullOrUndefined(this.handlePos1) ? 0 : this.handlePos1 + "px"
            })) : (this.rangeBar.style.bottom = this.handlePos1 + "px", setStyleAttribute(this.rangeBar, {
                height: this.handlePos2 - this.handlePos1 + "px"
            }));
        }, Slider.prototype.setValue = function() {
            this.handleVal1 = isNullOrUndefined(this.value) ? this.checkHandleValue(parseFloat(this.min.toString())) : this.checkHandleValue(parseFloat(this.value.toString())), 
            this.handlePos1 = this.checkHandlePosition(this.handleVal1), this.preHandlePos1 = this.handlePos1, 
            isNullOrUndefined(this.activeHandle) ? "Range" === this.type ? this.activeHandle = 2 : this.activeHandle = 1 : this.activeHandle = this.activeHandle, 
            "Default" === this.type || "MinRange" === this.type ? (this.setHandlePosition(), 
            this.handleStart(), this.value = this.handleVal1, this.setAriaAttrValue(this.firstHandle), 
            this.changeEvent("changed")) : this.validateRangeValue(), "Default" !== this.type && this.setRangeBar();
        }, Slider.prototype.rangeValueUpdate = function() {
            null !== this.value && "object" == typeof this.value || (this.value = [ parseFloat(formatUnit(this.min)), parseFloat(formatUnit(this.max)) ]);
        }, Slider.prototype.validateRangeValue = function() {
            this.rangeValueUpdate(), this.setRangeValue();
        }, Slider.prototype.modifyZindex = function() {
            "Range" === this.type ? 1 === this.activeHandle ? (this.firstHandle.style.zIndex = this.zIndex + 4 + "", 
            this.secondHandle.style.zIndex = this.zIndex + 3 + "", this.isMaterial && this.tooltip.isVisible && this.firstTooltipElement && this.secondTooltipElement && (this.firstTooltipElement.style.zIndex = this.zIndex + 4 + "", 
            this.secondTooltipElement.style.zIndex = this.zIndex + 3 + "")) : (this.firstHandle.style.zIndex = this.zIndex + 3 + "", 
            this.secondHandle.style.zIndex = this.zIndex + 4 + "", this.isMaterial && this.tooltip.isVisible && this.firstTooltipElement && this.secondTooltipElement && (this.firstTooltipElement.style.zIndex = this.zIndex + 3 + "", 
            this.secondTooltipElement.style.zIndex = this.zIndex + 4 + "")) : this.isMaterial && this.tooltip.isVisible && this.firstTooltipElement && (this.firstTooltipElement.style.zIndex = this.zIndex + 4 + "");
        }, Slider.prototype.setHandlePosition = function() {
            var handle, tooltipElement, _this = this, pos = 1 === this.activeHandle ? this.handlePos1 : this.handlePos2;
            1 === this.activeHandle ? this.handleVal1 : this.handleVal2;
            this.isMaterial && this.tooltip.isVisible ? (tooltipElement = 1 === this.activeHandle ? this.firstTooltipElement : this.secondTooltipElement, 
            handle = [ this.getHandle(), 1 === this.activeHandle ? this.firstMaterialHandle : this.secondMaterialHandle ]) : handle = [ this.getHandle() ], 
            this.tooltip.isVisible && 0 === pos && "Range" !== this.type ? (handle[0].classList.add(classNames_sliderHandleStart), 
            this.isMaterial && (handle[1].classList.add(classNames_sliderHandleStart), tooltipElement && tooltipElement.classList.add(classNames_sliderTooltipStart))) : (handle[0].classList.remove(classNames_sliderHandleStart), 
            this.tooltip.isVisible && this.isMaterial && (handle[1].classList.remove(classNames_sliderHandleStart), 
            tooltipElement && tooltipElement.classList.remove(classNames_sliderTooltipStart))), 
            handle.forEach(function(handle) {
                "Horizontal" === _this.orientation ? _this.enableRtl ? handle.style.right = pos + "px" : handle.style.left = pos + "px" : handle.style.bottom = pos + "px";
            }), this.changeEvent("change");
        }, Slider.prototype.getHandle = function() {
            return 1 === this.activeHandle ? this.firstHandle : this.secondHandle;
        }, Slider.prototype.setRangeValue = function() {
            this.activeHandle;
            this.updateRangeValue(), this.activeHandle = 1, this.setHandlePosition(), this.activeHandle = 2, 
            this.setHandlePosition(), this.activeHandle = 1;
        }, Slider.prototype.changeEvent = function(eventName) {
            var previous = "change" === eventName ? this.previousVal : this.previousChanged;
            if ("Range" !== this.type) this.setProperties({
                value: this.handleVal1
            }, !0), previous !== this.value && (this.trigger(eventName, this.changeEventArgs(eventName)), 
            this.setPreviousVal(eventName, this.value)), this.setAriaAttrValue(this.firstHandle); else {
                var value = this.value = [ this.handleVal1, this.handleVal2 ];
                this.setProperties({
                    value: value
                }, !0), (previous.length === this.value.length && this.value[0] !== previous[0] || this.value[1] !== previous[1]) && (this.trigger(eventName, this.changeEventArgs(eventName)), 
                this.setPreviousVal(eventName, this.value)), this.setAriaAttrValue(this.getHandle());
            }
            this.hiddenInput.value = this.value.toString();
        }, Slider.prototype.changeEventArgs = function(eventName) {
            var eventArgs;
            return this.tooltip.isVisible && this.firstTooltipObj ? (this.tooltipValue(), eventArgs = {
                value: this.value,
                previousValue: "change" === eventName ? this.previousVal : this.previousChanged,
                action: eventName,
                text: this.firstTooltipObj.content
            }) : eventArgs = {
                value: this.value,
                previousValue: "change" === eventName ? this.previousVal : this.previousChanged,
                action: eventName,
                text: isNullOrUndefined(this.ticksFormatInfo.format) ? this.value.toString() : "Range" !== this.type ? this.formatString(this.value, this.ticksFormatInfo).formatString : this.formatString(this.value[0], this.ticksFormatInfo).formatString + " - " + this.formatString(this.value[1], this.ticksFormatInfo).formatString
            }, eventArgs;
        }, Slider.prototype.setPreviousVal = function(eventName, value) {
            "change" === eventName ? this.previousVal = value : this.previousChanged = value;
        }, Slider.prototype.updateRangeValue = function() {
            var values = this.value.toString().split(",").map(Number);
            this.enableRtl && "Vertical" !== this.orientation || this.rtl ? this.value = [ values[1], values[0] ] : this.value = [ values[0], values[1] ], 
            this.enableRtl && "Vertical" !== this.orientation ? (this.handleVal1 = this.checkHandleValue(this.value[1]), 
            this.handleVal2 = this.checkHandleValue(this.value[0])) : (this.handleVal1 = this.checkHandleValue(this.value[0]), 
            this.handleVal2 = this.checkHandleValue(this.value[1])), this.handlePos1 = this.checkHandlePosition(this.handleVal1), 
            this.handlePos2 = this.checkHandlePosition(this.handleVal2), this.handlePos1 > this.handlePos2 && (this.handlePos1 = this.handlePos2, 
            this.handleVal1 = this.handleVal2), this.preHandlePos1 = this.handlePos1, this.preHandlePos2 = this.handlePos2;
        }, Slider.prototype.checkHandlePosition = function(value) {
            var pos;
            return value = 100 * (value - parseFloat(formatUnit(this.min))) / (parseFloat(formatUnit(this.max)) - parseFloat(formatUnit(this.min))), 
            pos = "Horizontal" === this.orientation ? this.element.getBoundingClientRect().width * (value / 100) : this.element.getBoundingClientRect().height * (value / 100), 
            parseFloat(formatUnit(this.max)) === parseFloat(formatUnit(this.min)) && (pos = "Horizontal" === this.orientation ? this.element.getBoundingClientRect().width : this.element.getBoundingClientRect().height), 
            pos;
        }, Slider.prototype.checkHandleValue = function(value) {
            if (this.min > this.max && (this.min = this.max), this.min === this.max) return parseFloat(formatUnit(this.max));
            var handle = this.tempStartEnd();
            return value < handle.start ? value = handle.start : value > handle.end && (value = handle.end), 
            value;
        }, Slider.prototype.onResize = function() {
            var _this = this;
            this.firstHandle.style.transition = "none", "Default" !== this.type && (this.rangeBar.style.transition = "none"), 
            "Range" === this.type && (this.secondHandle.style.transition = "none"), this.handlePos1 = this.checkHandlePosition(this.handleVal1), 
            this.handleVal2 && (this.handlePos2 = this.checkHandlePosition(this.handleVal2)), 
            "Horizontal" === this.orientation ? (this.enableRtl ? this.firstHandle.style.right = this.handlePos1 + "px" : this.firstHandle.style.left = this.handlePos1 + "px", 
            this.isMaterial && this.tooltip.isVisible && this.firstMaterialHandle && (this.enableRtl ? this.firstMaterialHandle.style.right = this.handlePos1 + "px" : this.firstMaterialHandle.style.left = this.handlePos1 + "px"), 
            "MinRange" === this.type ? (this.enableRtl ? this.rangeBar.style.right = "0px" : this.rangeBar.style.left = "0px", 
            setStyleAttribute(this.rangeBar, {
                width: isNullOrUndefined(this.handlePos1) ? 0 : this.handlePos1 + "px"
            })) : "Range" === this.type && (this.enableRtl ? this.secondHandle.style.right = this.handlePos2 + "px" : this.secondHandle.style.left = this.handlePos2 + "px", 
            this.isMaterial && this.tooltip.isVisible && this.secondMaterialHandle && (this.enableRtl ? this.secondMaterialHandle.style.right = this.handlePos2 + "px" : this.secondMaterialHandle.style.left = this.handlePos2 + "px"), 
            this.enableRtl ? this.rangeBar.style.right = this.handlePos1 + "px" : this.rangeBar.style.left = this.handlePos1 + "px", 
            setStyleAttribute(this.rangeBar, {
                width: this.handlePos2 - this.handlePos1 + "px"
            }))) : (this.firstHandle.style.bottom = this.handlePos1 + "px", this.isMaterial && this.tooltip.isVisible && this.firstMaterialHandle && (this.firstMaterialHandle.style.bottom = this.handlePos1 + "px"), 
            "MinRange" === this.type ? (this.rangeBar.style.bottom = "0px", setStyleAttribute(this.rangeBar, {
                height: isNullOrUndefined(this.handlePos1) ? 0 : this.handlePos1 + "px"
            })) : "Range" === this.type && (this.secondHandle.style.bottom = this.handlePos2 + "px", 
            this.isMaterial && this.tooltip.isVisible && this.secondMaterialHandle && (this.secondMaterialHandle.style.bottom = this.handlePos2 + "px"), 
            this.rangeBar.style.bottom = this.handlePos1 + "px", setStyleAttribute(this.rangeBar, {
                height: this.handlePos2 - this.handlePos1 + "px"
            }))), "None" !== this.ticks.placement && this.ul && (this.removeElement(this.ul), 
            this.renderScale()), this.tooltip.isVisible || setTimeout(function() {
                _this.firstHandle.style.transition = _this.scaleTransform, "Range" === _this.type && (_this.secondHandle.style.transition = _this.scaleTransform);
            }), this.refreshTooltip();
        }, Slider.prototype.changeHandleValue = function(value) {
            var position = null;
            1 === this.activeHandle ? (this.handleVal1 = this.checkHandleValue(value), this.handlePos1 = this.checkHandlePosition(this.handleVal1), 
            "Range" === this.type && this.handlePos1 > this.handlePos2 && (this.handlePos1 = this.handlePos2, 
            this.handleVal1 = this.handleVal2), this.handlePos1 !== this.preHandlePos1 && (position = this.preHandlePos1 = this.handlePos1), 
            this.modifyZindex()) : (this.handleVal2 = this.checkHandleValue(value), this.handlePos2 = this.checkHandlePosition(this.handleVal2), 
            "Range" === this.type && this.handlePos2 < this.handlePos1 && (this.handlePos2 = this.handlePos1, 
            this.handleVal2 = this.handleVal1), this.handlePos2 !== this.preHandlePos2 && (position = this.preHandlePos2 = this.handlePos2), 
            this.modifyZindex()), null !== position && ("Default" !== this.type && this.setRangeBar(), 
            this.setHandlePosition());
        }, Slider.prototype.tempStartEnd = function() {
            return this.min > this.max ? {
                start: this.max,
                end: this.min
            } : {
                start: this.min,
                end: this.max
            };
        }, Slider.prototype.xyToPosition = function(position) {
            if (this.min === this.max) return 100;
            if ("Horizontal" === this.orientation) {
                var left = position.x - this.element.getBoundingClientRect().left, num = this.element.offsetWidth / 100;
                this.val = left / num;
            } else {
                var top_1 = position.y - this.element.getBoundingClientRect().top;
                num = this.element.offsetHeight / 100;
                this.val = 100 - top_1 / num;
            }
            var val = this.stepValueCalculation(this.val);
            return val < 0 ? val = 0 : val > 100 && (val = 100), this.enableRtl && "Vertical" !== this.orientation && (val = 100 - val), 
            "Horizontal" === this.orientation ? this.element.getBoundingClientRect().width * (val / 100) : this.element.getBoundingClientRect().height * (val / 100);
        }, Slider.prototype.stepValueCalculation = function(value) {
            0 === this.step && (this.step = 1);
            var percentStep = parseFloat(formatUnit(this.step)) / ((parseFloat(formatUnit(this.max)) - parseFloat(formatUnit(this.min))) / 100), remain = value % Math.abs(percentStep);
            return 0 !== remain && (percentStep / 2 > remain ? value -= remain : value += Math.abs(percentStep) - remain), 
            value;
        }, Slider.prototype.add = function(a, b, addition) {
            var x = Math.pow(10, 3);
            return addition ? (Math.round(a * x) + Math.round(b * x)) / x : (Math.round(a * x) - Math.round(b * x)) / x;
        }, Slider.prototype.round = function(a) {
            var f = this.step.toString().split(".");
            return f[1] ? parseFloat(a.toFixed(f[1].length)) : Math.round(a);
        }, Slider.prototype.positionToValue = function(pos) {
            var val, diff = parseFloat(formatUnit(this.max)) - parseFloat(formatUnit(this.min));
            val = "Horizontal" === this.orientation ? pos / this.element.getBoundingClientRect().width * diff : pos / this.element.getBoundingClientRect().height * diff;
            return this.add(val, parseFloat(this.min.toString()), !0);
        }, Slider.prototype.sliderBarClick = function(evt) {
            evt.preventDefault();
            var pos;
            "mousedown" === evt.type || "click" === evt.type ? pos = {
                x: evt.clientX,
                y: evt.clientY
            } : "touchstart" === evt.type && (pos = {
                x: evt.changedTouches[0].clientX,
                y: evt.changedTouches[0].clientY
            });
            var handlepos = this.xyToPosition(pos), handleVal = this.positionToValue(handlepos);
            if ("Range" !== this.type && (this.handleVal1 = handleVal, this.firstHandle.classList.add(classNames_sliderActiveHandle)), 
            "Range" === this.type && this.handlePos2 - handlepos < handlepos - this.handlePos1 ? (this.secondHandle.classList.add(classNames_sliderActiveHandle), 
            this.handlePos2 = this.preHandlePos2 = handlepos, this.handleVal2 = handleVal, this.activeHandle = 2, 
            this.modifyZindex(), this.secondHandle.focus()) : (this.firstHandle.classList.add(classNames_sliderActiveHandle), 
            this.handlePos1 = this.preHandlePos1 = handlepos, this.handleVal1 = handleVal, this.activeHandle = 1, 
            this.modifyZindex(), this.firstHandle.focus()), this.isMaterial && this.tooltip.isVisible) {
                (1 === this.activeHandle ? this.firstTooltipElement : this.secondTooltipElement).classList.add(classNames_materialTooltipActive);
            }
            var focusedElement = this.element.querySelector("." + classNames_sliderTabHandle);
            focusedElement && this.getHandle() !== focusedElement && focusedElement.classList.remove(classNames_sliderTabHandle);
            var handle = 1 === this.activeHandle ? this.firstHandle : this.secondHandle;
            if (evt.target === handle) return !this.isMaterial || this.tooltip.isVisible || this.getHandle().classList.contains(classNames_sliderTabHandle) || this.materialChange(), 
            void this.tooltipAnimation();
            if (this.checkRepeatedValue(handleVal)) {
                var transition = this.isMaterial && this.tooltip.isVisible ? this.transitionOnMaterialTooltip : this.transition;
                this.getHandle().style.transition = transition.handle, "Default" !== this.type && (this.rangeBar.style.transition = transition.rangeBar), 
                this.setHandlePosition(), "Default" !== this.type && this.setRangeBar();
            }
        }, Slider.prototype.refreshTooltipOnMove = function() {
            this.tooltip.isVisible && (this.tooltipValue(), 1 === this.activeHandle ? this.firstTooltipObj.refresh(this.firstHandle) : this.secondTooltipObj.refresh(this.secondHandle));
        }, Slider.prototype.sliderDown = function(event) {
            event.preventDefault(), this.sliderBarClick(event), EventHandler.add(document, "mousemove touchmove", this.sliderBarMove, this), 
            EventHandler.add(document, "mouseup touchend", this.sliderBarUp, this);
        }, Slider.prototype.sliderBarUp = function() {
            if (this.changeEvent("changed"), this.handleFocusOut(), this.firstHandle.classList.remove(classNames_sliderActiveHandle), 
            "Range" === this.type && this.secondHandle.classList.remove(classNames_sliderActiveHandle), 
            this.tooltip.isVisible && ("Always" !== this.tooltip.showOn && this.closeTooltip(), 
            !this.isMaterial)) {
                (1 === this.activeHandle ? this.firstTooltipObj : this.secondTooltipObj).animation = {
                    open: {
                        effect: "None"
                    },
                    close: {
                        effect: "None"
                    }
                };
            }
            if (this.isMaterial && (this.getHandle().style.transform = this.getHandle().style.transform.replace("scale(1.5)", "scale(1)"), 
            this.tooltip.isVisible)) {
                (1 === this.activeHandle ? this.firstTooltipElement : this.secondTooltipElement).classList.remove(classNames_materialTooltipActive);
            }
            EventHandler.remove(document, "mousemove touchmove", this.sliderBarMove), EventHandler.remove(document, "mouseup touchend", this.sliderBarUp);
        }, Slider.prototype.sliderBarMove = function(evt) {
            "touchmove" !== evt.type && evt.preventDefault();
            var pos;
            pos = "mousemove" === evt.type ? {
                x: evt.clientX,
                y: evt.clientY
            } : {
                x: evt.changedTouches[0].clientX,
                y: evt.changedTouches[0].clientY
            };
            var handlepos = this.xyToPosition(pos), handleVal = this.positionToValue(handlepos);
            if (handlepos = Math.round(handlepos), "Range" !== this.type && 1 === this.activeHandle && (this.handlePos1 = handlepos, 
            this.handleVal1 = handleVal, this.firstHandle.classList.add(classNames_sliderActiveHandle)), 
            "Range" === this.type && (1 === this.activeHandle ? (this.firstHandle.classList.add(classNames_sliderActiveHandle), 
            handlepos > this.handlePos2 && (handlepos = this.handlePos2, handleVal = this.handleVal2), 
            handlepos !== this.preHandlePos1 && (this.handlePos1 = this.preHandlePos1 = handlepos, 
            this.handleVal1 = handleVal, this.activeHandle = 1)) : 2 === this.activeHandle && (this.secondHandle.classList.add(classNames_sliderActiveHandle), 
            handlepos < this.handlePos1 && (handlepos = this.handlePos1, handleVal = this.handleVal1), 
            handlepos !== this.preHandlePos2 && (this.handlePos2 = this.preHandlePos2 = handlepos, 
            this.handleVal2 = handleVal, this.activeHandle = 2))), this.checkRepeatedValue(handleVal)) {
                this.getHandle().style.transition = this.scaleTransform, "Default" !== this.type && (this.rangeBar.style.transition = "none"), 
                this.setHandlePosition(), !this.isMaterial || this.tooltip.isVisible || this.getHandle().classList.contains(classNames_sliderTabHandle) || this.materialChange();
                var tooltipElement = 1 === this.activeHandle ? this.firstTooltipElement : this.secondTooltipElement;
                this.tooltip.isVisible && (this.isMaterial ? tooltipElement.classList.contains(classNames_materialTooltipOpen) ? this.refreshTooltipOnMove() : this.openMaterialTooltip() : tooltipElement ? this.refreshTooltipOnMove() : this.openTooltip()), 
                "Default" !== this.type && this.setRangeBar();
            }
        }, Slider.prototype.checkRepeatedValue = function(currentValue) {
            if ("Range" === this.type) {
                if (currentValue === (this.enableRtl && "Vertical" !== this.orientation ? 1 === this.activeHandle ? this.previousVal[1] : this.previousVal[0] : 1 === this.activeHandle ? this.previousVal[0] : this.previousVal[1])) return 0;
            } else if (currentValue === this.previousVal) return 0;
            return 1;
        }, Slider.prototype.refreshTooltip = function() {
            this.tooltip.isVisible && this.firstTooltipObj && (this.tooltipValue(), this.firstTooltipObj.refresh(this.firstHandle), 
            "Range" === this.type && this.secondTooltipObj.refresh(this.secondHandle));
        }, Slider.prototype.openTooltip = function() {
            this.tooltip.isVisible && this.firstTooltipObj && (this.tooltipValue(), this.isMaterial ? this.openMaterialTooltip() : 1 === this.activeHandle ? this.firstTooltipObj.open(this.firstHandle) : this.secondTooltipObj.open(this.secondHandle));
        }, Slider.prototype.keyDown = function(event) {
            switch (event.keyCode) {
              case 37:
              case 38:
              case 39:
              case 40:
              case 33:
              case 34:
              case 36:
              case 35:
                event.preventDefault(), this.buttonClick(event), this.tooltip.isVisible && "Always" !== this.tooltip.showOn && !this.isMaterial && this.closeTooltip();
            }
        }, Slider.prototype.wireButtonEvt = function(destroy) {
            destroy ? (EventHandler.remove(this.firstBtn, "mouseleave touchleave", this.buttonFocusOut), 
            EventHandler.remove(this.secondBtn, "mouseleave touchleave", this.buttonFocusOut), 
            EventHandler.remove(this.firstBtn, "mousedown touchstart", this.repeatHandlerMouse), 
            EventHandler.remove(this.firstBtn, "mouseup mouseleave touchup touchend", this.repeatHandlerUp), 
            EventHandler.remove(this.secondBtn, "mousedown touchstart", this.repeatHandlerMouse), 
            EventHandler.remove(this.secondBtn, "mouseup mouseleave touchup touchend", this.repeatHandlerUp), 
            EventHandler.remove(this.firstBtn, "focusout", this.sliderFocusOut), EventHandler.remove(this.secondBtn, "focusout", this.sliderFocusOut)) : (EventHandler.add(this.firstBtn, "mouseleave touchleave", this.buttonFocusOut, this), 
            EventHandler.add(this.secondBtn, "mouseleave touchleave", this.buttonFocusOut, this), 
            EventHandler.add(this.firstBtn, "mousedown touchstart", this.repeatHandlerMouse, this), 
            EventHandler.add(this.firstBtn, "mouseup mouseleave touchup touchend", this.repeatHandlerUp, this), 
            EventHandler.add(this.secondBtn, "mousedown touchstart", this.repeatHandlerMouse, this), 
            EventHandler.add(this.secondBtn, "mouseup mouseleave touchup touchend", this.repeatHandlerUp, this), 
            EventHandler.add(this.firstBtn, "focusout", this.sliderFocusOut, this), EventHandler.add(this.secondBtn, "focusout", this.sliderFocusOut, this));
        }, Slider.prototype.wireEvents = function() {
            this.onresize = this.onResize.bind(this), window.addEventListener("resize", this.onresize), 
            this.enabled && !this.readOnly && (EventHandler.add(this.element, "mousedown touchstart", this.sliderDown, this), 
            EventHandler.add(this.sliderContainer, "keydown", this.keyDown, this), EventHandler.add(this.sliderContainer, "keyup", this.keyUp, this), 
            EventHandler.add(this.element, "focusout", this.sliderFocusOut, this), EventHandler.add(this.sliderContainer, "mouseover mouseout touchstart touchend", this.hover, this), 
            this.wireFirstHandleEvt(!1), "Range" === this.type && this.wireSecondHandleEvt(!1), 
            this.showButtons && this.wireButtonEvt(!1), this.wireMaterialTooltipEvent(!1));
        }, Slider.prototype.unwireEvents = function() {
            EventHandler.remove(this.element, "mousedown touchstart", this.sliderDown), EventHandler.remove(this.sliderContainer, "keydown", this.keyDown), 
            EventHandler.remove(this.sliderContainer, "keyup", this.keyUp), EventHandler.remove(this.element, "focusout", this.sliderFocusOut), 
            EventHandler.remove(this.sliderContainer, "mouseover mouseout touchstart touchend", this.hover), 
            this.wireFirstHandleEvt(!0), "Range" === this.type && this.wireSecondHandleEvt(!0), 
            this.showButtons && this.wireButtonEvt(!0), this.wireMaterialTooltipEvent(!0);
        }, Slider.prototype.keyUp = function(event) {
            if (9 === event.keyCode && event.target.classList.contains(classNames_sliderHandle) && !event.target.classList.contains(classNames_sliderTabHandle)) {
                this.element.querySelector("." + classNames_sliderTabHandle) && this.element.querySelector("." + classNames_sliderTabHandle).classList.remove(classNames_sliderTabHandle), 
                event.target.classList.add(classNames_sliderTabHandle);
                var parentElement = event.target.parentElement;
                parentElement === this.element && (parentElement.querySelector("." + classNames_sliderTrack).classList.add(classNames_sliderTabTrack), 
                "Range" !== this.type && "MinRange" !== this.type || parentElement.querySelector("." + classNames_rangeBar).classList.add(classNames_sliderTabRange)), 
                "Range" === this.type && (event.target.previousSibling.classList.contains(classNames_sliderHandle) ? this.activeHandle = 2 : this.activeHandle = 1), 
                this.tooltipAnimation(), this.tooltip.isVisible && "Always" !== this.tooltip.showOn && !this.isMaterial && this.closeTooltip();
            }
            this.changeEvent("changed");
        }, Slider.prototype.hover = function(event) {
            isNullOrUndefined(event) || ("mouseover" === event.type || "touchmove" === event.type || "mousemove" === event.type || "pointermove" === event.type || "touchstart" === event.type ? this.sliderContainer.classList.add(classNames_sliderHover) : this.sliderContainer.classList.remove(classNames_sliderHover));
        }, Slider.prototype.sliderFocusOut = function(event) {
            var _this = this;
            if (event.relatedTarget !== this.secondHandle && event.relatedTarget !== this.firstHandle && event.relatedTarget !== this.element && event.relatedTarget !== this.firstBtn && event.relatedTarget !== this.secondBtn) {
                if (this.hiddenInput.focus(), this.hiddenInput.blur(), this.isMaterial && this.tooltip.isVisible) {
                    var transformProperties_1 = this.getTooltipTransformProperties(this.previousTooltipClass), tooltipElement = "Range" !== this.type ? [ this.firstTooltipElement ] : [ this.firstTooltipElement, this.secondTooltipElement ], hiddenHandle_1 = "Range" !== this.type ? [ this.firstHandle ] : [ this.firstHandle, this.secondHandle ], handle_1 = "Range" !== this.type ? [ this.firstMaterialHandle ] : [ this.firstMaterialHandle, this.secondMaterialHandle ];
                    tooltipElement.forEach(function(tooltipElement, index) {
                        tooltipElement && (tooltipElement.style.transition = _this.scaleTransform, tooltipElement.firstChild.classList.remove(classNames_materialTooltipShow), 
                        tooltipElement.firstChild.classList.add(classNames_materialTooltipHide), hiddenHandle_1[index].style.cursor = "-webkit-grab", 
                        hiddenHandle_1[index].style.cursor = "grab", handle_1[index].style.transform = "scale(1)", 
                        tooltipElement.classList.remove(classNames_materialTooltipOpen), tooltipElement.firstElementChild.innerText.length > 4 ? tooltipElement.style.transform = transformProperties_1.translate + " scale(0.01)" : tooltipElement.style.transform = transformProperties_1.translate + " " + transformProperties_1.rotate + " scale(0.01)", 
                        setTimeout(function() {
                            tooltipElement.style.transition = "none";
                        }, 2500));
                    });
                }
                this.element.querySelector("." + classNames_sliderTabHandle) && this.element.querySelector("." + classNames_sliderTabHandle).classList.remove(classNames_sliderTabHandle), 
                this.element.querySelector("." + classNames_sliderTabTrack) && (this.element.querySelector("." + classNames_sliderTabTrack).classList.remove(classNames_sliderTabTrack), 
                "Range" !== this.type && "MinRange" !== this.type || !this.element.querySelector("." + classNames_sliderTabRange) || this.element.querySelector("." + classNames_sliderTabRange).classList.remove(classNames_sliderTabRange));
            }
        }, Slider.prototype.closeTooltip = function() {
            this.tooltip.isVisible && (this.tooltipValue(), 1 === this.activeHandle ? this.firstTooltipObj.close() : this.secondTooltipObj.close());
        }, Slider.prototype.removeElement = function(element) {
            element.parentNode && element.parentNode.removeChild(element);
        }, Slider.prototype.changeSliderType = function(type) {
            this.isMaterial && this.firstMaterialHandle && (this.sliderContainer.classList.remove(classNames_materialSlider), 
            this.removeElement(this.firstMaterialHandle), this.firstTooltipElement = void 0, 
            this.firstHandleTooltipPosition = void 0, this.secondMaterialHandle && (this.removeElement(this.secondMaterialHandle), 
            this.secondTooltipElement = void 0, this.secondHandleTooltipPosition = void 0)), 
            this.tooltip.isVisible && this.isMaterial && this.sliderContainer.classList.add(classNames_materialSlider), 
            this.removeElement(this.firstHandle), "Default" !== type && ("Range" === type && this.removeElement(this.secondHandle), 
            this.removeElement(this.rangeBar)), this.tooltip.isVisible && !isNullOrUndefined(this.firstTooltipObj) && (this.firstTooltipObj.destroy(), 
            "Range" !== type || isNullOrUndefined(this.secondTooltipObj) || this.secondTooltipObj.destroy()), 
            this.createRangeBar(), this.setHandler(), this.setOrientClass(), this.wireFirstHandleEvt(!1), 
            "Range" === this.type && this.wireSecondHandleEvt(!1), this.setValue(), this.tooltip.isVisible && (this.renderTooltip(), 
            this.wireMaterialTooltipEvent(!1)), this.updateConfig();
        }, Slider.prototype.changeRtl = function() {
            if (this.enableRtl || "Range" !== this.type || (this.value = [ this.handleVal2, this.handleVal1 ]), 
            this.updateConfig(), this.tooltip.isVisible && (this.firstTooltipObj.refresh(this.firstHandle), 
            "Range" === this.type && this.secondTooltipObj.refresh(this.secondHandle)), this.showButtons) {
                var enabledRTL = this.enableRtl && "Vertical" !== this.orientation;
                attributes(enabledRTL ? this.secondBtn : this.firstBtn, {
                    "aria-label": "Decrease",
                    title: "Decrease"
                }), attributes(enabledRTL ? this.firstBtn : this.secondBtn, {
                    "aria-label": "Increase",
                    title: "Increase"
                });
            }
        }, Slider.prototype.changeOrientation = function() {
            this.changeSliderType(this.type);
        }, Slider.prototype.updateConfig = function() {
            this.setEnableRTL(), this.setValue(), this.tooltip.isVisible && this.refreshTooltip(), 
            "None" !== this.ticks.placement && this.ul && (this.removeElement(this.ul), this.renderScale());
        }, Slider.prototype.getPersistData = function() {
            return this.addOnPersist([ "value" ]);
        }, Slider.prototype.destroy = function() {
            _super.prototype.destroy.call(this), this.unwireEvents(), window.removeEventListener("resize", this.onresize), 
            removeClass([ this.sliderContainer ], [ classNames_sliderDisabled ]), this.firstHandle.removeAttribute("aria-orientation"), 
            "Range" === this.type && this.secondHandle.removeAttribute("aria-orientation"), 
            this.sliderContainer.parentNode.insertBefore(this.element, this.sliderContainer), 
            detach(this.sliderContainer), this.tooltip.isVisible && (this.firstTooltipObj.destroy(), 
            "Range" !== this.type || isNullOrUndefined(this.secondTooltipObj) || this.secondTooltipObj.destroy()), 
            this.element.innerHTML = "";
        }, Slider.prototype.onPropertyChanged = function(newProp, oldProp) {
            for (var _this = this, _i = 0, _a = Object.keys(newProp); _i < _a.length; _i++) {
                switch (_a[_i]) {
                  case "cssClass":
                    this.setCSSClass(oldProp.cssClass);
                    break;

                  case "value":
                    isNullOrUndefined(oldProp.value) || isNullOrUndefined(newProp.value) || oldProp.value.toString() !== newProp.value.toString() && (this.setValue(), 
                    this.refreshTooltip(), "Range" === this.type && (oldProp.value[0] === newProp.value[0] ? this.activeHandle = 2 : this.activeHandle = 1));
                    break;

                  case "min":
                  case "step":
                  case "max":
                    this.setMinMaxValue();
                    break;

                  case "tooltip":
                    isNullOrUndefined(newProp.tooltip) || isNullOrUndefined(oldProp.tooltip) || this.setTooltip();
                    break;

                  case "type":
                    this.changeSliderType(oldProp.type), this.setZindex();
                    break;

                  case "enableRtl":
                    oldProp.enableRtl !== newProp.enableRtl && "Vertical" !== this.orientation && (this.rtl = oldProp.enableRtl, 
                    this.changeRtl());
                    break;

                  case "orientation":
                    this.changeOrientation();
                    break;

                  case "ticks":
                    isNullOrUndefined(this.sliderContainer.querySelector("." + classNames_scale)) || (detach(this.ul), 
                    Array.prototype.forEach.call(this.sliderContainer.classList, function(className) {
                        className.match(/e-scale-/) && _this.sliderContainer.classList.remove(className);
                    })), "None" !== this.ticks.placement && (this.renderScale(), this.setZindex());
                    break;

                  case "locale":
                    this.showButtons && this.buttonTitle();
                    break;

                  case "showButtons":
                    newProp.showButtons ? (this.setButtons(), this.onResize(), this.enabled && !this.readOnly && this.wireButtonEvt(!1)) : this.firstBtn && this.secondBtn && (this.sliderContainer.removeChild(this.firstBtn), 
                    this.sliderContainer.removeChild(this.secondBtn), this.firstBtn = void 0, this.secondBtn = void 0);
                    break;

                  case "enabled":
                    this.setEnabled();
                    break;

                  case "readOnly":
                    this.setReadOnly();
                }
            }
        }, Slider.prototype.setReadOnly = function() {
            this.readOnly ? (this.unwireEvents(), this.sliderContainer.classList.add(classNames_readOnly)) : (this.wireEvents(), 
            this.sliderContainer.classList.remove(classNames_readOnly));
        }, Slider.prototype.setMinMaxValue = function() {
            var _this = this;
            this.setValue(), this.refreshTooltip(), isNullOrUndefined(this.sliderContainer.querySelector("." + classNames_scale)) || this.ul && (detach(this.ul), 
            Array.prototype.forEach.call(this.sliderContainer.classList, function(className) {
                className.match(/e-scale-/) && _this.sliderContainer.classList.remove(className);
            })), "None" !== this.ticks.placement && (this.renderScale(), this.setZindex());
        }, Slider.prototype.setZindex = function() {
            this.zIndex = 6, isNullOrUndefined(this.ticks) || "None" === this.ticks.placement || (this.ul.style.zIndex = this.zIndex + -7 + "", 
            this.element.style.zIndex = this.zIndex + 2 + ""), this.isMaterial || isNullOrUndefined(this.ticks) || "Both" !== this.ticks.placement || (this.element.style.zIndex = this.zIndex + 2 + ""), 
            this.firstHandle.style.zIndex = this.zIndex + 3 + "", "Range" === this.type && (this.secondHandle.style.zIndex = this.zIndex + 4 + "");
        }, Slider.prototype.setTooltip = function() {
            this.changeSliderType(this.type);
        }, Slider.prototype.getModuleName = function() {
            return "slider";
        }, __decorate$2$4([ Property(null) ], Slider.prototype, "value", void 0), __decorate$2$4([ Property(1) ], Slider.prototype, "step", void 0), 
        __decorate$2$4([ Property(0) ], Slider.prototype, "min", void 0), __decorate$2$4([ Property(100) ], Slider.prototype, "max", void 0), 
        __decorate$2$4([ Property(!1) ], Slider.prototype, "readOnly", void 0), __decorate$2$4([ Property("Default") ], Slider.prototype, "type", void 0), 
        __decorate$2$4([ Complex({}, TicksData) ], Slider.prototype, "ticks", void 0), __decorate$2$4([ Property(!0) ], Slider.prototype, "enabled", void 0), 
        __decorate$2$4([ Property(!1) ], Slider.prototype, "enableRtl", void 0), __decorate$2$4([ Complex({}, TooltipData) ], Slider.prototype, "tooltip", void 0), 
        __decorate$2$4([ Property(!1) ], Slider.prototype, "showButtons", void 0), __decorate$2$4([ Property(!0) ], Slider.prototype, "enableAnimation", void 0), 
        __decorate$2$4([ Property("Horizontal") ], Slider.prototype, "orientation", void 0), 
        __decorate$2$4([ Property("") ], Slider.prototype, "cssClass", void 0), __decorate$2$4([ Event() ], Slider.prototype, "created", void 0), 
        __decorate$2$4([ Event() ], Slider.prototype, "change", void 0), __decorate$2$4([ Event() ], Slider.prototype, "changed", void 0), 
        __decorate$2$4([ Event() ], Slider.prototype, "renderingTicks", void 0), __decorate$2$4([ Event() ], Slider.prototype, "renderedTicks", void 0), 
        __decorate$2$4([ Event() ], Slider.prototype, "tooltipChange", void 0), Slider = __decorate$2$4([ NotifyPropertyChanges ], Slider);
    }(Component), __extends$3$2 = function() {
        var extendStatics = Object.setPrototypeOf || {
            __proto__: []
        } instanceof Array && function(d, b) {
            d.__proto__ = b;
        } || function(d, b) {
            for (var p in b) b.hasOwnProperty(p) && (d[p] = b[p]);
        };
        return function(d, b) {
            function __() {
                this.constructor = d;
            }
            extendStatics(d, b), d.prototype = null === b ? Object.create(b) : (__.prototype = b.prototype, 
            new __());
        };
    }(), __decorate$3$2 = function(decorators, target, key, desc) {
        var d, c = arguments.length, r = c < 3 ? target : null === desc ? desc = Object.getOwnPropertyDescriptor(target, key) : desc;
        if ("object" == typeof Reflect && "function" == typeof Reflect.decorate) r = Reflect.decorate(decorators, target, key, desc); else for (var i = decorators.length - 1; i >= 0; i--) (d = decorators[i]) && (r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r);
        return c > 3 && r && Object.defineProperty(target, key, r), r;
    }, VALIDATE_EMAIL = new RegExp("^[A-Za-z0-9._%+-]{3,}@[a-zA-Z]{3,}([.]{1}[a-zA-Z]{2,5}|[.]{1}[a-zA-Z]{2,4}[.]{1}[a-zA-Z]{2,4})$"), VALIDATE_URL = new RegExp("^((ftp|http|https)://)?www.([A-z]{2,}).([A-z]{2,})$"), VALIDATE_DATE_ISO = new RegExp("^([0-9]{4})-(0[1-9]|1[0-2])-(0[1-9]|[1-2][0-9]|3[0-1])$"), VALIDATE_DIGITS = new RegExp("^[0-9]*$"), VALIDATE_PHONE = new RegExp("^[+]?[0-9]{9,13}$"), VALIDATE_CREDITCARD = new RegExp("^\\d{13,16}$");
    !function(ErrorOption) {
        ErrorOption[ErrorOption.Message = 0] = "Message", ErrorOption[ErrorOption.Label = 1] = "Label";
    }(ErrorOption || (ErrorOption = {}));
    var ListBase, FormValidator = function(_super) {
        function FormValidator(element, options) {
            var _this = _super.call(this, options, element) || this;
            if (_this.validated = [], _this.errorRules = [], _this.allowSubmit = !1, _this.required = "required", 
            _this.infoElement = null, _this.inputElement = null, _this.selectQuery = "input:not([type=reset]):not([type=button]), select, textarea", 
            _this.defaultMessages = {
                required: "This field is required.",
                email: "Please enter a valid email address.",
                url: "Please enter a valid URL.",
                date: "Please enter a valid date.",
                dateIso: "Please enter a valid date ( ISO ).",
                creditcard: "Please enter valid card number",
                number: "Please enter a valid number.",
                digits: "Please enter only digits.",
                maxLength: "Please enter no more than {0} characters.",
                minLength: "Please enter at least {0} characters.",
                rangeLength: "Please enter a value between {0} and {1} characters long.",
                range: "Please enter a value between {0} and {1}.",
                max: "Please enter a value less than or equal to {0}.",
                min: "Please enter a value greater than or equal to {0}.",
                regex: "Please enter a correct value.",
                tel: "Please enter a valid phone number.",
                pattern: "Please enter a correct pattern value.",
                equalTo: "Please enter the valid match text"
            }, element = "string" == typeof element ? select(element, document) : element, null != _this.element) return _this.element.setAttribute("novalidate", ""), 
            _this.inputElements = selectAll(_this.selectQuery, _this.element), _this.createHTML5Rules(), 
            _this.wireEvents(), _this;
        }
        return __extends$3$2(FormValidator, _super), FormValidator_1 = FormValidator, FormValidator.prototype.addRules = function(name, rules) {
            name && (this.rules.hasOwnProperty(name) ? extend(this.rules[name], rules, {}) : this.rules[name] = rules);
        }, FormValidator.prototype.removeRules = function(name, rules) {
            if (name || rules) if (this.rules[name] && !rules) delete this.rules[name]; else {
                if (isNullOrUndefined(this.rules[name] && rules)) return;
                for (var i = 0; i < rules.length; i++) delete this.rules[name][rules[i]];
            } else this.rules = {};
        }, FormValidator.prototype.validate = function(selected) {
            var rules = Object.keys(this.rules);
            if (selected && rules.length) return this.validateRules(selected), -1 !== rules.indexOf(selected) && 0 === this.errorRules.filter(function(data) {
                return data.name === selected;
            }).length;
            for (var _i = 0, rules_1 = rules; _i < rules_1.length; _i++) {
                var name_1 = rules_1[_i];
                this.validateRules(name_1);
            }
            return 0 === this.errorRules.length;
        }, FormValidator.prototype.reset = function() {
            this.element.reset(), this.clearForm();
        }, FormValidator.prototype.getInputElement = function(name) {
            return this.inputElement = select("[name=" + name + "]", this.element), this.inputElement;
        }, FormValidator.prototype.destroy = function() {
            this.reset(), this.unwireEvents(), this.rules = {};
            for (var _i = 0, elements_1 = selectAll("." + this.errorClass + ", ." + this.validClass, this.element); _i < elements_1.length; _i++) {
                elements_1[_i].remove();
            }
            _super.prototype.destroy.call(this);
        }, FormValidator.prototype.onPropertyChanged = function(newProp, oldProp) {}, FormValidator.prototype.getModuleName = function() {
            return "formValidator";
        }, FormValidator.prototype.clearForm = function() {
            this.errorRules = [], this.validated = [];
            for (var _i = 0, elements_2 = selectAll(this.selectQuery, this.element); _i < elements_2.length; _i++) {
                var input = elements_2[_i];
                input.removeAttribute("aria-invalid"), input.classList.remove(this.errorClass), 
                input.name.length > 0 && (this.getInputElement(input.name), this.getErrorElement(input.name), 
                this.hideMessage(input.name)), input.classList.remove(this.validClass);
            }
        }, FormValidator.prototype.createHTML5Rules = function() {
            for (var defRules = [ "required", "regex", "rangeLength", "maxLength", "minLength", "dateIso", "digits", "pattern", "data-val-required", "type", "data-validation", "min", "max", "range", "equalTo", "data-val-minlength-min", "data-val-equalto-other", "data-val-maxlength-max", "data-val-range-min", "data-val-regex-pattern", "data-val-length-max", "data-val-creditcard", "data-val-phone" ], acceptedTypes = [ "email", "url", "date", "number", "tel" ], _i = 0, _a = this.inputElements; _i < _a.length; _i++) {
                for (var input = _a[_i], allRule = {}, _b = 0, defRules_1 = defRules; _b < defRules_1.length; _b++) {
                    var rule = defRules_1[_b];
                    if (null !== input.getAttribute(rule)) switch (rule) {
                      case "required":
                        this.defRule(input, allRule, rule, input.required);
                        break;

                      case "data-validation":
                        rule = input.getAttribute(rule), this.defRule(input, allRule, rule, !0);
                        break;

                      case "type":
                        -1 !== acceptedTypes.indexOf(input.type) && this.defRule(input, allRule, input.type, !0);
                        break;

                      case "rangeLength":
                      case "range":
                        this.defRule(input, allRule, rule, JSON.parse(input.getAttribute(rule)));
                        break;

                      case "equalTo":
                        var id = input.getAttribute(rule);
                        this.defRule(input, allRule, rule, id);
                        break;

                      default:
                        "true" === input.getAttribute("data-val") ? this.annotationRule(input, allRule, rule, input.getAttribute(rule)) : this.defRule(input, allRule, rule, input.getAttribute(rule));
                    }
                }
                0 !== Object.keys(allRule).length && this.addRules(input.name, allRule);
            }
        }, FormValidator.prototype.annotationRule = function(input, ruleCon, ruleName, value) {
            var annotationRule = ruleName.split("-"), rulesList = [ "required", "creditcard", "phone", "maxlength", "minlength", "range", "regex", "equalto" ], ruleFirstName = annotationRule[annotationRule.length - 1], ruleSecondName = annotationRule[annotationRule.length - 2];
            if (-1 !== rulesList.indexOf(ruleFirstName)) switch (ruleFirstName) {
              case "required":
                this.defRule(input, ruleCon, "required", value);
                break;

              case "creditcard":
                this.defRule(input, ruleCon, "creditcard", value);
                break;

              case "phone":
                this.defRule(input, ruleCon, "tel", value);
            } else if (-1 !== rulesList.indexOf(ruleSecondName)) switch (ruleSecondName) {
              case "maxlength":
                this.defRule(input, ruleCon, "maxLength", value);
                break;

              case "minlength":
                this.defRule(input, ruleCon, "minLength", value);
                break;

              case "range":
                var minvalue = input.getAttribute("data-val-range-min"), maxvalue = input.getAttribute("data-val-range-max");
                this.defRule(input, ruleCon, "range", [ minvalue, maxvalue ]);
                break;

              case "equalto":
                var id = input.getAttribute(ruleName).split(".");
                this.defRule(input, ruleCon, "equalTo", id[id.length - 1]);
                break;

              case "regex":
                this.defRule(input, ruleCon, "regex", value);
            }
        }, FormValidator.prototype.defRule = function(input, ruleCon, ruleName, value) {
            var message = input.getAttribute("data-" + ruleName + "-message"), annotationMessage = input.getAttribute("data-val-" + ruleName);
            message ? value = [ value, message ] : annotationMessage && (value = [ value, annotationMessage ]), 
            ruleCon[ruleName] = value;
        }, FormValidator.prototype.wireEvents = function() {
            for (var _i = 0, _a = this.inputElements; _i < _a.length; _i++) {
                var input = _a[_i];
                FormValidator_1.isCheckable(input) ? EventHandler.add(input, "click", this.clickHandler, this) : "SELECT" === input.tagName ? EventHandler.add(input, "change", this.changeHandler, this) : (EventHandler.add(input, "focusout", this.focusOutHandler, this), 
                EventHandler.add(input, "keyup", this.keyUpHandler, this));
            }
            EventHandler.add(this.element, "submit", this.submitHandler, this), EventHandler.add(this.element, "reset", this.resetHandler, this);
        }, FormValidator.prototype.unwireEvents = function() {
            for (var _i = 0, _a = this.inputElements; _i < _a.length; _i++) {
                var input = _a[_i];
                EventHandler.clearEvents(input);
            }
            EventHandler.remove(this.element, "submit", this.submitHandler), EventHandler.remove(this.element, "reset", this.resetHandler);
        }, FormValidator.prototype.focusOutHandler = function(e) {
            this.trigger("focusout", e);
            var element = e.target;
            this.rules[element.name] && (this.rules[element.name][this.required] || element.value.length > 0 ? this.validate(element.name) : -1 === this.validated.indexOf(element.name) && this.validated.push(element.name));
        }, FormValidator.prototype.keyUpHandler = function(e) {
            this.trigger("keyup", e);
            var element = e.target;
            (9 !== e.which || this.rules[element.name] && (!this.rules[element.name] || this.rules[element.name][this.required])) && -1 !== this.validated.indexOf(element.name) && this.rules[element.name] && -1 === [ 16, 17, 18, 20, 35, 36, 37, 38, 39, 40, 45, 144, 225 ].indexOf(e.which) && this.validate(element.name);
        }, FormValidator.prototype.clickHandler = function(e) {
            this.trigger("click", e);
            var element = e.target;
            "submit" !== element.type ? this.validate(element.name) : null !== element.getAttribute("formnovalidate") && (this.allowSubmit = !0);
        }, FormValidator.prototype.changeHandler = function(e) {
            this.trigger("change", e);
            var element = e.target;
            this.validate(element.name);
        }, FormValidator.prototype.submitHandler = function(e) {
            this.trigger("submit", e), this.allowSubmit || this.validate() ? this.allowSubmit = !1 : e.preventDefault();
        }, FormValidator.prototype.resetHandler = function() {
            this.clearForm();
        }, FormValidator.prototype.validateRules = function(name) {
            if (this.rules[name]) {
                var rules = Object.keys(this.rules[name]);
                this.getInputElement(name), this.getErrorElement(name);
                for (var _i = 0, rules_2 = rules; _i < rules_2.length; _i++) {
                    var rule = rules_2[_i], errorMessage = this.getErrorMessage(this.rules[name][rule], rule), errorRule = {
                        name: name,
                        message: errorMessage
                    }, eventArgs = {
                        inputName: name,
                        element: this.inputElement,
                        message: errorMessage
                    };
                    if (!this.isValid(name, rule) && !this.inputElement.classList.contains(this.ignore)) {
                        this.removeErrorRules(name), this.errorRules.push(errorRule), this.inputElement.setAttribute("aria-invalid", "true"), 
                        this.inputElement.setAttribute("aria-describedby", this.inputElement.id + "-info"), 
                        this.infoElement ? this.showMessage(errorRule) : this.createErrorElement(name, errorRule.message, this.inputElement), 
                        eventArgs.errorElement = this.infoElement, eventArgs.status = "failure", this.inputElement.classList.add(this.errorClass), 
                        this.inputElement.classList.remove(this.validClass), this.trigger("validationComplete", eventArgs), 
                        "required" === rule && this.inputElement.setAttribute("aria-required", "true");
                        break;
                    }
                    this.hideMessage(name), eventArgs.status = "success", this.trigger("validationComplete", eventArgs);
                }
            }
        }, FormValidator.prototype.isValid = function(name, rule) {
            var params = this.rules[name][rule], param = params instanceof Array && "string" == typeof params[1] ? params[0] : params, currentRule = this.rules[name][rule], args = {
                value: this.inputElement.value,
                param: param,
                element: this.inputElement,
                formElement: this.element
            };
            if (this.trigger("validationBegin", args), currentRule && "function" == typeof currentRule[0]) {
                return currentRule[0].call(this, {
                    element: this.inputElement,
                    value: this.inputElement.value
                });
            }
            return FormValidator_1.isCheckable(this.inputElement) ? "required" !== rule || selectAll("input[name=" + name + "]:checked", this.element).length > 0 : FormValidator_1.checkValidator[rule](args);
        }, FormValidator.prototype.getErrorMessage = function(ruleValue, rule) {
            var message = ruleValue instanceof Array && "string" == typeof ruleValue[1] ? ruleValue[1] : this.defaultMessages[rule], formats = message.match(/{(\d)}/g);
            if (!isNullOrUndefined(formats)) for (var i = 0; i < formats.length; i++) {
                var value = ruleValue instanceof Array ? ruleValue[i] : ruleValue;
                message = message.replace(formats[i], value);
            }
            return message;
        }, FormValidator.prototype.createErrorElement = function(name, message, input) {
            var errorElement = createElement(this.errorElement, {
                className: this.errorClass,
                innerHTML: message,
                attrs: {
                    for: name
                }
            });
            if (this.errorOption === ErrorOption.Message && (errorElement.classList.remove(this.errorClass), 
            errorElement.classList.add("e-message"), errorElement = createElement(this.errorContainer, {
                className: this.errorClass,
                innerHTML: errorElement.outerHTML
            })), errorElement.id = this.inputElement.name + "-info", this.element.querySelector('[data-valmsg-for="' + input.id + '"]')) this.element.querySelector('[data-valmsg-for="' + input.id + '"]').appendChild(errorElement); else if (!0 === input.hasAttribute("data-msg-containerid")) {
                var containerId = input.getAttribute("data-msg-containerid");
                this.element.querySelector("#" + containerId).appendChild(errorElement);
            } else null != this.customPlacement ? this.customPlacement.call(this, this.inputElement, errorElement) : this.inputElement.parentNode.insertBefore(errorElement, this.inputElement.nextSibling);
            errorElement.style.display = "block", this.getErrorElement(name), this.validated.push(name), 
            this.checkRequired(name);
        }, FormValidator.prototype.getErrorElement = function(name) {
            return this.infoElement = select(this.errorElement + "." + this.errorClass, this.inputElement.parentElement), 
            this.infoElement || (this.infoElement = select(this.errorElement + "." + this.errorClass + '[for="' + name + '"]')), 
            this.infoElement;
        }, FormValidator.prototype.removeErrorRules = function(name) {
            for (var i = 0; i < this.errorRules.length; i++) {
                this.errorRules[i].name === name && this.errorRules.splice(i, 1);
            }
        }, FormValidator.prototype.showMessage = function(errorRule) {
            this.infoElement.style.display = "block", this.infoElement.innerHTML = errorRule.message, 
            this.checkRequired(errorRule.name);
        }, FormValidator.prototype.hideMessage = function(name) {
            this.infoElement && (this.infoElement.style.display = "none", this.removeErrorRules(name), 
            this.inputElement.classList.add(this.validClass), this.inputElement.classList.remove(this.errorClass), 
            this.inputElement.setAttribute("aria-invalid", "false"));
        }, FormValidator.prototype.checkRequired = function(name) {
            this.rules[name][this.required] || this.inputElement.value.length || (this.infoElement.innerHTML = this.inputElement.value, 
            this.infoElement.setAttribute("aria-invalid", "false"), this.hideMessage(name));
        }, FormValidator.isCheckable = function(input) {
            var inputType = input.getAttribute("type");
            return inputType && ("checkbox" === inputType || "radio" === inputType || "submit" === inputType);
        }, FormValidator.checkValidator = {
            required: function(option) {
                return option.value.length > 0;
            },
            email: function(option) {
                return VALIDATE_EMAIL.test(option.value);
            },
            url: function(option) {
                return VALIDATE_URL.test(option.value);
            },
            dateIso: function(option) {
                return VALIDATE_DATE_ISO.test(option.value);
            },
            tel: function(option) {
                return VALIDATE_PHONE.test(option.value);
            },
            creditcard: function(option) {
                return VALIDATE_CREDITCARD.test(option.value);
            },
            number: function(option) {
                return !isNaN(Number(option.value)) && -1 === option.value.indexOf(" ");
            },
            digits: function(option) {
                return VALIDATE_DIGITS.test(option.value);
            },
            maxLength: function(option) {
                return option.value.length <= option.param;
            },
            minLength: function(option) {
                return option.value.length >= option.param;
            },
            rangeLength: function(option) {
                var param = option.param;
                return option.value.length >= param[0] && option.value.length <= param[1];
            },
            range: function(option) {
                var param = option.param;
                return !isNaN(Number(option.value)) && Number(option.value) >= param[0] && Number(option.value) <= param[1];
            },
            date: function(option) {
                return !isNaN(new Date(option.value).getTime());
            },
            max: function(option) {
                return isNaN(Number(option.value)) ? new Date(option.value).getTime() <= new Date(JSON.parse(JSON.stringify(option.param))).getTime() : +option.value <= option.param;
            },
            min: function(option) {
                return isNaN(Number(option.value)) ? new Date(option.value).getTime() >= new Date(JSON.parse(JSON.stringify(option.param))).getTime() : +option.value >= option.param;
            },
            regex: function(option) {
                return new RegExp(option.param).test(option.value);
            },
            equalTo: function(option) {
                var compareTo = option.formElement.querySelector("#" + option.param);
                return option.param = compareTo.value, option.param === option.value;
            }
        }, __decorate$3$2([ Property("e-hidden") ], FormValidator.prototype, "ignore", void 0), 
        __decorate$3$2([ Property({}) ], FormValidator.prototype, "rules", void 0), __decorate$3$2([ Property("e-error") ], FormValidator.prototype, "errorClass", void 0), 
        __decorate$3$2([ Property("e-valid") ], FormValidator.prototype, "validClass", void 0), 
        __decorate$3$2([ Property("label") ], FormValidator.prototype, "errorElement", void 0), 
        __decorate$3$2([ Property("div") ], FormValidator.prototype, "errorContainer", void 0), 
        __decorate$3$2([ Property(ErrorOption.Label) ], FormValidator.prototype, "errorOption", void 0), 
        __decorate$3$2([ Event() ], FormValidator.prototype, "focusout", void 0), __decorate$3$2([ Event() ], FormValidator.prototype, "keyup", void 0), 
        __decorate$3$2([ Event() ], FormValidator.prototype, "click", void 0), __decorate$3$2([ Event() ], FormValidator.prototype, "change", void 0), 
        __decorate$3$2([ Event() ], FormValidator.prototype, "submit", void 0), __decorate$3$2([ Event() ], FormValidator.prototype, "validationBegin", void 0), 
        __decorate$3$2([ Event() ], FormValidator.prototype, "validationComplete", void 0), 
        __decorate$3$2([ Event() ], FormValidator.prototype, "customPlacement", void 0), 
        FormValidator = FormValidator_1 = __decorate$3$2([ NotifyPropertyChanges ], FormValidator);
        var FormValidator_1;
    }(Base), __extends$4$2 = function() {
        var extendStatics = Object.setPrototypeOf || {
            __proto__: []
        } instanceof Array && function(d, b) {
            d.__proto__ = b;
        } || function(d, b) {
            for (var p in b) b.hasOwnProperty(p) && (d[p] = b[p]);
        };
        return function(d, b) {
            function __() {
                this.constructor = d;
            }
            extendStatics(d, b), d.prototype = null === b ? Object.create(b) : (__.prototype = b.prototype, 
            new __());
        };
    }(), __decorate$4$2 = function(decorators, target, key, desc) {
        var d, c = arguments.length, r = c < 3 ? target : null === desc ? desc = Object.getOwnPropertyDescriptor(target, key) : desc;
        if ("object" == typeof Reflect && "function" == typeof Reflect.decorate) r = Reflect.decorate(decorators, target, key, desc); else for (var i = decorators.length - 1; i >= 0; i--) (d = decorators[i]) && (r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r);
        return c > 3 && r && Object.defineProperty(target, key, r), r;
    }, FILE = "e-upload-file-list", STATUS = "e-file-status", CLEAR_ICON = "e-file-remove-btn", PROGRESSBAR = "e-upload-progress-bar", UPLOAD_SUCCESS = "e-upload-success", ICON_FOCUSED = "e-clear-icon-focus", FilesProp = function(_super) {
        function FilesProp() {
            return null !== _super && _super.apply(this, arguments) || this;
        }
        return __extends$4$2(FilesProp, _super), __decorate$4$2([ Property("") ], FilesProp.prototype, "name", void 0), 
        __decorate$4$2([ Property(null) ], FilesProp.prototype, "size", void 0), __decorate$4$2([ Property("") ], FilesProp.prototype, "type", void 0), 
        FilesProp;
    }(ChildProperty), ButtonsProps = function(_super) {
        function ButtonsProps() {
            return null !== _super && _super.apply(this, arguments) || this;
        }
        return __extends$4$2(ButtonsProps, _super), __decorate$4$2([ Property("Browse") ], ButtonsProps.prototype, "browse", void 0), 
        __decorate$4$2([ Property("Upload") ], ButtonsProps.prototype, "upload", void 0), 
        __decorate$4$2([ Property("Clear") ], ButtonsProps.prototype, "clear", void 0), 
        ButtonsProps;
    }(ChildProperty), AsyncSettings = function(_super) {
        function AsyncSettings() {
            return null !== _super && _super.apply(this, arguments) || this;
        }
        return __extends$4$2(AsyncSettings, _super), __decorate$4$2([ Property("") ], AsyncSettings.prototype, "saveUrl", void 0), 
        __decorate$4$2([ Property("") ], AsyncSettings.prototype, "removeUrl", void 0), 
        AsyncSettings;
    }(ChildProperty), Uploader = function(_super) {
        function Uploader(options, element) {
            var _this = _super.call(this, options, element) || this;
            return _this.initialAttr = {
                accept: null,
                multiple: !1,
                disabled: !1
            }, _this.fileList = [], _this.filesData = [], _this.uploadedFilesData = [], _this.isForm = !1, 
            _this;
        }
        return __extends$4$2(Uploader, _super), Uploader.prototype.onPropertyChanged = function(newProp, oldProp) {
            for (var _i = 0, _a = Object.keys(newProp); _i < _a.length; _i++) {
                switch (_a[_i]) {
                  case "allowedExtensions":
                    this.setExtensions(this.allowedExtensions), this.clearAll();
                    break;

                  case "enabled":
                    this.setControlStatus();
                    break;

                  case "multiple":
                    this.setMultipleSelection();
                    break;

                  case "enableRtl":
                    this.setRTL(), this.reRenderFileList();
                    break;

                  case "buttons":
                    this.buttons.browse = isNullOrUndefined(this.buttons.browse) ? "" : this.buttons.browse, 
                    this.buttons.clear = isNullOrUndefined(this.buttons.clear) ? "" : this.buttons.clear, 
                    this.buttons.upload = isNullOrUndefined(this.buttons.upload) ? "" : this.buttons.upload, 
                    this.renderButtonTemplates();
                    break;

                  case "dropArea":
                    this.unBindDropEvents(), this.setDropArea();
                    break;

                  case "showFileList":
                    this.listParent && (this.listParent.style.display = this.showFileList ? "block" : "none", 
                    this.actionButtons.style.display = this.showFileList ? "block" : "none");
                    break;

                  case "files":
                    this.renderPreLoadFiles();
                    break;

                  case "minFileSize":
                  case "maxFileSize":
                  case "template":
                  case "autoUpload":
                    this.clearAll();
                    break;

                  case "locale":
                    this.l10n.setLocale(this.locale), this.setLocalizedTexts(), this.preLocaleObj = getValue("currentLocale", this.l10n);
                }
            }
        }, Uploader.prototype.setLocalizedTexts = function() {
            isNullOrUndefined(this.template) && ("string" == typeof this.buttons.browse && (this.browseButton.innerText = "Browse" === this.buttons.browse ? this.localizedTexts("Browse") : this.buttons.browse, 
            this.browseButton.setAttribute("title", this.browseButton.innerText), this.uploadWrapper.querySelector(".e-file-drop").innerHTML = this.localizedTexts("dropFilesHint")), 
            this.updateFileList());
        }, Uploader.prototype.getKeyValue = function(val) {
            for (var keyValue, _i = 0, _a = Object.keys(this.preLocaleObj); _i < _a.length; _i++) {
                var key = _a[_i];
                this.preLocaleObj[key] === val && (keyValue = key);
            }
            return keyValue;
        }, Uploader.prototype.updateFileList = function() {
            if (this.fileList.length > 0 && !isNullOrUndefined(this.uploadWrapper.querySelector(".e-upload-files"))) for (var i = 0; i < this.fileList.length; i++) this.fileList[i].querySelector(".e-file-status").innerHTML = this.localizedTexts(this.getKeyValue(this.filesData[i].status)), 
            this.filesData[i].status = this.localizedTexts(this.getKeyValue(this.filesData[i].status)), 
            this.fileList[i].classList.contains(UPLOAD_SUCCESS) ? this.fileList[i].querySelector(".e-icons").setAttribute("title", this.localizedTexts("remove")) : this.fileList[i].querySelector(".e-icons").setAttribute("title", this.localizedTexts("delete")), 
            this.autoUpload || (this.uploadButton.innerText = "Upload" === this.buttons.upload ? this.localizedTexts("Upload") : this.buttons.upload, 
            this.clearButton.innerText = "Clear" === this.buttons.clear ? this.localizedTexts("Clear") : this.buttons.clear);
        }, Uploader.prototype.reRenderFileList = function() {
            this.listParent && (detach(this.listParent), this.listParent = null, this.fileList = [], 
            this.removeActionButtons(), this.createFileList(this.filesData), this.renderActionButtons());
        }, Uploader.prototype.preRender = function() {
            this.cloneElement = this.element.cloneNode(!0), this.localeText = {
                Browse: "Browse",
                Clear: "Clear",
                Upload: "Upload",
                dropFilesHint: "or Drop files here",
                invalidMaxFileSize: "File size is too large",
                invalidMinFileSize: "File size is too small",
                invalidFileType: "File type is not allowed",
                uploadFailedMessage: "File failed to upload",
                uploadSuccessMessage: "File uploaded successfully",
                removedSuccessMessage: "File removed successfully",
                removedFailedMessage: "File failed to remove",
                inProgress: "Uploading",
                readyToUploadMessage: "Ready to upload",
                remove: "Remove",
                cancel: "Cancel",
                delete: "Delete file"
            }, this.l10n = new L10n("uploader", this.localeText, this.locale), this.preLocaleObj = getValue("currentLocale", this.l10n), 
            this.checkHTMLAttributes(), "" !== this.asyncSettings.saveUrl || "" !== this.asyncSettings.removeUrl || this.autoUpload || isNullOrUndefined(this.element.closest("form")) || (this.isForm = !0, 
            this.element.closest("form").setAttribute("enctype", "multipart/form-data"), this.element.closest("form").setAttribute("encoding", "multipart/form-data"));
            var ejInstance = getValue("ej2_instances", this.element);
            if ("EJS-UPLOADER" === this.element.tagName || "UPLOADERCOMPONENT" === this.element.tagName) {
                for (var inputElement = createElement("input", {
                    attrs: {
                        type: "file"
                    }
                }), index = 0; index < this.element.attributes.length; index++) inputElement.setAttribute(this.element.attributes[index].nodeName, this.element.attributes[index].nodeValue), 
                inputElement.innerHTML = this.element.innerHTML;
                inputElement.hasAttribute("name") || inputElement.setAttribute("name", "UploadFiles"), 
                this.element.appendChild(inputElement), this.element = inputElement, setValue("ej2_instances", ejInstance, this.element);
            }
            isNullOrUndefined(this.element.getAttribute("name")) && this.element.setAttribute("name", this.element.getAttribute("id")), 
            this.element.hasAttribute("type") || this.element.setAttribute("type", "file"), 
            this.keyConfigs = {
                previous: "shift+tab",
                enter: "enter",
                next: "tab"
            };
        }, Uploader.prototype.getPersistData = function() {
            return this.addOnPersist([]);
        }, Uploader.prototype.getModuleName = function() {
            return "uploader";
        }, Uploader.prototype.render = function() {
            this.renderBrowseButton(), this.initializeUpload(), this.wireEvents(), this.setMultipleSelection(), 
            this.setExtensions(this.allowedExtensions), this.setRTL(), this.renderPreLoadFiles(), 
            this.setControlStatus();
        }, Uploader.prototype.renderBrowseButton = function() {
            this.browseButton = createElement("button", {
                className: "e-css e-btn",
                attrs: {
                    type: "button"
                }
            }), "string" == typeof this.buttons.browse ? (this.browseButton.innerText = "Browse" === this.buttons.browse ? this.localizedTexts("Browse") : this.buttons.browse, 
            this.browseButton.setAttribute("title", this.browseButton.innerText)) : this.browseButton.appendChild(this.buttons.browse), 
            this.element.setAttribute("aria-label", "Uploader");
        }, Uploader.prototype.renderActionButtons = function() {
            this.element.setAttribute("tabindex", "-1"), this.actionButtons = createElement("div", {
                className: "e-upload-actions"
            }), this.uploadButton = createElement("button", {
                className: "e-file-upload-btn e-css e-btn e-primary",
                attrs: {
                    type: "button",
                    tabindex: "-1"
                }
            }), this.clearButton = createElement("button", {
                className: "e-file-clear-btn e-css e-btn e-flat",
                attrs: {
                    type: "button",
                    tabindex: "-1"
                }
            }), this.actionButtons.appendChild(this.clearButton), this.actionButtons.appendChild(this.uploadButton), 
            this.renderButtonTemplates(), this.uploadWrapper.appendChild(this.actionButtons), 
            this.browseButton.blur(), this.uploadButton.focus(), this.wireActionButtonEvents();
        }, Uploader.prototype.wireActionButtonEvents = function() {
            EventHandler.add(this.uploadButton, "click", this.uploadButtonClick, this), EventHandler.add(this.clearButton, "click", this.clearButtonClick, this);
        }, Uploader.prototype.unwireActionButtonEvents = function() {
            EventHandler.remove(this.uploadButton, "click", this.uploadButtonClick), EventHandler.remove(this.clearButton, "click", this.clearButtonClick);
        }, Uploader.prototype.removeActionButtons = function() {
            this.actionButtons && (this.unwireActionButtonEvents(), detach(this.actionButtons), 
            this.actionButtons = null);
        }, Uploader.prototype.renderButtonTemplates = function() {
            if ("string" == typeof this.buttons.browse ? (this.browseButton.innerText = "Browse" === this.buttons.browse ? this.localizedTexts("Browse") : this.buttons.browse, 
            this.browseButton.setAttribute("title", this.browseButton.innerText)) : this.browseButton.appendChild(this.buttons.browse), 
            this.uploadButton) {
                var uploadText = void 0;
                uploadText = isNullOrUndefined(this.buttons.upload) ? "Upload" : this.buttons.upload, 
                this.buttons.upload = uploadText, "string" == typeof this.buttons.upload ? (this.uploadButton.innerText = "Upload" === this.buttons.upload ? this.localizedTexts("Upload") : this.buttons.upload, 
                this.uploadButton.setAttribute("title", this.uploadButton.innerText)) : this.uploadButton.appendChild(this.buttons.upload);
            }
            if (this.clearButton) {
                var clearText = void 0;
                clearText = isNullOrUndefined(this.buttons.clear) ? "Clear" : this.buttons.clear, 
                this.buttons.clear = clearText, "string" == typeof this.buttons.clear ? (this.clearButton.innerText = "Clear" === this.buttons.clear ? this.localizedTexts("Clear") : this.buttons.clear, 
                this.clearButton.setAttribute("title", this.clearButton.innerText)) : this.clearButton.appendChild(this.buttons.clear);
            }
        }, Uploader.prototype.initializeUpload = function() {
            this.element.setAttribute("tabindex", "-1");
            var inputWrapper = createElement("span", {
                className: "e-file-select"
            });
            this.element.parentElement.insertBefore(inputWrapper, this.element), this.dropAreaWrapper = createElement("div", {
                className: "e-file-select-wrap"
            }), this.element.parentElement.insertBefore(this.dropAreaWrapper, this.element), 
            inputWrapper.appendChild(this.element), this.dropAreaWrapper.appendChild(this.browseButton), 
            this.dropAreaWrapper.appendChild(inputWrapper);
            var fileDropArea = createElement("span", {
                className: "e-file-drop"
            });
            fileDropArea.innerHTML = this.localizedTexts("dropFilesHint"), this.dropAreaWrapper.appendChild(fileDropArea), 
            this.uploadWrapper = createElement("div", {
                className: "e-upload",
                attrs: {
                    "aria-activedescendant": "li-focused"
                }
            }), this.dropAreaWrapper.parentElement.insertBefore(this.uploadWrapper, this.dropAreaWrapper), 
            this.uploadWrapper.appendChild(this.dropAreaWrapper), this.setDropArea();
        }, Uploader.prototype.renderPreLoadFiles = function() {
            if (!isNullOrUndefined(this.files[0].size) && isNullOrUndefined(this.template)) {
                var files = [].slice.call(this.files), filesData = [];
                this.multiple || (this.clearData(), files = [ files[0] ]);
                for (var _i = 0, files_1 = files; _i < files_1.length; _i++) {
                    var data = files_1[_i], fileData = {
                        name: this.getFileNameOnly(data.name) + "." + data.type.split(".")[data.type.split(".").length - 1],
                        rawFile: "",
                        size: data.size,
                        status: this.localizedTexts("uploadSuccessMessage"),
                        type: data.type,
                        validationMessages: {
                            minSize: "",
                            maxSize: ""
                        },
                        statusCode: "2"
                    };
                    filesData.push(fileData), this.filesData.push(fileData);
                }
                this.createFileList(filesData), this.autoUpload || !this.listParent || this.actionButtons || this.isForm || this.renderActionButtons(), 
                this.checkActionButtonStatus();
            }
        }, Uploader.prototype.checkActionButtonStatus = function() {
            if (this.actionButtons) {
                var length_1 = this.uploadWrapper.querySelectorAll(".e-validation-fails").length + this.uploadWrapper.querySelectorAll(".e-upload-fails:not(.e-upload-progress)").length + this.uploadWrapper.querySelectorAll("span." + UPLOAD_SUCCESS).length + this.uploadWrapper.querySelectorAll("span.e-upload-progress").length;
                length_1 > 0 && length_1 === this.uploadWrapper.querySelectorAll("li").length ? this.uploadButton.setAttribute("disabled", "disabled") : this.uploadButton.removeAttribute("disabled");
            }
        }, Uploader.prototype.setDropArea = function() {
            var dropTextArea = this.dropAreaWrapper.querySelector(".e-file-drop");
            if (this.dropArea) {
                this.dropZoneElement = "string" != typeof this.dropArea ? this.dropArea : document.querySelector(this.dropArea);
                for (var element = this.element, enableDropText = !1; element.parentNode; ) (element = element.parentNode) === this.dropZoneElement && (enableDropText = !0);
                enableDropText || (dropTextArea.textContent = "");
            } else this.dropZoneElement = this.uploadWrapper, dropTextArea.textContent = this.localizedTexts("dropFilesHint");
            this.bindDropEvents();
        }, Uploader.prototype.setMultipleSelection = function() {
            if (this.multiple && !this.element.hasAttribute("multiple")) {
                var newAttr = document.createAttribute("multiple");
                this.element.setAttributeNode(newAttr);
            } else this.multiple || this.element.removeAttribute("multiple");
        }, Uploader.prototype.checkAutoUpload = function(fileData) {
            this.autoUpload ? (this.upload(fileData), this.removeActionButtons()) : this.actionButtons || this.renderActionButtons(), 
            this.checkActionButtonStatus();
        }, Uploader.prototype.wireEvents = function() {
            EventHandler.add(this.browseButton, "click", this.browseButtonClick, this), EventHandler.add(this.element, "change", this.onSelectFiles, this), 
            EventHandler.add(document, "click", this.removeFocus, this), this.keyboardModule = new KeyboardEvents(this.uploadWrapper, {
                keyAction: this.keyActionHandler.bind(this),
                keyConfigs: this.keyConfigs,
                eventName: "keydown"
            }), this.isForm && EventHandler.add(this.element.closest("form"), "reset", this.resetForm, this);
        }, Uploader.prototype.unWireEvents = function() {
            EventHandler.remove(this.browseButton, "click", this.browseButtonClick), EventHandler.remove(this.element, "change", this.onSelectFiles), 
            EventHandler.remove(document, "click", this.removeFocus), this.keyboardModule.destroy();
        }, Uploader.prototype.resetForm = function() {
            this.clearAll(), this.element.value = "";
        }, Uploader.prototype.keyActionHandler = function(e) {
            switch (e.action) {
              case "next":
                e.target === this.browseButton && isNullOrUndefined(this.listParent) ? this.browseButton.blur() : e.target === this.uploadButton ? this.uploadButton.blur() : (this.setTabFocus(e), 
                e.preventDefault(), e.stopPropagation(), e.target === this.clearButton && this.uploadButton.hasAttribute("disabled") && this.clearButton.blur());
                break;

              case "previous":
                e.target === this.browseButton ? this.browseButton.blur() : (this.setReverseFocus(e), 
                e.preventDefault(), e.stopPropagation());
                break;

              case "enter":
                e.target === this.clearButton ? this.clearButtonClick() : e.target === this.uploadButton ? this.uploadButtonClick() : e.target === this.browseButton ? this.browseButtonClick() : (this.removeFiles(e), 
                this.browseButton.focus()), e.preventDefault(), e.stopPropagation();
            }
        }, Uploader.prototype.setReverseFocus = function(e) {
            var target = e.target;
            if (target === this.uploadButton) this.uploadButton.blur(), this.clearButton.focus(); else if (target === this.clearButton && this.listParent && this.listParent.querySelector(".e-icons")) {
                this.clearButton.blur();
                var items = [].slice.call(this.listParent.querySelectorAll("span.e-icons"));
                items[items.length - 1].classList.add(ICON_FOCUSED), items[items.length - 1].focus();
            } else {
                var iconElements = [].slice.call(this.listParent.querySelectorAll("span.e-icons")), index = iconElements.indexOf(target);
                index > 0 ? (this.removeFocus(), iconElements[index - 1].classList.add(ICON_FOCUSED), 
                iconElements[index - 1].focus()) : (this.removeFocus(), this.browseButton.focus());
            }
        }, Uploader.prototype.setTabFocus = function(e) {
            var target = e.target;
            if (target === this.clearButton) {
                if (this.removeFocus(), this.uploadButton.hasAttribute("disabled")) return;
                this.uploadButton.focus();
            } else if (target.classList.contains("e-icons")) {
                var iconElements = [].slice.call(this.listParent.querySelectorAll("span.e-icons")), index = iconElements.indexOf(target);
                index < iconElements.length - 1 ? (this.removeFocus(), iconElements[index + 1].classList.add(ICON_FOCUSED), 
                iconElements[index + 1].focus()) : (this.removeFocus(), this.clearButton.focus());
            } else {
                this.browseButton.blur();
                var iconElement = this.listParent.querySelector("span.e-icons");
                iconElement.focus(), iconElement.classList.add(ICON_FOCUSED);
            }
        }, Uploader.prototype.removeFocus = function() {
            this.uploadWrapper && this.listParent && this.listParent.querySelector("." + ICON_FOCUSED) && (document.activeElement.blur(), 
            this.listParent.querySelector("." + ICON_FOCUSED).classList.remove(ICON_FOCUSED));
        }, Uploader.prototype.browseButtonClick = function() {
            this.element.click();
        }, Uploader.prototype.uploadButtonClick = function() {
            this.upload(this.filesData);
        }, Uploader.prototype.clearButtonClick = function() {
            this.clearAll();
        }, Uploader.prototype.bindDropEvents = function() {
            this.dropZoneElement && (EventHandler.add(this.dropZoneElement, "drop", this.dropElement, this), 
            EventHandler.add(this.dropZoneElement, "dragover", this.dragHover, this), EventHandler.add(this.dropZoneElement, "dragleave", this.onDragLeave, this));
        }, Uploader.prototype.unBindDropEvents = function() {
            this.dropZoneElement && (EventHandler.remove(this.dropZoneElement, "drop", this.dropElement), 
            EventHandler.remove(this.dropZoneElement, "dragover", this.dragHover), EventHandler.remove(this.dropZoneElement, "dragleave", this.onDragLeave));
        }, Uploader.prototype.onDragLeave = function(e) {
            this.dropZoneElement.classList.remove("e-upload-drag-hover");
        }, Uploader.prototype.dragHover = function(e) {
            this.enabled && (this.dropZoneElement.classList.add("e-upload-drag-hover"), e.preventDefault(), 
            e.stopPropagation());
        }, Uploader.prototype.dropElement = function(e) {
            this.dropZoneElement.classList.remove("e-upload-drag-hover"), this.onSelectFiles(e), 
            e.preventDefault(), e.stopPropagation();
        }, Uploader.prototype.removeFiles = function(args) {
            if (this.enabled) {
                var selectedElement = args.target.parentElement, index = this.fileList.indexOf(selectedElement), fileData = this.filesData[index];
                this.remove(fileData), this.element.value = "", this.checkActionButtonStatus();
            }
        }, Uploader.prototype.removeFilesData = function(file, customTemplate) {
            if (!customTemplate) {
                var selectedElement = this.getLiElement(file);
                if (!isNullOrUndefined(selectedElement)) {
                    detach(selectedElement);
                    var index = this.fileList.indexOf(selectedElement);
                    this.fileList.splice(index, 1), this.filesData.splice(index, 1), 0 === this.fileList.length && (detach(this.listParent), 
                    this.listParent = null, this.removeActionButtons());
                }
            }
        }, Uploader.prototype.removeUploadedFile = function(file, custom) {
            var _this = this, selectedFiles = file, ajax = new XMLHttpRequest(), name = this.element.getAttribute("name"), formData = new FormData();
            formData.append(name, selectedFiles.rawFile), ajax.addEventListener("load", function(e) {
                _this.removeCompleted(e, selectedFiles, custom);
            }, !1), ajax.addEventListener("error", function(e) {
                _this.removeFailed(e, selectedFiles, custom);
            }, !1), ajax.open("POST", this.asyncSettings.removeUrl), ajax.send(formData);
        }, Uploader.prototype.removeCompleted = function(e, files, customTemplate) {
            var args = {
                e: e,
                operation: "remove",
                file: this.updateStatus(files, this.localizedTexts("removedSuccessMessage"), "2")
            };
            this.trigger("success", args), this.removeFilesData(files, customTemplate);
            var index = this.uploadedFilesData.indexOf(files);
            this.uploadedFilesData.splice(index, 1), this.trigger("change", {
                files: this.uploadedFilesData
            });
        }, Uploader.prototype.removeFailed = function(e, files, customTemplate) {
            var args = {
                e: e,
                operation: "remove",
                file: this.updateStatus(files, this.localizedTexts("removedFailedMessage"), "0")
            };
            if (!customTemplate) {
                var index = this.filesData.indexOf(files), rootElement = this.fileList[index];
                if (rootElement) {
                    var statusElement = rootElement.querySelector("." + STATUS);
                    rootElement.classList.remove(UPLOAD_SUCCESS), statusElement.classList.remove(UPLOAD_SUCCESS), 
                    rootElement.classList.add("e-upload-fails"), statusElement.classList.add("e-upload-fails");
                }
                this.checkActionButtonStatus();
            }
            this.trigger("failure", args);
        }, Uploader.prototype.onSelectFiles = function(args) {
            if (this.enabled) {
                var targetFiles, fileData = [];
                if ("drop" === args.type) {
                    var files = args.dataTransfer.files;
                    targetFiles = this.multiple ? this.sortFileList(files) : [ files[0] ];
                } else targetFiles = [].slice.call(args.target.files);
                this.multiple || (this.clearData(), targetFiles = [ targetFiles[0] ]);
                for (var i = 0; i < targetFiles.length; i++) {
                    var file = targetFiles[i], eventArgs_1 = {
                        name: file.name,
                        rawFile: file,
                        size: file.size,
                        status: this.localizedTexts("readyToUploadMessage"),
                        type: this.getFileType(file.name),
                        validationMessages: this.validatedFileSize(file.size),
                        statusCode: "1"
                    };
                    eventArgs_1.status = "" !== eventArgs_1.validationMessages.minSize ? this.localizedTexts("invalidMinFileSize") : "" !== eventArgs_1.validationMessages.maxSize ? this.localizedTexts("invalidMaxFileSize") : eventArgs_1.status, 
                    "" === eventArgs_1.validationMessages.minSize && "" === eventArgs_1.validationMessages.maxSize || (eventArgs_1.statusCode = "0"), 
                    fileData.push(eventArgs_1);
                }
                var eventArgs = {
                    cancel: !1,
                    filesData: fileData,
                    isModified: !1,
                    modifiedFilesData: [],
                    progressInterval: ""
                };
                if ("drop" === args.type && (fileData = this.checkExtension(fileData)), this.trigger("selected", eventArgs), 
                !eventArgs.cancel) {
                    if (eventArgs.isModified && eventArgs.modifiedFilesData.length > 0) {
                        var dataFiles = this.checkExtension(eventArgs.modifiedFilesData);
                        this.updateSortedFileList(dataFiles), this.isForm || this.checkAutoUpload(dataFiles), 
                        this.filesData = dataFiles;
                    } else this.createFileList(fileData), this.filesData = this.filesData.concat(fileData), 
                    this.isForm || this.checkAutoUpload(fileData);
                    isNullOrUndefined(eventArgs.progressInterval) || "" === eventArgs.progressInterval || (this.progressInterval = eventArgs.progressInterval);
                }
            }
        }, Uploader.prototype.clearData = function() {
            isNullOrUndefined(this.listParent) || (detach(this.listParent), this.listParent = null), 
            "msie" !== Browser.info.name && (this.element.value = ""), this.fileList = [], this.filesData = [], 
            this.removeActionButtons();
        }, Uploader.prototype.updateSortedFileList = function(filesData) {
            var previousListClone = createElement("div", {
                id: "clonewrapper"
            }), added = -1;
            if (this.listParent) {
                for (var i = 0; i < this.listParent.querySelectorAll("li").length; i++) {
                    var liElement = this.listParent.querySelectorAll("li")[i];
                    previousListClone.appendChild(liElement.cloneNode(!0));
                }
                for (var _i = 0, removedList_1 = this.listParent.querySelectorAll("li"); _i < removedList_1.length; _i++) {
                    detach(removedList_1[_i]);
                }
                this.removeActionButtons();
                var oldList = [].slice.call(previousListClone.childNodes);
                detach(this.listParent), this.listParent = null, this.fileList = [], this.createParentUL();
                for (var index = 0; index < filesData.length; index++) {
                    for (var j = 0; j < this.filesData.length; j++) this.filesData[j].name === filesData[index].name && (this.listParent.appendChild(oldList[j]), 
                    EventHandler.add(oldList[j].querySelector(".e-icons"), "click", this.removeFiles, this), 
                    this.fileList.push(oldList[j]), added = index);
                    added !== index && this.createFileList([ filesData[index] ]);
                }
            } else this.createFileList(filesData);
        }, Uploader.prototype.checkExtension = function(files) {
            var dropFiles = files;
            if ("" !== this.allowedExtensions) {
                for (var allowedExtensions = [], _i = 0, extensions_1 = this.allowedExtensions.split(","); _i < extensions_1.length; _i++) {
                    var extension = extensions_1[_i];
                    allowedExtensions.push(extension.trim().toLocaleLowerCase());
                }
                for (var i = 0; i < files.length; i++) -1 === allowedExtensions.indexOf(("." + files[i].type).toLocaleLowerCase()) && (files[i].status = this.localizedTexts("invalidFileType"), 
                files[i].statusCode = "0");
            }
            return dropFiles;
        }, Uploader.prototype.validatedFileSize = function(fileSize) {
            var minSizeError = "", maxSizeError = "";
            fileSize < this.minFileSize ? minSizeError = this.localizedTexts("invalidMinFileSize") : fileSize > this.maxFileSize ? maxSizeError = this.localizedTexts("invalidMaxFileSize") : (minSizeError = "", 
            maxSizeError = "");
            return {
                minSize: minSizeError,
                maxSize: maxSizeError
            };
        }, Uploader.prototype.createCustomfileList = function(fileData) {
            this.createParentUL();
            for (var _i = 0, fileData_1 = fileData; _i < fileData_1.length; _i++) {
                var listItem = fileData_1[_i], liElement = createElement("li", {
                    className: FILE,
                    attrs: {
                        "data-file-name": listItem.name
                    }
                });
                this.uploadTemplateFn = this.templateComplier(this.template);
                for (var length_2 = this.uploadTemplateFn(listItem).length, i = 0; i < length_2; i++) liElement.appendChild(this.uploadTemplateFn(listItem)[i]);
                this.listParent.appendChild(liElement), this.fileList.push(liElement);
            }
        }, Uploader.prototype.createParentUL = function() {
            isNullOrUndefined(this.listParent) && (this.listParent = createElement("ul", {
                className: "e-upload-files"
            }), this.uploadWrapper.appendChild(this.listParent), this.listParent.style.display = this.showFileList ? "block" : "none");
        }, Uploader.prototype.createFileList = function(fileData) {
            if (this.createParentUL(), "" === this.template || isNullOrUndefined(this.template)) for (var _i = 0, fileData_2 = fileData; _i < fileData_2.length; _i++) {
                var listItem = fileData_2[_i], liElement = createElement("li", {
                    className: FILE,
                    attrs: {
                        "data-file-name": listItem.name
                    }
                }), textContainer = createElement("span", {
                    className: "e-file-container"
                }), textElement = createElement("span", {
                    className: "e-file-name",
                    attrs: {
                        title: listItem.name
                    }
                });
                textElement.innerHTML = this.getFileNameOnly(listItem.name);
                var fileExtension = createElement("span", {
                    className: "e-file-type"
                });
                if (fileExtension.innerHTML = "." + this.getFileType(listItem.name), this.enableRtl) {
                    var rtlContainer = createElement("span", {
                        className: "e-rtl-container"
                    });
                    rtlContainer.appendChild(fileExtension), rtlContainer.appendChild(textElement), 
                    textContainer.appendChild(rtlContainer);
                } else textContainer.appendChild(textElement), textContainer.appendChild(fileExtension);
                var fileSize = createElement("span", {
                    className: "e-file-size"
                });
                fileSize.innerHTML = this.bytesToSize(listItem.size), textContainer.appendChild(fileSize);
                var statusElement = createElement("span", {
                    className: STATUS
                });
                textContainer.appendChild(statusElement), statusElement.innerHTML = listItem.status, 
                liElement.appendChild(textContainer);
                var iconElement = createElement("span", {
                    className: " e-icons",
                    attrs: {
                        tabindex: "-1"
                    }
                });
                "msie" === Browser.info.name && iconElement.classList.add("e-msie"), "2" !== listItem.statusCode ? iconElement.setAttribute("title", this.localizedTexts("remove")) : iconElement.setAttribute("title", this.localizedTexts("delete")), 
                liElement.appendChild(iconElement), EventHandler.add(iconElement, "click", this.removeFiles, this), 
                "2" === listItem.statusCode ? (statusElement.classList.add(UPLOAD_SUCCESS), iconElement.classList.add("e-file-delete-btn")) : "1" !== listItem.statusCode && (statusElement.classList.remove(UPLOAD_SUCCESS), 
                statusElement.classList.add("e-validation-fails")), this.autoUpload && "1" === listItem.statusCode && "" !== this.asyncSettings.saveUrl && (statusElement.innerHTML = ""), 
                iconElement.classList.contains("e-file-delete-btn") || iconElement.classList.add(CLEAR_ICON), 
                this.listParent.appendChild(liElement), this.fileList.push(liElement), this.truncateName(textElement);
            } else this.createCustomfileList(fileData);
        }, Uploader.prototype.truncateName = function(name) {
            var text, nameElement = name;
            nameElement.offsetWidth < nameElement.scrollWidth && (text = nameElement.textContent, 
            nameElement.dataset.tail = text.slice(text.length - 10));
        }, Uploader.prototype.getFileType = function(name) {
            var extension, index = name.lastIndexOf(".");
            return index >= 0 && (extension = name.substring(index + 1)), extension || "";
        }, Uploader.prototype.getFileNameOnly = function(name) {
            var type = this.getFileType(name);
            return type = name.split("." + type)[0];
        }, Uploader.prototype.setInitialAttributes = function() {
            if (this.initialAttr.accept && this.element.setAttribute("accept", this.initialAttr.accept), 
            this.initialAttr.disabled && this.element.setAttribute("disabled", "disabled"), 
            this.initialAttr.multiple) {
                var newAttr = document.createAttribute("multiple");
                this.element.setAttributeNode(newAttr);
            }
        }, Uploader.prototype.filterfileList = function(files) {
            for (var filterFiles = [], i = 0; i < files.length; i++) this.getLiElement(files[i]).classList.contains(UPLOAD_SUCCESS) || filterFiles.push(files[i]);
            return filterFiles;
        }, Uploader.prototype.updateStatus = function(files, status, statusCode) {
            "" === status || isNullOrUndefined(status) || "" === statusCode || isNullOrUndefined(statusCode) || (files.status = status, 
            files.statusCode = statusCode);
            var li = this.getLiElement(files);
            return isNullOrUndefined(li) || isNullOrUndefined(li.querySelector("." + STATUS)) || "" === status || isNullOrUndefined(status) || (li.querySelector("." + STATUS).textContent = status), 
            files;
        }, Uploader.prototype.getLiElement = function(files) {
            var li, liElements = [];
            if (this.uploadWrapper) {
                liElements = this.uploadWrapper.querySelectorAll(".e-upload-files> li");
                for (var i = 0; i < liElements.length; i++) liElements[i].getAttribute("data-file-name") === files.name && (li = liElements[i]);
            }
            return li;
        }, Uploader.prototype.createProgressBar = function(liElement) {
            var progressbarWrapper = createElement("span", {
                className: "e-upload-progress-wrap"
            }), progressBar = createElement("progressbar", {
                className: PROGRESSBAR,
                attrs: {
                    value: "0",
                    max: "100"
                }
            }), progressbarInnerWrapper = createElement("span", {
                className: "e-progress-inner-wrap"
            });
            progressBar.setAttribute("style", "width: 0%");
            var progressbarText = createElement("span", {
                className: "e-progress-bar-text"
            });
            progressbarText.textContent = "0%", progressbarInnerWrapper.appendChild(progressBar), 
            progressbarWrapper.appendChild(progressbarInnerWrapper), progressbarWrapper.appendChild(progressbarText), 
            liElement.querySelector(".e-file-container").appendChild(progressbarWrapper);
        }, Uploader.prototype.updateProgressbar = function(e, li) {
            if (!isNaN(Math.round(e.loaded / e.total * 100)) && !isNullOrUndefined(li.querySelector("." + PROGRESSBAR))) if (isNullOrUndefined(this.progressInterval) || "" === this.progressInterval) this.changeProgressValue(li, Math.round(e.loaded / e.total * 100).toString() + "%"); else {
                var value = Math.round(e.loaded / e.total * 100) % parseInt(this.progressInterval, 10);
                0 !== value && 100 !== value || this.changeProgressValue(li, Math.round(e.loaded / e.total * 100).toString() + "%");
            }
        }, Uploader.prototype.changeProgressValue = function(li, progressValue) {
            li.querySelector("." + PROGRESSBAR).setAttribute("style", "width:" + progressValue), 
            li.querySelector(".e-progress-bar-text").textContent = progressValue;
        }, Uploader.prototype.uploadInProgress = function(e, files, customUI) {
            var li = this.getLiElement(files);
            if (!isNullOrUndefined(li) || customUI && !isNullOrUndefined(customUI)) {
                isNullOrUndefined(li) || (li.querySelectorAll(".e-upload-progress-wrap").length > 0 || !li.querySelector("." + STATUS) || (li.querySelector("." + STATUS).classList.add("e-upload-progress"), 
                this.createProgressBar(li), this.updateProgressBarClasses(li, "e-upload-progress")), 
                this.updateProgressbar(e, li), isNullOrUndefined(li.querySelector(".e-icons")) || (li.querySelector(".e-icons").removeAttribute("title"), 
                EventHandler.remove(li.querySelector(".e-icons"), "click", this.removeFiles), li.querySelector(".e-icons").classList.add("e-upload-progress")));
                var args = {
                    e: e,
                    operation: "upload",
                    file: this.updateStatus(files, this.localizedTexts("inProgress"), "3")
                };
                this.trigger("progress", args);
            }
        }, Uploader.prototype.uploadComplete = function(e, files, customUI) {
            var status = e.target;
            if (4 === status.readyState && 200 === status.status) {
                var li = this.getLiElement(files);
                if (isNullOrUndefined(li) && (!customUI || isNullOrUndefined(customUI))) return;
                isNullOrUndefined(li) || (this.updateProgressBarClasses(li, UPLOAD_SUCCESS), this.removeProgressbar(li, "success"), 
                isNullOrUndefined(li.querySelector("." + CLEAR_ICON)) || (li.querySelector("." + CLEAR_ICON).classList.add("e-file-delete-btn"), 
                li.querySelector("." + CLEAR_ICON).setAttribute("title", this.localizedTexts("delete")), 
                li.querySelector("." + CLEAR_ICON).classList.remove(CLEAR_ICON)), isNullOrUndefined(li.querySelector(".e-icons")) || (EventHandler.add(li.querySelector(".e-icons"), "click", this.removeFiles, this), 
                li.querySelector(".e-icons").classList.remove("e-upload-progress"), li.querySelector(".e-icons").setAttribute("title", this.localizedTexts("delete"))));
                var args = {
                    e: e,
                    operation: "upload",
                    file: this.updateStatus(files, this.localizedTexts("uploadSuccessMessage"), "2")
                };
                this.trigger("success", args), this.uploadedFilesData.push(files), this.trigger("change", {
                    files: this.uploadedFilesData
                }), this.checkActionButtonStatus();
            } else this.uploadFailed(e, files);
        }, Uploader.prototype.uploadFailed = function(e, files) {
            var li = this.getLiElement(files), args = {
                e: e,
                operation: "upload",
                file: this.updateStatus(files, this.localizedTexts("uploadFailedMessage"), "0")
            };
            isNullOrUndefined(li) || (this.updateProgressBarClasses(li, "e-upload-fails"), this.removeProgressbar(li, "failure"), 
            li.querySelector("." + CLEAR_ICON).setAttribute("title", this.localizedTexts("remove")), 
            EventHandler.add(li.querySelector(".e-icons"), "click", this.removeFiles, this), 
            li.querySelector(".e-icons").classList.remove("e-upload-progress")), this.trigger("failure", args), 
            this.checkActionButtonStatus();
        }, Uploader.prototype.updateProgressBarClasses = function(li, className) {
            var progressBar = li.querySelector("." + PROGRESSBAR);
            isNullOrUndefined(progressBar) || progressBar.classList.add(className);
        }, Uploader.prototype.removeProgressbar = function(li, callType) {
            var _this = this;
            isNullOrUndefined(li.querySelector(".e-upload-progress-wrap")) || (this.progressAnimation = new Animation({
                duration: 1250
            }), this.progressAnimation.animate(li.querySelector(".e-upload-progress-wrap"), {
                name: "FadeOut"
            }), this.progressAnimation.animate(li.querySelector(".e-progress-bar-text"), {
                name: "FadeOut"
            }), setTimeout(function() {
                _this.animateProgressBar(li, callType);
            }, 750));
        }, Uploader.prototype.animateProgressBar = function(li, callType) {
            "success" === callType ? (li.classList.add(UPLOAD_SUCCESS), isNullOrUndefined(li.querySelector("." + STATUS)) || (li.querySelector("." + STATUS).classList.remove("e-upload-progress"), 
            this.progressAnimation.animate(li.querySelector("." + STATUS), {
                name: "FadeIn"
            }), li.querySelector("." + STATUS).classList.add(UPLOAD_SUCCESS))) : isNullOrUndefined(li.querySelector("." + STATUS)) || (li.querySelector("." + STATUS).classList.remove("e-upload-progress"), 
            this.progressAnimation.animate(li.querySelector("." + STATUS), {
                name: "FadeIn"
            }), li.querySelector("." + STATUS).classList.add("e-upload-fails")), detach(li.querySelector(".e-upload-progress-wrap"));
        }, Uploader.prototype.setExtensions = function(extensions) {
            this.element.setAttribute("accept", extensions);
        }, Uploader.prototype.templateComplier = function(uploadTemplate) {
            if (uploadTemplate) try {
                if (document.querySelectorAll(uploadTemplate).length) return compile$$1(document.querySelector(uploadTemplate).innerHTML.trim());
            } catch (exception) {
                return compile$$1(uploadTemplate);
            }
        }, Uploader.prototype.setRTL = function() {
            this.enableRtl ? addClass([ this.uploadWrapper ], "e-rtl") : removeClass([ this.uploadWrapper ], "e-rtl");
        }, Uploader.prototype.localizedTexts = function(localeText) {
            return this.l10n.setLocale(this.locale), this.l10n.getConstant(localeText);
        }, Uploader.prototype.setControlStatus = function() {
            this.enabled ? (this.uploadWrapper.classList.contains("e-disabled") && this.uploadWrapper.classList.remove("e-disabled"), 
            !isNullOrUndefined(this.browseButton) && this.element.hasAttribute("disabled") && (this.element.removeAttribute("disabled"), 
            this.browseButton.removeAttribute("disabled")), !isNullOrUndefined(this.clearButton) && this.clearButton.hasAttribute("disabled") && this.clearButton.removeAttribute("disabled"), 
            !isNullOrUndefined(this.uploadButton) && this.uploadButton.hasAttribute("disabled") && this.uploadButton.hasAttribute("disabled")) : (this.uploadWrapper.classList.add("e-disabled"), 
            this.element.setAttribute("disabled", "disabled"), this.browseButton.setAttribute("disabled", "disabled"), 
            isNullOrUndefined(this.clearButton) || this.clearButton.setAttribute("disabled", "disabled"), 
            isNullOrUndefined(this.uploadButton) || this.uploadButton.setAttribute("disabled", "disabled"));
        }, Uploader.prototype.checkHTMLAttributes = function() {
            this.element.hasAttribute("accept") && (this.allowedExtensions = this.element.getAttribute("accept"), 
            this.initialAttr.accept = this.allowedExtensions), this.element.hasAttribute("multiple") && (this.multiple = !0, 
            this.initialAttr.multiple = !0), this.element.hasAttribute("disabled") && (this.enabled = !1, 
            this.initialAttr.disabled = !0);
        }, Uploader.prototype.bytesToSize = function(bytes) {
            var i = -1;
            if (!bytes) return "0.0 KB";
            do {
                bytes /= 1e3, i++;
            } while (bytes > 99);
            return i >= 2 && (bytes *= 1e3, i = 1), Math.max(bytes, 0).toFixed(1) + " " + [ "KB", "MB" ][i];
        }, Uploader.prototype.sortFileList = function(filesData) {
            for (var files = filesData, fileNames = [], i = 0; i < files.length; i++) fileNames.push(files[i].name);
            for (var sortedFilesData = [], _i = 0, sortedFileNames_1 = fileNames.sort(); _i < sortedFileNames_1.length; _i++) {
                var name_1 = sortedFileNames_1[_i];
                for (i = 0; i < files.length; i++) name_1 === files[i].name && sortedFilesData.push(files[i]);
            }
            return sortedFilesData;
        }, Uploader.prototype.destroy = function() {
            this.element.value = null, this.clearAll(), this.unWireEvents(), this.unBindDropEvents(), 
            this.multiple && this.element.removeAttribute("multiple"), this.enabled || this.element.removeAttribute("disabled"), 
            this.element.removeAttribute("accept"), this.setInitialAttributes(), this.uploadWrapper.parentElement.appendChild(this.cloneElement), 
            this.cloneElement.classList.remove("e-control", "e-uploader"), detach(this.uploadWrapper), 
            this.uploadWrapper = null, _super.prototype.destroy.call(this);
        }, Uploader.prototype.upload = function(files, custom) {
            var _this = this, selectedFiles = [];
            if ("" !== this.asyncSettings.saveUrl && !isNullOrUndefined(this.asyncSettings.saveUrl)) {
                if (!custom || isNullOrUndefined(custom)) if (this.multiple) selectedFiles = this.filterfileList(files); else {
                    var file = [];
                    file.push(files[0]), selectedFiles = this.filterfileList(file);
                } else selectedFiles = files;
                for (var _loop_1 = function(i) {
                    var ajax = new XMLHttpRequest(), formData = new FormData();
                    if ("1" === selectedFiles[i].statusCode) {
                        var eventArgs = {
                            fileData: selectedFiles[i],
                            customFormData: [],
                            cancel: !1
                        };
                        if (this_1.trigger("uploading", eventArgs), eventArgs.cancel) return {
                            value: void 0
                        };
                        var name_2 = this_1.element.getAttribute("name");
                        if (formData.append(name_2, selectedFiles[i].rawFile, selectedFiles[i].name), eventArgs.customFormData.length > 0) for (var i_1 = 0; i_1 < eventArgs.customFormData.length; i_1++) {
                            var customData = eventArgs.customFormData[i_1];
                            formData.append(Object.keys(customData)[0], Object.values(customData)[0]);
                        }
                        ajax.addEventListener("load", function(e) {
                            _this.uploadComplete(e, selectedFiles[i], custom);
                        }, !1), ajax.addEventListener("error", function(e) {
                            _this.uploadFailed(e, selectedFiles[i]);
                        }, !1), ajax.upload.addEventListener("progress", function(e) {
                            _this.uploadInProgress(e, selectedFiles[i], custom);
                        }, !1), ajax.open("POST", this_1.asyncSettings.saveUrl), ajax.send(formData);
                    }
                }, this_1 = this, i = 0; i < selectedFiles.length; i++) {
                    var state_1 = _loop_1(i);
                    if ("object" == typeof state_1) return state_1.value;
                }
            }
        }, Uploader.prototype.remove = function(fileData, customTemplate) {
            var removeFiles = [];
            (fileData = isNullOrUndefined(fileData) ? this.filesData : fileData) instanceof Array ? removeFiles = fileData : removeFiles.push(fileData);
            var eventArgs = {
                cancel: !1,
                filesData: removeFiles
            };
            if (this.trigger("removing", eventArgs), !eventArgs.cancel) for (var removeUrl = this.asyncSettings.removeUrl, validUrl = "" !== removeUrl && !isNullOrUndefined(removeUrl), _i = 0, removeFiles_1 = removeFiles; _i < removeFiles_1.length; _i++) {
                var files = removeFiles_1[_i];
                "2" === files.statusCode && validUrl ? this.removeUploadedFile(files, customTemplate) : this.removeFilesData(files, customTemplate);
            }
        }, Uploader.prototype.clearAll = function() {
            if (!isNullOrUndefined(this.listParent)) {
                var eventArgs = {
                    cancel: !1,
                    filesData: this.filesData
                };
                this.trigger("clearing", eventArgs), eventArgs.cancel || this.clearData();
            }
        }, Uploader.prototype.getFilesData = function() {
            return this.filesData;
        }, __decorate$4$2([ Complex({
            saveUrl: "",
            removeUrl: ""
        }, AsyncSettings) ], Uploader.prototype, "asyncSettings", void 0), __decorate$4$2([ Property(!1) ], Uploader.prototype, "enableRtl", void 0), 
        __decorate$4$2([ Property(!0) ], Uploader.prototype, "enabled", void 0), __decorate$4$2([ Property(null) ], Uploader.prototype, "template", void 0), 
        __decorate$4$2([ Property(!0) ], Uploader.prototype, "multiple", void 0), __decorate$4$2([ Property(!0) ], Uploader.prototype, "autoUpload", void 0), 
        __decorate$4$2([ Complex({}, ButtonsProps) ], Uploader.prototype, "buttons", void 0), 
        __decorate$4$2([ Property("") ], Uploader.prototype, "allowedExtensions", void 0), 
        __decorate$4$2([ Property(0) ], Uploader.prototype, "minFileSize", void 0), __decorate$4$2([ Property(3e7) ], Uploader.prototype, "maxFileSize", void 0), 
        __decorate$4$2([ Property(null) ], Uploader.prototype, "dropArea", void 0), __decorate$4$2([ Collection([ {} ], FilesProp) ], Uploader.prototype, "files", void 0), 
        __decorate$4$2([ Property(!0) ], Uploader.prototype, "showFileList", void 0), __decorate$4$2([ Event() ], Uploader.prototype, "selected", void 0), 
        __decorate$4$2([ Event() ], Uploader.prototype, "uploading", void 0), __decorate$4$2([ Event() ], Uploader.prototype, "success", void 0), 
        __decorate$4$2([ Event() ], Uploader.prototype, "failure", void 0), __decorate$4$2([ Event() ], Uploader.prototype, "removing", void 0), 
        __decorate$4$2([ Event() ], Uploader.prototype, "clearing", void 0), __decorate$4$2([ Event() ], Uploader.prototype, "progress", void 0), 
        __decorate$4$2([ Event() ], Uploader.prototype, "change", void 0), Uploader = __decorate$4$2([ NotifyPropertyChanges ], Uploader);
    }(Component), _inputs = Object.freeze({
        NumericTextBox: NumericTextBox,
        regularExpressions: regularExpressions,
        createMask: createMask,
        applyMask: applyMask,
        wireEvents: wireEvents,
        unwireEvents: unwireEvents,
        unstrippedValue: unstrippedValue,
        strippedValue: strippedValue,
        maskInputFocusHandler: maskInputFocusHandler,
        maskInputBlurHandler: maskInputBlurHandler,
        maskInputDropHandler: maskInputDropHandler,
        mobileRemoveFunction: mobileRemoveFunction,
        setMaskValue: setMaskValue,
        setElementValue: setElementValue,
        maskInput: function(args) {
            var inputEle = getMaskInput(args);
            applyMask.call(inputEle);
            var val = strippedValue.call(this, this.element);
            this.prevValue = val, this.value = val, args.mask && (unwireEvents.call(inputEle), 
            wireEvents.call(inputEle));
        },
        getVal: function(args) {
            return strippedValue.call(getUtilMaskEle(args), args.element);
        },
        getMaskedVal: function(args) {
            return unstrippedValue.call(getUtilMaskEle(args), args.element);
        },
        MaskUndo: MaskUndo,
        MaskedTextBox: MaskedTextBox,
        get Input() {
            return Input;
        },
        TicksData: TicksData,
        TooltipData: TooltipData,
        Slider: Slider,
        get ErrorOption() {
            return ErrorOption;
        },
        FormValidator: FormValidator,
        FilesProp: FilesProp,
        ButtonsProps: ButtonsProps,
        AsyncSettings: AsyncSettings,
        Uploader: Uploader
    }), queryString = "", prevString = "", matches$1 = [], activeClass = "e-active", Query = function() {
        function Query(from) {
            return this.subQuery = null, this.isChild = !1, this.queries = [], this.key = "", 
            this.fKey = "", "string" == typeof from ? this.fromTable = from : from && from instanceof Array && (this.lookups = from), 
            this.expands = [], this.sortedColumns = [], this.groupedColumns = [], this.subQuery = null, 
            this.isChild = !1, this.params = [], this;
        }
        return Query.prototype.setKey = function(field) {
            return this.key = field, this;
        }, Query.prototype.using = function(dataManager) {
            return this.dataManager = dataManager, this;
        }, Query.prototype.execute = function(dataManager, done, fail, always) {
            return (dataManager = dataManager || this.dataManager) ? dataManager.executeQuery(this, done, fail, always) : DataUtil.throwError('Query - execute() : dataManager needs to be is set using "using" function or should be passed as argument');
        }, Query.prototype.executeLocal = function(dataManager) {
            return (dataManager = dataManager || this.dataManager) ? dataManager.executeLocal(this) : DataUtil.throwError('Query - executeLocal() : dataManager needs to be is set using "using" function or should be passed as argument');
        }, Query.prototype.clone = function() {
            var cloned = new Query();
            return cloned.queries = this.queries.slice(0), cloned.key = this.key, cloned.isChild = this.isChild, 
            cloned.dataManager = this.dataManager, cloned.fromTable = this.fromTable, cloned.params = this.params.slice(0), 
            cloned.expands = this.expands.slice(0), cloned.sortedColumns = this.sortedColumns.slice(0), 
            cloned.groupedColumns = this.groupedColumns.slice(0), cloned.subQuerySelector = this.subQuerySelector, 
            cloned.subQuery = this.subQuery, cloned.fKey = this.fKey, cloned.isCountRequired = this.isCountRequired, 
            cloned;
        }, Query.prototype.from = function(tableName) {
            return this.fromTable = tableName, this;
        }, Query.prototype.addParams = function(key, value) {
            return "function" == typeof value ? this.params.push({
                key: key,
                fn: value
            }) : this.params.push({
                key: key,
                value: value
            }), this;
        }, Query.prototype.expand = function(tables) {
            return this.expands = "string" == typeof tables ? [].slice.call([ tables ], 0) : tables.slice(0), 
            this;
        }, Query.prototype.where = function(fieldName, operator, value, ignoreCase, ignoreAccent) {
            operator = operator ? operator.toLowerCase() : null;
            var predicate = null;
            return "string" == typeof fieldName ? predicate = new Predicate(fieldName, operator, value, ignoreCase, ignoreAccent) : fieldName instanceof Predicate && (predicate = fieldName), 
            this.queries.push({
                fn: "onWhere",
                e: predicate
            }), this;
        }, Query.prototype.search = function(searchKey, fieldNames, operator, ignoreCase, ignoreAccent) {
            "string" == typeof fieldNames && (fieldNames = [ fieldNames ]), operator = operator || "contains";
            var comparer = DataUtil.fnOperators[operator];
            return this.queries.push({
                fn: "onSearch",
                e: {
                    fieldNames: fieldNames,
                    operator: operator,
                    searchKey: searchKey,
                    ignoreCase: ignoreCase,
                    ignoreAccent: ignoreAccent,
                    comparer: comparer
                }
            }), this;
        }, Query.prototype.sortBy = function(fieldName, comparer, isFromGroup) {
            var sorts, temp, order = "ascending";
            if ("string" == typeof fieldName && DataUtil.endsWith(fieldName.toLowerCase(), " desc") && (fieldName = fieldName.replace(/ desc$/i, ""), 
            comparer = "descending"), comparer && "string" != typeof comparer || (order = comparer ? comparer.toLowerCase() : "ascending", 
            comparer = DataUtil.fnSort(comparer)), isFromGroup) {
                sorts = Query.filterQueries(this.queries, "onSortBy");
                for (var i = 0; i < sorts.length; i++) if ("string" == typeof (temp = sorts[i].e.fieldName)) {
                    if (temp === fieldName) return this;
                } else if (temp instanceof Array) for (var j = 0; j < temp.length; j++) if (temp[j] === fieldName || fieldName.toLowerCase() === temp[j] + " desc") return this;
            }
            return this.queries.push({
                fn: "onSortBy",
                e: {
                    fieldName: fieldName,
                    comparer: comparer,
                    direction: order
                }
            }), this;
        }, Query.prototype.sortByDesc = function(fieldName) {
            return this.sortBy(fieldName, "descending");
        }, Query.prototype.group = function(fieldName, fn, format) {
            return this.sortBy(fieldName, null, !0), this.queries.push({
                fn: "onGroup",
                e: {
                    fieldName: fieldName,
                    comparer: fn || null,
                    format: format || null
                }
            }), this;
        }, Query.prototype.page = function(pageIndex, pageSize) {
            return this.queries.push({
                fn: "onPage",
                e: {
                    pageIndex: pageIndex,
                    pageSize: pageSize
                }
            }), this;
        }, Query.prototype.range = function(start, end) {
            return this.queries.push({
                fn: "onRange",
                e: {
                    start: start,
                    end: end
                }
            }), this;
        }, Query.prototype.take = function(nos) {
            return this.queries.push({
                fn: "onTake",
                e: {
                    nos: nos
                }
            }), this;
        }, Query.prototype.skip = function(nos) {
            return this.queries.push({
                fn: "onSkip",
                e: {
                    nos: nos
                }
            }), this;
        }, Query.prototype.select = function(fieldNames) {
            return "string" == typeof fieldNames && (fieldNames = [].slice.call([ fieldNames ], 0)), 
            this.queries.push({
                fn: "onSelect",
                e: {
                    fieldNames: fieldNames
                }
            }), this;
        }, Query.prototype.hierarchy = function(query, selectorFn) {
            return this.subQuerySelector = selectorFn, this.subQuery = query, this;
        }, Query.prototype.foreignKey = function(key) {
            return this.fKey = key, this;
        }, Query.prototype.requiresCount = function() {
            return this.isCountRequired = !0, this;
        }, Query.prototype.aggregate = function(type, field) {
            return this.queries.push({
                fn: "onAggregates",
                e: {
                    field: field,
                    type: type
                }
            }), this;
        }, Query.filterQueries = function(queries, name) {
            return queries.filter(function(q) {
                return q.fn === name;
            });
        }, Query.filterQueryLists = function(queries, singles) {
            for (var filtered = queries.filter(function(q) {
                return -1 !== singles.indexOf(q.fn);
            }), res = {}, i = 0; i < filtered.length; i++) res[filtered[i].fn] || (res[filtered[i].fn] = filtered[i].e);
            return res;
        }, Query;
    }(), Predicate = function() {
        function Predicate(field, operator, value, ignoreCase, ignoreAccent) {
            return void 0 === ignoreCase && (ignoreCase = !1), this.ignoreAccent = !1, this.isComplex = !1, 
            "string" == typeof field ? (this.field = field, this.operator = operator.toLowerCase(), 
            this.value = value, this.ignoreCase = ignoreCase, this.ignoreAccent = ignoreAccent, 
            this.isComplex = !1, this.comparer = DataUtil.fnOperators.processOperator(this.operator)) : (field instanceof Predicate && value instanceof Predicate || value instanceof Array) && (this.isComplex = !0, 
            this.condition = operator.toLowerCase(), this.predicates = [ field ], value instanceof Array ? [].push.apply(this.predicates, value) : this.predicates.push(value)), 
            this;
        }
        return Predicate.and = function() {
            for (var args = [], _i = 0; _i < arguments.length; _i++) args[_i] = arguments[_i];
            return Predicate.combinePredicates([].slice.call(args, 0), "and");
        }, Predicate.prototype.and = function(field, operator, value, ignoreCase, ignoreAccent) {
            return Predicate.combine(this, field, operator, value, "and", ignoreCase, ignoreAccent);
        }, Predicate.or = function() {
            for (var args = [], _i = 0; _i < arguments.length; _i++) args[_i] = arguments[_i];
            return Predicate.combinePredicates([].slice.call(args, 0), "or");
        }, Predicate.prototype.or = function(field, operator, value, ignoreCase, ignoreAccent) {
            return Predicate.combine(this, field, operator, value, "or", ignoreCase, ignoreAccent);
        }, Predicate.fromJson = function(json) {
            if (json instanceof Array) {
                for (var res = [], i = 0, len = json.length; i < len; i++) res.push(this.fromJSONData(json[i]));
                return res;
            }
            var pred = json;
            return this.fromJSONData(pred);
        }, Predicate.prototype.validate = function(record) {
            var isAnd, ret, predicate = this.predicates ? this.predicates : [];
            if (!this.isComplex && this.comparer) return this.comparer.call(this, DataUtil.getObject(this.field, record), this.value, this.ignoreCase, this.ignoreAccent);
            isAnd = "and" === this.condition;
            for (var i = 0; i < predicate.length; i++) if (ret = predicate[i].validate(record), 
            isAnd) {
                if (!ret) return !1;
            } else if (ret) return !0;
            return isAnd;
        }, Predicate.prototype.toJson = function() {
            var predicates, p;
            if (this.isComplex) {
                predicates = [], p = this.predicates;
                for (var i = 0; i < p.length; i++) predicates.push(p[i].toJson());
            }
            return {
                isComplex: this.isComplex,
                field: this.field,
                operator: this.operator,
                value: this.value,
                ignoreCase: this.ignoreCase,
                ignoreAccent: this.ignoreAccent,
                condition: this.condition,
                predicates: predicates
            };
        }, Predicate.combinePredicates = function(predicates, operator) {
            if (1 === predicates.length) {
                if (!(predicates[0] instanceof Array)) return predicates[0];
                predicates = predicates[0];
            }
            return new Predicate(predicates[0], operator, predicates.slice(1));
        }, Predicate.combine = function(pred, field, operator, value, condition, ignoreCase, ignoreAccent) {
            return field instanceof Predicate ? Predicate[condition](pred, field) : "string" == typeof field ? Predicate[condition](pred, new Predicate(field, operator, value, ignoreCase, ignoreAccent)) : DataUtil.throwError("Predicate - " + condition + " : invalid arguments");
        }, Predicate.fromJSONData = function(json) {
            for (var preds = json.predicates || [], len = preds.length, predicates = [], i = 0; i < len; i++) predicates.push(this.fromJSONData(preds[i]));
            return json.isComplex ? new Predicate(predicates[0], json.condition, predicates.slice(1)) : new Predicate(json.field, json.operator, json.value, json.ignoreCase, json.ignoreAccent);
        }, Predicate;
    }(), consts = {
        GroupGuid: "{271bbba0-1ee7}"
    }, DataUtil = function() {
        function DataUtil() {}
        return DataUtil.getValue = function(value, inst) {
            return "function" == typeof value ? value.call(inst || {}) : value;
        }, DataUtil.endsWith = function(input, substr) {
            return input.slice(-substr.length) === substr;
        }, DataUtil.startsWith = function(input, start) {
            return input.slice(0, start.length) === start;
        }, DataUtil.fnSort = function(order) {
            return "ascending" === (order = order ? DataUtil.toLowerCase(order) : "ascending") ? this.fnAscending : this.fnDescending;
        }, DataUtil.fnAscending = function(x, y) {
            return null === y || void 0 === y ? -1 : "string" == typeof x ? x.localeCompare(y) : null === x || void 0 === x ? 1 : x - y;
        }, DataUtil.fnDescending = function(x, y) {
            return null === y || void 0 === y ? 1 : "string" == typeof x ? -1 * x.localeCompare(y) : null === x || void 0 === x ? -1 : y - x;
        }, DataUtil.extractFields = function(obj, fields) {
            for (var newObj = {}, i = 0; i < fields.length; i++) newObj = this.setValue(fields[i], this.getObject(fields[i], obj), newObj);
            return newObj;
        }, DataUtil.select = function(jsonArray, fields) {
            for (var newData = [], i = 0; i < jsonArray.length; i++) newData.push(this.extractFields(jsonArray[i], fields));
            return newData;
        }, DataUtil.group = function(jsonArray, field, aggregates, level, groupDs, format) {
            level = level || 1;
            var jsonData = jsonArray;
            if (jsonData.GroupGuid === consts.GroupGuid) {
                for (var _loop_1 = function(j) {
                    if (isNullOrUndefined(groupDs)) jsonData[j].items = this_1.group(jsonData[j].items, field, aggregates, jsonData.level + 1, null, format), 
                    jsonData[j].count = jsonData[j].items.length; else {
                        var indx = -1, temp = groupDs.filter(function(e) {
                            return e.key === jsonData[j].key;
                        });
                        indx = groupDs.indexOf(temp[0]), jsonData[j].items = this_1.group(jsonData[j].items, field, aggregates, jsonData.level + 1, groupDs[indx].items, format), 
                        jsonData[j].count = groupDs[indx].count;
                    }
                }, this_1 = this, j = 0; j < jsonData.length; j++) _loop_1(j);
                return jsonData.childLevels += 1, jsonData;
            }
            var grouped = {}, groupedArray = [];
            groupedArray.GroupGuid = consts.GroupGuid, groupedArray.level = level, groupedArray.childLevels = 0, 
            groupedArray.records = jsonData;
            for (var _loop_2 = function(i) {
                var val = this_2.getVal(jsonData, i, field);
                if (isNullOrUndefined(format) || (val = format(val, field)), !grouped[val] && (grouped[val] = {
                    key: val,
                    count: 0,
                    items: [],
                    aggregates: {},
                    field: field
                }, groupedArray.push(grouped[val]), !isNullOrUndefined(groupDs))) {
                    var tempObj = groupDs.filter(function(e) {
                        return e.key === grouped[val].key;
                    });
                    grouped[val].count = tempObj[0].count;
                }
                grouped[val].count = isNullOrUndefined(groupDs) ? grouped[val].count += 1 : grouped[val].count, 
                grouped[val].items.push(jsonData[i]);
            }, this_2 = this, i = 0; i < jsonData.length; i++) _loop_2(i);
            if (aggregates && aggregates.length) {
                var _loop_3 = function(i) {
                    for (var res = {}, fn = void 0, aggs = aggregates, j = 0; j < aggregates.length; j++) if (fn = DataUtil.aggregates[aggregates[j].type], 
                    isNullOrUndefined(groupDs)) fn && (res[aggs[j].field + " - " + aggs[j].type] = fn(groupedArray[i].items, aggs[j].field)); else {
                        var temp = groupDs.filter(function(e) {
                            return e.key === groupedArray[i].key;
                        });
                        fn && (res[aggs[j].field + " - " + aggs[j].type] = fn(temp[0].items, aggs[j].field));
                    }
                    groupedArray[i].aggregates = res;
                };
                for (i = 0; i < groupedArray.length; i++) _loop_3(i);
            }
            return jsonData.length && groupedArray || jsonData;
        }, DataUtil.buildHierarchy = function(fKey, from, source, lookup, pKey) {
            var i, grp = {};
            for (lookup.result && (lookup = lookup.result), lookup.GroupGuid && this.throwError("DataManager: Do not have support Grouping in hierarchy"), 
            i = 0; i < lookup.length; i++) {
                (grp[fKeyData = this.getObject(fKey, lookup[i])] || (grp[fKeyData] = [])).push(lookup[i]);
            }
            for (i = 0; i < source.length; i++) {
                var fKeyData = this.getObject(pKey || fKey, source[i]);
                source[i][from] = grp[fKeyData];
            }
        }, DataUtil.getFieldList = function(obj, fields, prefix) {
            if (void 0 === prefix && (prefix = ""), void 0 === fields || null === fields) return this.getFieldList(obj, [], prefix);
            for (var copyObj = obj, _i = 0, keys_1 = Object.keys(obj); _i < keys_1.length; _i++) {
                var prop = keys_1[_i];
                "object" != typeof copyObj[prop] || copyObj[prop] instanceof Array ? fields.push(prefix + prop) : this.getFieldList(copyObj[prop], fields, prefix + prop + ".");
            }
            return fields;
        }, DataUtil.getObject = function(nameSpace, from) {
            if (!nameSpace) return from;
            if (-1 === nameSpace.indexOf(".")) return from[nameSpace];
            for (var value = from, splits = nameSpace.split("."), i = 0; i < splits.length && null != value; i++) value = value[splits[i]];
            return value;
        }, DataUtil.setValue = function(nameSpace, value, obj) {
            var i, key, keys = nameSpace.toString().split("."), start = obj || {}, fromObj = start, length = keys.length;
            for (i = 0; i < length; i++) key = keys[i], i + 1 === length ? fromObj[key] = void 0 === value ? void 0 : value : isNullOrUndefined(fromObj[key]) && (fromObj[key] = {}), 
            fromObj = fromObj[key];
            return start;
        }, DataUtil.sort = function(ds, field, comparer) {
            if (ds.length <= 1) return ds;
            var middle = parseInt((ds.length / 2).toString(), 10), left = ds.slice(0, middle), right = ds.slice(middle);
            return left = this.sort(left, field, comparer), right = this.sort(right, field, comparer), 
            this.merge(left, right, field, comparer);
        }, DataUtil.ignoreDiacritics = function(value) {
            if ("string" != typeof value) return value;
            return value.split("").map(function(temp) {
                return temp in DataUtil.diacritics ? DataUtil.diacritics[temp] : temp;
            }).join("");
        }, DataUtil.merge = function(left, right, fieldName, comparer) {
            for (var current, result = []; left.length > 0 || right.length > 0; ) current = left.length > 0 && right.length > 0 ? comparer ? comparer(this.getVal(left, 0, fieldName), this.getVal(right, 0, fieldName)) <= 0 ? left : right : left[0][fieldName] < left[0][fieldName] ? left : right : left.length > 0 ? left : right, 
            result.push(current.shift());
            return result;
        }, DataUtil.getVal = function(array, index, field) {
            return field ? this.getObject(field, array[index]) : array[index];
        }, DataUtil.toLowerCase = function(val) {
            return val ? "string" == typeof val ? val.toLowerCase() : val.toString() : 0 === val || !1 === val ? val.toString() : "";
        }, DataUtil.callAdaptorFunction = function(adaptor, fnName, param1, param2) {
            if (fnName in adaptor) {
                var res = adaptor[fnName](param1, param2);
                this.fnOperators.isnull(res) || (param1 = res);
            }
            return param1;
        }, DataUtil.isPlainObject = function(obj) {
            return !!obj && obj.constructor === Object;
        }, DataUtil.isCors = function() {
            var xhr = null;
            try {
                xhr = new window.XMLHttpRequest();
            } catch (e) {}
            return !!xhr && "withCredentials" in xhr;
        }, DataUtil.getGuid = function(prefix) {
            var rand;
            return (prefix || "") + "00000000-0000-4000-0000-000000000000".replace(/0/g, function(val, i) {
                if ("crypto" in window && "getRandomValues" in crypto) {
                    var arr = new Uint8Array(1);
                    window.crypto.getRandomValues(arr), rand = arr[0] % 16 | 0;
                } else rand = 16 * Math.random() | 0;
                return "0123456789abcdef"[19 === i ? 3 & rand | 8 : rand];
            });
        }, DataUtil.isNull = function(val) {
            return void 0 === val || null === val;
        }, DataUtil.getItemFromComparer = function(array, field, comparer) {
            var keyVal, current, key, i = 0, castRequired = "string" == typeof DataUtil.getVal(array, 0, field);
            if (array.length) for (;isNullOrUndefined(keyVal) && i < array.length; ) keyVal = DataUtil.getVal(array, i, field), 
            key = array[i++];
            for (;i < array.length; i++) isNullOrUndefined(current = DataUtil.getVal(array, i, field)) || (castRequired && (keyVal = +keyVal, 
            current = +current), comparer(keyVal, current) > 0 && (keyVal = current, key = array[i]));
            return key;
        }, DataUtil.distinct = function(json, fieldName, requiresCompleteRecord) {
            requiresCompleteRecord = !isNullOrUndefined(requiresCompleteRecord) && requiresCompleteRecord;
            var val, result = [], tmp = {};
            return json.forEach(function(data, index) {
                (val = DataUtil.getVal(json, index, fieldName)) in tmp || (result.push(requiresCompleteRecord ? json[index] : val), 
                tmp[val] = 1);
            }), result;
        }, DataUtil.serverTimezoneOffset = null, DataUtil.throwError = function(error) {
            try {
                throw new Error(error);
            } catch (e) {
                throw e.message + "\n" + e.stack;
            }
        }, DataUtil.aggregates = {
            sum: function(ds, field) {
                for (var val, result = 0, castRequired = "number" != typeof DataUtil.getVal(ds, 0, field), i = 0; i < ds.length; i++) val = DataUtil.getVal(ds, i, field), 
                isNaN(val) || null === val || (castRequired && (val = +val), result += val);
                return result;
            },
            average: function(ds, field) {
                return DataUtil.aggregates.sum(ds, field) / ds.length;
            },
            min: function(ds, field) {
                var result, comparer;
                return "function" == typeof field && (comparer = field, field = null), result = DataUtil.getObject(field, DataUtil.getItemFromComparer(ds, field, comparer || DataUtil.fnAscending)), 
                isNullOrUndefined(result) ? null : result;
            },
            max: function(ds, field) {
                var result, comparer;
                return "function" == typeof field && (comparer = field, field = null), result = DataUtil.getObject(field, DataUtil.getItemFromComparer(ds, field, comparer || DataUtil.fnDescending)), 
                isNullOrUndefined(result) ? null : result;
            },
            truecount: function(ds, field) {
                return new DataManager(ds).executeLocal(new Query().where(field, "equal", !0, !0)).length;
            },
            falsecount: function(ds, field) {
                return new DataManager(ds).executeLocal(new Query().where(field, "equal", !1, !0)).length;
            },
            count: function(ds, field) {
                return ds.length;
            }
        }, DataUtil.operatorSymbols = {
            "<": "lessthan",
            ">": "greaterthan",
            "<=": "lessthanorequal",
            ">=": "greaterthanorequal",
            "==": "equal",
            "!=": "notequal",
            "*=": "contains",
            "$=": "endswith",
            "^=": "startswith"
        }, DataUtil.odBiOperator = {
            "<": " lt ",
            ">": " gt ",
            "<=": " le ",
            ">=": " ge ",
            "==": " eq ",
            "!=": " ne ",
            lessthan: " lt ",
            lessthanorequal: " le ",
            greaterthan: " gt ",
            greaterthanorequal: " ge ",
            equal: " eq ",
            notequal: " ne "
        }, DataUtil.odUniOperator = {
            "$=": "endswith",
            "^=": "startswith",
            "*=": "substringof",
            endswith: "endswith",
            startswith: "startswith",
            contains: "substringof"
        }, DataUtil.odv4UniOperator = {
            "$=": "endswith",
            "^=": "startswith",
            "*=": "contains",
            endswith: "endswith",
            startswith: "startswith",
            contains: "contains"
        }, DataUtil.diacritics = {
            "Ⓐ": "A",
            "Ａ": "A",
            "À": "A",
            "Á": "A",
            "Â": "A",
            "Ầ": "A",
            "Ấ": "A",
            "Ẫ": "A",
            "Ẩ": "A",
            "Ã": "A",
            "Ā": "A",
            "Ă": "A",
            "Ằ": "A",
            "Ắ": "A",
            "Ẵ": "A",
            "Ẳ": "A",
            "Ȧ": "A",
            "Ǡ": "A",
            "Ä": "A",
            "Ǟ": "A",
            "Ả": "A",
            "Å": "A",
            "Ǻ": "A",
            "Ǎ": "A",
            "Ȁ": "A",
            "Ȃ": "A",
            "Ạ": "A",
            "Ậ": "A",
            "Ặ": "A",
            "Ḁ": "A",
            "Ą": "A",
            "Ⱥ": "A",
            "Ɐ": "A",
            "Ꜳ": "AA",
            "Æ": "AE",
            "Ǽ": "AE",
            "Ǣ": "AE",
            "Ꜵ": "AO",
            "Ꜷ": "AU",
            "Ꜹ": "AV",
            "Ꜻ": "AV",
            "Ꜽ": "AY",
            "Ⓑ": "B",
            "Ｂ": "B",
            "Ḃ": "B",
            "Ḅ": "B",
            "Ḇ": "B",
            "Ƀ": "B",
            "Ƃ": "B",
            "Ɓ": "B",
            "Ⓒ": "C",
            "Ｃ": "C",
            "Ć": "C",
            "Ĉ": "C",
            "Ċ": "C",
            "Č": "C",
            "Ç": "C",
            "Ḉ": "C",
            "Ƈ": "C",
            "Ȼ": "C",
            "Ꜿ": "C",
            "Ⓓ": "D",
            "Ｄ": "D",
            "Ḋ": "D",
            "Ď": "D",
            "Ḍ": "D",
            "Ḑ": "D",
            "Ḓ": "D",
            "Ḏ": "D",
            "Đ": "D",
            "Ƌ": "D",
            "Ɗ": "D",
            "Ɖ": "D",
            "Ꝺ": "D",
            "Ǳ": "DZ",
            "Ǆ": "DZ",
            "ǲ": "Dz",
            "ǅ": "Dz",
            "Ⓔ": "E",
            "Ｅ": "E",
            "È": "E",
            "É": "E",
            "Ê": "E",
            "Ề": "E",
            "Ế": "E",
            "Ễ": "E",
            "Ể": "E",
            "Ẽ": "E",
            "Ē": "E",
            "Ḕ": "E",
            "Ḗ": "E",
            "Ĕ": "E",
            "Ė": "E",
            "Ë": "E",
            "Ẻ": "E",
            "Ě": "E",
            "Ȅ": "E",
            "Ȇ": "E",
            "Ẹ": "E",
            "Ệ": "E",
            "Ȩ": "E",
            "Ḝ": "E",
            "Ę": "E",
            "Ḙ": "E",
            "Ḛ": "E",
            "Ɛ": "E",
            "Ǝ": "E",
            "Ⓕ": "F",
            "Ｆ": "F",
            "Ḟ": "F",
            "Ƒ": "F",
            "Ꝼ": "F",
            "Ⓖ": "G",
            "Ｇ": "G",
            "Ǵ": "G",
            "Ĝ": "G",
            "Ḡ": "G",
            "Ğ": "G",
            "Ġ": "G",
            "Ǧ": "G",
            "Ģ": "G",
            "Ǥ": "G",
            "Ɠ": "G",
            "Ꞡ": "G",
            "Ᵹ": "G",
            "Ꝿ": "G",
            "Ⓗ": "H",
            "Ｈ": "H",
            "Ĥ": "H",
            "Ḣ": "H",
            "Ḧ": "H",
            "Ȟ": "H",
            "Ḥ": "H",
            "Ḩ": "H",
            "Ḫ": "H",
            "Ħ": "H",
            "Ⱨ": "H",
            "Ⱶ": "H",
            "Ɥ": "H",
            "Ⓘ": "I",
            "Ｉ": "I",
            "Ì": "I",
            "Í": "I",
            "Î": "I",
            "Ĩ": "I",
            "Ī": "I",
            "Ĭ": "I",
            "İ": "I",
            "Ï": "I",
            "Ḯ": "I",
            "Ỉ": "I",
            "Ǐ": "I",
            "Ȉ": "I",
            "Ȋ": "I",
            "Ị": "I",
            "Į": "I",
            "Ḭ": "I",
            "Ɨ": "I",
            "Ⓙ": "J",
            "Ｊ": "J",
            "Ĵ": "J",
            "Ɉ": "J",
            "Ⓚ": "K",
            "Ｋ": "K",
            "Ḱ": "K",
            "Ǩ": "K",
            "Ḳ": "K",
            "Ķ": "K",
            "Ḵ": "K",
            "Ƙ": "K",
            "Ⱪ": "K",
            "Ꝁ": "K",
            "Ꝃ": "K",
            "Ꝅ": "K",
            "Ꞣ": "K",
            "Ⓛ": "L",
            "Ｌ": "L",
            "Ŀ": "L",
            "Ĺ": "L",
            "Ľ": "L",
            "Ḷ": "L",
            "Ḹ": "L",
            "Ļ": "L",
            "Ḽ": "L",
            "Ḻ": "L",
            "Ł": "L",
            "Ƚ": "L",
            "Ɫ": "L",
            "Ⱡ": "L",
            "Ꝉ": "L",
            "Ꝇ": "L",
            "Ꞁ": "L",
            "Ǉ": "LJ",
            "ǈ": "Lj",
            "Ⓜ": "M",
            "Ｍ": "M",
            "Ḿ": "M",
            "Ṁ": "M",
            "Ṃ": "M",
            "Ɱ": "M",
            "Ɯ": "M",
            "Ⓝ": "N",
            "Ｎ": "N",
            "Ǹ": "N",
            "Ń": "N",
            "Ñ": "N",
            "Ṅ": "N",
            "Ň": "N",
            "Ṇ": "N",
            "Ņ": "N",
            "Ṋ": "N",
            "Ṉ": "N",
            "Ƞ": "N",
            "Ɲ": "N",
            "Ꞑ": "N",
            "Ꞥ": "N",
            "Ǌ": "NJ",
            "ǋ": "Nj",
            "Ⓞ": "O",
            "Ｏ": "O",
            "Ò": "O",
            "Ó": "O",
            "Ô": "O",
            "Ồ": "O",
            "Ố": "O",
            "Ỗ": "O",
            "Ổ": "O",
            "Õ": "O",
            "Ṍ": "O",
            "Ȭ": "O",
            "Ṏ": "O",
            "Ō": "O",
            "Ṑ": "O",
            "Ṓ": "O",
            "Ŏ": "O",
            "Ȯ": "O",
            "Ȱ": "O",
            "Ö": "O",
            "Ȫ": "O",
            "Ỏ": "O",
            "Ő": "O",
            "Ǒ": "O",
            "Ȍ": "O",
            "Ȏ": "O",
            "Ơ": "O",
            "Ờ": "O",
            "Ớ": "O",
            "Ỡ": "O",
            "Ở": "O",
            "Ợ": "O",
            "Ọ": "O",
            "Ộ": "O",
            "Ǫ": "O",
            "Ǭ": "O",
            "Ø": "O",
            "Ǿ": "O",
            "Ɔ": "O",
            "Ɵ": "O",
            "Ꝋ": "O",
            "Ꝍ": "O",
            "Ƣ": "OI",
            "Ꝏ": "OO",
            "Ȣ": "OU",
            "Ⓟ": "P",
            "Ｐ": "P",
            "Ṕ": "P",
            "Ṗ": "P",
            "Ƥ": "P",
            "Ᵽ": "P",
            "Ꝑ": "P",
            "Ꝓ": "P",
            "Ꝕ": "P",
            "Ⓠ": "Q",
            "Ｑ": "Q",
            "Ꝗ": "Q",
            "Ꝙ": "Q",
            "Ɋ": "Q",
            "Ⓡ": "R",
            "Ｒ": "R",
            "Ŕ": "R",
            "Ṙ": "R",
            "Ř": "R",
            "Ȑ": "R",
            "Ȓ": "R",
            "Ṛ": "R",
            "Ṝ": "R",
            "Ŗ": "R",
            "Ṟ": "R",
            "Ɍ": "R",
            "Ɽ": "R",
            "Ꝛ": "R",
            "Ꞧ": "R",
            "Ꞃ": "R",
            "Ⓢ": "S",
            "Ｓ": "S",
            "ẞ": "S",
            "Ś": "S",
            "Ṥ": "S",
            "Ŝ": "S",
            "Ṡ": "S",
            "Š": "S",
            "Ṧ": "S",
            "Ṣ": "S",
            "Ṩ": "S",
            "Ș": "S",
            "Ş": "S",
            "Ȿ": "S",
            "Ꞩ": "S",
            "Ꞅ": "S",
            "Ⓣ": "T",
            "Ｔ": "T",
            "Ṫ": "T",
            "Ť": "T",
            "Ṭ": "T",
            "Ț": "T",
            "Ţ": "T",
            "Ṱ": "T",
            "Ṯ": "T",
            "Ŧ": "T",
            "Ƭ": "T",
            "Ʈ": "T",
            "Ⱦ": "T",
            "Ꞇ": "T",
            "Ꜩ": "TZ",
            "Ⓤ": "U",
            "Ｕ": "U",
            "Ù": "U",
            "Ú": "U",
            "Û": "U",
            "Ũ": "U",
            "Ṹ": "U",
            "Ū": "U",
            "Ṻ": "U",
            "Ŭ": "U",
            "Ü": "U",
            "Ǜ": "U",
            "Ǘ": "U",
            "Ǖ": "U",
            "Ǚ": "U",
            "Ủ": "U",
            "Ů": "U",
            "Ű": "U",
            "Ǔ": "U",
            "Ȕ": "U",
            "Ȗ": "U",
            "Ư": "U",
            "Ừ": "U",
            "Ứ": "U",
            "Ữ": "U",
            "Ử": "U",
            "Ự": "U",
            "Ụ": "U",
            "Ṳ": "U",
            "Ų": "U",
            "Ṷ": "U",
            "Ṵ": "U",
            "Ʉ": "U",
            "Ⓥ": "V",
            "Ｖ": "V",
            "Ṽ": "V",
            "Ṿ": "V",
            "Ʋ": "V",
            "Ꝟ": "V",
            "Ʌ": "V",
            "Ꝡ": "VY",
            "Ⓦ": "W",
            "Ｗ": "W",
            "Ẁ": "W",
            "Ẃ": "W",
            "Ŵ": "W",
            "Ẇ": "W",
            "Ẅ": "W",
            "Ẉ": "W",
            "Ⱳ": "W",
            "Ⓧ": "X",
            "Ｘ": "X",
            "Ẋ": "X",
            "Ẍ": "X",
            "Ⓨ": "Y",
            "Ｙ": "Y",
            "Ỳ": "Y",
            "Ý": "Y",
            "Ŷ": "Y",
            "Ỹ": "Y",
            "Ȳ": "Y",
            "Ẏ": "Y",
            "Ÿ": "Y",
            "Ỷ": "Y",
            "Ỵ": "Y",
            "Ƴ": "Y",
            "Ɏ": "Y",
            "Ỿ": "Y",
            "Ⓩ": "Z",
            "Ｚ": "Z",
            "Ź": "Z",
            "Ẑ": "Z",
            "Ż": "Z",
            "Ž": "Z",
            "Ẓ": "Z",
            "Ẕ": "Z",
            "Ƶ": "Z",
            "Ȥ": "Z",
            "Ɀ": "Z",
            "Ⱬ": "Z",
            "Ꝣ": "Z",
            "ⓐ": "a",
            "ａ": "a",
            "ẚ": "a",
            "à": "a",
            "á": "a",
            "â": "a",
            "ầ": "a",
            "ấ": "a",
            "ẫ": "a",
            "ẩ": "a",
            "ã": "a",
            "ā": "a",
            "ă": "a",
            "ằ": "a",
            "ắ": "a",
            "ẵ": "a",
            "ẳ": "a",
            "ȧ": "a",
            "ǡ": "a",
            "ä": "a",
            "ǟ": "a",
            "ả": "a",
            "å": "a",
            "ǻ": "a",
            "ǎ": "a",
            "ȁ": "a",
            "ȃ": "a",
            "ạ": "a",
            "ậ": "a",
            "ặ": "a",
            "ḁ": "a",
            "ą": "a",
            "ⱥ": "a",
            "ɐ": "a",
            "ꜳ": "aa",
            "æ": "ae",
            "ǽ": "ae",
            "ǣ": "ae",
            "ꜵ": "ao",
            "ꜷ": "au",
            "ꜹ": "av",
            "ꜻ": "av",
            "ꜽ": "ay",
            "ⓑ": "b",
            "ｂ": "b",
            "ḃ": "b",
            "ḅ": "b",
            "ḇ": "b",
            "ƀ": "b",
            "ƃ": "b",
            "ɓ": "b",
            "ⓒ": "c",
            "ｃ": "c",
            "ć": "c",
            "ĉ": "c",
            "ċ": "c",
            "č": "c",
            "ç": "c",
            "ḉ": "c",
            "ƈ": "c",
            "ȼ": "c",
            "ꜿ": "c",
            "ↄ": "c",
            "ⓓ": "d",
            "ｄ": "d",
            "ḋ": "d",
            "ď": "d",
            "ḍ": "d",
            "ḑ": "d",
            "ḓ": "d",
            "ḏ": "d",
            "đ": "d",
            "ƌ": "d",
            "ɖ": "d",
            "ɗ": "d",
            "ꝺ": "d",
            "ǳ": "dz",
            "ǆ": "dz",
            "ⓔ": "e",
            "ｅ": "e",
            "è": "e",
            "é": "e",
            "ê": "e",
            "ề": "e",
            "ế": "e",
            "ễ": "e",
            "ể": "e",
            "ẽ": "e",
            "ē": "e",
            "ḕ": "e",
            "ḗ": "e",
            "ĕ": "e",
            "ė": "e",
            "ë": "e",
            "ẻ": "e",
            "ě": "e",
            "ȅ": "e",
            "ȇ": "e",
            "ẹ": "e",
            "ệ": "e",
            "ȩ": "e",
            "ḝ": "e",
            "ę": "e",
            "ḙ": "e",
            "ḛ": "e",
            "ɇ": "e",
            "ɛ": "e",
            "ǝ": "e",
            "ⓕ": "f",
            "ｆ": "f",
            "ḟ": "f",
            "ƒ": "f",
            "ꝼ": "f",
            "ⓖ": "g",
            "ｇ": "g",
            "ǵ": "g",
            "ĝ": "g",
            "ḡ": "g",
            "ğ": "g",
            "ġ": "g",
            "ǧ": "g",
            "ģ": "g",
            "ǥ": "g",
            "ɠ": "g",
            "ꞡ": "g",
            "ᵹ": "g",
            "ꝿ": "g",
            "ⓗ": "h",
            "ｈ": "h",
            "ĥ": "h",
            "ḣ": "h",
            "ḧ": "h",
            "ȟ": "h",
            "ḥ": "h",
            "ḩ": "h",
            "ḫ": "h",
            "ẖ": "h",
            "ħ": "h",
            "ⱨ": "h",
            "ⱶ": "h",
            "ɥ": "h",
            "ƕ": "hv",
            "ⓘ": "i",
            "ｉ": "i",
            "ì": "i",
            "í": "i",
            "î": "i",
            "ĩ": "i",
            "ī": "i",
            "ĭ": "i",
            "ï": "i",
            "ḯ": "i",
            "ỉ": "i",
            "ǐ": "i",
            "ȉ": "i",
            "ȋ": "i",
            "ị": "i",
            "į": "i",
            "ḭ": "i",
            "ɨ": "i",
            "ı": "i",
            "ⓙ": "j",
            "ｊ": "j",
            "ĵ": "j",
            "ǰ": "j",
            "ɉ": "j",
            "ⓚ": "k",
            "ｋ": "k",
            "ḱ": "k",
            "ǩ": "k",
            "ḳ": "k",
            "ķ": "k",
            "ḵ": "k",
            "ƙ": "k",
            "ⱪ": "k",
            "ꝁ": "k",
            "ꝃ": "k",
            "ꝅ": "k",
            "ꞣ": "k",
            "ⓛ": "l",
            "ｌ": "l",
            "ŀ": "l",
            "ĺ": "l",
            "ľ": "l",
            "ḷ": "l",
            "ḹ": "l",
            "ļ": "l",
            "ḽ": "l",
            "ḻ": "l",
            "ſ": "l",
            "ł": "l",
            "ƚ": "l",
            "ɫ": "l",
            "ⱡ": "l",
            "ꝉ": "l",
            "ꞁ": "l",
            "ꝇ": "l",
            "ǉ": "lj",
            "ⓜ": "m",
            "ｍ": "m",
            "ḿ": "m",
            "ṁ": "m",
            "ṃ": "m",
            "ɱ": "m",
            "ɯ": "m",
            "ⓝ": "n",
            "ｎ": "n",
            "ǹ": "n",
            "ń": "n",
            "ñ": "n",
            "ṅ": "n",
            "ň": "n",
            "ṇ": "n",
            "ņ": "n",
            "ṋ": "n",
            "ṉ": "n",
            "ƞ": "n",
            "ɲ": "n",
            "ŉ": "n",
            "ꞑ": "n",
            "ꞥ": "n",
            "ǌ": "nj",
            "ⓞ": "o",
            "ｏ": "o",
            "ò": "o",
            "ó": "o",
            "ô": "o",
            "ồ": "o",
            "ố": "o",
            "ỗ": "o",
            "ổ": "o",
            "õ": "o",
            "ṍ": "o",
            "ȭ": "o",
            "ṏ": "o",
            "ō": "o",
            "ṑ": "o",
            "ṓ": "o",
            "ŏ": "o",
            "ȯ": "o",
            "ȱ": "o",
            "ö": "o",
            "ȫ": "o",
            "ỏ": "o",
            "ő": "o",
            "ǒ": "o",
            "ȍ": "o",
            "ȏ": "o",
            "ơ": "o",
            "ờ": "o",
            "ớ": "o",
            "ỡ": "o",
            "ở": "o",
            "ợ": "o",
            "ọ": "o",
            "ộ": "o",
            "ǫ": "o",
            "ǭ": "o",
            "ø": "o",
            "ǿ": "o",
            "ɔ": "o",
            "ꝋ": "o",
            "ꝍ": "o",
            "ɵ": "o",
            "ƣ": "oi",
            "ȣ": "ou",
            "ꝏ": "oo",
            "ⓟ": "p",
            "ｐ": "p",
            "ṕ": "p",
            "ṗ": "p",
            "ƥ": "p",
            "ᵽ": "p",
            "ꝑ": "p",
            "ꝓ": "p",
            "ꝕ": "p",
            "ⓠ": "q",
            "ｑ": "q",
            "ɋ": "q",
            "ꝗ": "q",
            "ꝙ": "q",
            "ⓡ": "r",
            "ｒ": "r",
            "ŕ": "r",
            "ṙ": "r",
            "ř": "r",
            "ȑ": "r",
            "ȓ": "r",
            "ṛ": "r",
            "ṝ": "r",
            "ŗ": "r",
            "ṟ": "r",
            "ɍ": "r",
            "ɽ": "r",
            "ꝛ": "r",
            "ꞧ": "r",
            "ꞃ": "r",
            "ⓢ": "s",
            "ｓ": "s",
            "ß": "s",
            "ś": "s",
            "ṥ": "s",
            "ŝ": "s",
            "ṡ": "s",
            "š": "s",
            "ṧ": "s",
            "ṣ": "s",
            "ṩ": "s",
            "ș": "s",
            "ş": "s",
            "ȿ": "s",
            "ꞩ": "s",
            "ꞅ": "s",
            "ẛ": "s",
            "ⓣ": "t",
            "ｔ": "t",
            "ṫ": "t",
            "ẗ": "t",
            "ť": "t",
            "ṭ": "t",
            "ț": "t",
            "ţ": "t",
            "ṱ": "t",
            "ṯ": "t",
            "ŧ": "t",
            "ƭ": "t",
            "ʈ": "t",
            "ⱦ": "t",
            "ꞇ": "t",
            "ꜩ": "tz",
            "ⓤ": "u",
            "ｕ": "u",
            "ù": "u",
            "ú": "u",
            "û": "u",
            "ũ": "u",
            "ṹ": "u",
            "ū": "u",
            "ṻ": "u",
            "ŭ": "u",
            "ü": "u",
            "ǜ": "u",
            "ǘ": "u",
            "ǖ": "u",
            "ǚ": "u",
            "ủ": "u",
            "ů": "u",
            "ű": "u",
            "ǔ": "u",
            "ȕ": "u",
            "ȗ": "u",
            "ư": "u",
            "ừ": "u",
            "ứ": "u",
            "ữ": "u",
            "ử": "u",
            "ự": "u",
            "ụ": "u",
            "ṳ": "u",
            "ų": "u",
            "ṷ": "u",
            "ṵ": "u",
            "ʉ": "u",
            "ⓥ": "v",
            "ｖ": "v",
            "ṽ": "v",
            "ṿ": "v",
            "ʋ": "v",
            "ꝟ": "v",
            "ʌ": "v",
            "ꝡ": "vy",
            "ⓦ": "w",
            "ｗ": "w",
            "ẁ": "w",
            "ẃ": "w",
            "ŵ": "w",
            "ẇ": "w",
            "ẅ": "w",
            "ẘ": "w",
            "ẉ": "w",
            "ⱳ": "w",
            "ⓧ": "x",
            "ｘ": "x",
            "ẋ": "x",
            "ẍ": "x",
            "ⓨ": "y",
            "ｙ": "y",
            "ỳ": "y",
            "ý": "y",
            "ŷ": "y",
            "ỹ": "y",
            "ȳ": "y",
            "ẏ": "y",
            "ÿ": "y",
            "ỷ": "y",
            "ẙ": "y",
            "ỵ": "y",
            "ƴ": "y",
            "ɏ": "y",
            "ỿ": "y",
            "ⓩ": "z",
            "ｚ": "z",
            "ź": "z",
            "ẑ": "z",
            "ż": "z",
            "ž": "z",
            "ẓ": "z",
            "ẕ": "z",
            "ƶ": "z",
            "ȥ": "z",
            "ɀ": "z",
            "ⱬ": "z",
            "ꝣ": "z",
            "Ά": "Α",
            "Έ": "Ε",
            "Ή": "Η",
            "Ί": "Ι",
            "Ϊ": "Ι",
            "Ό": "Ο",
            "Ύ": "Υ",
            "Ϋ": "Υ",
            "Ώ": "Ω",
            "ά": "α",
            "έ": "ε",
            "ή": "η",
            "ί": "ι",
            "ϊ": "ι",
            "ΐ": "ι",
            "ό": "ο",
            "ύ": "υ",
            "ϋ": "υ",
            "ΰ": "υ",
            "ω": "ω",
            "ς": "σ"
        }, DataUtil.fnOperators = {
            equal: function(actual, expected, ignoreCase, ignoreAccent) {
                return ignoreAccent && (actual = DataUtil.ignoreDiacritics(actual), expected = DataUtil.ignoreDiacritics(expected)), 
                ignoreCase ? DataUtil.toLowerCase(actual) === DataUtil.toLowerCase(expected) : actual === expected;
            },
            notequal: function(actual, expected, ignoreCase, ignoreAccent) {
                return ignoreAccent && (actual = DataUtil.ignoreDiacritics(actual), expected = DataUtil.ignoreDiacritics(expected)), 
                !DataUtil.fnOperators.equal(actual, expected, ignoreCase);
            },
            lessthan: function(actual, expected, ignoreCase) {
                return ignoreCase ? DataUtil.toLowerCase(actual) < DataUtil.toLowerCase(expected) : actual < expected;
            },
            greaterthan: function(actual, expected, ignoreCase) {
                return ignoreCase ? DataUtil.toLowerCase(actual) > DataUtil.toLowerCase(expected) : actual > expected;
            },
            lessthanorequal: function(actual, expected, ignoreCase) {
                return ignoreCase ? DataUtil.toLowerCase(actual) <= DataUtil.toLowerCase(expected) : actual <= expected;
            },
            greaterthanorequal: function(actual, expected, ignoreCase) {
                return ignoreCase ? DataUtil.toLowerCase(actual) >= DataUtil.toLowerCase(expected) : actual >= expected;
            },
            contains: function(actual, expected, ignoreCase, ignoreAccent) {
                return ignoreAccent && (actual = DataUtil.ignoreDiacritics(actual), expected = DataUtil.ignoreDiacritics(expected)), 
                ignoreCase ? !isNullOrUndefined(actual) && !isNullOrUndefined(expected) && -1 !== DataUtil.toLowerCase(actual).indexOf(DataUtil.toLowerCase(expected)) : !isNullOrUndefined(actual) && !isNullOrUndefined(expected) && -1 !== actual.toString().indexOf(expected);
            },
            notnull: function(actual) {
                return null !== actual;
            },
            isnull: function(actual) {
                return null === actual;
            },
            startswith: function(actual, expected, ignoreCase, ignoreAccent) {
                return ignoreAccent && (actual = DataUtil.ignoreDiacritics(actual), expected = DataUtil.ignoreDiacritics(expected)), 
                ignoreCase ? actual && expected && DataUtil.startsWith(DataUtil.toLowerCase(actual), DataUtil.toLowerCase(expected)) : actual && expected && DataUtil.startsWith(actual, expected);
            },
            endswith: function(actual, expected, ignoreCase, ignoreAccent) {
                return ignoreAccent && (actual = DataUtil.ignoreDiacritics(actual), expected = DataUtil.ignoreDiacritics(expected)), 
                ignoreCase ? actual && expected && DataUtil.endsWith(DataUtil.toLowerCase(actual), DataUtil.toLowerCase(expected)) : actual && expected && DataUtil.endsWith(actual, expected);
            },
            processSymbols: function(operator) {
                var fnName = DataUtil.operatorSymbols[operator];
                if (fnName) {
                    return DataUtil.fnOperators[fnName];
                }
                return DataUtil.throwError("Query - Process Operator : Invalid operator");
            },
            processOperator: function(operator) {
                var fn = DataUtil.fnOperators[operator];
                return fn || DataUtil.fnOperators.processSymbols(operator);
            }
        }, DataUtil.parse = {
            parseJson: function(jsonText) {
                return "string" == typeof jsonText ? jsonText = JSON.parse(jsonText, DataUtil.parse.jsonReviver) : jsonText instanceof Array ? DataUtil.parse.iterateAndReviveArray(jsonText) : "object" == typeof jsonText && DataUtil.parse.iterateAndReviveJson(jsonText), 
                jsonText;
            },
            iterateAndReviveArray: function(array) {
                for (var i = 0; i < array.length; i++) "object" == typeof array[i] ? DataUtil.parse.iterateAndReviveJson(array[i]) : "string" != typeof array[i] || /^[\s]*\[|^[\s]*\{|\"/g.test(array[i]) ? array[i] = DataUtil.parse.parseJson(array[i]) : array[i] = DataUtil.parse.jsonReviver("", array[i]);
            },
            iterateAndReviveJson: function(json) {
                for (var value, _i = 0, keys_2 = Object.keys(json); _i < keys_2.length; _i++) {
                    var prop = keys_2[_i];
                    DataUtil.startsWith(prop, "__") || ("object" == typeof (value = json[prop]) ? value instanceof Array ? DataUtil.parse.iterateAndReviveArray(value) : value && DataUtil.parse.iterateAndReviveJson(value) : json[prop] = DataUtil.parse.jsonReviver(json[prop], value));
                }
            },
            jsonReviver: function(field, value) {
                var dupValue = value;
                if ("string" == typeof value) {
                    var ms = /^\/Date\(([+-]?[0-9]+)([+-][0-9]{4})?\)\/$/.exec(value);
                    if (ms) return DataUtil.dateParse.toTimeZone(new Date(parseInt(ms[1], 10)), DataUtil.serverTimezoneOffset, !0);
                    if (/^(\d{4}\-\d\d\-\d\d([tT][\d:\.]*){1})([zZ]|([+\-])(\d\d):?(\d\d))?$/.test(value)) {
                        var arr = dupValue.split(/[^0-9]/);
                        value = DataUtil.dateParse.toTimeZone(new Date(parseInt(arr[0], 10), parseInt(arr[1], 10) - 1, parseInt(arr[2], 10), parseInt(arr[3], 10), parseInt(arr[4], 10), parseInt(arr[5], 10)), DataUtil.serverTimezoneOffset, !0);
                    }
                }
                return value;
            },
            isJson: function(jsonData) {
                return "string" == typeof jsonData[0] ? jsonData : DataUtil.parse.parseJson(jsonData);
            },
            isGuid: function(value) {
                return null != /[A-Fa-f0-9]{8}(?:-[A-Fa-f0-9]{4}){3}-[A-Fa-f0-9]{12}/i.exec(value);
            },
            replacer: function(value, stringify) {
                return DataUtil.isPlainObject(value) ? DataUtil.parse.jsonReplacer(value, stringify) : value instanceof Array ? DataUtil.parse.arrayReplacer(value) : value instanceof Date ? DataUtil.parse.jsonReplacer({
                    val: value
                }, stringify).val : value;
            },
            jsonReplacer: function(val, stringify) {
                for (var value, _i = 0, keys_3 = Object.keys(val); _i < keys_3.length; _i++) {
                    var prop = keys_3[_i];
                    if ((value = val[prop]) instanceof Date) {
                        var d = value;
                        val[prop] = DataUtil.dateParse.toTimeZone(DataUtil.dateParse.addSelfOffset(d), DataUtil.serverTimezoneOffset).toJSON();
                    }
                }
                return val;
            },
            arrayReplacer: function(val) {
                for (var i = 0; i < val.length; i++) DataUtil.isPlainObject(val[i]) ? val[i] = DataUtil.parse.jsonReplacer(val[i]) : val[i] instanceof Date && (val[i] = DataUtil.parse.jsonReplacer({
                    date: val[i]
                }).date);
                return val;
            }
        }, DataUtil.dateParse = {
            addSelfOffset: function(input) {
                return new Date(+input - 6e4 * input.getTimezoneOffset());
            },
            toUTC: function(input) {
                return new Date(+input + 6e4 * input.getTimezoneOffset());
            },
            toTimeZone: function(input, offset, utc) {
                if (null === offset) return input;
                var unix = utc ? DataUtil.dateParse.toUTC(input) : input;
                return new Date(+unix - 36e5 * offset);
            }
        }, DataUtil;
    }(), __extends$8 = function() {
        var extendStatics = Object.setPrototypeOf || {
            __proto__: []
        } instanceof Array && function(d, b) {
            d.__proto__ = b;
        } || function(d, b) {
            for (var p in b) b.hasOwnProperty(p) && (d[p] = b[p]);
        };
        return function(d, b) {
            function __() {
                this.constructor = d;
            }
            extendStatics(d, b), d.prototype = null === b ? Object.create(b) : (__.prototype = b.prototype, 
            new __());
        };
    }(), Adaptor = function() {
        function Adaptor(ds) {
            this.options = {
                from: "table",
                requestType: "json",
                sortBy: "sorted",
                select: "select",
                skip: "skip",
                group: "group",
                take: "take",
                search: "search",
                count: "requiresCounts",
                where: "where",
                aggregates: "aggregates"
            }, this.type = Adaptor, this.dataSource = ds, this.pvt = {};
        }
        return Adaptor.prototype.processResponse = function(data, ds, query, xhr) {
            return data;
        }, Adaptor;
    }(), JsonAdaptor = function(_super) {
        function JsonAdaptor() {
            return null !== _super && _super.apply(this, arguments) || this;
        }
        return __extends$8(JsonAdaptor, _super), JsonAdaptor.prototype.processQuery = function(dataManager, query) {
            for (var ret, key, result = dataManager.dataSource.json.slice(0), count = result.length, countFlg = !0, agg = {}, i = 0; i < query.queries.length; i++) ret = this[(key = query.queries[i]).fn].call(this, result, key.e, query), 
            "onAggregates" === key.fn ? agg[key.e.field + " - " + key.e.type] = ret : result = void 0 !== ret ? ret : result, 
            "onPage" !== key.fn && "onSkip" !== key.fn && "onTake" !== key.fn && "onRange" !== key.fn || (countFlg = !1), 
            countFlg && (count = result.length);
            return query.isCountRequired && (result = {
                result: result,
                count: count,
                aggregates: agg
            }), result;
        }, JsonAdaptor.prototype.batchRequest = function(dm, changes, e) {
            var i;
            for (i = 0; i < changes.addedRecords.length; i++) this.insert(dm, changes.addedRecords[i]);
            for (i = 0; i < changes.changedRecords.length; i++) this.update(dm, e.key, changes.changedRecords[i]);
            for (i = 0; i < changes.deletedRecords.length; i++) this.remove(dm, e.key, changes.deletedRecords[i]);
            return changes;
        }, JsonAdaptor.prototype.onWhere = function(ds, e) {
            return ds && ds.length ? ds.filter(function(obj) {
                if (e) return e.validate(obj);
            }) : ds;
        }, JsonAdaptor.prototype.onAggregates = function(ds, e) {
            var fn = DataUtil.aggregates[e.type];
            return ds && fn && 0 !== ds.length ? fn(ds, e.field) : null;
        }, JsonAdaptor.prototype.onSearch = function(ds, e) {
            return ds && ds.length ? (0 === e.fieldNames.length && DataUtil.getFieldList(ds[0], e.fieldNames), 
            ds.filter(function(obj) {
                for (var j = 0; j < e.fieldNames.length; j++) if (e.comparer.call(obj, DataUtil.getObject(e.fieldNames[j], obj), e.searchKey, e.ignoreCase)) return !0;
                return !1;
            })) : ds;
        }, JsonAdaptor.prototype.onSortBy = function(ds, e, query) {
            if (!ds || !ds.length) return ds;
            var fnCompare, field = DataUtil.getValue(e.fieldName, query);
            if (!field) return ds.sort(e.comparer);
            if (field instanceof Array) {
                for (var i = (field = field.slice(0)).length - 1; i >= 0; i--) field[i] && (fnCompare = e.comparer, 
                DataUtil.endsWith(field[i], " desc") && (fnCompare = DataUtil.fnSort("descending"), 
                field[i] = field[i].replace(" desc", "")), ds = DataUtil.sort(ds, field[i], fnCompare));
                return ds;
            }
            return DataUtil.sort(ds, field, e.comparer);
        }, JsonAdaptor.prototype.onGroup = function(ds, e, query) {
            if (!ds || !ds.length) return ds;
            var aggQuery = Query.filterQueries(query.queries, "onAggregates"), agg = [];
            if (aggQuery.length) for (var tmp = void 0, i = 0; i < aggQuery.length; i++) tmp = aggQuery[i].e, 
            agg.push({
                type: tmp.type,
                field: DataUtil.getValue(tmp.field, query)
            });
            return DataUtil.group(ds, DataUtil.getValue(e.fieldName, query), agg, null, null, e.comparer);
        }, JsonAdaptor.prototype.onPage = function(ds, e, query) {
            var size = DataUtil.getValue(e.pageSize, query), start = (DataUtil.getValue(e.pageIndex, query) - 1) * size, end = start + size;
            return ds && ds.length ? ds.slice(start, end) : ds;
        }, JsonAdaptor.prototype.onRange = function(ds, e) {
            return ds && ds.length ? ds.slice(DataUtil.getValue(e.start), DataUtil.getValue(e.end)) : ds;
        }, JsonAdaptor.prototype.onTake = function(ds, e) {
            return ds && ds.length ? ds.slice(0, DataUtil.getValue(e.nos)) : ds;
        }, JsonAdaptor.prototype.onSkip = function(ds, e) {
            return ds && ds.length ? ds.slice(DataUtil.getValue(e.nos)) : ds;
        }, JsonAdaptor.prototype.onSelect = function(ds, e) {
            return ds && ds.length ? DataUtil.select(ds, DataUtil.getValue(e.fieldNames)) : ds;
        }, JsonAdaptor.prototype.insert = function(dm, data, tableName, query, position) {
            return isNullOrUndefined(position) ? dm.dataSource.json.push(data) : dm.dataSource.json.splice(position, 0, data);
        }, JsonAdaptor.prototype.remove = function(dm, keyField, value, tableName) {
            var i, ds = dm.dataSource.json;
            for ("object" == typeof value && (value = value[keyField]), i = 0; i < ds.length && ds[i][keyField] !== value; i++) ;
            return i !== ds.length ? ds.splice(i, 1) : null;
        }, JsonAdaptor.prototype.update = function(dm, keyField, value, tableName) {
            var i, ds = dm.dataSource.json, key = value[keyField];
            for (i = 0; i < ds.length && ds[i][keyField] !== key; i++) ;
            return i < ds.length ? merge(ds[i], value) : null;
        }, JsonAdaptor;
    }(Adaptor), UrlAdaptor = function(_super) {
        function UrlAdaptor() {
            return null !== _super && _super.apply(this, arguments) || this;
        }
        return __extends$8(UrlAdaptor, _super), UrlAdaptor.prototype.processQuery = function(dm, query, hierarchyFilters) {
            var temp, skip, queries = this.getQueryRequest(query), singles = Query.filterQueryLists(query.queries, [ "onSelect", "onPage", "onSkip", "onTake", "onRange" ]), params = query.params, url = dm.dataSource.url, take = null, options = this.options, request = {
                sorts: [],
                groups: [],
                filters: [],
                searches: [],
                aggregates: []
            };
            "onPage" in singles ? (temp = singles.onPage, skip = ((skip = DataUtil.getValue(temp.pageIndex, query)) - 1) * (take = DataUtil.getValue(temp.pageSize, query))) : "onRange" in singles && (skip = (temp = singles.onRange).start, 
            take = temp.end - temp.start);
            for (var i = 0; i < queries.sorts.length; i++) temp = DataUtil.getValue(queries.sorts[i].e.fieldName, query), 
            request.sorts.push(DataUtil.callAdaptorFunction(this, "onEachSort", {
                name: temp,
                direction: queries.sorts[i].e.direction
            }, query));
            hierarchyFilters && (temp = this.getFiltersFrom(hierarchyFilters, query)) && request.filters.push(DataUtil.callAdaptorFunction(this, "onEachWhere", temp.toJson(), query));
            for (i = 0; i < queries.filters.length; i++) {
                request.filters.push(DataUtil.callAdaptorFunction(this, "onEachWhere", queries.filters[i].e.toJson(), query));
                for (var _i = 0, keys_2 = "object" == typeof request.filters[i] ? Object.keys(request.filters[i]) : []; _i < keys_2.length; _i++) {
                    var prop = keys_2[_i];
                    DataUtil.isNull(request[prop]) && delete request[prop];
                }
            }
            for (i = 0; i < queries.searches.length; i++) temp = queries.searches[i].e, request.searches.push(DataUtil.callAdaptorFunction(this, "onEachSearch", {
                fields: temp.fieldNames,
                operator: temp.operator,
                key: temp.searchKey,
                ignoreCase: temp.ignoreCase
            }, query));
            for (i = 0; i < queries.groups.length; i++) request.groups.push(DataUtil.getValue(queries.groups[i].e.fieldName, query));
            for (i = 0; i < queries.aggregates.length; i++) temp = queries.aggregates[i].e, 
            request.aggregates.push({
                type: temp.type,
                field: DataUtil.getValue(temp.field, query)
            });
            var req = {};
            this.getRequestQuery(options, query, singles, request, req), DataUtil.callAdaptorFunction(this, "addParams", {
                dm: dm,
                query: query,
                params: params,
                reqParams: req
            });
            for (var _a = 0, keys_3 = Object.keys(req); _a < keys_3.length; _a++) {
                prop = keys_3[_a];
                (DataUtil.isNull(req[prop]) || "" === req[prop] || 0 === req[prop].length) && delete req[prop];
            }
            options.skip in req && options.take in req || null === take || (req[options.skip] = DataUtil.callAdaptorFunction(this, "onSkip", skip, query), 
            req[options.take] = DataUtil.callAdaptorFunction(this, "onTake", take, query));
            var p = this.pvt;
            return this.pvt = {}, "json" === this.options.requestType ? {
                data: JSON.stringify(req),
                url: url,
                pvtData: p,
                type: "POST",
                contentType: "application/json; charset=utf-8"
            } : (temp = this.convertToQueryString(req, query, dm), temp = (-1 !== dm.dataSource.url.indexOf("?") ? "&" : "/") + temp, 
            {
                type: "GET",
                url: temp.length ? url.replace(/\/*$/, temp) : url,
                pvtData: p
            });
        }, UrlAdaptor.prototype.getRequestQuery = function(options, query, singles, request, request1) {
            var req = request1;
            req[options.from] = query.fromTable, options.expand && (req[options.expand] = query.expands), 
            req[options.select] = "onSelect" in singles ? DataUtil.callAdaptorFunction(this, "onSelect", DataUtil.getValue(singles.onSelect.fieldNames, query), query) : "", 
            req[options.count] = query.isCountRequired ? DataUtil.callAdaptorFunction(this, "onCount", query.isCountRequired, query) : "", 
            req[options.search] = request.searches.length ? DataUtil.callAdaptorFunction(this, "onSearch", request.searches, query) : "", 
            req[options.skip] = "onSkip" in singles ? DataUtil.callAdaptorFunction(this, "onSkip", DataUtil.getValue(singles.onSkip.nos, query), query) : "", 
            req[options.take] = "onTake" in singles ? DataUtil.callAdaptorFunction(this, "onTake", DataUtil.getValue(singles.onTake.nos, query), query) : "", 
            req[options.where] = request.filters.length || request.searches.length ? DataUtil.callAdaptorFunction(this, "onWhere", request.filters, query) : "", 
            req[options.sortBy] = request.sorts.length ? DataUtil.callAdaptorFunction(this, "onSortBy", request.sorts, query) : "", 
            req[options.group] = request.groups.length ? DataUtil.callAdaptorFunction(this, "onGroup", request.groups, query) : "", 
            req[options.aggregates] = request.aggregates.length ? DataUtil.callAdaptorFunction(this, "onAggregates", request.aggregates, query) : "", 
            req.param = [];
        }, UrlAdaptor.prototype.convertToQueryString = function(request, query, dm) {
            return "";
        }, UrlAdaptor.prototype.processResponse = function(data, ds, query, xhr, request, changes) {
            var requests = request, pvt = requests.pvtData || {}, groupDs = data.groupDs;
            if (xhr && xhr.getResponseHeader("Content-Type") && -1 !== xhr.getResponseHeader("Content-Type").indexOf("xml")) return query.isCountRequired ? {
                result: [],
                count: 0
            } : [];
            var d = JSON.parse(requests.data);
            if (d && "batch" === d.action && data.addedRecords) return changes.addedRecords = data.addedRecords, 
            changes;
            data.d && (data = data.d);
            var args = {};
            return "count" in data && (args.count = data.count), args.result = data.result ? data.result : data, 
            this.getAggregateResult(pvt, data, args, groupDs), DataUtil.isNull(args.count) ? args.result : {
                result: args.result,
                count: args.count,
                aggregates: args.aggregates
            };
        }, UrlAdaptor.prototype.onGroup = function(e) {
            return this.pvt.groups = e, e;
        }, UrlAdaptor.prototype.onAggregates = function(e) {
            this.pvt.aggregates = e;
        }, UrlAdaptor.prototype.batchRequest = function(dm, changes, e) {
            return {
                type: "POST",
                url: dm.dataSource.batchUrl || dm.dataSource.crudUrl || dm.dataSource.removeUrl || dm.dataSource.url,
                contentType: "application/json; charset=utf-8",
                dataType: "json",
                data: JSON.stringify({
                    changed: changes.changedRecords,
                    added: changes.addedRecords,
                    deleted: changes.deletedRecords,
                    action: "batch",
                    table: e[void 0],
                    key: e[void 0]
                })
            };
        }, UrlAdaptor.prototype.beforeSend = function(dm, request) {}, UrlAdaptor.prototype.insert = function(dm, data, tableName) {
            return {
                url: dm.dataSource.insertUrl || dm.dataSource.crudUrl || dm.dataSource.url,
                data: JSON.stringify({
                    value: data,
                    table: tableName,
                    action: "insert"
                })
            };
        }, UrlAdaptor.prototype.remove = function(dm, keyField, value, tableName) {
            return {
                type: "POST",
                url: dm.dataSource.removeUrl || dm.dataSource.crudUrl || dm.dataSource.url,
                data: JSON.stringify({
                    key: value,
                    keyColumn: keyField,
                    table: tableName,
                    action: "remove"
                })
            };
        }, UrlAdaptor.prototype.update = function(dm, keyField, value, tableName) {
            return {
                type: "POST",
                url: dm.dataSource.updateUrl || dm.dataSource.crudUrl || dm.dataSource.url,
                data: JSON.stringify({
                    value: value,
                    action: "update",
                    keyColumn: keyField,
                    key: value[keyField],
                    table: tableName
                })
            };
        }, UrlAdaptor.prototype.getFiltersFrom = function(data, query) {
            var value, key = query.fKey, prop = key, pKey = query.key, predicats = [];
            "object" != typeof data[0] && (prop = null);
            for (var i = 0; i < data.length; i++) value = "object" == typeof data[0] ? DataUtil.getObject(pKey || prop, data[i]) : data[i], 
            predicats.push(new Predicate(key, "equal", value));
            return Predicate.or(predicats);
        }, UrlAdaptor.prototype.getAggregateResult = function(pvt, data, args, groupDs) {
            var pData = data;
            if (data && data.result && (pData = data.result), pvt && pvt.aggregates && pvt.aggregates.length) {
                var agg = pvt.aggregates, fn = void 0, aggregateData = pData, res = {};
                data.aggregate && (aggregateData = data.aggregate);
                for (var i = 0; i < agg.length; i++) (fn = DataUtil.aggregates[agg[i].type]) && (res[agg[i].field + " - " + agg[i].type] = fn(aggregateData, agg[i].field));
                args.aggregates = res;
            }
            if (pvt && pvt.groups && pvt.groups.length) {
                var groups = pvt.groups;
                for (i = 0; i < groups.length; i++) {
                    isNullOrUndefined(groupDs) || (groupDs = DataUtil.group(groupDs, groups[i])), pData = DataUtil.group(pData, groups[i], pvt.aggregates, null, groupDs);
                }
                args.result = pData;
            }
            return args;
        }, UrlAdaptor.prototype.getQueryRequest = function(query) {
            var req = {
                sorts: [],
                groups: [],
                filters: [],
                searches: [],
                aggregates: []
            };
            return req.sorts = Query.filterQueries(query.queries, "onSortBy"), req.groups = Query.filterQueries(query.queries, "onGroup"), 
            req.filters = Query.filterQueries(query.queries, "onWhere"), req.searches = Query.filterQueries(query.queries, "onSearch"), 
            req.aggregates = Query.filterQueries(query.queries, "onAggregates"), req;
        }, UrlAdaptor.prototype.addParams = function(options) {
            var req = options.reqParams;
            options.params.length && (req.params = {});
            for (var _i = 0, _a = options.params; _i < _a.length; _i++) {
                var tmp = _a[_i];
                if (req[tmp.key]) throw new Error("Query() - addParams: Custom Param is conflicting other request arguments");
                req[tmp.key] = tmp.value, tmp.fn && (req[tmp.key] = tmp.fn.call(options.query, tmp.key, options.query, options.dm)), 
                req.params[tmp.key] = req[tmp.key];
            }
        }, UrlAdaptor;
    }(Adaptor), ODataAdaptor = function(_super) {
        function ODataAdaptor() {
            var _this = _super.call(this) || this;
            return _this.options = extend({}, _this.options, {
                requestType: "get",
                accept: "application/json;odata=light;q=1,application/json;odata=verbose;q=0.5",
                multipartAccept: "multipart/mixed",
                sortBy: "$orderby",
                select: "$select",
                skip: "$skip",
                take: "$top",
                count: "$inlinecount",
                where: "$filter",
                expand: "$expand",
                batch: "$batch",
                changeSet: "--changeset_",
                batchPre: "batch_",
                contentId: "Content-Id: ",
                batchContent: "Content-Type: multipart/mixed; boundary=",
                changeSetContent: "Content-Type: application/http\nContent-Transfer-Encoding: binary ",
                batchChangeSetContentType: "Content-Type: application/json; charset=utf-8 "
            }), _this.getModuleName = getValue("getModulename", _this), _this;
        }
        return __extends$8(ODataAdaptor, _super), ODataAdaptor.prototype.onPredicate = function(predicate, query, requiresCast) {
            var operator, guid, returnValue = "", val = predicate.value, type = typeof val, field = predicate.field ? ODataAdaptor.getField(predicate.field) : null;
            if (val instanceof Date && (val = "datetime'" + DataUtil.parse.replacer(val) + "'"), 
            "string" === type && (val = "'" + val + "'", requiresCast && (field = "cast(" + field + ", 'Edm.String')"), 
            DataUtil.parse.isGuid(val) && (guid = "guid"), predicate.ignoreCase && (guid || (field = "tolower(" + field + ")"), 
            val = val.toLowerCase())), operator = DataUtil.odBiOperator[predicate.operator]) return returnValue += field, 
            returnValue += operator, guid && (returnValue += guid), returnValue + val;
            if (isNullOrUndefined(this.getModuleName) ? operator = DataUtil.odUniOperator[predicate.operator] : "ODataV4Adaptor" === this.getModuleName() && (operator = DataUtil.odv4UniOperator[predicate.operator]), 
            "substringof" === operator) {
                var temp = val;
                val = field, field = temp;
            }
            return returnValue += operator + "(", returnValue += field + ",", guid && (returnValue += guid), 
            returnValue += val + ")";
        }, ODataAdaptor.prototype.onComplexPredicate = function(predicate, query, requiresCast) {
            for (var res = [], i = 0; i < predicate.predicates.length; i++) res.push("(" + this.onEachWhere(predicate.predicates[i], query, requiresCast) + ")");
            return res.join(" " + predicate.condition + " ");
        }, ODataAdaptor.prototype.onEachWhere = function(filter, query, requiresCast) {
            return filter.isComplex ? this.onComplexPredicate(filter, query, requiresCast) : this.onPredicate(filter, query, requiresCast);
        }, ODataAdaptor.prototype.onWhere = function(filters) {
            return this.pvt.search && filters.push(this.onEachWhere(this.pvt.search, null, !0)), 
            filters.join(" and ");
        }, ODataAdaptor.prototype.onEachSearch = function(e) {
            e.fields && 0 === e.fields.length && DataUtil.throwError("Query() - Search : oData search requires list of field names to search");
            for (var filter = this.pvt.search || [], i = 0; i < e.fields.length; i++) filter.push(new Predicate(e.fields[i], e.operator, e.key, e.ignoreCase));
            this.pvt.search = filter;
        }, ODataAdaptor.prototype.onSearch = function(e) {
            return this.pvt.search = Predicate.or(this.pvt.search), "";
        }, ODataAdaptor.prototype.onEachSort = function(e) {
            var res = [];
            if (e.name instanceof Array) for (var i = 0; i < e.name.length; i++) res.push(ODataAdaptor.getField(e.name[i]) + ("descending" === e.direction ? " desc" : "")); else res.push(ODataAdaptor.getField(e.name) + ("descending" === e.direction ? " desc" : ""));
            return res.join(",");
        }, ODataAdaptor.prototype.onSortBy = function(e) {
            return e.reverse().join(",");
        }, ODataAdaptor.prototype.onGroup = function(e) {
            return this.pvt.groups = e, [];
        }, ODataAdaptor.prototype.onSelect = function(e) {
            for (var i = 0; i < e.length; i++) e[i] = ODataAdaptor.getField(e[i]);
            return e.join(",");
        }, ODataAdaptor.prototype.onAggregates = function(e) {
            return this.pvt.aggregates = e, "";
        }, ODataAdaptor.prototype.onCount = function(e) {
            return !0 === e ? "allpages" : "";
        }, ODataAdaptor.prototype.beforeSend = function(dm, request, settings) {
            DataUtil.endsWith(settings.url, this.options.batch) && "post" === settings.type.toLowerCase() ? (request.setRequestHeader("Accept", this.options.multipartAccept), 
            request.setRequestHeader("DataServiceVersion", "2.0"), request.overrideMimeType("text/plain; charset=x-user-defined")) : request.setRequestHeader("Accept", this.options.accept), 
            request.setRequestHeader("DataServiceVersion", "2.0"), request.setRequestHeader("MaxDataServiceVersion", "2.0");
        }, ODataAdaptor.prototype.processResponse = function(data, ds, query, xhr, request, changes) {
            if (!isNullOrUndefined(data.d)) {
                var dataCopy = query && query.isCountRequired ? data.d.results : data.d;
                if (!isNullOrUndefined(dataCopy)) for (var i = 0; i < dataCopy.length; i++) isNullOrUndefined(dataCopy[i].__metadata) || delete dataCopy[i].__metadata;
            }
            var pvt = request && request.pvtData, emptyAndBatch = this.processBatchResponse(data, query, xhr, request, changes);
            if (emptyAndBatch) return emptyAndBatch;
            var versionCheck = xhr && request.getResponseHeader("DataServiceVersion"), count = null, version = versionCheck && parseInt(versionCheck, 10) || 2;
            if (query && query.isCountRequired) {
                (data.__count || data["odata.count"]) && (count = data.__count || data["odata.count"]), 
                data.d && (data = data.d), (data.__count || data["odata.count"]) && (count = data.__count || data["odata.count"]);
            }
            3 === version && data.value && (data = data.value), data.d && (data = data.d), version < 3 && data.results && (data = data.results);
            var args = {};
            return args.count = count, args.result = data, this.getAggregateResult(pvt, data, args), 
            DataUtil.isNull(count) ? args.result : {
                result: args.result,
                count: args.count,
                aggregates: args.aggregates
            };
        }, ODataAdaptor.prototype.convertToQueryString = function(request, query, dm) {
            var res = [], tableName = request.table || "";
            delete request.table, dm.dataSource.requiresFormat && (request.$format = "json");
            for (var _i = 0, keys_4 = Object.keys(request); _i < keys_4.length; _i++) {
                var prop = keys_4[_i];
                res.push(prop + "=" + request[prop]);
            }
            return res = res.join("&"), dm.dataSource.url && -1 !== dm.dataSource.url.indexOf("?") && !tableName ? res : res.length ? tableName + "?" + res : tableName || "";
        }, ODataAdaptor.prototype.insert = function(dm, data, tableName) {
            return {
                url: dm.dataSource.url.replace(/\/*$/, tableName ? "/" + tableName : ""),
                data: JSON.stringify(data)
            };
        }, ODataAdaptor.prototype.remove = function(dm, keyField, value, tableName) {
            return {
                type: "DELETE",
                url: dm.dataSource.url.replace(/\/*$/, tableName ? "/" + tableName : "") + "(" + value + ")"
            };
        }, ODataAdaptor.prototype.update = function(dm, keyField, value, tableName) {
            return {
                type: "PUT",
                url: dm.dataSource.url.replace(/\/*$/, tableName ? "/" + tableName : "") + "(" + value[keyField] + ")",
                data: JSON.stringify(value),
                accept: this.options.accept
            };
        }, ODataAdaptor.prototype.batchRequest = function(dm, changes, e) {
            var initialGuid = e.guid = DataUtil.getGuid(this.options.batchPre), url = dm.dataSource.url.replace(/\/*$/, "/" + this.options.batch), args = {
                url: e.url,
                key: e.key,
                cid: 1,
                cSet: DataUtil.getGuid(this.options.changeSet)
            }, req = "--" + initialGuid + "\n";
            return req += "Content-Type: multipart/mixed; boundary=" + args.cSet.replace("--", "") + "\n", 
            this.pvt.changeSet = 0, req += this.generateInsertRequest(changes.addedRecords, args), 
            req += this.generateUpdateRequest(changes.changedRecords, args), req += this.generateDeleteRequest(changes.deletedRecords, args), 
            req += args.cSet + "--\n", req += "--" + initialGuid + "--", {
                type: "POST",
                url: url,
                dataType: "json",
                contentType: "multipart/mixed; charset=UTF-8;boundary=" + initialGuid,
                data: req
            };
        }, ODataAdaptor.prototype.generateDeleteRequest = function(arr, e) {
            if (!arr) return "";
            return this.generateBodyContent(arr, e, {
                method: "DELETE ",
                url: function(data, i, key) {
                    return "(" + data[i][key] + ")";
                },
                data: function(data, i) {
                    return "";
                }
            }) + "\n";
        }, ODataAdaptor.prototype.generateInsertRequest = function(arr, e) {
            if (!arr) return "";
            var stat = {
                method: "POST ",
                url: function(data, i, key) {
                    return "";
                },
                data: function(data, i) {
                    return JSON.stringify(data[i]) + "\n\n";
                }
            };
            return this.generateBodyContent(arr, e, stat);
        }, ODataAdaptor.prototype.generateUpdateRequest = function(arr, e) {
            if (!arr) return "";
            var stat = {
                method: "PUT ",
                url: function(data, i, key) {
                    return "(" + data[i][key] + ")";
                },
                data: function(data, i) {
                    return JSON.stringify(data[i]) + "\n\n";
                }
            };
            return this.generateBodyContent(arr, e, stat);
        }, ODataAdaptor.getField = function(prop) {
            return prop.replace(/\./g, "/");
        }, ODataAdaptor.prototype.generateBodyContent = function(arr, e, stat) {
            for (var req = "", i = 0; i < arr.length; i++) req += "\n" + e.cSet + "\n", req += this.options.changeSetContent + "\n\n", 
            req += stat.method, req += e.url + stat.url(arr, i, e.key) + " HTTP/1.1\n", req += "Accept: " + this.options.accept + "\n", 
            req += "Content-Id: " + this.pvt.changeSet++ + "\n", req += this.options.batchChangeSetContentType + "\n\n", 
            req += stat.data(arr, i);
            return req;
        }, ODataAdaptor.prototype.processBatchResponse = function(data, query, xhr, request, changes) {
            if (xhr && xhr.getResponseHeader("Content-Type") && -1 !== xhr.getResponseHeader("Content-Type").indexOf("xml")) return query.isCountRequired ? {
                result: [],
                count: 0
            } : [];
            if (request && this.options.batch && DataUtil.endsWith(request.url, this.options.batch) && "post" === request.type.toLowerCase()) {
                var guid = xhr.getResponseHeader("Content-Type"), cIdx = void 0, jsonObj = void 0, d = data + "";
                if (guid = guid.substring(guid.indexOf("=batchresponse") + 1), (d = d.split(guid)).length < 2) return {};
                d = d[1];
                var exVal = /(?:\bContent-Type.+boundary=)(changesetresponse.+)/i.exec(d);
                exVal && d.replace(exVal[0], "");
                for (var changeGuid = exVal ? exVal[1] : "", i = (d = d.split(changeGuid)).length; i > -1; i--) /\bContent-ID:/i.test(d[i]) && /\bHTTP.+201/.test(d[i]) && (cIdx = parseInt(/\bContent-ID: (\d+)/i.exec(d[i])[1], 10), 
                changes.addedRecords[cIdx] && (jsonObj = DataUtil.parse.parseJson(/^\{.+\}/m.exec(d[i])[0]), 
                extend({}, changes.addedRecords[cIdx], this.processResponse(jsonObj))));
                return changes;
            }
            return null;
        }, ODataAdaptor;
    }(UrlAdaptor), ODataV4Adaptor = function(_super) {
        function ODataV4Adaptor() {
            var _this = null !== _super && _super.apply(this, arguments) || this;
            return _this.options = extend({}, _this.options, {
                requestType: "get",
                accept: "application/json, text/javascript, */*; q=0.01",
                multipartAccept: "multipart/mixed",
                sortBy: "$orderby",
                select: "$select",
                skip: "$skip",
                take: "$top",
                count: "$count",
                search: "$search",
                where: "$filter",
                expand: "$expand",
                batch: "$batch",
                changeSet: "--changeset_",
                batchPre: "batch_",
                contentId: "Content-Id: ",
                batchContent: "Content-Type: multipart/mixed; boundary=",
                changeSetContent: "Content-Type: application/http\nContent-Transfer-Encoding: binary ",
                batchChangeSetContentType: "Content-Type: application/json; charset=utf-8 "
            }), _this;
        }
        return __extends$8(ODataV4Adaptor, _super), ODataV4Adaptor.prototype.getModulename = function() {
            return "ODataV4Adaptor";
        }, ODataV4Adaptor.prototype.onCount = function(e) {
            return !0 === e ? "true" : "";
        }, ODataV4Adaptor.prototype.onPredicate = function(predicate, query, requiresCast) {
            var returnValue = "", isDate = predicate.value instanceof Date;
            return returnValue = _super.prototype.onPredicate.call(this, predicate, query, requiresCast), 
            isDate && (returnValue = returnValue.replace(/datetime'(.*)'$/, "$1")), returnValue;
        }, ODataV4Adaptor.prototype.onEachSearch = function(e) {
            var search = this.pvt.searches || [];
            search.push(e.key), this.pvt.searches = search;
        }, ODataV4Adaptor.prototype.onSearch = function(e) {
            return this.pvt.searches.join(" OR ");
        }, ODataV4Adaptor.prototype.beforeSend = function(dm, request, settings) {
            request.setRequestHeader("Accept", this.options.accept);
        }, ODataV4Adaptor.prototype.processResponse = function(data, ds, query, xhr, request, changes) {
            var pvt = request && request.pvtData, emptyAndBatch = _super.prototype.processBatchResponse.call(this, data, query, xhr, request, changes);
            if (emptyAndBatch) return emptyAndBatch;
            var count = null;
            query && query.isCountRequired && "@odata.count" in data && (count = data["@odata.count"]), 
            data = data.value;
            var args = {};
            return args.count = count, args.result = data, this.getAggregateResult(pvt, data, args), 
            DataUtil.isNull(count) ? args.result : {
                result: args.result,
                count: count,
                aggregates: args.aggregates
            };
        }, ODataV4Adaptor;
    }(ODataAdaptor), WebApiAdaptor = function(_super) {
        function WebApiAdaptor() {
            return null !== _super && _super.apply(this, arguments) || this;
        }
        return __extends$8(WebApiAdaptor, _super), WebApiAdaptor.prototype.insert = function(dm, data, tableName) {
            return {
                type: "POST",
                url: dm.dataSource.url,
                data: JSON.stringify(data)
            };
        }, WebApiAdaptor.prototype.remove = function(dm, keyField, value, tableName) {
            return {
                type: "DELETE",
                url: dm.dataSource.url + "/" + value,
                data: JSON.stringify(value)
            };
        }, WebApiAdaptor.prototype.update = function(dm, keyField, value, tableName) {
            return {
                type: "PUT",
                url: dm.dataSource.url,
                data: JSON.stringify(value)
            };
        }, WebApiAdaptor.prototype.beforeSend = function(dm, request, settings) {
            request.setRequestHeader("Accept", "application/json, text/javascript, */*; q=0.01");
        }, WebApiAdaptor.prototype.processResponse = function(data, ds, query, xhr, request, changes) {
            var pvt = request && request.pvtData, count = null, args = {};
            if (request && "post" !== request.type.toLowerCase()) {
                var versionCheck = xhr && request.getResponseHeader("DataServiceVersion"), version = versionCheck && parseInt(versionCheck, 10) || 2;
                query && query.isCountRequired && (DataUtil.isNull(data.Count) || (count = data.Count)), 
                version < 3 && data.Items && (data = data.Items), args.count = count, args.result = data, 
                this.getAggregateResult(pvt, data, args);
            }
            return args.result = args.result || data, DataUtil.isNull(count) ? args.result : {
                result: args.result,
                count: args.count,
                aggregates: args.aggregates
            };
        }, WebApiAdaptor;
    }(ODataAdaptor), WebMethodAdaptor = function(_super) {
        function WebMethodAdaptor() {
            return null !== _super && _super.apply(this, arguments) || this;
        }
        return __extends$8(WebMethodAdaptor, _super), WebMethodAdaptor.prototype.processQuery = function(dm, query, hierarchyFilters) {
            var obj = new UrlAdaptor().processQuery(dm, query, hierarchyFilters), data = DataUtil.parse.parseJson(obj.data), result = {};
            if (data.param) for (var i = 0; i < data.param.length; i++) {
                var param = data.param[i], key = Object.keys(param)[0];
                result[key] = param[key];
            }
            result.value = data;
            return {
                data: JSON.stringify(result),
                url: obj.url,
                pvtData: obj.pvtData,
                type: "POST",
                contentType: "application/json; charset=utf-8"
            };
        }, WebMethodAdaptor;
    }(UrlAdaptor), RemoteSaveAdaptor = function(_super) {
        function RemoteSaveAdaptor() {
            var _this = _super.call(this) || this;
            return setValue("beforeSend", UrlAdaptor.prototype.beforeSend, _this), _this;
        }
        return __extends$8(RemoteSaveAdaptor, _super), RemoteSaveAdaptor.prototype.insert = function(dm, data, tableName) {
            return _super.prototype.insert.call(this, dm, data, null, null, 0), {
                url: dm.dataSource.insertUrl || dm.dataSource.crudUrl || dm.dataSource.url,
                data: JSON.stringify({
                    value: data,
                    table: tableName,
                    action: "insert"
                })
            };
        }, RemoteSaveAdaptor.prototype.remove = function(dm, keyField, value, tableName) {
            return _super.prototype.remove.call(this, dm, keyField, value), {
                type: "POST",
                url: dm.dataSource.removeUrl || dm.dataSource.crudUrl || dm.dataSource.url,
                data: JSON.stringify({
                    key: value,
                    keyColumn: keyField,
                    table: tableName,
                    action: "remove"
                })
            };
        }, RemoteSaveAdaptor.prototype.update = function(dm, keyField, value, tableName) {
            return _super.prototype.update.call(this, dm, keyField, value), {
                type: "POST",
                url: dm.dataSource.updateUrl || dm.dataSource.crudUrl || dm.dataSource.url,
                data: JSON.stringify({
                    value: value,
                    action: "update",
                    keyColumn: keyField,
                    key: value[keyField],
                    table: tableName
                })
            };
        }, RemoteSaveAdaptor.prototype.batchRequest = function(dm, changes, e) {
            var i;
            for (i = 0; i < changes.addedRecords.length; i++) JsonAdaptor.prototype.insert(dm, changes.addedRecords[i]);
            for (i = 0; i < changes.changedRecords.length; i++) JsonAdaptor.prototype.update(dm, e.key, changes.changedRecords[i]);
            for (i = 0; i < changes.deletedRecords.length; i++) JsonAdaptor.prototype.remove(dm, e.key, changes.deletedRecords[i]);
            return {
                type: "POST",
                url: dm.dataSource.batchUrl || dm.dataSource.crudUrl || dm.dataSource.url,
                contentType: "application/json; charset=utf-8",
                dataType: "json",
                data: JSON.stringify({
                    changed: changes.changedRecords,
                    added: changes.addedRecords,
                    deleted: changes.deletedRecords,
                    action: "batch",
                    table: e.url,
                    key: e.key
                })
            };
        }, RemoteSaveAdaptor;
    }(JsonAdaptor), CacheAdaptor = function(_super) {
        function CacheAdaptor(adaptor, timeStamp, pageSize) {
            var _this = _super.call(this) || this;
            _this.isCrudAction = !1, _this.isInsertAction = !1, isNullOrUndefined(adaptor) || (_this.cacheAdaptor = adaptor), 
            _this.pageSize = pageSize, _this.guidId = DataUtil.getGuid("cacheAdaptor");
            window.localStorage.setItem(_this.guidId, JSON.stringify({
                keys: [],
                results: []
            }));
            var guid = _this.guidId;
            return isNullOrUndefined(timeStamp) || setInterval(function() {
                var data;
                data = DataUtil.parse.parseJson(window.localStorage.getItem(guid));
                for (var forDel = [], i = 0; i < data.results.length; i++) {
                    var currentTime = +new Date(), requestTime = +new Date(data.results[i].timeStamp);
                    data.results[i].timeStamp = currentTime - requestTime, currentTime - requestTime > timeStamp && forDel.push(i);
                }
                for (i = 0; i < forDel.length; i++) data.results.splice(forDel[i], 1), data.keys.splice(forDel[i], 1);
                window.localStorage.removeItem(guid), window.localStorage.setItem(guid, JSON.stringify(data));
            }, timeStamp), _this;
        }
        return __extends$8(CacheAdaptor, _super), CacheAdaptor.prototype.generateKey = function(url, query) {
            var queries = this.getQueryRequest(query), singles = Query.filterQueryLists(query.queries, [ "onSelect", "onPage", "onSkip", "onTake", "onRange" ]), key = url;
            "onPage" in singles && (key += singles.onPage.pageIndex), queries.sorts.forEach(function(obj) {
                key += obj.e.direction + obj.e.fieldName;
            }), queries.groups.forEach(function(obj) {
                key += obj.e.fieldName;
            }), queries.searches.forEach(function(obj) {
                key += obj.e.searchKey;
            });
            for (var filter = 0; filter < queries.filters.length; filter++) {
                var currentFilter = queries.filters[filter];
                if (currentFilter.e.isComplex) {
                    var newQuery = query.clone();
                    newQuery.queries = [];
                    for (var i = 0; i < currentFilter.e.predicates.length; i++) newQuery.queries.push({
                        fn: "onWhere",
                        e: currentFilter.e.predicates[i],
                        filter: query.queries.filter
                    });
                    key += currentFilter.e.condition + this.generateKey(url, newQuery);
                } else key += currentFilter.e.field + currentFilter.e.operator + currentFilter.e.value;
            }
            return key;
        }, CacheAdaptor.prototype.processQuery = function(dm, query, hierarchyFilters) {
            var cachedItems, key = this.generateKey(dm.dataSource.url, query), data = (cachedItems = DataUtil.parse.parseJson(window.localStorage.getItem(this.guidId))) ? cachedItems.results[cachedItems.keys.indexOf(key)] : null;
            return null == data || this.isCrudAction || this.isInsertAction ? (this.isCrudAction = null, 
            this.isInsertAction = null, this.cacheAdaptor.processQuery.apply(this.cacheAdaptor, [].slice.call(arguments, 0))) : data;
        }, CacheAdaptor.prototype.processResponse = function(data, ds, query, xhr, request, changes) {
            if (this.isInsertAction || request && this.cacheAdaptor.options.batch && DataUtil.endsWith(request.url, this.cacheAdaptor.options.batch) && "post" === request.type.toLowerCase()) return this.cacheAdaptor.processResponse(data, ds, query, xhr, request, changes);
            data = this.cacheAdaptor.processResponse.apply(this.cacheAdaptor, [].slice.call(arguments, 0));
            var key = query ? this.generateKey(ds.dataSource.url, query) : ds.dataSource.url, obj = {}, index = (obj = DataUtil.parse.parseJson(window.localStorage.getItem(this.guidId))).keys.indexOf(key);
            for (-1 !== index && (obj.results.splice(index, 1), obj.keys.splice(index, 1)), 
            obj.results[obj.keys.push(key) - 1] = {
                keys: key,
                result: data.result,
                timeStamp: new Date(),
                count: data.count
            }; obj.results.length > this.pageSize; ) obj.results.splice(0, 1), obj.keys.splice(0, 1);
            return window.localStorage.setItem(this.guidId, JSON.stringify(obj)), data;
        }, CacheAdaptor.prototype.beforeSend = function(dm, request, settings) {
            DataUtil.endsWith(settings.url, this.cacheAdaptor.options.batch) && "post" === settings.type.toLowerCase() && request.setRequestHeader("Accept", this.cacheAdaptor.options.multipartAccept), 
            dm.dataSource.crossDomain || request.setRequestHeader("Accept", this.cacheAdaptor.options.accept);
        }, CacheAdaptor.prototype.update = function(dm, keyField, value, tableName) {
            return this.isCrudAction = !0, this.cacheAdaptor.update(dm, keyField, value, tableName);
        }, CacheAdaptor.prototype.insert = function(dm, data, tableName) {
            return this.isInsertAction = !0, this.cacheAdaptor.insert(dm, data, tableName);
        }, CacheAdaptor.prototype.remove = function(dm, keyField, value, tableName) {
            return this.isCrudAction = !0, this.cacheAdaptor.remove(dm, keyField, value, tableName);
        }, CacheAdaptor.prototype.batchRequest = function(dm, changes, e) {
            return this.cacheAdaptor.batchRequest(dm, changes, e);
        }, CacheAdaptor;
    }(UrlAdaptor), DataManager = function() {
        function DataManager(dataSource, query, adaptor) {
            var _this = this;
            this.dateParse = !0, this.requests = [], dataSource || this.dataSource || (dataSource = []), 
            adaptor = adaptor || dataSource.adaptor;
            var data;
            return dataSource instanceof Array ? data = {
                json: dataSource,
                offline: !0
            } : "object" == typeof dataSource ? (dataSource.json || (dataSource.json = []), 
            data = {
                url: dataSource.url,
                insertUrl: dataSource.insertUrl,
                removeUrl: dataSource.removeUrl,
                updateUrl: dataSource.updateUrl,
                crudUrl: dataSource.crudUrl,
                batchUrl: dataSource.batchUrl,
                json: dataSource.json,
                headers: dataSource.headers,
                accept: dataSource.accept,
                data: dataSource.data,
                timeTillExpiration: dataSource.timeTillExpiration,
                cachingPageSize: dataSource.cachingPageSize,
                enableCaching: dataSource.enableCaching,
                requestType: dataSource.requestType,
                key: dataSource.key,
                crossDomain: dataSource.crossDomain,
                jsonp: dataSource.jsonp,
                dataType: dataSource.dataType,
                offline: void 0 !== dataSource.offline ? dataSource.offline : !(dataSource.adaptor instanceof RemoteSaveAdaptor) && !dataSource.url,
                requiresFormat: dataSource.requiresFormat
            }) : DataUtil.throwError("DataManager: Invalid arguments"), void 0 !== data.requiresFormat || DataUtil.isCors() || (data.requiresFormat = !!isNullOrUndefined(data.crossDomain) || data.crossDomain), 
            void 0 === data.dataType && (data.dataType = "json"), this.dataSource = data, this.defaultQuery = query, 
            data.url && data.offline && !data.json.length ? (this.isDataAvailable = !1, this.adaptor = adaptor || new ODataAdaptor(), 
            this.dataSource.offline = !1, this.ready = this.executeQuery(query || new Query()), 
            this.ready.then(function(e) {
                _this.dataSource.offline = !0, _this.isDataAvailable = !0, data.json = e.result, 
                _this.adaptor = new JsonAdaptor();
            })) : this.adaptor = data.offline ? new JsonAdaptor() : new ODataAdaptor(), !data.jsonp && this.adaptor instanceof ODataAdaptor && (data.jsonp = "callback"), 
            this.adaptor = adaptor || this.adaptor, data.enableCaching && (this.adaptor = new CacheAdaptor(this.adaptor, data.timeTillExpiration, data.cachingPageSize)), 
            this;
        }
        return DataManager.prototype.setDefaultQuery = function(query) {
            return this.defaultQuery = query, this;
        }, DataManager.prototype.executeLocal = function(query) {
            this.defaultQuery || query instanceof Query || DataUtil.throwError("DataManager - executeLocal() : A query is required to execute"), 
            this.dataSource.json || DataUtil.throwError("DataManager - executeLocal() : Json data is required to execute"), 
            query = query || this.defaultQuery;
            var result = this.adaptor.processQuery(this, query);
            if (query.subQuery) {
                var from = query.subQuery.fromTable, lookup = query.subQuery.lookups, res = query.isCountRequired ? result.result : result;
                lookup && lookup instanceof Array && DataUtil.buildHierarchy(query.subQuery.fKey, from, res, lookup, query.subQuery.key);
                for (var j = 0; j < res.length; j++) res[j][from] instanceof Array && (res[j] = extend({}, {}, res[j]), 
                res[j][from] = this.adaptor.processResponse(query.subQuery.using(new DataManager(res[j][from].slice(0))).executeLocal(), this, query));
            }
            return this.adaptor.processResponse(result, this, query);
        }, DataManager.prototype.executeQuery = function(query, done, fail, always) {
            var _this = this;
            "function" == typeof query && (fail, fail = done, done = query, query = null), query || (query = this.defaultQuery), 
            query instanceof Query || DataUtil.throwError("DataManager - executeQuery() : A query is required to execute");
            var deffered = new Deferred(), args = {
                query: query
            };
            if (this.dataSource.offline || void 0 === this.dataSource.url) DataManager.nextTick(function() {
                var res = _this.executeLocal(query);
                args = DataManager.getDeferedArgs(query, res, args), deffered.resolve(args);
            }); else {
                var result = this.adaptor.processQuery(this, query);
                this.makeRequest(result, deffered, args, query);
            }
            return deffered.promise;
        }, DataManager.getDeferedArgs = function(query, result, args) {
            return query.isCountRequired ? (args.result = result.result, args.count = result.count, 
            args.aggregates = result.aggregates) : args.result = result, args;
        }, DataManager.nextTick = function(fn) {
            (window.setImmediate || window.setTimeout)(fn, 0);
        }, DataManager.prototype.extendRequest = function(url, fnSuccess, fnFail) {
            return extend({}, {
                type: "GET",
                dataType: this.dataSource.dataType,
                crossDomain: this.dataSource.crossDomain,
                jsonp: this.dataSource.jsonp,
                cache: !0,
                processData: !1,
                onSuccess: fnSuccess,
                onFailure: fnFail
            }, url);
        }, DataManager.prototype.makeRequest = function(url, deffered, args, query) {
            var _this = this, isSelector = !!query.subQuerySelector, fnFail = function(e) {
                args.error = e, deffered.reject(args);
            }, process = function(data, count, xhr, request, actual, aggregates, virtualSelectRecords) {
                args.xhr = xhr, args.count = count ? parseInt(count.toString(), 10) : 0, args.result = data, 
                args.request = request, args.aggregates = aggregates, args.actual = actual, args.virtualSelectRecords = virtualSelectRecords, 
                deffered.resolve(args);
            }, fnQueryChild = function(data, selector) {
                var subDeffer = new Deferred(), childArgs = {
                    parent: args
                };
                query.subQuery.isChild = !0;
                var subUrl = _this.adaptor.processQuery(_this, query.subQuery, data ? _this.adaptor.processResponse(data) : selector), childReq = _this.makeRequest(subUrl, subDeffer, childArgs, query.subQuery);
                return isSelector || subDeffer.then(function(subData) {
                    data && (DataUtil.buildHierarchy(query.subQuery.fKey, query.subQuery.fromTable, data, subData, query.subQuery.key), 
                    process(data, subData.count, subData.xhr));
                }, fnFail), childReq;
            }, req = this.extendRequest(url, function(data, request) {
                -1 === request.httpRequest.getResponseHeader("Content-Type").indexOf("xml") && _this.dateParse && (data = DataUtil.parse.parseJson(data));
                var result = _this.adaptor.processResponse(data, _this, query, request.httpRequest, request), count = 0, aggregates = null, virtualRecords = data.virtualSelectRecords;
                query.isCountRequired && (count = result.count, aggregates = result.aggregates, 
                result = result.result), query.subQuery ? isSelector || fnQueryChild(result, request) : process(result, count, request.httpRequest, request.type, data, aggregates, virtualRecords);
            }, fnFail), ajax = new Ajax(req);
            if (ajax.beforeSend = function() {
                _this.beforeSend(ajax.httpRequest, ajax);
            }, (req = ajax.send()).catch(function(e) {
                return !0;
            }), this.requests.push(ajax), isSelector) {
                var res = query.subQuerySelector.call(this, {
                    query: query.subQuery,
                    parent: query
                });
                res && res.length ? Promise.all([ req, fnQueryChild(null, res) ]).then(function() {
                    for (var args = [], _i = 0; _i < arguments.length; _i++) args[_i] = arguments[_i];
                    var result = args[0], pResult = _this.adaptor.processResponse(result[0], _this, query, _this.requests[0].httpRequest, _this.requests[0]), count = 0;
                    query.isCountRequired && (count = pResult.count, pResult = pResult.result);
                    var cResult = _this.adaptor.processResponse(result[1], _this, query.subQuery, _this.requests[1].httpRequest, _this.requests[1]);
                    count = 0, query.subQuery.isCountRequired && (count = cResult.count, cResult = cResult.result), 
                    DataUtil.buildHierarchy(query.subQuery.fKey, query.subQuery.fromTable, pResult, cResult, query.subQuery.key), 
                    isSelector = !1, process(pResult, count, _this.requests[0].httpRequest);
                }) : isSelector = !1;
            }
            return req;
        }, DataManager.prototype.beforeSend = function(request, settings) {
            this.adaptor.beforeSend(this, request, settings);
            for (var props, headers = this.dataSource.headers, i = 0; headers && i < headers.length; i++) {
                props = [];
                for (var _i = 0, keys_1 = Object.keys(headers[i]); _i < keys_1.length; _i++) {
                    var prop = keys_1[_i];
                    props.push(prop), request.setRequestHeader(prop, headers[i][prop]);
                }
            }
        }, DataManager.prototype.saveChanges = function(changes, key, tableName, query) {
            var _this = this;
            tableName instanceof Query && (query = tableName, tableName = null);
            var args = {
                url: tableName,
                key: key || this.dataSource.key
            }, req = this.adaptor.batchRequest(this, changes, args, query);
            if (this.dataSource.offline) return req;
            var deff = new Deferred(), ajax = new Ajax(req);
            return ajax.beforeSend = function() {
                _this.beforeSend(ajax.httpRequest, ajax);
            }, ajax.onSuccess = function(data, request) {
                deff.resolve(_this.adaptor.processResponse(DataUtil.parse.parseJson(data), _this, null, request.httpRequest, request, changes));
            }, ajax.onFailure = function(e) {
                deff.reject([ {
                    error: e
                } ]);
            }, ajax.send().catch(function(e) {
                return !0;
            }), deff.promise;
        }, DataManager.prototype.insert = function(data, tableName, query, position) {
            tableName instanceof Query && (query = tableName, tableName = null);
            var req = this.adaptor.insert(this, data, tableName, query, position);
            return this.dataSource.offline ? req : this.doAjaxRequest(req);
        }, DataManager.prototype.remove = function(keyField, value, tableName, query) {
            "object" == typeof value && (value = value[keyField]), tableName instanceof Query && (query = tableName, 
            tableName = null);
            var res = this.adaptor.remove(this, keyField, value, tableName, query);
            return this.dataSource.offline ? res : this.doAjaxRequest(res);
        }, DataManager.prototype.update = function(keyField, value, tableName, query) {
            tableName instanceof Query && (query = tableName, tableName = null);
            var res = this.adaptor.update(this, keyField, value, tableName, query);
            return this.dataSource.offline ? res : this.doAjaxRequest(res);
        }, DataManager.prototype.doAjaxRequest = function(res) {
            var _this = this, defer = new Deferred();
            res = extend({}, {
                type: "POST",
                contentType: "application/json; charset=utf-8",
                processData: !1
            }, res);
            var ajax = new Ajax(res);
            return ajax.beforeSend = function() {
                _this.beforeSend(ajax.httpRequest, ajax);
            }, ajax.onSuccess = function(record, request) {
                try {
                    DataUtil.parse.parseJson(record);
                } catch (e) {
                    record = [];
                }
                record = _this.adaptor.processResponse(DataUtil.parse.parseJson(record), _this, null, request.httpRequest, request), 
                defer.resolve(record);
            }, ajax.onFailure = function(e) {
                defer.reject([ {
                    error: e
                } ]);
            }, ajax.send().catch(function(e) {
                return !0;
            }), defer.promise;
        }, DataManager;
    }(), Deferred = function() {
        return function() {
            var _this = this;
            this.promise = new Promise(function(resolve, reject) {
                _this.resolve = resolve, _this.reject = reject;
            }), this.then = this.promise.then.bind(this.promise), this.catch = this.promise.catch.bind(this.promise);
        };
    }(), _data = Object.freeze({
        DataManager: DataManager,
        Deferred: Deferred,
        Query: Query,
        Predicate: Predicate,
        Adaptor: Adaptor,
        JsonAdaptor: JsonAdaptor,
        UrlAdaptor: UrlAdaptor,
        ODataAdaptor: ODataAdaptor,
        ODataV4Adaptor: ODataV4Adaptor,
        WebApiAdaptor: WebApiAdaptor,
        WebMethodAdaptor: WebMethodAdaptor,
        RemoteSaveAdaptor: RemoteSaveAdaptor,
        CacheAdaptor: CacheAdaptor,
        DataUtil: DataUtil
    }), cssClass = {
        li: "e-list-item",
        ul: "e-list-parent e-ul",
        group: "e-list-group-item",
        icon: "e-list-icon",
        text: "e-list-text",
        check: "e-list-check",
        checked: "e-checked",
        selected: "e-selected",
        expanded: "e-expanded",
        textContent: "e-text-content",
        hasChild: "e-has-child",
        level: "e-level",
        url: "e-list-url",
        collapsible: "e-icon-collapsible",
        disabled: "e-disabled",
        image: "e-list-img",
        iconWrapper: "e-icon-wrapper"
    };
    !function(ListBase) {
        function createListFromArray(dataSource, isSingleLevel, options) {
            return generateUL(createListItemFromArray(dataSource, isSingleLevel, options), null, options);
        }
        function createListItemFromArray(dataSource, isSingleLevel, options) {
            var subChild = [], curOpt = extend({}, defaultListBaseOptions, options);
            cssClass = getModuleClass(curOpt.moduleName);
            for (var id = genUID(), i = 0; i < dataSource.length; i++) if (!isNullOrUndefined(dataSource[i])) {
                var li = void 0;
                if (curOpt.itemCreating && "function" == typeof curOpt.itemCreating) {
                    var curData = {
                        dataSource: dataSource,
                        curData: dataSource[i],
                        text: dataSource[i],
                        options: curOpt
                    };
                    curOpt.itemCreating(curData);
                }
                if (li = isSingleLevel ? generateSingleLevelLI(dataSource[i], null, null, [], null, id, i, options) : generateLI(dataSource[i], null, null, options), 
                curOpt.itemCreated && "function" == typeof curOpt.itemCreated) {
                    curData = {
                        dataSource: dataSource,
                        curData: dataSource[i],
                        text: dataSource[i],
                        item: li,
                        options: curOpt
                    };
                    curOpt.itemCreated(curData);
                }
                subChild.push(li);
            }
            return subChild;
        }
        function createListItemFromJson(dataSource, options, level, isSingleLevel) {
            var curOpt = extend({}, defaultListBaseOptions, options);
            cssClass = getModuleClass(curOpt.moduleName);
            var id, fields = extend({}, ListBase.defaultMappedFields, curOpt.fields), ariaAttributes = extend({}, defaultAriaAttributes, curOpt.ariaAttributes);
            level && (ariaAttributes.level = level);
            var li, child = [];
            Object.keys(dataSource).length && !typeofData(dataSource).item.hasOwnProperty(fields.id) && (id = genUID());
            for (var i = 0; i < dataSource.length; i++) {
                var fieldData = getFieldValues(dataSource[i], fields);
                if (!isNullOrUndefined(dataSource[i])) {
                    if (curOpt.itemCreating && "function" == typeof curOpt.itemCreating) {
                        var curData = {
                            dataSource: dataSource,
                            curData: dataSource[i],
                            text: fieldData[fields.text],
                            options: curOpt,
                            fields: fields
                        };
                        curOpt.itemCreating(curData);
                    }
                    var curItem = dataSource[i];
                    curOpt.itemCreating && "function" == typeof curOpt.itemCreating && (fieldData = getFieldValues(dataSource[i], fields)), 
                    Object.keys(dataSource).length && fieldData.hasOwnProperty(fields.id) && !isNullOrUndefined(fieldData[fields.id]) && (id = fieldData.id);
                    var innerEle = [];
                    if (curOpt.showCheckBox && innerEle.push(createElement("input", {
                        className: cssClass.check,
                        attrs: {
                            type: "checkbox"
                        }
                    })), !0 === isSingleLevel) curOpt.showIcon && fieldData.hasOwnProperty(fields.iconCss) && (isNullOrUndefined(fieldData[fields.iconCss]) || innerEle.push(createElement("span", {
                        className: cssClass.icon + " " + fieldData[fields.iconCss]
                    }))), li = generateSingleLevelLI(curItem, fields, curOpt.itemClass, innerEle, !(!curItem.hasOwnProperty("isHeader") || !curItem.isHeader), id, i, options); else {
                        if ((li = generateLI(curItem, fields, curOpt.itemClass, options)).classList.add(cssClass.level + "-" + ariaAttributes.level), 
                        li.setAttribute("aria-level", ariaAttributes.level.toString()), fieldData.hasOwnProperty(fields.tooltip) && li.setAttribute("title", fieldData[fields.tooltip]), 
                        fieldData.hasOwnProperty(fields.htmlAttributes) && fieldData[fields.htmlAttributes] && setAttribute(li, fieldData[fields.htmlAttributes]), 
                        fieldData.hasOwnProperty(fields.enabled) && !1 === fieldData[fields.enabled] && li.classList.add(cssClass.disabled), 
                        fieldData.hasOwnProperty(fields.isVisible) && !1 === fieldData[fields.isVisible] && (li.style.display = "none"), 
                        fieldData.hasOwnProperty(fields.imageUrl) && !isNullOrUndefined(fieldData[fields.imageUrl])) {
                            var attr = {
                                src: fieldData[fields.imageUrl]
                            };
                            fieldData.hasOwnProperty(fields.imageUrl) && merge(attr, fieldData[fields.imageAttributes]), 
                            prepend([ createElement("img", {
                                className: cssClass.image,
                                attrs: attr
                            }) ], li.firstElementChild);
                        }
                        curOpt.showIcon && fieldData.hasOwnProperty(fields.iconCss) && !curOpt.template && (isNullOrUndefined(fieldData[fields.iconCss]) || prepend([ createElement("div", {
                            className: cssClass.icon + " " + fieldData[fields.iconCss]
                        }) ], li.firstElementChild)), innerEle.length && prepend(innerEle, li.firstElementChild), 
                        function(curItem, fields, ds, options, element, level) {
                            var fieldData = getFieldValues(curItem, fields), subDS = fieldData[fields.child] || [], hasChildren = fieldData[fields.hasChildren];
                            if (subDS.length && (hasChildren = !0, element.classList.add(cssClass.hasChild), 
                            options.processSubChild)) {
                                var subLi = createListFromJson(subDS, options, ++level);
                                element.appendChild(subLi);
                            }
                            if (options.expandCollapse && hasChildren && !options.template) {
                                element.firstElementChild.classList.contains(cssClass.textContent) && element.firstElementChild.classList.add(cssClass.iconWrapper);
                                var expandElement = "Left" === options.expandIconPosition ? prepend : append;
                                expandElement([ createElement("div", {
                                    className: "e-icons " + options.expandIconClass
                                }) ], element.querySelector("." + cssClass.textContent));
                            }
                        }(curItem, fields, 0, curOpt, li, ariaAttributes.level);
                    }
                    if (curOpt.itemCreated && "function" == typeof curOpt.itemCreated) {
                        curData = {
                            dataSource: dataSource,
                            curData: dataSource[i],
                            text: fieldData[fields.text],
                            item: li,
                            options: curOpt,
                            fields: fields
                        };
                        curOpt.itemCreated(curData);
                    }
                    child.push(li);
                }
            }
            return child;
        }
        function createListFromJson(dataSource, options, level, isSingleLevel) {
            var curOpt = extend({}, defaultListBaseOptions, options);
            return generateUL(createListItemFromJson(dataSource, options, level, isSingleLevel), curOpt.listClass, options);
        }
        function indexOf(item, elementArray) {
            if (elementArray && item) {
                return Array.prototype.slice.call(elementArray).indexOf(item);
            }
        }
        function addSorting(sortOrder, sortBy, query) {
            return void 0 === query && (query = new Query()), "Ascending" === sortOrder ? query.sortBy(sortBy, "ascending", !0) : "Descending" === sortOrder && query.sortBy(sortBy, "descending", !0), 
            query;
        }
        function getDataSource(dataSource, query) {
            return new DataManager(dataSource).executeLocal(query);
        }
        function createJsonFromElement(element, options) {
            var curOpt = extend({}, defaultListBaseOptions, options), fields = extend({}, ListBase.defaultMappedFields, curOpt.fields), curEle = element.cloneNode(!0), jsonAr = [];
            curEle.classList.add("json-parent");
            var childs = curEle.querySelectorAll(".json-parent>li");
            curEle.classList.remove("json-parent");
            for (var i = 0; i < childs.length; i++) {
                for (var li = childs[i], anchor = li.querySelector("a"), ul = li.querySelector("ul"), json = {}, childNodes = anchor ? anchor.childNodes : li.childNodes, keys = Object.keys(childNodes), i_1 = 0; i_1 < childNodes.length; i_1++) childNodes[Number(keys[i_1])].hasChildNodes() || (json[fields.text] = childNodes[Number(keys[i_1])].textContent);
                json[fields.id] = genUID();
                var attributes_1 = getAllAttributes(li);
                Object.keys(attributes_1).length && (json[fields.htmlAttributes] = attributes_1), 
                anchor && (attributes_1 = getAllAttributes(anchor), Object.keys(attributes_1).length && (json[fields.urlAttributes] = attributes_1)), 
                ul && (json[fields.child] = createJsonFromElement(ul, options)), jsonAr.push(json);
            }
            return jsonAr;
        }
        function typeofData(data) {
            for (var match = {
                typeof: null,
                item: null
            }, i = 0; i < data.length; i++) if (!isNullOrUndefined(data[i])) return match = {
                typeof: typeof data[i],
                item: data[i]
            };
            return match;
        }
        function setAttribute(element, elementAttributes) {
            var attr = {};
            merge(attr, elementAttributes), attr.class && (addClass([ element ], attr.class.split(" ")), 
            delete attr.class), attributes(element, attr);
        }
        function getAllAttributes(element) {
            for (var attributes$$1 = {}, attr = element.attributes, index = 0; index < attr.length; index++) attributes$$1[attr[index].nodeName] = attr[index].nodeValue;
            return attributes$$1;
        }
        function genUID() {
            return Math.floor(65536 * (1 + Math.random())).toString(16).substring(1);
        }
        function generateSingleLevelLI(item, fields, className, innerElements, grpLI, id, index, options) {
            var dataSource, curOpt = extend({}, defaultListBaseOptions, options), ariaAttributes = extend({}, defaultAriaAttributes, curOpt.ariaAttributes), text = item, value = item, fieldData = getFieldValues(item, fields);
            "string" != typeof item && "number" != typeof item && (dataSource = item, text = "boolean" == typeof fieldData[fields.text] || "number" == typeof fieldData[fields.text] ? fieldData[fields.text] : fieldData[fields.text] || "", 
            value = fieldData[fields.value]);
            var elementID;
            elementID = isNullOrUndefined(dataSource) || isNullOrUndefined(fieldData[fields.id]) || "" === fieldData[fields.id] ? id + "-" + index : id;
            var li = createElement("li", {
                className: (!0 === grpLI ? cssClass.group : cssClass.li) + " " + (isNullOrUndefined(className) ? "" : className),
                id: elementID,
                attrs: "" !== ariaAttributes.groupItemRole && "" !== ariaAttributes.itemRole ? {
                    role: !0 === grpLI ? ariaAttributes.groupItemRole : ariaAttributes.itemRole
                } : {}
            });
            return dataSource && fieldData.hasOwnProperty(fields.enabled) && "false" === fieldData[fields.enabled].toString() && li.classList.add(cssClass.disabled), 
            grpLI ? li.innerText = text : (isNullOrUndefined(value) || li.setAttribute("data-value", value), 
            li.setAttribute("role", "option"), dataSource && fieldData.hasOwnProperty(fields.htmlAttributes) && fieldData[fields.htmlAttributes] && setAttribute(li, fieldData[fields.htmlAttributes]), 
            innerElements.length && append(innerElements, li), dataSource && fieldData.hasOwnProperty(fields.url) && fieldData[fields.url] ? li.appendChild(anchorTag(dataSource, fields, text)) : li.appendChild(document.createTextNode(text))), 
            li;
        }
        function getModuleClass(moduleName) {
            return {
                li: "e-" + moduleName + "-item",
                ul: "e-" + moduleName + "-parent e-ul",
                group: "e-" + moduleName + "-group-item",
                icon: "e-" + moduleName + "-icon",
                text: "e-" + moduleName + "-text",
                check: "e-" + moduleName + "-check",
                checked: "e-checked",
                selected: "e-selected",
                expanded: "e-expanded",
                textContent: "e-text-content",
                hasChild: "e-has-child",
                level: "e-level",
                url: "e-" + moduleName + "-url",
                collapsible: "e-icon-collapsible",
                disabled: "e-disabled",
                image: "e-" + moduleName + "-img",
                iconWrapper: "e-icon-wrapper"
            };
        }
        function anchorTag(dataSource, fields, text) {
            var fieldData = getFieldValues(dataSource, fields), attr = {
                href: fieldData[fields.url]
            };
            fieldData.hasOwnProperty(fields.urlAttributes) && fieldData[fields.urlAttributes] && merge(attr, fieldData[fields.urlAttributes]);
            var anchorTag = createElement("a", {
                className: cssClass.text + " " + cssClass.url,
                innerHTML: text
            });
            return setAttribute(anchorTag, attr), anchorTag;
        }
        function generateLI(item, fields, className, options) {
            var uID, grpLI, dataSource, fieldData, curOpt = extend({}, defaultListBaseOptions, options), ariaAttributes = extend({}, defaultAriaAttributes, curOpt.ariaAttributes), text = item;
            "string" != typeof item && (dataSource = item, text = (fieldData = getFieldValues(item, fields))[fields.text] || "", 
            uID = fieldData[fields.id], grpLI = !(!item.hasOwnProperty("isHeader") || !item.isHeader));
            var li = createElement("li", {
                className: (!0 === grpLI ? cssClass.group : cssClass.li) + " " + (isNullOrUndefined(className) ? "" : className),
                attrs: "" !== ariaAttributes.groupItemRole && "" !== ariaAttributes.itemRole ? {
                    role: !0 === grpLI ? ariaAttributes.groupItemRole : ariaAttributes.itemRole
                } : {}
            });
            if (isNullOrUndefined(uID) ? li.setAttribute("data-uid", genUID()) : li.setAttribute("data-uid", uID), 
            grpLI && options && options.groupTemplate) {
                append(compile$$1(options.groupTemplate)(item), li);
            } else if (!grpLI && options && options.template) {
                append(compile$$1(options.template)(item), li);
            } else {
                var innerDiv = createElement("div", {
                    className: cssClass.textContent,
                    attrs: "" !== ariaAttributes.wrapperRole ? {
                        role: ariaAttributes.wrapperRole
                    } : {}
                });
                dataSource && fieldData.hasOwnProperty(fields.url) && fieldData[fields.url] ? innerDiv.appendChild(anchorTag(dataSource, fields, text)) : innerDiv.appendChild(createElement("span", {
                    className: cssClass.text,
                    innerHTML: text,
                    attrs: "" !== ariaAttributes.itemText ? {
                        role: ariaAttributes.itemText
                    } : {}
                })), li.appendChild(innerDiv);
            }
            return li;
        }
        function generateUL(liElement, className, options) {
            var curOpt = extend({}, defaultListBaseOptions, options), ariaAttributes = extend({}, defaultAriaAttributes, curOpt.ariaAttributes), ulElement = createElement("ul", {
                className: (cssClass = getModuleClass(curOpt.moduleName)).ul + " " + (isNullOrUndefined(className) ? "" : className),
                attrs: "" !== ariaAttributes.listRole ? {
                    role: ariaAttributes.listRole
                } : {}
            });
            return append(liElement, ulElement), ulElement;
        }
        ListBase.defaultMappedFields = {
            id: "id",
            text: "text",
            url: "url",
            value: "value",
            isChecked: "isChecked",
            enabled: "enabled",
            expanded: "expanded",
            selected: "selected",
            iconCss: "iconCss",
            child: "child",
            isVisible: "isVisible",
            hasChildren: "hasChildren",
            tooltip: "tooltip",
            htmlAttributes: "htmlAttributes",
            urlAttributes: "urlAttributes",
            imageAttributes: "imageAttributes",
            imageUrl: "imageUrl",
            groupBy: null
        };
        var defaultAriaAttributes = {
            level: 1,
            listRole: "presentation",
            itemRole: "presentation",
            groupItemRole: "group",
            itemText: "list-item",
            wrapperRole: "presentation"
        }, defaultListBaseOptions = {
            showCheckBox: !1,
            showIcon: !1,
            expandCollapse: !1,
            fields: ListBase.defaultMappedFields,
            ariaAttributes: defaultAriaAttributes,
            listClass: "",
            itemClass: "",
            processSubChild: !1,
            sortOrder: "None",
            template: null,
            groupTemplate: null,
            expandIconClass: "e-icon-collapsible",
            moduleName: "list",
            expandIconPosition: "Right"
        };
        ListBase.createList = function(dataSource, options, isSingleLevel) {
            var curOpt = extend({}, defaultListBaseOptions, options), ariaAttributes = extend({}, defaultAriaAttributes, curOpt.ariaAttributes), type = typeofData(dataSource).typeof;
            return "string" === type || "number" === type ? createListFromArray(dataSource, isSingleLevel, options) : createListFromJson(dataSource, options, ariaAttributes.level, isSingleLevel);
        }, ListBase.createListFromArray = createListFromArray, ListBase.createListItemFromArray = createListItemFromArray, 
        ListBase.createListItemFromJson = createListItemFromJson, ListBase.createListFromJson = createListFromJson, 
        ListBase.getSiblingLI = function(elementArray, element, isPrevious) {
            if (cssClass = getModuleClass(defaultListBaseOptions.moduleName), elementArray && elementArray.length) {
                var siblingLI, liIndex, liCollections = Array.prototype.slice.call(elementArray);
                for (siblingLI = liCollections[(liIndex = element ? indexOf(element, liCollections) : !0 === isPrevious ? liCollections.length : -1) + (!0 === isPrevious ? -1 : 1)]; siblingLI && (!isVisible(siblingLI) || siblingLI.classList.contains(cssClass.disabled)); ) siblingLI = liCollections[liIndex += !0 === isPrevious ? -1 : 1];
                return siblingLI;
            }
        }, ListBase.indexOf = indexOf, ListBase.groupDataSource = function(dataSource, fields, sortOrder) {
            void 0 === sortOrder && (sortOrder = "None");
            var cusQuery = new Query().group(fields.groupBy), ds = getDataSource(dataSource, cusQuery = addSorting(sortOrder, "key", cusQuery));
            dataSource = [];
            for (var j = 0; j < ds.length; j++) {
                var itemObj = ds[j].items, grpItem = {};
                grpItem[fields.text] = ds[j].key, grpItem.isHeader = !0, grpItem.items = itemObj, 
                dataSource.push(grpItem);
                for (var k = 0; k < itemObj.length; k++) dataSource.push(itemObj[k]);
            }
            return dataSource;
        }, ListBase.addSorting = addSorting, ListBase.getDataSource = getDataSource, ListBase.createJsonFromElement = createJsonFromElement, 
        ListBase.renderContentTemplate = function(template, dataSource, fields, options) {
            for (var ulElement = createElement("ul", {
                className: (cssClass = getModuleClass(defaultListBaseOptions.moduleName)).ul,
                attrs: {
                    role: "presentation"
                }
            }), curOpt = extend({}, defaultListBaseOptions, options), compiledString = compile$$1(template), liCollection = [], id = genUID(), i = 0; i < dataSource.length; i++) {
                var fieldData = getFieldValues(dataSource[i], fields), curItem = dataSource[i], isHeader = curItem.isHeader, value = "string" == typeof curItem || "number" == typeof curItem ? curItem : fieldData[fields.value];
                if (curOpt.itemCreating && "function" == typeof curOpt.itemCreating) {
                    var curData = {
                        dataSource: dataSource,
                        curData: curItem,
                        text: value,
                        options: curOpt,
                        fields: fields
                    };
                    curOpt.itemCreating(curData);
                }
                curOpt.itemCreating && "function" == typeof curOpt.itemCreating && (value = (fieldData = getFieldValues(dataSource[i], fields))[fields.value]);
                var li = createElement("li", {
                    id: id + "-" + i,
                    className: isHeader ? cssClass.group : cssClass.li,
                    attrs: {
                        role: "presentation"
                    }
                });
                isHeader ? li.innerText = fieldData[fields.text] : (append(compiledString(curItem), li), 
                li.setAttribute("data-value", value), li.setAttribute("role", "option")), curOpt.itemCreated && "function" == typeof curOpt.itemCreated && (curData = {
                    dataSource: dataSource,
                    curData: curItem,
                    text: value,
                    item: li,
                    options: curOpt,
                    fields: fields
                }, curOpt.itemCreated(curData)), liCollection.push(li);
            }
            return append(liCollection, ulElement), ulElement;
        }, ListBase.renderGroupTemplate = function(groupTemplate, groupDataSource, fields, headerItems) {
            for (var compiledString = compile$$1(groupTemplate), category = fields.groupBy, headerData = {}, _i = 0, headerItems_1 = headerItems; _i < headerItems_1.length; _i++) {
                var header = headerItems_1[_i];
                headerData[category] = header.textContent, header.innerHTML = "", append(compiledString(headerData), header);
            }
            return headerItems;
        }, ListBase.generateUL = generateUL, ListBase.generateIcon = function(liElement, className, options) {
            var curOpt = extend({}, defaultListBaseOptions, options);
            return extend({}, defaultAriaAttributes, curOpt.ariaAttributes), cssClass = getModuleClass(curOpt.moduleName), 
            ("Left" === curOpt.expandIconPosition ? prepend : append)([ createElement("div", {
                className: "e-icons " + curOpt.expandIconClass + " " + (isNullOrUndefined(className) ? "" : className)
            }) ], liElement.querySelector("." + cssClass.textContent)), liElement;
        };
    }(ListBase || (ListBase = {}));
    var __extends$9 = function() {
        var extendStatics = Object.setPrototypeOf || {
            __proto__: []
        } instanceof Array && function(d, b) {
            d.__proto__ = b;
        } || function(d, b) {
            for (var p in b) b.hasOwnProperty(p) && (d[p] = b[p]);
        };
        return function(d, b) {
            function __() {
                this.constructor = d;
            }
            extendStatics(d, b), d.prototype = null === b ? Object.create(b) : (__.prototype = b.prototype, 
            new __());
        };
    }(), __decorate$8 = function(decorators, target, key, desc) {
        var d, c = arguments.length, r = c < 3 ? target : null === desc ? desc = Object.getOwnPropertyDescriptor(target, key) : desc;
        if ("object" == typeof Reflect && "function" == typeof Reflect.decorate) r = Reflect.decorate(decorators, target, key, desc); else for (var i = decorators.length - 1; i >= 0; i--) (d = decorators[i]) && (r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r);
        return c > 3 && r && Object.defineProperty(target, key, r), r;
    }, effectsConfig = {
        None: [],
        SlideLeft: [ "SlideRightOut", "SlideLeftOut", "SlideLeftIn", "SlideRightIn" ],
        SlideDown: [ "SlideTopOut", "SlideBottomOut", "SlideBottomIn", "SlideTopIn" ],
        Zoom: [ "FadeOut", "FadeZoomOut", "FadeZoomIn", "FadeIn" ],
        Fade: [ "FadeOut", "FadeOut", "FadeIn", "FadeIn" ]
    }, effectsRTLConfig = {
        None: [],
        SlideLeft: [ "SlideLeftOut", "SlideRightOut", "SlideRightIn", "SlideLeftIn" ],
        SlideDown: [ "SlideBottomOut", "SlideTopOut", "SlideTopIn", "SlideBottomIn" ],
        Zoom: [ "FadeZoomOut", "FadeOut", "FadeIn", "FadeZoomIn" ],
        Fade: [ "FadeOut", "FadeOut", "FadeIn", "FadeIn" ]
    }, classNames$__root = "e-listview", classNames$__hover = "e-hover", classNames$__selected = "e-active", classNames$__focused = "e-focused", classNames$__parentItem = "e-list-parent", classNames$__listItem = "e-list-item", classNames$__grpListItem = "e-list-group-item", classNames$__hasChild = "e-has-child", classNames$__header = "e-list-header", classNames$__headerText = "e-headertext", classNames$__text = "e-text", classNames$__disable = "e-disabled", classNames$__content = "e-content", classNames$__icon = "e-icons", classNames$__backIcon = "e-icon-back", classNames$__checkboxWrapper = "e-checkbox-wrapper", classNames$__checkbox = "e-checkbox", classNames$__checked = "e-check", classNames$__checkboxIcon = "e-frame", classNames$__checkboxRight = "e-checkbox-right", classNames$__checkboxLeft = "e-checkbox-left", FieldSettings$1 = function(_super) {
        function FieldSettings() {
            return null !== _super && _super.apply(this, arguments) || this;
        }
        return __extends$9(FieldSettings, _super), __decorate$8([ Property("id") ], FieldSettings.prototype, "id", void 0), 
        __decorate$8([ Property("text") ], FieldSettings.prototype, "text", void 0), __decorate$8([ Property("isChecked") ], FieldSettings.prototype, "isChecked", void 0), 
        __decorate$8([ Property("isVisible") ], FieldSettings.prototype, "isVisible", void 0), 
        __decorate$8([ Property("enabled") ], FieldSettings.prototype, "enabled", void 0), 
        __decorate$8([ Property("iconCss") ], FieldSettings.prototype, "iconCss", void 0), 
        __decorate$8([ Property("child") ], FieldSettings.prototype, "child", void 0), __decorate$8([ Property("tooltip") ], FieldSettings.prototype, "tooltip", void 0), 
        __decorate$8([ Property("groupBy") ], FieldSettings.prototype, "groupBy", void 0), 
        __decorate$8([ Property("text") ], FieldSettings.prototype, "sortBy", void 0), __decorate$8([ Property("htmlAttributes") ], FieldSettings.prototype, "htmlAttributes", void 0), 
        __decorate$8([ Property("tableName") ], FieldSettings.prototype, "tableName", void 0), 
        FieldSettings;
    }(ChildProperty), ListView = function(_super) {
        function ListView(options, element) {
            var _this = _super.call(this, options, element) || this;
            return _this.curDSLevel = [], _this.curViewDS = [], _this.keyConfigs = {
                moveDown: "downarrow",
                moveUp: "uparrow",
                back: "backspace",
                home: "home",
                select: "enter",
                end: "end",
                tab: "tab",
                space: "space"
            }, _this.animateOptions = {}, _this.isNestedList = !1, _this.currentLiElements = [], 
            _this.resetList = !1, _this.selectedData = [], _this.selectedId = [], _this.aniObj = new Animation(_this.animateOptions), 
            _this;
        }
        return __extends$9(ListView, _super), ListView.prototype.onPropertyChanged = function(newProp, oldProp) {
            for (var _i = 0, _a = Object.keys(newProp); _i < _a.length; _i++) {
                switch (_a[_i]) {
                  case "htmlAttributes":
                    this.setHTMLAttribute();
                    break;

                  case "cssClass":
                    this.setCSSClass(oldProp.cssClass);
                    break;

                  case "enable":
                    this.setEnable();
                    break;

                  case "width":
                  case "height":
                    this.setSize();
                    break;

                  case "enableRtl":
                    this.setEnableRTL();
                    break;

                  case "fields":
                    this.listBaseOption.fields = this.fields.properties, this.reRender();
                    break;

                  case "headerTitle":
                    this.curDSLevel.length || this.header(this.headerTitle, !1);
                    break;

                  case "showHeader":
                    this.header(this.headerTitle, !1);
                    break;

                  case "showCheckBox":
                  case "checkBoxPosition":
                    this.setCheckbox();
                    break;

                  case "dataSource":
                    this.reRender();
                    break;

                  case "sortOrder":
                  case "showIcon":
                    this.listBaseOption.showIcon = this.showIcon, this.curViewDS = this.getSubDS(), 
                    this.resetCurrentList();
                }
            }
        }, ListView.prototype.setHTMLAttribute = function() {
            Object.keys(this.htmlAttributes).length && attributes(this.element, this.htmlAttributes);
        }, ListView.prototype.setCSSClass = function(oldCSSClass) {
            this.cssClass && addClass([ this.element ], this.cssClass.split(" ")), oldCSSClass && removeClass([ this.element ], oldCSSClass.split(" "));
        }, ListView.prototype.setSize = function() {
            this.element.style.height = formatUnit(this.height), this.element.style.width = formatUnit(this.width);
        }, ListView.prototype.setEnable = function() {
            this.enableElement(this.element, this.enable);
        }, ListView.prototype.setEnableRTL = function() {
            this.enableRtl ? this.element.classList.add("e-rtl") : this.element.classList.remove("e-rtl");
        }, ListView.prototype.enableElement = function(element, isEnabled) {
            isEnabled ? element.classList.remove(classNames$__disable) : element.classList.add(classNames$__disable);
        }, ListView.prototype.header = function(text, showBack) {
            if (void 0 === this.headerEle && this.showHeader) {
                this.headerEle = createElement("div", {
                    className: classNames$__header
                });
                var innerHeaderEle = createElement("span", {
                    className: classNames$__headerText,
                    innerHTML: this.headerTitle
                }), textEle = createElement("div", {
                    className: classNames$__text,
                    innerHTML: innerHeaderEle.outerHTML
                }), hedBackButton = createElement("div", {
                    className: classNames$__icon + " " + classNames$__backIcon + " e-but-back",
                    attrs: {
                        style: "display:none;"
                    }
                });
                this.headerEle.appendChild(hedBackButton), this.headerEle.appendChild(textEle), 
                this.element.classList.add("e-has-header"), prepend([ this.headerEle ], this.element);
            } else if (this.headerEle) if (this.showHeader) {
                this.headerEle.style.display = "";
                textEle = this.headerEle.querySelector("." + classNames$__headerText), hedBackButton = this.headerEle.querySelector("." + classNames$__backIcon);
                textEle.innerHTML = text, hedBackButton.style.display = !0 === showBack ? "" : "none";
            } else this.headerEle.style.display = "none";
        }, ListView.prototype.switchView = function(fromView, toView, reverse) {
            var _this = this;
            if (fromView && toView) {
                var fPos_1 = fromView.style.position, overflow_1 = "hidden" !== this.element.style.overflow ? this.element.style.overflow : "";
                fromView.style.position = "absolute", fromView.classList.add("e-view");
                var anim = void 0, duration = this.animation.duration;
                if (this.animation.effect) anim = this.enableRtl ? effectsRTLConfig[this.animation.effect] : effectsConfig[this.animation.effect]; else {
                    anim = effectsConfig.SlideLeft, reverse = this.enableRtl, duration = 0;
                }
                this.element.style.overflow = "hidden", this.aniObj.animate(fromView, {
                    name: !0 === reverse ? anim[0] : anim[1],
                    duration: duration,
                    timingFunction: this.animation.easing,
                    end: function(model) {
                        fromView.style.display = "none", _this.element.style.overflow = overflow_1, fromView.style.position = fPos_1, 
                        fromView.classList.remove("e-view");
                    }
                }), toView.style.display = "", this.aniObj.animate(toView, {
                    name: !0 === reverse ? anim[2] : anim[3],
                    duration: duration,
                    timingFunction: this.animation.easing,
                    end: function() {
                        _this.trigger("actionComplete");
                    }
                }), this.curUL = toView;
            }
        }, ListView.prototype.preRender = function() {
            this.listBaseOption = {
                template: this.template,
                groupTemplate: this.groupTemplate,
                expandCollapse: !0,
                listClass: "",
                ariaAttributes: {
                    itemRole: "listitem",
                    listRole: "list",
                    itemText: "",
                    groupItemRole: "group",
                    wrapperRole: "presentation"
                },
                fields: this.fields.properties,
                sortOrder: this.sortOrder,
                showIcon: this.showIcon,
                itemCreated: this.renderCheckbox.bind(this)
            };
        }, ListView.prototype.renderCheckbox = function(args) {
            if (this.showCheckBox && this.isValidLI(args.item) && !this.isNestedList) if (args.item.classList.contains(classNames$__hasChild)) this.checkboxRevert(); else {
                var checkboxElement = void 0, fieldData = void 0;
                (checkboxElement = createCheckBox(!1, {
                    checked: !1,
                    enableRtl: this.enableRtl
                })).setAttribute("role", "checkbox");
                var frameElement_1 = checkboxElement.querySelector("." + classNames$__checkboxIcon);
                args.item.classList.add("e-checklist"), args.item.firstElementChild.classList.add(classNames$__checkbox), 
                "string" != typeof this.dataSource[0] ? (fieldData = getFieldValues(args.curData, this.listBaseOption.fields), 
                !this.resetList && fieldData[this.listBaseOption.fields.isChecked] ? this.checkItem(args, checkboxElement) : -1 !== this.selectedData.indexOf(fieldData[this.listBaseOption.fields.text]) && -1 !== this.selectedId.indexOf(fieldData[this.listBaseOption.fields.id]) && this.checkItem(args, checkboxElement)) : "string" == typeof this.dataSource[0] && -1 !== this.selectedData.indexOf(args.text) && this.checkItem(args, checkboxElement), 
                checkboxElement.setAttribute("aria-checked", frameElement_1.classList.contains(classNames$__checked) ? "true" : "false"), 
                "Left" === this.checkBoxPosition ? (checkboxElement.classList.add(classNames$__checkboxLeft), 
                args.item.firstElementChild.insertBefore(checkboxElement, args.item.firstElementChild.childNodes[0])) : (checkboxElement.classList.add(classNames$__checkboxRight), 
                args.item.firstElementChild.appendChild(checkboxElement)), this.currentLiElements.push(args.item);
            }
        }, ListView.prototype.checkItem = function(args, checkboxElement) {
            args.item.classList.add(classNames$__selected), checkboxElement.querySelector("." + classNames$__checkboxIcon).classList.add(classNames$__checked), 
            checkboxElement.setAttribute("aria-checked", "true");
        }, ListView.prototype.checkboxRevert = function() {
            this.isNestedList = !0, this.setProperties({
                showCheckBox: !1
            }, !0);
            for (var i = 0; i < this.currentLiElements.length; i++) this.currentLiElements[i].querySelector("." + classNames$__checkboxWrapper) && (this.currentLiElements[i].firstElementChild.classList.remove(classNames$__checkbox), 
            this.removeElement(this.currentLiElements[i].firstElementChild.firstElementChild));
        }, ListView.prototype.setCheckbox = function() {
            var _this = this;
            if (this.showCheckBox && !this.curUL.querySelector("." + classNames$__hasChild)) {
                var args_1 = {
                    item: void 0,
                    curData: void 0,
                    dataSource: void 0,
                    fields: void 0,
                    options: void 0,
                    text: ""
                };
                this.liCollection.forEach(function(element) {
                    args_1.item = element, args_1.curData = _this.getItemData(element), element.querySelector("." + classNames$__checkboxWrapper) && _this.removeElement(element.querySelector("." + classNames$__checkboxWrapper)), 
                    _this.renderCheckbox(args_1);
                });
            } else this.liCollection.forEach(function(element) {
                element.firstElementChild.classList.remove(classNames$__checkbox), element.querySelector("." + classNames$__checkboxWrapper) && _this.removeElement(element.querySelector("." + classNames$__checkboxWrapper));
            });
        }, ListView.prototype.clickHandler = function(e) {
            var target = e.target, classList$$1 = target.classList;
            if (classList$$1.contains(classNames$__backIcon) || classList$$1.contains(classNames$__headerText)) this.back(); else {
                var li = closest(target.parentNode, "." + classNames$__listItem);
                null === li && (li = target), this.enable && this.showCheckBox && this.isValidLI(li) ? this.setCheckboxLI(li, e) : this.setSelectLI(li, e);
            }
        }, ListView.prototype.removeElement = function(element) {
            return element && element.parentNode && element.parentNode.removeChild(element);
        }, ListView.prototype.hoverHandler = function(e) {
            var curLi = closest(e.target.parentNode, "." + classNames$__listItem);
            this.setHoverLI(curLi);
        }, ListView.prototype.leaveHandler = function(e) {
            this.removeHover();
        }, ListView.prototype.homeKeyHandler = function(e, end) {
            var li = this.curUL.querySelectorAll("." + classNames$__listItem), focusedElement = this.curUL.querySelector("." + classNames$__focused) || this.curUL.querySelector("." + classNames$__selected);
            focusedElement && (focusedElement.classList.remove(classNames$__focused), this.showCheckBox || focusedElement.classList.remove(classNames$__selected));
            var index = end ? li.length - 1 : 0;
            li[index].classList.contains(classNames$__hasChild) || this.showCheckBox ? li[index].classList.add(classNames$__focused) : this.setSelectLI(li[index], e);
        }, ListView.prototype.arrowKeyHandler = function(e, prev) {
            var siblingLI, li;
            !isNullOrUndefined(this.curUL.querySelector("." + classNames$__hasChild)) || this.showCheckBox ? (li = this.curUL.querySelector("." + classNames$__focused) || this.curUL.querySelector("." + classNames$__selected), 
            isNullOrUndefined(siblingLI = ListBase.getSiblingLI(this.curUL.querySelectorAll("." + classNames$__listItem), li, prev)) || (li && (li.classList.remove(classNames$__focused), 
            this.showCheckBox || li.classList.remove(classNames$__selected)), siblingLI.classList.contains(classNames$__hasChild) || this.showCheckBox ? siblingLI.classList.add(classNames$__focused) : this.setSelectLI(siblingLI, e))) : (li = this.curUL.querySelector("." + classNames$__selected), 
            siblingLI = ListBase.getSiblingLI(this.curUL.querySelectorAll("." + classNames$__listItem), li, prev), 
            this.setSelectLI(siblingLI, e));
        }, ListView.prototype.enterKeyHandler = function(e) {
            var hasChild = !isNullOrUndefined(this.curUL.querySelector("." + classNames$__hasChild)), li = this.curUL.querySelector("." + classNames$__focused);
            hasChild && li && (li.classList.remove(classNames$__focused), this.setSelectLI(li, e));
        }, ListView.prototype.spaceKeyHandler = function(e) {
            if (this.enable && this.showCheckBox) {
                var li = this.curUL.querySelector("." + classNames$__focused);
                this.setCheckboxLI(li, e);
            }
        }, ListView.prototype.keyActionHandler = function(e) {
            switch (e.preventDefault(), e.action) {
              case "home":
                this.homeKeyHandler(e);
                break;

              case "end":
                this.homeKeyHandler(e, !0);
                break;

              case "moveDown":
                this.arrowKeyHandler(e);
                break;

              case "moveUp":
                this.arrowKeyHandler(e, !0);
                break;

              case "select":
                this.enterKeyHandler(e);
                break;

              case "back":
                this.back();
                break;

              case "tab":
                this.tabFocus(e);
                break;

              case "space":
                this.spaceKeyHandler(e);
            }
        }, ListView.prototype.swipeActionHandler = function(e) {
            "Right" === e.swipeDirection && this.back();
        }, ListView.prototype.focusout = function() {
            var focusedElement = this.curUL.querySelector("." + classNames$__focused), activeElement = this.curUL.querySelector("[aria-selected = true]");
            focusedElement && !this.showCheckBox && (focusedElement.classList.remove(classNames$__focused), 
            activeElement && activeElement.classList.add(classNames$__selected));
        }, ListView.prototype.wireEvents = function() {
            EventHandler.add(this.element, "click", this.clickHandler, this), EventHandler.add(this.element, "mouseover", this.hoverHandler, this), 
            EventHandler.add(this.element, "mouseout", this.leaveHandler, this), EventHandler.add(this.element, "focusout", this.focusout, this), 
            this.keyboardModule = new KeyboardEvents(this.element, {
                keyAction: this.keyActionHandler.bind(this),
                keyConfigs: this.keyConfigs
            }), this.touchModule = new Touch(this.element, {
                swipe: this.swipeActionHandler.bind(this)
            });
        }, ListView.prototype.unWireEvents = function() {
            EventHandler.remove(this.element, "click", this.clickHandler), EventHandler.remove(this.element, "mouseover", this.hoverHandler), 
            EventHandler.remove(this.element, "mouseout", this.leaveHandler), this.keyboardModule.destroy(), 
            this.touchModule.destroy();
        }, ListView.prototype.tabFocus = function(e) {
            if (!this.curUL.querySelector("." + classNames$__selected) && this.curUL || this.showCheckBox) {
                var li = this.curUL.querySelector("." + classNames$__listItem);
                if (li.classList.contains(classNames$__hasChild) || this.showCheckBox) {
                    isNullOrUndefined(this.curUL.querySelector("." + classNames$__focused)) && li.classList.add(classNames$__focused);
                } else this.setSelectLI(li, e);
            }
        }, ListView.prototype.removeHover = function() {
            var hoverLI = this.element.querySelector("." + classNames$__hover);
            hoverLI && hoverLI.classList.remove(classNames$__hover);
        }, ListView.prototype.removeSelect = function() {
            for (var _i = 0, selectedLI_1 = this.element.querySelectorAll("[aria-selected = true]"); _i < selectedLI_1.length; _i++) {
                var ele = selectedLI_1[_i];
                ele.removeAttribute("aria-selected"), "" !== ele.className && ele.classList.remove(classNames$__selected);
            }
        }, ListView.prototype.isValidLI = function(li) {
            return li && li.classList.contains(classNames$__listItem) && !li.classList.contains(classNames$__grpListItem) && !li.classList.contains(classNames$__disable);
        }, ListView.prototype.setCheckboxLI = function(li, e) {
            if (this.isValidLI(li) && this.enable && this.showCheckBox) {
                this.curUL.querySelector("." + classNames$__focused) && this.curUL.querySelector("." + classNames$__focused).classList.remove(classNames$__focused), 
                li.classList.add(classNames$__focused);
                var checkboxElement = li.querySelector("." + classNames$__checkboxWrapper), checkIcon = checkboxElement.querySelector("." + classNames$__checkboxIcon + "." + classNames$__icon);
                if (this.removeHover(), checkIcon.classList.contains(classNames$__checked) ? (checkIcon.classList.remove(classNames$__checked), 
                li.classList.remove(classNames$__selected)) : (checkIcon.classList.add(classNames$__checked), 
                li.classList.add(classNames$__selected)), checkboxElement.setAttribute("aria-checked", checkIcon.classList.contains(classNames$__checked) ? "true" : "false"), 
                e) {
                    var eventArgs = this.selectEventData(li, e);
                    merge(eventArgs, {
                        isChecked: checkIcon.classList.contains(classNames$__checked)
                    }), this.trigger("select", eventArgs);
                }
            }
        }, ListView.prototype.selectEventData = function(li, e) {
            var data = this.getItemData(li), fieldData = getFieldValues(data, this.listBaseOption.fields), eventArgs = {};
            return merge(eventArgs, isNullOrUndefined(data) && "string" == typeof this.dataSource[0] ? {
                item: li,
                text: li.innerText.trim(),
                data: this.dataSource
            } : {
                item: li,
                text: fieldData[this.listBaseOption.fields.text],
                data: data
            }), e && merge(eventArgs, {
                isInteracted: !0,
                event: e,
                index: Array.prototype.indexOf.call(this.curUL.children, li)
            }), eventArgs;
        }, ListView.prototype.setSelectLI = function(li, e) {
            if (this.isValidLI(li) && !li.classList.contains(classNames$__selected) && this.enable) {
                this.removeSelect(), li.classList.add(classNames$__selected), li.setAttribute("aria-selected", "true"), 
                this.removeHover();
                var eventArgs = this.selectEventData(li, e);
                this.trigger("select", eventArgs), this.selectedLI = li, this.renderSubList(li);
            }
        }, ListView.prototype.setHoverLI = function(li) {
            if (this.isValidLI(li) && !li.classList.contains(classNames$__hover) && this.enable) {
                var lastLi = this.element.querySelectorAll("." + classNames$__hover);
                lastLi && lastLi.length && removeClass(lastLi, classNames$__hover), li.classList.contains(classNames$__selected) && !this.showCheckBox || li.classList.add(classNames$__hover);
            }
        }, ListView.prototype.hoverSiblingLI = function(prev) {
            var siblingLI, lastLi = this.curUL.querySelector("." + classNames$__hover);
            if (lastLi || (lastLi = this.curUL.querySelector("." + classNames$__selected)), 
            lastLi) siblingLI = ListBase.getSiblingLI(this.curUL.querySelectorAll("." + classNames$__listItem), lastLi, prev); else if (prev) {
                var curLIs = this.curUL.querySelectorAll("." + classNames$__listItem);
                siblingLI = curLIs[curLIs.length - 1];
            } else siblingLI = this.curUL.querySelector("." + classNames$__listItem);
            this.setHoverLI(siblingLI);
        }, ListView.prototype.getSubDS = function() {
            var levelKeys = this.curDSLevel;
            if (levelKeys.length) {
                for (var ds = this.localData, _i = 0, levelKeys_1 = levelKeys; _i < levelKeys_1.length; _i++) {
                    var key = levelKeys_1[_i];
                    this.curDSJSON = this.findItemFromDS(ds, {
                        id: key
                    });
                    var fieldData = getFieldValues(this.curDSJSON, this.listBaseOption.fields);
                    ds = this.curDSJSON ? fieldData[this.fields.child] : ds;
                }
                return ds;
            }
            return this.localData;
        }, ListView.prototype.getItemData = function(li) {
            var fields = this.getElementUID(li), curDS = this.dataSource;
            return this.findItemFromDS(curDS, fields);
        }, ListView.prototype.findItemFromDS = function(dataSource, fields, parent) {
            var resultJSON, _this = this;
            return dataSource && dataSource.length && fields ? dataSource.some(function(data) {
                var fieldData = getFieldValues(data, _this.listBaseOption.fields);
                if (!fields.id && !fields.text || fields.id && fieldData[_this.fields.id] !== fields.id || fields.text && fieldData[_this.fields.text] !== fields.text) if (!isNullOrUndefined(fields.id) && isNullOrUndefined(fieldData[_this.fields.id])) {
                    _this.element.querySelector('[data-uid="' + fields.id + '"]').innerText.trim() === fieldData[_this.fields.text] && (resultJSON = data);
                } else fieldData.hasOwnProperty(_this.fields.child) && fieldData[_this.fields.child].length && (resultJSON = _this.findItemFromDS(fieldData[_this.fields.child], fields, parent)); else resultJSON = parent ? dataSource : data;
                return !!resultJSON;
            }) : resultJSON = dataSource, resultJSON;
        }, ListView.prototype.getQuery = function() {
            var columns = [], query = this.query ? this.query : new Query();
            if (!this.query) {
                for (var _i = 0, _a = Object.keys(this.fields.properties); _i < _a.length; _i++) {
                    var column = _a[_i];
                    "tableName" !== column && this.fields[column] && this.fields[column] !== ListBase.defaultMappedFields[column] && -1 === columns.indexOf(this.fields[column]) && columns.push(this.fields[column]);
                }
                query.select(columns), this.fields.properties.hasOwnProperty("tableName") && query.from(this.fields.tableName);
            }
            return query;
        }, ListView.prototype.setViewDataSource = function(dataSource) {
            void 0 === dataSource && (dataSource = this.localData), dataSource && this.fields.groupBy ? this.curViewDS = ListBase.groupDataSource(dataSource, this.fields, this.sortOrder) : dataSource && "None" !== this.sortOrder ? this.curViewDS = ListBase.getDataSource(dataSource, ListBase.addSorting(this.sortOrder, this.fields.sortBy)) : this.curViewDS = dataSource;
        }, ListView.prototype.isInAnimation = function() {
            return this.curUL.classList.contains(".e-animate");
        }, ListView.prototype.setLocalData = function() {
            var _this = this;
            if (this.trigger("actionBegin"), this.dataSource instanceof DataManager) this.dataSource.executeQuery(this.getQuery()).then(function(e) {
                _this.isDestroyed || (_this.localData = e.result, _this.renderList(), _this.trigger("actionComplete", e));
            }).catch(function(e) {
                _this.isDestroyed || _this.trigger("actionFailure", e);
            }); else if (this.dataSource && this.dataSource.length) this.localData = this.dataSource, 
            this.renderList(), this.trigger("actionComplete", {
                data: this.localData
            }); else {
                var ul = this.element.querySelector("ul");
                ul && (remove(ul), this.setProperties({
                    dataSource: ListBase.createJsonFromElement(ul)
                }, !0), this.localData = this.dataSource, this.renderList(), this.trigger("actionComplete", {
                    data: this.localData
                }));
            }
        }, ListView.prototype.reRender = function() {
            this.element.innerHTML = "", this.curUL = this.headerEle = void 0, this.setLocalData(), 
            this.header();
        }, ListView.prototype.resetCurrentList = function() {
            this.setViewDataSource(this.curViewDS), this.contentContainer.innerHTML = "", this.createList(), 
            this.renderIntoDom(this.curUL);
        }, ListView.prototype.createList = function() {
            this.currentLiElements = [], this.ulElement = this.curUL = ListBase.createList(this.curViewDS, this.listBaseOption), 
            this.liCollection = this.curUL.querySelectorAll("." + classNames$__listItem);
        }, ListView.prototype.renderSubList = function(li) {
            var uID = li.getAttribute("data-uid");
            if (li.classList.contains(classNames$__hasChild) && uID) {
                var ul = closest(li.parentNode, "." + classNames$__parentItem), ele = this.element.querySelector("[pid='" + uID + "']");
                this.curDSLevel.push(uID), this.setViewDataSource(this.getSubDS()), ele || ((ele = ListBase.createListFromJson(this.curViewDS, this.listBaseOption, this.curDSLevel.length)).setAttribute("pID", uID), 
                ele.style.display = "none", this.renderIntoDom(ele)), this.switchView(ul, ele), 
                this.liCollection = this.curUL.querySelectorAll("." + classNames$__listItem);
                var fieldData = getFieldValues(this.getSelectedItems().data, this.listBaseOption.fields);
                this.header(fieldData[this.listBaseOption.fields.text], !0), this.selectedLI = void 0;
            }
        }, ListView.prototype.renderIntoDom = function(ele) {
            this.contentContainer.appendChild(ele);
        }, ListView.prototype.renderList = function() {
            this.setViewDataSource(), this.createList(), this.contentContainer = createElement("div", {
                className: classNames$__content
            }), this.element.appendChild(this.contentContainer), this.renderIntoDom(this.ulElement);
        }, ListView.prototype.getElementUID = function(obj) {
            var fields = {};
            return obj instanceof Element ? fields.id = obj.getAttribute("data-uid") : fields = obj, 
            fields;
        }, ListView.prototype.render = function() {
            this.element.classList.add(classNames$__root), attributes(this.element, {
                role: "list",
                tabindex: "0"
            }), this.setCSSClass(), this.setEnableRTL(), this.setEnable(), this.setSize(), this.wireEvents(), 
            this.header(), this.setLocalData(), this.setHTMLAttribute(), this.rippleFn = rippleEffect(this.element, {
                selector: "." + classNames$__listItem
            });
        }, ListView.prototype.destroy = function() {
            this.unWireEvents();
            var classAr = [ classNames$__root, this.cssClass, classNames$__disable, "e-rtl", "e-has-header" ];
            removeClass([ this.element ], classAr), this.rippleFn(), _super.prototype.destroy.call(this);
        }, ListView.prototype.back = function() {
            var pID = this.curDSLevel[this.curDSLevel.length - 1];
            if (void 0 !== pID && !this.isInAnimation()) {
                this.curDSLevel.pop(), this.setViewDataSource(this.getSubDS());
                var toUL = this.element.querySelector("[data-uid='" + pID + "']"), fromUL = this.curUL;
                toUL ? toUL = toUL.parentElement : (this.createList(), this.renderIntoDom(this.ulElement), 
                toUL = this.curUL);
                var text = getFieldValues(this.curDSJSON, this.listBaseOption.fields)[this.fields.text];
                this.switchView(fromUL, toUL, !0), this.removeSelect(), this.liCollection = this.curUL.querySelectorAll("." + classNames$__listItem), 
                this.header(this.curDSLevel.length ? text : this.headerTitle, !!this.curDSLevel.length);
            }
        }, ListView.prototype.selectItem = function(obj) {
            isNullOrUndefined(obj) || (this.showCheckBox ? this.setCheckboxLI(this.getLiFromObjOrElement(obj)) : this.setSelectLI(this.getLiFromObjOrElement(obj)));
        }, ListView.prototype.getLiFromObjOrElement = function(obj) {
            var li;
            if (!isNullOrUndefined(obj)) if ("string" == typeof this.dataSource[0]) {
                for (var uid = obj.getAttribute("data-uid").toString(), i = 0; i < this.liCollection.length; i++) if (this.liCollection[i].getAttribute("data-uid").toString() === uid) {
                    li = this.liCollection[i];
                    break;
                }
            } else {
                var resultJSON = this.getItemData(obj), fieldData = getFieldValues(resultJSON, this.listBaseOption.fields);
                if (resultJSON && (li = this.element.querySelector('[data-uid="' + fieldData[this.fields.id] + '"]'), 
                isNullOrUndefined(li))) {
                    var curLi = this.element.querySelectorAll("." + classNames$__listItem);
                    for (i = 0; i < curLi.length; i++) curLi[i].innerText.trim() === resultJSON.text && (li = curLi[i]);
                }
            }
            return li;
        }, ListView.prototype.selectMultipleItems = function(obj) {
            if (!isNullOrUndefined(obj)) for (var i = 0; i < obj.length; i++) isNullOrUndefined(obj[i]) || this.selectItem(obj[i]);
        }, ListView.prototype.getSelectedItems = function() {
            if (this.selectedId = [], this.showCheckBox) {
                var liCollection = this.element.getElementsByClassName(classNames$__selected), liTextCollection = [], liDataCollection = [];
                this.selectedId = [];
                for (var i = 0; i < liCollection.length; i++) if ("string" == typeof this.dataSource[0]) liTextCollection.push(liCollection[i].innerText.trim()); else {
                    var fieldData = getFieldValues(this.getItemData(liCollection[i]), this.listBaseOption.fields);
                    liTextCollection.push(fieldData[this.listBaseOption.fields.text]), liDataCollection.push(this.getItemData(liCollection[i])), 
                    this.selectedId.push(fieldData[this.listBaseOption.fields.id]);
                }
                return "string" == typeof this.dataSource[0] ? {
                    item: liCollection,
                    data: this.dataSource,
                    text: liTextCollection
                } : {
                    item: liCollection,
                    data: liDataCollection,
                    text: liTextCollection
                };
            }
            var liElement = this.element.getElementsByClassName(classNames$__selected)[0];
            fieldData = getFieldValues(this.getItemData(liElement), this.listBaseOption.fields);
            return "string" == typeof this.dataSource[0] ? isNullOrUndefined(liElement) ? void 0 : {
                item: liElement,
                data: this.dataSource,
                text: liElement.innerText.trim()
            } : isNullOrUndefined(fieldData) || isNullOrUndefined(liElement) ? void 0 : (this.selectedId.push(fieldData[this.listBaseOption.fields.id]), 
            {
                text: fieldData[this.listBaseOption.fields.text],
                item: liElement,
                data: this.getItemData(liElement)
            });
        }, ListView.prototype.findItem = function(fields) {
            return this.findItemFromDS(this.dataSource, fields);
        }, ListView.prototype.enableItem = function(obj) {
            this.setItemState(obj, !0);
        }, ListView.prototype.disableItem = function(obj) {
            this.setItemState(obj, !1);
        }, ListView.prototype.setItemState = function(obj, isEnable) {
            var resultJSON = this.getItemData(obj), fieldData = getFieldValues(resultJSON, this.listBaseOption.fields);
            if (resultJSON) {
                var li = this.element.querySelector('[data-uid="' + fieldData[this.fields.id] + '"]');
                isEnable ? (li && li.classList.remove(classNames$__disable), delete resultJSON[this.fields.enabled]) : isEnable || (li && li.classList.add(classNames$__disable), 
                resultJSON[this.fields.enabled] = !1);
            }
        }, ListView.prototype.showItem = function(obj) {
            this.showHideItem(obj, !1, "");
        }, ListView.prototype.hideItem = function(obj) {
            this.showHideItem(obj, !0, "none");
        }, ListView.prototype.showHideItem = function(obj, isHide, display) {
            var resultJSON = this.getItemData(obj), fieldData = getFieldValues(resultJSON, this.listBaseOption.fields);
            if (resultJSON) {
                var li = this.element.querySelector('[data-uid="' + fieldData[this.fields.id] + '"]');
                li && (li.style.display = display), isHide ? resultJSON[this.fields.isVisible] = !1 : delete resultJSON[this.fields.isVisible];
            }
        }, ListView.prototype.addItem = function(data, fields) {
            var ds = this.findItemFromDS(this.dataSource, fields), child = getFieldValues(ds, this.listBaseOption.fields)[this.fields.child];
            child || (child = []), child = child.concat(data), ds instanceof Array ? (this.dataSource = this.localData = ds.concat(data), 
            this.setViewDataSource()) : ds[this.fields.child] = child, this.resetCurrentList();
        }, ListView.prototype.removeItem = function(obj) {
            this.removeItemFromList(obj, !0);
        }, ListView.prototype.removeItemFromList = function(obj, resetList) {
            var _this = this, valid = !1;
            if ("string" == typeof this.dataSource[0]) {
                if ("object" == typeof obj) {
                    var liCollection_1 = [], idx_1 = 0;
                    this.liCollection.forEach(function(element) {
                        element === obj ? (valid = !0, _this.removeElement(element), _this.dataSource.splice(idx_1, 1), 
                        _this.localData = _this.dataSource) : liCollection_1.push(element), idx_1++;
                    }), this.liCollection = liCollection_1;
                } else if ("string" == typeof obj) {
                    var liCollection_2 = [], idx_2 = 0, ds_1 = [];
                    this.liCollection.forEach(function(element) {
                        element.innerText.trim() === obj ? (valid = !0, _this.removeElement(element)) : (liCollection_2.push(element), 
                        ds_1.push(_this.dataSource[idx_2])), idx_2++;
                    }), this.localData = this.curViewDS = this.dataSource = ds_1, this.liCollection = liCollection_2;
                }
                var values = this.getSelectedItems();
                if (this.selectedData = isNullOrUndefined(values) ? void 0 : values.text, void 0, 
                resetList && valid) {
                    if (this.resetList = !0, this.resetCurrentList(), !this.showCheckBox && this.selectedData && this.selectedData.length) {
                        this.removeSelect();
                        var index = this.dataSource.lastIndexOf(this.selectedData);
                        this.liCollection[index].classList.add(classNames$__selected), this.liCollection[index].setAttribute("aria-selected", "true");
                    }
                    this.resetList = !1;
                }
            } else {
                isNullOrUndefined(this.getSelectedItems()) ? void 0 : this.getSelectedItems().data;
                var curAr_1, fields_1 = this.getElementUID(obj), curDS = this.findItemFromDS(this.dataSource, fields_1, !0);
                if (curDS && obj) {
                    var idx_3;
                    curDS.some(function(data, index, arr) {
                        var fieldData = getFieldValues(data, _this.listBaseOption.fields);
                        return !(!fields_1.id && !fields_1.text || fields_1.id && fieldData[_this.fields.id] !== fields_1.id || fields_1.text && fieldData[_this.fields.text] !== fields_1.text) && (curAr_1 = arr, 
                        idx_3 = index, !0);
                    }), this.removeElement(this.getLiFromObjOrElement(curAr_1[idx_3])), curAr_1.splice(idx_3, 1), 
                    this.curViewDS = curAr_1;
                }
                values = this.getSelectedItems();
                this.selectedData = isNullOrUndefined(values) ? void 0 : values.text, resetList && curAr_1 && (this.resetList = !0, 
                this.resetCurrentList(), this.showCheckBox || isNullOrUndefined(values) || this.selectItem(values.item), 
                this.resetList = !1);
            }
        }, ListView.prototype.removeMultipleItems = function(obj) {
            if (obj.length) for (var i = 0; i < obj.length; i++) i === obj.length - 1 ? this.removeItemFromList(obj[i], !0) : this.removeItemFromList(obj[i], !1);
        }, ListView.prototype.getModuleName = function() {
            return "listview";
        }, ListView.prototype.getPersistData = function() {
            return this.addOnPersist([ "cssClass", "enableRtl", "htmlAttributes", "enable", "fields", "animation", "headerTitle", "sortOrder", "showIcon", "height", "width", "showCheckBox", "checkBoxPosition" ]);
        }, __decorate$8([ Property() ], ListView.prototype, "cssClass", void 0), __decorate$8([ Property({}) ], ListView.prototype, "htmlAttributes", void 0), 
        __decorate$8([ Property(!0) ], ListView.prototype, "enable", void 0), __decorate$8([ Property([]) ], ListView.prototype, "dataSource", void 0), 
        __decorate$8([ Property() ], ListView.prototype, "query", void 0), __decorate$8([ Complex(ListBase.defaultMappedFields, FieldSettings$1) ], ListView.prototype, "fields", void 0), 
        __decorate$8([ Property({
            effect: "SlideLeft",
            duration: 400,
            easing: "ease"
        }) ], ListView.prototype, "animation", void 0), __decorate$8([ Property("None") ], ListView.prototype, "sortOrder", void 0), 
        __decorate$8([ Property(!1) ], ListView.prototype, "showIcon", void 0), __decorate$8([ Property(!1) ], ListView.prototype, "showCheckBox", void 0), 
        __decorate$8([ Property("Left") ], ListView.prototype, "checkBoxPosition", void 0), 
        __decorate$8([ Property("") ], ListView.prototype, "headerTitle", void 0), __decorate$8([ Property(!1) ], ListView.prototype, "showHeader", void 0), 
        __decorate$8([ Property("") ], ListView.prototype, "height", void 0), __decorate$8([ Property("") ], ListView.prototype, "width", void 0), 
        __decorate$8([ Property(null) ], ListView.prototype, "template", void 0), __decorate$8([ Property(null) ], ListView.prototype, "groupTemplate", void 0), 
        __decorate$8([ Event() ], ListView.prototype, "select", void 0), __decorate$8([ Event() ], ListView.prototype, "actionBegin", void 0), 
        __decorate$8([ Event() ], ListView.prototype, "actionComplete", void 0), __decorate$8([ Event() ], ListView.prototype, "actionFailure", void 0), 
        ListView = __decorate$8([ NotifyPropertyChanges ], ListView);
    }(Component), _lists = Object.freeze({
        FieldSettings: FieldSettings$1,
        ListView: ListView,
        get cssClass() {
            return cssClass;
        },
        get ListBase() {
            return ListBase;
        },
        getFieldValues: getFieldValues
    }), __extends$7 = function() {
        var extendStatics = Object.setPrototypeOf || {
            __proto__: []
        } instanceof Array && function(d, b) {
            d.__proto__ = b;
        } || function(d, b) {
            for (var p in b) b.hasOwnProperty(p) && (d[p] = b[p]);
        };
        return function(d, b) {
            function __() {
                this.constructor = d;
            }
            extendStatics(d, b), d.prototype = null === b ? Object.create(b) : (__.prototype = b.prototype, 
            new __());
        };
    }(), __decorate$7 = function(decorators, target, key, desc) {
        var d, c = arguments.length, r = c < 3 ? target : null === desc ? desc = Object.getOwnPropertyDescriptor(target, key) : desc;
        if ("object" == typeof Reflect && "function" == typeof Reflect.decorate) r = Reflect.decorate(decorators, target, key, desc); else for (var i = decorators.length - 1; i >= 0; i--) (d = decorators[i]) && (r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r);
        return c > 3 && r && Object.defineProperty(target, key, r), r;
    }, FieldSettings = function(_super) {
        function FieldSettings() {
            return null !== _super && _super.apply(this, arguments) || this;
        }
        return __extends$7(FieldSettings, _super), __decorate$7([ Property() ], FieldSettings.prototype, "text", void 0), 
        __decorate$7([ Property() ], FieldSettings.prototype, "value", void 0), __decorate$7([ Property() ], FieldSettings.prototype, "iconCss", void 0), 
        __decorate$7([ Property() ], FieldSettings.prototype, "groupBy", void 0), __decorate$7([ Property() ], FieldSettings.prototype, "htmlAttributes", void 0), 
        FieldSettings;
    }(ChildProperty), dropDownBaseClasses = {
        root: "e-dropdownbase",
        rtl: "e-rtl",
        content: "e-content",
        selected: "e-active",
        hover: "e-hover",
        noData: "e-nodata",
        fixedHead: "e-fixed-head",
        focus: "e-item-focus",
        li: cssClass.li,
        group: cssClass.group,
        disabled: cssClass.disabled,
        grouping: "e-dd-group"
    }, DropDownBase = function(_super) {
        function DropDownBase(options, element) {
            return _super.call(this, options, element) || this;
        }
        return __extends$7(DropDownBase, _super), DropDownBase.prototype.getPropObject = function(prop, newProp, oldProp) {
            var newProperty = new Object(), oldProperty = new Object(), propName = new Function("prop", "return prop");
            newProperty[propName(prop)] = newProp[propName(prop)], oldProperty[propName(prop)] = oldProp[propName(prop)];
            var data = new Object();
            return data.newProperty = newProperty, data.oldProperty = oldProperty, data;
        }, DropDownBase.prototype.getValueByText = function(text, ignoreCase) {
            var value = null, dataSource = this.listData, fields = this.fields, type = this.typeOfData(dataSource).typeof;
            if (ignoreCase) if ("string" === type || "number" === type) for (var _i = 0, dataSource_1 = dataSource; _i < dataSource_1.length; _i++) {
                if (!isNullOrUndefined(item = dataSource_1[_i]) && String(item).toLowerCase() === text.toString().toLowerCase()) {
                    value = "string" === type ? String(item) : this.getFormattedValue(String(item));
                    break;
                }
            } else dataSource.filter(function(item) {
                getValue(fields.text, item).toString().toLowerCase() === text.toLowerCase() && (value = getValue(fields.value, item));
            }); else if ("string" === type || "number" === type) for (var _a = 0, dataSource_2 = dataSource; _a < dataSource_2.length; _a++) {
                var item;
                if (!isNullOrUndefined(item = dataSource_2[_a]) && String(item) === text.toString()) {
                    value = "string" === type ? text : this.getFormattedValue(text);
                    break;
                }
            } else dataSource.filter(function(item) {
                getValue(fields.text, item) === text && (value = getValue(fields.value, item));
            });
            return value;
        }, DropDownBase.prototype.l10nUpdate = function(actionFailure) {
            if ("No Records Found" !== this.noRecordsTemplate || "The Request Failed" !== this.actionFailureTemplate) {
                var template = actionFailure ? this.actionFailureTemplate : this.noRecordsTemplate;
                this.list.innerHTML = "";
                for (var _i = 0, _a = compile$$1(template)({}); _i < _a.length; _i++) {
                    var item = _a[_i];
                    this.list.appendChild(item);
                }
            } else {
                this.l10n = new L10n("dropdowns", {
                    noRecordsTemplate: "No Records Found",
                    actionFailureTemplate: "The Request Failed"
                }, this.locale), this.list.innerHTML = actionFailure ? this.l10n.getConstant("actionFailureTemplate") : this.l10n.getConstant("noRecordsTemplate");
            }
        }, DropDownBase.prototype.getTextByValue = function(value) {
            var text, dataSource = this.listData, fields = this.fields, type = this.typeOfData(dataSource).typeof;
            if ("string" === type || "number" === type) for (var _i = 0, dataSource_3 = dataSource; _i < dataSource_3.length; _i++) {
                var item = dataSource_3[_i];
                if (!isNullOrUndefined(item) && item.toString() === value.toString()) {
                    text = item.toString();
                    break;
                }
            } else dataSource.filter(function(item) {
                var itemValue = getValue(fields.value, item);
                isNullOrUndefined(itemValue) || itemValue.toString() !== value.toString() || (text = getValue(fields.text, item));
            });
            return text;
        }, DropDownBase.prototype.getFormattedValue = function(value) {
            if (this.listData && this.listData.length) {
                var item = this.typeOfData(this.listData);
                if ("number" == typeof getValue(this.fields.value ? this.fields.value : "value", item.item) || "number" === item.typeof) return parseInt(value, 10);
            }
            return value;
        }, DropDownBase.prototype.setEnableRtl = function() {
            this.list && this.enableRtlElements.push(this.list), this.enableRtl ? addClass(this.enableRtlElements, dropDownBaseClasses.rtl) : removeClass(this.enableRtlElements, dropDownBaseClasses.rtl);
        }, DropDownBase.prototype.initialize = function() {
            if (this.bindEvent = !0, "UL" === this.element.tagName) {
                var jsonElement = ListBase.createJsonFromElement(this.element);
                this.setProperties({
                    fields: {
                        text: "text",
                        value: "text"
                    }
                }, !0), this.resetList(jsonElement, this.fields);
            } else if ("SELECT" === this.element.tagName) {
                (this.dataSource instanceof Array ? this.dataSource.length > 0 : !isNullOrUndefined(this.dataSource)) || this.renderItemsBySelect();
            } else this.setListData(this.dataSource, this.fields, this.query);
        }, DropDownBase.prototype.getPersistData = function() {
            return this.addOnPersist([]);
        }, DropDownBase.prototype.setEnabled = function() {
            this.enabled ? this.element.setAttribute("aria-disabled", "false") : this.element.setAttribute("aria-disabled", "true");
        }, DropDownBase.prototype.renderItemsBySelect = function() {
            var element = this.element, fields = {
                value: "value",
                text: "text"
            }, jsonElement = [], group = element.querySelectorAll("select>optgroup"), option = element.querySelectorAll("select>option");
            if (this.getJSONfromOption(jsonElement, option, fields), group.length) {
                for (var i = 0; i < group.length; i++) {
                    var item = group[i], optionGroup = {};
                    optionGroup[fields.text] = item.label, optionGroup.isHeader = !0;
                    var child = item.querySelectorAll("option");
                    jsonElement.push(optionGroup), this.getJSONfromOption(jsonElement, child, fields);
                }
                element.querySelectorAll("select>option");
            }
            this.fields.text = fields.text, this.fields.value = fields.value, this.resetList(jsonElement, fields);
        }, DropDownBase.prototype.getJSONfromOption = function(items, options, fields) {
            for (var _i = 0, options_1 = options; _i < options_1.length; _i++) {
                var option = options_1[_i], json = {};
                json[fields.text] = option.innerText, json[fields.value] = option.getAttribute(fields.value) ? option.getAttribute(fields.value) : option.innerText, 
                items.push(json);
            }
        }, DropDownBase.prototype.preRender = function() {
            this.scrollTimer = -1, this.enableRtlElements = [], this.isRequested = !1;
        }, DropDownBase.prototype.setListData = function(dataSource, fields, query) {
            var _this = this;
            fields = fields || this.fields;
            var ulElement;
            if (this.isActive = !0, dataSource instanceof DataManager) {
                var eventArgs = {
                    cancel: !1,
                    data: dataSource,
                    query: query
                };
                if (this.trigger("actionBegin", eventArgs), eventArgs.cancel) return;
                this.showSpinner(), this.isRequested = !0, eventArgs.data.executeQuery(this.getQuery(eventArgs.query)).then(function(e) {
                    if (_this.trigger("actionComplete", e), !e.cancel) {
                        var listItems = e.result;
                        ulElement = _this.renderItems(listItems, fields), _this.onActionComplete(ulElement, listItems, e), 
                        _this.isRequested = !1, _this.hideSpinner(), _this.trigger("dataBound", {
                            items: listItems,
                            e: e
                        });
                    }
                }).catch(function(e) {
                    _this.isRequested = !1, _this.onActionFailure(e), _this.hideSpinner();
                });
            } else {
                this.showSpinner();
                var dataManager = new DataManager(dataSource), listItems = this.getQuery(query).executeLocal(dataManager);
                ulElement = this.renderItems(listItems, fields), this.onActionComplete(ulElement, listItems), 
                this.hideSpinner(), this.trigger("dataBound", {
                    items: listItems
                });
            }
        }, DropDownBase.prototype.showSpinner = function() {}, DropDownBase.prototype.hideSpinner = function() {}, 
        DropDownBase.prototype.onActionFailure = function(e) {
            this.liCollections = [], this.trigger("actionFailure", e), this.l10nUpdate(!0), 
            addClass([ this.list ], dropDownBaseClasses.noData);
        }, DropDownBase.prototype.onActionComplete = function(ulElement, list, e) {
            this.listData = list, this.list.innerHTML = "", this.list.appendChild(ulElement), 
            this.liCollections = this.list.querySelectorAll("." + dropDownBaseClasses.li), this.ulElement = this.list.querySelector("ul"), 
            this.postRender(this.list, list, this.bindEvent);
        }, DropDownBase.prototype.postRender = function(listElement, list, bindEvent) {
            var focusItem = listElement.querySelector("." + dropDownBaseClasses.li), selectedItem = listElement.querySelector("." + dropDownBaseClasses.selected);
            focusItem && !selectedItem && addClass([ focusItem ], dropDownBaseClasses.focus), 
            list.length <= 0 ? (this.l10nUpdate(), addClass([ listElement ], dropDownBaseClasses.noData)) : listElement.classList.remove(dropDownBaseClasses.noData), 
            this.groupTemplate && this.renderGroupTemplate(listElement);
        }, DropDownBase.prototype.getQuery = function(query) {
            return query || (this.query ? this.query : new Query());
        }, DropDownBase.prototype.renderGroupTemplate = function(listEle) {
            if (null !== this.fields.groupBy && this.dataSource || this.element.querySelector("." + dropDownBaseClasses.group)) {
                var dataSource = this.dataSource, headerItems = listEle.querySelectorAll("." + dropDownBaseClasses.group);
                ListBase.renderGroupTemplate(this.groupTemplate, dataSource, this.fields.properties, headerItems);
            }
        }, DropDownBase.prototype.createListItems = function(dataSource, fields) {
            dataSource && fields.groupBy || this.element.querySelector("optgroup") ? (fields.groupBy && ("None" !== this.sortOrder && (dataSource = this.getSortedDataSource(dataSource)), 
            dataSource = ListBase.groupDataSource(dataSource, fields.properties, this.sortOrder)), 
            addClass([ this.list ], dropDownBaseClasses.grouping)) : dataSource = this.getSortedDataSource(dataSource);
            var options = this.listOption(dataSource, fields);
            return ListBase.createList(dataSource, options, !0);
        }, DropDownBase.prototype.listOption = function(dataSource, fields) {
            var iconCss = !isNullOrUndefined(fields.iconCss);
            return extend({}, null !== fields.text || null !== fields.value ? {
                fields: fields.properties,
                showIcon: iconCss,
                ariaAttributes: {
                    groupItemRole: "presentation"
                }
            } : {
                fields: {
                    value: "text"
                }
            }, fields, !0);
        }, DropDownBase.prototype.setFloatingHeader = function(e) {
            isNullOrUndefined(this.fixedHeaderElement) && (this.fixedHeaderElement = createElement("div", {
                className: dropDownBaseClasses.fixedHead
            }), this.list.querySelector("li").classList.contains(dropDownBaseClasses.group) || (this.fixedHeaderElement.style.display = "none"), 
            prepend([ this.fixedHeaderElement ], this.list), this.setFixedHeader()), isNullOrUndefined(this.fixedHeaderElement) || "0" !== this.fixedHeaderElement.style.zIndex || this.setFixedHeader(), 
            this.scrollStop(e);
        }, DropDownBase.prototype.scrollStop = function(e) {
            for (var target = e.target, liHeight = parseInt(getComputedStyle(this.liCollections[0], null).getPropertyValue("height"), 10), topIndex = Math.round(target.scrollTop / liHeight), liCollections = this.ulElement.querySelectorAll("li"), i = topIndex; i > -1; i--) {
                if (!isNullOrUndefined(liCollections[i]) && liCollections[i].classList.contains(dropDownBaseClasses.group)) {
                    var currentLi = liCollections[i];
                    this.fixedHeaderElement.innerHTML = currentLi.innerHTML, this.fixedHeaderElement.style.top = e.target.scrollTop + "px", 
                    this.fixedHeaderElement.style.display = "block";
                    break;
                }
                this.fixedHeaderElement.style.display = "none", this.fixedHeaderElement.style.top = "none";
            }
        }, DropDownBase.prototype.renderItems = function(listData, fields) {
            var ulElement;
            if (this.itemTemplate && listData) {
                var dataSource = listData;
                dataSource && fields.groupBy ? ("None" !== this.sortOrder && (dataSource = this.getSortedDataSource(dataSource)), 
                dataSource = ListBase.groupDataSource(dataSource, fields.properties, this.sortOrder)) : dataSource = this.getSortedDataSource(dataSource), 
                ulElement = this.templateListItem(dataSource, fields);
            } else ulElement = this.createListItems(listData, fields);
            return ulElement;
        }, DropDownBase.prototype.templateListItem = function(dataSource, fields) {
            var option = this.listOption(dataSource, fields);
            return ListBase.renderContentTemplate(this.itemTemplate, dataSource, fields.properties, option);
        }, DropDownBase.prototype.typeOfData = function(items) {
            for (var item = {
                typeof: null,
                item: null
            }, i = 0; i < items.length; i++) if (!isNullOrUndefined(items[i])) return item = {
                typeof: typeof items[i],
                item: items[i]
            };
            return item;
        }, DropDownBase.prototype.setFixedHeader = function() {
            this.list.parentElement.style.display = "block";
            var liWidth = this.liCollections[0].offsetWidth;
            this.fixedHeaderElement.style.width = liWidth.toString() + "px", setStyleAttribute(this.fixedHeaderElement, {
                zIndex: 10
            });
            var firstLi = this.ulElement.querySelector("." + dropDownBaseClasses.group);
            this.fixedHeaderElement.innerHTML = firstLi.innerHTML;
        }, DropDownBase.prototype.getSortedDataSource = function(dataSource) {
            if (dataSource && "None" !== this.sortOrder) {
                var textField = this.fields.text ? this.fields.text : "text";
                dataSource = ListBase.getDataSource(dataSource, ListBase.addSorting(this.sortOrder, textField));
            }
            return dataSource;
        }, DropDownBase.prototype.getIndexByValue = function(value) {
            for (var index, listItems = this.getItems(), i = 0; i < listItems.length; i++) if (!isNullOrUndefined(value) && listItems[i].getAttribute("data-value") === value.toString()) {
                index = i;
                break;
            }
            return index;
        }, DropDownBase.prototype.dispatchEvent = function(element, type) {
            var evt = document.createEvent("HTMLEvents");
            evt.initEvent(type, !1, !0), element.dispatchEvent(evt);
        }, DropDownBase.prototype.setFields = function() {
            var fields = this.fields;
            this.fields.value && !this.fields.text ? this.fields.text = this.fields.value : !fields.value && fields.text ? this.fields.value = this.fields.text : this.fields.value || this.fields.text || (this.fields.value = this.fields.text = "text");
        }, DropDownBase.prototype.resetList = function(dataSource, fields, query) {
            this.list && this.setListData(dataSource, fields, query);
        }, DropDownBase.prototype.updateSelection = function() {}, DropDownBase.prototype.renderList = function() {
            this.render();
        }, DropDownBase.prototype.updateDataSource = function(prop) {
            this.resetList(this.dataSource);
        }, DropDownBase.proto