﻿using gridmvclocalization.Models;
using Syncfusion.EJ2.Base;
using System;
using System.Collections;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.Linq;
using System.Web;
using System.Web.Mvc;

namespace gridmvclocalization.Controllers
{
    public class HomeController : Controller
    {
        public static List<OrdersDetails> order = new List<OrdersDetails>();
        public ActionResult Index()
        {
            BindData();
            var data = order.ToList();
            ViewBag.dataSource = data;
            return View(GetDepartments());
        }
        public void BindData()
        {
            int code = 10000;
            int empcode = 100;
            for (int i = 1; i < 10; i++)
            {
                order.Add(new OrdersDetails(code + 1, "<span>ALFKI ALFKI ALFKI ALFKI ALFKI ALFKI ALFKI ALFKI ALFKI ALFKI ALFKI</span>", i + 0, 2.3 * i, new DateTime(1991, 05, 15), "Berlin Berlin Berlin Berlin Berlin", "Denmark", true, new Employee(empcode + 1)));
                order.Add(new OrdersDetails(code + 2, "<span>ANATR ANATR ANATR ANATR ANATR ANATR ANATR ANATR ANATR ANATRANATR</span>", i + 2, 3.3 * i, new DateTime(1990, 04, 04), "Madrid Madrid Madrid Madrid Madrid", "Brazil", false, new Employee(empcode + 2)));
                order.Add(new OrdersDetails(code + 3, "<span>ANTON ANTON ANTON ANTON ANTONANTONANTONANTON ANTONANTONANTON ANTON ANTON</span>", i + 1, 4.3 * i, new DateTime(1957, 11, 30), "Cholchester Cholchester Cholchester Cholchester Cholchester", "Germany", null, new Employee(empcode + 3)));
                order.Add(new OrdersDetails(code + 4, "<span> BLONP BLONP BLONP BLONPBLONP BLONPBLONPBLONP BLONPBLONP BLONP BLONP </span>", i + 3, 5.3 * i, new DateTime(1930, 10, 22), "Marseille Marseille Marseille Marseille Marseille", "Austria", true, new Employee(empcode + 4)));
                order.Add(new OrdersDetails(code + 5, "<span>BOLID BOLIDBOLID BOLID BOLID BOLID BOLID BOLID BOLIDBOLIDBOLID BOLID BOLID BOLID</span>", i + 4, 6.3 * i, new DateTime(1953, 02, 18), "Tsawassen Tsawassen Tsawassen TsawassenTsawassen", "Switzerland", null, new Employee(empcode + 5)));
                code += 5;
                empcode += 5;
            }
        }
        public ActionResult BatchUpdate(string action, CRUDModel batchmodel)
        {
            if (batchmodel.Changed != null)
            {
                for (var i = 0; i < batchmodel.Changed.Count(); i++)
                {
                    var ord = batchmodel.Changed[i];
                    OrdersDetails val = order.Where(or => or.OrderID == ord.OrderID).FirstOrDefault();
                    val.OrderID = ord.OrderID;
                    val.CustomerID = ord.CustomerID;
                    val.Verified = ord.Verified;
                }
            }

            if (batchmodel.Deleted != null)
            {
                for (var i = 0; i < batchmodel.Deleted.Count(); i++)
                {
                    order.Remove(order.Where(or => or.OrderID == batchmodel.Deleted[i].OrderID).FirstOrDefault());
                }
            }

            if (batchmodel.Added != null)
            {
                for (var i = 0; i < batchmodel.Added.Count(); i++)
                {
                    order.Insert(0, batchmodel.Added[i]);
                }
            }
            var data = order.ToList();
            return Json(data);

        }

        public List<Department> GetDepartments()
        {
            List<Department> lstDepts = new List<Department>();
            Department dept = new Department();
            dept.DeptID = 1001;
            dept.Name = "Administration";
            dept.Code = "ADM";
            lstDepts.Add(dept);

            dept = new Department();
            dept.DeptID = 1002;
            dept.Name = "Architect";
            dept.Code = "ARC";
            lstDepts.Add(dept);

            dept = new Department();
            dept.DeptID = 1003;
            dept.Name = "Artist";
            dept.Code = "ART";
            lstDepts.Add(dept);

            dept = new Department();
            dept.DeptID = 1004;
            dept.Name = "Handheld Admin";
            dept.Code = "HDN";
            lstDepts.Add(dept);

            dept = new Department();
            dept.DeptID = 1005;
            dept.Name = "Maintenance";
            dept.Code = "MNT";
            lstDepts.Add(dept);

            dept = new Department();
            dept.DeptID = 1008;
            dept.Name = "Human Resource";
            dept.Code = "HR";
            lstDepts.Add(dept);

            dept = new Department();
            dept.DeptID = 1007;
            dept.Name = "Support";
            dept.Code = "SUP";
            lstDepts.Add(dept);

            return lstDepts;
        }



        public class CRUDModel
        {
            public List<OrdersDetails> Added { get; set; }
            public List<OrdersDetails> Changed { get; set; }
            public List<OrdersDetails> Deleted { get; set; }
            public OrdersDetails Value { get; set; }
            public int key { get; set; }
            public string action { get; set; }
        }

        public class Employee
        {
            public Employee()
            {

            }
            public Employee(int EmpID)
            {
                this.EmpID = EmpID;
            }
            public int EmpID { get; set; }

        }

        public class OrdersDetails
        {
            public OrdersDetails()
            {

            }
            public OrdersDetails(long OrderId, string CustomerId, int EmployeeId, double Freight, DateTime OrderDate, string ShipCity, string ShipCountry, bool? Verified, Employee EmpDetails)
            {
                this.OrderID = OrderId;
                this.CustomerID = CustomerId;
                this.EmployeeID = EmployeeId;
                this.Freight = Freight;
                this.OrderDate = OrderDate;
                this.ShipCity = ShipCity;
                this.ShipCountry = ShipCountry;
                this.Verified = Verified;
                this.EmpDetails = EmpDetails;
            }

            

            public long OrderID { get; set; }
            [Required]
            public string CustomerID { get; set; }
            public int EmployeeID { get; set; }
            public double Freight { get; set; }
            public DateTime OrderDate { get; set; }
            public string ShipCity { get; set; }
            public string ShipCountry { get; set; }
            public bool? Verified { get; set; }
            public Employee EmpDetails { get; set; }
        }
    }
}