﻿using Microsoft.AspNetCore.Http.Features;
using Microsoft.AspNetCore.Mvc;

namespace FileUploadSample.Server.Controllers
{
    [Route("api/[controller]")]
    [ApiController]
    public class SampleDataController : Controller
    {
        public IActionResult Index()
        {
            return View();
        }
        public string uploads = ".\\Uploaded Files";

        private Microsoft.AspNetCore.Hosting.IHostingEnvironment hostingEnv;

        public SampleDataController(Microsoft.AspNetCore.Hosting.IHostingEnvironment env)
        {
            this.hostingEnv = env;
        }

        [HttpPost("[action]")]
        public async void Save(IList<IFormFile> UploadFiles) // Save the uploaded file here
        {
            try
            {
                foreach (var file in UploadFiles)
                {
                    var filename = hostingEnv.ContentRootPath + $@"\{file.FileName}";
                    if (!System.IO.File.Exists(filename))
                    {
                        using (FileStream fs = System.IO.File.Create(filename))
                        {
                            file.CopyTo(fs);
                            fs.Flush();
                        }
                    }
                }
            }
            catch (Exception e)
            {
                Response.Clear();
                Response.StatusCode = 204;
                Response.HttpContext.Features.Get<IHttpResponseFeature>().ReasonPhrase = "File failed to upload";
                Response.HttpContext.Features.Get<IHttpResponseFeature>().ReasonPhrase = e.Message;
            }
        }
       
        [HttpPost("[action]")]
        public void Remove(string UploadFiles) // Delete the uploaded file here
        {
            if (UploadFiles != null)
            {
                var filePath = Path.Combine(uploads, UploadFiles);
                if (System.IO.File.Exists(filePath))
                {
                    //Delete the file from server
                    System.IO.File.Delete(filePath);
                }
            }
        }
    }
}
