﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Syncfusion.Pdf;
using Syncfusion.Pdf.Parsing;

namespace SyncfusionMergePdf
{
    internal class Program
    {
        static void Main(string[] args)
        {
            string[] mergeFileNames = new string[]
            {
                "34.pdf", 
                "511 Fragebogen GWG (Gesellschaft).pdf",
                "58.pdf", 
                "VA24_BB_GHV.pdf",
                "VA24_BB_GHV_E01.pdf", 
                "VA24_BB_GHV_E02.pdf", 
                "VA24_BB_GHV_G01.pdf" 
            };

            using (PdfDocument finalPdfDocument = new PdfDocument())
            {
                foreach (string currentMergeFileName in mergeFileNames)
                {
                    using (PdfLoadedDocument currentMergeDocument = new PdfLoadedDocument(currentMergeFileName, true))
                    {
                        PdfDocument.Merge(finalPdfDocument, currentMergeDocument);
                        finalPdfDocument.Save("result.pdf");
                        currentMergeDocument.Close(true);
                    }
                }
                finalPdfDocument.Close(true);
            }
        }
    }
}
