﻿using qFramework.WPF.Core;
using Syncfusion.Windows.Shared;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System;
using System.Runtime.InteropServices;
using System.Windows.Interop;

namespace Test.SubWindows
{
    public class RibbonWindowController : WindowController<RibbonWindowView, RibbonWindowViewModel>
    {
        #region Constants and methods for window manipulation

        private const int GWL_STYLE = -16;
        private const int WS_MINIMIZEBOX = 0x20000;

        [DllImport("user32.dll")]
        private static extern int GetWindowLong(IntPtr hwnd, int index);

        [DllImport("user32.dll")]
        private static extern int SetWindowLong(IntPtr hwnd, int index, int newStyle);

        #endregion

        private Window parentWindow;

        public RibbonWindowController(Window owner, bool office2013)
            : base(owner)
        {
            parentWindow = owner;

            if (office2013)
            {
                SkinStorage.SetVisualStyle(this.View.RibbonWindow, "Office2013");
            }

            //this.View.RibbonWindow.WindowState = WindowState.Maximized;
            //this.View.RibbonWindow.ResizeMode = ResizeMode.NoResize;
        }

        protected override RibbonWindowViewModel CreateViewModel()
        {
            RibbonWindowViewModel viewModel = new RibbonWindowViewModel();

            return viewModel;
        }

        protected override RibbonWindowView CreateView()
        {
            RibbonWindowView view = new RibbonWindowView();

            view.RibbonWindow.SourceInitialized += MainView_Window_SourceInitialized;

            return view;
        }

        public bool Start()
        {
            var result = this.View.ShowDialog();

            return (result.HasValue && result.Value);
        }

        private void MainView_Window_SourceInitialized(object sender, EventArgs e)
        {
            WindowInteropHelper helper = new WindowInteropHelper(this.View);
            int style = GetWindowLong(helper.Handle, GWL_STYLE);
            SetWindowLong(helper.Handle, GWL_STYLE, style & ~WS_MINIMIZEBOX);
        }
    }
}
