﻿using Syncfusion.Maui.DataSource;
using Syncfusion.Maui.DataSource.Extensions;

//using Syncfusion.Maui.Data;
using System.Collections.Generic;

namespace ListViewMaui
{
    public class CustomGroupComparer : IComparer<GroupResult>
    {
        public int Compare(GroupResult x, GroupResult y)
        {
            if (x.Count > y.Count)
            {
                //GroupResult y is stacked into top of the group i.e., Ascending.
                //GroupResult x is stacked at the bottom of the group i.e., Descending.
                return 1;
            }
            else if (x.Count < y.Count)
            {
                //GroupResult x is stacked into top of the group i.e., Ascending.
                //GroupResult y is stacked at the bottom of the group i.e., Descending.
                return -1;
            }

            return 0;
        }
    }
    public class ShortDateGroupComparer : IComparer<GroupResult>
    {
        public ShortDateGroupComparer()
        {
            this.SortDirection = ListSortDirection.Ascending;
        }

        public ListSortDirection SortDirection
        {
            get;
            set;
        }

        public int Compare(GroupResult x, GroupResult y)
        {
            try
            {
                DateTime xvalue = Convert.ToDateTime(x.Key);
                DateTime yvalue = Convert.ToDateTime(y.Key);
                // Group results are compared and return the SortDirection
                if (xvalue.CompareTo(yvalue) > 0)
                    return SortDirection == ListSortDirection.Ascending ? 1 : -1;
                else if (xvalue.CompareTo(yvalue) == -1)
                    return SortDirection == ListSortDirection.Ascending ? -1 : 1;
                else
                    return 0;
            }
            catch (Exception ex)
            {
                return 0;
            }
        }
    }
}
