﻿using CommunityToolkit.Mvvm.ComponentModel;
using CommunityToolkit.Mvvm.Input;
using System.Collections.ObjectModel;

namespace ListViewMaui
{
    public partial class ListViewSortingViewModel
    {
        #region Fields

        private ObservableCollection<ListViewContactsInfo> contactsInfo;

        #endregion

        #region Constructor

        public ListViewSortingViewModel()
        {
            GenerateSource(100);
        }

        #endregion

        #region Properties

        public ObservableCollection<ListViewContactsInfo> ContactsInfo
        {
            get { return contactsInfo; }
            set { this.contactsInfo = value; }
        }

        #endregion

        #region ItemSource

        public void GenerateSource(int count)
        {
            ListViewContactsInfoRepository contactRepository = new ListViewContactsInfoRepository();
            contactsInfo = contactRepository.GetContactDetails(count);
        }

        #endregion

        #region ItemTappedCommand
        [RelayCommand]
        private async void OnItemListTapped(Syncfusion.Maui.ListView.ItemTappedEventArgs item)
        {
            Console.WriteLine("ListTapped");
            var info = (ListViewContactsInfo)item.DataItem;
            info.Selected = !info.Selected;
        }

        #endregion
    }
}
