﻿using Microsoft.Maui.Controls;
using System;
using System.ComponentModel;

namespace ListViewMaui
{
    public class ListViewContactsInfo : INotifyPropertyChanged
    {
        #region Fields

        private string contactName;
        private string contactNo;
        private ImageSource image;
        private string contactType;
        private DateTime from;
        private double height =70;
        private bool selected = false;
        #endregion

        #region Constructor

        public ListViewContactsInfo()
        {

        }

        #endregion

        #region Public Properties

        public string ContactName
        {
            get { return this.contactName; }
            set
            {
                this.contactName = value;
                RaisePropertyChanged("ContactName");
            }
        }

        public double Height
        {
            get { return this.height; }
            set
            {
                this.height = value;
                RaisePropertyChanged("ContactName");
            }
        }

        public bool Selected
        {
            get=> this.selected;
            set
            {
                this.selected = value;
                RaisePropertyChanged("Selected");
            }
        }

        public string ContactNumber
        {
            get { return contactNo; }
            set
            {
                this.contactNo = value;
                RaisePropertyChanged("ContactNumber");
            }
        }

        public string ContactType
        {
            get { return contactType; }
            set
            {
                this.contactType = value;
                RaisePropertyChanged("ContactType");
            }
        }
        public string Day => From.Date.ToShortDateString();

        public DateTime From {
            get { return from; }
            set
            {
                this.from = value;
                RaisePropertyChanged(nameof(From));
            }
        }

        public ImageSource ContactImage
        {
            get { return this.image; }
            set
            {
                this.image = value;
                this.RaisePropertyChanged("ContactImage");
            }
        }

        #endregion

        #region INotifyPropertyChanged implementation

        public event PropertyChangedEventHandler PropertyChanged;

        private void RaisePropertyChanged(String name)
        {
            if (PropertyChanged != null)
                this.PropertyChanged(this, new PropertyChangedEventArgs(name));
        }

        #endregion
    }
}
