﻿using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Diagnostics;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using MauiApp4.Classes;
using Newtonsoft.Json;

namespace MauiApp4.ViewModels
{
    public class MainPageViewModel
    {
        public ObservableRangeCollection<KridSiteProjectApplications> Apps { get; private set; }
        public ObservableRangeCollection<KridApp> Items { get; set; }

        public IEnumerable<ProgramEntity> Programs { get; set; }

        public MainPageViewModel() 
        {
            Items =  new ObservableRangeCollection<KridApp>();
            Debug.WriteLine("x");

        }

        public async Task getItems()
        {

            var programs = "";

            programs = await LoadMauiAsset("json1.json");
            Programs = JsonConvert.DeserializeObject<IEnumerable<ProgramEntity>>(programs);
            Apps = await getData();
            doit();
        }

        void doit()
        {

            Items.Clear();
            var env = new List<MobileUserEntity>();
            env.Add(new MobileUserEntity()
            {
                Site = "QA",
                SiteURL = "https://mobile.key360.co.za/",
                UserName = "cobus.pretorius@ssgconsulting.co.za",
                SiteUserId = 141,
                SiteVersion = 1,
                SiteId = 1

            });
            //if (ClientHelper.MobileSites != null && ClientHelper.MobileSites.Any())
            //    foreach (var user in ClientHelper.Users)
            //    {
            //        if (user != null && user.MobileUser != null)
            //        {
            //            var result =
            //                ClientHelper.MobileSites.SingleOrDefault(w => w.SiteId == user.MobileUser.SiteId);
            //            if (result != null)
            //                env.Add(result);
            //        }
            //    }

            foreach (var mobileSite in env)
            {

                if (Apps.Any(f => f.Id == mobileSite.SiteId))
                {
                    var siteApps = Apps.FirstOrDefault(f => f.Id == mobileSite.SiteId);
                    if (siteApps == null) continue;
                    try
                    {
                        foreach (var program in Programs
                            .OrderBy(o => o.Name))
                        {
                            foreach (var project in program.Projects.OrderBy(o => o.Name))
                            {
                                var projectApps = new List<KridSiteApplicationMRU>();
                                if (siteApps.ProjectApplications.Any(w => w.Id == project.Id))
                                {
                                    var projectApp = siteApps.ProjectApplications.FirstOrDefault(w => w.Id == project.Id);
                                    foreach (var application in projectApp.Applications.OrderBy(a => a.AppName))
                                    {
                                        var mruKey = "mru_" + application.GroupCode + "_" + application.EntityCode;
                                        Tuple<DateTime?, int> myLastCount = new Tuple<DateTime?, int>(null, 0);
                                        projectApps.Add(new KridSiteApplicationMRU(new KridSiteApplication
                                        {
                                            AppName = application.AppName,
                                            AppImage = application.AppImage,
                                            AppImageIcon = application.AppImageIcon,
                                            EntityCode = application.EntityCode,
                                            GroupCode = application.GroupCode,
                                            Projects = new List<int> { project.Id }
                                        }, myLastCount.Item1, myLastCount.Item2));
                                    }

                                }
                                var app = new KridApp
                                {
                                    Id = mobileSite.SiteId,
                                    SiteName = "1" + mobileSite.Site,
                                    ProgrammeName = "2" + program.Name,
                                    ProjectName = "3" + project.Name,
                                    ProjectId = project.Id,
                                    Apps = new ObservableCollection<KridSiteApplicationMRU>(projectApps)
                                };
                                Items.Add(app);
                            }
                        }
                    }
                    finally { }
                }
                continue;

            }

        }

        async Task<ObservableRangeCollection<KridSiteProjectApplications>> getData()
        {
            try
            {
                var content = "";
                content = await LoadMauiAsset("foo.json");
                return JsonConvert.DeserializeObject<ObservableRangeCollection<KridSiteProjectApplications>>(content);

            }
            catch
            {
                return null;
            }

        }

        async Task<string> LoadMauiAsset(string fileName)
        {
            try
            {
                using var stream = await FileSystem.OpenAppPackageFileAsync(fileName);
                using var reader = new StreamReader(stream);

                return reader.ReadToEnd();
            }
            catch (Exception ex)
            {
                return "";
            }

        }
    }
}
