﻿using System;
using System.Collections.Generic;
using System.Globalization;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace MauiApp4.Helpers
{
    public class AppGroupHeaderConvertor : IValueConverter
    {
        #region Public Fields

        public static AppGroupHeaderConvertor Instance = new AppGroupHeaderConvertor();

        #endregion Public Fields

        #region Public Methods

        public object Convert(object value, Type targetType, object parameter, CultureInfo culture)
        {
            var level = value.ToString()[0].ToString();
            if (targetType.Name == "Color")
            {
                if (level == "1")
                    return Colors.DarkGray;
                if (level == "2")
                    return Colors.Gray;
                return Colors.Orange;
            }
            else
            {
                if (level == "1")
                    return new Thickness(0, 20, 10, 20);
                if (level == "2")
                    return new Thickness(int.Parse(level) * 5, 5, 10, 5);
                return new Thickness(int.Parse(level) * 5, 5, 10, 5);
                // else
                //    return new Thickness((int)value * 15, 5, 5, 0);
            }
        }

        public object ConvertBack(object value, Type targetType, object parameter, CultureInfo culture)
        {
            throw new NotImplementedException();
        }

        #endregion Public Methods
    }

    public class AppGroupHeaderSourceConvertor : IValueConverter
    {
        #region Public Fields

        public static AppGroupHeaderSourceConvertor Instance = new AppGroupHeaderSourceConvertor();

        #endregion Public Fields

        #region Public Methods

        public object Convert(object value, Type targetType, object parameter, CultureInfo culture)
        {
            var level = value.ToString()[0].ToString();
            switch (level)
            {
                case "1":
                    return "yellow.png";

                case "2":
                    return "orange.png";
            }

            return "green.png";
        }

        public object ConvertBack(object value, Type targetType, object parameter, CultureInfo culture)
        {
            throw new NotImplementedException();
        }

        #endregion Public Methods
    }

    public class AppGroupHeaderTextConvertor : IValueConverter
    {
        #region Public Fields

        public static AppGroupHeaderTextConvertor Instance = new AppGroupHeaderTextConvertor();

        #endregion Public Fields

        #region Public Methods

        public object Convert(object value, Type targetType, object parameter, CultureInfo culture)
        {
            return value.ToString().Substring(1);
        }

        public object ConvertBack(object value, Type targetType, object parameter, CultureInfo culture)
        {
            throw new NotImplementedException();
        }

        #endregion Public Methods
    }

    public class AppGroupHeaderTextExpanderConvertor : IValueConverter
    {
        #region Public Fields

        public static AppGroupHeaderTextExpanderConvertor Instance = new AppGroupHeaderTextExpanderConvertor();

        #endregion Public Fields

        #region Public Methods

        public object Convert(object value, Type targetType, object parameter, CultureInfo culture)
        {
            if (value.ToString().Substring(0, 1) == "1")
                return string.Empty;
            else
                return "└ ";
        }

        public object ConvertBack(object value, Type targetType, object parameter, CultureInfo culture)
        {
            throw new NotImplementedException();
        }

        #endregion Public Methods
    }
}
