﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace MauiApp4.Classes
{
    public class KridSiteApplication
    {
        public string GroupCode { get; set; }
        public string EntityCode { get; set; }
        public string AppName { get; set; }
        public string AppImage { get; set; }
        public byte[] AppImageIcon { get; set; }
        public List<int> Projects { get; set; }
        public string KnowledgeArea { get; set; }
        public int KnowledgeAreaSequence { get; set; }
    }

    public class KridSiteApplicationMRU : KridSiteApplication
    {
        public KridSiteApplicationMRU(KridSiteApplication gridSiteApplication, DateTime? lastAccess, int accesCount)
        {
            if (gridSiteApplication == null)
                throw new NotSupportedException();
            GroupCode = gridSiteApplication.GroupCode;
            EntityCode = gridSiteApplication.EntityCode;
            AppName = gridSiteApplication.AppName;
            AppImageIcon = gridSiteApplication.AppImageIcon;
            KnowledgeArea = gridSiteApplication.KnowledgeArea;
            KnowledgeAreaSequence = gridSiteApplication.KnowledgeAreaSequence;
            Projects = gridSiteApplication.Projects;
            LastAccess = lastAccess;
            AccessCount = accesCount;
            IsEnabled = true;
        }
        public DateTime? LastAccess { get; set; }
        public int AccessCount { get; set; }
        public bool IsEnabled { get; set; }
    }
}
