using System.Collections;
using System.Diagnostics;
using System.Text.Json;
using Microsoft.AspNetCore.Mvc;
using Syncfusion.EJ2.Base;

namespace CoreGridApp.Controllers
{
  public class HomeController : Controller
  {
     public static List<Orders> order = new List<Orders>();
        public IActionResult Index()
        {
            if (order.Count == 0)
                BindDataSource();
            ViewBag.data = order;
            return View();
        }
        public IActionResult UrlDatasource([FromBody]TestDm dm)
        {
            IEnumerable DataSource = order;
            DataOperations operation = new DataOperations();
            if (dm.Search != null && dm.Search.Count > 0)
            {
                DataSource = operation.PerformSearching(DataSource, dm.Search);  //Search
            }
            if (dm.Sorted != null && dm.Sorted.Count > 0) //Sorting
            {
                DataSource = operation.PerformSorting(DataSource, dm.Sorted);
            }
            if (dm.Where != null && dm.Where.Count > 0) //Filtering
            {
                DataSource = operation.PerformFiltering(DataSource, dm.Where, dm.Where[0].Operator);
            }
            int count = DataSource.Cast<Orders>().Count();
            if (dm.Skip != 0)
            {
                DataSource = operation.PerformSkip(DataSource, dm.Skip);         //Paging
            }
            if (dm.Take != 0)
            {
                DataSource = operation.PerformTake(DataSource, dm.Take);
            }
            return dm.RequiresCounts ? Json(new { result = DataSource, count = count }) : Json(DataSource);
        }
        public void move(ResponseData data)
        {
            // insert the passed data in DestGrid  dataSource.
        }

        public class TestDm : DataManagerRequest
        {
            public int flag { get; set; }
            public string ej2grid { get; set; }
        }

        public class ResponseData
        {
            public int oldIndex { get; set; }
            public object data { get; set; }
            public int newIndex { get; set; }
        }
        public IActionResult BatchUpdate([FromBody]CRUDModel batchmodel)
        {
            if (batchmodel.Changed != null)
            {
                for (var i = 0; i < batchmodel.Changed.Count(); i++)
                {
                    var ord = batchmodel.Changed[i];
                    Orders val = order.Where(or => or.OrderID == ord.OrderID).FirstOrDefault();
                    val.OrderID = ord.OrderID;
                    val.EmployeeID = ord.EmployeeID;
                    val.CustomerID = ord.CustomerID;
                    val.ShipCity = ord.ShipCity;
                }
            }

            if (batchmodel.Deleted != null)
            {
                for (var i = 0; i < batchmodel.Deleted.Count(); i++)
                {
                    order.Remove(order.Where(or => or.OrderID == batchmodel.Deleted[i].OrderID).FirstOrDefault());
                }
            }

            if (batchmodel.Added != null)
            {
                for (var i = 0; i < batchmodel.Added.Count(); i++)
                {
                    order.Insert(0, batchmodel.Added[i]);
                }
            }
            var data = order.ToList();
            return Json(data);

        }
        public class CRUDModel
        {
            public List<Orders> Added { get; set; }
            public List<Orders> Changed { get; set; }
            public List<Orders> Deleted { get; set; }
            public Orders Value { get; set; }
            public int key { get; set; }
            public string action { get; set; }

            public IDictionary<string, object> @params { get; set; }
        }
        public void BindDataSource()
        {
            order.Add(new Orders(10248, 1, "VINET", "Aeróbics"));
            order.Add(new Orders(10249, 2, "ALFKI", "Münster"));
            order.Add(new Orders(10250, 3, "TOMSP", "Aerógrafía"));
            order.Add(new Orders(10251, 4, "HANAR", "Aeromodelaje"));
            order.Add(new Orders(10252, 5, "HILAA", "Resende"));
            order.Add(new Orders(10253, 2, "CENTC", "Graz"));
            order.Add(new Orders(10254, 3, "RICSU", "México"));
            order.Add(new Orders(10255, 5, "ERNSH", "Oulu"));
            order.Add(new Orders(10256, 6, "RATTC", "Lander"));
            order.Add(new Orders(10257, 1, "BLONP", "Bergamo"));
            order.Add(new Orders(10258, 7, "QUICK", "Madrid"));
            order.Add(new Orders(10259, 3, "LEHMS", "Frankfurt"));
            order.Add(new Orders(10260, 1, "ROMEY", "Reggio"));
            order.Add(new Orders(10261, 2, "REGGC", "Albuquerque"));
            order.Add(new Orders(10262, 5, "BSBEV", "Munster"));
        }
        public class Orders
        {
            public Orders()
            {

            }
            public Orders(int OrderID, int EmployeeID, string CustomerID, string ShipCity)
            {
                this.OrderID = OrderID;
                this.EmployeeID = EmployeeID;
                this.CustomerID = CustomerID;
                this.ShipCity = ShipCity;
            }
            public int OrderID { get; set; }
            public int EmployeeID { get; set; }
            public string CustomerID { get; set; }
            public string ShipCity { get; set; }
        }
    }
}
