﻿using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;
using Syncfusion.UI.Xaml.TreeGrid;
using Syncfusion.UI.Xaml.Grid;

namespace SfTreeGrid_NET8 {
    /// <summary>
    /// Interaction logic for MainWindow.xaml
    /// </summary>
    public partial class MainWindow : Window {
        SfTreeGrid treeGrid;
        public MainWindow() {
            InitializeComponent();

            //            < Syncfusion:SfTreeGrid x:Name = "treeGrid" ChildPropertyName = "ReportsTo"
            //                       ItemsSource = "{Binding Employees}"
            //                       AutoGenerateColumns = "True"
            //                       ParentPropertyName = "ID"
            //                       SelfRelationRootValue = "-1" >


            //</ Syncfusion:SfTreeGrid >

            treeGrid = new SfTreeGrid();
            treeGrid.ParentPropertyName = "ID";
            treeGrid.SelfRelationRootValue = "-1";

            treeGrid.SetValue(Grid.RowProperty, 0);
            treeGrid.AllowEditing = false;
            treeGrid.AllowFiltering = true;
            treeGrid.AllowSorting = true;
            treeGrid.AllowResizingColumns = true;
            treeGrid.AllowResizingHiddenColumns = true;
            treeGrid.AllowDraggingColumns = true;
            treeGrid.AutoGenerateColumns = true;
            treeGrid.ColumnSizer = TreeColumnSizer.Auto;
            treeGrid.SelectionMode = GridSelectionMode.Single;
            layoutGrid.Children.Add(treeGrid);
            treeGrid.AutoGeneratingColumn += treeGridAutoGeneratingColumns;

            treeGrid.ItemsSource = new EmployeeViewModel().Employees;


        }

        private void Button_Click(object sender, RoutedEventArgs e) {
            UpdateColumnWidth(this.treeGrid, 1, 300);
            UpdateColumnWidth(treeGrid, 2, 300);

        }
        private void treeGridAutoGeneratingColumns(object sender, TreeGridAutoGeneratingColumnEventArgs e) {
            
            if (e.Column.MappingName.Equals("LastName")) {

                // NOTE: in the real app, the initial column widths are set in a function that restores the user preferences
                // but this quick and dirty shows the issue. The real app uses  treeGrid.ColumnSizer = TreeColumnSizer.None;

                // IF THIS IS 0, COLUMN DOES NOT RESIZE, SETTING TO 0.01 IT DOES
                e.Column.Width = 0;
            }


        }


        private static void UpdateColumnWidth(SfTreeGrid grid, int colIndex, double width) {

            var col = grid.Columns[colIndex];

            col.Width = width;

        }

        private void Button_Click_1(object sender, RoutedEventArgs e) {
            UpdateColumnWidth(this.treeGrid, 1, 0);
            UpdateColumnWidth(treeGrid,2,0);
        }
    }

}
