﻿using System;
using System.IO;
using Syncfusion.DocIO.DLS;
using Syncfusion.DocToPDFConverter;

namespace TableOfContents
{
    internal class Program
    {
        static void Main(string[] args)
        {
            using (var docStream = new FileStream($"./../../test.docx", FileMode.Open))
            {
                using (var wordDoc = new WordDocument(docStream))
                {

                    var wordDocumentConverter = new DocToPDFConverter();

                    using (var pdfDocument = wordDocumentConverter.ConvertToPDF(wordDoc))
                    {
                        pdfDocument.Save("./../../result.pdf");

                        pdfDocument.Close();
                    }
                }
            }
        }
    }
}
